/*
 * Copyright (C) 2014-2016 Altera Corporation <www.altera.com>
 *
 * SPDX-License-Identifier:	GPL-2.0
 */

#ifndef	_ARRIA10_RESET_MANAGER_H_
#define	_ARRIA10_RESET_MANAGER_H_

#define ARRIA10_RSTMGR_STATUS		0x0
#define ARRIA10_RSTMGR_RAMSTAT		0x4
#define ARRIA10_RSTMGR_MISCSTAT		0x8
#define ARRIA10_RSTMGR_CTRL		0xc
#define ARRIA10_RSTMGR_HDSKEN		0x10
#define ARRIA10_RSTMGR_HDSKREQ		0x14
#define ARRIA10_RSTMGR_HDSKACK		0x18
#define ARRIA10_RSTMGR_COUNTS		0x1c
#define ARRIA10_RSTMGR_MPUMODRST	0x20
#define ARRIA10_RSTMGR_PER0MODRST	0x24
#define ARRIA10_RSTMGR_PER1MODRST	0x28
#define ARRIA10_RSTMGR_BRGMODRST	0x2c
#define ARRIA10_RSTMGR_SYSMODRST	0x30
#define ARRIA10_RSTMGR_COLDMODRST	0x34
#define ARRIA10_RSTMGR_NRSTMODRST	0x38
#define ARRIA10_RSTMGR_DBGMODRST	0x3c
#define ARRIA10_RSTMGR_MPUWARMMASK	0x40
#define ARRIA10_RSTMGR_PER0WARMMASK	0x44
#define ARRIA10_RSTMGR_PER1WARMMASK	0x48
#define ARRIA10_RSTMGR_BRGWARMMASK	0x4c
#define ARRIA10_RSTMGR_SYSWARMMASK	0x50
#define ARRIA10_RSTMGR_NRSTWARMMASK	0x54
#define ARRIA10_RSTMGR_L3WARMMASK	0x58
#define ARRIA10_RSTMGR_TSTSTA		0x5c
#define ARRIA10_RSTMGR_TSTSCRATCH	0x60
#define ARRIA10_RSTMGR_HDSKTIMEOUT	0x64
#define ARRIA10_RSTMGR_HMCINTR		0x68
#define ARRIA10_RSTMGR_HMCINTREN	0x6c
#define ARRIA10_RSTMGR_HMCINTRENS	0x70
#define ARRIA10_RSTMGR_HMCINTRENR	0x74
#define ARRIA10_RSTMGR_HMCGPOUT		0x78
#define ARRIA10_RSTMGR_HMCGPIN		0x7c

/* Built-in HPS POR voltage detector triggered a cold reset. */
#define ARRIA10_RSTMGR_STAT_PORHPSVOLTRST	BIT(0)
/* Built-in FPGA POR voltage detector triggered a cold reset. */
#define ARRIA10_RSTMGR_STAT_PORFPGAVOLTRST	BIT(1)
/* nPOR pin triggered a col reset (por_pin_req = 1) */
#define ARRIA10_RSTMGR_STAT_NPORPINRST		BIT(2)
/* FPGA core triggered a cold reset (f2s_cold_rst_req = 1) */
#define ARRIA10_RSTMGR_STAT_FPGACOLDRST		BIT(3)
/* FPGA entered CONFIG_IO mode and triggered a cold reset */
#define ARRIA10_RSTMGR_STAT_CONFIGIOCOLDRST	BIT(4)
/* Software wrote CTRL.SWCOLDRSTREQ to 1 and triggered a cold reset */
#define ARRIA10_RSTMGR_STAT_SWCOLDRST		BIT(5)
/* nRST pin triggered a hardware sequenced warm reset */
#define ARRIA10_RSTMGR_STAT_NRSTPINRST		BIT(8)
/* FPGA core triggered a hardware sequenced warm reset */
#define ARRIA10_RSTMGR_STAT_FPGAWARMRST		BIT(9)
/* Software wrote CTRL.SWWARMRSTREQ to 1 and triggered a hardware sequenced warm reset. */
#define ARRIA10_RSTMGR_STAT_SWWARMRST		BIT(10)
/* MPU watchdog 0 triggered a hardware sequenced warm reset */
#define ARRIA10_RSTMGR_STAT_MPUWD0WARMRST	BIT(11)
/* MPU watchdog 1 triggered a hardware sequenced warm reset */
#define ARRIA10_RSTMGR_STAT_MPUWD1WARMRST	BIT(12)
/* L4 watchdog 0 triggered a hardware sequenced warm reset */
#define ARRIA10_RSTMGR_STAT_L4WD0WARMRST	BIT(13)
/* L4 watchdog 1 triggered a hardware sequenced warm reset */
#define ARRIA10_RSTMGR_STAT_L4WD1WARMRST	BIT(14)
/* FPGA triggered debug reset */
#define ARRIA10_RSTMGR_STAT_FPGADBGRST		BIT(16)
/* DAP triggered debug reset */
#define ARRIA10_RSTMGR_STAT_CDBGRST		BIT(17)

#define ARRIA10_RSTMGR_CTL_SWWARMRSTREQ		BIT(1)
#define ARRIA10_RSTMGR_PER0MODRST_EMAC0		BIT(0)
#define ARRIA10_RSTMGR_PER0MODRST_EMAC1		BIT(1)
#define ARRIA10_RSTMGR_PER0MODRST_EMAC2		BIT(2)
#define ARRIA10_RSTMGR_PER0MODRST_USB0		BIT(3)
#define ARRIA10_RSTMGR_PER0MODRST_USB1		BIT(4)
#define ARRIA10_RSTMGR_PER0MODRST_NAND		BIT(5)
#define ARRIA10_RSTMGR_PER0MODRST_QSPI		BIT(6)
#define ARRIA10_RSTMGR_PER0MODRST_SDMMC		BIT(7)
#define ARRIA10_RSTMGR_PER0MODRST_EMAC0OCP	BIT(8)
#define ARRIA10_RSTMGR_PER0MODRST_EMAC1OCP	BIT(9)
#define ARRIA10_RSTMGR_PER0MODRST_EMAC2OCP	BIT(10)
#define ARRIA10_RSTMGR_PER0MODRST_USB0OCP	BIT(11)
#define ARRIA10_RSTMGR_PER0MODRST_USB1OCP	BIT(12)
#define ARRIA10_RSTMGR_PER0MODRST_NANDOCP	BIT(13)
#define ARRIA10_RSTMGR_PER0MODRST_QSPIOCP	BIT(14)
#define ARRIA10_RSTMGR_PER0MODRST_SDMMCOCP	BIT(15)
#define ARRIA10_RSTMGR_PER0MODRST_DMA		BIT(16)
#define ARRIA10_RSTMGR_PER0MODRST_SPIM0		BIT(17)
#define ARRIA10_RSTMGR_PER0MODRST_SPIM1		BIT(18)
#define ARRIA10_RSTMGR_PER0MODRST_SPIS0		BIT(19)
#define ARRIA10_RSTMGR_PER0MODRST_SPIS1		BIT(20)
#define ARRIA10_RSTMGR_PER0MODRST_DMAOCP	BIT(21)
#define ARRIA10_RSTMGR_PER0MODRST_EMACPTP	BIT(22)
#define ARRIA10_RSTMGR_PER0MODRST_DMAIF0	BIT(24)
#define ARRIA10_RSTMGR_PER0MODRST_DMAIF1	BIT(25)
#define ARRIA10_RSTMGR_PER0MODRST_DMAIF2	BIT(26)
#define ARRIA10_RSTMGR_PER0MODRST_DMAIF3	BIT(27)
#define ARRIA10_RSTMGR_PER0MODRST_DMAIF4	BIT(28)
#define ARRIA10_RSTMGR_PER0MODRST_DMAIF5	BIT(29)
#define ARRIA10_RSTMGR_PER0MODRST_DMAIF6	BIT(30)
#define ARRIA10_RSTMGR_PER0MODRST_DMAIF7	BIT(31)

#define ARRIA10_RSTMGR_PER1MODRST_WATCHDOG0	BIT(0)
#define ARRIA10_RSTMGR_PER1MODRST_WATCHDOG1	BIT(1)
#define ARRIA10_RSTMGR_PER1MODRST_L4SYSTIMER0	BIT(2)
#define ARRIA10_RSTMGR_PER1MODRST_L4SYSTIMER1	BIT(3)
#define ARRIA10_RSTMGR_PER1MODRST_SPTIMER0	BIT(4)
#define ARRIA10_RSTMGR_PER1MODRST_SPTIMER1	BIT(5)
#define ARRIA10_RSTMGR_PER1MODRST_I2C0		BIT(8)
#define ARRIA10_RSTMGR_PER1MODRST_I2C1		BIT(9)
#define ARRIA10_RSTMGR_PER1MODRST_I2C2		BIT(10)
#define ARRIA10_RSTMGR_PER1MODRST_I2C3		BIT(11)
#define ARRIA10_RSTMGR_PER1MODRST_I2C4		BIT(12)
#define ARRIA10_RSTMGR_PER1MODRST_UART0		BIT(16)
#define ARRIA10_RSTMGR_PER1MODRST_UART1		BIT(17)
#define ARRIA10_RSTMGR_PER1MODRST_GPIO0		BIT(24)
#define ARRIA10_RSTMGR_PER1MODRST_GPIO1		BIT(25)
#define ARRIA10_RSTMGR_PER1MODRST_GPIO2		BIT(26)

#define ARRIA10_RSTMGR_BRGMODRST_HPS2FPGA	BIT(0)
#define ARRIA10_RSTMGR_BRGMODRST_LWHPS2FPGA	BIT(1)
#define ARRIA10_RSTMGR_BRGMODRST_FPGA2HPS	BIT(2)
#define ARRIA10_RSTMGR_BRGMODRST_F2SSDRAM0	BIT(3)
#define ARRIA10_RSTMGR_BRGMODRST_F2SSDRAM1	BIT(4)
#define ARRIA10_RSTMGR_BRGMODRST_F2SSDRAM2	BIT(5)
#define ARRIA10_RSTMGR_BRGMODRST_DDRSCH		BIT(6)

#define ARRIA10_RSTMGR_OCP_MASK (ARRIA10_RSTMGR_PER0MODRST_EMAC0OCP |	\
				 ARRIA10_RSTMGR_PER0MODRST_EMAC1OCP |	\
				 ARRIA10_RSTMGR_PER0MODRST_EMAC2OCP |	\
				 ARRIA10_RSTMGR_PER0MODRST_NANDOCP  |	\
				 ARRIA10_RSTMGR_PER0MODRST_QSPIOCP  |	\
				 ARRIA10_RSTMGR_PER0MODRST_SDMMCOCP)

void arria10_reset_peripherals(void);
void arria10_reset_deassert_dedicated_peripherals(void);
void arria10_reset_deassert_shared_peripherals(void);
void arria10_reset_deassert_shared_peripherals_q1(uint32_t *mask0, uint32_t *mask1);
void arria10_reset_deassert_shared_peripherals_q2(uint32_t *mask0, uint32_t *mask1);
void arria10_reset_deassert_shared_peripherals_q3(uint32_t *mask0, uint32_t *mask1);
void arria10_reset_deassert_shared_peripherals_q4(uint32_t *mask0, uint32_t *mask1);
void arria10_reset_deassert_fpga_peripherals(void);

#endif

