/*
 * Copyright 2024 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * Code generated with DDR Tool v3.4.0_8.3-4e2b550a.
 * DDR PHY FW2022.01
 */

#include <linux/kernel.h>
#include <common.h>
#include <soc/imx9/ddr.h>

/* Initialize DDRC registers */
static struct dram_cfg_param ddr_ddrc_cfg[] = {
	{0x4e300110, 0x44100001},
	{0x4e300000, 0x8000ff},
	{0x4e300008, 0x0},
	{0x4e300080, 0x80000512},
	{0x4e300084, 0x0},
	{0x4e300114, 0x1002},
	{0x4e300260, 0x80},
	{0x4e300f04, 0x80},
	{0x4e300800, 0x43b30002},
	{0x4e300804, 0x1f1f1f1f},
	{0x4e301000, 0x0},
	{0x4e301240, 0x0},
	{0x4e301244, 0x0},
	{0x4e301248, 0x0},
	{0x4e30124c, 0x0},
	{0x4e301250, 0x0},
	{0x4e301254, 0x0},
	{0x4e301258, 0x0},
	{0x4e30125c, 0x0},
};

/* dram fsp cfg */
static struct dram_fsp_cfg ddr_dram_fsp_cfg[] = {
	{
		{
			{0x4e300100, 0x24AB321B},
			{0x4e300104, 0xF8EE001B},
			{0x4e300108, 0x2F2EE233},
			{0x4e30010C, 0x0005E18B},
			{0x4e300124, 0x1C760000},
			{0x4e300160, 0x00009102},
			{0x4e30016C, 0x35F00000},
			{0x4e300170, 0x8B0B0608},
			{0x4e300250, 0x00000028},
			{0x4e300254, 0x015B015B},
			{0x4e300258, 0x00000008},
			{0x4e30025C, 0x00000400},
			{0x4e300300, 0x224F2213},
			{0x4e300304, 0x015B2213},
			{0x4e300308, 0x0A3C0E3D},
		},
		{
			{0x01, 0xE4},
			{0x02, 0x36},
			{0x03, 0x32},
			{0x0b, 0x46},
			{0x0c, 0x11},
			{0x0e, 0x11},
			{0x16, 0x04},
		},
		0,
	},
	{
		{
			{0x4e300100, 0x12552100},
			{0x4e300104, 0xF877000E},
			{0x4e300108, 0x1816B4AA},
			{0x4e30010C, 0x005101E6},
			{0x4e300124, 0x0E3C0000},
			{0x4e300160, 0x00009101},
			{0x4e30016C, 0x30900000},
			{0x4e300170, 0x8A0A0508},
			{0x4e300250, 0x00000014},
			{0x4e300254, 0x00AA00AA},
			{0x4e300258, 0x00000008},
			{0x4e30025C, 0x00000400},
		},
		{
			{0x01, 0xB4},
			{0x02, 0x1B},
			{0x03, 0x32},
			{0x0b, 0x46},
			{0x0c, 0x11},
			{0x0e, 0x11},
			{0x16, 0x04},
		},
		0,
	},
	{
		{
			{0x4e300100, 0x00061000},
			{0x4e300104, 0xF855000A},
			{0x4e300108, 0x6E62FA48},
			{0x4e30010C, 0x0031010D},
			{0x4e300124, 0x04C50000},
			{0x4e300160, 0x00009100},
			{0x4e30016C, 0x30000000},
			{0x4e300170, 0x89090408},
			{0x4e300250, 0x00000007},
			{0x4e300254, 0x00340034},
			{0x4e300258, 0x00000008},
			{0x4e30025C, 0x00000400},
		},
		{
			{0x01, 0x94},
			{0x02, 0x9},
			{0x03, 0x32},
			{0x0b, 0x46},
			{0x0c, 0x11},
			{0x0e, 0x11},
			{0x16, 0x04},
		},
		1,
	},
};

/* PHY Initialize Configuration */
static struct dram_cfg_param ddr_ddrphy_cfg[] = {
	{0x100a0, 0x4},
	{0x100a1, 0x5},
	{0x100a2, 0x6},
	{0x100a3, 0x7},
	{0x100a4, 0x0},
	{0x100a5, 0x1},
	{0x100a6, 0x2},
	{0x100a7, 0x3},
	{0x110a0, 0x3},
	{0x110a1, 0x2},
	{0x110a2, 0x0},
	{0x110a3, 0x1},
	{0x110a4, 0x7},
	{0x110a5, 0x6},
	{0x110a6, 0x4},
	{0x110a7, 0x5},
	{0x1005f, 0x5ff},
	{0x1015f, 0x5ff},
	{0x1105f, 0x5ff},
	{0x1115f, 0x5ff},
	{0x11005f, 0x5ff},
	{0x11015f, 0x5ff},
	{0x11105f, 0x5ff},
	{0x11115f, 0x5ff},
	{0x21005f, 0x5ff},
	{0x21015f, 0x5ff},
	{0x21105f, 0x5ff},
	{0x21115f, 0x5ff},
	{0x55, 0x1ff},
	{0x1055, 0x1ff},
	{0x2055, 0x1ff},
	{0x200c5, 0x19},
	{0x1200c5, 0xb},
	{0x2200c5, 0x7},
	{0x2002e, 0x2},
	{0x12002e, 0x2},
	{0x22002e, 0x2},
	{0x90204, 0x0},
	{0x190204, 0x0},
	{0x290204, 0x0},
	{0x20024, 0x1e3},
	{0x2003a, 0x2},
	{0x2007d, 0x212},
	{0x2007c, 0x61},
	{0x120024, 0x1e3},
	{0x2003a, 0x2},
	{0x12007d, 0x212},
	{0x12007c, 0x61},
	{0x220024, 0x1e3},
	{0x2003a, 0x2},
	{0x22007d, 0x212},
	{0x22007c, 0x61},
	{0x20056, 0x3},
	{0x120056, 0x3},
	{0x220056, 0x3},
	{0x1004d, 0x600},
	{0x1014d, 0x600},
	{0x1104d, 0x600},
	{0x1114d, 0x600},
	{0x11004d, 0x600},
	{0x11014d, 0x600},
	{0x11104d, 0x600},
	{0x11114d, 0x600},
	{0x21004d, 0x600},
	{0x21014d, 0x600},
	{0x21104d, 0x600},
	{0x21114d, 0x600},
	{0x10049, 0xe00},
	{0x10149, 0xe00},
	{0x11049, 0xe00},
	{0x11149, 0xe00},
	{0x110049, 0xe00},
	{0x110149, 0xe00},
	{0x111049, 0xe00},
	{0x111149, 0xe00},
	{0x210049, 0xe00},
	{0x210149, 0xe00},
	{0x211049, 0xe00},
	{0x211149, 0xe00},
	{0x43, 0x60},
	{0x1043, 0x60},
	{0x2043, 0x60},
	{0x20018, 0x1},
	{0x20075, 0x4},
	{0x20050, 0x0},
	{0x2009b, 0x2},
	{0x20008, 0x3a5},
	{0x120008, 0x1d3},
	{0x220008, 0x9c},
	{0x20088, 0x9},
	{0x200b2, 0x10c},
	{0x10043, 0x5a1},
	{0x10143, 0x5a1},
	{0x11043, 0x5a1},
	{0x11143, 0x5a1},
	{0x1200b2, 0x10c},
	{0x110043, 0x5a1},
	{0x110143, 0x5a1},
	{0x111043, 0x5a1},
	{0x111143, 0x5a1},
	{0x2200b2, 0x10c},
	{0x210043, 0x5a1},
	{0x210143, 0x5a1},
	{0x211043, 0x5a1},
	{0x211143, 0x5a1},
	{0x200fa, 0x2},
	{0x1200fa, 0x2},
	{0x2200fa, 0x2},
	{0x20019, 0x1},
	{0x120019, 0x1},
	{0x220019, 0x1},
	{0x200f0, 0x600},
	{0x200f1, 0x0},
	{0x200f2, 0x4444},
	{0x200f3, 0x8888},
	{0x200f4, 0x5655},
	{0x200f5, 0x0},
	{0x200f6, 0x0},
	{0x200f7, 0xf000},
	{0x1004a, 0x500},
	{0x1104a, 0x500},
	{0x20025, 0x0},
	{0x2002d, 0x0},
	{0x12002d, 0x0},
	{0x22002d, 0x0},
	{0x2002c, 0x0},
	{0x20021, 0x0},
	{0x200c7, 0x21},
	{0x1200c7, 0x21},
	{0x200ca, 0x24},
	{0x1200ca, 0x24},
};

/* ddr phy trained csr */
static struct dram_cfg_param ddr_ddrphy_trained_csr[] = {
	{0x1005f, 0x0},
	{0x1015f, 0x0},
	{0x1105f, 0x0},
	{0x1115f, 0x0},
	{0x11005f, 0x0},
	{0x11015f, 0x0},
	{0x11105f, 0x0},
	{0x11115f, 0x0},
	{0x21005f, 0x0},
	{0x21015f, 0x0},
	{0x21105f, 0x0},
	{0x21115f, 0x0},
	{0x55, 0x0},
	{0x1055, 0x0},
	{0x2055, 0x0},
	{0x200c5, 0x0},
	{0x1200c5, 0x0},
	{0x2200c5, 0x0},
	{0x2002e, 0x0},
	{0x12002e, 0x0},
	{0x22002e, 0x0},
	{0x90204, 0x0},
	{0x190204, 0x0},
	{0x290204, 0x0},
	{0x20024, 0x0},
	{0x2003a, 0x0},
	{0x2007d, 0x0},
	{0x2007c, 0x0},
	{0x120024, 0x0},
	{0x12007d, 0x0},
	{0x12007c, 0x0},
	{0x220024, 0x0},
	{0x22007d, 0x0},
	{0x22007c, 0x0},
	{0x20056, 0x0},
	{0x120056, 0x0},
	{0x220056, 0x0},
	{0x1004d, 0x0},
	{0x1014d, 0x0},
	{0x1104d, 0x0},
	{0x1114d, 0x0},
	{0x11004d, 0x0},
	{0x11014d, 0x0},
	{0x11104d, 0x0},
	{0x11114d, 0x0},
	{0x21004d, 0x0},
	{0x21014d, 0x0},
	{0x21104d, 0x0},
	{0x21114d, 0x0},
	{0x10049, 0x0},
	{0x10149, 0x0},
	{0x11049, 0x0},
	{0x11149, 0x0},
	{0x110049, 0x0},
	{0x110149, 0x0},
	{0x111049, 0x0},
	{0x111149, 0x0},
	{0x210049, 0x0},
	{0x210149, 0x0},
	{0x211049, 0x0},
	{0x211149, 0x0},
	{0x43, 0x0},
	{0x1043, 0x0},
	{0x2043, 0x0},
	{0x20018, 0x0},
	{0x20075, 0x0},
	{0x20050, 0x0},
	{0x2009b, 0x0},
	{0x20008, 0x0},
	{0x120008, 0x0},
	{0x220008, 0x0},
	{0x20088, 0x0},
	{0x200b2, 0x0},
	{0x10043, 0x0},
	{0x10143, 0x0},
	{0x11043, 0x0},
	{0x11143, 0x0},
	{0x1200b2, 0x0},
	{0x110043, 0x0},
	{0x110143, 0x0},
	{0x111043, 0x0},
	{0x111143, 0x0},
	{0x2200b2, 0x0},
	{0x210043, 0x0},
	{0x210143, 0x0},
	{0x211043, 0x0},
	{0x211143, 0x0},
	{0x200fa, 0x0},
	{0x1200fa, 0x0},
	{0x2200fa, 0x0},
	{0x20019, 0x0},
	{0x120019, 0x0},
	{0x220019, 0x0},
	{0x200f0, 0x0},
	{0x200f1, 0x0},
	{0x200f2, 0x0},
	{0x200f3, 0x0},
	{0x200f4, 0x0},
	{0x200f5, 0x0},
	{0x200f6, 0x0},
	{0x200f7, 0x0},
	{0x1004a, 0x0},
	{0x1104a, 0x0},
	{0x20025, 0x0},
	{0x2002d, 0x0},
	{0x12002d, 0x0},
	{0x22002d, 0x0},
	{0x2002c, 0x0},
	{0xd0000, 0x0},
	{0x90000, 0x0},
	{0x90001, 0x0},
	{0x90002, 0x0},
	{0x90003, 0x0},
	{0x90004, 0x0},
	{0x90005, 0x0},
	{0x90029, 0x0},
	{0x9002a, 0x0},
	{0x9002b, 0x0},
	{0x9002c, 0x0},
	{0x9002d, 0x0},
	{0x9002e, 0x0},
	{0x9002f, 0x0},
	{0x90030, 0x0},
	{0x90031, 0x0},
	{0x90032, 0x0},
	{0x90033, 0x0},
	{0x90034, 0x0},
	{0x90035, 0x0},
	{0x90036, 0x0},
	{0x90037, 0x0},
	{0x90038, 0x0},
	{0x90039, 0x0},
	{0x9003a, 0x0},
	{0x9003b, 0x0},
	{0x9003c, 0x0},
	{0x9003d, 0x0},
	{0x9003e, 0x0},
	{0x9003f, 0x0},
	{0x90040, 0x0},
	{0x90041, 0x0},
	{0x90042, 0x0},
	{0x90043, 0x0},
	{0x90044, 0x0},
	{0x90045, 0x0},
	{0x90046, 0x0},
	{0x90047, 0x0},
	{0x90048, 0x0},
	{0x90049, 0x0},
	{0x9004a, 0x0},
	{0x9004b, 0x0},
	{0x9004c, 0x0},
	{0x9004d, 0x0},
	{0x9004e, 0x0},
	{0x9004f, 0x0},
	{0x90050, 0x0},
	{0x90051, 0x0},
	{0x90052, 0x0},
	{0x90053, 0x0},
	{0x90054, 0x0},
	{0x90055, 0x0},
	{0x90056, 0x0},
	{0x90057, 0x0},
	{0x90058, 0x0},
	{0x90059, 0x0},
	{0x9005a, 0x0},
	{0x9005b, 0x0},
	{0x9005c, 0x0},
	{0x9005d, 0x0},
	{0x9005e, 0x0},
	{0x9005f, 0x0},
	{0x90060, 0x0},
	{0x90061, 0x0},
	{0x90062, 0x0},
	{0x90063, 0x0},
	{0x90064, 0x0},
	{0x90065, 0x0},
	{0x90066, 0x0},
	{0x90067, 0x0},
	{0x90068, 0x0},
	{0x90069, 0x0},
	{0x9006a, 0x0},
	{0x9006b, 0x0},
	{0x9006c, 0x0},
	{0x9006d, 0x0},
	{0x9006e, 0x0},
	{0x9006f, 0x0},
	{0x90070, 0x0},
	{0x90071, 0x0},
	{0x90072, 0x0},
	{0x90073, 0x0},
	{0x90074, 0x0},
	{0x90075, 0x0},
	{0x90076, 0x0},
	{0x90077, 0x0},
	{0x90078, 0x0},
	{0x90079, 0x0},
	{0x9007a, 0x0},
	{0x9007b, 0x0},
	{0x9007c, 0x0},
	{0x9007d, 0x0},
	{0x9007e, 0x0},
	{0x9007f, 0x0},
	{0x90080, 0x0},
	{0x90081, 0x0},
	{0x90082, 0x0},
	{0x90083, 0x0},
	{0x90084, 0x0},
	{0x90085, 0x0},
	{0x90086, 0x0},
	{0x90087, 0x0},
	{0x90088, 0x0},
	{0x90089, 0x0},
	{0x9008a, 0x0},
	{0x9008b, 0x0},
	{0x9008c, 0x0},
	{0x9008d, 0x0},
	{0x9008e, 0x0},
	{0x9008f, 0x0},
	{0x90090, 0x0},
	{0x90091, 0x0},
	{0x90092, 0x0},
	{0x90093, 0x0},
	{0x90094, 0x0},
	{0x90095, 0x0},
	{0x90096, 0x0},
	{0x90097, 0x0},
	{0x90098, 0x0},
	{0x90099, 0x0},
	{0x9009a, 0x0},
	{0x9009b, 0x0},
	{0x9009c, 0x0},
	{0x9009d, 0x0},
	{0x9009e, 0x0},
	{0x9009f, 0x0},
	{0x900a0, 0x0},
	{0x900a1, 0x0},
	{0x900a2, 0x0},
	{0x900a3, 0x0},
	{0x900a4, 0x0},
	{0x900a5, 0x0},
	{0x900a6, 0x0},
	{0x900a7, 0x0},
	{0x900a8, 0x0},
	{0x900a9, 0x0},
	{0x40000, 0x0},
	{0x40020, 0x0},
	{0x40040, 0x0},
	{0x40060, 0x0},
	{0x40001, 0x0},
	{0x40021, 0x0},
	{0x40041, 0x0},
	{0x40061, 0x0},
	{0x40002, 0x0},
	{0x40022, 0x0},
	{0x40042, 0x0},
	{0x40062, 0x0},
	{0x40003, 0x0},
	{0x40023, 0x0},
	{0x40043, 0x0},
	{0x40063, 0x0},
	{0x40004, 0x0},
	{0x40024, 0x0},
	{0x40044, 0x0},
	{0x40064, 0x0},
	{0x40005, 0x0},
	{0x40025, 0x0},
	{0x40045, 0x0},
	{0x40065, 0x0},
	{0x40006, 0x0},
	{0x40026, 0x0},
	{0x40046, 0x0},
	{0x40066, 0x0},
	{0x40007, 0x0},
	{0x40027, 0x0},
	{0x40047, 0x0},
	{0x40067, 0x0},
	{0x40008, 0x0},
	{0x40028, 0x0},
	{0x40048, 0x0},
	{0x40068, 0x0},
	{0x40009, 0x0},
	{0x40029, 0x0},
	{0x40049, 0x0},
	{0x40069, 0x0},
	{0x4000a, 0x0},
	{0x4002a, 0x0},
	{0x4004a, 0x0},
	{0x4006a, 0x0},
	{0x4000b, 0x0},
	{0x4002b, 0x0},
	{0x4004b, 0x0},
	{0x4006b, 0x0},
	{0x4000c, 0x0},
	{0x4002c, 0x0},
	{0x4004c, 0x0},
	{0x4006c, 0x0},
	{0x4000d, 0x0},
	{0x4002d, 0x0},
	{0x4004d, 0x0},
	{0x4006d, 0x0},
	{0x4000e, 0x0},
	{0x4002e, 0x0},
	{0x4004e, 0x0},
	{0x4006e, 0x0},
	{0x4000f, 0x0},
	{0x4002f, 0x0},
	{0x4004f, 0x0},
	{0x4006f, 0x0},
	{0x40010, 0x0},
	{0x40030, 0x0},
	{0x40050, 0x0},
	{0x40070, 0x0},
	{0x40011, 0x0},
	{0x40031, 0x0},
	{0x40051, 0x0},
	{0x40071, 0x0},
	{0x40012, 0x0},
	{0x40032, 0x0},
	{0x40052, 0x0},
	{0x40072, 0x0},
	{0x40013, 0x0},
	{0x40033, 0x0},
	{0x40053, 0x0},
	{0x40073, 0x0},
	{0x40014, 0x0},
	{0x40034, 0x0},
	{0x40054, 0x0},
	{0x40074, 0x0},
	{0x40015, 0x0},
	{0x40035, 0x0},
	{0x40055, 0x0},
	{0x40075, 0x0},
	{0x40016, 0x0},
	{0x40036, 0x0},
	{0x40056, 0x0},
	{0x40076, 0x0},
	{0x40017, 0x0},
	{0x40037, 0x0},
	{0x40057, 0x0},
	{0x40077, 0x0},
	{0x40018, 0x0},
	{0x40038, 0x0},
	{0x40058, 0x0},
	{0x40078, 0x0},
	{0x40019, 0x0},
	{0x40039, 0x0},
	{0x40059, 0x0},
	{0x40079, 0x0},
	{0x4001a, 0x0},
	{0x4003a, 0x0},
	{0x4005a, 0x0},
	{0x4007a, 0x0},
	{0x900aa, 0x0},
	{0x900ab, 0x0},
	{0x900ac, 0x0},
	{0x900ad, 0x0},
	{0x900ae, 0x0},
	{0x900af, 0x0},
	{0x900b0, 0x0},
	{0x900b1, 0x0},
	{0x900b2, 0x0},
	{0x900b3, 0x0},
	{0x900b4, 0x0},
	{0x900b5, 0x0},
	{0x900b6, 0x0},
	{0x900b7, 0x0},
	{0x900b8, 0x0},
	{0x900b9, 0x0},
	{0x900ba, 0x0},
	{0x900bb, 0x0},
	{0x900bc, 0x0},
	{0x900bd, 0x0},
	{0x900be, 0x0},
	{0x900bf, 0x0},
	{0x900c0, 0x0},
	{0x900c1, 0x0},
	{0x900c2, 0x0},
	{0x900c3, 0x0},
	{0x900c4, 0x0},
	{0x900c5, 0x0},
	{0x900c6, 0x0},
	{0x900c7, 0x0},
	{0x900c8, 0x0},
	{0x900c9, 0x0},
	{0x900ca, 0x0},
	{0x900cb, 0x0},
	{0x900cc, 0x0},
	{0x900cd, 0x0},
	{0x900ce, 0x0},
	{0x900cf, 0x0},
	{0x900d0, 0x0},
	{0x900d1, 0x0},
	{0x900d2, 0x0},
	{0x900d3, 0x0},
	{0x900d4, 0x0},
	{0x900d5, 0x0},
	{0x900d6, 0x0},
	{0x900d7, 0x0},
	{0x900d8, 0x0},
	{0x900d9, 0x0},
	{0x900da, 0x0},
	{0x900db, 0x0},
	{0x900dc, 0x0},
	{0x900dd, 0x0},
	{0x900de, 0x0},
	{0x900df, 0x0},
	{0x900e0, 0x0},
	{0x900e1, 0x0},
	{0x900e2, 0x0},
	{0x900e3, 0x0},
	{0x900e4, 0x0},
	{0x900e5, 0x0},
	{0x900e6, 0x0},
	{0x900e7, 0x0},
	{0x900e8, 0x0},
	{0x900e9, 0x0},
	{0x900ea, 0x0},
	{0x900eb, 0x0},
	{0x900ec, 0x0},
	{0x900ed, 0x0},
	{0x900ee, 0x0},
	{0x900ef, 0x0},
	{0x900f0, 0x0},
	{0x900f1, 0x0},
	{0x900f2, 0x0},
	{0x900f3, 0x0},
	{0x900f4, 0x0},
	{0x900f5, 0x0},
	{0x900f6, 0x0},
	{0x900f7, 0x0},
	{0x900f8, 0x0},
	{0x900f9, 0x0},
	{0x900fa, 0x0},
	{0x900fb, 0x0},
	{0x900fc, 0x0},
	{0x900fd, 0x0},
	{0x900fe, 0x0},
	{0x900ff, 0x0},
	{0x90100, 0x0},
	{0x90101, 0x0},
	{0x90102, 0x0},
	{0x90103, 0x0},
	{0x90104, 0x0},
	{0x90105, 0x0},
	{0x90106, 0x0},
	{0x90107, 0x0},
	{0x90108, 0x0},
	{0x90109, 0x0},
	{0x9010a, 0x0},
	{0x9010b, 0x0},
	{0x9010c, 0x0},
	{0x9010d, 0x0},
	{0x9010e, 0x0},
	{0x9010f, 0x0},
	{0x90110, 0x0},
	{0x90111, 0x0},
	{0x90112, 0x0},
	{0x90113, 0x0},
	{0x90114, 0x0},
	{0x90115, 0x0},
	{0x90116, 0x0},
	{0x90117, 0x0},
	{0x90118, 0x0},
	{0x90119, 0x0},
	{0x9011a, 0x0},
	{0x9011b, 0x0},
	{0x9011c, 0x0},
	{0x9011d, 0x0},
	{0x9011e, 0x0},
	{0x9011f, 0x0},
	{0x90120, 0x0},
	{0x90121, 0x0},
	{0x90122, 0x0},
	{0x90123, 0x0},
	{0x90124, 0x0},
	{0x90125, 0x0},
	{0x90126, 0x0},
	{0x90127, 0x0},
	{0x90128, 0x0},
	{0x90129, 0x0},
	{0x9012a, 0x0},
	{0x9012b, 0x0},
	{0x9012c, 0x0},
	{0x9012d, 0x0},
	{0x9012e, 0x0},
	{0x9012f, 0x0},
	{0x90130, 0x0},
	{0x90131, 0x0},
	{0x90132, 0x0},
	{0x90133, 0x0},
	{0x90134, 0x0},
	{0x90135, 0x0},
	{0x90136, 0x0},
	{0x90137, 0x0},
	{0x90138, 0x0},
	{0x90139, 0x0},
	{0x9013a, 0x0},
	{0x9013b, 0x0},
	{0x9013c, 0x0},
	{0x9013d, 0x0},
	{0x9013e, 0x0},
	{0x9013f, 0x0},
	{0x90140, 0x0},
	{0x90141, 0x0},
	{0x90142, 0x0},
	{0x90143, 0x0},
	{0x90144, 0x0},
	{0x90145, 0x0},
	{0x90146, 0x0},
	{0x90147, 0x0},
	{0x90148, 0x0},
	{0x90149, 0x0},
	{0x9014a, 0x0},
	{0x9014b, 0x0},
	{0x9014c, 0x0},
	{0x9014d, 0x0},
	{0x9014e, 0x0},
	{0x9014f, 0x0},
	{0x90150, 0x0},
	{0x90151, 0x0},
	{0x90152, 0x0},
	{0x90153, 0x0},
	{0x90154, 0x0},
	{0x90155, 0x0},
	{0x90156, 0x0},
	{0x90157, 0x0},
	{0x90158, 0x0},
	{0x90159, 0x0},
	{0x9015a, 0x0},
	{0x9015b, 0x0},
	{0x9015c, 0x0},
	{0x9015d, 0x0},
	{0x9015e, 0x0},
	{0x9015f, 0x0},
	{0x90160, 0x0},
	{0x90161, 0x0},
	{0x90162, 0x0},
	{0x90163, 0x0},
	{0x90164, 0x0},
	{0x90165, 0x0},
	{0x90166, 0x0},
	{0x90167, 0x0},
	{0x90168, 0x0},
	{0x90169, 0x0},
	{0x9016a, 0x0},
	{0x9016b, 0x0},
	{0x9016c, 0x0},
	{0x9016d, 0x0},
	{0x9016e, 0x0},
	{0x9016f, 0x0},
	{0x90170, 0x0},
	{0x90171, 0x0},
	{0x90172, 0x0},
	{0x90173, 0x0},
	{0x90174, 0x0},
	{0x90175, 0x0},
	{0x90176, 0x0},
	{0x90177, 0x0},
	{0x90178, 0x0},
	{0x90179, 0x0},
	{0x9017a, 0x0},
	{0x9017b, 0x0},
	{0x9017c, 0x0},
	{0x9017d, 0x0},
	{0x9017e, 0x0},
	{0x9017f, 0x0},
	{0x90180, 0x0},
	{0x90181, 0x0},
	{0x90182, 0x0},
	{0x90183, 0x0},
	{0x90184, 0x0},
	{0x90006, 0x0},
	{0x90007, 0x0},
	{0x90008, 0x0},
	{0x90009, 0x0},
	{0x9000a, 0x0},
	{0x9000b, 0x0},
	{0xd00e7, 0x0},
	{0x90017, 0x0},
	{0x9001f, 0x0},
	{0x90026, 0x0},
	{0x400d0, 0x0},
	{0x400d1, 0x0},
	{0x400d2, 0x0},
	{0x400d3, 0x0},
	{0x400d4, 0x0},
	{0x400d5, 0x0},
	{0x400d6, 0x0},
	{0x400d7, 0x0},
	{0x200be, 0x0},
	{0x2000b, 0x0},
	{0x2000c, 0x0},
	{0x2000d, 0x0},
	{0x2000e, 0x0},
	{0x12000b, 0x0},
	{0x12000c, 0x0},
	{0x12000d, 0x0},
	{0x12000e, 0x0},
	{0x22000b, 0x0},
	{0x22000c, 0x0},
	{0x22000d, 0x0},
	{0x22000e, 0x0},
	{0x9000c, 0x0},
	{0x9000d, 0x0},
	{0x9000e, 0x0},
	{0x9000f, 0x0},
	{0x90010, 0x0},
	{0x90011, 0x0},
	{0x90012, 0x0},
	{0x90013, 0x0},
	{0x20010, 0x0},
	{0x20011, 0x0},
	{0x120010, 0x0},
	{0x120011, 0x0},
	{0x40080, 0x0},
	{0x40081, 0x0},
	{0x40082, 0x0},
	{0x40083, 0x0},
	{0x40084, 0x0},
	{0x40085, 0x0},
	{0x140080, 0x0},
	{0x140081, 0x0},
	{0x140082, 0x0},
	{0x140083, 0x0},
	{0x140084, 0x0},
	{0x140085, 0x0},
	{0x240080, 0x0},
	{0x240081, 0x0},
	{0x240082, 0x0},
	{0x240083, 0x0},
	{0x240084, 0x0},
	{0x240085, 0x0},
	{0x400fd, 0x0},
	{0x400f1, 0x0},
	{0x10011, 0x0},
	{0x10012, 0x0},
	{0x10013, 0x0},
	{0x10018, 0x0},
	{0x10002, 0x0},
	{0x100b2, 0x0},
	{0x101b4, 0x0},
	{0x102b4, 0x0},
	{0x103b4, 0x0},
	{0x104b4, 0x0},
	{0x105b4, 0x0},
	{0x106b4, 0x0},
	{0x107b4, 0x0},
	{0x108b4, 0x0},
	{0x11011, 0x0},
	{0x11012, 0x0},
	{0x11013, 0x0},
	{0x11018, 0x0},
	{0x11002, 0x0},
	{0x110b2, 0x0},
	{0x111b4, 0x0},
	{0x112b4, 0x0},
	{0x113b4, 0x0},
	{0x114b4, 0x0},
	{0x115b4, 0x0},
	{0x116b4, 0x0},
	{0x117b4, 0x0},
	{0x118b4, 0x0},
	{0x20089, 0x0},
	{0xc0080, 0x0},
	{0x200cb, 0x0},
	{0x10068, 0x0},
	{0x10069, 0x0},
	{0x10168, 0x0},
	{0x10169, 0x0},
	{0x10268, 0x0},
	{0x10269, 0x0},
	{0x10368, 0x0},
	{0x10369, 0x0},
	{0x10468, 0x0},
	{0x10469, 0x0},
	{0x10568, 0x0},
	{0x10569, 0x0},
	{0x10668, 0x0},
	{0x10669, 0x0},
	{0x10768, 0x0},
	{0x10769, 0x0},
	{0x10868, 0x0},
	{0x10869, 0x0},
	{0x100aa, 0x0},
	{0x10062, 0x0},
	{0x10001, 0x0},
	{0x100a0, 0x0},
	{0x100a1, 0x0},
	{0x100a2, 0x0},
	{0x100a3, 0x0},
	{0x100a4, 0x0},
	{0x100a5, 0x0},
	{0x100a6, 0x0},
	{0x100a7, 0x0},
	{0x11068, 0x0},
	{0x11069, 0x0},
	{0x11168, 0x0},
	{0x11169, 0x0},
	{0x11268, 0x0},
	{0x11269, 0x0},
	{0x11368, 0x0},
	{0x11369, 0x0},
	{0x11468, 0x0},
	{0x11469, 0x0},
	{0x11568, 0x0},
	{0x11569, 0x0},
	{0x11668, 0x0},
	{0x11669, 0x0},
	{0x11768, 0x0},
	{0x11769, 0x0},
	{0x11868, 0x0},
	{0x11869, 0x0},
	{0x110aa, 0x0},
	{0x11062, 0x0},
	{0x11001, 0x0},
	{0x110a0, 0x0},
	{0x110a1, 0x0},
	{0x110a2, 0x0},
	{0x110a3, 0x0},
	{0x110a4, 0x0},
	{0x110a5, 0x0},
	{0x110a6, 0x0},
	{0x110a7, 0x0},
	{0x80, 0x0},
	{0x1080, 0x0},
	{0x2080, 0x0},
	{0x10020, 0x0},
	{0x10080, 0x0},
	{0x10081, 0x0},
	{0x100d0, 0x0},
	{0x100d1, 0x0},
	{0x1008c, 0x0},
	{0x1008d, 0x0},
	{0x10180, 0x0},
	{0x10181, 0x0},
	{0x101d0, 0x0},
	{0x101d1, 0x0},
	{0x1018c, 0x0},
	{0x1018d, 0x0},
	{0x100c0, 0x0},
	{0x100c1, 0x0},
	{0x101c0, 0x0},
	{0x101c1, 0x0},
	{0x102c0, 0x0},
	{0x102c1, 0x0},
	{0x103c0, 0x0},
	{0x103c1, 0x0},
	{0x104c0, 0x0},
	{0x104c1, 0x0},
	{0x105c0, 0x0},
	{0x105c1, 0x0},
	{0x106c0, 0x0},
	{0x106c1, 0x0},
	{0x107c0, 0x0},
	{0x107c1, 0x0},
	{0x108c0, 0x0},
	{0x108c1, 0x0},
	{0x100ae, 0x0},
	{0x100af, 0x0},
	{0x11020, 0x0},
	{0x11080, 0x0},
	{0x11081, 0x0},
	{0x110d0, 0x0},
	{0x110d1, 0x0},
	{0x1108c, 0x0},
	{0x1108d, 0x0},
	{0x11180, 0x0},
	{0x11181, 0x0},
	{0x111d0, 0x0},
	{0x111d1, 0x0},
	{0x1118c, 0x0},
	{0x1118d, 0x0},
	{0x110c0, 0x0},
	{0x110c1, 0x0},
	{0x111c0, 0x0},
	{0x111c1, 0x0},
	{0x112c0, 0x0},
	{0x112c1, 0x0},
	{0x113c0, 0x0},
	{0x113c1, 0x0},
	{0x114c0, 0x0},
	{0x114c1, 0x0},
	{0x115c0, 0x0},
	{0x115c1, 0x0},
	{0x116c0, 0x0},
	{0x116c1, 0x0},
	{0x117c0, 0x0},
	{0x117c1, 0x0},
	{0x118c0, 0x0},
	{0x118c1, 0x0},
	{0x110ae, 0x0},
	{0x110af, 0x0},
	{0x90201, 0x0},
	{0x90202, 0x0},
	{0x90203, 0x0},
	{0x90205, 0x0},
	{0x90206, 0x0},
	{0x90207, 0x0},
	{0x90208, 0x0},
	{0x20020, 0x0},
	{0x100080, 0x0},
	{0x101080, 0x0},
	{0x102080, 0x0},
	{0x110020, 0x0},
	{0x110080, 0x0},
	{0x110081, 0x0},
	{0x1100d0, 0x0},
	{0x1100d1, 0x0},
	{0x11008c, 0x0},
	{0x11008d, 0x0},
	{0x110180, 0x0},
	{0x110181, 0x0},
	{0x1101d0, 0x0},
	{0x1101d1, 0x0},
	{0x11018c, 0x0},
	{0x11018d, 0x0},
	{0x1100c0, 0x0},
	{0x1100c1, 0x0},
	{0x1101c0, 0x0},
	{0x1101c1, 0x0},
	{0x1102c0, 0x0},
	{0x1102c1, 0x0},
	{0x1103c0, 0x0},
	{0x1103c1, 0x0},
	{0x1104c0, 0x0},
	{0x1104c1, 0x0},
	{0x1105c0, 0x0},
	{0x1105c1, 0x0},
	{0x1106c0, 0x0},
	{0x1106c1, 0x0},
	{0x1107c0, 0x0},
	{0x1107c1, 0x0},
	{0x1108c0, 0x0},
	{0x1108c1, 0x0},
	{0x1100ae, 0x0},
	{0x1100af, 0x0},
	{0x111020, 0x0},
	{0x111080, 0x0},
	{0x111081, 0x0},
	{0x1110d0, 0x0},
	{0x1110d1, 0x0},
	{0x11108c, 0x0},
	{0x11108d, 0x0},
	{0x111180, 0x0},
	{0x111181, 0x0},
	{0x1111d0, 0x0},
	{0x1111d1, 0x0},
	{0x11118c, 0x0},
	{0x11118d, 0x0},
	{0x1110c0, 0x0},
	{0x1110c1, 0x0},
	{0x1111c0, 0x0},
	{0x1111c1, 0x0},
	{0x1112c0, 0x0},
	{0x1112c1, 0x0},
	{0x1113c0, 0x0},
	{0x1113c1, 0x0},
	{0x1114c0, 0x0},
	{0x1114c1, 0x0},
	{0x1115c0, 0x0},
	{0x1115c1, 0x0},
	{0x1116c0, 0x0},
	{0x1116c1, 0x0},
	{0x1117c0, 0x0},
	{0x1117c1, 0x0},
	{0x1118c0, 0x0},
	{0x1118c1, 0x0},
	{0x1110ae, 0x0},
	{0x1110af, 0x0},
	{0x190201, 0x0},
	{0x190202, 0x0},
	{0x190203, 0x0},
	{0x190205, 0x0},
	{0x190206, 0x0},
	{0x190207, 0x0},
	{0x190208, 0x0},
	{0x120020, 0x0},
	{0x200080, 0x0},
	{0x201080, 0x0},
	{0x202080, 0x0},
	{0x210020, 0x0},
	{0x210080, 0x0},
	{0x210081, 0x0},
	{0x2100d0, 0x0},
	{0x2100d1, 0x0},
	{0x21008c, 0x0},
	{0x21008d, 0x0},
	{0x210180, 0x0},
	{0x210181, 0x0},
	{0x2101d0, 0x0},
	{0x2101d1, 0x0},
	{0x21018c, 0x0},
	{0x21018d, 0x0},
	{0x2100c0, 0x0},
	{0x2100c1, 0x0},
	{0x2101c0, 0x0},
	{0x2101c1, 0x0},
	{0x2102c0, 0x0},
	{0x2102c1, 0x0},
	{0x2103c0, 0x0},
	{0x2103c1, 0x0},
	{0x2104c0, 0x0},
	{0x2104c1, 0x0},
	{0x2105c0, 0x0},
	{0x2105c1, 0x0},
	{0x2106c0, 0x0},
	{0x2106c1, 0x0},
	{0x2107c0, 0x0},
	{0x2107c1, 0x0},
	{0x2108c0, 0x0},
	{0x2108c1, 0x0},
	{0x2100ae, 0x0},
	{0x2100af, 0x0},
	{0x211020, 0x0},
	{0x211080, 0x0},
	{0x211081, 0x0},
	{0x2110d0, 0x0},
	{0x2110d1, 0x0},
	{0x21108c, 0x0},
	{0x21108d, 0x0},
	{0x211180, 0x0},
	{0x211181, 0x0},
	{0x2111d0, 0x0},
	{0x2111d1, 0x0},
	{0x21118c, 0x0},
	{0x21118d, 0x0},
	{0x2110c0, 0x0},
	{0x2110c1, 0x0},
	{0x2111c0, 0x0},
	{0x2111c1, 0x0},
	{0x2112c0, 0x0},
	{0x2112c1, 0x0},
	{0x2113c0, 0x0},
	{0x2113c1, 0x0},
	{0x2114c0, 0x0},
	{0x2114c1, 0x0},
	{0x2115c0, 0x0},
	{0x2115c1, 0x0},
	{0x2116c0, 0x0},
	{0x2116c1, 0x0},
	{0x2117c0, 0x0},
	{0x2117c1, 0x0},
	{0x2118c0, 0x0},
	{0x2118c1, 0x0},
	{0x2110ae, 0x0},
	{0x2110af, 0x0},
	{0x290201, 0x0},
	{0x290202, 0x0},
	{0x290203, 0x0},
	{0x290205, 0x0},
	{0x290206, 0x0},
	{0x290207, 0x0},
	{0x290208, 0x0},
	{0x220020, 0x0},
	{0x20077, 0x0},
	{0x20072, 0x0},
	{0x20073, 0x0},
	{0x400c0, 0x0},
	{0x10040, 0x0},
	{0x10140, 0x0},
	{0x10240, 0x0},
	{0x10340, 0x0},
	{0x10440, 0x0},
	{0x10540, 0x0},
	{0x10640, 0x0},
	{0x10740, 0x0},
	{0x10840, 0x0},
	{0x11040, 0x0},
	{0x11140, 0x0},
	{0x11240, 0x0},
	{0x11340, 0x0},
	{0x11440, 0x0},
	{0x11540, 0x0},
	{0x11640, 0x0},
	{0x11740, 0x0},
	{0x11840, 0x0},
};

/* P0 message block parameter for training firmware */
static struct dram_cfg_param ddr_fsp0_cfg[] = {
	{0xd0000, 0x0},
	{0x54003, 0xe94},
	{0x54004, 0x4},
	{0x54006, 0x15},
	{0x54008, 0x131f},
	{0x54009, 0xc8},
	{0x5400b, 0x4},
	{0x5400d, 0x100},
	{0x5400f, 0x100},
	{0x54012, 0x110},
	{0x54019, 0x36e4},
	{0x5401a, 0x32},
	{0x5401b, 0x1146},
	{0x5401c, 0x1108},
	{0x5401e, 0x4},
	{0x5401f, 0x36e4},
	{0x54020, 0x32},
	{0x54021, 0x1146},
	{0x54022, 0x1108},
	{0x54024, 0x4},
	{0x54032, 0xe400},
	{0x54033, 0x3236},
	{0x54034, 0x4600},
	{0x54035, 0x811},
	{0x54036, 0x11},
	{0x54037, 0x400},
	{0x54038, 0xe400},
	{0x54039, 0x3236},
	{0x5403a, 0x4600},
	{0x5403b, 0x811},
	{0x5403c, 0x11},
	{0x5403d, 0x400},
	{0xd0000, 0x1}
};

/* P0 2D message block parameter for training firmware */
static struct dram_cfg_param ddr_fsp0_2d_cfg[] = {
	{0xd0000, 0x0},
	{0x54003, 0xe94},
	{0x54004, 0x4},
	{0x54006, 0x15},
	{0x54008, 0x61},
	{0x54009, 0xc8},
	{0x5400b, 0x4},
	{0x5400d, 0x100},
	{0x5400f, 0x100},
	{0x54010, 0x2080},
	{0x54012, 0x110},
	{0x54019, 0x36e4},
	{0x5401a, 0x32},
	{0x5401b, 0x1146},
	{0x5401c, 0x1108},
	{0x5401e, 0x4},
	{0x5401f, 0x36e4},
	{0x54020, 0x32},
	{0x54021, 0x1146},
	{0x54022, 0x1108},
	{0x54024, 0x4},
	{0x54032, 0xe400},
	{0x54033, 0x3236},
	{0x54034, 0x4600},
	{0x54035, 0x811},
	{0x54036, 0x11},
	{0x54037, 0x400},
	{0x54038, 0xe400},
	{0x54039, 0x3236},
	{0x5403a, 0x4600},
	{0x5403b, 0x811},
	{0x5403c, 0x11},
	{0x5403d, 0x400},
	{0xd0000, 0x1}
};

/* DRAM PHY init engine image */
static struct dram_cfg_param ddr_phy_pie[] = {
	{0xd0000, 0x0},
	{0x90000, 0x10},
	{0x90001, 0x400},
	{0x90002, 0x10e},
	{0x90003, 0x0},
	{0x90004, 0x0},
	{0x90005, 0x8},
	{0x90029, 0xb},
	{0x9002a, 0x480},
	{0x9002b, 0x109},
	{0x9002c, 0x8},
	{0x9002d, 0x448},
	{0x9002e, 0x139},
	{0x9002f, 0x8},
	{0x90030, 0x478},
	{0x90031, 0x109},
	{0x90032, 0x0},
	{0x90033, 0xe8},
	{0x90034, 0x109},
	{0x90035, 0x2},
	{0x90036, 0x10},
	{0x90037, 0x139},
	{0x90038, 0xb},
	{0x90039, 0x7c0},
	{0x9003a, 0x139},
	{0x9003b, 0x44},
	{0x9003c, 0x633},
	{0x9003d, 0x159},
	{0x9003e, 0x14f},
	{0x9003f, 0x630},
	{0x90040, 0x159},
	{0x90041, 0x47},
	{0x90042, 0x633},
	{0x90043, 0x149},
	{0x90044, 0x4f},
	{0x90045, 0x633},
	{0x90046, 0x179},
	{0x90047, 0x8},
	{0x90048, 0xe0},
	{0x90049, 0x109},
	{0x9004a, 0x0},
	{0x9004b, 0x7c8},
	{0x9004c, 0x109},
	{0x9004d, 0x0},
	{0x9004e, 0x1},
	{0x9004f, 0x8},
	{0x90050, 0x30},
	{0x90051, 0x65a},
	{0x90052, 0x9},
	{0x90053, 0x0},
	{0x90054, 0x45a},
	{0x90055, 0x9},
	{0x90056, 0x0},
	{0x90057, 0x448},
	{0x90058, 0x109},
	{0x90059, 0x40},
	{0x9005a, 0x633},
	{0x9005b, 0x179},
	{0x9005c, 0x1},
	{0x9005d, 0x618},
	{0x9005e, 0x109},
	{0x9005f, 0x40c0},
	{0x90060, 0x633},
	{0x90061, 0x149},
	{0x90062, 0x8},
	{0x90063, 0x4},
	{0x90064, 0x48},
	{0x90065, 0x4040},
	{0x90066, 0x633},
	{0x90067, 0x149},
	{0x90068, 0x0},
	{0x90069, 0x4},
	{0x9006a, 0x48},
	{0x9006b, 0x40},
	{0x9006c, 0x633},
	{0x9006d, 0x149},
	{0x9006e, 0x0},
	{0x9006f, 0x658},
	{0x90070, 0x109},
	{0x90071, 0x10},
	{0x90072, 0x4},
	{0x90073, 0x18},
	{0x90074, 0x0},
	{0x90075, 0x4},
	{0x90076, 0x78},
	{0x90077, 0x549},
	{0x90078, 0x633},
	{0x90079, 0x159},
	{0x9007a, 0xd49},
	{0x9007b, 0x633},
	{0x9007c, 0x159},
	{0x9007d, 0x94a},
	{0x9007e, 0x633},
	{0x9007f, 0x159},
	{0x90080, 0x441},
	{0x90081, 0x633},
	{0x90082, 0x149},
	{0x90083, 0x42},
	{0x90084, 0x633},
	{0x90085, 0x149},
	{0x90086, 0x1},
	{0x90087, 0x633},
	{0x90088, 0x149},
	{0x90089, 0x0},
	{0x9008a, 0xe0},
	{0x9008b, 0x109},
	{0x9008c, 0xa},
	{0x9008d, 0x10},
	{0x9008e, 0x109},
	{0x9008f, 0x9},
	{0x90090, 0x3c0},
	{0x90091, 0x149},
	{0x90092, 0x9},
	{0x90093, 0x3c0},
	{0x90094, 0x159},
	{0x90095, 0x18},
	{0x90096, 0x10},
	{0x90097, 0x109},
	{0x90098, 0x0},
	{0x90099, 0x3c0},
	{0x9009a, 0x109},
	{0x9009b, 0x18},
	{0x9009c, 0x4},
	{0x9009d, 0x48},
	{0x9009e, 0x18},
	{0x9009f, 0x4},
	{0x900a0, 0x58},
	{0x900a1, 0xb},
	{0x900a2, 0x10},
	{0x900a3, 0x109},
	{0x900a4, 0x1},
	{0x900a5, 0x10},
	{0x900a6, 0x109},
	{0x900a7, 0x5},
	{0x900a8, 0x7c0},
	{0x900a9, 0x109},
	{0x40000, 0x811},
	{0x40020, 0x880},
	{0x40040, 0x0},
	{0x40060, 0x0},
	{0x40001, 0x4008},
	{0x40021, 0x83},
	{0x40041, 0x4f},
	{0x40061, 0x0},
	{0x40002, 0x4040},
	{0x40022, 0x83},
	{0x40042, 0x51},
	{0x40062, 0x0},
	{0x40003, 0x811},
	{0x40023, 0x880},
	{0x40043, 0x0},
	{0x40063, 0x0},
	{0x40004, 0x720},
	{0x40024, 0xf},
	{0x40044, 0x1740},
	{0x40064, 0x0},
	{0x40005, 0x16},
	{0x40025, 0x83},
	{0x40045, 0x4b},
	{0x40065, 0x0},
	{0x40006, 0x716},
	{0x40026, 0xf},
	{0x40046, 0x2001},
	{0x40066, 0x0},
	{0x40007, 0x716},
	{0x40027, 0xf},
	{0x40047, 0x2800},
	{0x40067, 0x0},
	{0x40008, 0x716},
	{0x40028, 0xf},
	{0x40048, 0xf00},
	{0x40068, 0x0},
	{0x40009, 0x720},
	{0x40029, 0xf},
	{0x40049, 0x1400},
	{0x40069, 0x0},
	{0x4000a, 0xe08},
	{0x4002a, 0xc15},
	{0x4004a, 0x0},
	{0x4006a, 0x0},
	{0x4000b, 0x625},
	{0x4002b, 0x15},
	{0x4004b, 0x0},
	{0x4006b, 0x0},
	{0x4000c, 0x4028},
	{0x4002c, 0x80},
	{0x4004c, 0x0},
	{0x4006c, 0x0},
	{0x4000d, 0xe08},
	{0x4002d, 0xc1a},
	{0x4004d, 0x0},
	{0x4006d, 0x0},
	{0x4000e, 0x625},
	{0x4002e, 0x1a},
	{0x4004e, 0x0},
	{0x4006e, 0x0},
	{0x4000f, 0x4040},
	{0x4002f, 0x80},
	{0x4004f, 0x0},
	{0x4006f, 0x0},
	{0x40010, 0x2604},
	{0x40030, 0x15},
	{0x40050, 0x0},
	{0x40070, 0x0},
	{0x40011, 0x708},
	{0x40031, 0x5},
	{0x40051, 0x0},
	{0x40071, 0x2002},
	{0x40012, 0x8},
	{0x40032, 0x80},
	{0x40052, 0x0},
	{0x40072, 0x0},
	{0x40013, 0x2604},
	{0x40033, 0x1a},
	{0x40053, 0x0},
	{0x40073, 0x0},
	{0x40014, 0x708},
	{0x40034, 0xa},
	{0x40054, 0x0},
	{0x40074, 0x2002},
	{0x40015, 0x4040},
	{0x40035, 0x80},
	{0x40055, 0x0},
	{0x40075, 0x0},
	{0x40016, 0x60a},
	{0x40036, 0x15},
	{0x40056, 0x1200},
	{0x40076, 0x0},
	{0x40017, 0x61a},
	{0x40037, 0x15},
	{0x40057, 0x1300},
	{0x40077, 0x0},
	{0x40018, 0x60a},
	{0x40038, 0x1a},
	{0x40058, 0x1200},
	{0x40078, 0x0},
	{0x40019, 0x642},
	{0x40039, 0x1a},
	{0x40059, 0x1300},
	{0x40079, 0x0},
	{0x4001a, 0x4808},
	{0x4003a, 0x880},
	{0x4005a, 0x0},
	{0x4007a, 0x0},
	{0x900aa, 0x0},
	{0x900ab, 0x790},
	{0x900ac, 0x11a},
	{0x900ad, 0x8},
	{0x900ae, 0x7aa},
	{0x900af, 0x2a},
	{0x900b0, 0x10},
	{0x900b1, 0x7b2},
	{0x900b2, 0x2a},
	{0x900b3, 0x0},
	{0x900b4, 0x7c8},
	{0x900b5, 0x109},
	{0x900b6, 0x10},
	{0x900b7, 0x10},
	{0x900b8, 0x109},
	{0x900b9, 0x10},
	{0x900ba, 0x2a8},
	{0x900bb, 0x129},
	{0x900bc, 0x8},
	{0x900bd, 0x370},
	{0x900be, 0x129},
	{0x900bf, 0xa},
	{0x900c0, 0x3c8},
	{0x900c1, 0x1a9},
	{0x900c2, 0xc},
	{0x900c3, 0x408},
	{0x900c4, 0x199},
	{0x900c5, 0x14},
	{0x900c6, 0x790},
	{0x900c7, 0x11a},
	{0x900c8, 0x8},
	{0x900c9, 0x4},
	{0x900ca, 0x18},
	{0x900cb, 0xe},
	{0x900cc, 0x408},
	{0x900cd, 0x199},
	{0x900ce, 0x8},
	{0x900cf, 0x8568},
	{0x900d0, 0x108},
	{0x900d1, 0x18},
	{0x900d2, 0x790},
	{0x900d3, 0x16a},
	{0x900d4, 0x8},
	{0x900d5, 0x1d8},
	{0x900d6, 0x169},
	{0x900d7, 0x10},
	{0x900d8, 0x8558},
	{0x900d9, 0x168},
	{0x900da, 0x1ff8},
	{0x900db, 0x85a8},
	{0x900dc, 0x1e8},
	{0x900dd, 0x50},
	{0x900de, 0x798},
	{0x900df, 0x16a},
	{0x900e0, 0x60},
	{0x900e1, 0x7a0},
	{0x900e2, 0x16a},
	{0x900e3, 0x8},
	{0x900e4, 0x8310},
	{0x900e5, 0x168},
	{0x900e6, 0x8},
	{0x900e7, 0xa310},
	{0x900e8, 0x168},
	{0x900e9, 0xa},
	{0x900ea, 0x408},
	{0x900eb, 0x169},
	{0x900ec, 0x6e},
	{0x900ed, 0x0},
	{0x900ee, 0x68},
	{0x900ef, 0x0},
	{0x900f0, 0x408},
	{0x900f1, 0x169},
	{0x900f2, 0x0},
	{0x900f3, 0x8310},
	{0x900f4, 0x168},
	{0x900f5, 0x0},
	{0x900f6, 0xa310},
	{0x900f7, 0x168},
	{0x900f8, 0x1ff8},
	{0x900f9, 0x85a8},
	{0x900fa, 0x1e8},
	{0x900fb, 0x68},
	{0x900fc, 0x798},
	{0x900fd, 0x16a},
	{0x900fe, 0x78},
	{0x900ff, 0x7a0},
	{0x90100, 0x16a},
	{0x90101, 0x68},
	{0x90102, 0x790},
	{0x90103, 0x16a},
	{0x90104, 0x8},
	{0x90105, 0x8b10},
	{0x90106, 0x168},
	{0x90107, 0x8},
	{0x90108, 0xab10},
	{0x90109, 0x168},
	{0x9010a, 0xa},
	{0x9010b, 0x408},
	{0x9010c, 0x169},
	{0x9010d, 0x58},
	{0x9010e, 0x0},
	{0x9010f, 0x68},
	{0x90110, 0x0},
	{0x90111, 0x408},
	{0x90112, 0x169},
	{0x90113, 0x0},
	{0x90114, 0x8b10},
	{0x90115, 0x168},
	{0x90116, 0x1},
	{0x90117, 0xab10},
	{0x90118, 0x168},
	{0x90119, 0x0},
	{0x9011a, 0x1d8},
	{0x9011b, 0x169},
	{0x9011c, 0x80},
	{0x9011d, 0x790},
	{0x9011e, 0x16a},
	{0x9011f, 0x18},
	{0x90120, 0x7aa},
	{0x90121, 0x6a},
	{0x90122, 0xa},
	{0x90123, 0x0},
	{0x90124, 0x1e9},
	{0x90125, 0x8},
	{0x90126, 0x8080},
	{0x90127, 0x108},
	{0x90128, 0xf},
	{0x90129, 0x408},
	{0x9012a, 0x169},
	{0x9012b, 0xc},
	{0x9012c, 0x0},
	{0x9012d, 0x68},
	{0x9012e, 0x9},
	{0x9012f, 0x0},
	{0x90130, 0x1a9},
	{0x90131, 0x0},
	{0x90132, 0x408},
	{0x90133, 0x169},
	{0x90134, 0x0},
	{0x90135, 0x8080},
	{0x90136, 0x108},
	{0x90137, 0x8},
	{0x90138, 0x7aa},
	{0x90139, 0x6a},
	{0x9013a, 0x0},
	{0x9013b, 0x8568},
	{0x9013c, 0x108},
	{0x9013d, 0xb7},
	{0x9013e, 0x790},
	{0x9013f, 0x16a},
	{0x90140, 0x1f},
	{0x90141, 0x0},
	{0x90142, 0x68},
	{0x90143, 0x8},
	{0x90144, 0x8558},
	{0x90145, 0x168},
	{0x90146, 0xf},
	{0x90147, 0x408},
	{0x90148, 0x169},
	{0x90149, 0xd},
	{0x9014a, 0x0},
	{0x9014b, 0x68},
	{0x9014c, 0x0},
	{0x9014d, 0x408},
	{0x9014e, 0x169},
	{0x9014f, 0x0},
	{0x90150, 0x8558},
	{0x90151, 0x168},
	{0x90152, 0x8},
	{0x90153, 0x3c8},
	{0x90154, 0x1a9},
	{0x90155, 0x3},
	{0x90156, 0x370},
	{0x90157, 0x129},
	{0x90158, 0x20},
	{0x90159, 0x2aa},
	{0x9015a, 0x9},
	{0x9015b, 0x8},
	{0x9015c, 0xe8},
	{0x9015d, 0x109},
	{0x9015e, 0x0},
	{0x9015f, 0x8140},
	{0x90160, 0x10c},
	{0x90161, 0x10},
	{0x90162, 0x8138},
	{0x90163, 0x104},
	{0x90164, 0x8},
	{0x90165, 0x448},
	{0x90166, 0x109},
	{0x90167, 0xf},
	{0x90168, 0x7c0},
	{0x90169, 0x109},
	{0x9016a, 0x0},
	{0x9016b, 0xe8},
	{0x9016c, 0x109},
	{0x9016d, 0x47},
	{0x9016e, 0x630},
	{0x9016f, 0x109},
	{0x90170, 0x8},
	{0x90171, 0x618},
	{0x90172, 0x109},
	{0x90173, 0x8},
	{0x90174, 0xe0},
	{0x90175, 0x109},
	{0x90176, 0x0},
	{0x90177, 0x7c8},
	{0x90178, 0x109},
	{0x90179, 0x8},
	{0x9017a, 0x8140},
	{0x9017b, 0x10c},
	{0x9017c, 0x0},
	{0x9017d, 0x478},
	{0x9017e, 0x109},
	{0x9017f, 0x0},
	{0x90180, 0x1},
	{0x90181, 0x8},
	{0x90182, 0x8},
	{0x90183, 0x4},
	{0x90184, 0x0},
	{0x90006, 0x8},
	{0x90007, 0x7c8},
	{0x90008, 0x109},
	{0x90009, 0x0},
	{0x9000a, 0x400},
	{0x9000b, 0x106},
	{0xd00e7, 0x400},
	{0x90017, 0x0},
	{0x9001f, 0x2b},
	{0x90026, 0x69},
	{0x400d0, 0x0},
	{0x400d1, 0x101},
	{0x400d2, 0x105},
	{0x400d3, 0x107},
	{0x400d4, 0x10f},
	{0x400d5, 0x202},
	{0x400d6, 0x20a},
	{0x400d7, 0x20b},
	{0x2003a, 0x2},
	{0x200be, 0x3},
	{0x2000b, 0x41a},
	{0x2000c, 0xe9},
	{0x2000d, 0x91c},
	{0x2000e, 0x2c},
	{0x12000b, 0x20d},
	{0x12000c, 0x74},
	{0x12000d, 0x48e},
	{0x12000e, 0x2c},
	{0x22000b, 0xb0},
	{0x22000c, 0x27},
	{0x22000d, 0x186},
	{0x22000e, 0x10},
	{0x9000c, 0x0},
	{0x9000d, 0x173},
	{0x9000e, 0x60},
	{0x9000f, 0x6110},
	{0x90010, 0x2152},
	{0x90011, 0xdfbd},
	{0x90012, 0x2060},
	{0x90013, 0x6152},
	{0x20010, 0x5a},
	{0x20011, 0x3},
	{0x120010, 0x5a},
	{0x120011, 0x3},
	{0x40080, 0xe0},
	{0x40081, 0x12},
	{0x40082, 0xe0},
	{0x40083, 0x12},
	{0x40084, 0xe0},
	{0x40085, 0x12},
	{0x140080, 0xe0},
	{0x140081, 0x12},
	{0x140082, 0xe0},
	{0x140083, 0x12},
	{0x140084, 0xe0},
	{0x140085, 0x12},
	{0x240080, 0xe0},
	{0x240081, 0x12},
	{0x240082, 0xe0},
	{0x240083, 0x12},
	{0x240084, 0xe0},
	{0x240085, 0x12},
	{0x400fd, 0xf},
	{0x400f1, 0xe},
	{0x10011, 0x1},
	{0x10012, 0x1},
	{0x10013, 0x180},
	{0x10018, 0x1},
	{0x10002, 0x6209},
	{0x100b2, 0x1},
	{0x101b4, 0x1},
	{0x102b4, 0x1},
	{0x103b4, 0x1},
	{0x104b4, 0x1},
	{0x105b4, 0x1},
	{0x106b4, 0x1},
	{0x107b4, 0x1},
	{0x108b4, 0x1},
	{0x11011, 0x1},
	{0x11012, 0x1},
	{0x11013, 0x180},
	{0x11018, 0x1},
	{0x11002, 0x6209},
	{0x110b2, 0x1},
	{0x111b4, 0x1},
	{0x112b4, 0x1},
	{0x113b4, 0x1},
	{0x114b4, 0x1},
	{0x115b4, 0x1},
	{0x116b4, 0x1},
	{0x117b4, 0x1},
	{0x118b4, 0x1},
	{0x20089, 0x1},
	{0x20088, 0x19},
	{0xc0080, 0x0},
	{0xd0000, 0x1},
};

static struct dram_fsp_msg ddr_dram_fsp_msg[] = {
	{
		/* P0 3733mts 1D */
		.drate = 3733,
		.fw_type = FW_1D_IMAGE,
		.fsp_cfg = ddr_fsp0_cfg,
		.fsp_cfg_num = ARRAY_SIZE(ddr_fsp0_cfg),
	},
	{
		/* P0 3733mts 2D */
		.drate = 3733,
		.fw_type = FW_2D_IMAGE,
		.fsp_cfg = ddr_fsp0_2d_cfg,
		.fsp_cfg_num = ARRAY_SIZE(ddr_fsp0_2d_cfg),
	},
};

/* ddr timing config params */
struct dram_timing_info frdm_imx93_dram_timing = {
	.ddrc_cfg = ddr_ddrc_cfg,
	.ddrc_cfg_num = ARRAY_SIZE(ddr_ddrc_cfg),
	.ddrphy_cfg = ddr_ddrphy_cfg,
	.ddrphy_cfg_num = ARRAY_SIZE(ddr_ddrphy_cfg),
	.fsp_msg = ddr_dram_fsp_msg,
	.fsp_msg_num = ARRAY_SIZE(ddr_dram_fsp_msg),
	.ddrphy_trained_csr = ddr_ddrphy_trained_csr,
	.ddrphy_trained_csr_num = ARRAY_SIZE(ddr_ddrphy_trained_csr),
	.ddrphy_pie = ddr_phy_pie,
	.ddrphy_pie_num = ARRAY_SIZE(ddr_phy_pie),
	.fsp_table = { 3733, },
	.fsp_cfg = ddr_dram_fsp_cfg,
	.fsp_cfg_num = ARRAY_SIZE(ddr_dram_fsp_cfg),
};
