/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaAssignment_private_offset;
static gpointer vala_assignment_parent_class = NULL;

static void vala_assignment_set_left (ValaAssignment* self,
                               ValaExpression* value);
static void vala_assignment_set_operator (ValaAssignment* self,
                                   ValaAssignmentOperator value);
static void vala_assignment_set_right (ValaAssignment* self,
                                ValaExpression* value);
static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static gchar* vala_assignment_real_to_string (ValaCodeNode* base);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static void vala_assignment_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static void vala_assignment_check_constant_assignment (ValaAssignment* self,
                                                ValaMemberAccess* inner);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);
static GType vala_assignment_get_type_once (void);

static inline gpointer
vala_assignment_get_instance_private (ValaAssignment* self)
{
	return G_STRUCT_MEMBER_P (self, ValaAssignment_private_offset);
}

ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_operator;
	return result;
}

static void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

static void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}

ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}

static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static gchar*
vala_assignment_real_to_string (ValaCodeNode* base)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaAssignmentOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	self = (ValaAssignment*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_assignment_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}

static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_assignment_real_get_error_types (ValaCodeNode* base,
                                      ValaCollection* collection,
                                      ValaSourceReference* source_reference)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp92_;
	ValaExpression* _tmp93_;
	ValaExpression* _tmp94_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp97_;
	ValaExpression* _tmp248_;
	ValaExpression* _tmp249_;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp250_;
	ValaExpression* _tmp251_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp252_;
	ValaExpression* _tmp253_;
	gboolean transform_assignment = FALSE;
	gboolean _tmp254_ = FALSE;
	ValaMemberAccess* _tmp255_;
	gboolean _tmp283_ = FALSE;
	ValaAssignmentOperator _tmp284_;
	ValaMemberAccess* _tmp348_;
	ValaExpression* _tmp685_;
	ValaExpression* _tmp686_;
	ValaDataType* _tmp687_;
	ValaDataType* _tmp688_;
	ValaDataType* _tmp697_;
	ValaDataType* _tmp698_;
	gboolean _tmp701_;
	gboolean _tmp702_;
	gboolean result;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (VALA_IS_TUPLE (_tmp7_)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_EXPRESSION_STATEMENT (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaSemanticAnalyzer* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaBlock* _tmp29_;
		ValaDeclarationStatement* _tmp30_;
		ValaDeclarationStatement* _tmp31_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp81_;
		ValaSemanticAnalyzer* _tmp82_;
		ValaList* _tmp83_;
		ValaCodeNode* _tmp84_;
		ValaCodeNode* _tmp85_;
		ValaExpressionStatement* _tmp86_;
		ValaExpression* _tmp87_;
		ValaExpression* _tmp88_;
		ValaExpressionStatement* _tmp89_;
		ValaExpression* _tmp90_;
		ValaExpression* _tmp91_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		tuple = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple);
		_tmp13_ = vala_code_node_get_temp_name ();
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_assignment_get_right (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_assignment_get_right (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (NULL, _tmp14_, _tmp16_, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp14_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = vala_code_context_get_analyzer (context);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_->insert_block;
		_tmp30_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp29_, (ValaStatement*) _tmp30_);
		_tmp31_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp31_, context);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp32_;
			ValaList* _tmp33_;
			gint _expr_size = 0;
			ValaList* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			gint _expr_index = 0;
			_tmp32_ = tuple;
			_tmp33_ = vala_tuple_get_expressions (_tmp32_);
			_expr_list = _tmp33_;
			_tmp34_ = _expr_list;
			_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
			_tmp36_ = _tmp35_;
			_expr_size = _tmp36_;
			_expr_index = -1;
			while (TRUE) {
				gint _tmp37_;
				gint _tmp38_;
				ValaExpression* expr = NULL;
				ValaList* _tmp39_;
				gpointer _tmp40_;
				ValaExpressionStatement* _tmp41_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp47_;
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				ValaExpression* _tmp50_;
				ValaExpression* _tmp51_;
				ValaSourceReference* _tmp52_;
				ValaSourceReference* _tmp53_;
				ValaMemberAccess* _tmp54_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp55_;
				ValaExpression* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaSourceReference* _tmp58_;
				ValaElementAccess* _tmp59_;
				ValaElementAccess* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				ValaExpression* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaSourceReference* _tmp65_;
				ValaIntegerLiteral* _tmp66_;
				ValaIntegerLiteral* _tmp67_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp68_;
				ValaElementAccess* _tmp69_;
				ValaAssignmentOperator _tmp70_;
				ValaExpression* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaAssignment* _tmp74_;
				ValaAssignment* _tmp75_;
				ValaExpression* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaSourceReference* _tmp78_;
				ValaExpressionStatement* _tmp79_;
				gint _tmp80_;
				_expr_index = _expr_index + 1;
				_tmp37_ = _expr_index;
				_tmp38_ = _expr_size;
				if (!(_tmp37_ < _tmp38_)) {
					break;
				}
				_tmp39_ = _expr_list;
				_tmp40_ = vala_list_get (_tmp39_, _expr_index);
				expr = (ValaExpression*) _tmp40_;
				_tmp41_ = stmt;
				if (_tmp41_ != NULL) {
					ValaSemanticAnalyzer* _tmp42_;
					ValaSemanticAnalyzer* _tmp43_;
					ValaBlock* _tmp44_;
					ValaExpressionStatement* _tmp45_;
					ValaExpressionStatement* _tmp46_;
					_tmp42_ = vala_code_context_get_analyzer (context);
					_tmp43_ = _tmp42_;
					_tmp44_ = _tmp43_->insert_block;
					_tmp45_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp44_, (ValaStatement*) _tmp45_);
					_tmp46_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp46_, context);
				}
				_tmp47_ = local;
				_tmp48_ = vala_symbol_get_name ((ValaSymbol*) _tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = vala_assignment_get_right (self);
				_tmp51_ = _tmp50_;
				_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_member_access_new_simple (_tmp49_, _tmp53_);
				temp_access = _tmp54_;
				_tmp55_ = temp_access;
				_tmp56_ = expr;
				_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = vala_element_access_new ((ValaExpression*) _tmp55_, _tmp58_);
				ea = _tmp59_;
				_tmp60_ = ea;
				_tmp61_ = g_strdup_printf ("%i", i);
				_tmp62_ = _tmp61_;
				_tmp63_ = expr;
				_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = vala_integer_literal_new (_tmp62_, _tmp65_);
				_tmp67_ = _tmp66_;
				vala_element_access_append_index (_tmp60_, (ValaExpression*) _tmp67_);
				_vala_code_node_unref0 (_tmp67_);
				_g_free0 (_tmp62_);
				_tmp68_ = expr;
				_tmp69_ = ea;
				_tmp70_ = self->priv->_operator;
				_tmp71_ = expr;
				_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_assignment_new (_tmp68_, (ValaExpression*) _tmp69_, _tmp70_, _tmp73_);
				assign = _tmp74_;
				_tmp75_ = assign;
				_tmp76_ = expr;
				_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = vala_expression_statement_new ((ValaExpression*) _tmp75_, _tmp78_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp79_;
				_tmp80_ = i;
				i = _tmp80_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
		}
		_tmp81_ = vala_code_context_get_analyzer (context);
		_tmp82_ = _tmp81_;
		_tmp83_ = _tmp82_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp83_, (ValaCodeNode*) self);
		_tmp84_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp85_ = _tmp84_;
		_tmp86_ = stmt;
		_tmp87_ = vala_expression_statement_get_expression (_tmp86_);
		_tmp88_ = _tmp87_;
		vala_code_node_replace_expression (_tmp85_, (ValaExpression*) self, _tmp88_);
		_tmp89_ = stmt;
		_tmp90_ = vala_expression_statement_get_expression (_tmp89_);
		_tmp91_ = _tmp90_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp91_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp92_ = vala_assignment_get_left (self);
	_tmp93_ = _tmp92_;
	vala_expression_set_lvalue (_tmp93_, TRUE);
	_tmp94_ = vala_assignment_get_left (self);
	_tmp95_ = _tmp94_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp95_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp96_ = vala_assignment_get_left (self);
	_tmp97_ = _tmp96_;
	if (VALA_IS_MEMBER_ACCESS (_tmp97_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp98_;
		ValaExpression* _tmp99_;
		ValaMemberAccess* _tmp100_;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		ValaMemberAccess* _tmp103_;
		ValaSymbol* _tmp104_;
		ValaSymbol* _tmp105_;
		ValaMemberAccess* _tmp121_;
		gboolean _tmp122_;
		gboolean _tmp123_;
		gboolean _tmp131_ = FALSE;
		ValaMemberAccess* _tmp132_;
		gboolean _tmp133_;
		gboolean _tmp134_;
		ValaMemberAccess* _tmp138_;
		ValaSymbol* _tmp139_;
		ValaSymbol* _tmp140_;
		ValaMemberAccess* _tmp148_;
		ValaSymbol* _tmp149_;
		ValaSymbol* _tmp150_;
		_tmp98_ = vala_assignment_get_left (self);
		_tmp99_ = _tmp98_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp100_ = ma;
		vala_assignment_check_constant_assignment (self, _tmp100_);
		_tmp103_ = ma;
		_tmp104_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp103_);
		_tmp105_ = _tmp104_;
		if (!VALA_IS_DYNAMIC_PROPERTY (_tmp105_)) {
			ValaMemberAccess* _tmp106_;
			ValaDataType* _tmp107_;
			ValaDataType* _tmp108_;
			_tmp106_ = ma;
			_tmp107_ = vala_expression_get_value_type ((ValaExpression*) _tmp106_);
			_tmp108_ = _tmp107_;
			_tmp102_ = _tmp108_ == NULL;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			_tmp101_ = TRUE;
		} else {
			gboolean _tmp109_ = FALSE;
			gboolean _tmp110_ = FALSE;
			ValaMemberAccess* _tmp111_;
			ValaExpression* _tmp112_;
			ValaExpression* _tmp113_;
			_tmp111_ = ma;
			_tmp112_ = vala_member_access_get_inner (_tmp111_);
			_tmp113_ = _tmp112_;
			if (_tmp113_ == NULL) {
				ValaMemberAccess* _tmp114_;
				const gchar* _tmp115_;
				const gchar* _tmp116_;
				_tmp114_ = ma;
				_tmp115_ = vala_member_access_get_member_name (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp110_ = g_strcmp0 (_tmp116_, "this") == 0;
			} else {
				_tmp110_ = FALSE;
			}
			if (_tmp110_) {
				ValaSemanticAnalyzer* _tmp117_;
				ValaSemanticAnalyzer* _tmp118_;
				_tmp117_ = vala_code_context_get_analyzer (context);
				_tmp118_ = _tmp117_;
				_tmp109_ = vala_semantic_analyzer_is_in_instance_method (_tmp118_);
			} else {
				_tmp109_ = FALSE;
			}
			_tmp101_ = _tmp109_;
		}
		if (_tmp101_) {
			ValaSourceReference* _tmp119_;
			ValaSourceReference* _tmp120_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp120_ = _tmp119_;
			vala_report_error (_tmp120_, "unsupported lvalue in assignment");
			result = FALSE;
			return result;
		}
		_tmp121_ = ma;
		_tmp122_ = vala_member_access_get_prototype_access (_tmp121_);
		_tmp123_ = _tmp122_;
		if (_tmp123_) {
			ValaSourceReference* _tmp124_;
			ValaSourceReference* _tmp125_;
			ValaMemberAccess* _tmp126_;
			ValaSymbol* _tmp127_;
			ValaSymbol* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp125_ = _tmp124_;
			_tmp126_ = ma;
			_tmp127_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp126_);
			_tmp128_ = _tmp127_;
			_tmp129_ = vala_symbol_get_full_name (_tmp128_);
			_tmp130_ = _tmp129_;
			vala_report_error (_tmp125_, "Access to instance member `%s' denied", _tmp130_);
			_g_free0 (_tmp130_);
			result = FALSE;
			return result;
		}
		_tmp132_ = ma;
		_tmp133_ = vala_code_node_get_error ((ValaCodeNode*) _tmp132_);
		_tmp134_ = _tmp133_;
		if (_tmp134_) {
			_tmp131_ = TRUE;
		} else {
			ValaMemberAccess* _tmp135_;
			ValaSymbol* _tmp136_;
			ValaSymbol* _tmp137_;
			_tmp135_ = ma;
			_tmp136_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp135_);
			_tmp137_ = _tmp136_;
			_tmp131_ = _tmp137_ == NULL;
		}
		if (_tmp131_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp138_ = ma;
		_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp138_);
		_tmp140_ = _tmp139_;
		if (vala_code_node_has_attribute ((ValaCodeNode*) _tmp140_, "GtkChild")) {
			ValaSourceReference* _tmp141_;
			ValaSourceReference* _tmp142_;
			ValaMemberAccess* _tmp143_;
			ValaSymbol* _tmp144_;
			ValaSymbol* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp142_ = _tmp141_;
			_tmp143_ = ma;
			_tmp144_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_symbol_get_full_name (_tmp145_);
			_tmp147_ = _tmp146_;
			vala_report_error (_tmp142_, "Assignment of [GtkChild] `%s' is not allowed", _tmp147_);
			_g_free0 (_tmp147_);
			result = FALSE;
			return result;
		}
		_tmp148_ = ma;
		_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp148_);
		_tmp150_ = _tmp149_;
		if (VALA_IS_DYNAMIC_PROPERTY (_tmp150_)) {
		} else {
			ValaExpression* _tmp151_;
			ValaExpression* _tmp152_;
			ValaMemberAccess* _tmp153_;
			ValaDataType* _tmp154_;
			ValaDataType* _tmp155_;
			ValaDataType* _tmp156_;
			ValaDataType* _tmp157_;
			ValaExpression* _tmp158_;
			ValaExpression* _tmp159_;
			ValaMemberAccess* _tmp160_;
			ValaDataType* _tmp161_;
			ValaDataType* _tmp162_;
			ValaDataType* _tmp163_;
			ValaDataType* _tmp164_;
			_tmp151_ = vala_assignment_get_right (self);
			_tmp152_ = _tmp151_;
			_tmp153_ = ma;
			_tmp154_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_data_type_copy (_tmp155_);
			_tmp157_ = _tmp156_;
			vala_expression_set_formal_target_type (_tmp152_, _tmp157_);
			_vala_code_node_unref0 (_tmp157_);
			_tmp158_ = vala_assignment_get_right (self);
			_tmp159_ = _tmp158_;
			_tmp160_ = ma;
			_tmp161_ = vala_expression_get_value_type ((ValaExpression*) _tmp160_);
			_tmp162_ = _tmp161_;
			_tmp163_ = vala_data_type_copy (_tmp162_);
			_tmp164_ = _tmp163_;
			vala_expression_set_target_type (_tmp159_, _tmp164_);
			_vala_code_node_unref0 (_tmp164_);
		}
	} else {
		ValaExpression* _tmp165_;
		ValaExpression* _tmp166_;
		_tmp165_ = vala_assignment_get_left (self);
		_tmp166_ = _tmp165_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp166_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp167_;
			ValaExpression* _tmp168_;
			ValaElementAccess* _tmp169_;
			ValaExpression* _tmp170_;
			ValaExpression* _tmp171_;
			ValaElementAccess* _tmp172_;
			ValaExpression* _tmp173_;
			ValaExpression* _tmp174_;
			ValaDataType* _tmp175_;
			ValaDataType* _tmp176_;
			ValaTypeSymbol* _tmp177_;
			ValaTypeSymbol* _tmp178_;
			ValaSemanticAnalyzer* _tmp179_;
			ValaSemanticAnalyzer* _tmp180_;
			ValaDataType* _tmp181_;
			ValaTypeSymbol* _tmp182_;
			ValaTypeSymbol* _tmp183_;
			_tmp167_ = vala_assignment_get_left (self);
			_tmp168_ = _tmp167_;
			ea = G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
			_tmp169_ = ea;
			_tmp170_ = vala_element_access_get_container (_tmp169_);
			_tmp171_ = _tmp170_;
			vala_assignment_check_constant_assignment (self, VALA_IS_MEMBER_ACCESS (_tmp171_) ? ((ValaMemberAccess*) _tmp171_) : NULL);
			_tmp172_ = ea;
			_tmp173_ = vala_element_access_get_container (_tmp172_);
			_tmp174_ = _tmp173_;
			_tmp175_ = vala_expression_get_value_type (_tmp174_);
			_tmp176_ = _tmp175_;
			_tmp177_ = vala_data_type_get_type_symbol (_tmp176_);
			_tmp178_ = _tmp177_;
			_tmp179_ = vala_code_context_get_analyzer (context);
			_tmp180_ = _tmp179_;
			_tmp181_ = _tmp180_->string_type;
			_tmp182_ = vala_data_type_get_type_symbol (_tmp181_);
			_tmp183_ = _tmp182_;
			if (_tmp178_ == _tmp183_) {
				ValaElementAccess* _tmp184_;
				ValaSourceReference* _tmp185_;
				ValaSourceReference* _tmp186_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp184_ = ea;
				_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp184_);
				_tmp186_ = _tmp185_;
				vala_report_error (_tmp186_, "strings are immutable");
				result = FALSE;
				return result;
			} else {
				ValaElementAccess* _tmp187_;
				ValaExpression* _tmp188_;
				ValaExpression* _tmp189_;
				ValaDataType* _tmp190_;
				ValaDataType* _tmp191_;
				ValaSymbol* _tmp192_;
				ValaSymbol* _tmp193_;
				gboolean _tmp194_;
				_tmp187_ = ea;
				_tmp188_ = vala_element_access_get_container (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp190_ = vala_expression_get_value_type (_tmp189_);
				_tmp191_ = _tmp190_;
				_tmp192_ = vala_data_type_get_member (_tmp191_, "set");
				_tmp193_ = _tmp192_;
				_tmp194_ = VALA_IS_METHOD (_tmp193_);
				_vala_code_node_unref0 (_tmp193_);
				if (_tmp194_) {
					ValaMethodCall* set_call = NULL;
					ValaElementAccess* _tmp195_;
					ValaExpression* _tmp196_;
					ValaExpression* _tmp197_;
					ValaSourceReference* _tmp198_;
					ValaSourceReference* _tmp199_;
					ValaMemberAccess* _tmp200_;
					ValaMemberAccess* _tmp201_;
					ValaSourceReference* _tmp202_;
					ValaSourceReference* _tmp203_;
					ValaMethodCall* _tmp204_;
					ValaMethodCall* _tmp205_;
					ValaMethodCall* _tmp217_;
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					ValaCodeNode* _tmp220_;
					ValaCodeNode* _tmp221_;
					ValaMethodCall* _tmp222_;
					ValaMethodCall* _tmp223_;
					_tmp195_ = ea;
					_tmp196_ = vala_element_access_get_container (_tmp195_);
					_tmp197_ = _tmp196_;
					_tmp198_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp199_ = _tmp198_;
					_tmp200_ = vala_member_access_new (_tmp197_, "set", _tmp199_);
					_tmp201_ = _tmp200_;
					_tmp202_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp203_ = _tmp202_;
					_tmp204_ = vala_method_call_new ((ValaExpression*) _tmp201_, _tmp203_);
					_tmp205_ = _tmp204_;
					_vala_code_node_unref0 (_tmp201_);
					set_call = _tmp205_;
					{
						ValaList* _e_list = NULL;
						ValaElementAccess* _tmp206_;
						ValaList* _tmp207_;
						gint _e_size = 0;
						ValaList* _tmp208_;
						gint _tmp209_;
						gint _tmp210_;
						gint _e_index = 0;
						_tmp206_ = ea;
						_tmp207_ = vala_element_access_get_indices (_tmp206_);
						_e_list = _tmp207_;
						_tmp208_ = _e_list;
						_tmp209_ = vala_collection_get_size ((ValaCollection*) _tmp208_);
						_tmp210_ = _tmp209_;
						_e_size = _tmp210_;
						_e_index = -1;
						while (TRUE) {
							gint _tmp211_;
							gint _tmp212_;
							ValaExpression* e = NULL;
							ValaList* _tmp213_;
							gpointer _tmp214_;
							ValaMethodCall* _tmp215_;
							ValaExpression* _tmp216_;
							_e_index = _e_index + 1;
							_tmp211_ = _e_index;
							_tmp212_ = _e_size;
							if (!(_tmp211_ < _tmp212_)) {
								break;
							}
							_tmp213_ = _e_list;
							_tmp214_ = vala_list_get (_tmp213_, _e_index);
							e = (ValaExpression*) _tmp214_;
							_tmp215_ = set_call;
							_tmp216_ = e;
							vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp215_, _tmp216_);
							_vala_code_node_unref0 (e);
						}
					}
					_tmp217_ = set_call;
					_tmp218_ = vala_assignment_get_right (self);
					_tmp219_ = _tmp218_;
					vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp217_, _tmp219_);
					_tmp220_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp221_ = _tmp220_;
					_tmp222_ = set_call;
					vala_code_node_replace_expression (_tmp221_, (ValaExpression*) self, (ValaExpression*) _tmp222_);
					_tmp223_ = set_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp223_, context);
					_vala_code_node_unref0 (set_call);
					return result;
				} else {
					ValaExpression* _tmp224_;
					ValaExpression* _tmp225_;
					ValaExpression* _tmp226_;
					ValaExpression* _tmp227_;
					ValaDataType* _tmp228_;
					ValaDataType* _tmp229_;
					ValaDataType* _tmp230_;
					ValaDataType* _tmp231_;
					_tmp224_ = vala_assignment_get_right (self);
					_tmp225_ = _tmp224_;
					_tmp226_ = vala_assignment_get_left (self);
					_tmp227_ = _tmp226_;
					_tmp228_ = vala_expression_get_value_type (_tmp227_);
					_tmp229_ = _tmp228_;
					_tmp230_ = vala_data_type_copy (_tmp229_);
					_tmp231_ = _tmp230_;
					vala_expression_set_target_type (_tmp225_, _tmp231_);
					_vala_code_node_unref0 (_tmp231_);
				}
			}
		} else {
			ValaExpression* _tmp232_;
			ValaExpression* _tmp233_;
			_tmp232_ = vala_assignment_get_left (self);
			_tmp233_ = _tmp232_;
			if (VALA_IS_POINTER_INDIRECTION (_tmp233_)) {
				ValaExpression* _tmp234_;
				ValaExpression* _tmp235_;
				ValaExpression* _tmp236_;
				ValaExpression* _tmp237_;
				ValaDataType* _tmp238_;
				ValaDataType* _tmp239_;
				ValaDataType* _tmp240_;
				ValaDataType* _tmp241_;
				_tmp234_ = vala_assignment_get_right (self);
				_tmp235_ = _tmp234_;
				_tmp236_ = vala_assignment_get_left (self);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_expression_get_value_type (_tmp237_);
				_tmp239_ = _tmp238_;
				_tmp240_ = vala_data_type_copy (_tmp239_);
				_tmp241_ = _tmp240_;
				vala_expression_set_target_type (_tmp235_, _tmp241_);
				_vala_code_node_unref0 (_tmp241_);
			} else {
				ValaExpression* _tmp242_;
				ValaExpression* _tmp243_;
				_tmp242_ = vala_assignment_get_left (self);
				_tmp243_ = _tmp242_;
				if (VALA_IS_LITERAL (_tmp243_)) {
					ValaSourceReference* _tmp244_;
					ValaSourceReference* _tmp245_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp244_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp245_ = _tmp244_;
					vala_report_error (_tmp245_, "Literals are immutable");
					result = FALSE;
					return result;
				} else {
					ValaSourceReference* _tmp246_;
					ValaSourceReference* _tmp247_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp246_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp247_ = _tmp246_;
					vala_report_error (_tmp247_, "unsupported lvalue in assignment");
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp248_ = vala_assignment_get_right (self);
	_tmp249_ = _tmp248_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp249_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp250_ = vala_assignment_get_left (self);
	_tmp251_ = _tmp250_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp251_) ? ((ValaMemberAccess*) _tmp251_) : NULL;
	_tmp252_ = vala_assignment_get_left (self);
	_tmp253_ = _tmp252_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp253_) ? ((ValaElementAccess*) _tmp253_) : NULL;
	transform_assignment = FALSE;
	_tmp255_ = ma;
	if (_tmp255_ != NULL) {
		ValaMemberAccess* _tmp256_;
		ValaSymbol* _tmp257_;
		ValaSymbol* _tmp258_;
		_tmp256_ = ma;
		_tmp257_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp256_);
		_tmp258_ = _tmp257_;
		_tmp254_ = !VALA_IS_LOCAL_VARIABLE (_tmp258_);
	} else {
		_tmp254_ = FALSE;
	}
	if (_tmp254_) {
		transform_assignment = TRUE;
	} else {
		gboolean _tmp259_ = FALSE;
		ValaExpression* _tmp260_;
		ValaExpression* _tmp261_;
		ValaDataType* _tmp262_;
		ValaDataType* _tmp263_;
		_tmp260_ = vala_assignment_get_left (self);
		_tmp261_ = _tmp260_;
		_tmp262_ = vala_expression_get_value_type (_tmp261_);
		_tmp263_ = _tmp262_;
		if (_tmp263_ != NULL) {
			ValaExpression* _tmp264_;
			ValaExpression* _tmp265_;
			ValaDataType* _tmp266_;
			ValaDataType* _tmp267_;
			_tmp264_ = vala_assignment_get_left (self);
			_tmp265_ = _tmp264_;
			_tmp266_ = vala_expression_get_value_type (_tmp265_);
			_tmp267_ = _tmp266_;
			_tmp259_ = !vala_data_type_is_non_null_simple_type (_tmp267_);
		} else {
			_tmp259_ = FALSE;
		}
		if (_tmp259_) {
			transform_assignment = TRUE;
		} else {
			gboolean _tmp268_ = FALSE;
			ValaElementAccess* _tmp269_;
			_tmp269_ = ea;
			if (_tmp269_ != NULL) {
				ValaElementAccess* _tmp270_;
				ValaExpression* _tmp271_;
				ValaExpression* _tmp272_;
				ValaDataType* _tmp273_;
				ValaDataType* _tmp274_;
				_tmp270_ = ea;
				_tmp271_ = vala_element_access_get_container (_tmp270_);
				_tmp272_ = _tmp271_;
				_tmp273_ = vala_expression_get_value_type (_tmp272_);
				_tmp274_ = _tmp273_;
				_tmp268_ = VALA_IS_ARRAY_TYPE (_tmp274_);
			} else {
				_tmp268_ = FALSE;
			}
			if (_tmp268_) {
				ValaArrayType* array_type = NULL;
				ValaElementAccess* _tmp275_;
				ValaExpression* _tmp276_;
				ValaExpression* _tmp277_;
				ValaDataType* _tmp278_;
				ValaDataType* _tmp279_;
				ValaArrayType* _tmp280_;
				ValaDataType* _tmp281_;
				ValaDataType* _tmp282_;
				_tmp275_ = ea;
				_tmp276_ = vala_element_access_get_container (_tmp275_);
				_tmp277_ = _tmp276_;
				_tmp278_ = vala_expression_get_value_type (_tmp277_);
				_tmp279_ = _tmp278_;
				array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp279_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp280_ = array_type;
				_tmp281_ = vala_array_type_get_element_type (_tmp280_);
				_tmp282_ = _tmp281_;
				transform_assignment = !vala_data_type_is_non_null_simple_type (_tmp282_);
			}
		}
	}
	_tmp284_ = self->priv->_operator;
	if (_tmp284_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		_tmp283_ = transform_assignment;
	} else {
		_tmp283_ = FALSE;
	}
	if (_tmp283_) {
		ValaExpression* old_value = NULL;
		ValaMemberAccess* _tmp285_;
		ValaBinaryOperator bop = 0;
		ValaAssignmentOperator _tmp319_;
		ValaBinaryExpression* bin = NULL;
		ValaExpression* _tmp322_;
		ValaExpression* _tmp323_;
		ValaExpression* _tmp324_;
		ValaSourceReference* _tmp325_;
		ValaSourceReference* _tmp326_;
		ValaBinaryExpression* _tmp327_;
		ValaBinaryExpression* _tmp328_;
		ValaExpression* _tmp329_;
		ValaExpression* _tmp330_;
		ValaDataType* _tmp331_;
		ValaDataType* _tmp332_;
		ValaExpression* _tmp333_;
		ValaExpression* _tmp334_;
		ValaExpression* _tmp335_;
		ValaExpression* _tmp336_;
		ValaDataType* _tmp337_;
		ValaDataType* _tmp338_;
		ValaDataType* _tmp339_;
		ValaDataType* _tmp340_;
		ValaExpression* _tmp341_;
		ValaExpression* _tmp342_;
		ValaDataType* _tmp343_;
		ValaDataType* _tmp344_;
		ValaBinaryExpression* _tmp345_;
		ValaExpression* _tmp346_;
		ValaExpression* _tmp347_;
		old_value = NULL;
		_tmp285_ = ma;
		if (_tmp285_ != NULL) {
			ValaMemberAccess* _tmp286_;
			ValaExpression* _tmp287_;
			ValaExpression* _tmp288_;
			ValaMemberAccess* _tmp289_;
			const gchar* _tmp290_;
			const gchar* _tmp291_;
			ValaExpression* _tmp292_;
			ValaExpression* _tmp293_;
			ValaSourceReference* _tmp294_;
			ValaSourceReference* _tmp295_;
			ValaMemberAccess* _tmp296_;
			_tmp286_ = ma;
			_tmp287_ = vala_member_access_get_inner (_tmp286_);
			_tmp288_ = _tmp287_;
			_tmp289_ = ma;
			_tmp290_ = vala_member_access_get_member_name (_tmp289_);
			_tmp291_ = _tmp290_;
			_tmp292_ = vala_assignment_get_left (self);
			_tmp293_ = _tmp292_;
			_tmp294_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp293_);
			_tmp295_ = _tmp294_;
			_tmp296_ = vala_member_access_new (_tmp288_, _tmp291_, _tmp295_);
			_vala_code_node_unref0 (old_value);
			old_value = (ValaExpression*) _tmp296_;
		} else {
			ValaElementAccess* _tmp297_;
			_tmp297_ = ea;
			if (_tmp297_ != NULL) {
				ValaElementAccess* _tmp298_;
				ValaExpression* _tmp299_;
				ValaExpression* _tmp300_;
				ValaExpression* _tmp301_;
				ValaExpression* _tmp302_;
				ValaSourceReference* _tmp303_;
				ValaSourceReference* _tmp304_;
				ValaElementAccess* _tmp305_;
				ValaList* indices = NULL;
				ValaElementAccess* _tmp306_;
				ValaList* _tmp307_;
				ValaList* _tmp308_;
				_tmp298_ = ea;
				_tmp299_ = vala_element_access_get_container (_tmp298_);
				_tmp300_ = _tmp299_;
				_tmp301_ = vala_assignment_get_left (self);
				_tmp302_ = _tmp301_;
				_tmp303_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp302_);
				_tmp304_ = _tmp303_;
				_tmp305_ = vala_element_access_new (_tmp300_, _tmp304_);
				_vala_code_node_unref0 (old_value);
				old_value = (ValaExpression*) _tmp305_;
				_tmp306_ = ea;
				_tmp307_ = vala_element_access_get_indices (_tmp306_);
				_tmp308_ = _vala_iterable_ref0 (_tmp307_);
				indices = _tmp308_;
				{
					ValaList* _index_list = NULL;
					ValaList* _tmp309_;
					gint _index_size = 0;
					ValaList* _tmp310_;
					gint _tmp311_;
					gint _tmp312_;
					gint _index_index = 0;
					_tmp309_ = indices;
					_index_list = _tmp309_;
					_tmp310_ = _index_list;
					_tmp311_ = vala_collection_get_size ((ValaCollection*) _tmp310_);
					_tmp312_ = _tmp311_;
					_index_size = _tmp312_;
					_index_index = -1;
					while (TRUE) {
						gint _tmp313_;
						gint _tmp314_;
						ValaExpression* index = NULL;
						ValaList* _tmp315_;
						gpointer _tmp316_;
						ValaExpression* _tmp317_;
						ValaExpression* _tmp318_;
						_index_index = _index_index + 1;
						_tmp313_ = _index_index;
						_tmp314_ = _index_size;
						if (!(_tmp313_ < _tmp314_)) {
							break;
						}
						_tmp315_ = _index_list;
						_tmp316_ = vala_list_get (_tmp315_, _index_index);
						index = (ValaExpression*) _tmp316_;
						_tmp317_ = old_value;
						_tmp318_ = index;
						vala_element_access_append_index (G_TYPE_CHECK_INSTANCE_CAST (_tmp317_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess), _tmp318_);
						_vala_code_node_unref0 (index);
					}
				}
				_vala_iterable_unref0 (indices);
			} else {
				g_assert_not_reached ();
			}
		}
		_tmp319_ = self->priv->_operator;
		switch (_tmp319_) {
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_OR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_AND;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_XOR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_ADD:
			{
				bop = VALA_BINARY_OPERATOR_PLUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SUB:
			{
				bop = VALA_BINARY_OPERATOR_MINUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_MUL:
			{
				bop = VALA_BINARY_OPERATOR_MUL;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_DIV:
			{
				bop = VALA_BINARY_OPERATOR_DIV;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_PERCENT:
			{
				bop = VALA_BINARY_OPERATOR_MOD;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_LEFT;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				break;
			}
			default:
			{
				ValaSourceReference* _tmp320_;
				ValaSourceReference* _tmp321_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp320_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp321_ = _tmp320_;
				vala_report_error (_tmp321_, "internal error: unsupported assignment operator");
				result = FALSE;
				_vala_code_node_unref0 (old_value);
				return result;
			}
		}
		_tmp322_ = old_value;
		_tmp323_ = vala_assignment_get_right (self);
		_tmp324_ = _tmp323_;
		_tmp325_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp326_ = _tmp325_;
		_tmp327_ = vala_binary_expression_new (bop, _tmp322_, _tmp324_, _tmp326_);
		bin = _tmp327_;
		_tmp328_ = bin;
		_tmp329_ = vala_assignment_get_right (self);
		_tmp330_ = _tmp329_;
		_tmp331_ = vala_expression_get_target_type (_tmp330_);
		_tmp332_ = _tmp331_;
		vala_expression_set_target_type ((ValaExpression*) _tmp328_, _tmp332_);
		_tmp333_ = vala_assignment_get_right (self);
		_tmp334_ = _tmp333_;
		_tmp335_ = vala_assignment_get_right (self);
		_tmp336_ = _tmp335_;
		_tmp337_ = vala_expression_get_target_type (_tmp336_);
		_tmp338_ = _tmp337_;
		_tmp339_ = vala_data_type_copy (_tmp338_);
		_tmp340_ = _tmp339_;
		vala_expression_set_target_type (_tmp334_, _tmp340_);
		_vala_code_node_unref0 (_tmp340_);
		_tmp341_ = vala_assignment_get_right (self);
		_tmp342_ = _tmp341_;
		_tmp343_ = vala_expression_get_target_type (_tmp342_);
		_tmp344_ = _tmp343_;
		vala_data_type_set_value_owned (_tmp344_, FALSE);
		_tmp345_ = bin;
		vala_assignment_set_right (self, (ValaExpression*) _tmp345_);
		_tmp346_ = vala_assignment_get_right (self);
		_tmp347_ = _tmp346_;
		vala_code_node_check ((ValaCodeNode*) _tmp347_, context);
		vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
		_vala_code_node_unref0 (bin);
		_vala_code_node_unref0 (old_value);
	}
	_tmp348_ = ma;
	if (_tmp348_ != NULL) {
		ValaMemberAccess* _tmp349_;
		ValaSymbol* _tmp350_;
		ValaSymbol* _tmp351_;
		gboolean _tmp474_ = FALSE;
		ValaExpression* _tmp475_;
		ValaExpression* _tmp476_;
		ValaDataType* _tmp477_;
		ValaDataType* _tmp478_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp562_;
		ValaExpression* _tmp563_;
		gboolean _tmp564_ = FALSE;
		ValaMemberAccess* _tmp565_;
		_tmp349_ = ma;
		_tmp350_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp349_);
		_tmp351_ = _tmp350_;
		if (VALA_IS_PROPERTY (_tmp351_)) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp352_;
			ValaSymbol* _tmp353_;
			ValaSymbol* _tmp354_;
			ValaExpression* _tmp355_;
			ValaExpression* _tmp356_;
			ValaDataType* _tmp357_;
			ValaDataType* _tmp358_;
			ValaDynamicProperty* dynamic_prop = NULL;
			ValaProperty* _tmp361_;
			ValaDynamicProperty* _tmp362_;
			_tmp352_ = ma;
			_tmp353_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp352_);
			_tmp354_ = _tmp353_;
			prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp354_, VALA_TYPE_PROPERTY, ValaProperty);
			_tmp355_ = vala_assignment_get_right (self);
			_tmp356_ = _tmp355_;
			_tmp357_ = vala_expression_get_value_type (_tmp356_);
			_tmp358_ = _tmp357_;
			if (_tmp358_ == NULL) {
				ValaSourceReference* _tmp359_;
				ValaSourceReference* _tmp360_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp359_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp360_ = _tmp359_;
				vala_report_error (_tmp360_, "Assignment: Invalid assignment attempt");
				result = FALSE;
				return result;
			}
			_tmp361_ = prop;
			dynamic_prop = VALA_IS_DYNAMIC_PROPERTY (_tmp361_) ? ((ValaDynamicProperty*) _tmp361_) : NULL;
			_tmp362_ = dynamic_prop;
			if (_tmp362_ != NULL) {
				ValaDynamicProperty* _tmp363_;
				ValaExpression* _tmp364_;
				ValaExpression* _tmp365_;
				ValaDataType* _tmp366_;
				ValaDataType* _tmp367_;
				ValaDataType* _tmp368_;
				ValaDataType* _tmp369_;
				ValaExpression* _tmp370_;
				ValaExpression* _tmp371_;
				ValaDynamicProperty* _tmp372_;
				ValaDataType* _tmp373_;
				ValaDataType* _tmp374_;
				ValaDataType* _tmp375_;
				ValaDataType* _tmp376_;
				_tmp363_ = dynamic_prop;
				_tmp364_ = vala_assignment_get_right (self);
				_tmp365_ = _tmp364_;
				_tmp366_ = vala_expression_get_value_type (_tmp365_);
				_tmp367_ = _tmp366_;
				_tmp368_ = vala_data_type_copy (_tmp367_);
				_tmp369_ = _tmp368_;
				vala_property_set_property_type ((ValaProperty*) _tmp363_, _tmp369_);
				_vala_code_node_unref0 (_tmp369_);
				_tmp370_ = vala_assignment_get_left (self);
				_tmp371_ = _tmp370_;
				_tmp372_ = dynamic_prop;
				_tmp373_ = vala_property_get_property_type ((ValaProperty*) _tmp372_);
				_tmp374_ = _tmp373_;
				_tmp375_ = vala_data_type_copy (_tmp374_);
				_tmp376_ = _tmp375_;
				vala_expression_set_value_type (_tmp371_, _tmp376_);
				_vala_code_node_unref0 (_tmp376_);
			}
		} else {
			gboolean _tmp377_ = FALSE;
			ValaMemberAccess* _tmp378_;
			ValaSymbol* _tmp379_;
			ValaSymbol* _tmp380_;
			_tmp378_ = ma;
			_tmp379_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp378_);
			_tmp380_ = _tmp379_;
			if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp380_)) {
				ValaMemberAccess* _tmp381_;
				ValaExpression* _tmp382_;
				ValaExpression* _tmp383_;
				ValaDataType* _tmp384_;
				ValaDataType* _tmp385_;
				gboolean _tmp386_;
				gboolean _tmp387_;
				_tmp381_ = ma;
				_tmp382_ = vala_member_access_get_inner (_tmp381_);
				_tmp383_ = _tmp382_;
				_tmp384_ = vala_expression_get_value_type (_tmp383_);
				_tmp385_ = _tmp384_;
				_tmp386_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp385_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp387_ = _tmp386_;
				_tmp377_ = _tmp387_;
			} else {
				_tmp377_ = FALSE;
			}
			if (_tmp377_) {
				ValaSourceReference* _tmp388_;
				ValaSourceReference* _tmp389_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp388_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp389_ = _tmp388_;
				vala_report_error (_tmp389_, "`length' field of fixed length arrays is read-only");
				result = FALSE;
				return result;
			} else {
				gboolean _tmp390_ = FALSE;
				ValaMemberAccess* _tmp391_;
				ValaSymbol* _tmp392_;
				ValaSymbol* _tmp393_;
				_tmp391_ = ma;
				_tmp392_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp391_);
				_tmp393_ = _tmp392_;
				if (VALA_IS_VARIABLE (_tmp393_)) {
					ValaExpression* _tmp394_;
					ValaExpression* _tmp395_;
					ValaDataType* _tmp396_;
					ValaDataType* _tmp397_;
					_tmp394_ = vala_assignment_get_right (self);
					_tmp395_ = _tmp394_;
					_tmp396_ = vala_expression_get_value_type (_tmp395_);
					_tmp397_ = _tmp396_;
					_tmp390_ = VALA_IS_METHOD_TYPE (_tmp397_);
				} else {
					_tmp390_ = FALSE;
				}
				if (_tmp390_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp398_;
					ValaSymbol* _tmp399_;
					ValaSymbol* _tmp400_;
					ValaVariable* _tmp401_;
					ValaDataType* _tmp402_;
					ValaDataType* _tmp403_;
					_tmp398_ = ma;
					_tmp399_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp398_);
					_tmp400_ = _tmp399_;
					variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp400_, VALA_TYPE_VARIABLE, ValaVariable);
					_tmp401_ = variable;
					_tmp402_ = vala_variable_get_variable_type (_tmp401_);
					_tmp403_ = _tmp402_;
					if (VALA_IS_DELEGATE_TYPE (_tmp403_)) {
						ValaExpression* _tmp404_;
						ValaExpression* _tmp405_;
						ValaDataType* _tmp406_;
						ValaDataType* _tmp407_;
						ValaVariable* _tmp408_;
						ValaDataType* _tmp409_;
						ValaDataType* _tmp410_;
						_tmp404_ = vala_assignment_get_right (self);
						_tmp405_ = _tmp404_;
						_tmp406_ = vala_expression_get_value_type (_tmp405_);
						_tmp407_ = _tmp406_;
						_tmp408_ = variable;
						_tmp409_ = vala_variable_get_variable_type (_tmp408_);
						_tmp410_ = _tmp409_;
						if (!vala_data_type_compatible (_tmp407_, _tmp410_)) {
							ValaMethod* m = NULL;
							ValaExpression* _tmp411_;
							ValaExpression* _tmp412_;
							ValaSymbol* _tmp413_;
							ValaSymbol* _tmp414_;
							ValaDelegate* cb = NULL;
							ValaVariable* _tmp415_;
							ValaDataType* _tmp416_;
							ValaDataType* _tmp417_;
							ValaDelegate* _tmp418_;
							ValaDelegate* _tmp419_;
							ValaSourceReference* _tmp420_;
							ValaSourceReference* _tmp421_;
							ValaMethod* _tmp422_;
							gchar* _tmp423_;
							gchar* _tmp424_;
							ValaDelegate* _tmp425_;
							gchar* _tmp426_;
							gchar* _tmp427_;
							_tmp411_ = vala_assignment_get_right (self);
							_tmp412_ = _tmp411_;
							_tmp413_ = vala_expression_get_symbol_reference (_tmp412_);
							_tmp414_ = _tmp413_;
							m = G_TYPE_CHECK_INSTANCE_CAST (_tmp414_, VALA_TYPE_METHOD, ValaMethod);
							_tmp415_ = variable;
							_tmp416_ = vala_variable_get_variable_type (_tmp415_);
							_tmp417_ = _tmp416_;
							_tmp418_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp417_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							_tmp419_ = _tmp418_;
							cb = _tmp419_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp420_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp421_ = _tmp420_;
							_tmp422_ = m;
							_tmp423_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp422_);
							_tmp424_ = _tmp423_;
							_tmp425_ = cb;
							_tmp426_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp425_);
							_tmp427_ = _tmp426_;
							vala_report_error (_tmp421_, "Declaration of method `%s' is not compatible with delegate `%s'", _tmp424_, _tmp427_);
							_g_free0 (_tmp427_);
							_g_free0 (_tmp424_);
							result = FALSE;
							return result;
						}
					} else {
						ValaSourceReference* _tmp428_;
						ValaSourceReference* _tmp429_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp428_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp429_ = _tmp428_;
						vala_report_error (_tmp429_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						return result;
					}
				} else {
					gboolean _tmp430_ = FALSE;
					ValaMemberAccess* _tmp431_;
					ValaSymbol* _tmp432_;
					ValaSymbol* _tmp433_;
					_tmp431_ = ma;
					_tmp432_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp431_);
					_tmp433_ = _tmp432_;
					if (VALA_IS_VARIABLE (_tmp433_)) {
						ValaExpression* _tmp434_;
						ValaExpression* _tmp435_;
						ValaDataType* _tmp436_;
						ValaDataType* _tmp437_;
						_tmp434_ = vala_assignment_get_right (self);
						_tmp435_ = _tmp434_;
						_tmp436_ = vala_expression_get_value_type (_tmp435_);
						_tmp437_ = _tmp436_;
						_tmp430_ = _tmp437_ == NULL;
					} else {
						_tmp430_ = FALSE;
					}
					if (_tmp430_) {
						ValaSourceReference* _tmp438_;
						ValaSourceReference* _tmp439_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp438_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp439_ = _tmp438_;
						vala_report_error (_tmp439_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						return result;
					} else {
						ValaMemberAccess* _tmp440_;
						ValaSymbol* _tmp441_;
						ValaSymbol* _tmp442_;
						_tmp440_ = ma;
						_tmp441_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp440_);
						_tmp442_ = _tmp441_;
						if (VALA_IS_VARIABLE (_tmp442_)) {
							ValaVariable* variable = NULL;
							ValaMemberAccess* _tmp443_;
							ValaSymbol* _tmp444_;
							ValaSymbol* _tmp445_;
							ValaArrayType* variable_array_type = NULL;
							ValaVariable* _tmp446_;
							ValaDataType* _tmp447_;
							ValaDataType* _tmp448_;
							gboolean _tmp449_ = FALSE;
							gboolean _tmp450_ = FALSE;
							gboolean _tmp451_ = FALSE;
							ValaArrayType* _tmp452_;
							_tmp443_ = ma;
							_tmp444_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp443_);
							_tmp445_ = _tmp444_;
							variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp445_, VALA_TYPE_VARIABLE, ValaVariable);
							_tmp446_ = variable;
							_tmp447_ = vala_variable_get_variable_type (_tmp446_);
							_tmp448_ = _tmp447_;
							variable_array_type = VALA_IS_ARRAY_TYPE (_tmp448_) ? ((ValaArrayType*) _tmp448_) : NULL;
							_tmp452_ = variable_array_type;
							if (_tmp452_ != NULL) {
								ValaArrayType* _tmp453_;
								gboolean _tmp454_;
								gboolean _tmp455_;
								_tmp453_ = variable_array_type;
								_tmp454_ = vala_array_type_get_inline_allocated (_tmp453_);
								_tmp455_ = _tmp454_;
								_tmp451_ = _tmp455_;
							} else {
								_tmp451_ = FALSE;
							}
							if (_tmp451_) {
								ValaExpression* _tmp456_;
								ValaExpression* _tmp457_;
								_tmp456_ = vala_assignment_get_right (self);
								_tmp457_ = _tmp456_;
								_tmp450_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp457_);
							} else {
								_tmp450_ = FALSE;
							}
							if (_tmp450_) {
								ValaExpression* _tmp458_;
								ValaExpression* _tmp459_;
								ValaInitializerList* _tmp460_;
								ValaInitializerList* _tmp461_;
								_tmp458_ = vala_assignment_get_right (self);
								_tmp459_ = _tmp458_;
								_tmp460_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp459_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
								_tmp461_ = _tmp460_;
								_tmp449_ = _tmp461_ == NULL;
							} else {
								_tmp449_ = FALSE;
							}
							if (_tmp449_) {
								ValaSourceReference* _tmp462_;
								ValaSourceReference* _tmp463_;
								ValaCodeNode* _tmp464_;
								ValaCodeNode* _tmp465_;
								ValaCodeNode* _tmp466_;
								ValaCodeNode* _tmp467_;
								ValaCodeNode* _tmp468_;
								ValaCodeNode* _tmp469_;
								ValaSourceReference* _tmp470_;
								ValaSourceReference* _tmp471_;
								ValaEmptyStatement* _tmp472_;
								ValaEmptyStatement* _tmp473_;
								_tmp462_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp463_ = _tmp462_;
								vala_report_warning (_tmp463_, "Inline allocated arrays don't require an explicit instantiation");
								_tmp464_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp465_ = _tmp464_;
								_tmp466_ = vala_code_node_get_parent_node (_tmp465_);
								_tmp467_ = _tmp466_;
								_tmp468_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp469_ = _tmp468_;
								_tmp470_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp471_ = _tmp470_;
								_tmp472_ = vala_empty_statement_new (_tmp471_);
								_tmp473_ = _tmp472_;
								vala_block_replace_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp467_, VALA_TYPE_BLOCK, ValaBlock), G_TYPE_CHECK_INSTANCE_CAST (_tmp469_, VALA_TYPE_STATEMENT, ValaStatement), (ValaStatement*) _tmp473_);
								_vala_code_node_unref0 (_tmp473_);
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
		_tmp475_ = vala_assignment_get_left (self);
		_tmp476_ = _tmp475_;
		_tmp477_ = vala_expression_get_value_type (_tmp476_);
		_tmp478_ = _tmp477_;
		if (_tmp478_ != NULL) {
			ValaExpression* _tmp479_;
			ValaExpression* _tmp480_;
			ValaDataType* _tmp481_;
			ValaDataType* _tmp482_;
			_tmp479_ = vala_assignment_get_right (self);
			_tmp480_ = _tmp479_;
			_tmp481_ = vala_expression_get_value_type (_tmp480_);
			_tmp482_ = _tmp481_;
			_tmp474_ = _tmp482_ != NULL;
		} else {
			_tmp474_ = FALSE;
		}
		if (_tmp474_) {
			ValaExpression* _tmp483_;
			ValaExpression* _tmp484_;
			ValaDataType* _tmp485_;
			ValaDataType* _tmp486_;
			ValaExpression* _tmp487_;
			ValaExpression* _tmp488_;
			ValaDataType* _tmp489_;
			ValaDataType* _tmp490_;
			ValaMemberAccess* _tmp536_;
			ValaSymbol* _tmp537_;
			ValaSymbol* _tmp538_;
			_tmp483_ = vala_assignment_get_right (self);
			_tmp484_ = _tmp483_;
			_tmp485_ = vala_expression_get_value_type (_tmp484_);
			_tmp486_ = _tmp485_;
			_tmp487_ = vala_assignment_get_left (self);
			_tmp488_ = _tmp487_;
			_tmp489_ = vala_expression_get_value_type (_tmp488_);
			_tmp490_ = _tmp489_;
			if (!vala_data_type_compatible (_tmp486_, _tmp490_)) {
				ValaSourceReference* _tmp491_;
				ValaSourceReference* _tmp492_;
				ValaExpression* _tmp493_;
				ValaExpression* _tmp494_;
				ValaDataType* _tmp495_;
				ValaDataType* _tmp496_;
				gchar* _tmp497_;
				gchar* _tmp498_;
				ValaExpression* _tmp499_;
				ValaExpression* _tmp500_;
				ValaDataType* _tmp501_;
				ValaDataType* _tmp502_;
				gchar* _tmp503_;
				gchar* _tmp504_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp492_ = _tmp491_;
				_tmp493_ = vala_assignment_get_right (self);
				_tmp494_ = _tmp493_;
				_tmp495_ = vala_expression_get_value_type (_tmp494_);
				_tmp496_ = _tmp495_;
				_tmp497_ = vala_code_node_to_string ((ValaCodeNode*) _tmp496_);
				_tmp498_ = _tmp497_;
				_tmp499_ = vala_assignment_get_left (self);
				_tmp500_ = _tmp499_;
				_tmp501_ = vala_expression_get_value_type (_tmp500_);
				_tmp502_ = _tmp501_;
				_tmp503_ = vala_code_node_to_string ((ValaCodeNode*) _tmp502_);
				_tmp504_ = _tmp503_;
				vala_report_error (_tmp492_, "Assignment: Cannot convert from `%s' to `%s'", _tmp498_, _tmp504_);
				_g_free0 (_tmp504_);
				_g_free0 (_tmp498_);
				result = FALSE;
				return result;
			} else {
				gboolean _tmp505_ = FALSE;
				gboolean _tmp506_ = FALSE;
				ValaExpression* _tmp507_;
				ValaExpression* _tmp508_;
				ValaDataType* _tmp509_;
				ValaDataType* _tmp510_;
				_tmp507_ = vala_assignment_get_left (self);
				_tmp508_ = _tmp507_;
				_tmp509_ = vala_expression_get_value_type (_tmp508_);
				_tmp510_ = _tmp509_;
				if (VALA_IS_ENUM_VALUE_TYPE (_tmp510_)) {
					ValaExpression* _tmp511_;
					ValaExpression* _tmp512_;
					ValaDataType* _tmp513_;
					ValaDataType* _tmp514_;
					_tmp511_ = vala_assignment_get_right (self);
					_tmp512_ = _tmp511_;
					_tmp513_ = vala_expression_get_value_type (_tmp512_);
					_tmp514_ = _tmp513_;
					_tmp506_ = VALA_IS_INTEGER_TYPE (_tmp514_);
				} else {
					_tmp506_ = FALSE;
				}
				if (_tmp506_) {
					gboolean _tmp515_ = FALSE;
					ValaExpression* _tmp516_;
					ValaExpression* _tmp517_;
					_tmp516_ = vala_assignment_get_right (self);
					_tmp517_ = _tmp516_;
					if (!VALA_IS_INTEGER_LITERAL (_tmp517_)) {
						_tmp515_ = TRUE;
					} else {
						ValaExpression* _tmp518_;
						ValaExpression* _tmp519_;
						const gchar* _tmp520_;
						const gchar* _tmp521_;
						_tmp518_ = vala_assignment_get_right (self);
						_tmp519_ = _tmp518_;
						_tmp520_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp519_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
						_tmp521_ = _tmp520_;
						_tmp515_ = g_strcmp0 (_tmp521_, "0") != 0;
					}
					_tmp505_ = _tmp515_;
				} else {
					_tmp505_ = FALSE;
				}
				if (_tmp505_) {
					ValaSourceReference* _tmp522_;
					ValaSourceReference* _tmp523_;
					ValaExpression* _tmp524_;
					ValaExpression* _tmp525_;
					ValaDataType* _tmp526_;
					ValaDataType* _tmp527_;
					gchar* _tmp528_;
					gchar* _tmp529_;
					ValaExpression* _tmp530_;
					ValaExpression* _tmp531_;
					ValaDataType* _tmp532_;
					ValaDataType* _tmp533_;
					gchar* _tmp534_;
					gchar* _tmp535_;
					_tmp522_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp523_ = _tmp522_;
					_tmp524_ = vala_assignment_get_right (self);
					_tmp525_ = _tmp524_;
					_tmp526_ = vala_expression_get_value_type (_tmp525_);
					_tmp527_ = _tmp526_;
					_tmp528_ = vala_code_node_to_string ((ValaCodeNode*) _tmp527_);
					_tmp529_ = _tmp528_;
					_tmp530_ = vala_assignment_get_left (self);
					_tmp531_ = _tmp530_;
					_tmp532_ = vala_expression_get_value_type (_tmp531_);
					_tmp533_ = _tmp532_;
					_tmp534_ = vala_code_node_to_string ((ValaCodeNode*) _tmp533_);
					_tmp535_ = _tmp534_;
					vala_report_notice (_tmp523_, "Assignment: Unsafe conversion from `%s' to `%s'", _tmp529_, _tmp535_);
					_g_free0 (_tmp535_);
					_g_free0 (_tmp529_);
				}
			}
			_tmp536_ = ma;
			_tmp537_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp536_);
			_tmp538_ = _tmp537_;
			if (!VALA_IS_PROPERTY (_tmp538_)) {
				ValaExpression* _tmp539_;
				ValaExpression* _tmp540_;
				ValaDataType* _tmp541_;
				ValaDataType* _tmp542_;
				_tmp539_ = vala_assignment_get_right (self);
				_tmp540_ = _tmp539_;
				_tmp541_ = vala_expression_get_value_type (_tmp540_);
				_tmp542_ = _tmp541_;
				if (vala_data_type_is_disposable (_tmp542_)) {
					gboolean _tmp543_ = FALSE;
					ValaExpression* _tmp544_;
					ValaExpression* _tmp545_;
					ValaDataType* _tmp546_;
					ValaDataType* _tmp547_;
					_tmp544_ = vala_assignment_get_left (self);
					_tmp545_ = _tmp544_;
					_tmp546_ = vala_expression_get_value_type (_tmp545_);
					_tmp547_ = _tmp546_;
					if (!VALA_IS_POINTER_TYPE (_tmp547_)) {
						ValaExpression* _tmp548_;
						ValaExpression* _tmp549_;
						ValaDataType* _tmp550_;
						ValaDataType* _tmp551_;
						gboolean _tmp552_;
						gboolean _tmp553_;
						_tmp548_ = vala_assignment_get_left (self);
						_tmp549_ = _tmp548_;
						_tmp550_ = vala_expression_get_value_type (_tmp549_);
						_tmp551_ = _tmp550_;
						_tmp552_ = vala_data_type_get_value_owned (_tmp551_);
						_tmp553_ = _tmp552_;
						_tmp543_ = !_tmp553_;
					} else {
						_tmp543_ = FALSE;
					}
					if (_tmp543_) {
						ValaSourceReference* _tmp554_;
						ValaSourceReference* _tmp555_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp554_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp555_ = _tmp554_;
						vala_report_error (_tmp555_, "Invalid assignment from owned expression to unowned variable");
					}
				} else {
					ValaExpression* _tmp556_;
					ValaExpression* _tmp557_;
					ValaDataType* _tmp558_;
					ValaDataType* _tmp559_;
					gboolean _tmp560_;
					gboolean _tmp561_;
					_tmp556_ = vala_assignment_get_left (self);
					_tmp557_ = _tmp556_;
					_tmp558_ = vala_expression_get_value_type (_tmp557_);
					_tmp559_ = _tmp558_;
					_tmp560_ = vala_data_type_get_value_owned (_tmp559_);
					_tmp561_ = _tmp560_;
					if (_tmp561_) {
					}
				}
			}
		}
		_tmp562_ = vala_assignment_get_right (self);
		_tmp563_ = _tmp562_;
		right_ma = VALA_IS_MEMBER_ACCESS (_tmp563_) ? ((ValaMemberAccess*) _tmp563_) : NULL;
		_tmp565_ = right_ma;
		if (_tmp565_ != NULL) {
			ValaMemberAccess* _tmp566_;
			ValaSymbol* _tmp567_;
			ValaSymbol* _tmp568_;
			ValaMemberAccess* _tmp569_;
			ValaSymbol* _tmp570_;
			ValaSymbol* _tmp571_;
			_tmp566_ = ma;
			_tmp567_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp566_);
			_tmp568_ = _tmp567_;
			_tmp569_ = right_ma;
			_tmp570_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp569_);
			_tmp571_ = _tmp570_;
			_tmp564_ = _tmp568_ == _tmp571_;
		} else {
			_tmp564_ = FALSE;
		}
		if (_tmp564_) {
			gboolean _tmp572_ = FALSE;
			ValaMemberAccess* _tmp573_;
			ValaSymbol* _tmp574_;
			ValaSymbol* _tmp575_;
			_tmp573_ = ma;
			_tmp574_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp573_);
			_tmp575_ = _tmp574_;
			if (VALA_IS_LOCAL_VARIABLE (_tmp575_)) {
				_tmp572_ = TRUE;
			} else {
				ValaMemberAccess* _tmp576_;
				ValaSymbol* _tmp577_;
				ValaSymbol* _tmp578_;
				_tmp576_ = ma;
				_tmp577_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp576_);
				_tmp578_ = _tmp577_;
				_tmp572_ = VALA_IS_PARAMETER (_tmp578_);
			}
			if (_tmp572_) {
				ValaSourceReference* _tmp579_;
				ValaSourceReference* _tmp580_;
				_tmp579_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp580_ = _tmp579_;
				vala_report_warning (_tmp580_, "Assignment to same variable");
			} else {
				ValaMemberAccess* _tmp581_;
				ValaSymbol* _tmp582_;
				ValaSymbol* _tmp583_;
				_tmp581_ = ma;
				_tmp582_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp581_);
				_tmp583_ = _tmp582_;
				if (VALA_IS_FIELD (_tmp583_)) {
					ValaField* f = NULL;
					ValaMemberAccess* _tmp584_;
					ValaSymbol* _tmp585_;
					ValaSymbol* _tmp586_;
					ValaField* _tmp587_;
					ValaMemberBinding _tmp588_;
					ValaMemberBinding _tmp589_;
					_tmp584_ = ma;
					_tmp585_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp584_);
					_tmp586_ = _tmp585_;
					f = G_TYPE_CHECK_INSTANCE_CAST (_tmp586_, VALA_TYPE_FIELD, ValaField);
					_tmp587_ = f;
					_tmp588_ = vala_field_get_binding (_tmp587_);
					_tmp589_ = _tmp588_;
					if (_tmp589_ == VALA_MEMBER_BINDING_STATIC) {
						ValaSourceReference* _tmp590_;
						ValaSourceReference* _tmp591_;
						_tmp590_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp591_ = _tmp590_;
						vala_report_warning (_tmp591_, "Assignment to same variable");
					} else {
						ValaMemberAccess* ma_inner = NULL;
						ValaMemberAccess* _tmp592_;
						ValaExpression* _tmp593_;
						ValaExpression* _tmp594_;
						ValaMemberAccess* right_ma_inner = NULL;
						ValaMemberAccess* _tmp595_;
						ValaExpression* _tmp596_;
						ValaExpression* _tmp597_;
						gboolean _tmp598_ = FALSE;
						gboolean _tmp599_ = FALSE;
						gboolean _tmp600_ = FALSE;
						gboolean _tmp601_ = FALSE;
						gboolean _tmp602_ = FALSE;
						ValaMemberAccess* _tmp603_;
						_tmp592_ = ma;
						_tmp593_ = vala_member_access_get_inner (_tmp592_);
						_tmp594_ = _tmp593_;
						ma_inner = VALA_IS_MEMBER_ACCESS (_tmp594_) ? ((ValaMemberAccess*) _tmp594_) : NULL;
						_tmp595_ = right_ma;
						_tmp596_ = vala_member_access_get_inner (_tmp595_);
						_tmp597_ = _tmp596_;
						right_ma_inner = VALA_IS_MEMBER_ACCESS (_tmp597_) ? ((ValaMemberAccess*) _tmp597_) : NULL;
						_tmp603_ = ma_inner;
						if (_tmp603_ != NULL) {
							ValaMemberAccess* _tmp604_;
							const gchar* _tmp605_;
							const gchar* _tmp606_;
							_tmp604_ = ma_inner;
							_tmp605_ = vala_member_access_get_member_name (_tmp604_);
							_tmp606_ = _tmp605_;
							_tmp602_ = g_strcmp0 (_tmp606_, "this") == 0;
						} else {
							_tmp602_ = FALSE;
						}
						if (_tmp602_) {
							ValaMemberAccess* _tmp607_;
							ValaExpression* _tmp608_;
							ValaExpression* _tmp609_;
							_tmp607_ = ma_inner;
							_tmp608_ = vala_member_access_get_inner (_tmp607_);
							_tmp609_ = _tmp608_;
							_tmp601_ = _tmp609_ == NULL;
						} else {
							_tmp601_ = FALSE;
						}
						if (_tmp601_) {
							ValaMemberAccess* _tmp610_;
							_tmp610_ = right_ma_inner;
							_tmp600_ = _tmp610_ != NULL;
						} else {
							_tmp600_ = FALSE;
						}
						if (_tmp600_) {
							ValaMemberAccess* _tmp611_;
							const gchar* _tmp612_;
							const gchar* _tmp613_;
							_tmp611_ = right_ma_inner;
							_tmp612_ = vala_member_access_get_member_name (_tmp611_);
							_tmp613_ = _tmp612_;
							_tmp599_ = g_strcmp0 (_tmp613_, "this") == 0;
						} else {
							_tmp599_ = FALSE;
						}
						if (_tmp599_) {
							ValaMemberAccess* _tmp614_;
							ValaExpression* _tmp615_;
							ValaExpression* _tmp616_;
							_tmp614_ = right_ma_inner;
							_tmp615_ = vala_member_access_get_inner (_tmp614_);
							_tmp616_ = _tmp615_;
							_tmp598_ = _tmp616_ == NULL;
						} else {
							_tmp598_ = FALSE;
						}
						if (_tmp598_) {
							ValaSourceReference* _tmp617_;
							ValaSourceReference* _tmp618_;
							_tmp617_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp618_ = _tmp617_;
							vala_report_warning (_tmp618_, "Assignment to same variable");
						}
					}
				}
			}
		}
	} else {
		ValaElementAccess* _tmp619_;
		_tmp619_ = ea;
		if (_tmp619_ != NULL) {
			ValaExpression* _tmp620_;
			ValaExpression* _tmp621_;
			ValaDataType* _tmp622_;
			ValaDataType* _tmp623_;
			ValaExpression* _tmp624_;
			ValaExpression* _tmp625_;
			ValaDataType* _tmp626_;
			ValaDataType* _tmp627_;
			ValaExpression* _tmp642_;
			ValaExpression* _tmp643_;
			ValaDataType* _tmp644_;
			ValaDataType* _tmp645_;
			_tmp620_ = vala_assignment_get_right (self);
			_tmp621_ = _tmp620_;
			_tmp622_ = vala_expression_get_value_type (_tmp621_);
			_tmp623_ = _tmp622_;
			_tmp624_ = vala_assignment_get_left (self);
			_tmp625_ = _tmp624_;
			_tmp626_ = vala_expression_get_value_type (_tmp625_);
			_tmp627_ = _tmp626_;
			if (!vala_data_type_compatible (_tmp623_, _tmp627_)) {
				ValaSourceReference* _tmp628_;
				ValaSourceReference* _tmp629_;
				ValaExpression* _tmp630_;
				ValaExpression* _tmp631_;
				ValaDataType* _tmp632_;
				ValaDataType* _tmp633_;
				gchar* _tmp634_;
				gchar* _tmp635_;
				ValaExpression* _tmp636_;
				ValaExpression* _tmp637_;
				ValaDataType* _tmp638_;
				ValaDataType* _tmp639_;
				gchar* _tmp640_;
				gchar* _tmp641_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp628_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp629_ = _tmp628_;
				_tmp630_ = vala_assignment_get_right (self);
				_tmp631_ = _tmp630_;
				_tmp632_ = vala_expression_get_value_type (_tmp631_);
				_tmp633_ = _tmp632_;
				_tmp634_ = vala_code_node_to_string ((ValaCodeNode*) _tmp633_);
				_tmp635_ = _tmp634_;
				_tmp636_ = vala_assignment_get_left (self);
				_tmp637_ = _tmp636_;
				_tmp638_ = vala_expression_get_value_type (_tmp637_);
				_tmp639_ = _tmp638_;
				_tmp640_ = vala_code_node_to_string ((ValaCodeNode*) _tmp639_);
				_tmp641_ = _tmp640_;
				vala_report_error (_tmp629_, "Assignment: Cannot convert from `%s' to `%s'", _tmp635_, _tmp641_);
				_g_free0 (_tmp641_);
				_g_free0 (_tmp635_);
				result = FALSE;
				return result;
			}
			_tmp642_ = vala_assignment_get_right (self);
			_tmp643_ = _tmp642_;
			_tmp644_ = vala_expression_get_value_type (_tmp643_);
			_tmp645_ = _tmp644_;
			if (vala_data_type_is_disposable (_tmp645_)) {
				ValaDataType* element_type = NULL;
				ValaElementAccess* _tmp646_;
				ValaExpression* _tmp647_;
				ValaExpression* _tmp648_;
				ValaDataType* _tmp649_;
				ValaDataType* _tmp650_;
				gboolean _tmp672_ = FALSE;
				ValaDataType* _tmp673_;
				_tmp646_ = ea;
				_tmp647_ = vala_element_access_get_container (_tmp646_);
				_tmp648_ = _tmp647_;
				_tmp649_ = vala_expression_get_value_type (_tmp648_);
				_tmp650_ = _tmp649_;
				if (VALA_IS_ARRAY_TYPE (_tmp650_)) {
					ValaArrayType* array_type = NULL;
					ValaElementAccess* _tmp651_;
					ValaExpression* _tmp652_;
					ValaExpression* _tmp653_;
					ValaDataType* _tmp654_;
					ValaDataType* _tmp655_;
					ValaArrayType* _tmp656_;
					ValaDataType* _tmp657_;
					ValaDataType* _tmp658_;
					ValaDataType* _tmp659_;
					_tmp651_ = ea;
					_tmp652_ = vala_element_access_get_container (_tmp651_);
					_tmp653_ = _tmp652_;
					_tmp654_ = vala_expression_get_value_type (_tmp653_);
					_tmp655_ = _tmp654_;
					array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp655_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
					_tmp656_ = array_type;
					_tmp657_ = vala_array_type_get_element_type (_tmp656_);
					_tmp658_ = _tmp657_;
					_tmp659_ = _vala_code_node_ref0 (_tmp658_);
					_vala_code_node_unref0 (element_type);
					element_type = _tmp659_;
				} else {
					ValaList* args = NULL;
					ValaElementAccess* _tmp660_;
					ValaExpression* _tmp661_;
					ValaExpression* _tmp662_;
					ValaDataType* _tmp663_;
					ValaDataType* _tmp664_;
					ValaList* _tmp665_;
					ValaList* _tmp666_;
					ValaList* _tmp667_;
					gint _tmp668_;
					gint _tmp669_;
					ValaList* _tmp670_;
					gpointer _tmp671_;
					_tmp660_ = ea;
					_tmp661_ = vala_element_access_get_container (_tmp660_);
					_tmp662_ = _tmp661_;
					_tmp663_ = vala_expression_get_value_type (_tmp662_);
					_tmp664_ = _tmp663_;
					_tmp665_ = vala_data_type_get_type_arguments (_tmp664_);
					_tmp666_ = _vala_iterable_ref0 (_tmp665_);
					args = _tmp666_;
					_tmp667_ = args;
					_tmp668_ = vala_collection_get_size ((ValaCollection*) _tmp667_);
					_tmp669_ = _tmp668_;
					_vala_assert (_tmp669_ == 1, "args.size == 1");
					_tmp670_ = args;
					_tmp671_ = vala_list_get (_tmp670_, 0);
					_vala_code_node_unref0 (element_type);
					element_type = (ValaDataType*) _tmp671_;
					_vala_iterable_unref0 (args);
				}
				_tmp673_ = element_type;
				if (!VALA_IS_POINTER_TYPE (_tmp673_)) {
					ValaDataType* _tmp674_;
					gboolean _tmp675_;
					gboolean _tmp676_;
					_tmp674_ = element_type;
					_tmp675_ = vala_data_type_get_value_owned (_tmp674_);
					_tmp676_ = _tmp675_;
					_tmp672_ = !_tmp676_;
				} else {
					_tmp672_ = FALSE;
				}
				if (_tmp672_) {
					ValaSourceReference* _tmp677_;
					ValaSourceReference* _tmp678_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp677_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp678_ = _tmp677_;
					vala_report_error (_tmp678_, "Invalid assignment from owned expression to unowned variable");
					result = FALSE;
					_vala_code_node_unref0 (element_type);
					return result;
				}
				_vala_code_node_unref0 (element_type);
			} else {
				ValaExpression* _tmp679_;
				ValaExpression* _tmp680_;
				ValaDataType* _tmp681_;
				ValaDataType* _tmp682_;
				gboolean _tmp683_;
				gboolean _tmp684_;
				_tmp679_ = vala_assignment_get_left (self);
				_tmp680_ = _tmp679_;
				_tmp681_ = vala_expression_get_value_type (_tmp680_);
				_tmp682_ = _tmp681_;
				_tmp683_ = vala_data_type_get_value_owned (_tmp682_);
				_tmp684_ = _tmp683_;
				if (_tmp684_) {
				}
			}
		} else {
			result = TRUE;
			return result;
		}
	}
	_tmp685_ = vala_assignment_get_left (self);
	_tmp686_ = _tmp685_;
	_tmp687_ = vala_expression_get_value_type (_tmp686_);
	_tmp688_ = _tmp687_;
	if (_tmp688_ != NULL) {
		ValaExpression* _tmp689_;
		ValaExpression* _tmp690_;
		ValaDataType* _tmp691_;
		ValaDataType* _tmp692_;
		ValaDataType* _tmp693_;
		ValaDataType* _tmp694_;
		ValaDataType* _tmp695_;
		ValaDataType* _tmp696_;
		_tmp689_ = vala_assignment_get_left (self);
		_tmp690_ = _tmp689_;
		_tmp691_ = vala_expression_get_value_type (_tmp690_);
		_tmp692_ = _tmp691_;
		_tmp693_ = vala_data_type_copy (_tmp692_);
		_tmp694_ = _tmp693_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp694_);
		_vala_code_node_unref0 (_tmp694_);
		_tmp695_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp696_ = _tmp695_;
		vala_data_type_set_value_owned (_tmp696_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp697_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp698_ = _tmp697_;
	if (_tmp698_ != NULL) {
		ValaDataType* _tmp699_;
		ValaDataType* _tmp700_;
		_tmp699_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp700_ = _tmp699_;
		vala_code_node_check ((ValaCodeNode*) _tmp700_, context);
	}
	_tmp701_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp702_ = _tmp701_;
	result = !_tmp702_;
	return result;
}

static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaBinaryExpression* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	binary = VALA_IS_BINARY_EXPRESSION (_tmp1_) ? ((ValaBinaryExpression*) _tmp1_) : NULL;
	_tmp3_ = binary;
	if (_tmp3_ != NULL) {
		ValaBinaryExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp4_ = binary;
		_tmp5_ = vala_binary_expression_get_left (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_expression_get_value_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = VALA_IS_ARRAY_TYPE (_tmp8_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaBinaryExpression* _tmp9_;
		ValaBinaryOperator _tmp10_;
		ValaBinaryOperator _tmp11_;
		_tmp9_ = binary;
		_tmp10_ = vala_binary_expression_get_operator (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaBinaryExpression* _tmp16_;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			_tmp12_ = vala_assignment_get_left (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_expression_get_symbol_reference (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = binary;
			_tmp17_ = vala_binary_expression_get_left (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_expression_get_symbol_reference (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp15_ == _tmp20_) {
				ValaBinaryExpression* _tmp21_;
				ValaExpression* _tmp22_;
				ValaExpression* _tmp23_;
				_tmp21_ = binary;
				_tmp22_ = vala_binary_expression_get_left (_tmp21_);
				_tmp23_ = _tmp22_;
				vala_expression_set_lvalue (_tmp23_, TRUE);
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static void
vala_assignment_check_constant_assignment (ValaAssignment* self,
                                           ValaMemberAccess* inner)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		if (!(inner != NULL)) {
			break;
		}
		_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) inner);
		_tmp1_ = _tmp0_;
		if (VALA_IS_CONSTANT (_tmp1_)) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			vala_report_error (_tmp3_, "Assignment to constant after initialization");
			break;
		}
		_tmp4_ = vala_member_access_get_inner (inner);
		_tmp5_ = _tmp4_;
		if (VALA_IS_MEMBER_ACCESS (_tmp5_)) {
			ValaExpression* _tmp6_;
			ValaExpression* _tmp7_;
			_tmp6_ = vala_member_access_get_inner (inner);
			_tmp7_ = _tmp6_;
			inner = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		} else {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (inner);
			_tmp9_ = _tmp8_;
			if (VALA_IS_ELEMENT_ACCESS (_tmp9_)) {
				ValaExpression* _tmp10_;
				ValaExpression* _tmp11_;
				ValaExpression* _tmp12_;
				ValaExpression* _tmp13_;
				_tmp10_ = vala_member_access_get_inner (inner);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_element_access_get_container (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				_tmp13_ = _tmp12_;
				inner = VALA_IS_MEMBER_ACCESS (_tmp13_) ? ((ValaMemberAccess*) _tmp13_) : NULL;
			} else {
				inner = NULL;
			}
		}
	}
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaExpression* _tmp130_;
	ValaExpression* _tmp131_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	pi = VALA_IS_POINTER_INDIRECTION (_tmp5_) ? ((ValaPointerIndirection*) _tmp5_) : NULL;
	_tmp6_ = ma;
	if (_tmp6_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp13_;
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		ValaField* _tmp21_;
		gboolean instance = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		ValaAssignmentOperator _tmp36_;
		gboolean _tmp115_ = FALSE;
		gboolean _tmp116_ = FALSE;
		_tmp7_ = ma;
		_tmp8_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp7_);
		_tmp9_ = _tmp8_;
		local = VALA_IS_LOCAL_VARIABLE (_tmp9_) ? ((ValaLocalVariable*) _tmp9_) : NULL;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		param = VALA_IS_PARAMETER (_tmp12_) ? ((ValaParameter*) _tmp12_) : NULL;
		_tmp13_ = ma;
		_tmp14_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp13_);
		_tmp15_ = _tmp14_;
		field = VALA_IS_FIELD (_tmp15_) ? ((ValaField*) _tmp15_) : NULL;
		_tmp16_ = ma;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
		_tmp18_ = _tmp17_;
		property = VALA_IS_PROPERTY (_tmp18_) ? ((ValaProperty*) _tmp18_) : NULL;
		_tmp21_ = field;
		if (_tmp21_ != NULL) {
			ValaField* _tmp22_;
			ValaMemberBinding _tmp23_;
			ValaMemberBinding _tmp24_;
			_tmp22_ = field;
			_tmp23_ = vala_field_get_binding (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp20_ = _tmp24_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gboolean _tmp25_ = FALSE;
			ValaProperty* _tmp26_;
			_tmp26_ = property;
			if (_tmp26_ != NULL) {
				ValaProperty* _tmp27_;
				ValaMemberBinding _tmp28_;
				ValaMemberBinding _tmp29_;
				_tmp27_ = property;
				_tmp28_ = vala_property_get_binding (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp25_ = _tmp29_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp19_ = _tmp25_;
		}
		instance = _tmp19_;
		_tmp36_ = self->priv->_operator;
		if (_tmp36_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_ = FALSE;
			ValaLocalVariable* _tmp39_;
			_tmp39_ = local;
			if (_tmp39_ != NULL) {
				_tmp38_ = TRUE;
			} else {
				ValaParameter* _tmp40_;
				_tmp40_ = param;
				_tmp38_ = _tmp40_ != NULL;
			}
			if (_tmp38_) {
				_tmp37_ = TRUE;
			} else {
				ValaField* _tmp41_;
				_tmp41_ = field;
				_tmp37_ = _tmp41_ != NULL;
			}
			_tmp35_ = _tmp37_;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			_tmp34_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			ValaField* _tmp42_;
			_tmp42_ = field;
			_tmp33_ = !VALA_IS_ARRAY_LENGTH_FIELD (_tmp42_);
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			ValaField* _tmp43_;
			_tmp43_ = field;
			_tmp32_ = !VALA_IS_DELEGATE_TARGET_FIELD (_tmp43_);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaField* _tmp44_;
			_tmp44_ = field;
			_tmp31_ = !VALA_IS_DELEGATE_DESTROY_FIELD (_tmp44_);
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			gboolean _tmp45_ = FALSE;
			ValaExpression* _tmp46_;
			ValaExpression* _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp49_;
			_tmp46_ = vala_assignment_get_left (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_expression_get_value_type (_tmp47_);
			_tmp49_ = _tmp48_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp49_)) {
				ValaExpression* _tmp50_;
				ValaExpression* _tmp51_;
				_tmp50_ = vala_assignment_get_right (self);
				_tmp51_ = _tmp50_;
				_tmp45_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp51_);
			} else {
				_tmp45_ = FALSE;
			}
			_tmp30_ = !_tmp45_;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			gboolean _tmp52_ = FALSE;
			ValaExpression* _tmp59_;
			ValaExpression* _tmp60_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp61_;
			ValaExpression* _tmp62_;
			ValaTargetValue* _tmp63_;
			ValaTargetValue* _tmp64_;
			ValaTargetValue* _tmp65_;
			ValaLocalVariable* _tmp66_;
			ValaCodeNode* _tmp91_;
			ValaCodeNode* _tmp92_;
			if (instance) {
				ValaMemberAccess* _tmp53_;
				ValaExpression* _tmp54_;
				ValaExpression* _tmp55_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_inner (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp52_ = _tmp55_ != NULL;
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				_tmp56_ = ma;
				_tmp57_ = vala_member_access_get_inner (_tmp56_);
				_tmp58_ = _tmp57_;
				vala_code_node_emit ((ValaCodeNode*) _tmp58_, codegen);
			}
			_tmp59_ = vala_assignment_get_right (self);
			_tmp60_ = _tmp59_;
			vala_code_node_emit ((ValaCodeNode*) _tmp60_, codegen);
			_tmp61_ = vala_assignment_get_right (self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_expression_get_target_value (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = _vala_target_value_ref0 (_tmp64_);
			new_value = _tmp65_;
			_tmp66_ = local;
			if (_tmp66_ != NULL) {
				ValaLocalVariable* _tmp67_;
				ValaTargetValue* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaSourceReference* _tmp70_;
				_tmp67_ = local;
				_tmp68_ = new_value;
				_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp70_ = _tmp69_;
				vala_code_generator_store_local (codegen, _tmp67_, _tmp68_, FALSE, _tmp70_);
			} else {
				ValaParameter* _tmp71_;
				_tmp71_ = param;
				if (_tmp71_ != NULL) {
					ValaParameter* _tmp72_;
					ValaTargetValue* _tmp73_;
					ValaSourceReference* _tmp74_;
					ValaSourceReference* _tmp75_;
					_tmp72_ = param;
					_tmp73_ = new_value;
					_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp75_ = _tmp74_;
					vala_code_generator_store_parameter (codegen, _tmp72_, _tmp73_, FALSE, _tmp75_);
				} else {
					ValaField* _tmp76_;
					_tmp76_ = field;
					if (_tmp76_ != NULL) {
						ValaTargetValue* _tmp77_ = NULL;
						gboolean _tmp78_ = FALSE;
						ValaField* _tmp87_;
						ValaTargetValue* _tmp88_;
						ValaSourceReference* _tmp89_;
						ValaSourceReference* _tmp90_;
						if (instance) {
							ValaMemberAccess* _tmp79_;
							ValaExpression* _tmp80_;
							ValaExpression* _tmp81_;
							_tmp79_ = ma;
							_tmp80_ = vala_member_access_get_inner (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp78_ = _tmp81_ != NULL;
						} else {
							_tmp78_ = FALSE;
						}
						if (_tmp78_) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							ValaTargetValue* _tmp85_;
							ValaTargetValue* _tmp86_;
							_tmp82_ = ma;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = vala_expression_get_target_value (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp77_ = _tmp86_;
						} else {
							_tmp77_ = NULL;
						}
						_tmp87_ = field;
						_tmp88_ = new_value;
						_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp90_ = _tmp89_;
						vala_code_generator_store_field (codegen, _tmp87_, _tmp77_, _tmp88_, _tmp90_, FALSE);
					}
				}
			}
			_tmp91_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp92_ = _tmp91_;
			if (!VALA_IS_EXPRESSION_STATEMENT (_tmp92_)) {
				ValaLocalVariable* _tmp93_;
				_tmp93_ = local;
				if (_tmp93_ != NULL) {
					ValaLocalVariable* _tmp94_;
					ValaTargetValue* _tmp95_;
					ValaTargetValue* _tmp96_;
					_tmp94_ = local;
					_tmp95_ = vala_code_generator_load_local (codegen, _tmp94_, NULL);
					_tmp96_ = _tmp95_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp96_);
					_vala_target_value_unref0 (_tmp96_);
				} else {
					ValaParameter* _tmp97_;
					_tmp97_ = param;
					if (_tmp97_ != NULL) {
						ValaParameter* _tmp98_;
						ValaTargetValue* _tmp99_;
						ValaTargetValue* _tmp100_;
						_tmp98_ = param;
						_tmp99_ = vala_code_generator_load_parameter (codegen, _tmp98_, NULL);
						_tmp100_ = _tmp99_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp100_);
						_vala_target_value_unref0 (_tmp100_);
					} else {
						ValaField* _tmp101_;
						_tmp101_ = field;
						if (_tmp101_ != NULL) {
							ValaTargetValue* _tmp102_ = NULL;
							gboolean _tmp103_ = FALSE;
							ValaField* _tmp112_;
							ValaTargetValue* _tmp113_;
							ValaTargetValue* _tmp114_;
							if (instance) {
								ValaMemberAccess* _tmp104_;
								ValaExpression* _tmp105_;
								ValaExpression* _tmp106_;
								_tmp104_ = ma;
								_tmp105_ = vala_member_access_get_inner (_tmp104_);
								_tmp106_ = _tmp105_;
								_tmp103_ = _tmp106_ != NULL;
							} else {
								_tmp103_ = FALSE;
							}
							if (_tmp103_) {
								ValaMemberAccess* _tmp107_;
								ValaExpression* _tmp108_;
								ValaExpression* _tmp109_;
								ValaTargetValue* _tmp110_;
								ValaTargetValue* _tmp111_;
								_tmp107_ = ma;
								_tmp108_ = vala_member_access_get_inner (_tmp107_);
								_tmp109_ = _tmp108_;
								_tmp110_ = vala_expression_get_target_value (_tmp109_);
								_tmp111_ = _tmp110_;
								_tmp102_ = _tmp111_;
							} else {
								_tmp102_ = NULL;
							}
							_tmp112_ = field;
							_tmp113_ = vala_code_generator_load_field (codegen, _tmp112_, _tmp102_, NULL);
							_tmp114_ = _tmp113_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp114_);
							_vala_target_value_unref0 (_tmp114_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			return;
		}
		if (instance) {
			ValaMemberAccess* _tmp117_;
			ValaExpression* _tmp118_;
			ValaExpression* _tmp119_;
			_tmp117_ = ma;
			_tmp118_ = vala_member_access_get_inner (_tmp117_);
			_tmp119_ = _tmp118_;
			_tmp116_ = _tmp119_ != NULL;
		} else {
			_tmp116_ = FALSE;
		}
		if (_tmp116_) {
			ValaProperty* _tmp120_;
			_tmp120_ = property;
			_tmp115_ = _tmp120_ != NULL;
		} else {
			_tmp115_ = FALSE;
		}
		if (_tmp115_) {
			ValaMemberAccess* _tmp121_;
			ValaExpression* _tmp122_;
			ValaExpression* _tmp123_;
			_tmp121_ = ma;
			_tmp122_ = vala_member_access_get_inner (_tmp121_);
			_tmp123_ = _tmp122_;
			vala_code_node_emit ((ValaCodeNode*) _tmp123_, codegen);
		} else {
			ValaProperty* _tmp124_;
			_tmp124_ = property;
			if (_tmp124_ == NULL) {
				ValaMemberAccess* _tmp125_;
				_tmp125_ = ma;
				vala_code_node_emit ((ValaCodeNode*) _tmp125_, codegen);
			}
		}
	} else {
		ValaElementAccess* _tmp126_;
		_tmp126_ = ea;
		if (_tmp126_ != NULL) {
			ValaElementAccess* _tmp127_;
			_tmp127_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp127_, codegen);
		} else {
			ValaPointerIndirection* _tmp128_;
			_tmp128_ = pi;
			if (_tmp128_ != NULL) {
				ValaPointerIndirection* _tmp129_;
				_tmp129_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp129_, codegen);
			}
		}
	}
	_tmp130_ = vala_assignment_get_right (self);
	_tmp131_ = _tmp130_;
	vala_code_node_emit ((ValaCodeNode*) _tmp131_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaLocalVariable* _tmp12_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp7_) ? ((ValaLocalVariable*) _tmp7_) : NULL;
	_tmp8_ = vala_assignment_get_left (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_expression_get_symbol_reference (_tmp9_);
	_tmp11_ = _tmp10_;
	param = VALA_IS_PARAMETER (_tmp11_) ? ((ValaParameter*) _tmp11_) : NULL;
	_tmp12_ = local;
	if (_tmp12_ != NULL) {
		ValaLocalVariable* _tmp13_;
		_tmp13_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp13_);
	} else {
		gboolean _tmp14_ = FALSE;
		ValaParameter* _tmp15_;
		_tmp15_ = param;
		if (_tmp15_ != NULL) {
			ValaParameter* _tmp16_;
			ValaParameterDirection _tmp17_;
			ValaParameterDirection _tmp18_;
			_tmp16_ = param;
			_tmp17_ = vala_parameter_get_direction (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaParameter* _tmp19_;
			_tmp19_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp19_);
		}
	}
}

static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMemberAccess* _tmp5_;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp5_ = ma;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		_tmp6_ = ma;
		_tmp7_ = vala_member_access_get_inner (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaMemberAccess* _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp9_ = ma;
		_tmp10_ = vala_member_access_get_inner (_tmp9_);
		_tmp11_ = _tmp10_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
	} else {
		ValaElementAccess* _tmp12_;
		_tmp12_ = ea;
		if (_tmp12_ != NULL) {
			ValaElementAccess* _tmp13_;
			_tmp13_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
		}
	}
	_tmp14_ = vala_assignment_get_right (self);
	_tmp15_ = _tmp14_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
}

static void
vala_assignment_class_init (ValaAssignmentClass * klass,
                            gpointer klass_data)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_adjust_private_offset (klass, &ValaAssignment_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_assignment_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_assignment_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_used_variables;
}

static void
vala_assignment_instance_init (ValaAssignment * self,
                               gpointer klass)
{
	self->priv = vala_assignment_get_instance_private (self);
}

static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}

/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
static GType
vala_assignment_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
	GType vala_assignment_type_id;
	vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
	ValaAssignment_private_offset = g_type_add_instance_private (vala_assignment_type_id, sizeof (ValaAssignmentPrivate));
	return vala_assignment_type_id;
}

GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__once = 0;
	if (g_once_init_enter (&vala_assignment_type_id__once)) {
		GType vala_assignment_type_id;
		vala_assignment_type_id = vala_assignment_get_type_once ();
		g_once_init_leave (&vala_assignment_type_id__once, vala_assignment_type_id);
	}
	return vala_assignment_type_id__once;
}

const gchar*
vala_assignment_operator_to_string (ValaAssignmentOperator self)
{
	const gchar* result;
	switch (self) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			result = "=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			result = "|=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			result = "&=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			result = "^=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			result = "+=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			result = "-=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			result = "*=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			result = "/=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			result = "%=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			result = "<<=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>=";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_assignment_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
	GType vala_assignment_operator_type_id;
	vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
	return vala_assignment_operator_type_id;
}

GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__once = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__once)) {
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = vala_assignment_operator_get_type_once ();
		g_once_init_leave (&vala_assignment_operator_type_id__once, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__once;
}

