/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __MACH_ESDCTL_V4_H
#define __MACH_ESDCTL_V4_H

#define ESDCTL_V4_ESDCTL0		0x00
#define ESDCTL_V4_ESDPDC		0x04
#define ESDCTL_V4_ESDOTC		0x08
#define ESDCTL_V4_ESDCFG0		0x0c
#define ESDCTL_V4_ESDCFG1		0x10
#define ESDCTL_V4_ESDCFG2		0x14
#define ESDCTL_V4_ESDMISC		0x18
#define ESDCTL_V4_ESDSCR		0x1c
#define ESDCTL_V4_ESDREF		0x20
#define ESDCTL_V4_ESDWCC		0x24
#define ESDCTL_V4_ESDRCC		0x28
#define ESDCTL_V4_ESDRWD		0x2c
#define ESDCTL_V4_ESDOR			0x30
#define ESDCTL_V4_ESDMRR		0x34
#define ESDCTL_V4_ESDCFG3_LP		0x38
#define ESDCTL_V4_ESDMR4		0x3c
#define ESDCTL_V4_ZQHWCTRL		0x40
#define ESDCTL_V4_ZQSWCTRL		0x44
#define ESDCTL_V4_WLGCR			0x48
#define ESDCTL_V4_WLDECTRL0		0x4c
#define ESDCTL_V4_WLDECTRL1		0x50
#define ESDCTL_V4_WLDLST		0x54
#define ESDCTL_V4_ODTCTRL		0x58
#define ESDCTL_V4_RDDQBY0DL		0x5c
#define ESDCTL_V4_RDDQBY1DL		0x60
#define ESDCTL_V4_RDDQBY2DL		0x64
#define ESDCTL_V4_RDDQBY3DL		0x68
#define ESDCTL_V4_WRDQBY0DL		0x6c
#define ESDCTL_V4_WRDQBY1DL		0x70
#define ESDCTL_V4_WRDQBY2DL		0x74
#define ESDCTL_V4_WRDQBY3DL		0x78
#define ESDCTL_V4_DGCTRL0		0x7c
#define ESDCTL_V4_DGCTRL1		0x80
#define ESDCTL_V4_DGDLST		0x84
#define ESDCTL_V4_RDDLCTL		0x88
#define ESDCTL_V4_RDDLST		0x8c
#define ESDCTL_V4_WRDLCTL		0x90
#define ESDCTL_V4_WRDLST		0x94
#define ESDCTL_V4_SDCTRL		0x98
#define ESDCTL_V4_ZQLP2CTL		0x9c
#define ESDCTL_V4_RDDLHWCTL		0xa0
#define ESDCTL_V4_WRDLHWCTL		0xa4
#define ESDCTL_V4_RDDLHWST0		0xa8
#define ESDCTL_V4_RDDLHWST1		0xac
#define ESDCTL_V4_WRDLHWST0		0xb0
#define ESDCTL_V4_WRDLHWST1		0xb4
#define ESDCTL_V4_WLHWERR		0xb8
#define ESDCTL_V4_DGHWST0		0xbc
#define ESDCTL_V4_DGHWST1		0xc0
#define ESDCTL_V4_DGHWST2		0xc4
#define ESDCTL_V4_DGHWST3		0xc8
#define ESDCTL_V4_PDCMPR1		0xcc
#define ESDCTL_V4_PDCMPR2		0xd0
#define ESDCTL_V4_SWDADR		0xd4
#define ESDCTL_V4_SWDRDR0		0xd8
#define ESDCTL_V4_SWDRDR1		0xdc
#define ESDCTL_V4_SWDRDR2		0xe0
#define ESDCTL_V4_SWDRDR3		0xe4
#define ESDCTL_V4_SWDRDR4		0xe8
#define ESDCTL_V4_SWDRDR5		0xec
#define ESDCTL_V4_SWDRDR6		0xf0
#define ESDCTL_V4_SWDRDR7		0xf4
#define ESDCTL_V4_MUR			0xf8
#define ESDCTL_V4_WRCADL		0xfc

#define ESDCTL_V4_ESDCTLx_SDE0				0x80000000
#define ESDCTL_V4_ESDCTLx_SDE1				0x40000000

#define ESDCTL_V4_ESDCTLx_ROW_MASK			0x07000000
#define ESDCTL_V4_ESDCTLx_ROW_11			0x00000000
#define ESDCTL_V4_ESDCTLx_ROW_12			0x01000000
#define ESDCTL_V4_ESDCTLx_ROW_13			0x02000000
#define ESDCTL_V4_ESDCTLx_ROW_14			0x03000000
#define ESDCTL_V4_ESDCTLx_ROW_15			0x04000000
#define ESDCTL_V4_ESDCTLx_ROW_16			0x05000000

#define ESDCTL_V4_ESDCTLx_COL_MASK			0x00700000
#define ESDCTL_V4_ESDCTLx_COL_9				0x00000000
#define ESDCTL_V4_ESDCTLx_COL_10			0x00100000
#define ESDCTL_V4_ESDCTLx_COL_11			0x00200000
#define ESDCTL_V4_ESDCTLx_COL_8				0x00300000
#define ESDCTL_V4_ESDCTLx_COL_12			0x00400000

#define ESDCTL_V4_ESDCTLx_BL_MASK			0x00080000
#define ESDCTL_V4_ESDCTLx_BL_4_RES			0x00000000
#define ESDCTL_V4_ESDCTLx_BL_8_8			0x00080000

#define ESDCTL_V4_ESDCTLx_DSIZ_MASK			0x00010000
#define ESDCTL_V4_ESDCTLx_DSIZ_16B_LOW			0x00000000
#define ESDCTL_V4_ESDCTLx_DSIZ_32B			0x00010000

#define ESDCTL_V4_ESDMISC_CS0_RDY			0x80000000
#define ESDCTL_V4_ESDMISC_CS1_RDY			0x40000000
#define ESDCTL_V4_ESDMISC_ONE_CS			0x00100000
#define ESDCTL_V4_ESDMISC_ADDR_MIRROR			0x00080000
#define ESDCTL_V4_ESDMISC_LHD				0x00040000
#define ESDCTL_V4_ESDMISC_WALAT_SHIFT			16
#define ESDCTL_V4_ESDMISC_WALAT_MASK			(0x3 << ESDCTL_V4_ESDMISC_WALAT_SHIFT)
#define ESDCTL_V4_ESDMISC_WALAT_0			(0x0 << ESDCTL_V4_ESDMISC_WALAT_SHIFT)
#define ESDCTL_V4_ESDMISC_WALAT_1			(0x1 << ESDCTL_V4_ESDMISC_WALAT_SHIFT)
#define ESDCTL_V4_ESDMISC_WALAT_2			(0x2 << ESDCTL_V4_ESDMISC_WALAT_SHIFT)
#define ESDCTL_V4_ESDMISC_WALAT_3			(0x3 << ESDCTL_V4_ESDMISC_WALAT_SHIFT)
#define ESDCTL_V4_ESDMISC_BI_ON				0x00001000
#define ESDCTL_V4_ESDMISC_MIF3_MODE_MASK		0x00000600
#define ESDCTL_V4_ESDMISC_MIF3_MODE_DIS			0x00000000
#define ESDCTL_V4_ESDMISC_MIF3_MODE_EF			0x00000200
#define ESDCTL_V4_ESDMISC_MIF3_MODE_EFA			0x00000400
#define ESDCTL_V4_ESDMISC_MIF3_MODE_EFAM		0x00000600
#define ESDCTL_V4_ESDMISC_RALAT_SHIFT			6
#define ESDCTL_V4_ESDMISC_RALAT_MASK			(0x7 << ESDCTL_V4_ESDMISC_RALAT_SHIFT)
#define ESDCTL_V4_ESDMISC_RALAT_0			(0x0 << ESDCTL_V4_ESDMISC_RALAT_SHIFT)
#define ESDCTL_V4_ESDMISC_RALAT_1			(0x1 << ESDCTL_V4_ESDMISC_RALAT_SHIFT)
#define ESDCTL_V4_ESDMISC_RALAT_2			(0x2 << ESDCTL_V4_ESDMISC_RALAT_SHIFT)
#define ESDCTL_V4_ESDMISC_RALAT_3			(0x3 << ESDCTL_V4_ESDMISC_RALAT_SHIFT)
#define ESDCTL_V4_ESDMISC_RALAT_4			(0x4 << ESDCTL_V4_ESDMISC_RALAT_SHIFT)
#define ESDCTL_V4_ESDMISC_RALAT_5			(0x5 << ESDCTL_V4_ESDMISC_RALAT_SHIFT)
#define ESDCTL_V4_ESDMISC_RALAT_6			(0x6 << ESDCTL_V4_ESDMISC_RALAT_SHIFT)
#define ESDCTL_V4_ESDMISC_RALAT_7			(0x7 << ESDCTL_V4_ESDMISC_RALAT_SHIFT)

#define ESDCTL_V4_ESDMISC_DDR_MASK			0x00000818
#define ESDCTL_V4_ESDMISC_DDR_DDR3			0x00000000
#define ESDCTL_V4_ESDMISC_DDR_LPDDR2_S4			0x00000008
#define ESDCTL_V4_ESDMISC_DDR_LPDDR2_S2			0x00000808
#define ESDCTL_V4_ESDMISC_DDR_DDR2			0x00000010

#define ESDCTL_V4_ESDMISC_BANKS_MASK			0x00000020
#define ESDCTL_V4_ESDMISC_BANKS_4			0x00000020
#define ESDCTL_V4_ESDMISC_BANKS_8			0x00000000

#define ESDCTL_V4_ESDMISC_RST				0x00000002


#define ESDCTL_V4_ESDRDDLCTL_RD_DL_ABS_OFFSET3_SHIFT	24
#define ESDCTL_V4_ESDRDDLCTL_RD_DL_ABS_OFFSET2_SHIFT	16
#define ESDCTL_V4_ESDRDDLCTL_RD_DL_ABS_OFFSET1_SHIFT	8
#define ESDCTL_V4_ESDRDDLCTL_RD_DL_ABS_OFFSET0_SHIFT	0
#define ESDCTL_V4_ESDRDDLCTL_RD_DL_ABS_OFFSET_MASK	0xff

#define ESDCTL_V4_ESDRDDLCTL_WR_DL_ABS_OFFSET3_SHIFT	24
#define ESDCTL_V4_ESDRDDLCTL_WR_DL_ABS_OFFSET2_SHIFT	16
#define ESDCTL_V4_ESDRDDLCTL_WR_DL_ABS_OFFSET1_SHIFT	8
#define ESDCTL_V4_ESDRDDLCTL_WR_DL_ABS_OFFSET0_SHIFT	0
#define ESDCTL_V4_ESDRDDLCTL_WR_DL_ABS_OFFSET_MASK	0xff


#define ESDCTL_V4_ESDDGCTRL0_RST_RD_FIFO		0x80000000
#define ESDCTL_V4_ESDDGCTRL0_DG_CMP_CYC			0x40000000
#define ESDCTL_V4_ESDDGCTRL0_DG_DIS			0x20000000
#define ESDCTL_V4_ESDDGCTRL0_HW_DG_EN			0x10000000
#define ESDCTL_V4_ESDDGCTRL0_DG_HC_DEL1_MASK		0x0f000000
#define ESDCTL_V4_ESDDGCTRL0_DG_HC_DEL1_SHIFT		24
#define ESDCTL_V4_ESDDGCTRL0_DG_EXT_UP			0x00800000
#define ESDCTL_V4_ESDDGCTRL0_DG_DL_ABS_OFFSET1_MASK	0x007f0000
#define ESDCTL_V4_ESDDGCTRL0_DG_DL_ABS_OFFSET1_SHIFT	16
#define ESDCTL_V4_ESDDGCTRL0_HW_DG_ERR			0x00001000
#define ESDCTL_V4_ESDDGCTRL0_DG_HC_DEL0_MASK		0x00000f00
#define ESDCTL_V4_ESDDGCTRL0_DG_HC_DEL0_SHIFT		8
#define ESDCTL_V4_ESDDGCTRL0_DG_DL_ABS_OFFSET0_MASK	0x0000007f
#define ESDCTL_V4_ESDDGCTRL0_DG_DL_ABS_OFFSET0_SHIFT	0

#define ESDCTL_V4_ESDDGCTRL1_DG_HC_DEL3_MASK		0x0f000000
#define ESDCTL_V4_ESDDGCTRL1_DG_HC_DEL3_SHIFT		24
#define ESDCTL_V4_ESDDGCTRL1_DG_DL_ABS_OFFSET3_MASK	0x007f0000
#define ESDCTL_V4_ESDDGCTRL1_DG_DL_ABS_OFFSET3_SHIFT	16
#define ESDCTL_V4_ESDDGCTRL1_DG_HC_DEL2_MASK		0x00000f00
#define ESDCTL_V4_ESDDGCTRL1_DG_HC_DEL2_SHIFT		8
#define ESDCTL_V4_ESDDGCTRL1_DG_DL_ABS_OFFSET2_MASK	0x0000007f
#define ESDCTL_V4_ESDDGCTRL1_DG_DL_ABS_OFFSET2_SHIFT	0


#define ESDCTL_V4_ESDCFG0_tRFC_SHIFT			24
#define ESDCTL_V4_ESDCFG0_tRFC_MASK			(0xff << ESDCTL_V4_ESDCFG0_tRFC_SHIFT)
#define ESDCTL_V4_ESDCFG0_tXS_SHIFT			16
#define ESDCTL_V4_ESDCFG0_tXS_MASK			(0xff << ESDCTL_V4_ESDCFG0_tXS_SHIFT)
#define ESDCTL_V4_ESDCFG0_tXP_SHIFT			13
#define ESDCTL_V4_ESDCFG0_tXP_MASK			(0x7 << ESDCTL_V4_ESDCFG0_tXP_SHIFT)
#define ESDCTL_V4_ESDCFG0_tXPDLL_SHIFT			9
#define ESDCTL_V4_ESDCFG0_tXPDLL_MASK			(0xf << ESDCTL_V4_ESDCFG0_tXPDLL_SHIFT)
#define ESDCTL_V4_ESDCFG0_tFAW_SHIFT			4
#define ESDCTL_V4_ESDCFG0_tFAW_MASK			(0x1f << ESDCTL_V4_ESDCFG0_tFAW_SHIFT)
#define ESDCTL_V4_ESDCFG0_tCL_SHIFT			0
#define ESDCTL_V4_ESDCFG0_tCL_MASK			(0xf << ESDCTL_V4_ESDCFG0_tCL_SHIFT)

#define ESDCTL_V4_ESDCFG1_tRCD_SHIFT			29
#define ESDCTL_V4_ESDCFG1_tRCD_MASK			(0x7 << ESDCTL_V4_ESDCFG1_tRCD_SHIFT)
#define ESDCTL_V4_ESDCFG1_tRP_SHIFT			26
#define ESDCTL_V4_ESDCFG1_tRP_MASK			(0x7 << ESDCTL_V4_ESDCFG1_tRP_SHIFT)
#define ESDCTL_V4_ESDCFG1_tRC_SHIFT			21
#define ESDCTL_V4_ESDCFG1_tRC_MASK			(0x1f << ESDCTL_V4_ESDCFG1_tRC_SHIFT)
#define ESDCTL_V4_ESDCFG1_tRAS_SHIFT			16
#define ESDCTL_V4_ESDCFG1_tRAS_MASK			(0x1f << ESDCTL_V4_ESDCFG1_tRAS_SHIFT)
#define ESDCTL_V4_ESDCFG1_tRPA_SHIFT			15
#define ESDCTL_V4_ESDCFG1_tRPA_MASK			(0x1 << ESDCTL_V4_ESDCFG1_tRPA_SHIFT)
#define ESDCTL_V4_ESDCFG1_tWR_SHIFT			9
#define ESDCTL_V4_ESDCFG1_tWR_MASK			(0x7 << ESDCTL_V4_ESDCFG1_tWR_SHIFT)
#define ESDCTL_V4_ESDCFG1_tMRD_SHIFT			5
#define ESDCTL_V4_ESDCFG1_tMRD_MASK			(0xf << ESDCTL_V4_ESDCFG1_tMRD_SHIFT)
#define ESDCTL_V4_ESDCFG1_tCWL_SHIFT			0
#define ESDCTL_V4_ESDCFG1_tCWL_MASK			(0x7 << ESDCTL_V4_ESDCFG1_tCWL_SHIFT)

#define ESDCTL_V4_ESDCFG2_tDLLK_SHIFT			16
#define ESDCTL_V4_ESDCFG2_tDLLK_MASK			(0x1ff << ESDCTL_V4_ESDCFG2_tDLLK_SHIFT)
#define ESDCTL_V4_ESDCFG2_tRTP_SHIFT			6
#define ESDCTL_V4_ESDCFG2_tRTP_MASK			(0x7 << ESDCTL_V4_ESDCFG2_tRTP_SHIFT)
#define ESDCTL_V4_ESDCFG2_tWTR_SHIFT			3
#define ESDCTL_V4_ESDCFG2_tWTR_MASK			(0x7 << ESDCTL_V4_ESDCFG2_tWTR_SHIFT)
#define ESDCTL_V4_ESDCFG2_tRRD_SHIFT			0
#define ESDCTL_V4_ESDCFG2_tRRD_MASK			(0x7 << ESDCTL_V4_ESDCFG2_tRRD_SHIFT)

#define ESDCTL_V4_ESDRWD_tDAI_SHIFT			16
#define ESDCTL_V4_ESDRWD_tDAI_MASK			(0x1fff << ESDCTL_V4_ESDRWD_tDAI_SHIFT)
#define ESDCTL_V4_ESDRWD_RTW_SAME_SHIFT			12
#define ESDCTL_V4_ESDRWD_RTW_SAME_MASK			(0x7 << ESDCTL_V4_ESDRWD_RTW_SAME_SHIFT)
#define ESDCTL_V4_ESDRWD_WTR_DIFF_SHIFT			9
#define ESDCTL_V4_ESDRWD_WTR_DIFF_MASK			(0x7 << ESDCTL_V4_ESDRWD_WTR_DIFF_SHIFT)
#define ESDCTL_V4_ESDRWD_WTW_DIFF_SHIFT			6
#define ESDCTL_V4_ESDRWD_WTW_DIFF_MASK			(0x7 << ESDCTL_V4_ESDRWD_WTW_DIFF_SHIFT)
#define ESDCTL_V4_ESDRWD_RTW_DIFF_SHIFT			3
#define ESDCTL_V4_ESDRWD_RTW_DIFF_MASK			(0x7 << ESDCTL_V4_ESDRWD_RTW_DIFF_SHIFT)
#define ESDCTL_V4_ESDRWD_RTR_DIFF_SHIFT			0
#define ESDCTL_V4_ESDRWD_RTR_DIFF_MASK			(0x7 << ESDCTL_V4_ESDRWD_RTR_DIFF_SHIFT)

#define ESDCTL_V4_ESDOR_tXPR_SHIFT			16
#define ESDCTL_V4_ESDOR_tXPR_MASK			(0xff << ESDCTL_V4_ESDOR_tXPR_SHIFT)
#define ESDCTL_V4_ESDOR_SDE_to_RST_SHIFT		8
#define ESDCTL_V4_ESDOR_SDE_to_RST_MASK			(0x3f << ESDCTL_V4_ESDOR_SDE_to_RST_SHIFT)
#define ESDCTL_V4_ESDOR_RST_to_CKE_SHIFT		0
#define ESDCTL_V4_ESDOR_RST_to_CKE_MASK			(0x3f << ESDCTL_V4_ESDOR_RST_to_CKE_SHIFT)

#define ESDCTL_V4_ESDOTC_tAOFPD_SHIFT			27
#define ESDCTL_V4_ESDOTC_tAOFPD_MASK			(0x7 << ESDCTL_V4_ESDOTC_tAOFPD_SHIFT)
#define ESDCTL_V4_ESDOTC_tAONPD_SHIFT			24
#define ESDCTL_V4_ESDOTC_tAONPD_MASK			(0x7 << ESDCTL_V4_ESDOTC_tAONPD_SHIFT)
#define ESDCTL_V4_ESDOTC_tANPD_SHIFT			20
#define ESDCTL_V4_ESDOTC_tANPD_MASK			(0xf << ESDCTL_V4_ESDOTC_tANPD_SHIFT)
#define ESDCTL_V4_ESDOTC_tAXPD_SHIFT			16
#define ESDCTL_V4_ESDOTC_tAXPD_MASK			(0xf << ESDCTL_V4_ESDOTC_tAXPD_SHIFT)
#define ESDCTL_V4_ESDOTC_tODTLon_SHIFT			12
#define ESDCTL_V4_ESDOTC_tODTLon_MASK			(0x7 << ESDCTL_V4_ESDOTC_tODTLon_SHIFT)
#define ESDCTL_V4_ESDOTC_tODT_idle_off_SHIFT		4
#define ESDCTL_V4_ESDOTC_tODT_idle_off_MASK		(0x1f << ESDCTL_V4_ESDOTC_tODT_idle_off_SHIFT)

#define ESDCTL_V4_ESDPDC_PRCT1_SHIFT			28
#define ESDCTL_V4_ESDPDC_PRCT1_MASK			(0x7 << ESDCTL_V4_ESDPDC_PRCT1_SHIFT)
#define ESDCTL_V4_ESDPDC_PRCT0_SHIFT			24
#define ESDCTL_V4_ESDPDC_PRCT0_MASK			(0x7 << ESDCTL_V4_ESDPDC_PRCT0_SHIFT)
#define ESDCTL_V4_ESDPDC_tCKE_SHIFT			16
#define ESDCTL_V4_ESDPDC_tCKE_MASK			(0x7 << ESDCTL_V4_ESDPDC_tCKE_SHIFT)
#define ESDCTL_V4_ESDPDC_PWDT1_SHIFT			12
#define ESDCTL_V4_ESDPDC_PWDT1_MASK			(0xf << ESDCTL_V4_ESDPDC_PWDT1_SHIFT)
#define ESDCTL_V4_ESDPDC_PWDT0_SHIFT			8
#define ESDCTL_V4_ESDPDC_PWDT0_MASK			(0xf << ESDCTL_V4_ESDPDC_PWDT0_SHIFT)
#define ESDCTL_V4_ESDPDC_SLOW_PD			0x00000080
#define ESDCTL_V4_ESDPDC_BOTH_CS_PD			0x00000040
#define ESDCTL_V4_ESDPDC_tCKSRX_SHIFT			3
#define ESDCTL_V4_ESDPDC_tCKSRX_MASK			(0x7 << ESDCTL_V4_ESDPDC_tCKSRX_SHIFT)
#define ESDCTL_V4_ESDPDC_tCKSRE_SHIFT			0
#define ESDCTL_V4_ESDPDC_tCKSRE_MASK			(0x7 << ESDCTL_V4_ESDPDC_tCKSRE_SHIFT)

#define ESDCTL_V4_ESDPDC_PRCT_DISABLE			0x0
#define ESDCTL_V4_ESDPDC_PRCT_2				0x1
#define ESDCTL_V4_ESDPDC_PRCT_4				0x2
#define ESDCTL_V4_ESDPDC_PRCT_8				0x3
#define ESDCTL_V4_ESDPDC_PRCT_16			0x4
#define ESDCTL_V4_ESDPDC_PRCT_32			0x5
#define ESDCTL_V4_ESDPDC_PRCT_64			0x6
#define ESDCTL_V4_ESDPDC_PRCT_128			0x7

#define ESDCTL_V4_ESDPDC_PWDT_DISABLE			0x0
#define ESDCTL_V4_ESDPDC_PWDT_16			0x1
#define ESDCTL_V4_ESDPDC_PWDT_32			0x2
#define ESDCTL_V4_ESDPDC_PWDT_64			0x3
#define ESDCTL_V4_ESDPDC_PWDT_128			0x4
#define ESDCTL_V4_ESDPDC_PWDT_256			0x5
#define ESDCTL_V4_ESDPDC_PWDT_512			0x6
#define ESDCTL_V4_ESDPDC_PWDT_1024			0x7
#define ESDCTL_V4_ESDPDC_PWDT_2048			0x8
#define ESDCTL_V4_ESDPDC_PWDT_4096			0x9
#define ESDCTL_V4_ESDPDC_PWDT_8192			0xa
#define ESDCTL_V4_ESDPDC_PWDT_16384			0xb
#define ESDCTL_V4_ESDPDC_PWDT_32768			0xc

#define ESDCTL_V4_ESDREF_REF_CNT_SHIFT			16
#define ESDCTL_V4_ESDREF_REF_CNT_MASK			(0xffff << ESDCTL_V4_ESDREF_REF_CNT_SHIFT)
#define ESDCTL_V4_ESDREF_REF_SEL_MASK			0x0000c000
#define ESDCTL_V4_ESDREF_REF_SEL_64K			0x00000000
#define ESDCTL_V4_ESDREF_REF_SEL_32K			0x00001000
#define ESDCTL_V4_ESDREF_REF_SEL_REFCNT			0x00002000
#define ESDCTL_V4_ESDREF_REFR_SHIFT			11
#define ESDCTL_V4_ESDREF_REFR_MASK			(0x7 << ESDCTL_V4_ESDREF_REFR_SHIFT)
#define ESDCTL_V4_ESDREF_START_REF			0x00000001

#define ESDCTL_V4_ESDZQHWC_ZQ_PARA_EN			0x04000000
#define ESDCTL_V4_ESDZQHWC_TZQ_CS_SHIFT			23
#define ESDCTL_V4_ESDZQHWC_TZQ_CS_MASK			(0x7 << ESDCTL_V4_ESDZQHWC_TZQ_CS_SHIFT)
#define ESDCTL_V4_ESDZQHWC_TZQ_OPER_SHIFT		20
#define ESDCTL_V4_ESDZQHWC_TZQ_OPER_MASK		(0x7 << ESDCTL_V4_ESDZQHWC_TZQ_OPER_SHIFT)
#define ESDCTL_V4_ESDZQHWC_TZQ_INIT_SHIFT		17
#define ESDCTL_V4_ESDZQHWC_TZQ_INIT_MASK		(0x7 << ESDCTL_V4_ESDZQHWC_TZQ_INIT_SHIFT)
#define ESDCTL_V4_ESDZQHWC_ZQ_HW_FOR			0x00010000
#define ESDCTL_V4_ESDZQHWC_ZQ_HW_PD_RES_SHIFT		11
#define ESDCTL_V4_ESDZQHWC_ZQ_HW_PD_RES_MASK		(0x1f << ESDCTL_V4_ESDZQHWC_ZQ_HW_PD_RES_SHIFT)
#define ESDCTL_V4_ESDZQHWC_ZQ_HW_PU_RES_SHIFT		6
#define ESDCTL_V4_ESDZQHWC_ZQ_HW_PU_RES_MASK		(0x1f << ESDCTL_V4_ESDZQHWC_ZQ_HW_PU_RES_SHIFT)
#define ESDCTL_V4_ESDZQHWC_ZQ_HW_PER_SHIFT		2
#define ESDCTL_V4_ESDZQHWC_ZQ_HW_PER_MASK		(0xf << ESDCTL_V4_ESDZQHWC_ZQ_HW_PER_SHIFT)
#define ESDCTL_V4_ESDZQHWC_ZQ_MODE_SHIFT		0
#define ESDCTL_V4_ESDZQHWC_ZQ_MODE_MASK			(0x3 << ESDCTL_V4_ESDZQHWC_ZQ_MODE_SHIFT)

#define ESDCTL_V4_ESDZQHWC_32CYC			0x0
#define ESDCTL_V4_ESDZQHWC_64CYC			0x1
#define ESDCTL_V4_ESDZQHWC_128CYC			0x2
#define ESDCTL_V4_ESDZQHWC_256CYC			0x3
#define ESDCTL_V4_ESDZQHWC_512CYC			0x4
#define ESDCTL_V4_ESDZQHWC_1024CYC			0x5

#define ESDCTL_V4_ESDZQHWC_ZQ_MODE_NO_CAL		(0x0 << ESDCTL_V4_ESDZQHWC_ZQ_MODE_SHIFT)
#define ESDCTL_V4_ESDZQHWC_ZQ_MODE_BOTH_EXIT		(0x1 << ESDCTL_V4_ESDZQHWC_ZQ_MODE_SHIFT)
#define ESDCTL_V4_ESDZQHWC_ZQ_MODE_EXTERNAL_PER		(0x2 << ESDCTL_V4_ESDZQHWC_ZQ_MODE_SHIFT)
#define ESDCTL_V4_ESDZQHWC_ZQ_MODE_BOTH_PER		(0x3 << ESDCTL_V4_ESDZQHWC_ZQ_MODE_SHIFT)

#define ESDCTL_V4_ESDODTC_ODT3_INT_RES_SHIFT		16
#define ESDCTL_V4_ESDODTC_ODT3_INT_RES_MASK		(0x7 << ESDCTL_V4_ESDODTC_ODT3_INT_RES_SHIFT)
#define ESDCTL_V4_ESDODTC_ODT2_INT_RES_SHIFT		12
#define ESDCTL_V4_ESDODTC_ODT2_INT_RES_MASK		(0x7 << ESDCTL_V4_ESDODTC_ODT2_INT_RES_SHIFT)
#define ESDCTL_V4_ESDODTC_ODT1_INT_RES_SHIFT		8
#define ESDCTL_V4_ESDODTC_ODT1_INT_RES_MASK		(0x7 << ESDCTL_V4_ESDODTC_ODT1_INT_RES_SHIFT)
#define ESDCTL_V4_ESDODTC_ODT0_INT_RES_SHIFT		4
#define ESDCTL_V4_ESDODTC_ODT0_INT_RES_MASK		(0x7 << ESDCTL_V4_ESDODTC_ODT0_INT_RES_SHIFT)
#define ESDCTL_V4_ESDODTC_ODT_RD_ACT_EN			0x00000008
#define ESDCTL_V4_ESDODTC_ODT_RD_PAS_EN			0x00000004
#define ESDCTL_V4_ESDODTC_ODT_WR_ACT_EN			0x00000002
#define ESDCTL_V4_ESDODTC_ODT_WR_PAS_EN			0x00000001

#define ESDCTL_V4_ESDODTC_RTT_DISABLE			0x0
#define ESDCTL_V4_ESDODTC_RTT_60			0x1
#define ESDCTL_V4_ESDODTC_RTT_120			0x2
#define ESDCTL_V4_ESDODTC_RTT_40			0x3
#define ESDCTL_V4_ESDODTC_RTT_20			0x4
#define ESDCTL_V4_ESDODTC_RTT_30			0x5

#define ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT			16
#define ESDCTL_V4_ESDSCR_CMD_ADDR_MASK			(0xffff << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_ESDSCR_CON_REQ			0x00008000
#define ESDCTL_V4_ESDSCR_CON_ACK			0x00004000
#define ESDCTL_V4_ESDSCR_MRR_DATA_VALID			0x00000400
#define ESDCTL_V4_ESDSCR_WL_EN				0x00000200
#define ESDCTL_V4_ESDSCR_DLL_RST1			0x00000100
#define ESDCTL_V4_ESDSCR_DLL_RST0			0x00000080
#define ESDCTL_V4_ESDSCR_CMD_SHIFT			4
#define ESDCTL_V4_ESDSCR_CMD_MASK			(0x7 << ESDCTL_V4_ESDSCR_CMD_SHIFT)
#define ESDCTL_V4_ESDSCR_CMD_NOP			(0x0 << ESDCTL_V4_ESDSCR_CMD_SHIFT)
#define ESDCTL_V4_ESDSCR_CMD_PRE_ALL			(0x1 << ESDCTL_V4_ESDSCR_CMD_SHIFT)
#define ESDCTL_V4_ESDSCR_CMD_AREFRESH			(0x2 << ESDCTL_V4_ESDSCR_CMD_SHIFT)
#define ESDCTL_V4_ESDSCR_CMD_LMR			(0x3 << ESDCTL_V4_ESDSCR_CMD_SHIFT)
#define ESDCTL_V4_ESDSCR_CMD_ZQCALIB_OLD		(0x4 << ESDCTL_V4_ESDSCR_CMD_SHIFT)
#define ESDCTL_V4_ESDSCR_CMD_PRE_ALL_OPEN		(0x5 << ESDCTL_V4_ESDSCR_CMD_SHIFT)
#define ESDCTL_V4_ESDSCR_CMD_MRR			(0x6 << ESDCTL_V4_ESDSCR_CMD_SHIFT)
#define ESDCTL_V4_ESDSCR_CMD_CS				0x00000008
#define ESDCTL_V4_ESDSCR_CMD_CS0			0x00000000
#define ESDCTL_V4_ESDSCR_CMD_CS1			0x00000008
#define ESDCTL_V4_ESDSCR_CMD_BA_SHIFT			0
#define ESDCTL_V4_ESDSCR_CMD_BA_MASK			(0x7 << ESDCTL_V4_ESDSCR_CMD_BA_SHIFT)

#define ESDCTL_V4_PDCMPR2_PHY_CA_DL_SHIFT		24
#define ESDCTL_V4_PDCMPR2_PHY_CA_DL_MASK		(0x7f << ESDCTL_V4_PDCMPR2_PHY_CA_DL_SHIFT)
#define ESDCTL_V4_PDCMPR2_CA_DL_ABS_SHIFT		16
#define ESDCTL_V4_PDCMPR2_CA_DL_ABS_MASK		(0x7f << ESDCTL_V4_PDCMPR2_CA_DL_ABS_SHIFT)
#define ESDCTL_V4_PDCMPR2_RLPAT				0x4
#define ESDCTL_V4_PDCMPR2_RLPAT_0			0x0
#define ESDCTL_V4_PDCMPR2_RLPAT_1			0x4
#define ESDCTL_V4_PDCMPR2_MPR_FULL_CMP			0x2
#define ESDCTL_V4_PDCMPR2_MPR_CMP			0x1

#define ESDCTL_V4_WLGCR_WL_HW_ERR3			(1 << 11)
#define ESDCTL_V4_WLGCR_WL_HW_ERR2			(1 << 10)
#define ESDCTL_V4_WLGCR_WL_HW_ERR1			(1 << 9)
#define ESDCTL_V4_WLGCR_WL_HW_ERR0			(1 << 8)
#define ESDCTL_V4_WLGCR_WL_SW_ERR3			(1 << 7)
#define ESDCTL_V4_WLGCR_WL_SW_ERR2			(1 << 6)
#define ESDCTL_V4_WLGCR_WL_SW_ERR1			(1 << 5)
#define ESDCTL_V4_WLGCR_WL_SW_ERR0			(1 << 4)
#define ESDCTL_V4_WLGCR_SW_WL_CNT_EN			(1 << 2)
#define ESDCTL_V4_WLGCR_SW_WL_EN			(1 << 1)
#define ESDCTL_V4_WLGCR_HW_WL_EN			(1 << 1)

#define ESDCTL_V4_RDDLHWCTL_HW_RDL_CMP_CYC		(1 << 5)
#define ESDCTL_V4_RDDLHWCTL_HW_RDL_EN			(1 << 4)
#define ESDCTL_V4_RDDLHWCTL_HW_RDL_ERR3			(1 << 3)
#define ESDCTL_V4_RDDLHWCTL_HW_RDL_ERR2			(1 << 2)
#define ESDCTL_V4_RDDLHWCTL_HW_RDL_ERR1			(1 << 1)
#define ESDCTL_V4_RDDLHWCTL_HW_RDL_ERR0			(1 << 0)

#define ESDCTL_V4_WRDLHWCTL_HW_WDL_CMP_CYC		(1 << 5)
#define ESDCTL_V4_WRDLHWCTL_HW_WDL_EN			(1 << 4)
#define ESDCTL_V4_WRDLHWCTL_HW_WDL_ERR3			(1 << 3)
#define ESDCTL_V4_WRDLHWCTL_HW_WDL_ERR2			(1 << 2)
#define ESDCTL_V4_WRDLHWCTL_HW_WDL_ERR1			(1 << 1)
#define ESDCTL_V4_WRDLHWCTL_HW_WDL_ERR0			(1 << 0)

#define ESDCTL_V4_DDR3_REG_MR0				(0x0 << ESDCTL_V4_ESDSCR_CMD_BA_SHIFT)
#define ESDCTL_V4_DDR3_REG_MR1				(0x1 << ESDCTL_V4_ESDSCR_CMD_BA_SHIFT)
#define ESDCTL_V4_DDR3_REG_MR2				(0x2 << ESDCTL_V4_ESDSCR_CMD_BA_SHIFT)
#define ESDCTL_V4_DDR3_REG_MR3				(0x3 << ESDCTL_V4_ESDSCR_CMD_BA_SHIFT)

#define ESDCTL_V4_DDR3_MR0_PPD				(0x1000 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_PPD_SLOW			(0x0000 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_PPD_FAST			(0x1000 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_WR_SHIFT			(9 + ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_WR_MASK			(0x7 << ESDCTL_V4_DDR3_MR0_WR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_WR_16			(0x0 << ESDCTL_V4_DDR3_MR0_WR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_WR_5				(0x1 << ESDCTL_V4_DDR3_MR0_WR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_WR_6				(0x2 << ESDCTL_V4_DDR3_MR0_WR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_WR_7				(0x3 << ESDCTL_V4_DDR3_MR0_WR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_WR_8				(0x4 << ESDCTL_V4_DDR3_MR0_WR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_WR_10			(0x5 << ESDCTL_V4_DDR3_MR0_WR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_WR_12			(0x6 << ESDCTL_V4_DDR3_MR0_WR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_WR_14			(0x7 << ESDCTL_V4_DDR3_MR0_WR_SHIFT)
#define ESDCTL_V4_DDR3_DLL_RESET			(0x0100 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_TM				(0x0080 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_TM_NORMAL			(0x0000 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_TM_TEST				(0x0080 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_SHIFT			(2 + ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_MASK			(0x74 << ESDCTL_V4_DDR3_MR0_CL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_5				(0x10 << ESDCTL_V4_DDR3_MR0_CL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_6				(0x20 << ESDCTL_V4_DDR3_MR0_CL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_7				(0x30 << ESDCTL_V4_DDR3_MR0_CL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_8				(0x40 << ESDCTL_V4_DDR3_MR0_CL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_9				(0x50 << ESDCTL_V4_DDR3_MR0_CL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_10			(0x60 << ESDCTL_V4_DDR3_MR0_CL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_11			(0x70 << ESDCTL_V4_DDR3_MR0_CL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_12			(0x04 << ESDCTL_V4_DDR3_MR0_CL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_13			(0x14 << ESDCTL_V4_DDR3_MR0_CL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_14			(0x24 << ESDCTL_V4_DDR3_MR0_CL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_15			(0x34 << ESDCTL_V4_DDR3_MR0_CL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_CL_16			(0x44 << ESDCTL_V4_DDR3_MR0_CL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_RBT				(0x0008 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_RBT_NIBBLE			(0x0000 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_RBT_INTERL			(0x0008 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_BL_SHIFT			(0 + ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR0_BL_MASK			(0x3 << ESDCTL_V4_DDR3_MR0_BL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_BL_FIXED8			(0x0 << ESDCTL_V4_DDR3_MR0_BL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_BL_DYNAMIC			(0x1 << ESDCTL_V4_DDR3_MR0_BL_SHIFT)
#define ESDCTL_V4_DDR3_MR0_BL_FIXED4			(0x2 << ESDCTL_V4_DDR3_MR0_BL_SHIFT)

#define ESDCTL_V4_DDR3_MR1_QOFF				(0x1000 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_TDQS				(0x0800 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_WL				(0x0080 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_AL_SHIFT			(3 + ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_AL_MASK			(0x3 << ESDCTL_V4_DDR3_MR1_AL_SHIFT)
#define ESDCTL_V4_DDR3_MR1_AL_DISABLE			(0x0 << ESDCTL_V4_DDR3_MR1_AL_SHIFT)
#define ESDCTL_V4_DDR3_MR1_AL_CL1			(0x1 << ESDCTL_V4_DDR3_MR1_AL_SHIFT)
#define ESDCTL_V4_DDR3_MR1_AL_CL2			(0x2 << ESDCTL_V4_DDR3_MR1_AL_SHIFT)
#define ESDCTL_V4_DDR3_MR1_DLL_DISABLE			(0x0001 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_RTTN_MASK			(0x0244 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_RTTN_DIS			(0x0000 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_RTTN_RZQ4			(0x0004 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_RTTN_RZQ2			(0x0040 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_RTTN_RZQ6			(0x0044 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_RTTN_RZQ12			(0x0200 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_RTTN_RZQ8			(0x0204 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_ODIC_MASK			(0x0022 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_ODIC_RZQ6			(0x0000 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR1_ODIC_RZQ7			(0x0002 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)

#define ESDCTL_V4_DDR3_MR2_RTTWR_SHIFT			(9 + ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_RTTWR_MASK			(0x3 << ESDCTL_V4_DDR3_MR2_RTTWR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_RTTWR_OFF			(0x0 << ESDCTL_V4_DDR3_MR2_RTTWR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_RTTWR_RZQ4			(0x1 << ESDCTL_V4_DDR3_MR2_RTTWR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_RTTWR_RZQ2			(0x2 << ESDCTL_V4_DDR3_MR2_RTTWR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_SRT				(0x0080 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_SRT_NORMAL			(0x0000 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_SRT_EXTENDED			(0x0080 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_ASR_ENABLE			(0x0040 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_CWL_SHIFT			(3 + ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_CWL_MASK			(0x7 << ESDCTL_V4_DDR3_MR2_CWL_SHIFT)
#define ESDCTL_V4_DDR3_MR2_CWL_5			(0x0 << ESDCTL_V4_DDR3_MR2_CWL_SHIFT)
#define ESDCTL_V4_DDR3_MR2_CWL_6			(0x1 << ESDCTL_V4_DDR3_MR2_CWL_SHIFT)
#define ESDCTL_V4_DDR3_MR2_CWL_7			(0x2 << ESDCTL_V4_DDR3_MR2_CWL_SHIFT)
#define ESDCTL_V4_DDR3_MR2_CWL_8			(0x3 << ESDCTL_V4_DDR3_MR2_CWL_SHIFT)
#define ESDCTL_V4_DDR3_MR2_CWL_9			(0x4 << ESDCTL_V4_DDR3_MR2_CWL_SHIFT)
#define ESDCTL_V4_DDR3_MR2_CWL_10			(0x5 << ESDCTL_V4_DDR3_MR2_CWL_SHIFT)
#define ESDCTL_V4_DDR3_MR2_CWL_11			(0x6 << ESDCTL_V4_DDR3_MR2_CWL_SHIFT)
#define ESDCTL_V4_DDR3_MR2_CWL_12			(0x7 << ESDCTL_V4_DDR3_MR2_CWL_SHIFT)
#define ESDCTL_V4_DDR3_MR2_PASR_SHIFT			(0 + ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_PASR_MASK			(0x7 << ESDCTL_V4_DDR3_MR2_PASR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_PASR_1_1			(0x0 << ESDCTL_V4_DDR3_MR2_PASR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_PASR_1_2L			(0x1 << ESDCTL_V4_DDR3_MR2_PASR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_PASR_1_4L			(0x2 << ESDCTL_V4_DDR3_MR2_PASR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_PASR_1_8L			(0x3 << ESDCTL_V4_DDR3_MR2_PASR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_PASR_3_4L			(0x4 << ESDCTL_V4_DDR3_MR2_PASR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_PASR_1_2H			(0x5 << ESDCTL_V4_DDR3_MR2_PASR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_PASR_1_4H			(0x6 << ESDCTL_V4_DDR3_MR2_PASR_SHIFT)
#define ESDCTL_V4_DDR3_MR2_PASR_1_8H			(0x7 << ESDCTL_V4_DDR3_MR2_PASR_SHIFT)

#define ESDCTL_V4_DDR3_MR3_MPR_DISABLE			(0x0000 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR3_MPR_ENABLE			(0x0004 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR3_MPR_PATTERN			(0x0000 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR3_MPR_RFU1			(0x0001 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR3_MPR_RFU2			(0x0002 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)
#define ESDCTL_V4_DDR3_MR3_MPR_RFU3			(0x0003 << ESDCTL_V4_ESDSCR_CMD_ADDR_SHIFT)

#ifndef __ASSEMBLY__

void imx_esdctlv4_do_write_leveling(void);
void imx_esdctlv4_do_dqs_gating(void);
void imx_esdctlv4_do_zq_calibration(void);
void imx_esdctlv4_start_ddr3_sdram(int cs);
void imx_esdctlv4_do_read_delay_line_calibration(void);
void imx_esdctlv4_do_write_delay_line_calibration(void);
void imx_esdctlv4_set_tRFC_timing(void);
void imx_esdctlv4_detect_sdrams(void);
void imx_esdctlv4_init(void);

#endif

#endif /* __MACH_ESDCTL_V4_H */
