/*
 * Copyright 2013-2014 Freescale Semiconductor, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef __MACH_CLOCK_VF610_H__
#define __MACH_CLOCK_VF610_H__

#define VF610_CCM_CCR				(VF610_CCM_BASE_ADDR + 0x00)
#define VF610_CCM_CSR				(VF610_CCM_BASE_ADDR + 0x04)
#define VF610_CCM_CCSR				(VF610_CCM_BASE_ADDR + 0x08)
#define VF610_CCM_CACRR				(VF610_CCM_BASE_ADDR + 0x0c)
#define VF610_CCM_CSCMR1			(VF610_CCM_BASE_ADDR + 0x10)
#define VF610_CCM_CSCDR1			(VF610_CCM_BASE_ADDR + 0x14)
#define VF610_CCM_CSCDR2			(VF610_CCM_BASE_ADDR + 0x18)
#define VF610_CCM_CSCDR3			(VF610_CCM_BASE_ADDR + 0x1c)
#define VF610_CCM_CSCMR2			(VF610_CCM_BASE_ADDR + 0x20)
#define VF610_CCM_CTOR				(VF610_CCM_BASE_ADDR + 0x28)
#define VF610_CCM_CLPCR				(VF610_CCM_BASE_ADDR + 0x80)
#define VF610_CCM_CMEOR5			(VF610_CCM_BASE_ADDR + 0x84)
#define VF610_CCM_CPPDSR			(VF610_CCM_BASE_ADDR + 0x88)
#define VF610_CCM_CCOWR				(VF610_CCM_BASE_ADDR + 0x8c)
#define VF610_CCM_CCPGR0			(VF610_CCM_BASE_ADDR + 0x90)
#define VF610_CCM_CCPGR1			(VF610_CCM_BASE_ADDR + 0x94)
#define VF610_CCM_CCPGR2			(VF610_CCM_BASE_ADDR + 0x98)
#define VF610_CCM_CCPGR3			(VF610_CCM_BASE_ADDR + 0x9c)

#define VF610_CCM_CCGRx_CGn(n)	((n) * 2)

#define VF610_ANADIG_PLL1_CTRL			(VF610_ANADIG_BASE_ADDR + 0x270)
#define VF610_ANADIG_PLL1_NUM			(VF610_ANADIG_BASE_ADDR + 0x290)
#define VF610_ANADIG_PLL1_DENOM			(VF610_ANADIG_BASE_ADDR + 0x2A0)
#define VF610_ANADIG_PLL2_CTRL			(VF610_ANADIG_BASE_ADDR + 0x30)
#define VF610_ANADIG_PLL2_NUM			(VF610_ANADIG_BASE_ADDR + 0x50)
#define VF610_ANADIG_PLL3_CTRL			(VF610_ANADIG_BASE_ADDR + 0x10)
#define VF610_ANADIG_PLL4_CTRL			(VF610_ANADIG_BASE_ADDR + 0x70)
#define VF610_ANADIG_PLL5_CTRL			(VF610_ANADIG_BASE_ADDR + 0xe0)
#define VF610_ANADIG_PLL6_CTRL			(VF610_ANADIG_BASE_ADDR + 0xa0)
#define VF610_ANADIG_PLL7_CTRL			(VF610_ANADIG_BASE_ADDR + 0x20)
#define VF610_ANADIG_ANA_MISC1			(VF610_ANADIG_BASE_ADDR + 0x160)
#define VF610_ANADIG_LOCK			(VF610_ANADIG_BASE_ADDR + 0x2C0)

#define CCM_CCR_FIRC_EN				(1 << 16)
#define CCM_CCR_OSCNT_MASK			0xff
#define CCM_CCR_OSCNT(v)			((v) & 0xff)

#define CCM_CCSR_PLL2_PFD_CLK_SEL_OFFSET	19
#define CCM_CCSR_PLL2_PFD_CLK_SEL_MASK		(0x7 << 19)
#define CCM_CCSR_PLL2_PFD_CLK_SEL(v)		(((v) & 0x7) << 19)

#define CCM_CCSR_PLL1_PFD_CLK_SEL_OFFSET	16
#define CCM_CCSR_PLL1_PFD_CLK_SEL_MASK		(0x7 << 16)
#define CCM_CCSR_PLL1_PFD_CLK_SEL(v)		(((v) & 0x7) << 16)

#define CCM_CCSR_PLL2_PFD4_EN			(1 << 15)
#define CCM_CCSR_PLL2_PFD3_EN			(1 << 14)
#define CCM_CCSR_PLL2_PFD2_EN			(1 << 13)
#define CCM_CCSR_PLL2_PFD1_EN			(1 << 12)
#define CCM_CCSR_PLL1_PFD4_EN			(1 << 11)
#define CCM_CCSR_PLL1_PFD3_EN			(1 << 10)
#define CCM_CCSR_PLL1_PFD2_EN			(1 << 9)
#define CCM_CCSR_PLL1_PFD1_EN			(1 << 8)

#define CCM_CCSR_DDRC_CLK_SEL(v)		((v) << 6)
#define CCM_CCSR_FAST_CLK_SEL(v)		((v) << 5)

#define CCM_CCSR_SYS_CLK_SEL_OFFSET		0
#define CCM_CCSR_SYS_CLK_SEL_MASK		0x7
#define CCM_CCSR_SYS_CLK_SEL(v)			((v) & 0x7)

#define CCM_CACRR_IPG_CLK_DIV_OFFSET		11
#define CCM_CACRR_IPG_CLK_DIV_MASK		(0x3 << 11)
#define CCM_CACRR_IPG_CLK_DIV(v)		(((v) & 0x3) << 11)
#define CCM_CACRR_BUS_CLK_DIV_OFFSET		3
#define CCM_CACRR_BUS_CLK_DIV_MASK		(0x7 << 3)
#define CCM_CACRR_BUS_CLK_DIV(v)		(((v) & 0x7) << 3)
#define CCM_CACRR_ARM_CLK_DIV_OFFSET		0
#define CCM_CACRR_ARM_CLK_DIV_MASK		0x7
#define CCM_CACRR_ARM_CLK_DIV(v)		((v) & 0x7)

#define CCM_CSCMR1_QSPI0_CLK_SEL_OFFSET		22
#define CCM_CSCMR1_QSPI0_CLK_SEL_MASK		(0x3 << 22)
#define CCM_CSCMR1_QSPI0_CLK_SEL(v)		(((v) & 0x3) << 22)
#define CCM_CSCMR1_ESDHC1_CLK_SEL_OFFSET	18
#define CCM_CSCMR1_ESDHC1_CLK_SEL_MASK		(0x3 << 18)
#define CCM_CSCMR1_ESDHC1_CLK_SEL(v)		(((v) & 0x3) << 18)
#define CCM_CSCMR1_NFC_CLK_SEL_OFFSET		12
#define CCM_CSCMR1_NFC_CLK_SEL_MASK		(0x3 << 12)
#define CCM_CSCMR1_NFC_CLK_SEL(v)		(((v) & 0x3) << 12)

#define CCM_CSCDR1_RMII_CLK_EN			(1 << 24)

#define CCM_CSCDR2_NFC_EN			(1 << 9)
#define CCM_CSCDR2_NFC_FRAC_DIV_EN		(1 << 13)
#define CCM_CSCDR2_NFC_CLK_INV			(1 << 14)
#define CCM_CSCDR2_NFC_FRAC_DIV_OFFSET		4
#define CCM_CSCDR2_NFC_FRAC_DIV_MASK		(0xf << 4)
#define CCM_CSCDR2_NFC_FRAC_DIV(v)		(((v) & 0xf) << 4)

#define CCM_CSCDR2_ESDHC1_EN			(1 << 29)
#define CCM_CSCDR2_ESDHC1_CLK_DIV_OFFSET	20
#define CCM_CSCDR2_ESDHC1_CLK_DIV_MASK		(0xf << 20)
#define CCM_CSCDR2_ESDHC1_CLK_DIV(v)		(((v) & 0xf) << 20)

#define CCM_CSCDR3_NFC_PRE_DIV_OFFSET		13
#define CCM_CSCDR3_NFC_PRE_DIV_MASK		(0x7 << 13)
#define CCM_CSCDR3_NFC_PRE_DIV(v)		(((v) & 0x7) << 13)
#define CCM_CSCDR3_QSPI0_EN			(1 << 4)
#define CCM_CSCDR3_QSPI0_DIV(v)			((v) << 3)
#define CCM_CSCDR3_QSPI0_X2_DIV(v)		((v) << 2)
#define CCM_CSCDR3_QSPI0_X4_DIV(v)		((v) & 0x3)

#define CCM_CSCMR2_RMII_CLK_SEL_OFFSET		4
#define CCM_CSCMR2_RMII_CLK_SEL_MASK		(0x3 << 4)
#define CCM_CSCMR2_RMII_CLK_SEL(v)		(((v) & 0x3) << 4)

#define CCM_REG_CTRL_MASK			0xffffffff
#define CCM_CCGR0_UART0_CTRL_MASK               (0x3 << 14)
#define CCM_CCGR0_UART1_CTRL_MASK		(0x3 << 16)
#define CCM_CCGR0_DSPI0_CTRL_MASK		(0x3 << 24)
#define CCM_CCGR0_DSPI1_CTRL_MASK		(0x3 << 26)
#define CCM_CCGR1_USBC0_CTRL_MASK		(0x3 << 8)
#define CCM_CCGR1_PIT_CTRL_MASK			(0x3 << 14)
#define CCM_CCGR1_WDOGA5_CTRL_MASK		(0x3 << 28)
#define CCM_CCGR2_QSPI0_CTRL_MASK		(0x3 << 8)
#define CCM_CCGR2_IOMUXC_CTRL_MASK		(0x3 << 16)
#define CCM_CCGR2_PORTA_CTRL_MASK		(0x3 << 18)
#define CCM_CCGR2_PORTB_CTRL_MASK		(0x3 << 20)
#define CCM_CCGR2_PORTC_CTRL_MASK		(0x3 << 22)
#define CCM_CCGR2_PORTD_CTRL_MASK		(0x3 << 24)
#define CCM_CCGR2_PORTE_CTRL_MASK		(0x3 << 26)
#define CCM_CCGR3_ANADIG_CTRL_MASK		0x3
#define CCM_CCGR3_SCSC_CTRL_MASK		(0x3 << 4)
#define CCM_CCGR4_WKUP_CTRL_MASK		(0x3 << 20)
#define CCM_CCGR4_CCM_CTRL_MASK			(0x3 << 22)
#define CCM_CCGR4_GPC_CTRL_MASK			(0x3 << 24)
#define CCM_CCGR4_I2C0_CTRL_MASK		(0x3 << 12)
#define CCM_CCGR4_I2C1_CTRL_MASK		(0x3 << 14)
#define CCM_CCGR6_OCOTP_CTRL_MASK		(0x3 << 10)
#define CCM_CCGR6_DSPI2_CTRL_MASK		(0x3 << 24)
#define CCM_CCGR6_DSPI3_CTRL_MASK		(0x3 << 26)
#define CCM_CCGR6_DDRMC_CTRL_MASK		(0x3 << 28)
#define CCM_CCGR7_SDHC1_CTRL_MASK		(0x3 << 4)
#define CCM_CCGR7_USBC1_CTRL_MASK		(0x3 << 8)
#define CCM_CCGR9_FEC0_CTRL_MASK		0x3
#define CCM_CCGR9_FEC1_CTRL_MASK		(0x3 << 2)
#define CCM_CCGR10_NFC_CTRL_MASK		0x3
#define CCM_CCGR10_I2C2_CTRL_MASK		(0x3 << 12)
#define CCM_CCGR10_I2C3_CTRL_MASK		(0x3 << 14)

#define ANADIG_PLL7_CTRL_BYPASS			(1 << 16)
#define ANADIG_PLL7_CTRL_ENABLE			(1 << 13)
#define ANADIG_PLL7_CTRL_POWERDOWN		(1 << 12)
#define ANADIG_PLL7_CTRL_DIV_SELECT		(1 << 1)
#define ANADIG_PLL5_CTRL_BYPASS			(1 << 16)
#define ANADIG_PLL5_CTRL_ENABLE			(1 << 13)
#define ANADIG_PLL5_CTRL_POWERDOWN		(1 << 12)
#define ANADIG_PLL5_CTRL_DIV_SELECT		1
#define ANADIG_PLL3_CTRL_BYPASS			(1 << 16)
#define ANADIG_PLL3_CTRL_ENABLE			(1 << 13)
#define ANADIG_PLL3_CTRL_POWERDOWN		(1 << 12)
#define ANADIG_PLL3_CTRL_DIV_SELECT		(1 << 1)
#define ANADIG_PLL2_CTRL_ENABLE			(1 << 13)
#define ANADIG_PLL2_CTRL_POWERDOWN		(1 << 12)
#define ANADIG_PLL2_CTRL_DIV_SELECT		1
#define ANADIG_PLL1_CTRL_ENABLE			(1 << 13)
#define ANADIG_PLL1_CTRL_POWERDOWN		(1 << 12)
#define ANADIG_PLL1_CTRL_DIV_SELECT		1

#endif
