/* SPDX-License-Identifier: GPL-2.0 */
/*
* Copyright (C) 2019-2023 Intel Corporation <www.intel.com>
 */

#ifndef _SOC64_SYSTEM_MANAGER_H_
#define _SOC64_SYSTEM_MANAGER_H_

#include <linux/bitops.h>

#define SYSMGR_SOC64_SILICONID_1		0x00
#define SYSMGR_SOC64_SILICONID_2		0x04
#define SYSMGR_SOC64_WDDBG			0x08
#define SYSMGR_SOC64_MPU_STATUS			0x10
#define SYSMGR_SOC64_SDMMC			0x28
#define SYSMGR_SOC64_SDMMC_L3MASTER		0x2c
#define SYSMGR_SOC64_COMBOPHY_DFISEL		0xfc
#define SYSMGR_SOC64_COMBOPHY_DFISEL_SDMMC	0x1
#define SYSMGR_SOC64_NANDGRP_L3MASTER		0x34
#define SYSMGR_SOC64_USB0_L3MASTER		0x38
#define SYSMGR_SOC64_USB1_L3MASTER		0x3c
#define SYSMGR_SOC64_TSN_GLOBAL			0x40
#define SYSMGR_SOC64_TSN_0			0x44
#define SYSMGR_SOC64_TSN_1			0x48
#define SYSMGR_SOC64_TSN_2			0x4C
#define SYSMGR_SOC64_TSN_0_ACE			0x50
#define SYSMGR_SOC64_TSN_1_ACE			0x54
#define SYSMGR_SOC64_TSN_2_ACE			0x58
#define SYSMGR_SOC64_FPGAINTF_EN1		0x68
#define SYSMGR_SOC64_FPGAINTF_EN2		0x6C
#define SYSMGR_SOC64_FPGAINTF_EN3		0x70
#define SYSMGR_SOC64_DMAC0_L3_MASTER		0x74
#define SYSMGR_SOC64_ETR_L3_MASTER		0x78
#define SYSMGR_SOC64_DMAC1_L3_MASTER		0x7C
#define SYSMGR_SOC64_SEC_CTRL_SLT		0x80
#define SYSMGR_SOC64_OSC_TRIM			0x84
#define SYSMGR_SOC64_DMAC0_CTRL_STATUS_REG	0x88
#define SYSMGR_SOC64_DMAC1_CTRL_STATUS_REG	0x8C
#define SYSMGR_SOC64_ECC_INTMASK_VALUE		0x90
#define SYSMGR_SOC64_ECC_INTMASK_SET		0x94
#define SYSMGR_SOC64_ECC_INTMASK_CLR		0x98
#define SYSMGR_SOC64_ECC_INTMASK_SERR		0x9C
#define SYSMGR_SOC64_ECC_INTMASK_DERR		0xA0
#define SYSMGR_SOC64_NOC_TIMEOUT		0xC0
#define SYSMGR_SOC64_NOC_IDLEREQ_SET		0xc4
#define SYSMGR_SOC64_NOC_IDLEREQ_CLR		0xc8
#define SYSMGR_SOC64_NOC_IDLEREQ_VAL		0xcc
#define SYSMGR_SOC64_NOC_IDLEACK		0xd0
#define SYSMGR_SOC64_NOC_IDLESTATUS		0xD4
#define SYSMGR_SOC64_FPGA2SOC_CTRL		0xD8
#define SYSMGR_SOC64_FPGA_CONFIG		0xDC
#define SYSMGR_SOC64_BOOT_SCRATCH_COLD0		0x200
#define SYSMGR_SOC64_BOOT_SCRATCH_COLD1		0x204
#define SYSMGR_SOC64_BOOT_SCRATCH_COLD2		0x208
#define SYSMGR_SOC64_BOOT_SCRATCH_COLD3		0x20C
#define SYSMGR_SOC64_BOOT_SCRATCH_COLD4		0x210
#define SYSMGR_SOC64_BOOT_SCRATCH_COLD5		0x214
#define SYSMGR_SOC64_BOOT_SCRATCH_COLD6		0x218
#define SYSMGR_SOC64_BOOT_SCRATCH_COLD7		0x21C
#define SYSMGR_SOC64_BOOT_SCRATCH_COLD8		0x220
#define SYSMGR_SOC64_BOOT_SCRATCH_COLD9		0x224
#define SYSMGR_SOC64_MPFE_CONFIG		0x228
#define SYSMGR_SOC64_BOOT_SCRATCH_POR0		0x258
#define SYSMGR_SOC64_BOOT_SCRATCH_POR1		0x25C

#define SYSMGR_SCRATCH_REG_0_QSPI_REFCLK_MASK		GENMASK(31, 0)
#define ALT_SYSMGR_SCRATCH_REG_3_DDR_RESET_TYPE_MASK	GENMASK(31, 29)
#define ALT_SYSMGR_SCRATCH_REG_3_DDR_RESET_TYPE_SHIFT	29
#define ALT_SYSMGR_SCRATCH_REG_3_DDR_DBE_MASK		BIT(1)
#define ALT_SYSMGR_SCRATCH_REG_3_OCRAM_DBE_MASK		BIT(0)
#define ALT_SYSMGR_SCRATCH_REG_POR_0_DDR_PROGRESS_MASK	BIT(0)
#define ALT_SYSMGR_SCRATCH_REG_POR_1_REVA_WORKAROUND_USER_MODE_MASK	BIT(0)
#define ALT_SYSMGR_SCRATCH_REG_POR_1_REVA_WORKAROUND_MASK	BIT(1)

#define SYSMGR_SOC64_EMAC_GLOBAL	SYSMGR_SOC64_TSN_GLOBAL
#define SYSMGR_SOC64_EMAC0		SYSMGR_SOC64_TSN_0
#define SYSMGR_SOC64_EMAC1		SYSMGR_SOC64_TSN_1
#define SYSMGR_SOC64_EMAC2		SYSMGR_SOC64_TSN_2
#define SYSMGR_SOC64_EMAC0_ACE		SYSMGR_SOC64_TSN_0_ACE
#define SYSMGR_SOC64_EMAC1_ACE		SYSMGR_SOC64_TSN_1_ACE
#define SYSMGR_SOC64_EMAC2_ACE		SYSMGR_SOC64_TSN_2_ACE

#define SYSMGR_SOC64_PINSEL0			0x1000
#define SYSMGR_SOC64_IOCTRL0			0x1130
#define SYSMGR_SOC64_EMAC0_USEFPGA		0x1300
#define SYSMGR_SOC64_EMAC1_USEFPGA		0x1304
#define SYSMGR_SOC64_EMAC2_USEFPGA		0x1308
#define SYSMGR_SOC64_I2C0_USEFPGA		0x130c
#define SYSMGR_SOC64_I2C1_USEFPGA		0x1310
#define SYSMGR_SOC64_I2C_EMAC0_USEFPGA		0x1314
#define SYSMGR_SOC64_I2C_EMAC1_USEFPGA		0x1318
#define SYSMGR_SOC64_I2C_EMAC2_USEFPGA		0x131c
#define SYSMGR_SOC64_NAND_USEFPGA		0x1320
#define SYSMGR_SOC64_SPIM0_USEFPGA		0x1328
#define SYSMGR_SOC64_SPIM1_USEFPGA		0x132c
#define SYSMGR_SOC64_SPIS0_USEFPGA		0x1330
#define SYSMGR_SOC64_SPIS1_USEFPGA		0x1334
#define SYSMGR_SOC64_UART0_USEFPGA		0x1338
#define SYSMGR_SOC64_UART1_USEFPGA		0x133c
#define SYSMGR_SOC64_MDIO0_USEFPGA		0x1340
#define SYSMGR_SOC64_MDIO1_USEFPGA		0x1344
#define SYSMGR_SOC64_MDIO2_USEFPGA		0x1348
#define SYSMGR_SOC64_JTAG_USEFPGA		0x1350
#define SYSMGR_SOC64_SDMMC_USEFPGA		0x1354
#define SYSMGR_SOC64_HPS_OSC_CLK		0x1358
#define SYSMGR_SOC64_IODELAY0			0x1400
#define SYSMGR_SOC64_PERI			0x15D0

/*
 * Bits for SYSMGR_SOC64_BOOT_SCRATCH_COLD8
 * Bit[31] reserved for FSBL to check DBE is triggered (set by SDM to "1") ?
 *
 * Bit[30] reserved for FSBL to update the DDR init progress
 * 1 - means in progress, 0 - haven't started / DDR is up running.
 *
* Bit[19] store ATF CPU0 ON OFF value.
*
 * Bit[18] reserved for SDM to configure ACF
 * Bit[17:1] - Setting by Linux EDAC.
 * Bit[1](ECC_OCRAM), Bit[16](ECC_DDR0), Bit[17](ECC_DDR1)
 */
#define ALT_SYSMGR_SCRATCH_REG_8_DDR_DBE_MASK		BIT(31)
#define ALT_SYSMGR_SCRATCH_REG_8_DDR_PROGRESS_MASK	BIT(30)
#define SYSMGR_SCRATCH_REG_8_ACF_DDR_RATE_MASK		BIT(18)
#define SYSMGR_SCRATCH_REG_8_ACF_DDR_RATE_SHIFT		18

#define SYSMGR_SDMMC				SYSMGR_SOC64_SDMMC

#define SYSMGR_ROMCODEGRP_CTRL_WARMRSTCFGPINMUX	BIT(0)
#define SYSMGR_ROMCODEGRP_CTRL_WARMRSTCFGIO	BIT(1)
#define SYSMGR_ECC_OCRAM_EN			BIT(0)
#define SYSMGR_ECC_OCRAM_SERR			BIT(3)
#define SYSMGR_ECC_OCRAM_DERR			BIT(4)
#define SYSMGR_FPGACONFIG_FPGA_COMPLETE		BIT(0)
#define SYSMGR_FPGACONFIG_EARLY_USERMODE	BIT(1)
#define SYSMGR_FPGACONFIG_READY_MASK	(SYSMGR_FPGACONFIG_FPGA_COMPLETE | \
					 SYSMGR_FPGACONFIG_EARLY_USERMODE)

#define SYSMGR_FPGAINTF_USEFPGA	0x1
#define SYSMGR_FPGAINTF_NAND	BIT(4)
#define SYSMGR_FPGAINTF_SDMMC	BIT(8)
#define SYSMGR_FPGAINTF_SPIM0	BIT(16)
#define SYSMGR_FPGAINTF_SPIM1	BIT(24)
#define SYSMGR_FPGAINTF_EMAC0	BIT(0)
#define SYSMGR_FPGAINTF_EMAC1	BIT(8)
#define SYSMGR_FPGAINTF_EMAC2	BIT(16)

#define SYSMGR_SDMMC_SMPLSEL_SHIFT	4
#define SYSMGR_SDMMC_DRVSEL_SHIFT	0

/* EMAC Group Bit definitions */
#define SYSMGR_EMACGRP_CTRL_PHYSEL_ENUM_GMII_MII	0x0
#define SYSMGR_EMACGRP_CTRL_PHYSEL_ENUM_RGMII		0x1
#define SYSMGR_EMACGRP_CTRL_PHYSEL_ENUM_RMII		0x2

#define SYSMGR_EMACGRP_CTRL_PHYSEL0_LSB			0
#define SYSMGR_EMACGRP_CTRL_PHYSEL1_LSB			2
#define SYSMGR_EMACGRP_CTRL_PHYSEL_MASK			0x3

#define SYSMGR_NOC_H2F_MSK		0x00000001
#define SYSMGR_NOC_LWH2F_MSK		0x00000010
#define SYSMGR_HMC_CLK_STATUS_MSK	0x00000001

#define SYSMGR_DMA_IRQ_NS		0xFF000000
#define SYSMGR_DMA_MGR_NS		0x00010000

#define SYSMGR_DMAPERIPH_ALL_NS		0xFFFFFFFF

#define SYSMGR_WDDBG_PAUSE_ALL_CPU	0x0F0F0F0F

void agilex5_security_interleaving_on(void);
void agilex5_security_interleaving_off(void);
void agilex5_initialize_security_policies(void);
void agilex5_sysmgr_pinmux_init(void);

#endif /* _SOC64_SYSTEM_MANAGER_H_ */
