/* packet-mq-base.c
 * Routines for IBM WebSphere MQ packet dissection base
 *
 * metatech <metatech@flashmail.com>
 * Robert Grange <robionekenobi@bluewin.ch>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "config.h"
#include <epan/packet.h>

#include "packet-mq.h"

 /* This routine truncates the string at the first blank space */
gint32 strip_trailing_blanks(guint8* a_str, guint32 a_size)
{
    gint32 i = 0;
    if (a_str != NULL)
    {
        for (i = a_size - 1; i >= 0; i--)
        {
            if (a_str[i] != ' ' && a_str[i] != '\0')
                break;
            else
                a_str[i] = '\0';
        }
    }
    return i;
}

DEF_VALRB(WaitIntv)
/*  -2*/ DEF_VALR1(MQCGWI_DEFAULT),
/*  -1*/ DEF_VALR1(MQWI_UNLIMITED),
/* >=0*/ DEF_VALR3(MQWI_0, MQWI_7FFFFFFF, ""),
DEF_VALRE;

DEF_VALRB(OutDataLen)
/*  -1*/ DEF_VALR1(MQCODL_AS_INPUT),
/* >=0*/ DEF_VALR3(MQCODL_0, MQCODL_7FFFFFFF, ""),
DEF_VALRE;

DEF_VALRB(ccsid)
/*  -4*/ DEF_VALR1(MQCCSI_AS_PUBLISHED),
/*  -3*/ DEF_VALR1(MQCCSI_APPL),
/*  -2*/ DEF_VALR1(MQCCSI_INHERIT),
/*  -1*/ DEF_VALR1(MQCCSI_EMBEDDED),
/*   0*/ DEF_VALR3(MQCCSI_UNDEFINED, MQCCSI_UNDEFINED, "UNDEFINED/DEFAULT/Q_MGR"),
/* >=1*/ DEF_VALR3(MQCCSI_1, MQCCSI_65535, ""),
DEF_VALRE;

DEF_VALSB(Keyreusecount)
/*  0 */ DEF_VALS1(MQKEY_REUSE_DISABLED),
/* -1 */ DEF_VALS1(MQKEY_REUSE_UNLIMITED),
DEF_VALSE;

DEF_VALSBX(mqcc)
/* -1*/ DEF_VALS1(MQCC_UNKNOWN),
/*  0*/ DEF_VALS1(MQCC_OK),
/*  1*/ DEF_VALS1(MQCC_WARNING),
/*  2*/ DEF_VALS1(MQCC_FAILED),
DEF_VALSE;

/* Types of Structure */
DEF_VALSBX(mqcft)
/*  0*/ DEF_VALS1(MQCFT_NONE),
/*  1*/ DEF_VALS1(MQCFT_COMMAND),
/*  2*/ DEF_VALS1(MQCFT_RESPONSE),
/*  3*/ DEF_VALS1(MQCFT_INTEGER),
/*  4*/ DEF_VALS1(MQCFT_STRING),
/*  5*/ DEF_VALS1(MQCFT_INTEGER_LIST),
/*  6*/ DEF_VALS1(MQCFT_STRING_LIST),
/*  7*/ DEF_VALS1(MQCFT_EVENT),
/*  8*/ DEF_VALS1(MQCFT_USER),
/*  9*/ DEF_VALS1(MQCFT_BYTE_STRING),
/* 10*/ DEF_VALS1(MQCFT_TRACE_ROUTE),
/* 12*/ DEF_VALS1(MQCFT_REPORT),
/* 13*/ DEF_VALS1(MQCFT_INTEGER_FILTER),
/* 14*/ DEF_VALS1(MQCFT_STRING_FILTER),
/* 15*/ DEF_VALS1(MQCFT_BYTE_STRING_FILTER),
/* 16*/ DEF_VALS1(MQCFT_COMMAND_XR),
/* 17*/ DEF_VALS1(MQCFT_XR_MSG),
/* 18*/ DEF_VALS1(MQCFT_XR_ITEM),
/* 19*/ DEF_VALS1(MQCFT_XR_SUMMARY),
/* 20*/ DEF_VALS1(MQCFT_GROUP),
/* 21*/ DEF_VALS1(MQCFT_STATISTICS),
/* 22*/ DEF_VALS1(MQCFT_ACCOUNTING),
/* 23*/ DEF_VALS1(MQCFT_INTEGER64),
/* 25*/ DEF_VALS1(MQCFT_INTEGER64_LIST),
/* 26*/ DEF_VALS1(MQCFT_APP_ACTIVITY),
DEF_VALSE;

DEF_VALSB(AuthInfoType)
/* 0*/ DEF_VALS1(MQAIT_ALL),
/* 1*/ DEF_VALS1(MQAIT_CRL_LDAP),
/* 2*/ DEF_VALS1(MQAIT_OCSP),
/* 3*/ DEF_VALS1(MQAIT_IDPW_OS),
/* 4*/ DEF_VALS1(MQAIT_IDPW_LDAP),
DEF_VALSE;

DEF_VALSBX(FilterOP)
/*  1*/ DEF_VALS1(MQCFOP_LESS),
/*  2*/ DEF_VALS1(MQCFOP_EQUAL),
/*  3*/ DEF_VALS1(MQCFOP_NOT_GREATER),
/*  4*/ DEF_VALS1(MQCFOP_GREATER),
/*  5*/ DEF_VALS1(MQCFOP_NOT_EQUAL),
/*  6*/ DEF_VALS1(MQCFOP_NOT_LESS),
/* 10*/ DEF_VALS1(MQCFOP_CONTAINS),
/* 13*/ DEF_VALS1(MQCFOP_EXCLUDES),
/* 18*/ DEF_VALS1(MQCFOP_LIKE),
/* 21*/ DEF_VALS1(MQCFOP_NOT_LIKE),
/* 26*/ DEF_VALS1(MQCFOP_CONTAINS_GEN),
/* 29*/ DEF_VALS1(MQCFOP_EXCLUDES_GEN),
DEF_VALSE;

DEF_VALSBX(MQPRT)
/* 0*/ DEF_VALS1(MQPRT_RESPONSE_AS_PARENT),
/* 1*/ DEF_VALS1(MQPRT_SYNC_RESPONSE),
/* 2*/ DEF_VALS1(MQPRT_ASYNC_RESPONSE),
DEF_VALSE;

DEF_VALSB(TraceRouteRecording)
/* 0*/ DEF_VALS1(MQRECORDING_DISABLED),
/* 1*/ DEF_VALS1(MQRECORDING_Q),
/* 2*/ DEF_VALS1(MQRECORDING_MSG),
DEF_VALSE;

DEF_VALSB(TCPStackType)
/* 0*/ DEF_VALS1(MQTCPSTACK_SINGLE),
/* 1*/ DEF_VALS1(MQTCPSTACK_MULTIPLE),
DEF_VALSE;

DEF_VALSB(TCPKeepAlive)
/* 0*/ DEF_VALS1(MQTCPKEEP_NO),
/* 1*/ DEF_VALS1(MQTCPKEEP_YES),
DEF_VALSE;

DEF_VALSB(SharedQueueQueueManagerName)
/* 0*/ DEF_VALS1(MQSQQM_USE),
/* 1*/ DEF_VALS1(MQSQQM_IGNORE),
DEF_VALSE;

DEF_VALSB(ReceiveTimeoutType)
/* 0*/ DEF_VALS1(MQRCVTIME_MULTIPLY),
/* 1*/ DEF_VALS1(MQRCVTIME_ADD),
/* 2*/ DEF_VALS1(MQRCVTIME_EQUAL),
DEF_VALSE;

DEF_VALSB(IPAddressVersion)
/* 0*/ DEF_VALS1(MQIPADDR_IPV4),
/* 1*/ DEF_VALS1(MQIPADDR_IPV6),
DEF_VALSE;

DEF_VALSB(MQGUR)
/* 0*/ DEF_VALS1(MQGUR_DISABLED),
/* 1*/ DEF_VALS1(MQGUR_ENABLED),
DEF_VALSE;

DEF_VALSB(DNSWLM)
/* 0*/ DEF_VALS1(MQDNSWLM_NO),
/* 1*/ DEF_VALS1(MQDNSWLM_YES),
DEF_VALSE;

DEF_VALSB(AdoptNewMCAType)
/*  0*/ DEF_VALS1(MQADOPT_TYPE_NO),
/*  1*/ DEF_VALS1(MQADOPT_TYPE_ALL),
/*  2*/ DEF_VALS1(MQADOPT_TYPE_SVR),
/*  4*/ DEF_VALS1(MQADOPT_TYPE_SDR),
/*  8*/ DEF_VALS1(MQADOPT_TYPE_RCVR),
/* 16*/ DEF_VALS1(MQADOPT_TYPE_CLUSRCVR),
DEF_VALSE;

DEF_VALSB(AdoptNewMCACheck)
/* 0*/ DEF_VALS1(MQADOPT_CHECK_NONE),
/* 1*/ DEF_VALS1(MQADOPT_CHECK_ALL),
/* 2*/ DEF_VALS1(MQADOPT_CHECK_Q_MGR_NAME),
/* 4*/ DEF_VALS1(MQADOPT_CHECK_NET_ADDR),
/* 8*/ DEF_VALS1(MQADOPT_CHECK_CHANNEL_NAME),
DEF_VALSE;

DEF_VALSB(ActivityRecording)
/* 0*/ DEF_VALS1(MQRECORDING_DISABLED),
/* 1*/ DEF_VALS1(MQRECORDING_Q),
/* 2*/ DEF_VALS1(MQRECORDING_MSG),
DEF_VALSE;

DEF_VALSB(TransportType)
/* -1*/ DEF_VALS1(MQXPT_ALL),
/*  0*/ DEF_VALS1(MQXPT_LOCAL),
/*  1*/ DEF_VALS1(MQXPT_LU62),
/*  2*/ DEF_VALS1(MQXPT_TCP),
/*  3*/ DEF_VALS1(MQXPT_NETBIOS),
/*  4*/ DEF_VALS1(MQXPT_SPX),
/*  5*/ DEF_VALS1(MQXPT_DECNET),
/*  6*/ DEF_VALS1(MQXPT_UDP),
DEF_VALSE;

DEF_VALSB(SSLClientAuthentication)
/* 0*/ DEF_VALS1(MQSCA_REQUIRED),
/* 1*/ DEF_VALS1(MQSCA_OPTIONAL),
DEF_VALSE;


DEF_VALSB(PutAuthority)
/* 1*/ DEF_VALS1(MQPA_DEFAULT),
/* 2*/ DEF_VALS1(MQPA_CONTEXT),
/* 3*/ DEF_VALS1(MQPA_ONLY_MCA),
/* 4*/ DEF_VALS1(MQPA_ALTERNATE_OR_MCA),
DEF_VALSE;

DEF_VALSB(NonPersistentMsgSpeed)
/* 1*/ DEF_VALS1(MQNPMS_NORMAL),
/* 2*/ DEF_VALS1(MQNPMS_FAST),
DEF_VALSE;

DEF_VALSB(MQCOMPRESS)
/*         -1*/ DEF_VALS1(MQCOMPRESS_NOT_AVAILABLE),
/*          0*/ DEF_VALS1(MQCOMPRESS_NONE),
/*          1*/ DEF_VALS1(MQCOMPRESS_RLE),
/*          2*/ DEF_VALS1(MQCOMPRESS_ZLIBFAST),
/*          4*/ DEF_VALS1(MQCOMPRESS_ZLIBHIGH),
/*          8*/ DEF_VALS1(MQCOMPRESS_SYSTEM),
/* 0x0FFFFFFF*/ DEF_VALS1(MQCOMPRESS_ANY),
DEF_VALSE;

#if 0
DEF_VALSB(MCAStatus)
/* 0*/ DEF_VALS1(MQMCAS_STOPPED),
/* 3*/ DEF_VALS1(MQMCAS_RUNNING),
DEF_VALSE;
#endif

DEF_VALSB(MCAType)
/* 1*/ DEF_VALS1(MQMCAT_PROCESS),
/* 2*/ DEF_VALS1(MQMCAT_THREAD),
DEF_VALSE;

DEF_VALSB(DataConversion)
/* 0*/ DEF_VALS1(MQCDC_NO_SENDER_CONVERSION),
/* 1*/ DEF_VALS1(MQCDC_SENDER_CONVERSION),
DEF_VALSE;

DEF_VALSB(MQUS)
/* 0*/ DEF_VALS1(MQUS_NORMAL),
/* 1*/ DEF_VALS1(MQUS_TRANSMISSION),
DEF_VALSE;

DEF_VALSB(ChannelType)
/*  1*/ DEF_VALS1(MQCHT_SENDER),
/*  2*/ DEF_VALS1(MQCHT_SERVER),
/*  3*/ DEF_VALS1(MQCHT_RECEIVER),
/*  4*/ DEF_VALS1(MQCHT_REQUESTER),
/*  5*/ DEF_VALS1(MQCHT_ALL),
/*  6*/ DEF_VALS1(MQCHT_SVRCONN),
/*  7*/ DEF_VALS1(MQCHT_CLNTCONN),
/*  8*/ DEF_VALS1(MQCHT_CLUSRCVR),
/*  9*/ DEF_VALS1(MQCHT_CLUSSDR),
/* 10*/ DEF_VALS1(MQCHT_MQTT),
/* 11*/ DEF_VALS1(MQCHT_AMQP),
DEF_VALSE;

DEF_VALSB(ServiceIntervalEvent)
/* 0*/ DEF_VALS1(MQQSIE_NONE),
/* 1*/ DEF_VALS1(MQQSIE_HIGH),
/* 2*/ DEF_VALS1(MQQSIE_OK),
DEF_VALSE;

DEF_VALSB(MQMON)
/* -3*/ DEF_VALS1(MQMON_Q_MGR),
/* -1*/ DEF_VALS2(MQMON_NONE, "NONE/NOTAVAIL"),
/*  0*/ DEF_VALS2(MQMON_OFF, "OFF/DISABLED"),
/*  1*/ DEF_VALS2(MQMON_ON, "ON/ENABLED"),
/* 17*/ DEF_VALS1(MQMON_LOW),
/* 33*/ DEF_VALS1(MQMON_MEDIUM),
/* 65*/ DEF_VALS1(MQMON_HIGH),
DEF_VALSE;

DEF_VALSB(MQQT)
/*    1*/ DEF_VALS1(MQQT_LOCAL),
/*    2*/ DEF_VALS1(MQQT_MODEL),
/*    3*/ DEF_VALS1(MQQT_ALIAS),
/*    6*/ DEF_VALS1(MQQT_REMOTE),
/*    7*/ DEF_VALS1(MQQT_CLUSTER),
/* 1001*/ DEF_VALS1(MQQT_ALL),
DEF_VALSE;

DEF_VALSB(MQEVR)
/* 0*/ DEF_VALS1(MQEVR_DISABLED),
/* 1*/ DEF_VALS1(MQEVR_ENABLED),
/* 2*/ DEF_VALS1(MQEVR_EXCEPTION),
/* 3*/ DEF_VALS1(MQEVR_NO_DISPLAY),
/* 4*/ DEF_VALS1(MQEVR_API_ONLY),
/* 5*/ DEF_VALS1(MQEVR_ADMIN_ONLY),
/* 6*/ DEF_VALS1(MQEVR_USER_ONLY),
DEF_VALSE;

DEF_VALSB(MQOO)
/* 0x00000002*/ DEF_VALS1(MQOO_INPUT_SHARED),
/* 0x00000004*/ DEF_VALS1(MQOO_INPUT_EXCLUSIVE),
DEF_VALSE;

DEF_VALSB(CFConLoss)
/* 0*/ DEF_VALS1(MQCFCONLOS_TERMINATE),
/* 1*/ DEF_VALS1(MQCFCONLOS_TOLERATE),
/* 2*/ DEF_VALS1(MQCFCONLOS_ASQMGR),
DEF_VALSE;

DEF_VALSB(CLWLUseQ)
/* -3*/ DEF_VALS1(MQCLWL_USEQ_AS_Q_MGR),
/*  0*/ DEF_VALS1(MQCLWL_USEQ_LOCAL),
/*  1*/ DEF_VALS1(MQCLWL_USEQ_ANY),
DEF_VALSE;

DEF_VALSB(MQQDT)
/* 1*/ DEF_VALS1(MQQDT_PREDEFINED),
/* 2*/ DEF_VALS1(MQQDT_PERMANENT_DYNAMIC),
/* 3*/ DEF_VALS1(MQQDT_TEMPORARY_DYNAMIC),
/* 4*/ DEF_VALS1(MQQDT_SHARED_DYNAMIC),
DEF_VALSE;

DEF_VALSB(MQQA_GET)
/* 0*/ DEF_VALS1(MQQA_GET_ALLOWED),
/* 1*/ DEF_VALS1(MQQA_GET_INHIBITED),
DEF_VALSE;

DEF_VALSB(IntraGroupQueuing)
/* 0*/ DEF_VALS1(MQIGQ_DISABLED),
/* 1*/ DEF_VALS1(MQIGQ_ENABLED),
DEF_VALSE;

DEF_VALSB(MQQA_PUT)
/* 0*/ DEF_VALS1(MQQA_PUT_ALLOWED),
/* 1*/ DEF_VALS1(MQQA_PUT_INHIBITED),
DEF_VALSE;

DEF_VALSB(Shareability)
/* 0*/ DEF_VALS1(MQQA_NOT_SHAREABLE),
/* 1*/ DEF_VALS1(MQQA_SHAREABLE),
DEF_VALSE;

DEF_VALSB(MQQA_BACKOUT)
/* 0*/ DEF_VALS1(MQQA_BACKOUT_NOT_HARDENED),
/* 1*/ DEF_VALS1(MQQA_BACKOUT_HARDENED),
DEF_VALSE;

DEF_VALSB(MQMDS)
/* 0*/ DEF_VALS1(MQMDS_PRIORITY),
/* 1*/ DEF_VALS1(MQMDS_FIFO),
DEF_VALSE;

DEF_VALSB(NonpersistentMsgCls)
/*  0*/ DEF_VALS1(MQNPM_CLASS_NORMAL),
/* 10*/ DEF_VALS1(MQNPM_CLASS_HIGH),
DEF_VALSE;

DEF_VALSB(TriggerControl)
/* 0*/ DEF_VALS1(MQTC_OFF),
/* 1*/ DEF_VALS1(MQTC_ON),
DEF_VALSE;

DEF_VALSB(TriggerType)
/* 0*/ DEF_VALS1(MQTT_NONE),
/* 1*/ DEF_VALS1(MQTT_FIRST),
/* 2*/ DEF_VALS1(MQTT_EVERY),
/* 3*/ DEF_VALS1(MQTT_DEPTH),
DEF_VALSE;

#if 0
DEF_VALSB(TriggerRestart)
/* 0*/ DEF_VALS1(MQTRIGGER_RESTART_NO),
/* 1*/ DEF_VALS1(MQTRIGGER_RESTART_YES),
DEF_VALSE;
#endif

DEF_VALSB(DistributionLists)
/* 0*/ DEF_VALS1(MQDL_NOT_SUPPORTED),
/* 1*/ DEF_VALS1(MQDL_SUPPORTED),
DEF_VALSE;

DEF_VALSB(IndexTypes)
/* 0*/ DEF_VALS1(MQIT_NONE),
/* 1*/ DEF_VALS1(MQIT_MSG_ID),
/* 2*/ DEF_VALS1(MQIT_CORREL_ID),
/* 4*/ DEF_VALS1(MQIT_MSG_TOKEN),
/* 5*/ DEF_VALS1(MQIT_GROUP_ID),
DEF_VALSE;

DEF_VALSB(Bindings)
/* 0*/ DEF_VALS1(MQBND_BIND_ON_OPEN),
/* 1*/ DEF_VALS1(MQBND_BIND_NOT_FIXED),
/* 2*/ DEF_VALS1(MQBND_BIND_ON_GROUP),
DEF_VALSE;

DEF_VALSB(QShrGrpDisp)
/* -1*/ DEF_VALS1(MQQSGD_ALL),
/*  0*/ DEF_VALS1(MQQSGD_Q_MGR),
/*  1*/ DEF_VALS1(MQQSGD_COPY),
/*  2*/ DEF_VALS1(MQQSGD_SHARED),
/*  3*/ DEF_VALS1(MQQSGD_GROUP),
/*  4*/ DEF_VALS1(MQQSGD_PRIVATE),
/*  6*/ DEF_VALS1(MQQSGD_LIVE),
DEF_VALSE;

#if 0
DEF_VALSB(ReorgCtls)
/* 0*/ DEF_VALS1(MQREORG_DISABLED),
/* 1*/ DEF_VALS1(MQREORG_ENABLED),
DEF_VALSE;
#endif

DEF_VALSBX(MQREADA)
/* 0*/ DEF_VALS1(MQREADA_NO),
/* 1*/ DEF_VALS1(MQREADA_YES),
/* 2*/ DEF_VALS1(MQREADA_DISABLED),
/* 3*/ DEF_VALS1(MQREADA_INHIBITED),
/* 4*/ DEF_VALS1(MQREADA_BACKLOG),
DEF_VALSE;

DEF_VALSBX(MQPROP)
/* 0*/ DEF_VALS1(MQPROP_COMPATIBILITY),
/* 1*/ DEF_VALS1(MQPROP_NONE),
/* 2*/ DEF_VALS1(MQPROP_ALL),
/* 3*/ DEF_VALS1(MQPROP_FORCE_MQRFH2),
/* 4*/ DEF_VALS1(MQPROP_V6COMPAT),
DEF_VALSE;

DEF_VALSB(EvtOrig)
/* 0*/ DEF_VALS1(MQEVO_OTHER),
/* 1*/ DEF_VALS1(MQEVO_CONSOLE),
/* 2*/ DEF_VALS1(MQEVO_INIT),
/* 3*/ DEF_VALS1(MQEVO_MSG),
/* 4*/ DEF_VALS1(MQEVO_MQSET),
/* 5*/ DEF_VALS1(MQEVO_INTERNAL),
/* 6*/ DEF_VALS1(MQEVO_MQSUB),
/* 7*/ DEF_VALS1(MQEVO_CTLMSG),
/* 8*/ DEF_VALS1(MQEVO_REST),
DEF_VALSE;

DEF_VALSBX(MQPER)
/* -1*/ DEF_VALS1(MQPER_PERSISTENCE_AS_PARENT),
/*  0*/ DEF_VALS1(MQPER_NOT_PERSISTENT),
/*  1*/ DEF_VALS1(MQPER_PERSISTENT),
/*  2*/ DEF_VALS1(MQPER_PERSISTENCE_AS_Q_DEF),
DEF_VALSE;

DEF_VALSB(MQUCI)
/* 0*/ DEF_VALS1(MQUCI_NO),
/* 1*/ DEF_VALS1(MQUCI_YES),
DEF_VALSE;

#if 0
DEF_VALSB(MQLR)
/*  -2*/ DEF_VALS1(MQLR_MAX),
/*   1*/ DEF_VALS1(MQLR_ONE),
/*  -1*/ DEF_VALS1(MQLR_AUTO),
DEF_VALSE;
DEF_VALSB(MQMEDIMGSCHED)
/*   0*/ DEF_VALS1(MQMEDIMGSCHED_MANUAL),
/*   1*/ DEF_VALS1(MQMEDIMGSCHED_AUTO),
DEF_VALSE;
DEF_VALSB(MQMEDIMGINTVL)
/*   0*/ DEF_VALS1(MQMEDIMGINTVL_OFF),
DEF_VALSE;
DEF_VALSB(MQMEDIMGLOGLN)
/*   0*/ DEF_VALS1(MQMEDIMGLOGLN_OFF),
DEF_VALSE;
DEF_VALSB(MQIMGRCOV)
/*   0*/ DEF_VALS1(MQIMGRCOV_NO),
/*   1*/ DEF_VALS1(MQIMGRCOV_YES),
/*   2*/ DEF_VALS1(MQIMGRCOV_AS_Q_MGR),
DEF_VALSE;
#endif

DEF_VALSBX(MQMT)
/*   1*/ DEF_VALS1(MQMT_REQUEST),
/*   2*/ DEF_VALS1(MQMT_REPLY),
/*   3*/ DEF_VALS1(MQMT_DATAGRAM),
/*   4*/ DEF_VALS1(MQMT_REPORT),
/* 112*/ DEF_VALS1(MQMT_MQE_FIELDS_FROM_MQE),
/* 113*/ DEF_VALS1(MQMT_MQE_FIELDS),
DEF_VALSE;

DEF_VALSB(Platform)
/*  1*/ DEF_VALS2(MQPL_ZOS, "ZOS/MVS/OS390"),
/*  2*/ DEF_VALS1(MQPL_OS2),
/*  3*/ DEF_VALS2(MQPL_UNIX, "UNIX/AIX"),
/*  4*/ DEF_VALS1(MQPL_OS400),
/*  5*/ DEF_VALS1(MQPL_WINDOWS),
/* 11*/ DEF_VALS1(MQPL_WINDOWS_NT),
/* 12*/ DEF_VALS1(MQPL_VMS),
/* 13*/ DEF_VALS2(MQPL_NSK, "NSK/NSS"),
/* 15*/ DEF_VALS1(MQPL_OPEN_TP1),
/* 18*/ DEF_VALS1(MQPL_VM),
/* 23*/ DEF_VALS1(MQPL_TPF),
/* 27*/ DEF_VALS1(MQPL_VSE),
/* 28*/ DEF_VALS1(MQPL_APPLIANCE),
DEF_VALSE;

DEF_VALSB(CommandInformationValues)
/*  1*/ DEF_VALS1(MQCMDI_CMDSCOPE_ACCEPTED),
/*  2*/ DEF_VALS1(MQCMDI_CMDSCOPE_GENERATED),
/*  3*/ DEF_VALS1(MQCMDI_CMDSCOPE_COMPLETED),
/*  4*/ DEF_VALS1(MQCMDI_QSG_DISP_COMPLETED),
/*  5*/ DEF_VALS1(MQCMDI_COMMAND_ACCEPTED),
/*  6*/ DEF_VALS1(MQCMDI_CLUSTER_REQUEST_QUEUED),
/*  7*/ DEF_VALS1(MQCMDI_CHANNEL_INIT_STARTED),
/* 11*/ DEF_VALS1(MQCMDI_RECOVER_STARTED),
/* 12*/ DEF_VALS1(MQCMDI_BACKUP_STARTED),
/* 13*/ DEF_VALS1(MQCMDI_RECOVER_COMPLETED),
/* 14*/ DEF_VALS1(MQCMDI_SEC_TIMER_ZERO),
/* 16*/ DEF_VALS1(MQCMDI_REFRESH_CONFIGURATION),
/* 17*/ DEF_VALS1(MQCMDI_SEC_SIGNOFF_ERROR),
/* 18*/ DEF_VALS1(MQCMDI_IMS_BRIDGE_SUSPENDED),
/* 19*/ DEF_VALS1(MQCMDI_DB2_SUSPENDED),
/* 20*/ DEF_VALS1(MQCMDI_DB2_OBSOLETE_MSGS),
/* 21*/ DEF_VALS1(MQCMDI_SEC_UPPERCASE),
/* 22*/ DEF_VALS1(MQCMDI_SEC_MIXEDCASE),
DEF_VALSE;

DEF_VALSBX(CtlOpt)
/* 0*/ DEF_VALS1(MQCFC_NOT_LAST),
/* 1*/ DEF_VALS1(MQCFC_LAST),
DEF_VALSE;

#if 0
DEF_VALSB(ActionOptions)
/* 1*/ DEF_VALS1(MQACT_FORCE_REMOVE),
/* 2*/ DEF_VALS1(MQACT_ADVANCE_LOG),
/* 3*/ DEF_VALS1(MQACT_COLLECT_STATISTICS),
/* 4*/ DEF_VALS1(MQACT_PUBSUB),
/* 5*/ DEF_VALS1(MQACT_ADD),
/* 6*/ DEF_VALS1(MQACT_REPLACE),
/* 7*/ DEF_VALS1(MQACT_REMOVE),
/* 8*/ DEF_VALS1(MQACT_REMOVEALL),
/* 9*/ DEF_VALS1(MQACT_FAIL),
/*10*/ DEF_VALS1(MQACT_REDUCE_LOG),
/*11*/ DEF_VALS1(MQACT_ARCHIVE_LOG),
DEF_VALSE;
#endif

DEF_VALSB(AsynchronousStateValues)
/* 0*/ DEF_VALS1(MQAS_NONE),
/* 1*/ DEF_VALS1(MQAS_STARTED),
/* 2*/ DEF_VALS1(MQAS_START_WAIT),
/* 3*/ DEF_VALS1(MQAS_STOPPED),
/* 4*/ DEF_VALS1(MQAS_SUSPENDED),
/* 5*/ DEF_VALS1(MQAS_SUSPENDED_TEMPORARY),
/* 6*/ DEF_VALS1(MQAS_ACTIVE),
/* 7*/ DEF_VALS1(MQAS_INACTIVE),
DEF_VALSE;

DEF_VALSB(MQAUTH)
/* -3*/ DEF_VALS1(MQAUTH_ALL_MQI),
/* -2*/ DEF_VALS1(MQAUTH_ALL_ADMIN),
/* -1*/ DEF_VALS1(MQAUTH_ALL),
/*  0*/ DEF_VALS1(MQAUTH_NONE),
/*  1*/ DEF_VALS1(MQAUTH_ALT_USER_AUTHORITY),
/*  2*/ DEF_VALS1(MQAUTH_BROWSE),
/*  3*/ DEF_VALS1(MQAUTH_CHANGE),
/*  4*/ DEF_VALS1(MQAUTH_CLEAR),
/*  5*/ DEF_VALS1(MQAUTH_CONNECT),
/*  6*/ DEF_VALS1(MQAUTH_CREATE),
/*  7*/ DEF_VALS1(MQAUTH_DELETE),
/*  8*/ DEF_VALS1(MQAUTH_DISPLAY),
/*  9*/ DEF_VALS1(MQAUTH_INPUT),
/* 10*/ DEF_VALS1(MQAUTH_INQUIRE),
/* 11*/ DEF_VALS1(MQAUTH_OUTPUT),
/* 12*/ DEF_VALS1(MQAUTH_PASS_ALL_CONTEXT),
/* 13*/ DEF_VALS1(MQAUTH_PASS_IDENTITY_CONTEXT),
/* 14*/ DEF_VALS1(MQAUTH_SET),
/* 15*/ DEF_VALS1(MQAUTH_SET_ALL_CONTEXT),
/* 16*/ DEF_VALS1(MQAUTH_SET_IDENTITY_CONTEXT),
/* 17*/ DEF_VALS1(MQAUTH_CONTROL),
/* 18*/ DEF_VALS1(MQAUTH_CONTROL_EXTENDED),
/* 19*/ DEF_VALS1(MQAUTH_PUBLISH),
/* 20*/ DEF_VALS1(MQAUTH_SUBSCRIBE),
/* 21*/ DEF_VALS1(MQAUTH_RESUME),
/* 22*/ DEF_VALS1(MQAUTH_SYSTEM),
DEF_VALSE;

#if 0
DEF_VALSB(BridgeTypes)
/* 1*/ DEF_VALS1(MQBT_OTMA),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(RefreshRepositoryOptions)
/* 0*/ DEF_VALS1(MQCFO_REFRESH_REPOSITORY_NO),
/* 1*/ DEF_VALS1(MQCFO_REFRESH_REPOSITORY_YES),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(RemoveQueuesOptions)
/* 0*/ DEF_VALS1(MQCFO_REMOVE_QUEUES_NO),
/* 1*/ DEF_VALS1(MQCFO_REMOVE_QUEUES_YES),
DEF_VALSE;
#endif

DEF_VALSB(IndoubtStatus)
/* 0*/ DEF_VALS1(MQCHIDS_NOT_INDOUBT),
/* 1*/ DEF_VALS1(MQCHIDS_INDOUBT),
DEF_VALSE;

DEF_VALSB(ChannelDisp)
/* -1*/ DEF_VALS1(MQCHLD_ALL),
/*  1*/ DEF_VALS1(MQCHLD_DEFAULT),
/*  2*/ DEF_VALS1(MQCHLD_SHARED),
/*  4*/ DEF_VALS1(MQCHLD_PRIVATE),
/* 5 */ DEF_VALS1(MQCHLD_FIXSHARED),
DEF_VALSE;

DEF_VALSB(ChannelStatus)
/*  0*/ DEF_VALS1(MQCHS_INACTIVE),
/*  1*/ DEF_VALS1(MQCHS_BINDING),
/*  2*/ DEF_VALS1(MQCHS_STARTING),
/*  3*/ DEF_VALS1(MQCHS_RUNNING),
/*  4*/ DEF_VALS1(MQCHS_STOPPING),
/*  5*/ DEF_VALS1(MQCHS_RETRYING),
/*  6*/ DEF_VALS1(MQCHS_STOPPED),
/*  7*/ DEF_VALS1(MQCHS_REQUESTING),
/*  8*/ DEF_VALS1(MQCHS_PAUSED),
/*  9*/ DEF_VALS1(MQCHS_DISCONNECTED),
/* 13*/ DEF_VALS1(MQCHS_INITIALIZING),
/* 14*/ DEF_VALS1(MQCHS_SWITCHING),
DEF_VALSE;

DEF_VALSB(ChannelSubStates)
/*    0*/ DEF_VALS1(MQCHSSTATE_OTHER),
/*  100*/ DEF_VALS1(MQCHSSTATE_END_OF_BATCH),
/*  200*/ DEF_VALS1(MQCHSSTATE_SENDING),
/*  300*/ DEF_VALS1(MQCHSSTATE_RECEIVING),
/*  400*/ DEF_VALS1(MQCHSSTATE_SERIALIZING),
/*  500*/ DEF_VALS1(MQCHSSTATE_RESYNCHING),
/*  600*/ DEF_VALS1(MQCHSSTATE_HEARTBEATING),
/*  700*/ DEF_VALS1(MQCHSSTATE_IN_SCYEXIT),
/*  800*/ DEF_VALS1(MQCHSSTATE_IN_RCVEXIT),
/*  900*/ DEF_VALS1(MQCHSSTATE_IN_SENDEXIT),
/* 1000*/ DEF_VALS1(MQCHSSTATE_IN_MSGEXIT),
/* 1100*/ DEF_VALS1(MQCHSSTATE_IN_MREXIT),
/* 1200*/ DEF_VALS1(MQCHSSTATE_IN_CHADEXIT),
/* 1250*/ DEF_VALS1(MQCHSSTATE_NET_CONNECTING),
/* 1300*/ DEF_VALS1(MQCHSSTATE_SSL_HANDSHAKING),
/* 1400*/ DEF_VALS1(MQCHSSTATE_NAME_SERVER),
/* 1500*/ DEF_VALS1(MQCHSSTATE_IN_MQPUT),
/* 1600*/ DEF_VALS1(MQCHSSTATE_IN_MQGET),
/* 1700*/ DEF_VALS1(MQCHSSTATE_IN_MQI_CALL),
/* 1800*/ DEF_VALS1(MQCHSSTATE_COMPRESSING),
DEF_VALSE;

#if 0
DEF_VALSB(ChannelSharedRestartOptions)
/* 0*/ DEF_VALS1(MQCHSH_RESTART_NO),
/* 1*/ DEF_VALS1(MQCHSH_RESTART_YES),
DEF_VALSE;
#endif

DEF_VALSB(ChannelStopOptions)
/* 0*/ DEF_VALS1(MQCHSR_STOP_NOT_REQUESTED),
/* 1*/ DEF_VALS1(MQCHSR_STOP_REQUESTED),
DEF_VALSE;

#if 0
DEF_VALSB(ChannelTableTypes)
/* 1*/ DEF_VALS1(MQCHTAB_Q_MGR),
/* 2*/ DEF_VALS1(MQCHTAB_CLNTCONN),
DEF_VALSE;
#endif

DEF_VALSB(MQINBD)
/* 0*/ DEF_VALS1(MQINBD_Q_MGR),
/* 3*/ DEF_VALS1(MQINBD_GROUP),
DEF_VALSE;

DEF_VALSB(ChinitTraceAutoStart)
/* 0*/ DEF_VALS1(MQTRAXSTR_NO),
/* 1*/ DEF_VALS1(MQTRAXSTR_YES),
DEF_VALSE;

#if 0
DEF_VALSB(ClearTopicStringScope)
/* 1*/ DEF_VALS1(MQCLRS_LOCAL),
/* 2*/ DEF_VALS1(MQCLRS_GLOBAL),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(ClearTopicStringType)
/* 1*/ DEF_VALS1(MQCLRT_RETAINED),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(DisconnectTypes)
/* 0*/ DEF_VALS1(MQDISCONNECT_NORMAL),
/* 1*/ DEF_VALS1(MQDISCONNECT_IMPLICIT),
/* 2*/ DEF_VALS1(MQDISCONNECT_Q_MGR),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(EscapeTypes)
/* 1*/ DEF_VALS1(MQET_MQSC),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(EventRecording)
/* 0*/ DEF_VALS1(MQEVR_DISABLED),
/* 1*/ DEF_VALS1(MQEVR_ENABLED),
/* 2*/ DEF_VALS1(MQEVR_EXCEPTION),
/* 3*/ DEF_VALS1(MQEVR_NO_DISPLAY),
/* 4*/ DEF_VALS1(MQEVR_API_ONLY),
/* 5*/ DEF_VALS1(MQEVR_ADMIN_ONLY),
/* 6*/ DEF_VALS1(MQEVR_USER_ONLY),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(ForceOptions)
/* 0*/ DEF_VALS1(MQFC_NO),
/* 1*/ DEF_VALS1(MQFC_YES),
DEF_VALSE;
#endif

DEF_VALSB(HandleStates)
/* 0*/ DEF_VALS1(MQHSTATE_INACTIVE),
/* 1*/ DEF_VALS1(MQHSTATE_ACTIVE),
DEF_VALSE;

#if 0
DEF_VALSB(InboundDispositions)
/* 0*/ DEF_VALS1(MQINBD_Q_MGR),
/* 3*/ DEF_VALS1(MQINBD_GROUP),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(IndoubtOptions)
/* 1*/ DEF_VALS1(MQIDO_COMMIT),
/* 2*/ DEF_VALS1(MQIDO_BACKOUT),
DEF_VALSE;
#endif

DEF_VALSB(MessageChannelAgentStatus)
/* 0*/ DEF_VALS1(MQMCAS_STOPPED),
/* 3*/ DEF_VALS1(MQMCAS_RUNNING),
DEF_VALSE;

#if 0
DEF_VALSB(ModeOptions)
/* 0*/ DEF_VALS1(MQMODE_FORCE),
/* 1*/ DEF_VALS1(MQMODE_QUIESCE),
/* 2*/ DEF_VALS1(MQMODE_TERMINATE),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(PurgeOptions)
/* 0*/ DEF_VALS1(MQPO_NO),
/* 1*/ DEF_VALS1(MQPO_YES),
DEF_VALSE;
#endif

DEF_VALSB(PubSubCluster)
/* 0*/ DEF_VALS1(MQPSCLUS_DISABLED),
/* 1*/ DEF_VALS1(MQPSCLUS_ENABLED),
DEF_VALSE;

DEF_VALSB(PubSubMode)
/* 0*/ DEF_VALS1(MQPSM_DISABLED),
/* 1*/ DEF_VALS1(MQPSM_COMPAT),
/* 2*/ DEF_VALS1(MQPSM_ENABLED),
DEF_VALSE;

DEF_VALSB(PubSubSync)
/* 0*/ DEF_VALS1(MQSYNCPOINT_YES),
/* 1*/ DEF_VALS1(MQSYNCPOINT_IFPER),
DEF_VALSE;

#if 0
DEF_VALSB(PubSubStatusType)
/* 0*/ DEF_VALS1(MQPSST_ALL),
/* 1*/ DEF_VALS1(MQPSST_LOCAL),
/* 2*/ DEF_VALS1(MQPSST_PARENT),
/* 3*/ DEF_VALS1(MQPSST_CHILD),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(PubSubStatus)
/* 0*/ DEF_VALS1(MQPS_STATUS_INACTIVE),
/* 1*/ DEF_VALS1(MQPS_STATUS_STARTING),
/* 2*/ DEF_VALS1(MQPS_STATUS_STOPPING),
/* 3*/ DEF_VALS1(MQPS_STATUS_ACTIVE),
/* 4*/ DEF_VALS1(MQPS_STATUS_COMPAT),
/* 5*/ DEF_VALS1(MQPS_STATUS_ERROR),
/* 6*/ DEF_VALS1(MQPS_STATUS_REFUSED),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(QueueManagerDefinitionTypes)
/* 1*/ DEF_VALS1(MQQMDT_EXPLICIT_CLUSTER_SENDER),
/* 2*/ DEF_VALS1(MQQMDT_AUTO_CLUSTER_SENDER),
/* 3*/ DEF_VALS1(MQQMDT_CLUSTER_RECEIVER),
/* 4*/ DEF_VALS1(MQQMDT_AUTO_EXP_CLUSTER_SENDER),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(QueueManagerFacility)
/* 1*/ DEF_VALS1(MQQMFAC_IMS_BRIDGE),
/* 2*/ DEF_VALS1(MQQMFAC_DB2),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(QueueManagerStatus)
/* 1*/ DEF_VALS1(MQQMSTA_STARTING),
/* 2*/ DEF_VALS1(MQQMSTA_RUNNING),
/* 3*/ DEF_VALS1(MQQMSTA_QUIESCING),
/* 4*/ DEF_VALS1(MQQMSTA_STANDBY),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(QueueManagerTypes)
/* 0*/ DEF_VALS1(MQQMT_NORMAL),
/* 1*/ DEF_VALS1(MQQMT_REPOSITORY),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(QuiesceOptions)
/* 0*/ DEF_VALS1(MQQO_NO),
/* 1*/ DEF_VALS1(MQQO_YES),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(QueueServiceIntervalEvents)
/* 0*/ DEF_VALS1(MQQSIE_NONE),
/* 1*/ DEF_VALS1(MQQSIE_HIGH),
/* 2*/ DEF_VALS1(MQQSIE_OK),
DEF_VALSE;
#endif

DEF_VALSB(QueueStatusOpenTypes)
/* 1*/ DEF_VALS1(MQQSOT_ALL),
/* 2*/ DEF_VALS1(MQQSOT_INPUT),
/* 3*/ DEF_VALS1(MQQSOT_OUTPUT),
DEF_VALSE;

#if 0
DEF_VALSB(NameListTypes)
/*    0*/ DEF_VALS1(MQNT_NONE),
/*    1*/ DEF_VALS1(MQNT_Q),
/*    2*/ DEF_VALS1(MQNT_CLUSTER),
/*    4*/ DEF_VALS1(MQNT_AUTH_INFO),
/* 1001*/ DEF_VALS1(MQNT_ALL),
DEF_VALSE;
#endif

DEF_VALSB(QSGStatus)
/* 0*/ DEF_VALS1(MQQSGS_UNKNOWN),
/* 1*/ DEF_VALS1(MQQSGS_CREATED),
/* 2*/ DEF_VALS1(MQQSGS_ACTIVE),
/* 3*/ DEF_VALS1(MQQSGS_INACTIVE),
/* 4*/ DEF_VALS1(MQQSGS_FAILED),
/* 5*/ DEF_VALS1(MQQSGS_PENDING),
DEF_VALSE;

#if 0
DEF_VALSB(QueueStatusType)
/* 1104*/ DEF_VALS1(MQIACF_Q_HANDLE),
/* 1105*/ DEF_VALS1(MQIACF_Q_STATUS),
DEF_VALSE;
#endif

DEF_VALSB(QueueStatusOptionsYesNo)
/* 0*/ DEF_VALS1(MQQSO_NO),
/* 1*/ DEF_VALS1(MQQSO_YES),
DEF_VALSE;

DEF_VALSB(QueueStatusOpenOptions)
/* 0*/ DEF_VALS1(MQQSO_NO),
/* 1*/ DEF_VALS1(MQQSO_SHARED),
/* 2*/ DEF_VALS1(MQQSO_EXCLUSIVE),
DEF_VALSE;

#if 0
DEF_VALSB(QueueStatusUncommittedMessages)
/* 0*/ DEF_VALS1(MQQSUM_NO),
/* 1*/ DEF_VALS1(MQQSUM_YES),
DEF_VALSE;
#endif

DEF_VALSB(ReplaceOptions)
/* 0*/ DEF_VALS1(MQRP_NO),
/* 1*/ DEF_VALS1(MQRP_YES),
DEF_VALSE;

DEF_VALSB(MQRQ)
/*  1*/ DEF_VALS1(MQRQ_CONN_NOT_AUTHORIZED),
/*  2*/ DEF_VALS1(MQRQ_OPEN_NOT_AUTHORIZED),
/*  3*/ DEF_VALS1(MQRQ_CLOSE_NOT_AUTHORIZED),
/*  4*/ DEF_VALS1(MQRQ_CMD_NOT_AUTHORIZED),
/*  5*/ DEF_VALS1(MQRQ_Q_MGR_STOPPING),
/*  6*/ DEF_VALS1(MQRQ_Q_MGR_QUIESCING),
/*  7*/ DEF_VALS1(MQRQ_CHANNEL_STOPPED_OK),
/*  8*/ DEF_VALS1(MQRQ_CHANNEL_STOPPED_ERROR),
/*  9*/ DEF_VALS1(MQRQ_CHANNEL_STOPPED_RETRY),
/* 10*/ DEF_VALS1(MQRQ_CHANNEL_STOPPED_DISABLED),
/* 11*/ DEF_VALS1(MQRQ_BRIDGE_STOPPED_OK),
/* 12*/ DEF_VALS1(MQRQ_BRIDGE_STOPPED_ERROR),
/* 13*/ DEF_VALS1(MQRQ_SSL_HANDSHAKE_ERROR),
/* 14*/ DEF_VALS1(MQRQ_SSL_CIPHER_SPEC_ERROR),
/* 15*/ DEF_VALS1(MQRQ_SSL_CLIENT_AUTH_ERROR),
/* 16*/ DEF_VALS1(MQRQ_SSL_PEER_NAME_ERROR),
/* 17*/ DEF_VALS1(MQRQ_SUB_NOT_AUTHORIZED),
/* 18*/ DEF_VALS1(MQRQ_SUB_DEST_NOT_AUTHORIZED),
/* 19*/ DEF_VALS1(MQRQ_SSL_UNKNOWN_REVOCATION),
/* 20*/ DEF_VALS1(MQRQ_SYS_CONN_NOT_AUTHORIZED),
/* 21*/ DEF_VALS1(MQRQ_CHANNEL_BLOCKED_ADDRESS),
/* 22*/ DEF_VALS1(MQRQ_CHANNEL_BLOCKED_USERID),
/* 23*/ DEF_VALS1(MQRQ_CHANNEL_BLOCKED_NOACCESS),
/* 24*/ DEF_VALS1(MQRQ_MAX_ACTIVE_CHANNELS),
/* 25*/ DEF_VALS1(MQRQ_MAX_CHANNELS),
/* 26*/ DEF_VALS1(MQRQ_SVRCONN_INST_LIMIT),
/* 27*/ DEF_VALS1(MQRQ_CLIENT_INST_LIMIT),
/* 28*/ DEF_VALS1(MQRQ_CAF_NOT_INSTALLED),
/* 29*/ DEF_VALS1(MQRQ_CSP_NOT_AUTHORIZED),
/* 30*/ DEF_VALS1(MQRQ_FAILOVER_PERMITTED),
/* 31*/ DEF_VALS1(MQRQ_FAILOVER_NOT_PERMITTED),
/* 32*/ DEF_VALS1(MQRQ_STANDBY_ACTIVATED),
DEF_VALSE;

#if 0
DEF_VALSB(RefreshTypes)
/* 1*/ DEF_VALS1(MQRT_CONFIGURATION),
/* 2*/ DEF_VALS1(MQRT_EXPIRY),
/* 3*/ DEF_VALS1(MQRT_NSPROC),
/* 4*/ DEF_VALS1(MQRT_PROXYSUB),
/* 5*/ DEF_VALS1(MQRT_SUB_CONFIGURATION),
DEF_VALSE;
#endif

DEF_VALSB(QueueDefinitionScope)
/* 1*/ DEF_VALS1(MQSCO_Q_MGR),
/* 2*/ DEF_VALS1(MQSCO_CELL),
DEF_VALSE;

DEF_VALSB(MQSECITEM)
/*  0*/ DEF_VALS1(MQSECITEM_ALL),
/*  1*/ DEF_VALS1(MQSECITEM_MQADMIN),
/*  2*/ DEF_VALS1(MQSECITEM_MQNLIST),
/*  3*/ DEF_VALS1(MQSECITEM_MQPROC),
/*  4*/ DEF_VALS1(MQSECITEM_MQQUEUE),
/*  5*/ DEF_VALS1(MQSECITEM_MQCONN),
/*  6*/ DEF_VALS1(MQSECITEM_MQCMDS),
/*  7*/ DEF_VALS1(MQSECITEM_MXADMIN),
/*  8*/ DEF_VALS1(MQSECITEM_MXNLIST),
/*  9*/ DEF_VALS1(MQSECITEM_MXPROC),
/* 10*/ DEF_VALS1(MQSECITEM_MXQUEUE),
/* */ DEF_VALS1(MQSECITEM_MXTOPIC),
DEF_VALSE;

DEF_VALSB(MQSECSW)
/*  1*/ DEF_VALS1(MQSECSW_PROCESS),
/*  2*/ DEF_VALS1(MQSECSW_NAMELIST),
/*  3*/ DEF_VALS1(MQSECSW_Q),
/*  4*/ DEF_VALS1(MQSECSW_TOPIC),
/*  6*/ DEF_VALS1(MQSECSW_CONTEXT),
/*  7*/ DEF_VALS1(MQSECSW_ALTERNATE_USER),
/*  8*/ DEF_VALS1(MQSECSW_COMMAND),
/*  9*/ DEF_VALS1(MQSECSW_CONNECTION),
/* 10*/ DEF_VALS1(MQSECSW_SUBSYSTEM),
/* 11*/ DEF_VALS1(MQSECSW_COMMAND_RESOURCES),
/* 15*/ DEF_VALS1(MQSECSW_Q_MGR),
/* 16*/ DEF_VALS1(MQSECSW_QSG),
/* 21*/ DEF_VALS1(MQSECSW_OFF_FOUND),
/* 22*/ DEF_VALS1(MQSECSW_ON_FOUND),
/* 23*/ DEF_VALS1(MQSECSW_OFF_NOT_FOUND),
/* 24*/ DEF_VALS1(MQSECSW_ON_NOT_FOUND),
/* 25*/ DEF_VALS1(MQSECSW_OFF_ERROR),
/* 26*/ DEF_VALS1(MQSECSW_ON_OVERRIDDEN),
DEF_VALSE;

DEF_VALSB(MQSECTYPE)
/* 1*/ DEF_VALS1(MQSECTYPE_AUTHSERV),
/* 2*/ DEF_VALS1(MQSECTYPE_SSL),
/* 3*/ DEF_VALS1(MQSECTYPE_CLASSES),
/* 4*/ DEF_VALS1(MQSECTYPE_CONNAUTH),
DEF_VALSE;

DEF_VALSB(MQCHK)
/* 0*/ DEF_VALS1(MQCHK_OPTIONAL),
/* 1*/ DEF_VALS1(MQCHK_NONE),
/* 2*/ DEF_VALS1(MQCHK_REQUIRED_ADMIN),
/* 3*/ DEF_VALS1(MQCHK_REQUIRED),
/* 4*/ DEF_VALS1(MQCHK_AS_Q_MGR),
DEF_VALSE;


DEF_VALSB(MQADPCTX)
/* 0*/ DEF_VALS1(MQADPCTX_NO),
/* 1*/ DEF_VALS1(MQADPCTX_YES),
DEF_VALSE;

DEF_VALSB(MQSECCOMM)
/* 0*/ DEF_VALS1(MQSECCOMM_NO),
/* 1*/ DEF_VALS1(MQSECCOMM_YES),
/* 2*/ DEF_VALS1(MQSECCOMM_ANON),
DEF_VALSE;

DEF_VALSB(MQLDAP_AUTHORMD)
/* 0*/ DEF_VALS1(MQLDAP_AUTHORMD_OS),
/* 1*/ DEF_VALS1(MQLDAP_AUTHORMD_SEARCHGRP),
/* 2*/ DEF_VALS1(MQLDAP_AUTHORMD_SEARCHUSR),
/* 3*/ DEF_VALS1(MQLDAP_AUTHORMD_SRCHGRPSN),
DEF_VALSE;

DEF_VALSB(MQLDAP_NESTGRP)
/* 0*/ DEF_VALS1(MQLDAP_NESTGRP_NO),
/* 1*/ DEF_VALS1(MQLDAP_NESTGRP_YES),
DEF_VALSE;

DEF_VALSB(MQAUTHENTICATE)
/* 0*/ DEF_VALS1(MQAUTHENTICATE_OS),
/* 1*/ DEF_VALS1(MQAUTHENTICATE_PAM),
DEF_VALSE;

DEF_VALSB(MQLDAPC)
/* 0*/ DEF_VALS1(MQLDAPC_INACTIVE),
/* 1*/ DEF_VALS1(MQLDAPC_CONNECTED),
/* 2*/ DEF_VALS1(MQLDAPC_ERROR),
DEF_VALSE;

DEF_VALSB(MQZAET)
/* 0*/ DEF_VALS1(MQZAET_NONE),
/* 1*/ DEF_VALS1(MQZAET_PRINCIPAL),
/* 2*/ DEF_VALS1(MQZAET_GROUP),
/* 3*/ DEF_VALS1(MQZAET_UNKNOWN),
DEF_VALSE;

DEF_VALSB(InhibitPublications)
/* 0*/ DEF_VALS1(MQTA_PUB_AS_PARENT),
/* 1*/ DEF_VALS1(MQTA_PUB_INHIBITED),
/* 2*/ DEF_VALS1(MQTA_PUB_ALLOWED),
DEF_VALSE;

DEF_VALSB(MsgDelivery)
/* 0*/ DEF_VALS1(MQDLV_AS_PARENT),
/* 1*/ DEF_VALS1(MQDLV_ALL),
/* 2*/ DEF_VALS1(MQDLV_ALL_DUR),
/* 3*/ DEF_VALS1(MQDLV_ALL_AVAIL),
DEF_VALSE;

#if 0
DEF_VALSB(ClusterCacheType)
/* 0*/ DEF_VALS1(MQCLCT_STATIC),
/* 1*/ DEF_VALS1(MQCLCT_DYNAMIC),
DEF_VALSE;
#endif

DEF_VALSB(InhibitSubscriptions)
/* 0*/ DEF_VALS1(MQTA_SUB_AS_PARENT),
/* 1*/ DEF_VALS1(MQTA_SUB_INHIBITED),
/* 2*/ DEF_VALS1(MQTA_SUB_ALLOWED),
DEF_VALSE;

DEF_VALSB(ProxySubscriptions)
/* 1*/ DEF_VALS1(MQTA_PROXY_SUB_FORCE),
/* 2*/ DEF_VALS1(MQTA_PROXY_SUB_FIRSTUSE),
DEF_VALSE;

DEF_VALSB(WildcardOperation)
/* 1*/ DEF_VALS1(MQTA_BLOCK),
/* 2*/ DEF_VALS1(MQTA_PASSTHRU),
DEF_VALSE;

DEF_VALSB(TopicType)
/* 0*/ DEF_VALS1(MQTOPT_LOCAL),
/* 1*/ DEF_VALS1(MQTOPT_CLUSTER),
/* 2*/ DEF_VALS1(MQTOPT_ALL),
DEF_VALSE;

#if 0
DEF_VALSB(SelectorTypes)
/* 0*/ DEF_VALS1(MQSELTYPE_NONE),
/* 1*/ DEF_VALS1(MQSELTYPE_STANDARD),
/* 2*/ DEF_VALS1(MQSELTYPE_EXTENDED),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(SuspendStatus)
/* 0*/ DEF_VALS1(MQSUS_NO),
/* 1*/ DEF_VALS1(MQSUS_YES),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(SyncpointPubSub)
/* 0*/ DEF_VALS1(MQSYNCPOINT_YES),
/* 1*/ DEF_VALS1(MQSYNCPOINT_IFPER),
DEF_VALSE;
#endif

DEF_VALSB(MQSYSP)
/*  0*/ DEF_VALS1(MQSYSP_NO),
/*  1*/ DEF_VALS1(MQSYSP_YES),
/*  2*/ DEF_VALS1(MQSYSP_EXTENDED),
/* 10*/ DEF_VALS1(MQSYSP_TYPE_INITIAL),
/* 11*/ DEF_VALS1(MQSYSP_TYPE_SET),
/* 12*/ DEF_VALS1(MQSYSP_TYPE_LOG_COPY),
/* 13*/ DEF_VALS1(MQSYSP_TYPE_LOG_STATUS),
/* 14*/ DEF_VALS1(MQSYSP_TYPE_ARCHIVE_TAPE),
/* 20*/ DEF_VALS1(MQSYSP_ALLOC_BLK),
/* 21*/ DEF_VALS1(MQSYSP_ALLOC_TRK),
/* 22*/ DEF_VALS1(MQSYSP_ALLOC_CYL),
/* 30*/ DEF_VALS1(MQSYSP_STATUS_BUSY),
/* 31*/ DEF_VALS1(MQSYSP_STATUS_PREMOUNT),
/* 32*/ DEF_VALS1(MQSYSP_STATUS_AVAILABLE),
/* 33*/ DEF_VALS1(MQSYSP_STATUS_UNKNOWN),
/* 34*/ DEF_VALS1(MQSYSP_STATUS_ALLOC_ARCHIVE),
/* 35*/ DEF_VALS1(MQSYSP_STATUS_COPYING_BSDS),
/* 36*/ DEF_VALS1(MQSYSP_STATUS_COPYING_LOG),
DEF_VALSE;

DEF_VALSB(MQSUB_DURABLE)
/*-1*/ DEF_VALS1(MQSUB_DURABLE_ALL),
/* 0*/ DEF_VALS1(MQSUB_DURABLE_AS_PARENT),
/* 1*/ DEF_VALS2(MQSUB_DURABLE_ALLOWED, "ALLOWED/YES"),
/* 2*/ DEF_VALS2(MQSUB_DURABLE_INHIBITED, "INHIBITED/NO"),
DEF_VALSE;

DEF_VALSB(MQQSO)
/* 0*/ DEF_VALS1(MQQSO_NO),
/* 1*/ DEF_VALS2(MQQSO_YES, "SHARED/YES"),
/* 2*/ DEF_VALS1(MQQSO_EXCLUSIVE),
DEF_VALSE;

DEF_VALSB(MQSUBTYPE)
/* -2*/ DEF_VALS1(MQSUBTYPE_USER),
/* -1*/ DEF_VALS1(MQSUBTYPE_ALL),
/*  1*/ DEF_VALS1(MQSUBTYPE_API),
/*  2*/ DEF_VALS1(MQSUBTYPE_ADMIN),
/*  3*/ DEF_VALS1(MQSUBTYPE_PROXY),
DEF_VALSE;

#if 0
DEF_VALSB(SubscriptionDestinationClass)
/* 1*/ DEF_VALS1(MQDC_MANAGED),
/* 2*/ DEF_VALS1(MQDC_PROVIDED),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(MQRU_PUBLISH)
/* 1*/ DEF_VALS1(MQRU_PUBLISH_ON_REQUEST),
/* 2*/ DEF_VALS1(MQRU_PUBLISH_ALL),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(TimeUnits)
/* 0*/ DEF_VALS1(MQTIME_UNIT_MINS),
/* 1*/ DEF_VALS1(MQTIME_UNIT_SECS),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(VariableUser)
/* 1*/ DEF_VALS1(MQVU_FIXED_USER),
/* 2*/ DEF_VALS1(MQVU_ANY_USER),
DEF_VALSE;
#endif

#if 0
DEF_VALSB(WildcardSchema)
/* 0*/ DEF_VALS1(MQWS_DEFAULT),
/* 1*/ DEF_VALS1(MQWS_CHAR),
/* 2*/ DEF_VALS1(MQWS_TOPIC),
DEF_VALSE;
#endif

DEF_VALSB(MQUIDSUPP)
/* 0*/ DEF_VALS1(MQUIDSUPP_NO),
/* 1*/ DEF_VALS1(MQUIDSUPP_YES),
DEF_VALSE;

DEF_VALSB(MQUNDELIVERED)
/* 0*/ DEF_VALS1(MQUNDELIVERED_NORMAL),
/* 1*/ DEF_VALS1(MQUNDELIVERED_SAFE),
/* 2*/ DEF_VALS1(MQUNDELIVERED_DISCARD),
/* 3*/ DEF_VALS1(MQUNDELIVERED_KEEP),
DEF_VALSE;

DEF_VALSB(UOWStates)
/* 0*/ DEF_VALS1(MQUOWST_NONE),
/* 1*/ DEF_VALS1(MQUOWST_ACTIVE),
/* 2*/ DEF_VALS1(MQUOWST_PREPARED),
/* 3*/ DEF_VALS1(MQUOWST_UNRESOLVED),
DEF_VALSE;

DEF_VALSB(UOWTypes)
/* 0*/ DEF_VALS1(MQUOWT_Q_MGR),
/* 1*/ DEF_VALS1(MQUOWT_CICS),
/* 2*/ DEF_VALS1(MQUOWT_RRS),
/* 3*/ DEF_VALS1(MQUOWT_IMS),
/* 4*/ DEF_VALS1(MQUOWT_XA),
DEF_VALSE;

DEF_VALSB(MQUSAGE_PS)
/* 0*/ DEF_VALS1(MQUSAGE_PS_AVAILABLE),
/* 1*/ DEF_VALS1(MQUSAGE_PS_DEFINED),
/* 2*/ DEF_VALS1(MQUSAGE_PS_OFFLINE),
/* 3*/ DEF_VALS1(MQUSAGE_PS_NOT_DEFINED),
DEF_VALSE;

DEF_VALSB(MQUSAGE_EXPAND)
/* 1*/ DEF_VALS1(MQUSAGE_EXPAND_USER),
/* 2*/ DEF_VALS1(MQUSAGE_EXPAND_SYSTEM),
/* 3*/ DEF_VALS1(MQUSAGE_EXPAND_NONE),
DEF_VALSE;

DEF_VALSB(MQUSAGE_DS)
/* 10*/ DEF_VALS1(MQUSAGE_DS_OLDEST_ACTIVE_UOW),
/* 11*/ DEF_VALS1(MQUSAGE_DS_OLDEST_PS_RECOVERY),
/* 12*/ DEF_VALS1(MQUSAGE_DS_OLDEST_CF_RECOVERY),
DEF_VALSE;

#if 0
DEF_VALSB(ActivityOperations)
/*  0*/ DEF_VALS1(MQOPER_UNKNOWN),
/*  1*/ DEF_VALS1(MQOPER_BROWSE),
/*  2*/ DEF_VALS1(MQOPER_DISCARD),
/*  3*/ DEF_VALS1(MQOPER_GET),
/*  4*/ DEF_VALS1(MQOPER_PUT),
/*  5*/ DEF_VALS1(MQOPER_PUT_REPLY),
/*  6*/ DEF_VALS1(MQOPER_PUT_REPORT),
/*  7*/ DEF_VALS1(MQOPER_RECEIVE),
/*  8*/ DEF_VALS1(MQOPER_SEND),
/*  9*/ DEF_VALS1(MQOPER_TRANSFORM),
/* 10*/ DEF_VALS1(MQOPER_PUBLISH),
/* 11*/ DEF_VALS1(MQOPER_EXCLUDED_PUBLISH),
/* 12*/ DEF_VALS1(MQOPER_DISCARDED_PUBLISH),
DEF_VALSE;
#endif

DEF_VALSB(ConnInfoType)
/* 1111*/ DEF_VALS1(MQIACF_CONN_INFO_CONN),
/* 1112*/ DEF_VALS1(MQIACF_CONN_INFO_HANDLE),
/* 1113*/ DEF_VALS1(MQIACF_CONN_INFO_ALL),
DEF_VALSE;

DEF_VALSB(MQPRI)
/* -3*/ DEF_VALS1(MQPRI_PRIORITY_AS_PUBLISHED),
/* -2*/ DEF_VALS1(MQPRI_PRIORITY_AS_PARENT),
/* -1*/ DEF_VALS1(MQPRI_PRIORITY_AS_Q_DEF),
/*  0*/ DEF_VALS1(0),
/*  1*/ DEF_VALS1(1),
/*  2*/ DEF_VALS1(2),
/*  3*/ DEF_VALS1(3),
/*  4*/ DEF_VALS1(4),
/*  5*/ DEF_VALS1(5),
/*  6*/ DEF_VALS1(6),
/*  7*/ DEF_VALS1(7),
/*  8*/ DEF_VALS1(8),
/*  9*/ DEF_VALS1(9),
DEF_VALSE;

DEF_VALSB(MQPSPROP)
/* 0*/ DEF_VALS1(MQPSPROP_NONE),
/* 1*/ DEF_VALS1(MQPSPROP_COMPAT),
/* 2*/ DEF_VALS1(MQPSPROP_RFH2),
/* 3*/ DEF_VALS1(MQPSPROP_MSGPROP),
DEF_VALSE;

DEF_VALSB(PubSubScope)
/* 0*/ DEF_VALS1(MQSCOPE_ALL),
/* 1*/ DEF_VALS1(MQSCOPE_AS_PARENT),
/* 4*/ DEF_VALS1(MQSCOPE_QMGR),
DEF_VALSE;

DEF_VALSB(MQ_SUITE_B)
/* 0*/ DEF_VALS1(MQ_SUITE_B_NOT_AVAILABLE),
/* 1*/ DEF_VALS1(MQ_SUITE_B_NONE),
/* 2*/ DEF_VALS1(MQ_SUITE_B_128_BIT),
/* 4*/ DEF_VALS1(MQ_SUITE_B_192_BIT),
DEF_VALSE;

DEF_VALSB(MQMC)
/* 0*/ DEF_VALS1(MQMC_AS_PARENT),
/* 1*/ DEF_VALS1(MQMC_ENABLED),
/* 2*/ DEF_VALS1(MQMC_DISABLED),
/* 3*/ DEF_VALS1(MQMC_ONLY),
DEF_VALSE;

DEF_VALSB(MQUSEDLQ)
/* 0*/ DEF_VALS1(MQUSEDLQ_AS_PARENT),
/* 1*/ DEF_VALS1(MQUSEDLQ_NO),
/* 2*/ DEF_VALS1(MQUSEDLQ_YES),
DEF_VALSE;

DEF_VALSB(MQCLROUTE)
/* 0*/ DEF_VALS1(MQCLROUTE_DIRECT),
/* 1*/ DEF_VALS1(MQCLROUTE_TOPIC_HOST),
/* 2*/ DEF_VALS1(MQCLROUTE_NONE),
DEF_VALSE;

DEF_VALSB(MQCLST)
/* 0*/ DEF_VALS1(MQCLST_ACTIVE),
/* 1*/ DEF_VALS1(MQCLST_PENDING),
/* 2*/ DEF_VALS1(MQCLST_INVALID),
/* 3*/ DEF_VALS1(MQCLST_ERROR),
DEF_VALSE;

DEF_VALSB(MQMULC)
/* 0*/ DEF_VALS1(MQMULC_STANDARD),
/* 1*/ DEF_VALS1(MQMULC_REFINED),
DEF_VALSE;

DEF_VALSB(IGQPutAuthority)
/* 1*/ DEF_VALS1(MQIGQPA_DEFAULT),
/* 2*/ DEF_VALS1(MQIGQPA_CONTEXT),
/* 3*/ DEF_VALS1(MQIGQPA_ONLY_IGQ),
/* 4*/ DEF_VALS1(MQIGQPA_ALTERNATE_OR_IGQ),
DEF_VALSE;

DEF_VALSB(SecurityCase)
/* 0*/ DEF_VALS1(MQSCYC_UPPER),
/* 1*/ DEF_VALS1(MQSCYC_MIXED),
DEF_VALSE;

DEF_VALSB(ChlauthType)
/* 0*/ DEF_VALS1(MQCAUT_ALL),
/* 1*/ DEF_VALS1(MQCAUT_BLOCKUSER),
/* 2*/ DEF_VALS1(MQCAUT_BLOCKADDR),
/* 3*/ DEF_VALS1(MQCAUT_SSLPEERMAP),
/* 4*/ DEF_VALS1(MQCAUT_ADDRESSMAP),
/* 5*/ DEF_VALS1(MQCAUT_USERMAP),
/* 6*/ DEF_VALS1(MQCAUT_QMGRMAP),
DEF_VALSE;

DEF_VALSB(UserSource)
/* 0*/ DEF_VALS1(MQUSRC_MAP),
/* 1*/ DEF_VALS1(MQUSRC_NOACCESS),
/* 2*/ DEF_VALS1(MQUSRC_CHANNEL),
DEF_VALSE;

DEF_VALSB(Warning)
/* 0*/ DEF_VALS1(MQWARN_NO),
/* 1*/ DEF_VALS1(MQWARN_YES),
DEF_VALSE;

DEF_VALSB(CertValPolicy)
/* 0*/ DEF_VALS1(MQ_CERT_VAL_POLICY_ANY),
/* 1*/ DEF_VALS1(MQ_CERT_VAL_POLICY_RFC5280),
DEF_VALSE;

DEF_VALSB(ChanAutoDef)
/* 0*/ DEF_VALS1(MQCHAD_DISABLED),
/* 1*/ DEF_VALS1(MQCHAD_ENABLED),
DEF_VALSE;

DEF_VALSB(ChlAuthRecords)
/* 0*/ DEF_VALS1(MQCHLA_DISABLED),
/* 1*/ DEF_VALS1(MQCHLA_ENABLED),
DEF_VALSE;

DEF_VALSB(DefClusXmitTyp)
/* 0*/ DEF_VALS1(MQCLXQ_SCTQ),
/* 1*/ DEF_VALS1(MQCLXQ_CHANNEL),
DEF_VALSE;

DEF_VALSB(MQSVC_CONTROL)
/* 0*/ DEF_VALS1(MQSVC_CONTROL_Q_MGR),
/* 1*/ DEF_VALS1(MQSVC_CONTROL_Q_MGR_START),
/* 2*/ DEF_VALS1(MQSVC_CONTROL_MANUAL),
DEF_VALSE;

DEF_VALSB(MQSVC_STATUS)
/* 0*/ DEF_VALS1(MQSVC_STATUS_STOPPED),
/* 1*/ DEF_VALS1(MQSVC_STATUS_STARTING),
/* 2*/ DEF_VALS1(MQSVC_STATUS_RUNNING),
/* 3*/ DEF_VALS1(MQSVC_STATUS_STOPPING),
/* 4*/ DEF_VALS1(MQSVC_STATUS_RETRYING),
DEF_VALSE;

DEF_VALSB(MQCAP)
/* 0*/ DEF_VALS1(MQCAP_NOT_SUPPORTED),
/* 1*/ DEF_VALS1(MQCAP_SUPPORTED),
/* 2*/ DEF_VALS1(MQCAP_EXPIRED),
DEF_VALSE;

DEF_VALSB(FipsRequired)
/* 0*/ DEF_VALS1(MQSSL_FIPS_NO),
/* 1*/ DEF_VALS1(MQSSL_FIPS_YES),
DEF_VALSE;

DEF_VALSB(SyncpointAvailability)
/* 0*/ DEF_VALS1(MQSP_NOT_AVAILABLE),
/* 1*/ DEF_VALS1(MQSP_AVAILABLE),
DEF_VALSE;

DEF_VALSBX(UOWControls)
/* 0x00000111*/ DEF_VALS1(MQCUOWC_ONLY),
/* 0x00010000*/ DEF_VALS1(MQCUOWC_CONTINUE),
/* 0x00000011*/ DEF_VALS1(MQCUOWC_FIRST),
/* 0x00000010*/ DEF_VALS1(MQCUOWC_MIDDLE),
/* 0x00000110*/ DEF_VALS1(MQCUOWC_LAST),
/* 0x00000100*/ DEF_VALS1(MQCUOWC_COMMIT),
/* 0x00001100*/ DEF_VALS1(MQCUOWC_BACKOUT),
DEF_VALSE;

DEF_VALSBX(LinkType)
/* 1*/ DEF_VALS1(MQCLT_PROGRAM),
/* 2*/ DEF_VALS1(MQCLT_TRANSACTION),
DEF_VALSE;

DEF_VALSBX(ADSDescr)
/* 0x00000000*/ DEF_VALS1(MQCADSD_NONE),
/* 0x00000001*/ DEF_VALS1(MQCADSD_SEND),
/* 0x00000010*/ DEF_VALS1(MQCADSD_RECV),
/* 0x00000100*/ DEF_VALS1(MQCADSD_MSGFORMAT),
DEF_VALSE;

DEF_VALSBX(ConvTaskOpt)
/* 0x00000000*/ DEF_VALS1(MQCCT_NO),
/* 0x00000001*/ DEF_VALS1(MQCCT_YES),
DEF_VALSE;

DEF_VALSBX(TaskEndStatus)
/* 0x00000000*/ DEF_VALS1(MQCTES_NOSYNC),
/* 0x00000100*/ DEF_VALS1(MQCTES_COMMIT),
/* 0x00001100*/ DEF_VALS1(MQCTES_BACKOUT),
/* 0x00010000*/ DEF_VALS1(MQCTES_ENDTASK),
DEF_VALSE;

DEF_VALSB(CFRecoverability)
/* 0*/ DEF_VALS1(MQCFR_NO),
/* 1*/ DEF_VALS1(MQCFR_YES),
DEF_VALSE;

DEF_VALSB(DSBlock)
/* 0*/ DEF_VALS1(MQDSB_DEFAULT),
/* 1*/ DEF_VALS1(MQDSB_8K),
/* 2*/ DEF_VALS1(MQDSB_16K),
/* 3*/ DEF_VALS1(MQDSB_32K),
/* 4*/ DEF_VALS1(MQDSB_64K),
/* 5*/ DEF_VALS1(MQDSB_128K),
/* 6*/ DEF_VALS1(MQDSB_256K),
/* 7*/ DEF_VALS1(MQDSB_512K),
/* 8*/ DEF_VALS1(MQDSB_1024K),
/* 9*/ DEF_VALS1(MQDSB_1M),
DEF_VALSE;

DEF_VALSB(DSExpand)
/* 0*/ DEF_VALS1(MQDSE_DEFAULT),
/* 1*/ DEF_VALS1(MQDSE_YES),
/* 2*/ DEF_VALS1(MQDSE_NO),
DEF_VALSE;

DEF_VALSB(OffloadUse)
/* 0*/ DEF_VALS1(MQCFOFFLD_NONE),
/* 1*/ DEF_VALS1(MQCFOFFLD_SMDS),
/* 2*/ DEF_VALS1(MQCFOFFLD_DB2),
/* 3*/ DEF_VALS1(MQCFOFFLD_BOTH),
DEF_VALSE;

DEF_VALSB(CFAutomaticRecovery)
/* 0*/ DEF_VALS1(MQRECAUTO_NO),
/* 1*/ DEF_VALS1(MQRECAUTO_YES),
DEF_VALSE;

DEF_VALSB(CFLossConnectivity)
/* 0*/ DEF_VALS1(MQCFCONLOS_TERMINATE),
/* 1*/ DEF_VALS1(MQCFCONLOS_TOLERATE),
/* 2*/ DEF_VALS1(MQCFCONLOS_ASQMGR),
DEF_VALSE;

DEF_VALSB(CFStatus)
/*  0*/ DEF_VALS1(MQCFSTATUS_NOT_FOUND),
/*  1*/ DEF_VALS1(MQCFSTATUS_ACTIVE),
/*  2*/ DEF_VALS1(MQCFSTATUS_IN_RECOVER),
/*  3*/ DEF_VALS1(MQCFSTATUS_IN_BACKUP),
/*  4*/ DEF_VALS1(MQCFSTATUS_FAILED),
/*  5*/ DEF_VALS1(MQCFSTATUS_NONE),
/*  6*/ DEF_VALS1(MQCFSTATUS_UNKNOWN),
/*  7*/ DEF_VALS1(MQCFSTATUS_RECOVERED),
/*  8*/ DEF_VALS1(MQCFSTATUS_EMPTY),
/*  9*/ DEF_VALS1(MQCFSTATUS_NEW),
/* 20*/ DEF_VALS1(MQCFSTATUS_ADMIN_INCOMPLETE),
/* 21*/ DEF_VALS1(MQCFSTATUS_NEVER_USED),
/* 22*/ DEF_VALS1(MQCFSTATUS_NO_BACKUP),
/* 23*/ DEF_VALS1(MQCFSTATUS_NOT_FAILED),
/* 24*/ DEF_VALS1(MQCFSTATUS_NOT_RECOVERABLE),
/* 25*/ DEF_VALS1(MQCFSTATUS_XES_ERROR),
DEF_VALSE;

DEF_VALSB(CFStatusType)
/* 1136*/ DEF_VALS1(MQIACF_CF_STATUS_SUMMARY),
/* 1137*/ DEF_VALS1(MQIACF_CF_STATUS_CONNECT),
/* 1138*/ DEF_VALS1(MQIACF_CF_STATUS_BACKUP),
/* 1333*/ DEF_VALS1(MQIACF_CF_STATUS_SMDS),
DEF_VALSE;

DEF_VALSB(CFStructType)
/* 0*/ DEF_VALS1(MQCFTYPE_APPL),
/* 1*/ DEF_VALS1(MQCFTYPE_ADMIN),
DEF_VALSE;

DEF_VALSB(AccessOptions)
/* 0*/ DEF_VALS1(MQCFACCESS_ENABLED),
/* 1*/ DEF_VALS1(MQCFACCESS_SUSPENDED),
/* 2*/ DEF_VALS1(MQCFACCESS_DISABLED),
DEF_VALSE;

DEF_VALSB(OpenMode)
/* 0*/ DEF_VALS1(MQS_OPENMODE_NONE),
/* 1*/ DEF_VALS1(MQS_OPENMODE_READONLY),
/* 2*/ DEF_VALS1(MQS_OPENMODE_UPDATE),
/* 3*/ DEF_VALS1(MQS_OPENMODE_RECOVERY),
DEF_VALSE;

DEF_VALSB(SMDSStatus)
/* 0*/ DEF_VALS1(MQS_STATUS_CLOSED),
/* 1*/ DEF_VALS1(MQS_STATUS_CLOSING),
/* 2*/ DEF_VALS1(MQS_STATUS_OPENING),
/* 3*/ DEF_VALS1(MQS_STATUS_OPEN),
/* 4*/ DEF_VALS1(MQS_STATUS_NOTENABLED),
/* 5*/ DEF_VALS1(MQS_STATUS_ALLOCFAIL),
/* 6*/ DEF_VALS1(MQS_STATUS_OPENFAIL),
/* 7*/ DEF_VALS1(MQS_STATUS_STGFAIL),
/* 8*/ DEF_VALS1(MQS_STATUS_DATAFAIL),
DEF_VALSE;

DEF_VALSB(SMDSAvail)
/* 0*/ DEF_VALS1(MQS_AVAIL_NORMAL),
/* 1*/ DEF_VALS1(MQS_AVAIL_ERROR),
/* 2*/ DEF_VALS1(MQS_AVAIL_STOPPED),
DEF_VALSE;

DEF_VALSB(SMDSExpandSt)
/* 0*/ DEF_VALS1(MQS_EXPANDST_NORMAL),
/* 1*/ DEF_VALS1(MQS_EXPANDST_FAILED),
/* 2*/ DEF_VALS1(MQS_EXPANDST_MAXIMUM),
DEF_VALSE;

DEF_VALSB(MQRDNS)
/* 0*/ DEF_VALS1(MQRDNS_ENABLED),
/* 1*/ DEF_VALS1(MQRDNS_DISABLED),
DEF_VALSE;

DEF_VALSB(MQCIT)
/* 1*/ DEF_VALS1(MQCIT_MULTICAST),
DEF_VALSE;

DEF_VALSB(MQMCB)
/* 0*/ DEF_VALS1(MQMCB_DISABLED),
/* 1*/ DEF_VALS1(MQMCB_ENABLED),
DEF_VALSE;

DEF_VALSB(MQNSH)
/*-1*/ DEF_VALS1(MQNSH_ALL),
/* 0*/ DEF_VALS1(MQNSH_NONE),
DEF_VALSE;

DEF_VALSB(MQPSST)
/* 0*/ DEF_VALS1(MQPSST_ALL),
/* 1*/ DEF_VALS1(MQPSST_LOCAL),
/* 2*/ DEF_VALS1(MQPSST_PARENT),
/* 3*/ DEF_VALS1(MQPSST_CHILD),
DEF_VALSE;

DEF_VALSB(SMDSUsage)
/* 0*/ DEF_VALS1(MQUSAGE_SMDS_AVAILABLE),
/* 1*/ DEF_VALS1(MQUSAGE_SMDS_NO_DATA),
DEF_VALSE;

DEF_VALSB(MQSTDBY)
/* 0*/ DEF_VALS1(MQSTDBY_NOT_PERMITTED),
/* 1*/ DEF_VALS1(MQSTDBY_PERMITTED),
DEF_VALSE;

DEF_VALSB(MQAT)
/*    0*/ DEF_VALS1(MQAT_NO_CONTEXT),
/*    1*/ DEF_VALS1(MQAT_CICS),
/*    2*/ DEF_VALS1(MQAT_ZOS),
/*    3*/ DEF_VALS1(MQAT_IMS),
/*    4*/ DEF_VALS1(MQAT_OS2),
/*    5*/ DEF_VALS1(MQAT_DOS),
/*    6*/ DEF_VALS1(MQAT_UNIX),
/*    7*/ DEF_VALS1(MQAT_QMGR),
/*    8*/ DEF_VALS1(MQAT_OS400),
/*    9*/ DEF_VALS1(MQAT_WINDOWS),
/*   10*/ DEF_VALS1(MQAT_CICS_VSE),
/*   11*/ DEF_VALS1(MQAT_WINDOWS_NT),
/*   12*/ DEF_VALS1(MQAT_VMS),
/*   13*/ DEF_VALS1(MQAT_NSK),
/*   14*/ DEF_VALS1(MQAT_VOS),
/*   15*/ DEF_VALS1(MQAT_OPEN_TP1),
/*   18*/ DEF_VALS1(MQAT_VM),
/*   19*/ DEF_VALS1(MQAT_IMS_BRIDGE),
/*   20*/ DEF_VALS1(MQAT_XCF),
/*   21*/ DEF_VALS1(MQAT_CICS_BRIDGE),
/*   22*/ DEF_VALS1(MQAT_NOTES_AGENT),
/*   23*/ DEF_VALS1(MQAT_TPF),
/*   25*/ DEF_VALS1(MQAT_USER),
/*   26*/ DEF_VALS1(MQAT_QMGR_PUBLISH),
/*   28*/ DEF_VALS1(MQAT_JAVA),
/*   29*/ DEF_VALS1(MQAT_DQM),
/*   30*/ DEF_VALS1(MQAT_CHANNEL_INITIATOR),
/*   31*/ DEF_VALS1(MQAT_WLM),
/*   32*/ DEF_VALS1(MQAT_BATCH),
/*   33*/ DEF_VALS1(MQAT_RRS_BATCH),
/*   34*/ DEF_VALS1(MQAT_SIB),
/*   35*/ DEF_VALS1(MQAT_SYSTEM_EXTENSION),
/*   36*/ DEF_VALS1(MQAT_MCAST_PUBLISH),
/*   37*/ DEF_VALS1(MQAT_AMQP),
/*   -1*/ DEF_VALS1(MQAT_UNKNOWN),
DEF_VALSE;
DEF_VALS_EXTBX(MQAT);

DEF_VALSB(MQCMD)
/*    0*/ DEF_VALS1(MQCMD_NONE),
/*    1*/ DEF_VALS1(MQCMD_CHANGE_Q_MGR),
/*    2*/ DEF_VALS1(MQCMD_INQUIRE_Q_MGR),
/*    3*/ DEF_VALS1(MQCMD_CHANGE_PROCESS),
/*    4*/ DEF_VALS1(MQCMD_COPY_PROCESS),
/*    5*/ DEF_VALS1(MQCMD_CREATE_PROCESS),
/*    6*/ DEF_VALS1(MQCMD_DELETE_PROCESS),
/*    7*/ DEF_VALS1(MQCMD_INQUIRE_PROCESS),
/*    8*/ DEF_VALS1(MQCMD_CHANGE_Q),
/*    9*/ DEF_VALS1(MQCMD_CLEAR_Q),
/*   10*/ DEF_VALS1(MQCMD_COPY_Q),
/*   11*/ DEF_VALS1(MQCMD_CREATE_Q),
/*   12*/ DEF_VALS1(MQCMD_DELETE_Q),
/*   13*/ DEF_VALS1(MQCMD_INQUIRE_Q),
/*   16*/ DEF_VALS1(MQCMD_REFRESH_Q_MGR),
/*   17*/ DEF_VALS1(MQCMD_RESET_Q_STATS),
/*   18*/ DEF_VALS1(MQCMD_INQUIRE_Q_NAMES),
/*   19*/ DEF_VALS1(MQCMD_INQUIRE_PROCESS_NAMES),
/*   20*/ DEF_VALS1(MQCMD_INQUIRE_CHANNEL_NAMES),
/*   21*/ DEF_VALS1(MQCMD_CHANGE_CHANNEL),
/*   22*/ DEF_VALS1(MQCMD_COPY_CHANNEL),
/*   23*/ DEF_VALS1(MQCMD_CREATE_CHANNEL),
/*   24*/ DEF_VALS1(MQCMD_DELETE_CHANNEL),
/*   25*/ DEF_VALS1(MQCMD_INQUIRE_CHANNEL),
/*   26*/ DEF_VALS1(MQCMD_PING_CHANNEL),
/*   27*/ DEF_VALS1(MQCMD_RESET_CHANNEL),
/*   28*/ DEF_VALS1(MQCMD_START_CHANNEL),
/*   29*/ DEF_VALS1(MQCMD_STOP_CHANNEL),
/*   30*/ DEF_VALS1(MQCMD_START_CHANNEL_INIT),
/*   31*/ DEF_VALS1(MQCMD_START_CHANNEL_LISTENER),
/*   32*/ DEF_VALS1(MQCMD_CHANGE_NAMELIST),
/*   33*/ DEF_VALS1(MQCMD_COPY_NAMELIST),
/*   34*/ DEF_VALS1(MQCMD_CREATE_NAMELIST),
/*   35*/ DEF_VALS1(MQCMD_DELETE_NAMELIST),
/*   36*/ DEF_VALS1(MQCMD_INQUIRE_NAMELIST),
/*   37*/ DEF_VALS1(MQCMD_INQUIRE_NAMELIST_NAMES),
/*   38*/ DEF_VALS1(MQCMD_ESCAPE),
/*   39*/ DEF_VALS1(MQCMD_RESOLVE_CHANNEL),
/*   40*/ DEF_VALS1(MQCMD_PING_Q_MGR),
/*   41*/ DEF_VALS1(MQCMD_INQUIRE_Q_STATUS),
/*   42*/ DEF_VALS1(MQCMD_INQUIRE_CHANNEL_STATUS),
/*   43*/ DEF_VALS1(MQCMD_CONFIG_EVENT),
/*   44*/ DEF_VALS1(MQCMD_Q_MGR_EVENT),
/*   45*/ DEF_VALS1(MQCMD_PERFM_EVENT),
/*   46*/ DEF_VALS1(MQCMD_CHANNEL_EVENT),
/*   60*/ DEF_VALS1(MQCMD_DELETE_PUBLICATION),
/*   61*/ DEF_VALS1(MQCMD_DEREGISTER_PUBLISHER),
/*   62*/ DEF_VALS1(MQCMD_DEREGISTER_SUBSCRIBER),
/*   63*/ DEF_VALS1(MQCMD_PUBLISH),
/*   64*/ DEF_VALS1(MQCMD_REGISTER_PUBLISHER),
/*   65*/ DEF_VALS1(MQCMD_REGISTER_SUBSCRIBER),
/*   66*/ DEF_VALS1(MQCMD_REQUEST_UPDATE),
/*   67*/ DEF_VALS1(MQCMD_BROKER_INTERNAL),
/*   69*/ DEF_VALS1(MQCMD_ACTIVITY_MSG),
/*   70*/ DEF_VALS1(MQCMD_INQUIRE_CLUSTER_Q_MGR),
/*   71*/ DEF_VALS1(MQCMD_RESUME_Q_MGR_CLUSTER),
/*   72*/ DEF_VALS1(MQCMD_SUSPEND_Q_MGR_CLUSTER),
/*   73*/ DEF_VALS1(MQCMD_REFRESH_CLUSTER),
/*   74*/ DEF_VALS1(MQCMD_RESET_CLUSTER),
/*   75*/ DEF_VALS1(MQCMD_TRACE_ROUTE),
/*   78*/ DEF_VALS1(MQCMD_REFRESH_SECURITY),
/*   79*/ DEF_VALS1(MQCMD_CHANGE_AUTH_INFO),
/*   80*/ DEF_VALS1(MQCMD_COPY_AUTH_INFO),
/*   81*/ DEF_VALS1(MQCMD_CREATE_AUTH_INFO),
/*   82*/ DEF_VALS1(MQCMD_DELETE_AUTH_INFO),
/*   83*/ DEF_VALS1(MQCMD_INQUIRE_AUTH_INFO),
/*   84*/ DEF_VALS1(MQCMD_INQUIRE_AUTH_INFO_NAMES),
/*   85*/ DEF_VALS1(MQCMD_INQUIRE_CONNECTION),
/*   86*/ DEF_VALS1(MQCMD_STOP_CONNECTION),
/*   87*/ DEF_VALS1(MQCMD_INQUIRE_AUTH_RECS),
/*   88*/ DEF_VALS1(MQCMD_INQUIRE_ENTITY_AUTH),
/*   89*/ DEF_VALS1(MQCMD_DELETE_AUTH_REC),
/*   90*/ DEF_VALS1(MQCMD_SET_AUTH_REC),
/*   91*/ DEF_VALS1(MQCMD_LOGGER_EVENT),
/*   92*/ DEF_VALS1(MQCMD_RESET_Q_MGR),
/*   93*/ DEF_VALS1(MQCMD_CHANGE_LISTENER),
/*   94*/ DEF_VALS1(MQCMD_COPY_LISTENER),
/*   95*/ DEF_VALS1(MQCMD_CREATE_LISTENER),
/*   96*/ DEF_VALS1(MQCMD_DELETE_LISTENER),
/*   97*/ DEF_VALS1(MQCMD_INQUIRE_LISTENER),
/*   98*/ DEF_VALS1(MQCMD_INQUIRE_LISTENER_STATUS),
/*   99*/ DEF_VALS1(MQCMD_COMMAND_EVENT),
/*  100*/ DEF_VALS1(MQCMD_CHANGE_SECURITY),
/*  101*/ DEF_VALS1(MQCMD_CHANGE_CF_STRUC),
/*  102*/ DEF_VALS1(MQCMD_CHANGE_STG_CLASS),
/*  103*/ DEF_VALS1(MQCMD_CHANGE_TRACE),
/*  104*/ DEF_VALS1(MQCMD_ARCHIVE_LOG),
/*  105*/ DEF_VALS1(MQCMD_BACKUP_CF_STRUC),
/*  106*/ DEF_VALS1(MQCMD_CREATE_BUFFER_POOL),
/*  107*/ DEF_VALS1(MQCMD_CREATE_PAGE_SET),
/*  108*/ DEF_VALS1(MQCMD_CREATE_CF_STRUC),
/*  109*/ DEF_VALS1(MQCMD_CREATE_STG_CLASS),
/*  110*/ DEF_VALS1(MQCMD_COPY_CF_STRUC),
/*  111*/ DEF_VALS1(MQCMD_COPY_STG_CLASS),
/*  112*/ DEF_VALS1(MQCMD_DELETE_CF_STRUC),
/*  113*/ DEF_VALS1(MQCMD_DELETE_STG_CLASS),
/*  114*/ DEF_VALS1(MQCMD_INQUIRE_ARCHIVE),
/*  115*/ DEF_VALS1(MQCMD_INQUIRE_CF_STRUC),
/*  116*/ DEF_VALS1(MQCMD_INQUIRE_CF_STRUC_STATUS),
/*  117*/ DEF_VALS1(MQCMD_INQUIRE_CMD_SERVER),
/*  118*/ DEF_VALS1(MQCMD_INQUIRE_CHANNEL_INIT),
/*  119*/ DEF_VALS1(MQCMD_INQUIRE_QSG),
/*  120*/ DEF_VALS1(MQCMD_INQUIRE_LOG),
/*  121*/ DEF_VALS1(MQCMD_INQUIRE_SECURITY),
/*  122*/ DEF_VALS1(MQCMD_INQUIRE_STG_CLASS),
/*  123*/ DEF_VALS1(MQCMD_INQUIRE_SYSTEM),
/*  124*/ DEF_VALS1(MQCMD_INQUIRE_THREAD),
/*  125*/ DEF_VALS1(MQCMD_INQUIRE_TRACE),
/*  126*/ DEF_VALS1(MQCMD_INQUIRE_USAGE),
/*  127*/ DEF_VALS1(MQCMD_MOVE_Q),
/*  128*/ DEF_VALS1(MQCMD_RECOVER_BSDS),
/*  129*/ DEF_VALS1(MQCMD_RECOVER_CF_STRUC),
/*  130*/ DEF_VALS1(MQCMD_RESET_TPIPE),
/*  131*/ DEF_VALS1(MQCMD_RESOLVE_INDOUBT),
/*  132*/ DEF_VALS1(MQCMD_RESUME_Q_MGR),
/*  133*/ DEF_VALS1(MQCMD_REVERIFY_SECURITY),
/*  134*/ DEF_VALS1(MQCMD_SET_ARCHIVE),
/*  136*/ DEF_VALS1(MQCMD_SET_LOG),
/*  137*/ DEF_VALS1(MQCMD_SET_SYSTEM),
/*  138*/ DEF_VALS1(MQCMD_START_CMD_SERVER),
/*  139*/ DEF_VALS1(MQCMD_START_Q_MGR),
/*  140*/ DEF_VALS1(MQCMD_START_TRACE),
/*  141*/ DEF_VALS1(MQCMD_STOP_CHANNEL_INIT),
/*  142*/ DEF_VALS1(MQCMD_STOP_CHANNEL_LISTENER),
/*  143*/ DEF_VALS1(MQCMD_STOP_CMD_SERVER),
/*  144*/ DEF_VALS1(MQCMD_STOP_Q_MGR),
/*  145*/ DEF_VALS1(MQCMD_STOP_TRACE),
/*  146*/ DEF_VALS1(MQCMD_SUSPEND_Q_MGR),
/*  147*/ DEF_VALS1(MQCMD_INQUIRE_CF_STRUC_NAMES),
/*  148*/ DEF_VALS1(MQCMD_INQUIRE_STG_CLASS_NAMES),
/*  149*/ DEF_VALS1(MQCMD_CHANGE_SERVICE),
/*  150*/ DEF_VALS1(MQCMD_COPY_SERVICE),
/*  151*/ DEF_VALS1(MQCMD_CREATE_SERVICE),
/*  152*/ DEF_VALS1(MQCMD_DELETE_SERVICE),
/*  153*/ DEF_VALS1(MQCMD_INQUIRE_SERVICE),
/*  154*/ DEF_VALS1(MQCMD_INQUIRE_SERVICE_STATUS),
/*  155*/ DEF_VALS1(MQCMD_START_SERVICE),
/*  156*/ DEF_VALS1(MQCMD_STOP_SERVICE),
/*  157*/ DEF_VALS1(MQCMD_DELETE_BUFFER_POOL),
/*  158*/ DEF_VALS1(MQCMD_DELETE_PAGE_SET),
/*  159*/ DEF_VALS1(MQCMD_CHANGE_BUFFER_POOL),
/*  160*/ DEF_VALS1(MQCMD_CHANGE_PAGE_SET),
/*  161*/ DEF_VALS1(MQCMD_INQUIRE_Q_MGR_STATUS),
/*  162*/ DEF_VALS1(MQCMD_CREATE_LOG),
/*  164*/ DEF_VALS1(MQCMD_STATISTICS_MQI),
/*  165*/ DEF_VALS1(MQCMD_STATISTICS_Q),
/*  166*/ DEF_VALS1(MQCMD_STATISTICS_CHANNEL),
/*  167*/ DEF_VALS1(MQCMD_ACCOUNTING_MQI),
/*  168*/ DEF_VALS1(MQCMD_ACCOUNTING_Q),
/*  169*/ DEF_VALS1(MQCMD_INQUIRE_AUTH_SERVICE),
/*  170*/ DEF_VALS1(MQCMD_CHANGE_TOPIC),
/*  171*/ DEF_VALS1(MQCMD_COPY_TOPIC),
/*  172*/ DEF_VALS1(MQCMD_CREATE_TOPIC),
/*  173*/ DEF_VALS1(MQCMD_DELETE_TOPIC),
/*  174*/ DEF_VALS1(MQCMD_INQUIRE_TOPIC),
/*  175*/ DEF_VALS1(MQCMD_INQUIRE_TOPIC_NAMES),
/*  176*/ DEF_VALS1(MQCMD_INQUIRE_SUBSCRIPTION),
/*  177*/ DEF_VALS1(MQCMD_CREATE_SUBSCRIPTION),
/*  178*/ DEF_VALS1(MQCMD_CHANGE_SUBSCRIPTION),
/*  179*/ DEF_VALS1(MQCMD_DELETE_SUBSCRIPTION),
/*  181*/ DEF_VALS1(MQCMD_COPY_SUBSCRIPTION),
/*  182*/ DEF_VALS1(MQCMD_INQUIRE_SUB_STATUS),
/*  183*/ DEF_VALS1(MQCMD_INQUIRE_TOPIC_STATUS),
/*  184*/ DEF_VALS1(MQCMD_CLEAR_TOPIC_STRING),
/*  185*/ DEF_VALS1(MQCMD_INQUIRE_PUBSUB_STATUS),
/*  186*/ DEF_VALS1(MQCMD_INQUIRE_SMDS),
/*  187*/ DEF_VALS1(MQCMD_CHANGE_SMDS),
/*  188*/ DEF_VALS1(MQCMD_RESET_SMDS),
/*  190*/ DEF_VALS1(MQCMD_CREATE_COMM_INFO),
/*  191*/ DEF_VALS1(MQCMD_INQUIRE_COMM_INFO),
/*  192*/ DEF_VALS1(MQCMD_CHANGE_COMM_INFO),
/*  193*/ DEF_VALS1(MQCMD_COPY_COMM_INFO),
/*  194*/ DEF_VALS1(MQCMD_DELETE_COMM_INFO),
/*  195*/ DEF_VALS1(MQCMD_PURGE_CHANNEL),
/*  196*/ DEF_VALS1(MQCMD_MQXR_DIAGNOSTICS),
/*  197*/ DEF_VALS1(MQCMD_START_SMDSCONN),
/*  198*/ DEF_VALS1(MQCMD_STOP_SMDSCONN),
/*  199*/ DEF_VALS1(MQCMD_INQUIRE_SMDSCONN),
/*  200*/ DEF_VALS1(MQCMD_INQUIRE_MQXR_STATUS),
/*  201*/ DEF_VALS1(MQCMD_START_CLIENT_TRACE),
/*  202*/ DEF_VALS1(MQCMD_STOP_CLIENT_TRACE),
/*  203*/ DEF_VALS1(MQCMD_SET_CHLAUTH_REC),
/*  204*/ DEF_VALS1(MQCMD_INQUIRE_CHLAUTH_RECS),
/*  205*/ DEF_VALS1(MQCMD_INQUIRE_PROT_POLICY),
/*  206*/ DEF_VALS1(MQCMD_CREATE_PROT_POLICY),
/*  207*/ DEF_VALS1(MQCMD_DELETE_PROT_POLICY),
/*  208*/ DEF_VALS1(MQCMD_CHANGE_PROT_POLICY),
/*  209*/ DEF_VALS1(MQCMD_ACTIVITY_TRACE),
/*  213*/ DEF_VALS1(MQCMD_RESET_CF_STRUC),
/*  214*/ DEF_VALS1(MQCMD_INQUIRE_XR_CAPABILITY),
/*  216*/ DEF_VALS1(MQCMD_INQUIRE_AMQP_CAPABILITY),
/*  217*/ DEF_VALS1(MQCMD_AMQP_DIAGNOSTICS),

DEF_VALSE;
DEF_VALS_EXTBX(MQCMD);

DEF_VALSB(MQRC)
/*    0*/ DEF_VALS1(MQRC_NONE),
/*  900*/ DEF_VALS1(MQRC_APPL_FIRST),
/*  999*/ DEF_VALS1(MQRC_APPL_LAST),
/* 2001*/ DEF_VALS1(MQRC_ALIAS_BASE_Q_TYPE_ERROR),
/* 2002*/ DEF_VALS1(MQRC_ALREADY_CONNECTED),
/* 2003*/ DEF_VALS1(MQRC_BACKED_OUT),
/* 2004*/ DEF_VALS1(MQRC_BUFFER_ERROR),
/* 2005*/ DEF_VALS1(MQRC_BUFFER_LENGTH_ERROR),
/* 2006*/ DEF_VALS1(MQRC_CHAR_ATTR_LENGTH_ERROR),
/* 2007*/ DEF_VALS1(MQRC_CHAR_ATTRS_ERROR),
/* 2008*/ DEF_VALS1(MQRC_CHAR_ATTRS_TOO_SHORT),
/* 2009*/ DEF_VALS1(MQRC_CONNECTION_BROKEN),
/* 2010*/ DEF_VALS1(MQRC_DATA_LENGTH_ERROR),
/* 2011*/ DEF_VALS1(MQRC_DYNAMIC_Q_NAME_ERROR),
/* 2012*/ DEF_VALS1(MQRC_ENVIRONMENT_ERROR),
/* 2013*/ DEF_VALS1(MQRC_EXPIRY_ERROR),
/* 2014*/ DEF_VALS1(MQRC_FEEDBACK_ERROR),
/* 2016*/ DEF_VALS1(MQRC_GET_INHIBITED),
/* 2017*/ DEF_VALS1(MQRC_HANDLE_NOT_AVAILABLE),
/* 2018*/ DEF_VALS1(MQRC_HCONN_ERROR),
/* 2019*/ DEF_VALS1(MQRC_HOBJ_ERROR),
/* 2020*/ DEF_VALS1(MQRC_INHIBIT_VALUE_ERROR),
/* 2021*/ DEF_VALS1(MQRC_INT_ATTR_COUNT_ERROR),
/* 2022*/ DEF_VALS1(MQRC_INT_ATTR_COUNT_TOO_SMALL),
/* 2023*/ DEF_VALS1(MQRC_INT_ATTRS_ARRAY_ERROR),
/* 2024*/ DEF_VALS1(MQRC_SYNCPOINT_LIMIT_REACHED),
/* 2025*/ DEF_VALS1(MQRC_MAX_CONNS_LIMIT_REACHED),
/* 2026*/ DEF_VALS1(MQRC_MD_ERROR),
/* 2027*/ DEF_VALS1(MQRC_MISSING_REPLY_TO_Q),
/* 2029*/ DEF_VALS1(MQRC_MSG_TYPE_ERROR),
/* 2030*/ DEF_VALS1(MQRC_MSG_TOO_BIG_FOR_Q),
/* 2031*/ DEF_VALS1(MQRC_MSG_TOO_BIG_FOR_Q_MGR),
/* 2033*/ DEF_VALS1(MQRC_NO_MSG_AVAILABLE),
/* 2034*/ DEF_VALS1(MQRC_NO_MSG_UNDER_CURSOR),
/* 2035*/ DEF_VALS1(MQRC_NOT_AUTHORIZED),
/* 2036*/ DEF_VALS1(MQRC_NOT_OPEN_FOR_BROWSE),
/* 2037*/ DEF_VALS1(MQRC_NOT_OPEN_FOR_INPUT),
/* 2038*/ DEF_VALS1(MQRC_NOT_OPEN_FOR_INQUIRE),
/* 2039*/ DEF_VALS1(MQRC_NOT_OPEN_FOR_OUTPUT),
/* 2040*/ DEF_VALS1(MQRC_NOT_OPEN_FOR_SET),
/* 2041*/ DEF_VALS1(MQRC_OBJECT_CHANGED),
/* 2042*/ DEF_VALS1(MQRC_OBJECT_IN_USE),
/* 2043*/ DEF_VALS1(MQRC_OBJECT_TYPE_ERROR),
/* 2044*/ DEF_VALS1(MQRC_OD_ERROR),
/* 2045*/ DEF_VALS1(MQRC_OPTION_NOT_VALID_FOR_TYPE),
/* 2046*/ DEF_VALS1(MQRC_OPTIONS_ERROR),
/* 2047*/ DEF_VALS1(MQRC_PERSISTENCE_ERROR),
/* 2048*/ DEF_VALS1(MQRC_PERSISTENT_NOT_ALLOWED),
/* 2049*/ DEF_VALS1(MQRC_PRIORITY_EXCEEDS_MAXIMUM),
/* 2050*/ DEF_VALS1(MQRC_PRIORITY_ERROR),
/* 2051*/ DEF_VALS1(MQRC_PUT_INHIBITED),
/* 2052*/ DEF_VALS1(MQRC_Q_DELETED),
/* 2053*/ DEF_VALS1(MQRC_Q_FULL),
/* 2055*/ DEF_VALS1(MQRC_Q_NOT_EMPTY),
/* 2056*/ DEF_VALS1(MQRC_Q_SPACE_NOT_AVAILABLE),
/* 2057*/ DEF_VALS1(MQRC_Q_TYPE_ERROR),
/* 2058*/ DEF_VALS1(MQRC_Q_MGR_NAME_ERROR),
/* 2059*/ DEF_VALS1(MQRC_Q_MGR_NOT_AVAILABLE),
/* 2061*/ DEF_VALS1(MQRC_REPORT_OPTIONS_ERROR),
/* 2062*/ DEF_VALS1(MQRC_SECOND_MARK_NOT_ALLOWED),
/* 2063*/ DEF_VALS1(MQRC_SECURITY_ERROR),
/* 2065*/ DEF_VALS1(MQRC_SELECTOR_COUNT_ERROR),
/* 2066*/ DEF_VALS1(MQRC_SELECTOR_LIMIT_EXCEEDED),
/* 2067*/ DEF_VALS1(MQRC_SELECTOR_ERROR),
/* 2068*/ DEF_VALS1(MQRC_SELECTOR_NOT_FOR_TYPE),
/* 2069*/ DEF_VALS1(MQRC_SIGNAL_OUTSTANDING),
/* 2070*/ DEF_VALS1(MQRC_SIGNAL_REQUEST_ACCEPTED),
/* 2071*/ DEF_VALS1(MQRC_STORAGE_NOT_AVAILABLE),
/* 2072*/ DEF_VALS1(MQRC_SYNCPOINT_NOT_AVAILABLE),
/* 2075*/ DEF_VALS1(MQRC_TRIGGER_CONTROL_ERROR),
/* 2076*/ DEF_VALS1(MQRC_TRIGGER_DEPTH_ERROR),
/* 2077*/ DEF_VALS1(MQRC_TRIGGER_MSG_PRIORITY_ERR),
/* 2078*/ DEF_VALS1(MQRC_TRIGGER_TYPE_ERROR),
/* 2079*/ DEF_VALS1(MQRC_TRUNCATED_MSG_ACCEPTED),
/* 2080*/ DEF_VALS1(MQRC_TRUNCATED_MSG_FAILED),
/* 2082*/ DEF_VALS1(MQRC_UNKNOWN_ALIAS_BASE_Q),
/* 2085*/ DEF_VALS1(MQRC_UNKNOWN_OBJECT_NAME),
/* 2086*/ DEF_VALS1(MQRC_UNKNOWN_OBJECT_Q_MGR),
/* 2087*/ DEF_VALS1(MQRC_UNKNOWN_REMOTE_Q_MGR),
/* 2090*/ DEF_VALS1(MQRC_WAIT_INTERVAL_ERROR),
/* 2091*/ DEF_VALS1(MQRC_XMIT_Q_TYPE_ERROR),
/* 2092*/ DEF_VALS1(MQRC_XMIT_Q_USAGE_ERROR),
/* 2093*/ DEF_VALS1(MQRC_NOT_OPEN_FOR_PASS_ALL),
/* 2094*/ DEF_VALS1(MQRC_NOT_OPEN_FOR_PASS_IDENT),
/* 2095*/ DEF_VALS1(MQRC_NOT_OPEN_FOR_SET_ALL),
/* 2096*/ DEF_VALS1(MQRC_NOT_OPEN_FOR_SET_IDENT),
/* 2097*/ DEF_VALS1(MQRC_CONTEXT_HANDLE_ERROR),
/* 2098*/ DEF_VALS1(MQRC_CONTEXT_NOT_AVAILABLE),
/* 2099*/ DEF_VALS1(MQRC_SIGNAL1_ERROR),
/* 2100*/ DEF_VALS1(MQRC_OBJECT_ALREADY_EXISTS),
/* 2101*/ DEF_VALS1(MQRC_OBJECT_DAMAGED),
/* 2102*/ DEF_VALS1(MQRC_RESOURCE_PROBLEM),
/* 2103*/ DEF_VALS1(MQRC_ANOTHER_Q_MGR_CONNECTED),
/* 2104*/ DEF_VALS1(MQRC_UNKNOWN_REPORT_OPTION),
/* 2105*/ DEF_VALS1(MQRC_STORAGE_CLASS_ERROR),
/* 2106*/ DEF_VALS1(MQRC_COD_NOT_VALID_FOR_XCF_Q),
/* 2107*/ DEF_VALS1(MQRC_XWAIT_CANCELED),
/* 2108*/ DEF_VALS1(MQRC_XWAIT_ERROR),
/* 2109*/ DEF_VALS1(MQRC_SUPPRESSED_BY_EXIT),
/* 2110*/ DEF_VALS1(MQRC_FORMAT_ERROR),
/* 2111*/ DEF_VALS1(MQRC_SOURCE_CCSID_ERROR),
/* 2112*/ DEF_VALS1(MQRC_SOURCE_INTEGER_ENC_ERROR),
/* 2113*/ DEF_VALS1(MQRC_SOURCE_DECIMAL_ENC_ERROR),
/* 2114*/ DEF_VALS1(MQRC_SOURCE_FLOAT_ENC_ERROR),
/* 2115*/ DEF_VALS1(MQRC_TARGET_CCSID_ERROR),
/* 2116*/ DEF_VALS1(MQRC_TARGET_INTEGER_ENC_ERROR),
/* 2117*/ DEF_VALS1(MQRC_TARGET_DECIMAL_ENC_ERROR),
/* 2118*/ DEF_VALS1(MQRC_TARGET_FLOAT_ENC_ERROR),
/* 2119*/ DEF_VALS1(MQRC_NOT_CONVERTED),
/* 2120*/ DEF_VALS1(MQRC_CONVERTED_MSG_TOO_BIG),
/* 2120   DEF_VALS1(MQRC_TRUNCATED), */
/* 2121*/ DEF_VALS1(MQRC_NO_EXTERNAL_PARTICIPANTS),
/* 2122*/ DEF_VALS1(MQRC_PARTICIPANT_NOT_AVAILABLE),
/* 2123*/ DEF_VALS1(MQRC_OUTCOME_MIXED),
/* 2124*/ DEF_VALS1(MQRC_OUTCOME_PENDING),
/* 2125*/ DEF_VALS1(MQRC_BRIDGE_STARTED),
/* 2126*/ DEF_VALS1(MQRC_BRIDGE_STOPPED),
/* 2127*/ DEF_VALS1(MQRC_ADAPTER_STORAGE_SHORTAGE),
/* 2128*/ DEF_VALS1(MQRC_UOW_IN_PROGRESS),
/* 2129*/ DEF_VALS1(MQRC_ADAPTER_CONN_LOAD_ERROR),
/* 2130*/ DEF_VALS1(MQRC_ADAPTER_SERV_LOAD_ERROR),
/* 2131*/ DEF_VALS1(MQRC_ADAPTER_DEFS_ERROR),
/* 2132*/ DEF_VALS1(MQRC_ADAPTER_DEFS_LOAD_ERROR),
/* 2133*/ DEF_VALS1(MQRC_ADAPTER_CONV_LOAD_ERROR),
/* 2134*/ DEF_VALS1(MQRC_BO_ERROR),
/* 2135*/ DEF_VALS1(MQRC_DH_ERROR),
/* 2136*/ DEF_VALS1(MQRC_MULTIPLE_REASONS),
/* 2137*/ DEF_VALS1(MQRC_OPEN_FAILED),
/* 2138*/ DEF_VALS1(MQRC_ADAPTER_DISC_LOAD_ERROR),
/* 2139*/ DEF_VALS1(MQRC_CNO_ERROR),
/* 2140*/ DEF_VALS1(MQRC_CICS_WAIT_FAILED),
/* 2141*/ DEF_VALS1(MQRC_DLH_ERROR),
/* 2142*/ DEF_VALS1(MQRC_HEADER_ERROR),
/* 2143*/ DEF_VALS1(MQRC_SOURCE_LENGTH_ERROR),
/* 2144*/ DEF_VALS1(MQRC_TARGET_LENGTH_ERROR),
/* 2145*/ DEF_VALS1(MQRC_SOURCE_BUFFER_ERROR),
/* 2146*/ DEF_VALS1(MQRC_TARGET_BUFFER_ERROR),
/* 2148*/ DEF_VALS1(MQRC_IIH_ERROR),
/* 2149*/ DEF_VALS1(MQRC_PCF_ERROR),
/* 2150*/ DEF_VALS1(MQRC_DBCS_ERROR),
/* 2152*/ DEF_VALS1(MQRC_OBJECT_NAME_ERROR),
/* 2153*/ DEF_VALS1(MQRC_OBJECT_Q_MGR_NAME_ERROR),
/* 2154*/ DEF_VALS1(MQRC_RECS_PRESENT_ERROR),
/* 2155*/ DEF_VALS1(MQRC_OBJECT_RECORDS_ERROR),
/* 2156*/ DEF_VALS1(MQRC_RESPONSE_RECORDS_ERROR),
/* 2157*/ DEF_VALS1(MQRC_ASID_MISMATCH),
/* 2158*/ DEF_VALS1(MQRC_PMO_RECORD_FLAGS_ERROR),
/* 2159*/ DEF_VALS1(MQRC_PUT_MSG_RECORDS_ERROR),
/* 2160*/ DEF_VALS1(MQRC_CONN_ID_IN_USE),
/* 2161*/ DEF_VALS1(MQRC_Q_MGR_QUIESCING),
/* 2162*/ DEF_VALS1(MQRC_Q_MGR_STOPPING),
/* 2163*/ DEF_VALS1(MQRC_DUPLICATE_RECOV_COORD),
/* 2173*/ DEF_VALS1(MQRC_PMO_ERROR),
/* 2182*/ DEF_VALS1(MQRC_API_EXIT_NOT_FOUND),
/* 2183*/ DEF_VALS1(MQRC_API_EXIT_LOAD_ERROR),
/* 2184*/ DEF_VALS1(MQRC_REMOTE_Q_NAME_ERROR),
/* 2185*/ DEF_VALS1(MQRC_INCONSISTENT_PERSISTENCE),
/* 2186*/ DEF_VALS1(MQRC_GMO_ERROR),
/* 2187*/ DEF_VALS1(MQRC_CICS_BRIDGE_RESTRICTION),
/* 2188*/ DEF_VALS1(MQRC_STOPPED_BY_CLUSTER_EXIT),
/* 2189*/ DEF_VALS1(MQRC_CLUSTER_RESOLUTION_ERROR),
/* 2190*/ DEF_VALS1(MQRC_CONVERTED_STRING_TOO_BIG),
/* 2191*/ DEF_VALS1(MQRC_TMC_ERROR),
/* 2192*/ DEF_VALS1(MQRC_STORAGE_MEDIUM_FULL),
/* 2192   DEF_VALS1(MQRC_PAGESET_FULL), */
/* 2193*/ DEF_VALS1(MQRC_PAGESET_ERROR),
/* 2194*/ DEF_VALS1(MQRC_NAME_NOT_VALID_FOR_TYPE),
/* 2195*/ DEF_VALS1(MQRC_UNEXPECTED_ERROR),
/* 2196*/ DEF_VALS1(MQRC_UNKNOWN_XMIT_Q),
/* 2197*/ DEF_VALS1(MQRC_UNKNOWN_DEF_XMIT_Q),
/* 2198*/ DEF_VALS1(MQRC_DEF_XMIT_Q_TYPE_ERROR),
/* 2199*/ DEF_VALS1(MQRC_DEF_XMIT_Q_USAGE_ERROR),
/* 2200*/ DEF_VALS1(MQRC_MSG_MARKED_BROWSE_CO_OP),
/* 2201*/ DEF_VALS1(MQRC_NAME_IN_USE),
/* 2202*/ DEF_VALS1(MQRC_CONNECTION_QUIESCING),
/* 2203*/ DEF_VALS1(MQRC_CONNECTION_STOPPING),
/* 2204*/ DEF_VALS1(MQRC_ADAPTER_NOT_AVAILABLE),
/* 2206*/ DEF_VALS1(MQRC_MSG_ID_ERROR),
/* 2207*/ DEF_VALS1(MQRC_CORREL_ID_ERROR),
/* 2208*/ DEF_VALS1(MQRC_FILE_SYSTEM_ERROR),
/* 2209*/ DEF_VALS1(MQRC_NO_MSG_LOCKED),
/* 2210*/ DEF_VALS1(MQRC_SOAP_DOTNET_ERROR),
/* 2211*/ DEF_VALS1(MQRC_SOAP_AXIS_ERROR),
/* 2212*/ DEF_VALS1(MQRC_SOAP_URL_ERROR),
/* 2216*/ DEF_VALS1(MQRC_FILE_NOT_AUDITED),
/* 2217*/ DEF_VALS1(MQRC_CONNECTION_NOT_AUTHORIZED),
/* 2218*/ DEF_VALS1(MQRC_MSG_TOO_BIG_FOR_CHANNEL),
/* 2219*/ DEF_VALS1(MQRC_CALL_IN_PROGRESS),
/* 2220*/ DEF_VALS1(MQRC_RMH_ERROR),
/* 2222*/ DEF_VALS1(MQRC_Q_MGR_ACTIVE),
/* 2223*/ DEF_VALS1(MQRC_Q_MGR_NOT_ACTIVE),
/* 2224*/ DEF_VALS1(MQRC_Q_DEPTH_HIGH),
/* 2225*/ DEF_VALS1(MQRC_Q_DEPTH_LOW),
/* 2226*/ DEF_VALS1(MQRC_Q_SERVICE_INTERVAL_HIGH),
/* 2227*/ DEF_VALS1(MQRC_Q_SERVICE_INTERVAL_OK),
/* 2228*/ DEF_VALS1(MQRC_RFH_HEADER_FIELD_ERROR),
/* 2229*/ DEF_VALS1(MQRC_RAS_PROPERTY_ERROR),
/* 2232*/ DEF_VALS1(MQRC_UNIT_OF_WORK_NOT_STARTED),
/* 2233*/ DEF_VALS1(MQRC_CHANNEL_AUTO_DEF_OK),
/* 2234*/ DEF_VALS1(MQRC_CHANNEL_AUTO_DEF_ERROR),
/* 2235*/ DEF_VALS1(MQRC_CFH_ERROR),
/* 2236*/ DEF_VALS1(MQRC_CFIL_ERROR),
/* 2237*/ DEF_VALS1(MQRC_CFIN_ERROR),
/* 2238*/ DEF_VALS1(MQRC_CFSL_ERROR),
/* 2239*/ DEF_VALS1(MQRC_CFST_ERROR),
/* 2241*/ DEF_VALS1(MQRC_INCOMPLETE_GROUP),
/* 2242*/ DEF_VALS1(MQRC_INCOMPLETE_MSG),
/* 2243*/ DEF_VALS1(MQRC_INCONSISTENT_CCSIDS),
/* 2244*/ DEF_VALS1(MQRC_INCONSISTENT_ENCODINGS),
/* 2245*/ DEF_VALS1(MQRC_INCONSISTENT_UOW),
/* 2246*/ DEF_VALS1(MQRC_INVALID_MSG_UNDER_CURSOR),
/* 2247*/ DEF_VALS1(MQRC_MATCH_OPTIONS_ERROR),
/* 2248*/ DEF_VALS1(MQRC_MDE_ERROR),
/* 2249*/ DEF_VALS1(MQRC_MSG_FLAGS_ERROR),
/* 2250*/ DEF_VALS1(MQRC_MSG_SEQ_NUMBER_ERROR),
/* 2251*/ DEF_VALS1(MQRC_OFFSET_ERROR),
/* 2252*/ DEF_VALS1(MQRC_ORIGINAL_LENGTH_ERROR),
/* 2253*/ DEF_VALS1(MQRC_SEGMENT_LENGTH_ZERO),
/* 2255*/ DEF_VALS1(MQRC_UOW_NOT_AVAILABLE),
/* 2256*/ DEF_VALS1(MQRC_WRONG_GMO_VERSION),
/* 2257*/ DEF_VALS1(MQRC_WRONG_MD_VERSION),
/* 2258*/ DEF_VALS1(MQRC_GROUP_ID_ERROR),
/* 2259*/ DEF_VALS1(MQRC_INCONSISTENT_BROWSE),
/* 2260*/ DEF_VALS1(MQRC_XQH_ERROR),
/* 2261*/ DEF_VALS1(MQRC_SRC_ENV_ERROR),
/* 2262*/ DEF_VALS1(MQRC_SRC_NAME_ERROR),
/* 2263*/ DEF_VALS1(MQRC_DEST_ENV_ERROR),
/* 2264*/ DEF_VALS1(MQRC_DEST_NAME_ERROR),
/* 2265*/ DEF_VALS1(MQRC_TM_ERROR),
/* 2266*/ DEF_VALS1(MQRC_CLUSTER_EXIT_ERROR),
/* 2267*/ DEF_VALS1(MQRC_CLUSTER_EXIT_LOAD_ERROR),
/* 2268*/ DEF_VALS1(MQRC_CLUSTER_PUT_INHIBITED),
/* 2269*/ DEF_VALS1(MQRC_CLUSTER_RESOURCE_ERROR),
/* 2270*/ DEF_VALS1(MQRC_NO_DESTINATIONS_AVAILABLE),
/* 2271*/ DEF_VALS1(MQRC_CONN_TAG_IN_USE),
/* 2272*/ DEF_VALS1(MQRC_PARTIALLY_CONVERTED),
/* 2273*/ DEF_VALS1(MQRC_CONNECTION_ERROR),
/* 2274*/ DEF_VALS1(MQRC_OPTION_ENVIRONMENT_ERROR),
/* 2277*/ DEF_VALS1(MQRC_CD_ERROR),
/* 2278*/ DEF_VALS1(MQRC_CLIENT_CONN_ERROR),
/* 2279*/ DEF_VALS1(MQRC_CHANNEL_STOPPED_BY_USER),
/* 2280*/ DEF_VALS1(MQRC_HCONFIG_ERROR),
/* 2281*/ DEF_VALS1(MQRC_FUNCTION_ERROR),
/* 2282*/ DEF_VALS1(MQRC_CHANNEL_STARTED),
/* 2283*/ DEF_VALS1(MQRC_CHANNEL_STOPPED),
/* 2284*/ DEF_VALS1(MQRC_CHANNEL_CONV_ERROR),
/* 2285*/ DEF_VALS1(MQRC_SERVICE_NOT_AVAILABLE),
/* 2286*/ DEF_VALS1(MQRC_INITIALIZATION_FAILED),
/* 2287*/ DEF_VALS1(MQRC_TERMINATION_FAILED),
/* 2288*/ DEF_VALS1(MQRC_UNKNOWN_Q_NAME),
/* 2289*/ DEF_VALS1(MQRC_SERVICE_ERROR),
/* 2290*/ DEF_VALS1(MQRC_Q_ALREADY_EXISTS),
/* 2291*/ DEF_VALS1(MQRC_USER_ID_NOT_AVAILABLE),
/* 2292*/ DEF_VALS1(MQRC_UNKNOWN_ENTITY),
/* 2293*/ DEF_VALS1(MQRC_UNKNOWN_AUTH_ENTITY),
/* 2294*/ DEF_VALS1(MQRC_UNKNOWN_REF_OBJECT),
/* 2295*/ DEF_VALS1(MQRC_CHANNEL_ACTIVATED),
/* 2296*/ DEF_VALS1(MQRC_CHANNEL_NOT_ACTIVATED),
/* 2297*/ DEF_VALS1(MQRC_UOW_CANCELED),
/* 2298*/ DEF_VALS1(MQRC_FUNCTION_NOT_SUPPORTED),
/* 2299*/ DEF_VALS1(MQRC_SELECTOR_TYPE_ERROR),
/* 2300*/ DEF_VALS1(MQRC_COMMAND_TYPE_ERROR),
/* 2301*/ DEF_VALS1(MQRC_MULTIPLE_INSTANCE_ERROR),
/* 2302*/ DEF_VALS1(MQRC_SYSTEM_ITEM_NOT_ALTERABLE),
/* 2303*/ DEF_VALS1(MQRC_BAG_CONVERSION_ERROR),
/* 2304*/ DEF_VALS1(MQRC_SELECTOR_OUT_OF_RANGE),
/* 2305*/ DEF_VALS1(MQRC_SELECTOR_NOT_UNIQUE),
/* 2306*/ DEF_VALS1(MQRC_INDEX_NOT_PRESENT),
/* 2307*/ DEF_VALS1(MQRC_STRING_ERROR),
/* 2308*/ DEF_VALS1(MQRC_ENCODING_NOT_SUPPORTED),
/* 2309*/ DEF_VALS1(MQRC_SELECTOR_NOT_PRESENT),
/* 2310*/ DEF_VALS1(MQRC_OUT_SELECTOR_ERROR),
/* 2311*/ DEF_VALS1(MQRC_STRING_TRUNCATED),
/* 2312*/ DEF_VALS1(MQRC_SELECTOR_WRONG_TYPE),
/* 2313*/ DEF_VALS1(MQRC_INCONSISTENT_ITEM_TYPE),
/* 2314*/ DEF_VALS1(MQRC_INDEX_ERROR),
/* 2315*/ DEF_VALS1(MQRC_SYSTEM_BAG_NOT_ALTERABLE),
/* 2316*/ DEF_VALS1(MQRC_ITEM_COUNT_ERROR),
/* 2317*/ DEF_VALS1(MQRC_FORMAT_NOT_SUPPORTED),
/* 2318*/ DEF_VALS1(MQRC_SELECTOR_NOT_SUPPORTED),
/* 2319*/ DEF_VALS1(MQRC_ITEM_VALUE_ERROR),
/* 2320*/ DEF_VALS1(MQRC_HBAG_ERROR),
/* 2321*/ DEF_VALS1(MQRC_PARAMETER_MISSING),
/* 2322*/ DEF_VALS1(MQRC_CMD_SERVER_NOT_AVAILABLE),
/* 2323*/ DEF_VALS1(MQRC_STRING_LENGTH_ERROR),
/* 2324*/ DEF_VALS1(MQRC_INQUIRY_COMMAND_ERROR),
/* 2325*/ DEF_VALS1(MQRC_NESTED_BAG_NOT_SUPPORTED),
/* 2326*/ DEF_VALS1(MQRC_BAG_WRONG_TYPE),
/* 2327*/ DEF_VALS1(MQRC_ITEM_TYPE_ERROR),
/* 2328*/ DEF_VALS1(MQRC_SYSTEM_BAG_NOT_DELETABLE),
/* 2329*/ DEF_VALS1(MQRC_SYSTEM_ITEM_NOT_DELETABLE),
/* 2330*/ DEF_VALS1(MQRC_CODED_CHAR_SET_ID_ERROR),
/* 2331*/ DEF_VALS1(MQRC_MSG_TOKEN_ERROR),
/* 2332*/ DEF_VALS1(MQRC_MISSING_WIH),
/* 2333*/ DEF_VALS1(MQRC_WIH_ERROR),
/* 2334*/ DEF_VALS1(MQRC_RFH_ERROR),
/* 2335*/ DEF_VALS1(MQRC_RFH_STRING_ERROR),
/* 2336*/ DEF_VALS1(MQRC_RFH_COMMAND_ERROR),
/* 2337*/ DEF_VALS1(MQRC_RFH_PARM_ERROR),
/* 2338*/ DEF_VALS1(MQRC_RFH_DUPLICATE_PARM),
/* 2339*/ DEF_VALS1(MQRC_RFH_PARM_MISSING),
/* 2340*/ DEF_VALS1(MQRC_CHAR_CONVERSION_ERROR),
/* 2341*/ DEF_VALS1(MQRC_UCS2_CONVERSION_ERROR),
/* 2342*/ DEF_VALS1(MQRC_DB2_NOT_AVAILABLE),
/* 2343*/ DEF_VALS1(MQRC_OBJECT_NOT_UNIQUE),
/* 2344*/ DEF_VALS1(MQRC_CONN_TAG_NOT_RELEASED),
/* 2345*/ DEF_VALS1(MQRC_CF_NOT_AVAILABLE),
/* 2346*/ DEF_VALS1(MQRC_CF_STRUC_IN_USE),
/* 2347*/ DEF_VALS1(MQRC_CF_STRUC_LIST_HDR_IN_USE),
/* 2348*/ DEF_VALS1(MQRC_CF_STRUC_AUTH_FAILED),
/* 2349*/ DEF_VALS1(MQRC_CF_STRUC_ERROR),
/* 2350*/ DEF_VALS1(MQRC_CONN_TAG_NOT_USABLE),
/* 2351*/ DEF_VALS1(MQRC_GLOBAL_UOW_CONFLICT),
/* 2352*/ DEF_VALS1(MQRC_LOCAL_UOW_CONFLICT),
/* 2353*/ DEF_VALS1(MQRC_HANDLE_IN_USE_FOR_UOW),
/* 2354*/ DEF_VALS1(MQRC_UOW_ENLISTMENT_ERROR),
/* 2355*/ DEF_VALS1(MQRC_UOW_MIX_NOT_SUPPORTED),
/* 2356*/ DEF_VALS1(MQRC_WXP_ERROR),
/* 2357*/ DEF_VALS1(MQRC_CURRENT_RECORD_ERROR),
/* 2358*/ DEF_VALS1(MQRC_NEXT_OFFSET_ERROR),
/* 2359*/ DEF_VALS1(MQRC_NO_RECORD_AVAILABLE),
/* 2360*/ DEF_VALS1(MQRC_OBJECT_LEVEL_INCOMPATIBLE),
/* 2361*/ DEF_VALS1(MQRC_NEXT_RECORD_ERROR),
/* 2362*/ DEF_VALS1(MQRC_BACKOUT_THRESHOLD_REACHED),
/* 2363*/ DEF_VALS1(MQRC_MSG_NOT_MATCHED),
/* 2364*/ DEF_VALS1(MQRC_JMS_FORMAT_ERROR),
/* 2365*/ DEF_VALS1(MQRC_SEGMENTS_NOT_SUPPORTED),
/* 2366*/ DEF_VALS1(MQRC_WRONG_CF_LEVEL),
/* 2367*/ DEF_VALS1(MQRC_CONFIG_CREATE_OBJECT),
/* 2368*/ DEF_VALS1(MQRC_CONFIG_CHANGE_OBJECT),
/* 2369*/ DEF_VALS1(MQRC_CONFIG_DELETE_OBJECT),
/* 2370*/ DEF_VALS1(MQRC_CONFIG_REFRESH_OBJECT),
/* 2371*/ DEF_VALS1(MQRC_CHANNEL_SSL_ERROR),
/* 2372*/ DEF_VALS1(MQRC_PARTICIPANT_NOT_DEFINED),
/* 2373*/ DEF_VALS1(MQRC_CF_STRUC_FAILED),
/* 2374*/ DEF_VALS1(MQRC_API_EXIT_ERROR),
/* 2375*/ DEF_VALS1(MQRC_API_EXIT_INIT_ERROR),
/* 2376*/ DEF_VALS1(MQRC_API_EXIT_TERM_ERROR),
/* 2377*/ DEF_VALS1(MQRC_EXIT_REASON_ERROR),
/* 2378*/ DEF_VALS1(MQRC_RESERVED_VALUE_ERROR),
/* 2379*/ DEF_VALS1(MQRC_NO_DATA_AVAILABLE),
/* 2380*/ DEF_VALS1(MQRC_SCO_ERROR),
/* 2381*/ DEF_VALS1(MQRC_KEY_REPOSITORY_ERROR),
/* 2382*/ DEF_VALS1(MQRC_CRYPTO_HARDWARE_ERROR),
/* 2383*/ DEF_VALS1(MQRC_AUTH_INFO_REC_COUNT_ERROR),
/* 2384*/ DEF_VALS1(MQRC_AUTH_INFO_REC_ERROR),
/* 2385*/ DEF_VALS1(MQRC_AIR_ERROR),
/* 2386*/ DEF_VALS1(MQRC_AUTH_INFO_TYPE_ERROR),
/* 2387*/ DEF_VALS1(MQRC_AUTH_INFO_CONN_NAME_ERROR),
/* 2388*/ DEF_VALS1(MQRC_LDAP_USER_NAME_ERROR),
/* 2389*/ DEF_VALS1(MQRC_LDAP_USER_NAME_LENGTH_ERR),
/* 2390*/ DEF_VALS1(MQRC_LDAP_PASSWORD_ERROR),
/* 2391*/ DEF_VALS1(MQRC_SSL_ALREADY_INITIALIZED),
/* 2392*/ DEF_VALS1(MQRC_SSL_CONFIG_ERROR),
/* 2393*/ DEF_VALS1(MQRC_SSL_INITIALIZATION_ERROR),
/* 2394*/ DEF_VALS1(MQRC_Q_INDEX_TYPE_ERROR),
/* 2395*/ DEF_VALS1(MQRC_CFBS_ERROR),
/* 2396*/ DEF_VALS1(MQRC_SSL_NOT_ALLOWED),
/* 2397*/ DEF_VALS1(MQRC_JSSE_ERROR),
/* 2398*/ DEF_VALS1(MQRC_SSL_PEER_NAME_MISMATCH),
/* 2399*/ DEF_VALS1(MQRC_SSL_PEER_NAME_ERROR),
/* 2400*/ DEF_VALS1(MQRC_UNSUPPORTED_CIPHER_SUITE),
/* 2401*/ DEF_VALS1(MQRC_SSL_CERTIFICATE_REVOKED),
/* 2402*/ DEF_VALS1(MQRC_SSL_CERT_STORE_ERROR),
/* 2406*/ DEF_VALS1(MQRC_CLIENT_EXIT_LOAD_ERROR),
/* 2407*/ DEF_VALS1(MQRC_CLIENT_EXIT_ERROR),
/* 2408*/ DEF_VALS1(MQRC_UOW_COMMITTED),
/* 2409*/ DEF_VALS1(MQRC_SSL_KEY_RESET_ERROR),
/* 2410*/ DEF_VALS1(MQRC_UNKNOWN_COMPONENT_NAME),
/* 2411*/ DEF_VALS1(MQRC_LOGGER_STATUS),
/* 2412*/ DEF_VALS1(MQRC_COMMAND_MQSC),
/* 2413*/ DEF_VALS1(MQRC_COMMAND_PCF),
/* 2414*/ DEF_VALS1(MQRC_CFIF_ERROR),
/* 2415*/ DEF_VALS1(MQRC_CFSF_ERROR),
/* 2416*/ DEF_VALS1(MQRC_CFGR_ERROR),
/* 2417*/ DEF_VALS1(MQRC_MSG_NOT_ALLOWED_IN_GROUP),
/* 2418*/ DEF_VALS1(MQRC_FILTER_OPERATOR_ERROR),
/* 2419*/ DEF_VALS1(MQRC_NESTED_SELECTOR_ERROR),
/* 2420*/ DEF_VALS1(MQRC_EPH_ERROR),
/* 2421*/ DEF_VALS1(MQRC_RFH_FORMAT_ERROR),
/* 2422*/ DEF_VALS1(MQRC_CFBF_ERROR),
/* 2423*/ DEF_VALS1(MQRC_CLIENT_CHANNEL_CONFLICT),
/* 2424*/ DEF_VALS1(MQRC_SD_ERROR),
/* 2425*/ DEF_VALS1(MQRC_TOPIC_STRING_ERROR),
/* 2426*/ DEF_VALS1(MQRC_STS_ERROR),
/* 2428*/ DEF_VALS1(MQRC_NO_SUBSCRIPTION),
/* 2429*/ DEF_VALS1(MQRC_SUBSCRIPTION_IN_USE),
/* 2430*/ DEF_VALS1(MQRC_STAT_TYPE_ERROR),
/* 2431*/ DEF_VALS1(MQRC_SUB_USER_DATA_ERROR),
/* 2432*/ DEF_VALS1(MQRC_SUB_ALREADY_EXISTS),
/* 2434*/ DEF_VALS1(MQRC_IDENTITY_MISMATCH),
/* 2435*/ DEF_VALS1(MQRC_ALTER_SUB_ERROR),
/* 2436*/ DEF_VALS1(MQRC_DURABILITY_NOT_ALLOWED),
/* 2437*/ DEF_VALS1(MQRC_NO_RETAINED_MSG),
/* 2438*/ DEF_VALS1(MQRC_SRO_ERROR),
/* 2440*/ DEF_VALS1(MQRC_SUB_NAME_ERROR),
/* 2441*/ DEF_VALS1(MQRC_OBJECT_STRING_ERROR),
/* 2442*/ DEF_VALS1(MQRC_PROPERTY_NAME_ERROR),
/* 2443*/ DEF_VALS1(MQRC_SEGMENTATION_NOT_ALLOWED),
/* 2444*/ DEF_VALS1(MQRC_CBD_ERROR),
/* 2445*/ DEF_VALS1(MQRC_CTLO_ERROR),
/* 2446*/ DEF_VALS1(MQRC_NO_CALLBACKS_ACTIVE),
/* 2448*/ DEF_VALS1(MQRC_CALLBACK_NOT_REGISTERED),
/* 2457*/ DEF_VALS1(MQRC_OPTIONS_CHANGED),
/* 2458*/ DEF_VALS1(MQRC_READ_AHEAD_MSGS),
/* 2459*/ DEF_VALS1(MQRC_SELECTOR_SYNTAX_ERROR),
/* 2460*/ DEF_VALS1(MQRC_HMSG_ERROR),
/* 2461*/ DEF_VALS1(MQRC_CMHO_ERROR),
/* 2462*/ DEF_VALS1(MQRC_DMHO_ERROR),
/* 2463*/ DEF_VALS1(MQRC_SMPO_ERROR),
/* 2464*/ DEF_VALS1(MQRC_IMPO_ERROR),
/* 2465*/ DEF_VALS1(MQRC_PROPERTY_NAME_TOO_BIG),
/* 2466*/ DEF_VALS1(MQRC_PROP_VALUE_NOT_CONVERTED),
/* 2467*/ DEF_VALS1(MQRC_PROP_TYPE_NOT_SUPPORTED),
/* 2469*/ DEF_VALS1(MQRC_PROPERTY_VALUE_TOO_BIG),
/* 2470*/ DEF_VALS1(MQRC_PROP_CONV_NOT_SUPPORTED),
/* 2471*/ DEF_VALS1(MQRC_PROPERTY_NOT_AVAILABLE),
/* 2472*/ DEF_VALS1(MQRC_PROP_NUMBER_FORMAT_ERROR),
/* 2473*/ DEF_VALS1(MQRC_PROPERTY_TYPE_ERROR),
/* 2478*/ DEF_VALS1(MQRC_PROPERTIES_TOO_BIG),
/* 2479*/ DEF_VALS1(MQRC_PUT_NOT_RETAINED),
/* 2480*/ DEF_VALS1(MQRC_ALIAS_TARGTYPE_CHANGED),
/* 2481*/ DEF_VALS1(MQRC_DMPO_ERROR),
/* 2482*/ DEF_VALS1(MQRC_PD_ERROR),
/* 2483*/ DEF_VALS1(MQRC_CALLBACK_TYPE_ERROR),
/* 2484*/ DEF_VALS1(MQRC_CBD_OPTIONS_ERROR),
/* 2485*/ DEF_VALS1(MQRC_MAX_MSG_LENGTH_ERROR),
/* 2486*/ DEF_VALS1(MQRC_CALLBACK_ROUTINE_ERROR),
/* 2487*/ DEF_VALS1(MQRC_CALLBACK_LINK_ERROR),
/* 2488*/ DEF_VALS1(MQRC_OPERATION_ERROR),
/* 2489*/ DEF_VALS1(MQRC_BMHO_ERROR),
/* 2490*/ DEF_VALS1(MQRC_UNSUPPORTED_PROPERTY),
/* 2492*/ DEF_VALS1(MQRC_PROP_NAME_NOT_CONVERTED),
/* 2494*/ DEF_VALS1(MQRC_GET_ENABLED),
/* 2495*/ DEF_VALS1(MQRC_MODULE_NOT_FOUND),
/* 2496*/ DEF_VALS1(MQRC_MODULE_INVALID),
/* 2497*/ DEF_VALS1(MQRC_MODULE_ENTRY_NOT_FOUND),
/* 2498*/ DEF_VALS1(MQRC_MIXED_CONTENT_NOT_ALLOWED),
/* 2499*/ DEF_VALS1(MQRC_MSG_HANDLE_IN_USE),
/* 2500*/ DEF_VALS1(MQRC_HCONN_ASYNC_ACTIVE),
/* 2501*/ DEF_VALS1(MQRC_MHBO_ERROR),
/* 2502*/ DEF_VALS1(MQRC_PUBLICATION_FAILURE),
/* 2503*/ DEF_VALS1(MQRC_SUB_INHIBITED),
/* 2504*/ DEF_VALS1(MQRC_SELECTOR_ALWAYS_FALSE),
/* 2507*/ DEF_VALS1(MQRC_XEPO_ERROR),
/* 2509*/ DEF_VALS1(MQRC_DURABILITY_NOT_ALTERABLE),
/* 2510*/ DEF_VALS1(MQRC_TOPIC_NOT_ALTERABLE),
/* 2512*/ DEF_VALS1(MQRC_SUBLEVEL_NOT_ALTERABLE),
/* 2513*/ DEF_VALS1(MQRC_PROPERTY_NAME_LENGTH_ERR),
/* 2514*/ DEF_VALS1(MQRC_DUPLICATE_GROUP_SUB),
/* 2515*/ DEF_VALS1(MQRC_GROUPING_NOT_ALTERABLE),
/* 2516*/ DEF_VALS1(MQRC_SELECTOR_INVALID_FOR_TYPE),
/* 2517*/ DEF_VALS1(MQRC_HOBJ_QUIESCED),
/* 2518*/ DEF_VALS1(MQRC_HOBJ_QUIESCED_NO_MSGS),
/* 2519*/ DEF_VALS1(MQRC_SELECTION_STRING_ERROR),
/* 2520*/ DEF_VALS1(MQRC_RES_OBJECT_STRING_ERROR),
/* 2521*/ DEF_VALS1(MQRC_CONNECTION_SUSPENDED),
/* 2522*/ DEF_VALS1(MQRC_INVALID_DESTINATION),
/* 2523*/ DEF_VALS1(MQRC_INVALID_SUBSCRIPTION),
/* 2524*/ DEF_VALS1(MQRC_SELECTOR_NOT_ALTERABLE),
/* 2525*/ DEF_VALS1(MQRC_RETAINED_MSG_Q_ERROR),
/* 2526*/ DEF_VALS1(MQRC_RETAINED_NOT_DELIVERED),
/* 2527*/ DEF_VALS1(MQRC_RFH_RESTRICTED_FORMAT_ERR),
/* 2528*/ DEF_VALS1(MQRC_CONNECTION_STOPPED),
/* 2529*/ DEF_VALS1(MQRC_ASYNC_UOW_CONFLICT),
/* 2530*/ DEF_VALS1(MQRC_ASYNC_XA_CONFLICT),
/* 2531*/ DEF_VALS1(MQRC_PUBSUB_INHIBITED),
/* 2532*/ DEF_VALS1(MQRC_MSG_HANDLE_COPY_FAILURE),
/* 2533*/ DEF_VALS1(MQRC_DEST_CLASS_NOT_ALTERABLE),
/* 2534*/ DEF_VALS1(MQRC_OPERATION_NOT_ALLOWED),
/* 2535*/ DEF_VALS1(MQRC_ACTION_ERROR),
/* 2537*/ DEF_VALS1(MQRC_CHANNEL_NOT_AVAILABLE),
/* 2538*/ DEF_VALS1(MQRC_HOST_NOT_AVAILABLE),
/* 2539*/ DEF_VALS1(MQRC_CHANNEL_CONFIG_ERROR),
/* 2540*/ DEF_VALS1(MQRC_UNKNOWN_CHANNEL_NAME),
/* 2541*/ DEF_VALS1(MQRC_LOOPING_PUBLICATION),
/* 2542*/ DEF_VALS1(MQRC_ALREADY_JOINED),
/* 2543*/ DEF_VALS1(MQRC_STANDBY_Q_MGR),
/* 2544*/ DEF_VALS1(MQRC_RECONNECTING),
/* 2545*/ DEF_VALS1(MQRC_RECONNECTED),
/* 2546*/ DEF_VALS1(MQRC_RECONNECT_QMID_MISMATCH),
/* 2547*/ DEF_VALS1(MQRC_RECONNECT_INCOMPATIBLE),
/* 2548*/ DEF_VALS1(MQRC_RECONNECT_FAILED),
/* 2549*/ DEF_VALS1(MQRC_CALL_INTERRUPTED),
/* 2550*/ DEF_VALS1(MQRC_NO_SUBS_MATCHED),
/* 2551*/ DEF_VALS1(MQRC_SELECTION_NOT_AVAILABLE),
/* 2552*/ DEF_VALS1(MQRC_CHANNEL_SSL_WARNING),
/* 2553*/ DEF_VALS1(MQRC_OCSP_URL_ERROR),
/* 2554*/ DEF_VALS1(MQRC_CONTENT_ERROR),
/* 2555*/ DEF_VALS1(MQRC_RECONNECT_Q_MGR_REQD),
/* 2556*/ DEF_VALS1(MQRC_RECONNECT_TIMED_OUT),
/* 2557*/ DEF_VALS1(MQRC_PUBLISH_EXIT_ERROR),
/* 2558*/ DEF_VALS1(MQRC_COMMINFO_ERROR),
/* 2559*/ DEF_VALS1(MQRC_DEF_SYNCPOINT_INHIBITED),
/* 2560*/ DEF_VALS1(MQRC_MULTICAST_ONLY),
/* 2561*/ DEF_VALS1(MQRC_DATA_SET_NOT_AVAILABLE),
/* 2562*/ DEF_VALS1(MQRC_GROUPING_NOT_ALLOWED),
/* 2563*/ DEF_VALS1(MQRC_GROUP_ADDRESS_ERROR),
/* 2564*/ DEF_VALS1(MQRC_MULTICAST_CONFIG_ERROR),
/* 2565*/ DEF_VALS1(MQRC_MULTICAST_INTERFACE_ERROR),
/* 2566*/ DEF_VALS1(MQRC_MULTICAST_SEND_ERROR),
/* 2567*/ DEF_VALS1(MQRC_MULTICAST_INTERNAL_ERROR),
/* 2568*/ DEF_VALS1(MQRC_CONNECTION_NOT_AVAILABLE),
/* 2569*/ DEF_VALS1(MQRC_SYNCPOINT_NOT_ALLOWED),
/* 2570*/ DEF_VALS1(MQRC_SSL_ALT_PROVIDER_REQUIRED),
/* 2571*/ DEF_VALS1(MQRC_MCAST_PUB_STATUS),
/* 2572*/ DEF_VALS1(MQRC_MCAST_SUB_STATUS),
/* 2573*/ DEF_VALS1(MQRC_PRECONN_EXIT_LOAD_ERROR),
/* 2574*/ DEF_VALS1(MQRC_PRECONN_EXIT_NOT_FOUND),
/* 2575*/ DEF_VALS1(MQRC_PRECONN_EXIT_ERROR),
/* 2576*/ DEF_VALS1(MQRC_CD_ARRAY_ERROR),
/* 2577*/ DEF_VALS1(MQRC_CHANNEL_BLOCKED),
/* 2578*/ DEF_VALS1(MQRC_CHANNEL_BLOCKED_WARNING),
/* 2579*/ DEF_VALS1(MQRC_SUBSCRIPTION_CREATE),
/* 2580*/ DEF_VALS1(MQRC_SUBSCRIPTION_DELETE),
/* 2581*/ DEF_VALS1(MQRC_SUBSCRIPTION_CHANGE),
/* 2582*/ DEF_VALS1(MQRC_SUBSCRIPTION_REFRESH),
/* 2583*/ DEF_VALS1(MQRC_INSTALLATION_MISMATCH),
/* 2584*/ DEF_VALS1(MQRC_NOT_PRIVILEGED),
/* 2586*/ DEF_VALS1(MQRC_PROPERTIES_DISABLED),
/* 2587*/ DEF_VALS1(MQRC_HMSG_NOT_AVAILABLE),
/* 2588*/ DEF_VALS1(MQRC_EXIT_PROPS_NOT_SUPPORTED),
/* 2589*/ DEF_VALS1(MQRC_INSTALLATION_MISSING),
/* 2590*/ DEF_VALS1(MQRC_FASTPATH_NOT_AVAILABLE),
/* 2591*/ DEF_VALS1(MQRC_CIPHER_SPEC_NOT_SUITE_B),
/* 2592*/ DEF_VALS1(MQRC_SUITE_B_ERROR),
/* 2593*/ DEF_VALS1(MQRC_CERT_VAL_POLICY_ERROR),
/* 2594*/ DEF_VALS1(MQRC_PASSWORD_PROTECTION_ERROR),
/* 2595*/ DEF_VALS1(MQRC_CSP_ERROR),
/* 2596*/ DEF_VALS1(MQRC_CERT_LABEL_NOT_ALLOWED),
/* 2598*/ DEF_VALS1(MQRC_ADMIN_TOPIC_STRING_ERROR),
/* 2599*/ DEF_VALS1(MQRC_AMQP_NOT_AVAILABLE),
/* 2600*/ DEF_VALS1(MQRC_CCDT_URL_ERROR),
/* 3001*/ DEF_VALS1(MQRCCF_CFH_TYPE_ERROR),
/* 3002*/ DEF_VALS1(MQRCCF_CFH_LENGTH_ERROR),
/* 3003*/ DEF_VALS1(MQRCCF_CFH_VERSION_ERROR),
/* 3004*/ DEF_VALS1(MQRCCF_CFH_MSG_SEQ_NUMBER_ERR),
/* 3005*/ DEF_VALS1(MQRCCF_CFH_CONTROL_ERROR),
/* 3006*/ DEF_VALS1(MQRCCF_CFH_PARM_COUNT_ERROR),
/* 3007*/ DEF_VALS1(MQRCCF_CFH_COMMAND_ERROR),
/* 3008*/ DEF_VALS1(MQRCCF_COMMAND_FAILED),
/* 3009*/ DEF_VALS1(MQRCCF_CFIN_LENGTH_ERROR),
/* 3010*/ DEF_VALS1(MQRCCF_CFST_LENGTH_ERROR),
/* 3011*/ DEF_VALS1(MQRCCF_CFST_STRING_LENGTH_ERR),
/* 3012*/ DEF_VALS1(MQRCCF_FORCE_VALUE_ERROR),
/* 3013*/ DEF_VALS1(MQRCCF_STRUCTURE_TYPE_ERROR),
/* 3014*/ DEF_VALS1(MQRCCF_CFIN_PARM_ID_ERROR),
/* 3015*/ DEF_VALS1(MQRCCF_CFST_PARM_ID_ERROR),
/* 3016*/ DEF_VALS1(MQRCCF_MSG_LENGTH_ERROR),
/* 3017*/ DEF_VALS1(MQRCCF_CFIN_DUPLICATE_PARM),
/* 3018*/ DEF_VALS1(MQRCCF_CFST_DUPLICATE_PARM),
/* 3019*/ DEF_VALS1(MQRCCF_PARM_COUNT_TOO_SMALL),
/* 3020*/ DEF_VALS1(MQRCCF_PARM_COUNT_TOO_BIG),
/* 3021*/ DEF_VALS1(MQRCCF_Q_ALREADY_IN_CELL),
/* 3022*/ DEF_VALS1(MQRCCF_Q_TYPE_ERROR),
/* 3023*/ DEF_VALS1(MQRCCF_MD_FORMAT_ERROR),
/* 3024*/ DEF_VALS1(MQRCCF_CFSL_LENGTH_ERROR),
/* 3025*/ DEF_VALS1(MQRCCF_REPLACE_VALUE_ERROR),
/* 3026*/ DEF_VALS1(MQRCCF_CFIL_DUPLICATE_VALUE),
/* 3027*/ DEF_VALS1(MQRCCF_CFIL_COUNT_ERROR),
/* 3028*/ DEF_VALS1(MQRCCF_CFIL_LENGTH_ERROR),
/* 3029*/ DEF_VALS1(MQRCCF_QUIESCE_VALUE_ERROR),
/* 3029   DEF_VALS1(MQRCCF_MODE_VALUE_ERROR), */
/* 3030*/ DEF_VALS1(MQRCCF_MSG_SEQ_NUMBER_ERROR),
/* 3031*/ DEF_VALS1(MQRCCF_PING_DATA_COUNT_ERROR),
/* 3032*/ DEF_VALS1(MQRCCF_PING_DATA_COMPARE_ERROR),
/* 3033*/ DEF_VALS1(MQRCCF_CFSL_PARM_ID_ERROR),
/* 3034*/ DEF_VALS1(MQRCCF_CHANNEL_TYPE_ERROR),
/* 3035*/ DEF_VALS1(MQRCCF_PARM_SEQUENCE_ERROR),
/* 3036*/ DEF_VALS1(MQRCCF_XMIT_PROTOCOL_TYPE_ERR),
/* 3037*/ DEF_VALS1(MQRCCF_BATCH_SIZE_ERROR),
/* 3038*/ DEF_VALS1(MQRCCF_DISC_INT_ERROR),
/* 3039*/ DEF_VALS1(MQRCCF_SHORT_RETRY_ERROR),
/* 3040*/ DEF_VALS1(MQRCCF_SHORT_TIMER_ERROR),
/* 3041*/ DEF_VALS1(MQRCCF_LONG_RETRY_ERROR),
/* 3042*/ DEF_VALS1(MQRCCF_LONG_TIMER_ERROR),
/* 3043*/ DEF_VALS1(MQRCCF_SEQ_NUMBER_WRAP_ERROR),
/* 3044*/ DEF_VALS1(MQRCCF_MAX_MSG_LENGTH_ERROR),
/* 3045*/ DEF_VALS1(MQRCCF_PUT_AUTH_ERROR),
/* 3046*/ DEF_VALS1(MQRCCF_PURGE_VALUE_ERROR),
/* 3047*/ DEF_VALS1(MQRCCF_CFIL_PARM_ID_ERROR),
/* 3048*/ DEF_VALS1(MQRCCF_MSG_TRUNCATED),
/* 3049*/ DEF_VALS1(MQRCCF_CCSID_ERROR),
/* 3050*/ DEF_VALS1(MQRCCF_ENCODING_ERROR),
/* 3051*/ DEF_VALS1(MQRCCF_QUEUES_VALUE_ERROR),
/* 3052*/ DEF_VALS1(MQRCCF_DATA_CONV_VALUE_ERROR),
/* 3053*/ DEF_VALS1(MQRCCF_INDOUBT_VALUE_ERROR),
/* 3054*/ DEF_VALS1(MQRCCF_ESCAPE_TYPE_ERROR),
/* 3055*/ DEF_VALS1(MQRCCF_REPOS_VALUE_ERROR),
/* 3062*/ DEF_VALS1(MQRCCF_CHANNEL_TABLE_ERROR),
/* 3063*/ DEF_VALS1(MQRCCF_MCA_TYPE_ERROR),
/* 3064*/ DEF_VALS1(MQRCCF_CHL_INST_TYPE_ERROR),
/* 3065*/ DEF_VALS1(MQRCCF_CHL_STATUS_NOT_FOUND),
/* 3066*/ DEF_VALS1(MQRCCF_CFSL_DUPLICATE_PARM),
/* 3067*/ DEF_VALS1(MQRCCF_CFSL_TOTAL_LENGTH_ERROR),
/* 3068*/ DEF_VALS1(MQRCCF_CFSL_COUNT_ERROR),
/* 3069*/ DEF_VALS1(MQRCCF_CFSL_STRING_LENGTH_ERR),
/* 3070*/ DEF_VALS1(MQRCCF_BROKER_DELETED),
/* 3071*/ DEF_VALS1(MQRCCF_STREAM_ERROR),
/* 3072*/ DEF_VALS1(MQRCCF_TOPIC_ERROR),
/* 3073*/ DEF_VALS1(MQRCCF_NOT_REGISTERED),
/* 3074*/ DEF_VALS1(MQRCCF_Q_MGR_NAME_ERROR),
/* 3075*/ DEF_VALS1(MQRCCF_INCORRECT_STREAM),
/* 3076*/ DEF_VALS1(MQRCCF_Q_NAME_ERROR),
/* 3077*/ DEF_VALS1(MQRCCF_NO_RETAINED_MSG),
/* 3078*/ DEF_VALS1(MQRCCF_DUPLICATE_IDENTITY),
/* 3079*/ DEF_VALS1(MQRCCF_INCORRECT_Q),
/* 3080*/ DEF_VALS1(MQRCCF_CORREL_ID_ERROR),
/* 3081*/ DEF_VALS1(MQRCCF_NOT_AUTHORIZED),
/* 3082*/ DEF_VALS1(MQRCCF_UNKNOWN_STREAM),
/* 3083*/ DEF_VALS1(MQRCCF_REG_OPTIONS_ERROR),
/* 3084*/ DEF_VALS1(MQRCCF_PUB_OPTIONS_ERROR),
/* 3085*/ DEF_VALS1(MQRCCF_UNKNOWN_BROKER),
/* 3086*/ DEF_VALS1(MQRCCF_Q_MGR_CCSID_ERROR),
/* 3087*/ DEF_VALS1(MQRCCF_DEL_OPTIONS_ERROR),
/* 3088*/ DEF_VALS1(MQRCCF_CLUSTER_NAME_CONFLICT),
/* 3089*/ DEF_VALS1(MQRCCF_REPOS_NAME_CONFLICT),
/* 3090*/ DEF_VALS1(MQRCCF_CLUSTER_Q_USAGE_ERROR),
/* 3091*/ DEF_VALS1(MQRCCF_ACTION_VALUE_ERROR),
/* 3092*/ DEF_VALS1(MQRCCF_COMMS_LIBRARY_ERROR),
/* 3093*/ DEF_VALS1(MQRCCF_NETBIOS_NAME_ERROR),
/* 3094*/ DEF_VALS1(MQRCCF_BROKER_COMMAND_FAILED),
/* 3095*/ DEF_VALS1(MQRCCF_CFST_CONFLICTING_PARM),
/* 3096*/ DEF_VALS1(MQRCCF_PATH_NOT_VALID),
/* 3097*/ DEF_VALS1(MQRCCF_PARM_SYNTAX_ERROR),
/* 3098*/ DEF_VALS1(MQRCCF_PWD_LENGTH_ERROR),
/* 3150*/ DEF_VALS1(MQRCCF_FILTER_ERROR),
/* 3151*/ DEF_VALS1(MQRCCF_WRONG_USER),
/* 3152*/ DEF_VALS1(MQRCCF_DUPLICATE_SUBSCRIPTION),
/* 3153*/ DEF_VALS1(MQRCCF_SUB_NAME_ERROR),
/* 3154*/ DEF_VALS1(MQRCCF_SUB_IDENTITY_ERROR),
/* 3155*/ DEF_VALS1(MQRCCF_SUBSCRIPTION_IN_USE),
/* 3156*/ DEF_VALS1(MQRCCF_SUBSCRIPTION_LOCKED),
/* 3157*/ DEF_VALS1(MQRCCF_ALREADY_JOINED),
/* 3160*/ DEF_VALS1(MQRCCF_OBJECT_IN_USE),
/* 3161*/ DEF_VALS1(MQRCCF_UNKNOWN_FILE_NAME),
/* 3162*/ DEF_VALS1(MQRCCF_FILE_NOT_AVAILABLE),
/* 3163*/ DEF_VALS1(MQRCCF_DISC_RETRY_ERROR),
/* 3164*/ DEF_VALS1(MQRCCF_ALLOC_RETRY_ERROR),
/* 3165*/ DEF_VALS1(MQRCCF_ALLOC_SLOW_TIMER_ERROR),
/* 3166*/ DEF_VALS1(MQRCCF_ALLOC_FAST_TIMER_ERROR),
/* 3167*/ DEF_VALS1(MQRCCF_PORT_NUMBER_ERROR),
/* 3168*/ DEF_VALS1(MQRCCF_CHL_SYSTEM_NOT_ACTIVE),
/* 3169*/ DEF_VALS1(MQRCCF_ENTITY_NAME_MISSING),
/* 3170*/ DEF_VALS1(MQRCCF_PROFILE_NAME_ERROR),
/* 3171*/ DEF_VALS1(MQRCCF_AUTH_VALUE_ERROR),
/* 3172*/ DEF_VALS1(MQRCCF_AUTH_VALUE_MISSING),
/* 3173*/ DEF_VALS1(MQRCCF_OBJECT_TYPE_MISSING),
/* 3174*/ DEF_VALS1(MQRCCF_CONNECTION_ID_ERROR),
/* 3175*/ DEF_VALS1(MQRCCF_LOG_TYPE_ERROR),
/* 3176*/ DEF_VALS1(MQRCCF_PROGRAM_NOT_AVAILABLE),
/* 3177*/ DEF_VALS1(MQRCCF_PROGRAM_AUTH_FAILED),
/* 3200*/ DEF_VALS1(MQRCCF_NONE_FOUND),
/* 3201*/ DEF_VALS1(MQRCCF_SECURITY_SWITCH_OFF),
/* 3202*/ DEF_VALS1(MQRCCF_SECURITY_REFRESH_FAILED),
/* 3203*/ DEF_VALS1(MQRCCF_PARM_CONFLICT),
/* 3204*/ DEF_VALS1(MQRCCF_COMMAND_INHIBITED),
/* 3205*/ DEF_VALS1(MQRCCF_OBJECT_BEING_DELETED),
/* 3207*/ DEF_VALS1(MQRCCF_STORAGE_CLASS_IN_USE),
/* 3208*/ DEF_VALS1(MQRCCF_OBJECT_NAME_RESTRICTED),
/* 3209*/ DEF_VALS1(MQRCCF_OBJECT_LIMIT_EXCEEDED),
/* 3210*/ DEF_VALS1(MQRCCF_OBJECT_OPEN_FORCE),
/* 3211*/ DEF_VALS1(MQRCCF_DISPOSITION_CONFLICT),
/* 3212*/ DEF_VALS1(MQRCCF_Q_MGR_NOT_IN_QSG),
/* 3213*/ DEF_VALS1(MQRCCF_ATTR_VALUE_FIXED),
/* 3215*/ DEF_VALS1(MQRCCF_NAMELIST_ERROR),
/* 3217*/ DEF_VALS1(MQRCCF_NO_CHANNEL_INITIATOR),
/* 3218*/ DEF_VALS1(MQRCCF_CHANNEL_INITIATOR_ERROR),
/* 3222*/ DEF_VALS1(MQRCCF_COMMAND_LEVEL_CONFLICT),
/* 3223*/ DEF_VALS1(MQRCCF_Q_ATTR_CONFLICT),
/* 3224*/ DEF_VALS1(MQRCCF_EVENTS_DISABLED),
/* 3225*/ DEF_VALS1(MQRCCF_COMMAND_SCOPE_ERROR),
/* 3226*/ DEF_VALS1(MQRCCF_COMMAND_REPLY_ERROR),
/* 3227*/ DEF_VALS1(MQRCCF_FUNCTION_RESTRICTED),
/* 3228*/ DEF_VALS1(MQRCCF_PARM_MISSING),
/* 3229*/ DEF_VALS1(MQRCCF_PARM_VALUE_ERROR),
/* 3230*/ DEF_VALS1(MQRCCF_COMMAND_LENGTH_ERROR),
/* 3231*/ DEF_VALS1(MQRCCF_COMMAND_ORIGIN_ERROR),
/* 3232*/ DEF_VALS1(MQRCCF_LISTENER_CONFLICT),
/* 3233*/ DEF_VALS1(MQRCCF_LISTENER_STARTED),
/* 3234*/ DEF_VALS1(MQRCCF_LISTENER_STOPPED),
/* 3235*/ DEF_VALS1(MQRCCF_CHANNEL_ERROR),
/* 3236*/ DEF_VALS1(MQRCCF_CF_STRUC_ERROR),
/* 3237*/ DEF_VALS1(MQRCCF_UNKNOWN_USER_ID),
/* 3238*/ DEF_VALS1(MQRCCF_UNEXPECTED_ERROR),
/* 3239*/ DEF_VALS1(MQRCCF_NO_XCF_PARTNER),
/* 3240*/ DEF_VALS1(MQRCCF_CFGR_PARM_ID_ERROR),
/* 3241*/ DEF_VALS1(MQRCCF_CFIF_LENGTH_ERROR),
/* 3242*/ DEF_VALS1(MQRCCF_CFIF_OPERATOR_ERROR),
/* 3243*/ DEF_VALS1(MQRCCF_CFIF_PARM_ID_ERROR),
/* 3244*/ DEF_VALS1(MQRCCF_CFSF_FILTER_VAL_LEN_ERR),
/* 3245*/ DEF_VALS1(MQRCCF_CFSF_LENGTH_ERROR),
/* 3246*/ DEF_VALS1(MQRCCF_CFSF_OPERATOR_ERROR),
/* 3247*/ DEF_VALS1(MQRCCF_CFSF_PARM_ID_ERROR),
/* 3248*/ DEF_VALS1(MQRCCF_TOO_MANY_FILTERS),
/* 3249*/ DEF_VALS1(MQRCCF_LISTENER_RUNNING),
/* 3250*/ DEF_VALS1(MQRCCF_LSTR_STATUS_NOT_FOUND),
/* 3251*/ DEF_VALS1(MQRCCF_SERVICE_RUNNING),
/* 3252*/ DEF_VALS1(MQRCCF_SERV_STATUS_NOT_FOUND),
/* 3253*/ DEF_VALS1(MQRCCF_SERVICE_STOPPED),
/* 3254*/ DEF_VALS1(MQRCCF_CFBS_DUPLICATE_PARM),
/* 3255*/ DEF_VALS1(MQRCCF_CFBS_LENGTH_ERROR),
/* 3256*/ DEF_VALS1(MQRCCF_CFBS_PARM_ID_ERROR),
/* 3257*/ DEF_VALS1(MQRCCF_CFBS_STRING_LENGTH_ERR),
/* 3258*/ DEF_VALS1(MQRCCF_CFGR_LENGTH_ERROR),
/* 3259*/ DEF_VALS1(MQRCCF_CFGR_PARM_COUNT_ERROR),
/* 3260*/ DEF_VALS1(MQRCCF_CONN_NOT_STOPPED),
/* 3261*/ DEF_VALS1(MQRCCF_SERVICE_REQUEST_PENDING),
/* 3262*/ DEF_VALS1(MQRCCF_NO_START_CMD),
/* 3263*/ DEF_VALS1(MQRCCF_NO_STOP_CMD),
/* 3264*/ DEF_VALS1(MQRCCF_CFBF_LENGTH_ERROR),
/* 3265*/ DEF_VALS1(MQRCCF_CFBF_PARM_ID_ERROR),
/* 3266*/ DEF_VALS1(MQRCCF_CFBF_OPERATOR_ERROR),
/* 3267*/ DEF_VALS1(MQRCCF_CFBF_FILTER_VAL_LEN_ERR),
/* 3268*/ DEF_VALS1(MQRCCF_LISTENER_STILL_ACTIVE),
/* 3269*/ DEF_VALS1(MQRCCF_DEF_XMIT_Q_CLUS_ERROR),
/* 3300*/ DEF_VALS1(MQRCCF_TOPICSTR_ALREADY_EXISTS),
/* 3301*/ DEF_VALS1(MQRCCF_SHARING_CONVS_ERROR),
/* 3302*/ DEF_VALS1(MQRCCF_SHARING_CONVS_TYPE),
/* 3303*/ DEF_VALS1(MQRCCF_SECURITY_CASE_CONFLICT),
/* 3305*/ DEF_VALS1(MQRCCF_TOPIC_TYPE_ERROR),
/* 3306*/ DEF_VALS1(MQRCCF_MAX_INSTANCES_ERROR),
/* 3307*/ DEF_VALS1(MQRCCF_MAX_INSTS_PER_CLNT_ERR),
/* 3308*/ DEF_VALS1(MQRCCF_TOPIC_STRING_NOT_FOUND),
/* 3309*/ DEF_VALS1(MQRCCF_SUBSCRIPTION_POINT_ERR),
/* 3311*/ DEF_VALS1(MQRCCF_SUB_ALREADY_EXISTS),
/* 3312*/ DEF_VALS1(MQRCCF_UNKNOWN_OBJECT_NAME),
/* 3313*/ DEF_VALS1(MQRCCF_REMOTE_Q_NAME_ERROR),
/* 3314*/ DEF_VALS1(MQRCCF_DURABILITY_NOT_ALLOWED),
/* 3315*/ DEF_VALS1(MQRCCF_HOBJ_ERROR),
/* 3316*/ DEF_VALS1(MQRCCF_DEST_NAME_ERROR),
/* 3317*/ DEF_VALS1(MQRCCF_INVALID_DESTINATION),
/* 3318*/ DEF_VALS1(MQRCCF_PUBSUB_INHIBITED),
/* 3319*/ DEF_VALS1(MQRCCF_GROUPUR_CHECKS_FAILED),
/* 3320*/ DEF_VALS1(MQRCCF_COMM_INFO_TYPE_ERROR),
/* 3321*/ DEF_VALS1(MQRCCF_USE_CLIENT_ID_ERROR),
/* 3322*/ DEF_VALS1(MQRCCF_CLIENT_ID_NOT_FOUND),
/* 3323*/ DEF_VALS1(MQRCCF_CLIENT_ID_ERROR),
/* 3324*/ DEF_VALS1(MQRCCF_PORT_IN_USE),
/* 3325*/ DEF_VALS1(MQRCCF_SSL_ALT_PROVIDER_REQD),
/* 3326*/ DEF_VALS1(MQRCCF_CHLAUTH_TYPE_ERROR),
/* 3327*/ DEF_VALS1(MQRCCF_CHLAUTH_ACTION_ERROR),
/* 3328*/ DEF_VALS1(MQRCCF_POLICY_NOT_FOUND),
/* 3329*/ DEF_VALS1(MQRCCF_ENCRYPTION_ALG_ERROR),
/* 3330*/ DEF_VALS1(MQRCCF_SIGNATURE_ALG_ERROR),
/* 3331*/ DEF_VALS1(MQRCCF_TOLERATION_POL_ERROR),
/* 3332*/ DEF_VALS1(MQRCCF_POLICY_VERSION_ERROR),
/* 3333*/ DEF_VALS1(MQRCCF_RECIPIENT_DN_MISSING),
/* 3334*/ DEF_VALS1(MQRCCF_POLICY_NAME_MISSING),
/* 3335*/ DEF_VALS1(MQRCCF_CHLAUTH_USERSRC_ERROR),
/* 3336*/ DEF_VALS1(MQRCCF_WRONG_CHLAUTH_TYPE),
/* 3337*/ DEF_VALS1(MQRCCF_CHLAUTH_ALREADY_EXISTS),
/* 3338*/ DEF_VALS1(MQRCCF_CHLAUTH_NOT_FOUND),
/* 3339*/ DEF_VALS1(MQRCCF_WRONG_CHLAUTH_ACTION),
/* 3340*/ DEF_VALS1(MQRCCF_WRONG_CHLAUTH_USERSRC),
/* 3341*/ DEF_VALS1(MQRCCF_CHLAUTH_WARN_ERROR),
/* 3342*/ DEF_VALS1(MQRCCF_WRONG_CHLAUTH_MATCH),
/* 3343*/ DEF_VALS1(MQRCCF_IPADDR_RANGE_CONFLICT),
/* 3344*/ DEF_VALS1(MQRCCF_CHLAUTH_MAX_EXCEEDED),
/* 3345   DEF_VALS1(MQRCCF_IPADDR_ERROR), */
/* 3345*/ DEF_VALS1(MQRCCF_ADDRESS_ERROR),
/* 3346*/ DEF_VALS1(MQRCCF_IPADDR_RANGE_ERROR),
/* 3347*/ DEF_VALS1(MQRCCF_PROFILE_NAME_MISSING),
/* 3348*/ DEF_VALS1(MQRCCF_CHLAUTH_CLNTUSER_ERROR),
/* 3349*/ DEF_VALS1(MQRCCF_CHLAUTH_NAME_ERROR),
/* 3350*/ DEF_VALS1(MQRCCF_CHLAUTH_RUNCHECK_ERROR),
/* 3351*/ DEF_VALS1(MQRCCF_CF_STRUC_ALREADY_FAILED),
/* 3352*/ DEF_VALS1(MQRCCF_CFCONLOS_CHECKS_FAILED),
/* 3353*/ DEF_VALS1(MQRCCF_SUITE_B_ERROR),
/* 3354*/ DEF_VALS1(MQRCCF_CHANNEL_NOT_STARTED),
/* 3355*/ DEF_VALS1(MQRCCF_CUSTOM_ERROR),
/* 3356*/ DEF_VALS1(MQRCCF_BACKLOG_OUT_OF_RANGE),
/* 3357*/ DEF_VALS1(MQRCCF_CHLAUTH_DISABLED),
/* 3358*/ DEF_VALS1(MQRCCF_SMDS_REQUIRES_DSGROUP),
/* 3359*/ DEF_VALS1(MQRCCF_PSCLUS_DISABLED_TOPDEF),
/* 3360*/ DEF_VALS1(MQRCCF_PSCLUS_TOPIC_EXISTS),
/* 3361*/ DEF_VALS1(MQRCCF_SSL_CIPHER_SUITE_ERROR),
/* 3362*/ DEF_VALS1(MQRCCF_SOCKET_ERROR),
/* 3363*/ DEF_VALS1(MQRCCF_CLUS_XMIT_Q_USAGE_ERROR),
/* 3364*/ DEF_VALS1(MQRCCF_CERT_VAL_POLICY_ERROR),
/* 3365*/ DEF_VALS1(MQRCCF_INVALID_PROTOCOL),
/* 3366*/ DEF_VALS1(MQRCCF_REVDNS_DISABLED),
/* 3367*/ DEF_VALS1(MQRCCF_CLROUTE_NOT_ALTERABLE),
/* 3368*/ DEF_VALS1(MQRCCF_CLUSTER_TOPIC_CONFLICT),
/* 3369*/ DEF_VALS1(MQRCCF_DEFCLXQ_MODEL_Q_ERROR),
/* 3370*/ DEF_VALS1(MQRCCF_CHLAUTH_CHKCLI_ERROR),
/* 3371*/ DEF_VALS1(MQRCCF_CERT_LABEL_NOT_ALLOWED),
/* 3372*/ DEF_VALS1(MQRCCF_Q_MGR_ATTR_CONFLICT),
/* 3373*/ DEF_VALS1(MQRCCF_ENTITY_TYPE_MISSING),
/* 3374*/ DEF_VALS1(MQRCCF_CLWL_EXIT_NAME_ERROR),
/* 3375*/ DEF_VALS1(MQRCCF_SERVICE_NAME_ERROR),
/* 3376*/ DEF_VALS1(MQRCCF_REMOTE_CHL_TYPE_ERROR),
/* 3377*/ DEF_VALS1(MQRCCF_TOPIC_RESTRICTED),
/* 3378*/ DEF_VALS1(MQRCCF_CURRENT_LOG_EXTENT),
/* 3379*/ DEF_VALS1(MQRCCF_LOG_EXTENT_NOT_FOUND),
/* 3380*/ DEF_VALS1(MQRCCF_LOG_NOT_REDUCED),
/* 3381*/ DEF_VALS1(MQRCCF_LOG_EXTENT_ERROR),
/* 3382*/ DEF_VALS1(MQRCCF_ACCESS_BLOCKED),
/* 4001*/ DEF_VALS1(MQRCCF_OBJECT_ALREADY_EXISTS),
/* 4002*/ DEF_VALS1(MQRCCF_OBJECT_WRONG_TYPE),
/* 4003*/ DEF_VALS1(MQRCCF_LIKE_OBJECT_WRONG_TYPE),
/* 4004*/ DEF_VALS1(MQRCCF_OBJECT_OPEN),
/* 4005*/ DEF_VALS1(MQRCCF_ATTR_VALUE_ERROR),
/* 4006*/ DEF_VALS1(MQRCCF_UNKNOWN_Q_MGR),
/* 4007*/ DEF_VALS1(MQRCCF_Q_WRONG_TYPE),
/* 4008*/ DEF_VALS1(MQRCCF_OBJECT_NAME_ERROR),
/* 4009*/ DEF_VALS1(MQRCCF_ALLOCATE_FAILED),
/* 4010*/ DEF_VALS1(MQRCCF_HOST_NOT_AVAILABLE),
/* 4011*/ DEF_VALS1(MQRCCF_CONFIGURATION_ERROR),
/* 4012*/ DEF_VALS1(MQRCCF_CONNECTION_REFUSED),
/* 4013*/ DEF_VALS1(MQRCCF_ENTRY_ERROR),
/* 4014*/ DEF_VALS1(MQRCCF_SEND_FAILED),
/* 4015*/ DEF_VALS1(MQRCCF_RECEIVED_DATA_ERROR),
/* 4016*/ DEF_VALS1(MQRCCF_RECEIVE_FAILED),
/* 4017*/ DEF_VALS1(MQRCCF_CONNECTION_CLOSED),
/* 4018*/ DEF_VALS1(MQRCCF_NO_STORAGE),
/* 4019*/ DEF_VALS1(MQRCCF_NO_COMMS_MANAGER),
/* 4020*/ DEF_VALS1(MQRCCF_LISTENER_NOT_STARTED),
/* 4024*/ DEF_VALS1(MQRCCF_BIND_FAILED),
/* 4025*/ DEF_VALS1(MQRCCF_CHANNEL_INDOUBT),
/* 4026*/ DEF_VALS1(MQRCCF_MQCONN_FAILED),
/* 4027*/ DEF_VALS1(MQRCCF_MQOPEN_FAILED),
/* 4028*/ DEF_VALS1(MQRCCF_MQGET_FAILED),
/* 4029*/ DEF_VALS1(MQRCCF_MQPUT_FAILED),
/* 4030*/ DEF_VALS1(MQRCCF_PING_ERROR),
/* 4031*/ DEF_VALS1(MQRCCF_CHANNEL_IN_USE),
/* 4032*/ DEF_VALS1(MQRCCF_CHANNEL_NOT_FOUND),
/* 4033*/ DEF_VALS1(MQRCCF_UNKNOWN_REMOTE_CHANNEL),
/* 4034*/ DEF_VALS1(MQRCCF_REMOTE_QM_UNAVAILABLE),
/* 4035*/ DEF_VALS1(MQRCCF_REMOTE_QM_TERMINATING),
/* 4036*/ DEF_VALS1(MQRCCF_MQINQ_FAILED),
/* 4037*/ DEF_VALS1(MQRCCF_NOT_XMIT_Q),
/* 4038*/ DEF_VALS1(MQRCCF_CHANNEL_DISABLED),
/* 4039*/ DEF_VALS1(MQRCCF_USER_EXIT_NOT_AVAILABLE),
/* 4040*/ DEF_VALS1(MQRCCF_COMMIT_FAILED),
/* 4041*/ DEF_VALS1(MQRCCF_WRONG_CHANNEL_TYPE),
/* 4042*/ DEF_VALS1(MQRCCF_CHANNEL_ALREADY_EXISTS),
/* 4043*/ DEF_VALS1(MQRCCF_DATA_TOO_LARGE),
/* 4044*/ DEF_VALS1(MQRCCF_CHANNEL_NAME_ERROR),
/* 4045*/ DEF_VALS1(MQRCCF_XMIT_Q_NAME_ERROR),
/* 4047*/ DEF_VALS1(MQRCCF_MCA_NAME_ERROR),
/* 4048*/ DEF_VALS1(MQRCCF_SEND_EXIT_NAME_ERROR),
/* 4049*/ DEF_VALS1(MQRCCF_SEC_EXIT_NAME_ERROR),
/* 4050*/ DEF_VALS1(MQRCCF_MSG_EXIT_NAME_ERROR),
/* 4051*/ DEF_VALS1(MQRCCF_RCV_EXIT_NAME_ERROR),
/* 4052*/ DEF_VALS1(MQRCCF_XMIT_Q_NAME_WRONG_TYPE),
/* 4053*/ DEF_VALS1(MQRCCF_MCA_NAME_WRONG_TYPE),
/* 4054*/ DEF_VALS1(MQRCCF_DISC_INT_WRONG_TYPE),
/* 4055*/ DEF_VALS1(MQRCCF_SHORT_RETRY_WRONG_TYPE),
/* 4056*/ DEF_VALS1(MQRCCF_SHORT_TIMER_WRONG_TYPE),
/* 4057*/ DEF_VALS1(MQRCCF_LONG_RETRY_WRONG_TYPE),
/* 4058*/ DEF_VALS1(MQRCCF_LONG_TIMER_WRONG_TYPE),
/* 4059*/ DEF_VALS1(MQRCCF_PUT_AUTH_WRONG_TYPE),
/* 4060*/ DEF_VALS1(MQRCCF_KEEP_ALIVE_INT_ERROR),
/* 4061*/ DEF_VALS1(MQRCCF_MISSING_CONN_NAME),
/* 4062*/ DEF_VALS1(MQRCCF_CONN_NAME_ERROR),
/* 4063*/ DEF_VALS1(MQRCCF_MQSET_FAILED),
/* 4064*/ DEF_VALS1(MQRCCF_CHANNEL_NOT_ACTIVE),
/* 4065*/ DEF_VALS1(MQRCCF_TERMINATED_BY_SEC_EXIT),
/* 4067*/ DEF_VALS1(MQRCCF_DYNAMIC_Q_SCOPE_ERROR),
/* 4068*/ DEF_VALS1(MQRCCF_CELL_DIR_NOT_AVAILABLE),
/* 4069*/ DEF_VALS1(MQRCCF_MR_COUNT_ERROR),
/* 4070*/ DEF_VALS1(MQRCCF_MR_COUNT_WRONG_TYPE),
/* 4071*/ DEF_VALS1(MQRCCF_MR_EXIT_NAME_ERROR),
/* 4072*/ DEF_VALS1(MQRCCF_MR_EXIT_NAME_WRONG_TYPE),
/* 4073*/ DEF_VALS1(MQRCCF_MR_INTERVAL_ERROR),
/* 4074*/ DEF_VALS1(MQRCCF_MR_INTERVAL_WRONG_TYPE),
/* 4075*/ DEF_VALS1(MQRCCF_NPM_SPEED_ERROR),
/* 4076*/ DEF_VALS1(MQRCCF_NPM_SPEED_WRONG_TYPE),
/* 4077*/ DEF_VALS1(MQRCCF_HB_INTERVAL_ERROR),
/* 4078*/ DEF_VALS1(MQRCCF_HB_INTERVAL_WRONG_TYPE),
/* 4079*/ DEF_VALS1(MQRCCF_CHAD_ERROR),
/* 4080*/ DEF_VALS1(MQRCCF_CHAD_WRONG_TYPE),
/* 4081*/ DEF_VALS1(MQRCCF_CHAD_EVENT_ERROR),
/* 4082*/ DEF_VALS1(MQRCCF_CHAD_EVENT_WRONG_TYPE),
/* 4083*/ DEF_VALS1(MQRCCF_CHAD_EXIT_ERROR),
/* 4084*/ DEF_VALS1(MQRCCF_CHAD_EXIT_WRONG_TYPE),
/* 4085*/ DEF_VALS1(MQRCCF_SUPPRESSED_BY_EXIT),
/* 4086*/ DEF_VALS1(MQRCCF_BATCH_INT_ERROR),
/* 4087*/ DEF_VALS1(MQRCCF_BATCH_INT_WRONG_TYPE),
/* 4088*/ DEF_VALS1(MQRCCF_NET_PRIORITY_ERROR),
/* 4089*/ DEF_VALS1(MQRCCF_NET_PRIORITY_WRONG_TYPE),
/* 4090*/ DEF_VALS1(MQRCCF_CHANNEL_CLOSED),
/* 4091*/ DEF_VALS1(MQRCCF_Q_STATUS_NOT_FOUND),
/* 4092*/ DEF_VALS1(MQRCCF_SSL_CIPHER_SPEC_ERROR),
/* 4093*/ DEF_VALS1(MQRCCF_SSL_PEER_NAME_ERROR),
/* 4094*/ DEF_VALS1(MQRCCF_SSL_CLIENT_AUTH_ERROR),
/* 4095*/ DEF_VALS1(MQRCCF_RETAINED_NOT_SUPPORTED),
/* 6000*/ DEF_VALS1(MQRC_LIBRARY_LOAD_ERROR),
/* 6001*/ DEF_VALS1(MQRC_CLASS_LIBRARY_ERROR),
/* 6002*/ DEF_VALS1(MQRC_STRING_LENGTH_TOO_BIG),
/* 6003*/ DEF_VALS1(MQRC_WRITE_VALUE_ERROR),
/* 6004*/ DEF_VALS1(MQRC_PACKED_DECIMAL_ERROR),
/* 6005*/ DEF_VALS1(MQRC_FLOAT_CONVERSION_ERROR),
/* 6100*/ DEF_VALS1(MQRC_REOPEN_EXCL_INPUT_ERROR),
/* 6101*/ DEF_VALS1(MQRC_REOPEN_INQUIRE_ERROR),
/* 6102*/ DEF_VALS1(MQRC_REOPEN_SAVED_CONTEXT_ERR),
/* 6103*/ DEF_VALS1(MQRC_REOPEN_TEMPORARY_Q_ERROR),
/* 6104*/ DEF_VALS1(MQRC_ATTRIBUTE_LOCKED),
/* 6105*/ DEF_VALS1(MQRC_CURSOR_NOT_VALID),
/* 6106*/ DEF_VALS1(MQRC_ENCODING_ERROR),
/* 6107*/ DEF_VALS1(MQRC_STRUC_ID_ERROR),
/* 6108*/ DEF_VALS1(MQRC_NULL_POINTER),
/* 6109*/ DEF_VALS1(MQRC_NO_CONNECTION_REFERENCE),
/* 6110*/ DEF_VALS1(MQRC_NO_BUFFER),
/* 6111*/ DEF_VALS1(MQRC_BINARY_DATA_LENGTH_ERROR),
/* 6112*/ DEF_VALS1(MQRC_BUFFER_NOT_AUTOMATIC),
/* 6113*/ DEF_VALS1(MQRC_INSUFFICIENT_BUFFER),
/* 6114*/ DEF_VALS1(MQRC_INSUFFICIENT_DATA),
/* 6115*/ DEF_VALS1(MQRC_DATA_TRUNCATED),
/* 6116*/ DEF_VALS1(MQRC_ZERO_LENGTH),
/* 6117*/ DEF_VALS1(MQRC_NEGATIVE_LENGTH),
/* 6118*/ DEF_VALS1(MQRC_NEGATIVE_OFFSET),
/* 6119*/ DEF_VALS1(MQRC_INCONSISTENT_FORMAT),
/* 6120*/ DEF_VALS1(MQRC_INCONSISTENT_OBJECT_STATE),
/* 6121*/ DEF_VALS1(MQRC_CONTEXT_OBJECT_NOT_VALID),
/* 6122*/ DEF_VALS1(MQRC_CONTEXT_OPEN_ERROR),
/* 6123*/ DEF_VALS1(MQRC_STRUC_LENGTH_ERROR),
/* 6124*/ DEF_VALS1(MQRC_NOT_CONNECTED),
/* 6125*/ DEF_VALS1(MQRC_NOT_OPEN),
/* 6126*/ DEF_VALS1(MQRC_DISTRIBUTION_LIST_EMPTY),
/* 6127*/ DEF_VALS1(MQRC_INCONSISTENT_OPEN_OPTIONS),
/* 6128*/ DEF_VALS1(MQRC_WRONG_VERSION),
/* 6129*/ DEF_VALS1(MQRC_REFERENCE_ERROR),
/* 6130*/ DEF_VALS1(MQRC_XR_NOT_AVAILABLE),
/*29440*/ DEF_VALS1(MQRC_SUB_JOIN_NOT_ALTERABLE),
DEF_VALSE;
DEF_VALS_EXTBX(MQRC);

DEF_VALSB(objtype)
/*    0*/ DEF_VALS1(MQOT_NONE),
/*    1*/ DEF_VALS1(MQOT_Q),
/*    2*/ DEF_VALS1(MQOT_NAMELIST),
/*    3*/ DEF_VALS1(MQOT_PROCESS),
/*    4*/ DEF_VALS1(MQOT_STORAGE_CLASS),
/*    5*/ DEF_VALS1(MQOT_Q_MGR),
/*    6*/ DEF_VALS1(MQOT_CHANNEL),
/*    7*/ DEF_VALS1(MQOT_AUTH_INFO),
/*    8*/ DEF_VALS1(MQOT_TOPIC),
/*    9*/ DEF_VALS1(MQOT_COMM_INFO),
/*   10*/ DEF_VALS1(MQOT_CF_STRUC),
/*   11*/ DEF_VALS1(MQOT_LISTENER),
/*   12*/ DEF_VALS1(MQOT_SERVICE),
/*  999*/ DEF_VALS1(MQOT_RESERVED_1),
/* 1001*/ DEF_VALS1(MQOT_ALL),
/* 1002*/ DEF_VALS1(MQOT_ALIAS_Q),
/* 1003*/ DEF_VALS1(MQOT_MODEL_Q),
/* 1004*/ DEF_VALS1(MQOT_LOCAL_Q),
/* 1005*/ DEF_VALS1(MQOT_REMOTE_Q),
/* 1007*/ DEF_VALS1(MQOT_SENDER_CHANNEL),
/* 1008*/ DEF_VALS1(MQOT_SERVER_CHANNEL),
/* 1009*/ DEF_VALS1(MQOT_REQUESTER_CHANNEL),
/* 1010*/ DEF_VALS1(MQOT_RECEIVER_CHANNEL),
/* 1011*/ DEF_VALS1(MQOT_CURRENT_CHANNEL),
/* 1012*/ DEF_VALS1(MQOT_SAVED_CHANNEL),
/* 1013*/ DEF_VALS1(MQOT_SVRCONN_CHANNEL),
/* 1014*/ DEF_VALS1(MQOT_CLNTCONN_CHANNEL),
/* 1015*/ DEF_VALS1(MQOT_SHORT_CHANNEL),
/* 1016*/ DEF_VALS1(MQOT_CHLAUTH),
/* 1017*/ DEF_VALS1(MQOT_REMOTE_Q_MGR_NAME),
/* 1019*/ DEF_VALS1(MQOT_PROT_POLICY),
/* 1020*/ DEF_VALS1(MQOT_TT_CHANNEL),
/* 1021*/ DEF_VALS1(MQOT_AMQP_CHANNEL),
/* 1022*/ DEF_VALS1(MQOT_AUTH_REC),
DEF_VALSE;
DEF_VALS_EXTBX(objtype);

DEF_VALSB(PrmId)
/*    1*/ DEF_VALS1(MQIA_APPL_TYPE),
/*    2*/ DEF_VALS1(MQIA_CODED_CHAR_SET_ID),
/*    3*/ DEF_VALS1(MQIA_CURRENT_Q_DEPTH),
/*    4*/ DEF_VALS1(MQIA_DEF_INPUT_OPEN_OPTION),
/*    5*/ DEF_VALS1(MQIA_DEF_PERSISTENCE),
/*    6*/ DEF_VALS1(MQIA_DEF_PRIORITY),
/*    7*/ DEF_VALS1(MQIA_DEFINITION_TYPE),
/*    8*/ DEF_VALS1(MQIA_HARDEN_GET_BACKOUT),
/*    9*/ DEF_VALS1(MQIA_INHIBIT_GET),
/*   10*/ DEF_VALS1(MQIA_INHIBIT_PUT),
/*   11*/ DEF_VALS1(MQIA_MAX_HANDLES),
/*   12*/ DEF_VALS1(MQIA_USAGE),
/*   13*/ DEF_VALS1(MQIA_MAX_MSG_LENGTH),
/*   14*/ DEF_VALS1(MQIA_MAX_PRIORITY),
/*   15*/ DEF_VALS1(MQIA_MAX_Q_DEPTH),
/*   16*/ DEF_VALS1(MQIA_MSG_DELIVERY_SEQUENCE),
/*   17*/ DEF_VALS1(MQIA_OPEN_INPUT_COUNT),
/*   18*/ DEF_VALS1(MQIA_OPEN_OUTPUT_COUNT),
/*   19*/ DEF_VALS1(MQIA_NAME_COUNT),
/*   20*/ DEF_VALS1(MQIA_Q_TYPE),
/*   21*/ DEF_VALS1(MQIA_RETENTION_INTERVAL),
/*   22*/ DEF_VALS1(MQIA_BACKOUT_THRESHOLD),
/*   23*/ DEF_VALS1(MQIA_SHAREABILITY),
/*   24*/ DEF_VALS1(MQIA_TRIGGER_CONTROL),
/*   25*/ DEF_VALS1(MQIA_TRIGGER_INTERVAL),
/*   26*/ DEF_VALS1(MQIA_TRIGGER_MSG_PRIORITY),
/*   27*/ DEF_VALS1(MQIA_CPI_LEVEL),
/*   28*/ DEF_VALS1(MQIA_TRIGGER_TYPE),
/*   29*/ DEF_VALS1(MQIA_TRIGGER_DEPTH),
/*   30*/ DEF_VALS1(MQIA_SYNCPOINT),
/*   31*/ DEF_VALS1(MQIA_COMMAND_LEVEL),
/*   32*/ DEF_VALS1(MQIA_PLATFORM),
/*   33*/ DEF_VALS1(MQIA_MAX_UNCOMMITTED_MSGS),
/*   34*/ DEF_VALS1(MQIA_DIST_LISTS),
/*   35*/ DEF_VALS1(MQIA_TIME_SINCE_RESET),
/*   36*/ DEF_VALS1(MQIA_HIGH_Q_DEPTH),
/*   37*/ DEF_VALS1(MQIA_MSG_ENQ_COUNT),
/*   38*/ DEF_VALS1(MQIA_MSG_DEQ_COUNT),
/*   39*/ DEF_VALS1(MQIA_EXPIRY_INTERVAL),
/*   40*/ DEF_VALS1(MQIA_Q_DEPTH_HIGH_LIMIT),
/*   41*/ DEF_VALS1(MQIA_Q_DEPTH_LOW_LIMIT),
/*   42*/ DEF_VALS1(MQIA_Q_DEPTH_MAX_EVENT),
/*   43*/ DEF_VALS1(MQIA_Q_DEPTH_HIGH_EVENT),
/*   44*/ DEF_VALS1(MQIA_Q_DEPTH_LOW_EVENT),
/*   45*/ DEF_VALS1(MQIA_SCOPE),
/*   46*/ DEF_VALS1(MQIA_Q_SERVICE_INTERVAL_EVENT),
/*   47*/ DEF_VALS1(MQIA_AUTHORITY_EVENT),
/*   48*/ DEF_VALS1(MQIA_INHIBIT_EVENT),
/*   49*/ DEF_VALS1(MQIA_LOCAL_EVENT),
/*   50*/ DEF_VALS1(MQIA_REMOTE_EVENT),
/*   51*/ DEF_VALS1(MQIA_CONFIGURATION_EVENT),
/*   52*/ DEF_VALS1(MQIA_START_STOP_EVENT),
/*   53*/ DEF_VALS1(MQIA_PERFORMANCE_EVENT),
/*   54*/ DEF_VALS1(MQIA_Q_SERVICE_INTERVAL),
/*   55*/ DEF_VALS1(MQIA_CHANNEL_AUTO_DEF),
/*   56*/ DEF_VALS1(MQIA_CHANNEL_AUTO_DEF_EVENT),
/*   57*/ DEF_VALS1(MQIA_INDEX_TYPE),
/*   58*/ DEF_VALS1(MQIA_CLUSTER_WORKLOAD_LENGTH),
/*   59*/ DEF_VALS1(MQIA_CLUSTER_Q_TYPE),
/*   60*/ DEF_VALS1(MQIA_ARCHIVE),
/*   61*/ DEF_VALS1(MQIA_DEF_BIND),
/*   62*/ DEF_VALS1(MQIA_PAGESET_ID),
/*   63*/ DEF_VALS1(MQIA_QSG_DISP),
/*   64*/ DEF_VALS1(MQIA_INTRA_GROUP_QUEUING),
/*   65*/ DEF_VALS1(MQIA_IGQ_PUT_AUTHORITY),
/*   66*/ DEF_VALS1(MQIA_AUTH_INFO_TYPE),
/*   68*/ DEF_VALS1(MQIA_MSG_MARK_BROWSE_INTERVAL),
/*   69*/ DEF_VALS1(MQIA_SSL_TASKS),
/*   70*/ DEF_VALS1(MQIA_CF_LEVEL),
/*   71*/ DEF_VALS1(MQIA_CF_RECOVER),
/*   72*/ DEF_VALS1(MQIA_NAMELIST_TYPE),
/*   73*/ DEF_VALS1(MQIA_CHANNEL_EVENT),
/*   74*/ DEF_VALS1(MQIA_BRIDGE_EVENT),
/*   75*/ DEF_VALS1(MQIA_SSL_EVENT),
/*   76*/ DEF_VALS1(MQIA_SSL_RESET_COUNT),
/*   77*/ DEF_VALS1(MQIA_SHARED_Q_Q_MGR_NAME),
/*   78*/ DEF_VALS1(MQIA_NPM_CLASS),
/*   80*/ DEF_VALS1(MQIA_MAX_OPEN_Q),
/*   81*/ DEF_VALS1(MQIA_MONITOR_INTERVAL),
/*   82*/ DEF_VALS1(MQIA_Q_USERS),
/*   83*/ DEF_VALS1(MQIA_MAX_GLOBAL_LOCKS),
/*   84*/ DEF_VALS1(MQIA_MAX_LOCAL_LOCKS),
/*   85*/ DEF_VALS1(MQIA_LISTENER_PORT_NUMBER),
/*   86*/ DEF_VALS1(MQIA_BATCH_INTERFACE_AUTO),
/*   87*/ DEF_VALS1(MQIA_CMD_SERVER_AUTO),
/*   88*/ DEF_VALS1(MQIA_CMD_SERVER_CONVERT_MSG),
/*   89*/ DEF_VALS1(MQIA_CMD_SERVER_DLQ_MSG),
/*   90*/ DEF_VALS1(MQIA_MAX_Q_TRIGGERS),
/*   91*/ DEF_VALS1(MQIA_TRIGGER_RESTART),
/*   92*/ DEF_VALS1(MQIA_SSL_FIPS_REQUIRED),
/*   93*/ DEF_VALS1(MQIA_IP_ADDRESS_VERSION),
/*   94*/ DEF_VALS1(MQIA_LOGGER_EVENT),
/*   95*/ DEF_VALS1(MQIA_CLWL_Q_RANK),
/*   96*/ DEF_VALS1(MQIA_CLWL_Q_PRIORITY),
/*   97*/ DEF_VALS1(MQIA_CLWL_MRU_CHANNELS),
/*   98*/ DEF_VALS1(MQIA_CLWL_USEQ),
/*   99*/ DEF_VALS1(MQIA_COMMAND_EVENT),
/*  100*/ DEF_VALS1(MQIA_ACTIVE_CHANNELS),
/*  101*/ DEF_VALS1(MQIA_CHINIT_ADAPTERS),
/*  102*/ DEF_VALS1(MQIA_ADOPTNEWMCA_CHECK),
/*  103*/ DEF_VALS1(MQIA_ADOPTNEWMCA_TYPE),
/*  104*/ DEF_VALS1(MQIA_ADOPTNEWMCA_INTERVAL),
/*  105*/ DEF_VALS1(MQIA_CHINIT_DISPATCHERS),
/*  106*/ DEF_VALS1(MQIA_DNS_WLM),
/*  107*/ DEF_VALS1(MQIA_LISTENER_TIMER),
/*  108*/ DEF_VALS1(MQIA_LU62_CHANNELS),
/*  109*/ DEF_VALS1(MQIA_MAX_CHANNELS),
/*  110*/ DEF_VALS1(MQIA_OUTBOUND_PORT_MIN),
/*  111*/ DEF_VALS1(MQIA_RECEIVE_TIMEOUT),
/*  112*/ DEF_VALS1(MQIA_RECEIVE_TIMEOUT_TYPE),
/*  113*/ DEF_VALS1(MQIA_RECEIVE_TIMEOUT_MIN),
/*  114*/ DEF_VALS1(MQIA_TCP_CHANNELS),
/*  115*/ DEF_VALS1(MQIA_TCP_KEEP_ALIVE),
/*  116*/ DEF_VALS1(MQIA_TCP_STACK_TYPE),
/*  117*/ DEF_VALS1(MQIA_CHINIT_TRACE_AUTO_START),
/*  118*/ DEF_VALS1(MQIA_CHINIT_TRACE_TABLE_SIZE),
/*  119*/ DEF_VALS1(MQIA_CHINIT_CONTROL),
/*  120*/ DEF_VALS1(MQIA_CMD_SERVER_CONTROL),
/*  121*/ DEF_VALS1(MQIA_SERVICE_TYPE),
/*  122*/ DEF_VALS1(MQIA_MONITORING_CHANNEL),
/*  123*/ DEF_VALS1(MQIA_MONITORING_Q),
/*  124*/ DEF_VALS1(MQIA_MONITORING_AUTO_CLUSSDR),
/*  127*/ DEF_VALS1(MQIA_STATISTICS_MQI),
/*  128*/ DEF_VALS1(MQIA_STATISTICS_Q),
/*  129*/ DEF_VALS1(MQIA_STATISTICS_CHANNEL),
/*  130*/ DEF_VALS1(MQIA_STATISTICS_AUTO_CLUSSDR),
/*  131*/ DEF_VALS1(MQIA_STATISTICS_INTERVAL),
/*  133*/ DEF_VALS1(MQIA_ACCOUNTING_MQI),
/*  134*/ DEF_VALS1(MQIA_ACCOUNTING_Q),
/*  135*/ DEF_VALS1(MQIA_ACCOUNTING_INTERVAL),
/*  136*/ DEF_VALS1(MQIA_ACCOUNTING_CONN_OVERRIDE),
/*  137*/ DEF_VALS1(MQIA_TRACE_ROUTE_RECORDING),
/*  138*/ DEF_VALS1(MQIA_ACTIVITY_RECORDING),
/*  139*/ DEF_VALS1(MQIA_SERVICE_CONTROL),
/*  140*/ DEF_VALS1(MQIA_OUTBOUND_PORT_MAX),
/*  141*/ DEF_VALS1(MQIA_SECURITY_CASE),
/*  150*/ DEF_VALS1(MQIA_QMOPT_CSMT_ON_ERROR),
/*  151*/ DEF_VALS1(MQIA_QMOPT_CONS_INFO_MSGS),
/*  152*/ DEF_VALS1(MQIA_QMOPT_CONS_WARNING_MSGS),
/*  153*/ DEF_VALS1(MQIA_QMOPT_CONS_ERROR_MSGS),
/*  154*/ DEF_VALS1(MQIA_QMOPT_CONS_CRITICAL_MSGS),
/*  155*/ DEF_VALS1(MQIA_QMOPT_CONS_COMMS_MSGS),
/*  156*/ DEF_VALS1(MQIA_QMOPT_CONS_REORG_MSGS),
/*  157*/ DEF_VALS1(MQIA_QMOPT_CONS_SYSTEM_MSGS),
/*  158*/ DEF_VALS1(MQIA_QMOPT_LOG_INFO_MSGS),
/*  159*/ DEF_VALS1(MQIA_QMOPT_LOG_WARNING_MSGS),
/*  160*/ DEF_VALS1(MQIA_QMOPT_LOG_ERROR_MSGS),
/*  161*/ DEF_VALS1(MQIA_QMOPT_LOG_CRITICAL_MSGS),
/*  162*/ DEF_VALS1(MQIA_QMOPT_LOG_COMMS_MSGS),
/*  163*/ DEF_VALS1(MQIA_QMOPT_LOG_REORG_MSGS),
/*  164*/ DEF_VALS1(MQIA_QMOPT_LOG_SYSTEM_MSGS),
/*  165*/ DEF_VALS1(MQIA_QMOPT_TRACE_MQI_CALLS),
/*  166*/ DEF_VALS1(MQIA_QMOPT_TRACE_COMMS),
/*  167*/ DEF_VALS1(MQIA_QMOPT_TRACE_REORG),
/*  168*/ DEF_VALS1(MQIA_QMOPT_TRACE_CONVERSION),
/*  169*/ DEF_VALS1(MQIA_QMOPT_TRACE_SYSTEM),
/*  170*/ DEF_VALS1(MQIA_QMOPT_INTERNAL_DUMP),
/*  171*/ DEF_VALS1(MQIA_MAX_RECOVERY_TASKS),
/*  172*/ DEF_VALS1(MQIA_MAX_CLIENTS),
/*  173*/ DEF_VALS1(MQIA_AUTO_REORGANIZATION),
/*  174*/ DEF_VALS1(MQIA_AUTO_REORG_INTERVAL),
/*  175*/ DEF_VALS1(MQIA_DURABLE_SUB),
/*  176*/ DEF_VALS1(MQIA_MULTICAST),
/*  181*/ DEF_VALS1(MQIA_INHIBIT_PUB),
/*  182*/ DEF_VALS1(MQIA_INHIBIT_SUB),
/*  183*/ DEF_VALS1(MQIA_TREE_LIFE_TIME),
/*  184*/ DEF_VALS1(MQIA_DEF_PUT_RESPONSE_TYPE),
/*  185*/ DEF_VALS1(MQIA_TOPIC_DEF_PERSISTENCE),
/*  186*/ DEF_VALS1(MQIA_MASTER_ADMIN),
/*  187*/ DEF_VALS1(MQIA_PUBSUB_MODE),
/*  188*/ DEF_VALS1(MQIA_DEF_READ_AHEAD),
/*  189*/ DEF_VALS1(MQIA_READ_AHEAD),
/*  190*/ DEF_VALS1(MQIA_PROPERTY_CONTROL),
/*  192*/ DEF_VALS1(MQIA_MAX_PROPERTIES_LENGTH),
/*  193*/ DEF_VALS1(MQIA_BASE_TYPE),
/*  195*/ DEF_VALS1(MQIA_PM_DELIVERY),
/*  196*/ DEF_VALS1(MQIA_NPM_DELIVERY),
/*  199*/ DEF_VALS1(MQIA_PROXY_SUB),
/*  203*/ DEF_VALS1(MQIA_PUBSUB_NP_MSG),
/*  204*/ DEF_VALS1(MQIA_SUB_COUNT),
/*  205*/ DEF_VALS1(MQIA_PUBSUB_NP_RESP),
/*  206*/ DEF_VALS1(MQIA_PUBSUB_MAXMSG_RETRY_COUNT),
/*  207*/ DEF_VALS1(MQIA_PUBSUB_SYNC_PT),
/*  208*/ DEF_VALS1(MQIA_TOPIC_TYPE),
/*  215*/ DEF_VALS1(MQIA_PUB_COUNT),
/*  216*/ DEF_VALS1(MQIA_WILDCARD_OPERATION),
/*  218*/ DEF_VALS1(MQIA_SUB_SCOPE),
/*  219*/ DEF_VALS1(MQIA_PUB_SCOPE),
/*  221*/ DEF_VALS1(MQIA_GROUP_UR),
/*  222*/ DEF_VALS1(MQIA_UR_DISP),
/*  223*/ DEF_VALS1(MQIA_COMM_INFO_TYPE),
/*  224*/ DEF_VALS1(MQIA_CF_OFFLOAD),
/*  225*/ DEF_VALS1(MQIA_CF_OFFLOAD_THRESHOLD1),
/*  226*/ DEF_VALS1(MQIA_CF_OFFLOAD_THRESHOLD2),
/*  227*/ DEF_VALS1(MQIA_CF_OFFLOAD_THRESHOLD3),
/*  228*/ DEF_VALS1(MQIA_CF_SMDS_BUFFERS),
/*  229*/ DEF_VALS1(MQIA_CF_OFFLDUSE),
/*  230*/ DEF_VALS1(MQIA_MAX_RESPONSES),
/*  231*/ DEF_VALS1(MQIA_RESPONSE_RESTART_POINT),
/*  232*/ DEF_VALS1(MQIA_COMM_EVENT),
/*  233*/ DEF_VALS1(MQIA_MCAST_BRIDGE),
/*  234*/ DEF_VALS1(MQIA_USE_DEAD_LETTER_Q),
/*  235*/ DEF_VALS1(MQIA_TOLERATE_UNPROTECTED),
/*  236*/ DEF_VALS1(MQIA_SIGNATURE_ALGORITHM),
/*  237*/ DEF_VALS1(MQIA_ENCRYPTION_ALGORITHM),
/*  238*/ DEF_VALS1(MQIA_POLICY_VERSION),
/*  239*/ DEF_VALS1(MQIA_ACTIVITY_CONN_OVERRIDE),
/*  240*/ DEF_VALS1(MQIA_ACTIVITY_TRACE),
/*  242*/ DEF_VALS1(MQIA_SUB_CONFIGURATION_EVENT),
/*  243*/ DEF_VALS1(MQIA_XR_CAPABILITY),
/*  244*/ DEF_VALS1(MQIA_CF_RECAUTO),
/*  245*/ DEF_VALS1(MQIA_QMGR_CFCONLOS),
/*  246*/ DEF_VALS1(MQIA_CF_CFCONLOS),
/*  247*/ DEF_VALS1(MQIA_SUITE_B_STRENGTH),
/*  248*/ DEF_VALS1(MQIA_CHLAUTH_RECORDS),
/*  249*/ DEF_VALS1(MQIA_PUBSUB_CLUSTER),
/*  250*/ DEF_VALS1(MQIA_DEF_CLUSTER_XMIT_Q_TYPE),
/*  251*/ DEF_VALS1(MQIA_PROT_POLICY_CAPABILITY),
/*  252*/ DEF_VALS1(MQIA_CERT_VAL_POLICY),
/*  253*/ DEF_VALS1(MQIA_TOPIC_NODE_COUNT),
/*  254*/ DEF_VALS1(MQIA_REVERSE_DNS_LOOKUP),
/*  255*/ DEF_VALS1(MQIA_CLUSTER_PUB_ROUTE),
/*  256*/ DEF_VALS1(MQIA_CLUSTER_OBJECT_STATE),
/*  257*/ DEF_VALS1(MQIA_CHECK_LOCAL_BINDING),
/*  258*/ DEF_VALS1(MQIA_CHECK_CLIENT_BINDING),
/*  259*/ DEF_VALS1(MQIA_AUTHENTICATION_FAIL_DELAY),
/*  260*/ DEF_VALS1(MQIA_ADOPT_CONTEXT),
/*  261*/ DEF_VALS1(MQIA_LDAP_SECURE_COMM),
/*  262*/ DEF_VALS1(MQIA_DISPLAY_TYPE),
/*  263*/ DEF_VALS1(MQIA_LDAP_AUTHORMD),
/*  264*/ DEF_VALS1(MQIA_LDAP_NESTGRP),
/*  265*/ DEF_VALS1(MQIA_AMQP_CAPABILITY),
/*  266*/ DEF_VALS1(MQIA_AUTHENTICATION_METHOD),
/*  267*/ DEF_VALS1(MQIA_KEY_REUSE_COUNT),
/*  268*/ DEF_VALS1(MQIA_MEDIA_IMAGE_SCHEDULING),
/*  269*/ DEF_VALS1(MQIA_MEDIA_IMAGE_INTERVAL),
/*  270*/ DEF_VALS1(MQIA_MEDIA_IMAGE_LOG_LENGTH),
/*  271*/ DEF_VALS1(MQIA_MEDIA_IMAGE_RECOVER_OBJ),
/*  272*/ DEF_VALS1(MQIA_MEDIA_IMAGE_RECOVER_Q),
/*  273*/ DEF_VALS1(MQIA_ADVANCED_CAPABILITY),
/*  702*/ DEF_VALS1(MQIAMO_AVG_BATCH_SIZE),
/*  703*/ DEF_VALS1(MQIAMO_AVG_Q_TIME),
/*  703   DEF_VALS1(MQIAMO64_AVG_Q_TIME), */
/*  704*/ DEF_VALS1(MQIAMO_BACKOUTS),
/*  705*/ DEF_VALS1(MQIAMO_BROWSES),
/*  706*/ DEF_VALS1(MQIAMO_BROWSE_MAX_BYTES),
/*  707*/ DEF_VALS1(MQIAMO_BROWSE_MIN_BYTES),
/*  708*/ DEF_VALS1(MQIAMO_BROWSES_FAILED),
/*  709*/ DEF_VALS1(MQIAMO_CLOSES),
/*  710*/ DEF_VALS1(MQIAMO_COMMITS),
/*  711*/ DEF_VALS1(MQIAMO_COMMITS_FAILED),
/*  712*/ DEF_VALS1(MQIAMO_CONNS),
/*  713*/ DEF_VALS1(MQIAMO_CONNS_MAX),
/*  714*/ DEF_VALS1(MQIAMO_DISCS),
/*  715*/ DEF_VALS1(MQIAMO_DISCS_IMPLICIT),
/*  716*/ DEF_VALS1(MQIAMO_DISC_TYPE),
/*  717*/ DEF_VALS1(MQIAMO_EXIT_TIME_AVG),
/*  718*/ DEF_VALS1(MQIAMO_EXIT_TIME_MAX),
/*  719*/ DEF_VALS1(MQIAMO_EXIT_TIME_MIN),
/*  720*/ DEF_VALS1(MQIAMO_FULL_BATCHES),
/*  721*/ DEF_VALS1(MQIAMO_GENERATED_MSGS),
/*  722*/ DEF_VALS1(MQIAMO_GETS),
/*  723*/ DEF_VALS1(MQIAMO_GET_MAX_BYTES),
/*  724*/ DEF_VALS1(MQIAMO_GET_MIN_BYTES),
/*  725*/ DEF_VALS1(MQIAMO_GETS_FAILED),
/*  726*/ DEF_VALS1(MQIAMO_INCOMPLETE_BATCHES),
/*  727*/ DEF_VALS1(MQIAMO_INQS),
/*  728*/ DEF_VALS1(MQIAMO_MSGS),
/*  729*/ DEF_VALS1(MQIAMO_NET_TIME_AVG),
/*  730*/ DEF_VALS1(MQIAMO_NET_TIME_MAX),
/*  731*/ DEF_VALS1(MQIAMO_NET_TIME_MIN),
/*  732*/ DEF_VALS1(MQIAMO_OBJECT_COUNT),
/*  733*/ DEF_VALS1(MQIAMO_OPENS),
/*  734*/ DEF_VALS1(MQIAMO_PUT1S),
/*  735*/ DEF_VALS1(MQIAMO_PUTS),
/*  736*/ DEF_VALS1(MQIAMO_PUT_MAX_BYTES),
/*  737*/ DEF_VALS1(MQIAMO_PUT_MIN_BYTES),
/*  738*/ DEF_VALS1(MQIAMO_PUT_RETRIES),
/*  739*/ DEF_VALS1(MQIAMO_Q_MAX_DEPTH),
/*  740*/ DEF_VALS1(MQIAMO_Q_MIN_DEPTH),
/*  741*/ DEF_VALS1(MQIAMO_Q_TIME_AVG),
/*  741   DEF_VALS1(MQIAMO64_Q_TIME_AVG), */
/*  742*/ DEF_VALS1(MQIAMO_Q_TIME_MAX),
/*  742   DEF_VALS1(MQIAMO64_Q_TIME_MAX), */
/*  743*/ DEF_VALS1(MQIAMO_Q_TIME_MIN),
/*  743   DEF_VALS1(MQIAMO64_Q_TIME_MIN), */
/*  744*/ DEF_VALS1(MQIAMO_SETS),
/*  745*/ DEF_VALS1(MQIAMO64_BROWSE_BYTES),
/*  746*/ DEF_VALS1(MQIAMO64_BYTES),
/*  747*/ DEF_VALS1(MQIAMO64_GET_BYTES),
/*  748*/ DEF_VALS1(MQIAMO64_PUT_BYTES),
/*  749*/ DEF_VALS1(MQIAMO_CONNS_FAILED),
/*  751*/ DEF_VALS1(MQIAMO_OPENS_FAILED),
/*  752*/ DEF_VALS1(MQIAMO_INQS_FAILED),
/*  753*/ DEF_VALS1(MQIAMO_SETS_FAILED),
/*  754*/ DEF_VALS1(MQIAMO_PUTS_FAILED),
/*  755*/ DEF_VALS1(MQIAMO_PUT1S_FAILED),
/*  757*/ DEF_VALS1(MQIAMO_CLOSES_FAILED),
/*  758*/ DEF_VALS1(MQIAMO_MSGS_EXPIRED),
/*  759*/ DEF_VALS1(MQIAMO_MSGS_NOT_QUEUED),
/*  760*/ DEF_VALS1(MQIAMO_MSGS_PURGED),
/*  764*/ DEF_VALS1(MQIAMO_SUBS_DUR),
/*  765*/ DEF_VALS1(MQIAMO_SUBS_NDUR),
/*  766*/ DEF_VALS1(MQIAMO_SUBS_FAILED),
/*  767*/ DEF_VALS1(MQIAMO_SUBRQS),
/*  768*/ DEF_VALS1(MQIAMO_SUBRQS_FAILED),
/*  769*/ DEF_VALS1(MQIAMO_CBS),
/*  770*/ DEF_VALS1(MQIAMO_CBS_FAILED),
/*  771*/ DEF_VALS1(MQIAMO_CTLS),
/*  772*/ DEF_VALS1(MQIAMO_CTLS_FAILED),
/*  773*/ DEF_VALS1(MQIAMO_STATS),
/*  774*/ DEF_VALS1(MQIAMO_STATS_FAILED),
/*  775*/ DEF_VALS1(MQIAMO_SUB_DUR_HIGHWATER),
/*  776*/ DEF_VALS1(MQIAMO_SUB_DUR_LOWWATER),
/*  777*/ DEF_VALS1(MQIAMO_SUB_NDUR_HIGHWATER),
/*  778*/ DEF_VALS1(MQIAMO_SUB_NDUR_LOWWATER),
/*  779*/ DEF_VALS1(MQIAMO_TOPIC_PUTS),
/*  780*/ DEF_VALS1(MQIAMO_TOPIC_PUTS_FAILED),
/*  781*/ DEF_VALS1(MQIAMO_TOPIC_PUT1S),
/*  782*/ DEF_VALS1(MQIAMO_TOPIC_PUT1S_FAILED),
/*  783*/ DEF_VALS1(MQIAMO64_TOPIC_PUT_BYTES),
/*  784*/ DEF_VALS1(MQIAMO_PUBLISH_MSG_COUNT),
/*  785*/ DEF_VALS1(MQIAMO64_PUBLISH_MSG_BYTES),
/*  786*/ DEF_VALS1(MQIAMO_UNSUBS_DUR),
/*  787*/ DEF_VALS1(MQIAMO_UNSUBS_NDUR),
/*  788*/ DEF_VALS1(MQIAMO_UNSUBS_FAILED),
/*  789*/ DEF_VALS1(MQIAMO_INTERVAL),
/*  790*/ DEF_VALS1(MQIAMO_MSGS_SENT),
/*  791*/ DEF_VALS1(MQIAMO_BYTES_SENT),
/*  792*/ DEF_VALS1(MQIAMO_REPAIR_BYTES),
/*  793*/ DEF_VALS1(MQIAMO_FEEDBACK_MODE),
/*  794*/ DEF_VALS1(MQIAMO_RELIABILITY_TYPE),
/*  795*/ DEF_VALS1(MQIAMO_LATE_JOIN_MARK),
/*  796*/ DEF_VALS1(MQIAMO_NACKS_RCVD),
/*  797*/ DEF_VALS1(MQIAMO_REPAIR_PKTS),
/*  798*/ DEF_VALS1(MQIAMO_HISTORY_PKTS),
/*  799*/ DEF_VALS1(MQIAMO_PENDING_PKTS),
/*  800*/ DEF_VALS1(MQIAMO_PKT_RATE),
/*  801*/ DEF_VALS1(MQIAMO_MCAST_XMIT_RATE),
/*  802*/ DEF_VALS1(MQIAMO_MCAST_BATCH_TIME),
/*  803*/ DEF_VALS1(MQIAMO_MCAST_HEARTBEAT),
/*  804*/ DEF_VALS1(MQIAMO_DEST_DATA_PORT),
/*  805*/ DEF_VALS1(MQIAMO_DEST_REPAIR_PORT),
/*  806*/ DEF_VALS1(MQIAMO_ACKS_RCVD),
/*  807*/ DEF_VALS1(MQIAMO_ACTIVE_ACKERS),
/*  808*/ DEF_VALS1(MQIAMO_PKTS_SENT),
/*  809*/ DEF_VALS1(MQIAMO_TOTAL_REPAIR_PKTS),
/*  810*/ DEF_VALS1(MQIAMO_TOTAL_PKTS_SENT),
/*  811*/ DEF_VALS1(MQIAMO_TOTAL_MSGS_SENT),
/*  812*/ DEF_VALS1(MQIAMO_TOTAL_BYTES_SENT),
/*  813*/ DEF_VALS1(MQIAMO_NUM_STREAMS),
/*  814*/ DEF_VALS1(MQIAMO_ACK_FEEDBACK),
/*  815*/ DEF_VALS1(MQIAMO_NACK_FEEDBACK),
/*  816*/ DEF_VALS1(MQIAMO_PKTS_LOST),
/*  817*/ DEF_VALS1(MQIAMO_MSGS_RCVD),
/*  818*/ DEF_VALS1(MQIAMO_MSG_BYTES_RCVD),
/*  819*/ DEF_VALS1(MQIAMO_MSGS_DELIVERED),
/*  820*/ DEF_VALS1(MQIAMO_PKTS_PROCESSED),
/*  821*/ DEF_VALS1(MQIAMO_PKTS_DELIVERED),
/*  822*/ DEF_VALS1(MQIAMO_PKTS_DROPPED),
/*  823*/ DEF_VALS1(MQIAMO_PKTS_DUPLICATED),
/*  824*/ DEF_VALS1(MQIAMO_NACKS_CREATED),
/*  825*/ DEF_VALS1(MQIAMO_NACK_PKTS_SENT),
/*  826*/ DEF_VALS1(MQIAMO_REPAIR_PKTS_RQSTD),
/*  827*/ DEF_VALS1(MQIAMO_REPAIR_PKTS_RCVD),
/*  828*/ DEF_VALS1(MQIAMO_PKTS_REPAIRED),
/*  829*/ DEF_VALS1(MQIAMO_TOTAL_MSGS_RCVD),
/*  830*/ DEF_VALS1(MQIAMO_TOTAL_MSG_BYTES_RCVD),
/*  831*/ DEF_VALS1(MQIAMO_TOTAL_REPAIR_PKTS_RCVD),
/*  832*/ DEF_VALS1(MQIAMO_TOTAL_REPAIR_PKTS_RQSTD),
/*  833*/ DEF_VALS1(MQIAMO_TOTAL_MSGS_PROCESSED),
/*  834*/ DEF_VALS1(MQIAMO_TOTAL_MSGS_SELECTED),
/*  835*/ DEF_VALS1(MQIAMO_TOTAL_MSGS_EXPIRED),
/*  836*/ DEF_VALS1(MQIAMO_TOTAL_MSGS_DELIVERED),
/*  837*/ DEF_VALS1(MQIAMO_TOTAL_MSGS_RETURNED),
/*  838*/ DEF_VALS1(MQIAMO64_HIGHRES_TIME),
/*  839*/ DEF_VALS1(MQIAMO_MONITOR_CLASS),
/*  840*/ DEF_VALS1(MQIAMO_MONITOR_TYPE),
/*  841*/ DEF_VALS1(MQIAMO_MONITOR_ELEMENT),
/*  842*/ DEF_VALS1(MQIAMO_MONITOR_DATATYPE),
/*  843*/ DEF_VALS1(MQIAMO_MONITOR_FLAGS),
/*  844*/ DEF_VALS1(MQIAMO64_QMGR_OP_DURATION),
/*  845*/ DEF_VALS1(MQIAMO64_MONITOR_INTERVAL),
/* 1001*/ DEF_VALS1(MQIACF_Q_MGR_ATTRS),
/* 1002*/ DEF_VALS1(MQIACF_Q_ATTRS),
/* 1003*/ DEF_VALS1(MQIACF_PROCESS_ATTRS),
/* 1004*/ DEF_VALS1(MQIACF_NAMELIST_ATTRS),
/* 1005*/ DEF_VALS1(MQIACF_FORCE),
/* 1006*/ DEF_VALS1(MQIACF_REPLACE),
/* 1007*/ DEF_VALS1(MQIACF_PURGE),
/* 1008 DEF_VALS1(MQIACF_MODE), */
/* 1008*/ DEF_VALS1(MQIACF_QUIESCE),
/* 1009*/ DEF_VALS1(MQIACF_ALL),
/* 1010*/ DEF_VALS1(MQIACF_EVENT_APPL_TYPE),
/* 1011*/ DEF_VALS1(MQIACF_EVENT_ORIGIN),
/* 1012*/ DEF_VALS1(MQIACF_PARAMETER_ID),
/* 1013*/ DEF_VALS1(MQIACF_ERROR_ID),
/* 1013   DEF_VALS1(MQIACF_ERROR_IDENTIFIER), */
/* 1014*/ DEF_VALS1(MQIACF_SELECTOR),
/* 1015*/ DEF_VALS1(MQIACF_CHANNEL_ATTRS),
/* 1016*/ DEF_VALS1(MQIACF_OBJECT_TYPE),
/* 1017*/ DEF_VALS1(MQIACF_ESCAPE_TYPE),
/* 1018*/ DEF_VALS1(MQIACF_ERROR_OFFSET),
/* 1019*/ DEF_VALS1(MQIACF_AUTH_INFO_ATTRS),
/* 1020*/ DEF_VALS1(MQIACF_REASON_QUALIFIER),
/* 1021*/ DEF_VALS1(MQIACF_COMMAND),
/* 1022*/ DEF_VALS1(MQIACF_OPEN_OPTIONS),
/* 1023*/ DEF_VALS1(MQIACF_OPEN_TYPE),
/* 1024*/ DEF_VALS1(MQIACF_PROCESS_ID),
/* 1025*/ DEF_VALS1(MQIACF_THREAD_ID),
/* 1026*/ DEF_VALS1(MQIACF_Q_STATUS_ATTRS),
/* 1027*/ DEF_VALS1(MQIACF_UNCOMMITTED_MSGS),
/* 1028*/ DEF_VALS1(MQIACF_HANDLE_STATE),
/* 1070*/ DEF_VALS1(MQIACF_AUX_ERROR_DATA_INT_1),
/* 1071*/ DEF_VALS1(MQIACF_AUX_ERROR_DATA_INT_2),
/* 1072*/ DEF_VALS1(MQIACF_CONV_REASON_CODE),
/* 1073*/ DEF_VALS1(MQIACF_BRIDGE_TYPE),
/* 1074*/ DEF_VALS1(MQIACF_INQUIRY),
/* 1075*/ DEF_VALS1(MQIACF_WAIT_INTERVAL),
/* 1076*/ DEF_VALS1(MQIACF_OPTIONS),
/* 1077*/ DEF_VALS1(MQIACF_BROKER_OPTIONS),
/* 1078*/ DEF_VALS1(MQIACF_REFRESH_TYPE),
/* 1079*/ DEF_VALS1(MQIACF_SEQUENCE_NUMBER),
/* 1080*/ DEF_VALS1(MQIACF_INTEGER_DATA),
/* 1081*/ DEF_VALS1(MQIACF_REGISTRATION_OPTIONS),
/* 1082*/ DEF_VALS1(MQIACF_PUBLICATION_OPTIONS),
/* 1083*/ DEF_VALS1(MQIACF_CLUSTER_INFO),
/* 1084*/ DEF_VALS1(MQIACF_Q_MGR_DEFINITION_TYPE),
/* 1085*/ DEF_VALS1(MQIACF_Q_MGR_TYPE),
/* 1086*/ DEF_VALS1(MQIACF_ACTION),
/* 1087*/ DEF_VALS1(MQIACF_SUSPEND),
/* 1088*/ DEF_VALS1(MQIACF_BROKER_COUNT),
/* 1089*/ DEF_VALS1(MQIACF_APPL_COUNT),
/* 1090*/ DEF_VALS1(MQIACF_ANONYMOUS_COUNT),
/* 1091*/ DEF_VALS1(MQIACF_REG_REG_OPTIONS),
/* 1092*/ DEF_VALS1(MQIACF_DELETE_OPTIONS),
/* 1093*/ DEF_VALS1(MQIACF_CLUSTER_Q_MGR_ATTRS),
/* 1094*/ DEF_VALS1(MQIACF_REFRESH_INTERVAL),
/* 1095*/ DEF_VALS1(MQIACF_REFRESH_REPOSITORY),
/* 1096*/ DEF_VALS1(MQIACF_REMOVE_QUEUES),
/* 1098*/ DEF_VALS1(MQIACF_OPEN_INPUT_TYPE),
/* 1099*/ DEF_VALS1(MQIACF_OPEN_OUTPUT),
/* 1100*/ DEF_VALS1(MQIACF_OPEN_SET),
/* 1101*/ DEF_VALS1(MQIACF_OPEN_INQUIRE),
/* 1102*/ DEF_VALS1(MQIACF_OPEN_BROWSE),
/* 1103*/ DEF_VALS1(MQIACF_Q_STATUS_TYPE),
/* 1104*/ DEF_VALS1(MQIACF_Q_HANDLE),
/* 1105*/ DEF_VALS1(MQIACF_Q_STATUS),
/* 1106*/ DEF_VALS1(MQIACF_SECURITY_TYPE),
/* 1107*/ DEF_VALS1(MQIACF_CONNECTION_ATTRS),
/* 1108*/ DEF_VALS1(MQIACF_CONNECT_OPTIONS),
/* 1110*/ DEF_VALS1(MQIACF_CONN_INFO_TYPE),
/* 1111*/ DEF_VALS1(MQIACF_CONN_INFO_CONN),
/* 1112*/ DEF_VALS1(MQIACF_CONN_INFO_HANDLE),
/* 1113*/ DEF_VALS1(MQIACF_CONN_INFO_ALL),
/* 1114*/ DEF_VALS1(MQIACF_AUTH_PROFILE_ATTRS),
/* 1115*/ DEF_VALS1(MQIACF_AUTHORIZATION_LIST),
/* 1116*/ DEF_VALS1(MQIACF_AUTH_ADD_AUTHS),
/* 1117*/ DEF_VALS1(MQIACF_AUTH_REMOVE_AUTHS),
/* 1118*/ DEF_VALS1(MQIACF_ENTITY_TYPE),
/* 1120*/ DEF_VALS1(MQIACF_COMMAND_INFO),
/* 1121*/ DEF_VALS1(MQIACF_CMDSCOPE_Q_MGR_COUNT),
/* 1122*/ DEF_VALS1(MQIACF_Q_MGR_SYSTEM),
/* 1123*/ DEF_VALS1(MQIACF_Q_MGR_EVENT),
/* 1124*/ DEF_VALS1(MQIACF_Q_MGR_DQM),
/* 1125*/ DEF_VALS1(MQIACF_Q_MGR_CLUSTER),
/* 1126*/ DEF_VALS1(MQIACF_QSG_DISPS),
/* 1128*/ DEF_VALS1(MQIACF_UOW_STATE),
/* 1129*/ DEF_VALS1(MQIACF_SECURITY_ITEM),
/* 1130*/ DEF_VALS1(MQIACF_CF_STRUC_STATUS),
/* 1132*/ DEF_VALS1(MQIACF_UOW_TYPE),
/* 1133*/ DEF_VALS1(MQIACF_CF_STRUC_ATTRS),
/* 1134*/ DEF_VALS1(MQIACF_EXCLUDE_INTERVAL),
/* 1135*/ DEF_VALS1(MQIACF_CF_STATUS_TYPE),
/* 1136*/ DEF_VALS1(MQIACF_CF_STATUS_SUMMARY),
/* 1137*/ DEF_VALS1(MQIACF_CF_STATUS_CONNECT),
/* 1138*/ DEF_VALS1(MQIACF_CF_STATUS_BACKUP),
/* 1139*/ DEF_VALS1(MQIACF_CF_STRUC_TYPE),
/* 1140*/ DEF_VALS1(MQIACF_CF_STRUC_SIZE_MAX),
/* 1141*/ DEF_VALS1(MQIACF_CF_STRUC_SIZE_USED),
/* 1142*/ DEF_VALS1(MQIACF_CF_STRUC_ENTRIES_MAX),
/* 1143*/ DEF_VALS1(MQIACF_CF_STRUC_ENTRIES_USED),
/* 1144*/ DEF_VALS1(MQIACF_CF_STRUC_BACKUP_SIZE),
/* 1145*/ DEF_VALS1(MQIACF_MOVE_TYPE),
/* 1146*/ DEF_VALS1(MQIACF_MOVE_TYPE_MOVE),
/* 1147*/ DEF_VALS1(MQIACF_MOVE_TYPE_ADD),
/* 1148*/ DEF_VALS1(MQIACF_Q_MGR_NUMBER),
/* 1149*/ DEF_VALS1(MQIACF_Q_MGR_STATUS),
/* 1150*/ DEF_VALS1(MQIACF_DB2_CONN_STATUS),
/* 1151*/ DEF_VALS1(MQIACF_SECURITY_ATTRS),
/* 1152*/ DEF_VALS1(MQIACF_SECURITY_TIMEOUT),
/* 1153*/ DEF_VALS1(MQIACF_SECURITY_INTERVAL),
/* 1154*/ DEF_VALS1(MQIACF_SECURITY_SWITCH),
/* 1155*/ DEF_VALS1(MQIACF_SECURITY_SETTING),
/* 1156*/ DEF_VALS1(MQIACF_STORAGE_CLASS_ATTRS),
/* 1157*/ DEF_VALS1(MQIACF_USAGE_TYPE),
/* 1158*/ DEF_VALS1(MQIACF_BUFFER_POOL_ID),
/* 1159*/ DEF_VALS1(MQIACF_USAGE_TOTAL_PAGES),
/* 1160*/ DEF_VALS1(MQIACF_USAGE_UNUSED_PAGES),
/* 1161*/ DEF_VALS1(MQIACF_USAGE_PERSIST_PAGES),
/* 1162*/ DEF_VALS1(MQIACF_USAGE_NONPERSIST_PAGES),
/* 1163*/ DEF_VALS1(MQIACF_USAGE_RESTART_EXTENTS),
/* 1164*/ DEF_VALS1(MQIACF_USAGE_EXPAND_COUNT),
/* 1165*/ DEF_VALS1(MQIACF_PAGESET_STATUS),
/* 1166*/ DEF_VALS1(MQIACF_USAGE_TOTAL_BUFFERS),
/* 1167*/ DEF_VALS1(MQIACF_USAGE_DATA_SET_TYPE),
/* 1168*/ DEF_VALS1(MQIACF_USAGE_PAGESET),
/* 1169*/ DEF_VALS1(MQIACF_USAGE_DATA_SET),
/* 1170*/ DEF_VALS1(MQIACF_USAGE_BUFFER_POOL),
/* 1171*/ DEF_VALS1(MQIACF_MOVE_COUNT),
/* 1172*/ DEF_VALS1(MQIACF_EXPIRY_Q_COUNT),
/* 1173*/ DEF_VALS1(MQIACF_CONFIGURATION_OBJECTS),
/* 1174*/ DEF_VALS1(MQIACF_CONFIGURATION_EVENTS),
/* 1175*/ DEF_VALS1(MQIACF_SYSP_TYPE),
/* 1176*/ DEF_VALS1(MQIACF_SYSP_DEALLOC_INTERVAL),
/* 1177*/ DEF_VALS1(MQIACF_SYSP_MAX_ARCHIVE),
/* 1178*/ DEF_VALS1(MQIACF_SYSP_MAX_READ_TAPES),
/* 1179*/ DEF_VALS1(MQIACF_SYSP_IN_BUFFER_SIZE),
/* 1180*/ DEF_VALS1(MQIACF_SYSP_OUT_BUFFER_SIZE),
/* 1181*/ DEF_VALS1(MQIACF_SYSP_OUT_BUFFER_COUNT),
/* 1182*/ DEF_VALS1(MQIACF_SYSP_ARCHIVE),
/* 1183*/ DEF_VALS1(MQIACF_SYSP_DUAL_ACTIVE),
/* 1184*/ DEF_VALS1(MQIACF_SYSP_DUAL_ARCHIVE),
/* 1185*/ DEF_VALS1(MQIACF_SYSP_DUAL_BSDS),
/* 1186*/ DEF_VALS1(MQIACF_SYSP_MAX_CONNS),
/* 1187*/ DEF_VALS1(MQIACF_SYSP_MAX_CONNS_FORE),
/* 1188*/ DEF_VALS1(MQIACF_SYSP_MAX_CONNS_BACK),
/* 1189*/ DEF_VALS1(MQIACF_SYSP_EXIT_INTERVAL),
/* 1190*/ DEF_VALS1(MQIACF_SYSP_EXIT_TASKS),
/* 1191*/ DEF_VALS1(MQIACF_SYSP_CHKPOINT_COUNT),
/* 1192*/ DEF_VALS1(MQIACF_SYSP_OTMA_INTERVAL),
/* 1193*/ DEF_VALS1(MQIACF_SYSP_Q_INDEX_DEFER),
/* 1194*/ DEF_VALS1(MQIACF_SYSP_DB2_TASKS),
/* 1195*/ DEF_VALS1(MQIACF_SYSP_RESLEVEL_AUDIT),
/* 1196*/ DEF_VALS1(MQIACF_SYSP_ROUTING_CODE),
/* 1197*/ DEF_VALS1(MQIACF_SYSP_SMF_ACCOUNTING),
/* 1198*/ DEF_VALS1(MQIACF_SYSP_SMF_STATS),
/* 1199*/ DEF_VALS1(MQIACF_SYSP_SMF_INTERVAL),
/* 1200*/ DEF_VALS1(MQIACF_SYSP_TRACE_CLASS),
/* 1201*/ DEF_VALS1(MQIACF_SYSP_TRACE_SIZE),
/* 1202*/ DEF_VALS1(MQIACF_SYSP_WLM_INTERVAL),
/* 1203*/ DEF_VALS1(MQIACF_SYSP_ALLOC_UNIT),
/* 1204*/ DEF_VALS1(MQIACF_SYSP_ARCHIVE_RETAIN),
/* 1205*/ DEF_VALS1(MQIACF_SYSP_ARCHIVE_WTOR),
/* 1206*/ DEF_VALS1(MQIACF_SYSP_BLOCK_SIZE),
/* 1207*/ DEF_VALS1(MQIACF_SYSP_CATALOG),
/* 1208*/ DEF_VALS1(MQIACF_SYSP_COMPACT),
/* 1209*/ DEF_VALS1(MQIACF_SYSP_ALLOC_PRIMARY),
/* 1210*/ DEF_VALS1(MQIACF_SYSP_ALLOC_SECONDARY),
/* 1211*/ DEF_VALS1(MQIACF_SYSP_PROTECT),
/* 1212*/ DEF_VALS1(MQIACF_SYSP_QUIESCE_INTERVAL),
/* 1213*/ DEF_VALS1(MQIACF_SYSP_TIMESTAMP),
/* 1214*/ DEF_VALS1(MQIACF_SYSP_UNIT_ADDRESS),
/* 1215*/ DEF_VALS1(MQIACF_SYSP_UNIT_STATUS),
/* 1216*/ DEF_VALS1(MQIACF_SYSP_LOG_COPY),
/* 1217*/ DEF_VALS1(MQIACF_SYSP_LOG_USED),
/* 1218*/ DEF_VALS1(MQIACF_SYSP_LOG_SUSPEND),
/* 1219*/ DEF_VALS1(MQIACF_SYSP_OFFLOAD_STATUS),
/* 1220*/ DEF_VALS1(MQIACF_SYSP_TOTAL_LOGS),
/* 1221*/ DEF_VALS1(MQIACF_SYSP_FULL_LOGS),
/* 1222*/ DEF_VALS1(MQIACF_LISTENER_ATTRS),
/* 1223*/ DEF_VALS1(MQIACF_LISTENER_STATUS_ATTRS),
/* 1224*/ DEF_VALS1(MQIACF_SERVICE_ATTRS),
/* 1225*/ DEF_VALS1(MQIACF_SERVICE_STATUS_ATTRS),
/* 1226*/ DEF_VALS1(MQIACF_Q_TIME_INDICATOR),
/* 1227*/ DEF_VALS1(MQIACF_OLDEST_MSG_AGE),
/* 1228*/ DEF_VALS1(MQIACF_AUTH_OPTIONS),
/* 1229*/ DEF_VALS1(MQIACF_Q_MGR_STATUS_ATTRS),
/* 1230*/ DEF_VALS1(MQIACF_CONNECTION_COUNT),
/* 1231*/ DEF_VALS1(MQIACF_Q_MGR_FACILITY),
/* 1232*/ DEF_VALS1(MQIACF_CHINIT_STATUS),
/* 1233*/ DEF_VALS1(MQIACF_CMD_SERVER_STATUS),
/* 1234*/ DEF_VALS1(MQIACF_ROUTE_DETAIL),
/* 1235*/ DEF_VALS1(MQIACF_RECORDED_ACTIVITIES),
/* 1236*/ DEF_VALS1(MQIACF_MAX_ACTIVITIES),
/* 1237*/ DEF_VALS1(MQIACF_DISCONTINUITY_COUNT),
/* 1238*/ DEF_VALS1(MQIACF_ROUTE_ACCUMULATION),
/* 1239*/ DEF_VALS1(MQIACF_ROUTE_DELIVERY),
/* 1240*/ DEF_VALS1(MQIACF_OPERATION_TYPE),
/* 1241*/ DEF_VALS1(MQIACF_BACKOUT_COUNT),
/* 1242*/ DEF_VALS1(MQIACF_COMP_CODE),
/* 1243*/ DEF_VALS1(MQIACF_ENCODING),
/* 1244*/ DEF_VALS1(MQIACF_EXPIRY),
/* 1245*/ DEF_VALS1(MQIACF_FEEDBACK),
/* 1247*/ DEF_VALS1(MQIACF_MSG_FLAGS),
/* 1248*/ DEF_VALS1(MQIACF_MSG_LENGTH),
/* 1249*/ DEF_VALS1(MQIACF_MSG_TYPE),
/* 1250*/ DEF_VALS1(MQIACF_OFFSET),
/* 1251*/ DEF_VALS1(MQIACF_ORIGINAL_LENGTH),
/* 1252*/ DEF_VALS1(MQIACF_PERSISTENCE),
/* 1253*/ DEF_VALS1(MQIACF_PRIORITY),
/* 1254*/ DEF_VALS1(MQIACF_REASON_CODE),
/* 1255*/ DEF_VALS1(MQIACF_REPORT),
/* 1256*/ DEF_VALS1(MQIACF_VERSION),
/* 1257*/ DEF_VALS1(MQIACF_UNRECORDED_ACTIVITIES),
/* 1258*/ DEF_VALS1(MQIACF_MONITORING),
/* 1259*/ DEF_VALS1(MQIACF_ROUTE_FORWARDING),
/* 1260*/ DEF_VALS1(MQIACF_SERVICE_STATUS),
/* 1261*/ DEF_VALS1(MQIACF_Q_TYPES),
/* 1262*/ DEF_VALS1(MQIACF_USER_ID_SUPPORT),
/* 1263*/ DEF_VALS1(MQIACF_INTERFACE_VERSION),
/* 1264*/ DEF_VALS1(MQIACF_AUTH_SERVICE_ATTRS),
/* 1265*/ DEF_VALS1(MQIACF_USAGE_EXPAND_TYPE),
/* 1266*/ DEF_VALS1(MQIACF_SYSP_CLUSTER_CACHE),
/* 1267*/ DEF_VALS1(MQIACF_SYSP_DB2_BLOB_TASKS),
/* 1268*/ DEF_VALS1(MQIACF_SYSP_WLM_INT_UNITS),
/* 1269*/ DEF_VALS1(MQIACF_TOPIC_ATTRS),
/* 1271*/ DEF_VALS1(MQIACF_PUBSUB_PROPERTIES),
/* 1273*/ DEF_VALS1(MQIACF_DESTINATION_CLASS),
/* 1274*/ DEF_VALS1(MQIACF_DURABLE_SUBSCRIPTION),
/* 1275*/ DEF_VALS1(MQIACF_SUBSCRIPTION_SCOPE),
/* 1277*/ DEF_VALS1(MQIACF_VARIABLE_USER_ID),
/* 1280*/ DEF_VALS1(MQIACF_REQUEST_ONLY),
/* 1283*/ DEF_VALS1(MQIACF_PUB_PRIORITY),
/* 1287*/ DEF_VALS1(MQIACF_SUB_ATTRS),
/* 1288*/ DEF_VALS1(MQIACF_WILDCARD_SCHEMA),
/* 1289*/ DEF_VALS1(MQIACF_SUB_TYPE),
/* 1290*/ DEF_VALS1(MQIACF_MESSAGE_COUNT),
/* 1291*/ DEF_VALS1(MQIACF_Q_MGR_PUBSUB),
/* 1292*/ DEF_VALS1(MQIACF_Q_MGR_VERSION),
/* 1294*/ DEF_VALS1(MQIACF_SUB_STATUS_ATTRS),
/* 1295*/ DEF_VALS1(MQIACF_TOPIC_STATUS),
/* 1296*/ DEF_VALS1(MQIACF_TOPIC_SUB),
/* 1297*/ DEF_VALS1(MQIACF_TOPIC_PUB),
/* 1300*/ DEF_VALS1(MQIACF_RETAINED_PUBLICATION),
/* 1301*/ DEF_VALS1(MQIACF_TOPIC_STATUS_ATTRS),
/* 1302*/ DEF_VALS1(MQIACF_TOPIC_STATUS_TYPE),
/* 1303*/ DEF_VALS1(MQIACF_SUB_OPTIONS),
/* 1304*/ DEF_VALS1(MQIACF_PUBLISH_COUNT),
/* 1305*/ DEF_VALS1(MQIACF_CLEAR_TYPE),
/* 1306*/ DEF_VALS1(MQIACF_CLEAR_SCOPE),
/* 1307*/ DEF_VALS1(MQIACF_SUB_LEVEL),
/* 1308*/ DEF_VALS1(MQIACF_ASYNC_STATE),
/* 1309*/ DEF_VALS1(MQIACF_SUB_SUMMARY),
/* 1310*/ DEF_VALS1(MQIACF_OBSOLETE_MSGS),
/* 1311*/ DEF_VALS1(MQIACF_PUBSUB_STATUS),
/* 1314*/ DEF_VALS1(MQIACF_PS_STATUS_TYPE),
/* 1318*/ DEF_VALS1(MQIACF_PUBSUB_STATUS_ATTRS),
/* 1321*/ DEF_VALS1(MQIACF_SELECTOR_TYPE),
/* 1322*/ DEF_VALS1(MQIACF_LOG_COMPRESSION),
/* 1323*/ DEF_VALS1(MQIACF_GROUPUR_CHECK_ID),
/* 1324*/ DEF_VALS1(MQIACF_MULC_CAPTURE),
/* 1325*/ DEF_VALS1(MQIACF_PERMIT_STANDBY),
/* 1326*/ DEF_VALS1(MQIACF_OPERATION_MODE),
/* 1327*/ DEF_VALS1(MQIACF_COMM_INFO_ATTRS),
/* 1328*/ DEF_VALS1(MQIACF_CF_SMDS_BLOCK_SIZE),
/* 1329*/ DEF_VALS1(MQIACF_CF_SMDS_EXPAND),
/* 1330*/ DEF_VALS1(MQIACF_USAGE_FREE_BUFF),
/* 1331*/ DEF_VALS1(MQIACF_USAGE_FREE_BUFF_PERC),
/* 1332*/ DEF_VALS1(MQIACF_CF_STRUC_ACCESS),
/* 1333*/ DEF_VALS1(MQIACF_CF_STATUS_SMDS),
/* 1334*/ DEF_VALS1(MQIACF_SMDS_ATTRS),
/* 1335*/ DEF_VALS1(MQIACF_USAGE_SMDS),
/* 1336*/ DEF_VALS1(MQIACF_USAGE_BLOCK_SIZE),
/* 1337*/ DEF_VALS1(MQIACF_USAGE_DATA_BLOCKS),
/* 1338*/ DEF_VALS1(MQIACF_USAGE_EMPTY_BUFFERS),
/* 1339*/ DEF_VALS1(MQIACF_USAGE_INUSE_BUFFERS),
/* 1340*/ DEF_VALS1(MQIACF_USAGE_LOWEST_FREE),
/* 1341*/ DEF_VALS1(MQIACF_USAGE_OFFLOAD_MSGS),
/* 1342*/ DEF_VALS1(MQIACF_USAGE_READS_SAVED),
/* 1343*/ DEF_VALS1(MQIACF_USAGE_SAVED_BUFFERS),
/* 1344*/ DEF_VALS1(MQIACF_USAGE_TOTAL_BLOCKS),
/* 1345*/ DEF_VALS1(MQIACF_USAGE_USED_BLOCKS),
/* 1346*/ DEF_VALS1(MQIACF_USAGE_USED_RATE),
/* 1347*/ DEF_VALS1(MQIACF_USAGE_WAIT_RATE),
/* 1348*/ DEF_VALS1(MQIACF_SMDS_OPENMODE),
/* 1349*/ DEF_VALS1(MQIACF_SMDS_STATUS),
/* 1350*/ DEF_VALS1(MQIACF_SMDS_AVAIL),
/* 1351*/ DEF_VALS1(MQIACF_MCAST_REL_INDICATOR),
/* 1352*/ DEF_VALS1(MQIACF_CHLAUTH_TYPE),
/* 1354*/ DEF_VALS1(MQIACF_MQXR_DIAGNOSTICS_TYPE),
/* 1355*/ DEF_VALS1(MQIACF_CHLAUTH_ATTRS),
/* 1356*/ DEF_VALS1(MQIACF_OPERATION_ID),
/* 1357*/ DEF_VALS1(MQIACF_API_CALLER_TYPE),
/* 1358*/ DEF_VALS1(MQIACF_API_ENVIRONMENT),
/* 1359*/ DEF_VALS1(MQIACF_TRACE_DETAIL),
/* 1360*/ DEF_VALS1(MQIACF_HOBJ),
/* 1361*/ DEF_VALS1(MQIACF_CALL_TYPE),
/* 1362*/ DEF_VALS1(MQIACF_MQCB_OPERATION),
/* 1363*/ DEF_VALS1(MQIACF_MQCB_TYPE),
/* 1364*/ DEF_VALS1(MQIACF_MQCB_OPTIONS),
/* 1365*/ DEF_VALS1(MQIACF_CLOSE_OPTIONS),
/* 1366*/ DEF_VALS1(MQIACF_CTL_OPERATION),
/* 1367*/ DEF_VALS1(MQIACF_GET_OPTIONS),
/* 1368*/ DEF_VALS1(MQIACF_RECS_PRESENT),
/* 1369*/ DEF_VALS1(MQIACF_KNOWN_DEST_COUNT),
/* 1370*/ DEF_VALS1(MQIACF_UNKNOWN_DEST_COUNT),
/* 1371*/ DEF_VALS1(MQIACF_INVALID_DEST_COUNT),
/* 1372*/ DEF_VALS1(MQIACF_RESOLVED_TYPE),
/* 1373*/ DEF_VALS1(MQIACF_PUT_OPTIONS),
/* 1374*/ DEF_VALS1(MQIACF_BUFFER_LENGTH),
/* 1375*/ DEF_VALS1(MQIACF_TRACE_DATA_LENGTH),
/* 1376*/ DEF_VALS1(MQIACF_SMDS_EXPANDST),
/* 1377*/ DEF_VALS1(MQIACF_STRUC_LENGTH),
/* 1378*/ DEF_VALS1(MQIACF_ITEM_COUNT),
/* 1379*/ DEF_VALS1(MQIACF_EXPIRY_TIME),
/* 1380*/ DEF_VALS1(MQIACF_CONNECT_TIME),
/* 1381*/ DEF_VALS1(MQIACF_DISCONNECT_TIME),
/* 1382*/ DEF_VALS1(MQIACF_HSUB),
/* 1383*/ DEF_VALS1(MQIACF_SUBRQ_OPTIONS),
/* 1384*/ DEF_VALS1(MQIACF_XA_RMID),
/* 1385*/ DEF_VALS1(MQIACF_XA_FLAGS),
/* 1386*/ DEF_VALS1(MQIACF_XA_RETCODE),
/* 1387*/ DEF_VALS1(MQIACF_XA_HANDLE),
/* 1388*/ DEF_VALS1(MQIACF_XA_RETVAL),
/* 1389*/ DEF_VALS1(MQIACF_STATUS_TYPE),
/* 1390*/ DEF_VALS1(MQIACF_XA_COUNT),
/* 1391*/ DEF_VALS1(MQIACF_SELECTOR_COUNT),
/* 1392*/ DEF_VALS1(MQIACF_SELECTORS),
/* 1393*/ DEF_VALS1(MQIACF_INTATTR_COUNT),
/* 1394*/ DEF_VALS1(MQIACF_INT_ATTRS),
/* 1395*/ DEF_VALS1(MQIACF_SUBRQ_ACTION),
/* 1396*/ DEF_VALS1(MQIACF_NUM_PUBS),
/* 1397*/ DEF_VALS1(MQIACF_POINTER_SIZE),
/* 1398*/ DEF_VALS1(MQIACF_REMOVE_AUTHREC),
/* 1399*/ DEF_VALS1(MQIACF_XR_ATTRS),
/* 1400*/ DEF_VALS1(MQIACF_APPL_FUNCTION_TYPE),
/* 1401*/ DEF_VALS1(MQIACF_AMQP_ATTRS),
/* 1402*/ DEF_VALS1(MQIACF_EXPORT_TYPE),
/* 1403*/ DEF_VALS1(MQIACF_EXPORT_ATTRS),
/* 1404*/ DEF_VALS1(MQIACF_SYSTEM_OBJECTS),
/* 1405*/ DEF_VALS1(MQIACF_CONNECTION_SWAP),
/* 1406*/ DEF_VALS1(MQIACF_AMQP_DIAGNOSTICS_TYPE),
/* 1408*/ DEF_VALS1(MQIACF_BUFFER_POOL_LOCATION),
/* 1409*/ DEF_VALS1(MQIACF_LDAP_CONNECTION_STATUS),
/* 1410*/ DEF_VALS1(MQIACF_SYSP_MAX_ACE_POOL),
/* 1411*/ DEF_VALS1(MQIACF_PAGECLAS),
/* 1412*/ DEF_VALS1(MQIACF_AUTH_REC_TYPE),
/* 1413*/ DEF_VALS1(MQIACF_SYSP_MAX_CONC_OFFLOADS),
/* 1414*/ DEF_VALS1(MQIACF_SYSP_ZHYPERWRITE),
/* 1415*/ DEF_VALS1(MQIACF_Q_MGR_STATUS_LOG),
/* 1416*/ DEF_VALS1(MQIACF_ARCHIVE_LOG_SIZE),
/* 1417*/ DEF_VALS1(MQIACF_MEDIA_LOG_SIZE),
/* 1418*/ DEF_VALS1(MQIACF_RESTART_LOG_SIZE),
/* 1419*/ DEF_VALS1(MQIACF_REUSABLE_LOG_SIZE),
/* 1420*/ DEF_VALS1(MQIACF_LOG_IN_USE),
/* 1421*/ DEF_VALS1(MQIACF_LOG_UTILIZATION),
/* 1422*/ DEF_VALS1(MQIACF_LOG_REDUCTION),
/* 1501*/ DEF_VALS1(MQIACH_XMIT_PROTOCOL_TYPE),
/* 1502*/ DEF_VALS1(MQIACH_BATCH_SIZE),
/* 1503*/ DEF_VALS1(MQIACH_DISC_INTERVAL),
/* 1504*/ DEF_VALS1(MQIACH_SHORT_TIMER),
/* 1505*/ DEF_VALS1(MQIACH_SHORT_RETRY),
/* 1506*/ DEF_VALS1(MQIACH_LONG_TIMER),
/* 1507*/ DEF_VALS1(MQIACH_LONG_RETRY),
/* 1508*/ DEF_VALS1(MQIACH_PUT_AUTHORITY),
/* 1509*/ DEF_VALS1(MQIACH_SEQUENCE_NUMBER_WRAP),
/* 1510*/ DEF_VALS1(MQIACH_MAX_MSG_LENGTH),
/* 1511*/ DEF_VALS1(MQIACH_CHANNEL_TYPE),
/* 1512*/ DEF_VALS1(MQIACH_DATA_COUNT),
/* 1513*/ DEF_VALS1(MQIACH_NAME_COUNT),
/* 1514*/ DEF_VALS1(MQIACH_MSG_SEQUENCE_NUMBER),
/* 1515*/ DEF_VALS1(MQIACH_DATA_CONVERSION),
/* 1516*/ DEF_VALS1(MQIACH_IN_DOUBT),
/* 1517*/ DEF_VALS1(MQIACH_MCA_TYPE),
/* 1518*/ DEF_VALS1(MQIACH_SESSION_COUNT),
/* 1519*/ DEF_VALS1(MQIACH_ADAPTER),
/* 1520*/ DEF_VALS1(MQIACH_COMMAND_COUNT),
/* 1521*/ DEF_VALS1(MQIACH_SOCKET),
/* 1522*/ DEF_VALS1(MQIACH_PORT),
/* 1523*/ DEF_VALS1(MQIACH_CHANNEL_INSTANCE_TYPE),
/* 1524*/ DEF_VALS1(MQIACH_CHANNEL_INSTANCE_ATTRS),
/* 1525*/ DEF_VALS1(MQIACH_CHANNEL_ERROR_DATA),
/* 1526*/ DEF_VALS1(MQIACH_CHANNEL_TABLE),
/* 1527*/ DEF_VALS1(MQIACH_CHANNEL_STATUS),
/* 1528*/ DEF_VALS1(MQIACH_INDOUBT_STATUS),
/* 1529*/ DEF_VALS1(MQIACH_LAST_SEQ_NUMBER),
/* 1529 DEF_VALS1(MQIACH_LAST_SEQUENCE_NUMBER), */
/* 1531*/ DEF_VALS1(MQIACH_CURRENT_MSGS),
/* 1532*/ DEF_VALS1(MQIACH_CURRENT_SEQ_NUMBER),
/* 1532 DEF_VALS1(MQIACH_CURRENT_SEQUENCE_NUMBER), */
/* 1533*/ DEF_VALS1(MQIACH_SSL_RETURN_CODE),
/* 1534*/ DEF_VALS1(MQIACH_MSGS),
/* 1535*/ DEF_VALS1(MQIACH_BYTES_SENT),
/* 1536 DEF_VALS1(MQIACH_BYTES_RCVD), */
/* 1536*/ DEF_VALS1(MQIACH_BYTES_RECEIVED),
/* 1537*/ DEF_VALS1(MQIACH_BATCHES),
/* 1538*/ DEF_VALS1(MQIACH_BUFFERS_SENT),
/* 1539 DEF_VALS1(MQIACH_BUFFERS_RCVD), */
/* 1539*/ DEF_VALS1(MQIACH_BUFFERS_RECEIVED),
/* 1540*/ DEF_VALS1(MQIACH_LONG_RETRIES_LEFT),
/* 1541*/ DEF_VALS1(MQIACH_SHORT_RETRIES_LEFT),
/* 1542*/ DEF_VALS1(MQIACH_MCA_STATUS),
/* 1543*/ DEF_VALS1(MQIACH_STOP_REQUESTED),
/* 1544*/ DEF_VALS1(MQIACH_MR_COUNT),
/* 1545*/ DEF_VALS1(MQIACH_MR_INTERVAL),
/* 1562*/ DEF_VALS1(MQIACH_NPM_SPEED),
/* 1563*/ DEF_VALS1(MQIACH_HB_INTERVAL),
/* 1564*/ DEF_VALS1(MQIACH_BATCH_INTERVAL),
/* 1565*/ DEF_VALS1(MQIACH_NETWORK_PRIORITY),
/* 1566*/ DEF_VALS1(MQIACH_KEEP_ALIVE_INTERVAL),
/* 1567*/ DEF_VALS1(MQIACH_BATCH_HB),
/* 1568*/ DEF_VALS1(MQIACH_SSL_CLIENT_AUTH),
/* 1570*/ DEF_VALS1(MQIACH_ALLOC_RETRY),
/* 1571*/ DEF_VALS1(MQIACH_ALLOC_FAST_TIMER),
/* 1572*/ DEF_VALS1(MQIACH_ALLOC_SLOW_TIMER),
/* 1573*/ DEF_VALS1(MQIACH_DISC_RETRY),
/* 1574*/ DEF_VALS1(MQIACH_PORT_NUMBER),
/* 1575*/ DEF_VALS1(MQIACH_HDR_COMPRESSION),
/* 1576*/ DEF_VALS1(MQIACH_MSG_COMPRESSION),
/* 1577*/ DEF_VALS1(MQIACH_CLWL_CHANNEL_RANK),
/* 1578*/ DEF_VALS1(MQIACH_CLWL_CHANNEL_PRIORITY),
/* 1579*/ DEF_VALS1(MQIACH_CLWL_CHANNEL_WEIGHT),
/* 1580*/ DEF_VALS1(MQIACH_CHANNEL_DISP),
/* 1581*/ DEF_VALS1(MQIACH_INBOUND_DISP),
/* 1582*/ DEF_VALS1(MQIACH_CHANNEL_TYPES),
/* 1583*/ DEF_VALS1(MQIACH_ADAPS_STARTED),
/* 1584*/ DEF_VALS1(MQIACH_ADAPS_MAX),
/* 1585*/ DEF_VALS1(MQIACH_DISPS_STARTED),
/* 1586*/ DEF_VALS1(MQIACH_DISPS_MAX),
/* 1587*/ DEF_VALS1(MQIACH_SSLTASKS_STARTED),
/* 1588*/ DEF_VALS1(MQIACH_SSLTASKS_MAX),
/* 1589*/ DEF_VALS1(MQIACH_CURRENT_CHL),
/* 1590*/ DEF_VALS1(MQIACH_CURRENT_CHL_MAX),
/* 1591*/ DEF_VALS1(MQIACH_CURRENT_CHL_TCP),
/* 1592*/ DEF_VALS1(MQIACH_CURRENT_CHL_LU62),
/* 1593*/ DEF_VALS1(MQIACH_ACTIVE_CHL),
/* 1594*/ DEF_VALS1(MQIACH_ACTIVE_CHL_MAX),
/* 1595*/ DEF_VALS1(MQIACH_ACTIVE_CHL_PAUSED),
/* 1596*/ DEF_VALS1(MQIACH_ACTIVE_CHL_STARTED),
/* 1597*/ DEF_VALS1(MQIACH_ACTIVE_CHL_STOPPED),
/* 1598*/ DEF_VALS1(MQIACH_ACTIVE_CHL_RETRY),
/* 1599*/ DEF_VALS1(MQIACH_LISTENER_STATUS),
/* 1600*/ DEF_VALS1(MQIACH_SHARED_CHL_RESTART),
/* 1601*/ DEF_VALS1(MQIACH_LISTENER_CONTROL),
/* 1602*/ DEF_VALS1(MQIACH_BACKLOG),
/* 1604*/ DEF_VALS1(MQIACH_XMITQ_TIME_INDICATOR),
/* 1605*/ DEF_VALS1(MQIACH_NETWORK_TIME_INDICATOR),
/* 1606*/ DEF_VALS1(MQIACH_EXIT_TIME_INDICATOR),
/* 1607*/ DEF_VALS1(MQIACH_BATCH_SIZE_INDICATOR),
/* 1608*/ DEF_VALS1(MQIACH_XMITQ_MSGS_AVAILABLE),
/* 1609*/ DEF_VALS1(MQIACH_CHANNEL_SUBSTATE),
/* 1610*/ DEF_VALS1(MQIACH_SSL_KEY_RESETS),
/* 1611*/ DEF_VALS1(MQIACH_COMPRESSION_RATE),
/* 1612*/ DEF_VALS1(MQIACH_COMPRESSION_TIME),
/* 1613*/ DEF_VALS1(MQIACH_MAX_XMIT_SIZE),
/* 1614*/ DEF_VALS1(MQIACH_DEF_CHANNEL_DISP),
/* 1615*/ DEF_VALS1(MQIACH_SHARING_CONVERSATIONS),
/* 1616*/ DEF_VALS1(MQIACH_MAX_SHARING_CONVS),
/* 1617*/ DEF_VALS1(MQIACH_CURRENT_SHARING_CONVS),
/* 1618*/ DEF_VALS1(MQIACH_MAX_INSTANCES),
/* 1619*/ DEF_VALS1(MQIACH_MAX_INSTS_PER_CLIENT),
/* 1620*/ DEF_VALS1(MQIACH_CLIENT_CHANNEL_WEIGHT),
/* 1621*/ DEF_VALS1(MQIACH_CONNECTION_AFFINITY),
/* 1622*/ DEF_VALS1(MQIACH_AUTH_INFO_TYPES),
/* 1623*/ DEF_VALS1(MQIACH_RESET_REQUESTED),
/* 1624*/ DEF_VALS1(MQIACH_BATCH_DATA_LIMIT),
/* 1625*/ DEF_VALS1(MQIACH_MSG_HISTORY),
/* 1626*/ DEF_VALS1(MQIACH_MULTICAST_PROPERTIES),
/* 1627*/ DEF_VALS1(MQIACH_NEW_SUBSCRIBER_HISTORY),
/* 1628*/ DEF_VALS1(MQIACH_MC_HB_INTERVAL),
/* 1629*/ DEF_VALS1(MQIACH_USE_CLIENT_ID),
/* 1630*/ DEF_VALS1(MQIACH_MQTT_KEEP_ALIVE),
/* 1631*/ DEF_VALS1(MQIACH_IN_DOUBT_IN),
/* 1632*/ DEF_VALS1(MQIACH_IN_DOUBT_OUT),
/* 1633*/ DEF_VALS1(MQIACH_MSGS_SENT),
/* 1634*/ DEF_VALS1(MQIACH_MSGS_RCVD),
/* 1634   DEF_VALS1(MQIACH_MSGS_RECEIVED), */
/* 1635*/ DEF_VALS1(MQIACH_PENDING_OUT),
/* 1636*/ DEF_VALS1(MQIACH_AVAILABLE_CIPHERSPECS),
/* 1637*/ DEF_VALS1(MQIACH_MATCH),
/* 1638*/ DEF_VALS1(MQIACH_USER_SOURCE),
/* 1639*/ DEF_VALS1(MQIACH_WARNING),
/* 1640*/ DEF_VALS1(MQIACH_DEF_RECONNECT),
/* 1642*/ DEF_VALS1(MQIACH_CHANNEL_SUMMARY_ATTRS),
/* 1643*/ DEF_VALS1(MQIACH_PROTOCOL),
/* 1644*/ DEF_VALS1(MQIACH_AMQP_KEEP_ALIVE),
/* 1645*/ DEF_VALS1(MQIACH_SECURITY_PROTOCOL),
/* 2000*/ DEF_VALS1(MQIA_USER_LIST),
/* 2001*/ DEF_VALS1(MQCA_APPL_ID),
/* 2002*/ DEF_VALS1(MQCA_BASE_OBJECT_NAME),
/* 2002   DEF_VALS1(MQCA_BASE_Q_NAME), */
/* 2003*/ DEF_VALS1(MQCA_COMMAND_INPUT_Q_NAME),
/* 2004*/ DEF_VALS1(MQCA_CREATION_DATE),
/* 2005*/ DEF_VALS1(MQCA_CREATION_TIME),
/* 2006*/ DEF_VALS1(MQCA_DEAD_LETTER_Q_NAME),
/* 2007*/ DEF_VALS1(MQCA_ENV_DATA),
/* 2008*/ DEF_VALS1(MQCA_INITIATION_Q_NAME),
/* 2009*/ DEF_VALS1(MQCA_NAMELIST_DESC),
/* 2010*/ DEF_VALS1(MQCA_NAMELIST_NAME),
/* 2011*/ DEF_VALS1(MQCA_PROCESS_DESC),
/* 2012*/ DEF_VALS1(MQCA_PROCESS_NAME),
/* 2013*/ DEF_VALS1(MQCA_Q_DESC),
/* 2014*/ DEF_VALS1(MQCA_Q_MGR_DESC),
/* 2015*/ DEF_VALS1(MQCA_Q_MGR_NAME),
/* 2016*/ DEF_VALS1(MQCA_Q_NAME),
/* 2017*/ DEF_VALS1(MQCA_REMOTE_Q_MGR_NAME),
/* 2018*/ DEF_VALS1(MQCA_REMOTE_Q_NAME),
/* 2019*/ DEF_VALS1(MQCA_BACKOUT_REQ_Q_NAME),
/* 2020*/ DEF_VALS1(MQCA_NAMES),
/* 2021*/ DEF_VALS1(MQCA_USER_DATA),
/* 2022*/ DEF_VALS1(MQCA_STORAGE_CLASS),
/* 2023*/ DEF_VALS1(MQCA_TRIGGER_DATA),
/* 2024*/ DEF_VALS1(MQCA_XMIT_Q_NAME),
/* 2025*/ DEF_VALS1(MQCA_DEF_XMIT_Q_NAME),
/* 2026*/ DEF_VALS1(MQCA_CHANNEL_AUTO_DEF_EXIT),
/* 2027*/ DEF_VALS1(MQCA_ALTERATION_DATE),
/* 2028*/ DEF_VALS1(MQCA_ALTERATION_TIME),
/* 2029*/ DEF_VALS1(MQCA_CLUSTER_NAME),
/* 2030*/ DEF_VALS1(MQCA_CLUSTER_NAMELIST),
/* 2031*/ DEF_VALS1(MQCA_CLUSTER_Q_MGR_NAME),
/* 2032*/ DEF_VALS1(MQCA_Q_MGR_IDENTIFIER),
/* 2033*/ DEF_VALS1(MQCA_CLUSTER_WORKLOAD_EXIT),
/* 2034*/ DEF_VALS1(MQCA_CLUSTER_WORKLOAD_DATA),
/* 2035*/ DEF_VALS1(MQCA_REPOSITORY_NAME),
/* 2036*/ DEF_VALS1(MQCA_REPOSITORY_NAMELIST),
/* 2037*/ DEF_VALS1(MQCA_CLUSTER_DATE),
/* 2038*/ DEF_VALS1(MQCA_CLUSTER_TIME),
/* 2039*/ DEF_VALS1(MQCA_CF_STRUC_NAME),
/* 2040*/ DEF_VALS1(MQCA_QSG_NAME),
/* 2041*/ DEF_VALS1(MQCA_IGQ_USER_ID),
/* 2042*/ DEF_VALS1(MQCA_STORAGE_CLASS_DESC),
/* 2043*/ DEF_VALS1(MQCA_XCF_GROUP_NAME),
/* 2044*/ DEF_VALS1(MQCA_XCF_MEMBER_NAME),
/* 2045*/ DEF_VALS1(MQCA_AUTH_INFO_NAME),
/* 2046*/ DEF_VALS1(MQCA_AUTH_INFO_DESC),
/* 2047*/ DEF_VALS1(MQCA_LDAP_USER_NAME),
/* 2048*/ DEF_VALS1(MQCA_LDAP_PASSWORD),
/* 2049*/ DEF_VALS1(MQCA_SSL_KEY_REPOSITORY),
/* 2050*/ DEF_VALS1(MQCA_SSL_CRL_NAMELIST),
/* 2051*/ DEF_VALS1(MQCA_SSL_CRYPTO_HARDWARE),
/* 2052*/ DEF_VALS1(MQCA_CF_STRUC_DESC),
/* 2053*/ DEF_VALS1(MQCA_AUTH_INFO_CONN_NAME),
/* 2060*/ DEF_VALS1(MQCA_CICS_FILE_NAME),
/* 2061*/ DEF_VALS1(MQCA_TRIGGER_TRANS_ID),
/* 2062*/ DEF_VALS1(MQCA_TRIGGER_PROGRAM_NAME),
/* 2063*/ DEF_VALS1(MQCA_TRIGGER_TERM_ID),
/* 2064*/ DEF_VALS1(MQCA_TRIGGER_CHANNEL_NAME),
/* 2065*/ DEF_VALS1(MQCA_SYSTEM_LOG_Q_NAME),
/* 2066*/ DEF_VALS1(MQCA_MONITOR_Q_NAME),
/* 2067*/ DEF_VALS1(MQCA_COMMAND_REPLY_Q_NAME),
/* 2068*/ DEF_VALS1(MQCA_BATCH_INTERFACE_ID),
/* 2069*/ DEF_VALS1(MQCA_SSL_KEY_LIBRARY),
/* 2070*/ DEF_VALS1(MQCA_SSL_KEY_MEMBER),
/* 2071*/ DEF_VALS1(MQCA_DNS_GROUP),
/* 2072*/ DEF_VALS1(MQCA_LU_GROUP_NAME),
/* 2073*/ DEF_VALS1(MQCA_LU_NAME),
/* 2074*/ DEF_VALS1(MQCA_LU62_ARM_SUFFIX),
/* 2075*/ DEF_VALS1(MQCA_TCP_NAME),
/* 2076*/ DEF_VALS1(MQCA_CHINIT_SERVICE_PARM),
/* 2077*/ DEF_VALS1(MQCA_SERVICE_NAME),
/* 2078*/ DEF_VALS1(MQCA_SERVICE_DESC),
/* 2079*/ DEF_VALS1(MQCA_SERVICE_START_COMMAND),
/* 2080*/ DEF_VALS1(MQCA_SERVICE_START_ARGS),
/* 2081*/ DEF_VALS1(MQCA_SERVICE_STOP_COMMAND),
/* 2082*/ DEF_VALS1(MQCA_SERVICE_STOP_ARGS),
/* 2083*/ DEF_VALS1(MQCA_STDOUT_DESTINATION),
/* 2084*/ DEF_VALS1(MQCA_STDERR_DESTINATION),
/* 2085*/ DEF_VALS1(MQCA_TPIPE_NAME),
/* 2086*/ DEF_VALS1(MQCA_PASS_TICKET_APPL),
/* 2090*/ DEF_VALS1(MQCA_AUTO_REORG_START_TIME),
/* 2091*/ DEF_VALS1(MQCA_AUTO_REORG_CATALOG),
/* 2092*/ DEF_VALS1(MQCA_TOPIC_NAME),
/* 2093*/ DEF_VALS1(MQCA_TOPIC_DESC),
/* 2094*/ DEF_VALS1(MQCA_TOPIC_STRING),
/* 2096*/ DEF_VALS1(MQCA_MODEL_DURABLE_Q),
/* 2097*/ DEF_VALS1(MQCA_MODEL_NON_DURABLE_Q),
/* 2098*/ DEF_VALS1(MQCA_RESUME_DATE),
/* 2099*/ DEF_VALS1(MQCA_RESUME_TIME),
/* 2101*/ DEF_VALS1(MQCA_CHILD),
/* 2102*/ DEF_VALS1(MQCA_PARENT),
/* 2105*/ DEF_VALS1(MQCA_ADMIN_TOPIC_NAME),
/* 2108*/ DEF_VALS1(MQCA_TOPIC_STRING_FILTER),
/* 2109*/ DEF_VALS1(MQCA_AUTH_INFO_OCSP_URL),
/* 2110*/ DEF_VALS1(MQCA_COMM_INFO_NAME),
/* 2111*/ DEF_VALS1(MQCA_COMM_INFO_DESC),
/* 2112*/ DEF_VALS1(MQCA_POLICY_NAME),
/* 2113*/ DEF_VALS1(MQCA_SIGNER_DN),
/* 2114*/ DEF_VALS1(MQCA_RECIPIENT_DN),
/* 2115*/ DEF_VALS1(MQCA_INSTALLATION_DESC),
/* 2116*/ DEF_VALS1(MQCA_INSTALLATION_NAME),
/* 2117*/ DEF_VALS1(MQCA_INSTALLATION_PATH),
/* 2118*/ DEF_VALS1(MQCA_CHLAUTH_DESC),
/* 2119*/ DEF_VALS1(MQCA_CUSTOM),
/* 2120*/ DEF_VALS1(MQCA_VERSION),
/* 2121*/ DEF_VALS1(MQCA_CERT_LABEL),
/* 2122*/ DEF_VALS1(MQCA_XR_VERSION),
/* 2123*/ DEF_VALS1(MQCA_XR_SSL_CIPHER_SUITES),
/* 2124*/ DEF_VALS1(MQCA_CLUS_CHL_NAME),
/* 2125*/ DEF_VALS1(MQCA_CONN_AUTH),
/* 2126*/ DEF_VALS1(MQCA_LDAP_BASE_DN_USERS),
/* 2127*/ DEF_VALS1(MQCA_LDAP_SHORT_USER_FIELD),
/* 2128*/ DEF_VALS1(MQCA_LDAP_USER_OBJECT_CLASS),
/* 2129*/ DEF_VALS1(MQCA_LDAP_USER_ATTR_FIELD),
/* 2130*/ DEF_VALS1(MQCA_SSL_CERT_ISSUER_NAME),
/* 2131*/ DEF_VALS1(MQCA_QSG_CERT_LABEL),
/* 2132*/ DEF_VALS1(MQCA_LDAP_BASE_DN_GROUPS),
/* 2133*/ DEF_VALS1(MQCA_LDAP_GROUP_OBJECT_CLASS),
/* 2134*/ DEF_VALS1(MQCA_LDAP_GROUP_ATTR_FIELD),
/* 2135*/ DEF_VALS1(MQCA_LDAP_FIND_GROUP_FIELD),
/* 2136*/ DEF_VALS1(MQCA_AMQP_VERSION),
/* 2137*/ DEF_VALS1(MQCA_AMQP_SSL_CIPHER_SUITES),
/* 2701*/ DEF_VALS1(MQCAMO_CLOSE_DATE),
/* 2702*/ DEF_VALS1(MQCAMO_CLOSE_TIME),
/* 2703*/ DEF_VALS1(MQCAMO_CONN_DATE),
/* 2704*/ DEF_VALS1(MQCAMO_CONN_TIME),
/* 2705*/ DEF_VALS1(MQCAMO_DISC_DATE),
/* 2706*/ DEF_VALS1(MQCAMO_DISC_TIME),
/* 2707*/ DEF_VALS1(MQCAMO_END_DATE),
/* 2708*/ DEF_VALS1(MQCAMO_END_TIME),
/* 2709*/ DEF_VALS1(MQCAMO_OPEN_DATE),
/* 2710*/ DEF_VALS1(MQCAMO_OPEN_TIME),
/* 2711*/ DEF_VALS1(MQCAMO_START_DATE),
/* 2712*/ DEF_VALS1(MQCAMO_START_TIME),
/* 2713*/ DEF_VALS1(MQCAMO_MONITOR_CLASS),
/* 2714*/ DEF_VALS1(MQCAMO_MONITOR_TYPE),
/* 2715*/ DEF_VALS1(MQCAMO_MONITOR_DESC),
/* 3001*/ DEF_VALS1(MQCACF_FROM_Q_NAME),
/* 3002*/ DEF_VALS1(MQCACF_TO_Q_NAME),
/* 3003*/ DEF_VALS1(MQCACF_FROM_PROCESS_NAME),
/* 3004*/ DEF_VALS1(MQCACF_TO_PROCESS_NAME),
/* 3005*/ DEF_VALS1(MQCACF_FROM_NAMELIST_NAME),
/* 3006*/ DEF_VALS1(MQCACF_TO_NAMELIST_NAME),
/* 3007*/ DEF_VALS1(MQCACF_FROM_CHANNEL_NAME),
/* 3008*/ DEF_VALS1(MQCACF_TO_CHANNEL_NAME),
/* 3009*/ DEF_VALS1(MQCACF_FROM_AUTH_INFO_NAME),
/* 3010*/ DEF_VALS1(MQCACF_TO_AUTH_INFO_NAME),
/* 3011*/ DEF_VALS1(MQCACF_Q_NAMES),
/* 3012*/ DEF_VALS1(MQCACF_PROCESS_NAMES),
/* 3013*/ DEF_VALS1(MQCACF_NAMELIST_NAMES),
/* 3014*/ DEF_VALS1(MQCACF_ESCAPE_TEXT),
/* 3015*/ DEF_VALS1(MQCACF_LOCAL_Q_NAMES),
/* 3016*/ DEF_VALS1(MQCACF_MODEL_Q_NAMES),
/* 3017*/ DEF_VALS1(MQCACF_ALIAS_Q_NAMES),
/* 3018*/ DEF_VALS1(MQCACF_REMOTE_Q_NAMES),
/* 3019*/ DEF_VALS1(MQCACF_SENDER_CHANNEL_NAMES),
/* 3020*/ DEF_VALS1(MQCACF_SERVER_CHANNEL_NAMES),
/* 3021*/ DEF_VALS1(MQCACF_REQUESTER_CHANNEL_NAMES),
/* 3022*/ DEF_VALS1(MQCACF_RECEIVER_CHANNEL_NAMES),
/* 3023*/ DEF_VALS1(MQCACF_OBJECT_Q_MGR_NAME),
/* 3024*/ DEF_VALS1(MQCACF_APPL_NAME),
/* 3025*/ DEF_VALS1(MQCACF_USER_IDENTIFIER),
/* 3026*/ DEF_VALS1(MQCACF_AUX_ERROR_DATA_STR_1),
/* 3027*/ DEF_VALS1(MQCACF_AUX_ERROR_DATA_STR_2),
/* 3028*/ DEF_VALS1(MQCACF_AUX_ERROR_DATA_STR_3),
/* 3029*/ DEF_VALS1(MQCACF_BRIDGE_NAME),
/* 3030*/ DEF_VALS1(MQCACF_STREAM_NAME),
/* 3031*/ DEF_VALS1(MQCACF_TOPIC),
/* 3032*/ DEF_VALS1(MQCACF_PARENT_Q_MGR_NAME),
/* 3033*/ DEF_VALS1(MQCACF_CORREL_ID),
/* 3034*/ DEF_VALS1(MQCACF_PUBLISH_TIMESTAMP),
/* 3035*/ DEF_VALS1(MQCACF_STRING_DATA),
/* 3036*/ DEF_VALS1(MQCACF_SUPPORTED_STREAM_NAME),
/* 3037*/ DEF_VALS1(MQCACF_REG_TOPIC),
/* 3038*/ DEF_VALS1(MQCACF_REG_TIME),
/* 3039*/ DEF_VALS1(MQCACF_REG_USER_ID),
/* 3040*/ DEF_VALS1(MQCACF_CHILD_Q_MGR_NAME),
/* 3041*/ DEF_VALS1(MQCACF_REG_STREAM_NAME),
/* 3042*/ DEF_VALS1(MQCACF_REG_Q_MGR_NAME),
/* 3043*/ DEF_VALS1(MQCACF_REG_Q_NAME),
/* 3044*/ DEF_VALS1(MQCACF_REG_CORREL_ID),
/* 3045*/ DEF_VALS1(MQCACF_EVENT_USER_ID),
/* 3046*/ DEF_VALS1(MQCACF_OBJECT_NAME),
/* 3047*/ DEF_VALS1(MQCACF_EVENT_Q_MGR),
/* 3048*/ DEF_VALS1(MQCACF_AUTH_INFO_NAMES),
/* 3049*/ DEF_VALS1(MQCACF_EVENT_APPL_IDENTITY),
/* 3050*/ DEF_VALS1(MQCACF_EVENT_APPL_NAME),
/* 3051*/ DEF_VALS1(MQCACF_EVENT_APPL_ORIGIN),
/* 3052*/ DEF_VALS1(MQCACF_SUBSCRIPTION_NAME),
/* 3053*/ DEF_VALS1(MQCACF_REG_SUB_NAME),
/* 3054*/ DEF_VALS1(MQCACF_SUBSCRIPTION_IDENTITY),
/* 3055*/ DEF_VALS1(MQCACF_REG_SUB_IDENTITY),
/* 3056*/ DEF_VALS1(MQCACF_SUBSCRIPTION_USER_DATA),
/* 3057*/ DEF_VALS1(MQCACF_REG_SUB_USER_DATA),
/* 3058*/ DEF_VALS1(MQCACF_APPL_TAG),
/* 3059*/ DEF_VALS1(MQCACF_DATA_SET_NAME),
/* 3060*/ DEF_VALS1(MQCACF_UOW_START_DATE),
/* 3061*/ DEF_VALS1(MQCACF_UOW_START_TIME),
/* 3062*/ DEF_VALS1(MQCACF_UOW_LOG_START_DATE),
/* 3063*/ DEF_VALS1(MQCACF_UOW_LOG_START_TIME),
/* 3064*/ DEF_VALS1(MQCACF_UOW_LOG_EXTENT_NAME),
/* 3065*/ DEF_VALS1(MQCACF_PRINCIPAL_ENTITY_NAMES),
/* 3066*/ DEF_VALS1(MQCACF_GROUP_ENTITY_NAMES),
/* 3067*/ DEF_VALS1(MQCACF_AUTH_PROFILE_NAME),
/* 3068*/ DEF_VALS1(MQCACF_ENTITY_NAME),
/* 3069*/ DEF_VALS1(MQCACF_SERVICE_COMPONENT),
/* 3070*/ DEF_VALS1(MQCACF_RESPONSE_Q_MGR_NAME),
/* 3071*/ DEF_VALS1(MQCACF_CURRENT_LOG_EXTENT_NAME),
/* 3072*/ DEF_VALS1(MQCACF_RESTART_LOG_EXTENT_NAME),
/* 3073*/ DEF_VALS1(MQCACF_MEDIA_LOG_EXTENT_NAME),
/* 3074*/ DEF_VALS1(MQCACF_LOG_PATH),
/* 3075*/ DEF_VALS1(MQCACF_COMMAND_MQSC),
/* 3076*/ DEF_VALS1(MQCACF_Q_MGR_CPF),
/* 3078*/ DEF_VALS1(MQCACF_USAGE_LOG_RBA),
/* 3079*/ DEF_VALS1(MQCACF_USAGE_LOG_LRSN),
/* 3080*/ DEF_VALS1(MQCACF_COMMAND_SCOPE),
/* 3081*/ DEF_VALS1(MQCACF_ASID),
/* 3082*/ DEF_VALS1(MQCACF_PSB_NAME),
/* 3083*/ DEF_VALS1(MQCACF_PST_ID),
/* 3084*/ DEF_VALS1(MQCACF_TASK_NUMBER),
/* 3085*/ DEF_VALS1(MQCACF_TRANSACTION_ID),
/* 3086*/ DEF_VALS1(MQCACF_Q_MGR_UOW_ID),
/* 3088*/ DEF_VALS1(MQCACF_ORIGIN_NAME),
/* 3089*/ DEF_VALS1(MQCACF_ENV_INFO),
/* 3090*/ DEF_VALS1(MQCACF_SECURITY_PROFILE),
/* 3091*/ DEF_VALS1(MQCACF_CONFIGURATION_DATE),
/* 3092*/ DEF_VALS1(MQCACF_CONFIGURATION_TIME),
/* 3093*/ DEF_VALS1(MQCACF_FROM_CF_STRUC_NAME),
/* 3094*/ DEF_VALS1(MQCACF_TO_CF_STRUC_NAME),
/* 3095*/ DEF_VALS1(MQCACF_CF_STRUC_NAMES),
/* 3096*/ DEF_VALS1(MQCACF_FAIL_DATE),
/* 3097*/ DEF_VALS1(MQCACF_FAIL_TIME),
/* 3098*/ DEF_VALS1(MQCACF_BACKUP_DATE),
/* 3099*/ DEF_VALS1(MQCACF_BACKUP_TIME),
/* 3100*/ DEF_VALS1(MQCACF_SYSTEM_NAME),
/* 3101*/ DEF_VALS1(MQCACF_CF_STRUC_BACKUP_START),
/* 3102*/ DEF_VALS1(MQCACF_CF_STRUC_BACKUP_END),
/* 3103*/ DEF_VALS1(MQCACF_CF_STRUC_LOG_Q_MGRS),
/* 3104*/ DEF_VALS1(MQCACF_FROM_STORAGE_CLASS),
/* 3105*/ DEF_VALS1(MQCACF_TO_STORAGE_CLASS),
/* 3106*/ DEF_VALS1(MQCACF_STORAGE_CLASS_NAMES),
/* 3108*/ DEF_VALS1(MQCACF_DSG_NAME),
/* 3109*/ DEF_VALS1(MQCACF_DB2_NAME),
/* 3110*/ DEF_VALS1(MQCACF_SYSP_CMD_USER_ID),
/* 3111*/ DEF_VALS1(MQCACF_SYSP_OTMA_GROUP),
/* 3112*/ DEF_VALS1(MQCACF_SYSP_OTMA_MEMBER),
/* 3113*/ DEF_VALS1(MQCACF_SYSP_OTMA_DRU_EXIT),
/* 3114*/ DEF_VALS1(MQCACF_SYSP_OTMA_TPIPE_PFX),
/* 3115*/ DEF_VALS1(MQCACF_SYSP_ARCHIVE_PFX1),
/* 3116*/ DEF_VALS1(MQCACF_SYSP_ARCHIVE_UNIT1),
/* 3117*/ DEF_VALS1(MQCACF_SYSP_LOG_CORREL_ID),
/* 3118*/ DEF_VALS1(MQCACF_SYSP_UNIT_VOLSER),
/* 3119*/ DEF_VALS1(MQCACF_SYSP_Q_MGR_TIME),
/* 3120*/ DEF_VALS1(MQCACF_SYSP_Q_MGR_DATE),
/* 3121*/ DEF_VALS1(MQCACF_SYSP_Q_MGR_RBA),
/* 3122*/ DEF_VALS1(MQCACF_SYSP_LOG_RBA),
/* 3123*/ DEF_VALS1(MQCACF_SYSP_SERVICE),
/* 3124*/ DEF_VALS1(MQCACF_FROM_LISTENER_NAME),
/* 3125*/ DEF_VALS1(MQCACF_TO_LISTENER_NAME),
/* 3126*/ DEF_VALS1(MQCACF_FROM_SERVICE_NAME),
/* 3127*/ DEF_VALS1(MQCACF_TO_SERVICE_NAME),
/* 3128*/ DEF_VALS1(MQCACF_LAST_PUT_DATE),
/* 3129*/ DEF_VALS1(MQCACF_LAST_PUT_TIME),
/* 3130*/ DEF_VALS1(MQCACF_LAST_GET_DATE),
/* 3131*/ DEF_VALS1(MQCACF_LAST_GET_TIME),
/* 3132*/ DEF_VALS1(MQCACF_OPERATION_DATE),
/* 3133*/ DEF_VALS1(MQCACF_OPERATION_TIME),
/* 3134*/ DEF_VALS1(MQCACF_ACTIVITY_DESC),
/* 3135*/ DEF_VALS1(MQCACF_APPL_IDENTITY_DATA),
/* 3136*/ DEF_VALS1(MQCACF_APPL_ORIGIN_DATA),
/* 3137*/ DEF_VALS1(MQCACF_PUT_DATE),
/* 3138*/ DEF_VALS1(MQCACF_PUT_TIME),
/* 3139*/ DEF_VALS1(MQCACF_REPLY_TO_Q),
/* 3140*/ DEF_VALS1(MQCACF_REPLY_TO_Q_MGR),
/* 3141*/ DEF_VALS1(MQCACF_RESOLVED_Q_NAME),
/* 3142*/ DEF_VALS1(MQCACF_STRUC_ID),
/* 3143*/ DEF_VALS1(MQCACF_VALUE_NAME),
/* 3144*/ DEF_VALS1(MQCACF_SERVICE_START_DATE),
/* 3145*/ DEF_VALS1(MQCACF_SERVICE_START_TIME),
/* 3146*/ DEF_VALS1(MQCACF_SYSP_OFFLINE_RBA),
/* 3147*/ DEF_VALS1(MQCACF_SYSP_ARCHIVE_PFX2),
/* 3148*/ DEF_VALS1(MQCACF_SYSP_ARCHIVE_UNIT2),
/* 3149*/ DEF_VALS1(MQCACF_TO_TOPIC_NAME),
/* 3150*/ DEF_VALS1(MQCACF_FROM_TOPIC_NAME),
/* 3151*/ DEF_VALS1(MQCACF_TOPIC_NAMES),
/* 3152*/ DEF_VALS1(MQCACF_SUB_NAME),
/* 3153*/ DEF_VALS1(MQCACF_DESTINATION_Q_MGR),
/* 3154*/ DEF_VALS1(MQCACF_DESTINATION),
/* 3156*/ DEF_VALS1(MQCACF_SUB_USER_ID),
/* 3159*/ DEF_VALS1(MQCACF_SUB_USER_DATA),
/* 3160*/ DEF_VALS1(MQCACF_SUB_SELECTOR),
/* 3161*/ DEF_VALS1(MQCACF_LAST_PUB_DATE),
/* 3162*/ DEF_VALS1(MQCACF_LAST_PUB_TIME),
/* 3163*/ DEF_VALS1(MQCACF_FROM_SUB_NAME),
/* 3164*/ DEF_VALS1(MQCACF_TO_SUB_NAME),
/* 3167*/ DEF_VALS1(MQCACF_LAST_MSG_TIME),
/* 3168*/ DEF_VALS1(MQCACF_LAST_MSG_DATE),
/* 3169*/ DEF_VALS1(MQCACF_SUBSCRIPTION_POINT),
/* 3170*/ DEF_VALS1(MQCACF_FILTER),
/* 3171*/ DEF_VALS1(MQCACF_NONE),
/* 3172*/ DEF_VALS1(MQCACF_ADMIN_TOPIC_NAMES),
/* 3172*/ DEF_VALS1(MQCACF_ADMIN_TOPIC_NAMES),
/* 3173*/ DEF_VALS1(MQCACF_ROUTING_FINGER_PRINT),
/* 3173*/ DEF_VALS1(MQCACF_ROUTING_FINGER_PRINT),
/* 3174*/ DEF_VALS1(MQCACF_APPL_DESC),
/* 3174*/ DEF_VALS1(MQCACF_APPL_DESC),
/* 3175*/ DEF_VALS1(MQCACF_Q_MGR_START_DATE),
/* 3176*/ DEF_VALS1(MQCACF_Q_MGR_START_TIME),
/* 3177*/ DEF_VALS1(MQCACF_FROM_COMM_INFO_NAME),
/* 3178*/ DEF_VALS1(MQCACF_TO_COMM_INFO_NAME),
/* 3179*/ DEF_VALS1(MQCACF_CF_OFFLOAD_SIZE1),
/* 3180*/ DEF_VALS1(MQCACF_CF_OFFLOAD_SIZE2),
/* 3181*/ DEF_VALS1(MQCACF_CF_OFFLOAD_SIZE3),
/* 3182*/ DEF_VALS1(MQCACF_CF_SMDS_GENERIC_NAME),
/* 3183*/ DEF_VALS1(MQCACF_CF_SMDS),
/* 3184*/ DEF_VALS1(MQCACF_RECOVERY_DATE),
/* 3185*/ DEF_VALS1(MQCACF_RECOVERY_TIME),
/* 3186*/ DEF_VALS1(MQCACF_CF_SMDSCONN),
/* 3187*/ DEF_VALS1(MQCACF_CF_STRUC_NAME),
/* 3188*/ DEF_VALS1(MQCACF_ALTERNATE_USERID),
/* 3189*/ DEF_VALS1(MQCACF_CHAR_ATTRS),
/* 3190*/ DEF_VALS1(MQCACF_DYNAMIC_Q_NAME),
/* 3191*/ DEF_VALS1(MQCACF_HOST_NAME),
/* 3192*/ DEF_VALS1(MQCACF_MQCB_NAME),
/* 3193*/ DEF_VALS1(MQCACF_OBJECT_STRING),
/* 3194*/ DEF_VALS1(MQCACF_RESOLVED_LOCAL_Q_MGR),
/* 3195*/ DEF_VALS1(MQCACF_RESOLVED_LOCAL_Q_NAME),
/* 3196*/ DEF_VALS1(MQCACF_RESOLVED_OBJECT_STRING),
/* 3197*/ DEF_VALS1(MQCACF_RESOLVED_Q_MGR),
/* 3198*/ DEF_VALS1(MQCACF_SELECTION_STRING),
/* 3199*/ DEF_VALS1(MQCACF_XA_INFO),
/* 3200*/ DEF_VALS1(MQCACF_APPL_FUNCTION),
/* 3201*/ DEF_VALS1(MQCACF_XQH_REMOTE_Q_NAME),
/* 3202*/ DEF_VALS1(MQCACF_XQH_REMOTE_Q_MGR),
/* 3203*/ DEF_VALS1(MQCACF_XQH_PUT_TIME),
/* 3204*/ DEF_VALS1(MQCACF_XQH_PUT_DATE),
/* 3205*/ DEF_VALS1(MQCACF_EXCL_OPERATOR_MESSAGES),
/* 3206*/ DEF_VALS1(MQCACF_CSP_USER_IDENTIFIER),
/* 3207*/ DEF_VALS1(MQCACF_AMQP_CLIENT_ID),
/* 3208*/ DEF_VALS1(MQCACF_ARCHIVE_LOG_EXTENT_NAME),
/* 3501*/ DEF_VALS1(MQCACH_CHANNEL_NAME),
/* 3502*/ DEF_VALS1(MQCACH_DESC),
/* 3503*/ DEF_VALS1(MQCACH_MODE_NAME),
/* 3504*/ DEF_VALS1(MQCACH_TP_NAME),
/* 3505*/ DEF_VALS1(MQCACH_XMIT_Q_NAME),
/* 3506*/ DEF_VALS1(MQCACH_CONNECTION_NAME),
/* 3507*/ DEF_VALS1(MQCACH_MCA_NAME),
/* 3508*/ DEF_VALS1(MQCACH_SEC_EXIT_NAME),
/* 3509*/ DEF_VALS1(MQCACH_MSG_EXIT_NAME),
/* 3510*/ DEF_VALS1(MQCACH_SEND_EXIT_NAME),
/* 3511*/ DEF_VALS1(MQCACH_RCV_EXIT_NAME),
/* 3512*/ DEF_VALS1(MQCACH_CHANNEL_NAMES),
/* 3513*/ DEF_VALS1(MQCACH_SEC_EXIT_USER_DATA),
/* 3514*/ DEF_VALS1(MQCACH_MSG_EXIT_USER_DATA),
/* 3515*/ DEF_VALS1(MQCACH_SEND_EXIT_USER_DATA),
/* 3516*/ DEF_VALS1(MQCACH_RCV_EXIT_USER_DATA),
/* 3517*/ DEF_VALS1(MQCACH_USER_ID),
/* 3518*/ DEF_VALS1(MQCACH_PASSWORD),
/* 3520*/ DEF_VALS1(MQCACH_LOCAL_ADDRESS),
/* 3521*/ DEF_VALS1(MQCACH_LOCAL_NAME),
/* 3524*/ DEF_VALS1(MQCACH_LAST_MSG_TIME),
/* 3525*/ DEF_VALS1(MQCACH_LAST_MSG_DATE),
/* 3527*/ DEF_VALS1(MQCACH_MCA_USER_ID),
/* 3528*/ DEF_VALS1(MQCACH_CHANNEL_START_TIME),
/* 3529*/ DEF_VALS1(MQCACH_CHANNEL_START_DATE),
/* 3530*/ DEF_VALS1(MQCACH_MCA_JOB_NAME),
/* 3531*/ DEF_VALS1(MQCACH_LAST_LUWID),
/* 3532*/ DEF_VALS1(MQCACH_CURRENT_LUWID),
/* 3533*/ DEF_VALS1(MQCACH_FORMAT_NAME),
/* 3534*/ DEF_VALS1(MQCACH_MR_EXIT_NAME),
/* 3535*/ DEF_VALS1(MQCACH_MR_EXIT_USER_DATA),
/* 3544*/ DEF_VALS1(MQCACH_SSL_CIPHER_SPEC),
/* 3545*/ DEF_VALS1(MQCACH_SSL_PEER_NAME),
/* 3546*/ DEF_VALS1(MQCACH_SSL_HANDSHAKE_STAGE),
/* 3547*/ DEF_VALS1(MQCACH_SSL_SHORT_PEER_NAME),
/* 3548*/ DEF_VALS1(MQCACH_REMOTE_APPL_TAG),
/* 3549*/ DEF_VALS1(MQCACH_SSL_CERT_USER_ID),
/* 3550*/ DEF_VALS1(MQCACH_SSL_CERT_ISSUER_NAME),
/* 3551*/ DEF_VALS1(MQCACH_LU_NAME),
/* 3552*/ DEF_VALS1(MQCACH_IP_ADDRESS),
/* 3553*/ DEF_VALS1(MQCACH_TCP_NAME),
/* 3554*/ DEF_VALS1(MQCACH_LISTENER_NAME),
/* 3555*/ DEF_VALS1(MQCACH_LISTENER_DESC),
/* 3556*/ DEF_VALS1(MQCACH_LISTENER_START_DATE),
/* 3557*/ DEF_VALS1(MQCACH_LISTENER_START_TIME),
/* 3558*/ DEF_VALS1(MQCACH_SSL_KEY_RESET_DATE),
/* 3559*/ DEF_VALS1(MQCACH_SSL_KEY_RESET_TIME),
/* 3560*/ DEF_VALS1(MQCACH_REMOTE_VERSION),
/* 3561*/ DEF_VALS1(MQCACH_REMOTE_PRODUCT),
/* 3562*/ DEF_VALS1(MQCACH_GROUP_ADDRESS),
/* 3563*/ DEF_VALS1(MQCACH_JAAS_CONFIG),
/* 3564*/ DEF_VALS1(MQCACH_CLIENT_ID),
/* 3565*/ DEF_VALS1(MQCACH_SSL_KEY_PASSPHRASE),
/* 3566*/ DEF_VALS1(MQCACH_CONNECTION_NAME_LIST),
/* 3567*/ DEF_VALS1(MQCACH_CLIENT_USER_ID),
/* 3568*/ DEF_VALS1(MQCACH_MCA_USER_ID_LIST),
/* 3569*/ DEF_VALS1(MQCACH_SSL_CIPHER_SUITE),
/* 3570*/ DEF_VALS1(MQCACH_WEBCONTENT_PATH),
/* 3571*/ DEF_VALS1(MQCACH_TOPIC_ROOT),
/* 4000*/ DEF_VALS1(MQCA_USER_LIST),
/* 7001*/ DEF_VALS1(MQBACF_EVENT_ACCOUNTING_TOKEN),
/* 7002*/ DEF_VALS1(MQBACF_EVENT_SECURITY_ID),
/* 7003*/ DEF_VALS1(MQBACF_RESPONSE_SET),
/* 7004*/ DEF_VALS1(MQBACF_RESPONSE_ID),
/* 7005*/ DEF_VALS1(MQBACF_EXTERNAL_UOW_ID),
/* 7006*/ DEF_VALS1(MQBACF_CONNECTION_ID),
/* 7007*/ DEF_VALS1(MQBACF_GENERIC_CONNECTION_ID),
/* 7008*/ DEF_VALS1(MQBACF_ORIGIN_UOW_ID),
/* 7009*/ DEF_VALS1(MQBACF_Q_MGR_UOW_ID),
/* 7010*/ DEF_VALS1(MQBACF_ACCOUNTING_TOKEN),
/* 7011*/ DEF_VALS1(MQBACF_CORREL_ID),
/* 7012*/ DEF_VALS1(MQBACF_GROUP_ID),
/* 7013*/ DEF_VALS1(MQBACF_MSG_ID),
/* 7014*/ DEF_VALS1(MQBACF_CF_LEID),
/* 7015*/ DEF_VALS1(MQBACF_DESTINATION_CORREL_ID),
/* 7016*/ DEF_VALS1(MQBACF_SUB_ID),
/* 7019*/ DEF_VALS1(MQBACF_ALTERNATE_SECURITYID),
/* 7020*/ DEF_VALS1(MQBACF_MESSAGE_DATA),
/* 7021*/ DEF_VALS1(MQBACF_MQBO_STRUCT),
/* 7022*/ DEF_VALS1(MQBACF_MQCB_FUNCTION),
/* 7023*/ DEF_VALS1(MQBACF_MQCBC_STRUCT),
/* 7024*/ DEF_VALS1(MQBACF_MQCBD_STRUCT),
/* 7025*/ DEF_VALS1(MQBACF_MQCD_STRUCT),
/* 7026*/ DEF_VALS1(MQBACF_MQCNO_STRUCT),
/* 7027*/ DEF_VALS1(MQBACF_MQGMO_STRUCT),
/* 7028*/ DEF_VALS1(MQBACF_MQMD_STRUCT),
/* 7029*/ DEF_VALS1(MQBACF_MQPMO_STRUCT),
/* 7030*/ DEF_VALS1(MQBACF_MQSD_STRUCT),
/* 7031*/ DEF_VALS1(MQBACF_MQSTS_STRUCT),
/* 7032*/ DEF_VALS1(MQBACF_SUB_CORREL_ID),
/* 7033*/ DEF_VALS1(MQBACF_XA_XID),
/* 7034*/ DEF_VALS1(MQBACF_XQH_CORREL_ID),
/* 7035*/ DEF_VALS1(MQBACF_XQH_MSG_ID),
/* 7036*/ DEF_VALS1(MQBACF_REQUEST_ID),
/* 7037*/ DEF_VALS1(MQBACF_PROPERTIES_DATA),
/* 7038*/ DEF_VALS1(MQBACF_CONN_TAG),
/* 8001*/ DEF_VALS1(MQGACF_COMMAND_CONTEXT),
/* 8002*/ DEF_VALS1(MQGACF_COMMAND_DATA),
/* 8003*/ DEF_VALS1(MQGACF_TRACE_ROUTE),
/* 8004*/ DEF_VALS1(MQGACF_OPERATION),
/* 8005*/ DEF_VALS1(MQGACF_ACTIVITY),
/* 8006*/ DEF_VALS1(MQGACF_EMBEDDED_MQMD),
/* 8007*/ DEF_VALS1(MQGACF_MESSAGE),
/* 8008*/ DEF_VALS1(MQGACF_MQMD),
/* 8009*/ DEF_VALS1(MQGACF_VALUE_NAMING),
/* 8010*/ DEF_VALS1(MQGACF_Q_ACCOUNTING_DATA),
/* 8011*/ DEF_VALS1(MQGACF_Q_STATISTICS_DATA),
/* 8012*/ DEF_VALS1(MQGACF_CHL_STATISTICS_DATA),
/* 8013*/ DEF_VALS1(MQGACF_ACTIVITY_TRACE),
/* 8014*/ DEF_VALS1(MQGACF_APP_DIST_LIST),
/* 8015*/ DEF_VALS1(MQGACF_MONITOR_CLASS),
/* 8016*/ DEF_VALS1(MQGACF_MONITOR_TYPE),
/* 8017*/ DEF_VALS1(MQGACF_MONITOR_ELEMENT),
DEF_VALSE;
DEF_VALS_EXTBX(PrmId);

DEF_VALSB(PrmTyp)
/*    0*/ DEF_VALS1(MQCFT_NONE),
/*    1*/ DEF_VALS1(MQCFT_COMMAND),
/*    2*/ DEF_VALS1(MQCFT_RESPONSE),
/*    3*/ DEF_VALS1(MQCFT_INTEGER),
/*    4*/ DEF_VALS1(MQCFT_STRING),
/*    5*/ DEF_VALS1(MQCFT_INTEGER_LIST),
/*    6*/ DEF_VALS1(MQCFT_STRING_LIST),
/*    7*/ DEF_VALS1(MQCFT_EVENT),
/*    8*/ DEF_VALS1(MQCFT_USER),
/*    9*/ DEF_VALS1(MQCFT_BYTE_STRING),
/*   10*/ DEF_VALS1(MQCFT_TRACE_ROUTE),
/*   12*/ DEF_VALS1(MQCFT_REPORT),
/*   13*/ DEF_VALS1(MQCFT_INTEGER_FILTER),
/*   14*/ DEF_VALS1(MQCFT_STRING_FILTER),
/*   15*/ DEF_VALS1(MQCFT_BYTE_STRING_FILTER),
/*   16*/ DEF_VALS1(MQCFT_COMMAND_XR),
/*   17*/ DEF_VALS1(MQCFT_XR_MSG),
/*   18*/ DEF_VALS1(MQCFT_XR_ITEM),
/*   19*/ DEF_VALS1(MQCFT_XR_SUMMARY),
/*   20*/ DEF_VALS1(MQCFT_GROUP),
/*   21*/ DEF_VALS1(MQCFT_STATISTICS),
/*   22*/ DEF_VALS1(MQCFT_ACCOUNTING),
/*   23*/ DEF_VALS1(MQCFT_INTEGER64),
/*   25*/ DEF_VALS1(MQCFT_INTEGER64_LIST),
DEF_VALSE;
DEF_VALS_EXTBX(PrmTyp);

DEF_VALSB(PrmTyp2)
/*    0*/ DEF_VALS1(MQCFT_NONE),
/*    1*/ DEF_VALS1(MQCFT_CMD),
/*    2*/ DEF_VALS1(MQCFT_RSP),
/*    3*/ DEF_VALS1(MQCFT_INT),
/*    4*/ DEF_VALS1(MQCFT_STR),
/*    5*/ DEF_VALS1(MQCFT_INTL),
/*    6*/ DEF_VALS1(MQCFT_STRL),
/*    7*/ DEF_VALS1(MQCFT_EVT),
/*    8*/ DEF_VALS1(MQCFT_USR),
/*    9*/ DEF_VALS1(MQCFT_BSTR),
/*   10*/ DEF_VALS1(MQCFT_TRC),
/*   12*/ DEF_VALS1(MQCFT_RPT),
/*   13*/ DEF_VALS1(MQCFT_INTF),
/*   14*/ DEF_VALS1(MQCFT_STRF),
/*   15*/ DEF_VALS1(MQCFT_BSTF),
/*   16*/ DEF_VALS1(MQCFT_CMDX),
/*   17*/ DEF_VALS1(MQCFT_XMSG),
/*   18*/ DEF_VALS1(MQCFT_XITM),
/*   19*/ DEF_VALS1(MQCFT_XSUM),
/*   20*/ DEF_VALS1(MQCFT_GRP),
/*   21*/ DEF_VALS1(MQCFT_STAT),
/*   22*/ DEF_VALS1(MQCFT_ACNT),
/*   23*/ DEF_VALS1(MQCFT_I64),
/*   25*/ DEF_VALS1(MQCFT_I64L),
DEF_VALSE;
DEF_VALS_EXTBX(PrmTyp2);

DEF_VALSB(selector)
/*    1*/ DEF_VALS1(MQIA_APPL_TYPE),
/*    2*/ DEF_VALS1(MQIA_CODED_CHAR_SET_ID),
/*    3*/ DEF_VALS1(MQIA_CURRENT_Q_DEPTH),
/*    4*/ DEF_VALS1(MQIA_DEF_INPUT_OPEN_OPTION),
/*    5*/ DEF_VALS1(MQIA_DEF_PERSISTENCE),
/*    6*/ DEF_VALS1(MQIA_DEF_PRIORITY),
/*    7*/ DEF_VALS1(MQIA_DEFINITION_TYPE),
/*    8*/ DEF_VALS1(MQIA_HARDEN_GET_BACKOUT),
/*    9*/ DEF_VALS1(MQIA_INHIBIT_GET),
/*   10*/ DEF_VALS1(MQIA_INHIBIT_PUT),
/*   11*/ DEF_VALS1(MQIA_MAX_HANDLES),
/*   12*/ DEF_VALS1(MQIA_USAGE),
/*   13*/ DEF_VALS1(MQIA_MAX_MSG_LENGTH),
/*   14*/ DEF_VALS1(MQIA_MAX_PRIORITY),
/*   15*/ DEF_VALS1(MQIA_MAX_Q_DEPTH),
/*   16*/ DEF_VALS1(MQIA_MSG_DELIVERY_SEQUENCE),
/*   17*/ DEF_VALS1(MQIA_OPEN_INPUT_COUNT),
/*   18*/ DEF_VALS1(MQIA_OPEN_OUTPUT_COUNT),
/*   19*/ DEF_VALS1(MQIA_NAME_COUNT),
/*   20*/ DEF_VALS1(MQIA_Q_TYPE),
/*   21*/ DEF_VALS1(MQIA_RETENTION_INTERVAL),
/*   22*/ DEF_VALS1(MQIA_BACKOUT_THRESHOLD),
/*   23*/ DEF_VALS1(MQIA_SHAREABILITY),
/*   24*/ DEF_VALS1(MQIA_TRIGGER_CONTROL),
/*   25*/ DEF_VALS1(MQIA_TRIGGER_INTERVAL),
/*   26*/ DEF_VALS1(MQIA_TRIGGER_MSG_PRIORITY),
/*   27*/ DEF_VALS1(MQIA_CPI_LEVEL),
/*   28*/ DEF_VALS1(MQIA_TRIGGER_TYPE),
/*   29*/ DEF_VALS1(MQIA_TRIGGER_DEPTH),
/*   30*/ DEF_VALS1(MQIA_SYNCPOINT),
/*   31*/ DEF_VALS1(MQIA_COMMAND_LEVEL),
/*   32*/ DEF_VALS1(MQIA_PLATFORM),
/*   33*/ DEF_VALS1(MQIA_MAX_UNCOMMITTED_MSGS),
/*   34*/ DEF_VALS1(MQIA_DIST_LISTS),
/*   35*/ DEF_VALS1(MQIA_TIME_SINCE_RESET),
/*   36*/ DEF_VALS1(MQIA_HIGH_Q_DEPTH),
/*   37*/ DEF_VALS1(MQIA_MSG_ENQ_COUNT),
/*   38*/ DEF_VALS1(MQIA_MSG_DEQ_COUNT),
/*   39*/ DEF_VALS1(MQIA_EXPIRY_INTERVAL),
/*   40*/ DEF_VALS1(MQIA_Q_DEPTH_HIGH_LIMIT),
/*   41*/ DEF_VALS1(MQIA_Q_DEPTH_LOW_LIMIT),
/*   42*/ DEF_VALS1(MQIA_Q_DEPTH_MAX_EVENT),
/*   43*/ DEF_VALS1(MQIA_Q_DEPTH_HIGH_EVENT),
/*   44*/ DEF_VALS1(MQIA_Q_DEPTH_LOW_EVENT),
/*   45*/ DEF_VALS1(MQIA_SCOPE),
/*   46*/ DEF_VALS1(MQIA_Q_SERVICE_INTERVAL_EVENT),
/*   47*/ DEF_VALS1(MQIA_AUTHORITY_EVENT),
/*   48*/ DEF_VALS1(MQIA_INHIBIT_EVENT),
/*   49*/ DEF_VALS1(MQIA_LOCAL_EVENT),
/*   50*/ DEF_VALS1(MQIA_REMOTE_EVENT),
/*   51*/ DEF_VALS1(MQIA_CONFIGURATION_EVENT),
/*   52*/ DEF_VALS1(MQIA_START_STOP_EVENT),
/*   53*/ DEF_VALS1(MQIA_PERFORMANCE_EVENT),
/*   54*/ DEF_VALS1(MQIA_Q_SERVICE_INTERVAL),
/*   55*/ DEF_VALS1(MQIA_CHANNEL_AUTO_DEF),
/*   56*/ DEF_VALS1(MQIA_CHANNEL_AUTO_DEF_EVENT),
/*   57*/ DEF_VALS1(MQIA_INDEX_TYPE),
/*   58*/ DEF_VALS1(MQIA_CLUSTER_WORKLOAD_LENGTH),
/*   59*/ DEF_VALS1(MQIA_CLUSTER_Q_TYPE),
/*   60*/ DEF_VALS1(MQIA_ARCHIVE),
/*   61*/ DEF_VALS1(MQIA_DEF_BIND),
/*   62*/ DEF_VALS1(MQIA_PAGESET_ID),
/*   63*/ DEF_VALS1(MQIA_QSG_DISP),
/*   64*/ DEF_VALS1(MQIA_INTRA_GROUP_QUEUING),
/*   65*/ DEF_VALS1(MQIA_IGQ_PUT_AUTHORITY),
/*   66*/ DEF_VALS1(MQIA_AUTH_INFO_TYPE),
/*   68*/ DEF_VALS1(MQIA_MSG_MARK_BROWSE_INTERVAL),
/*   69*/ DEF_VALS1(MQIA_SSL_TASKS),
/*   70*/ DEF_VALS1(MQIA_CF_LEVEL),
/*   71*/ DEF_VALS1(MQIA_CF_RECOVER),
/*   72*/ DEF_VALS1(MQIA_NAMELIST_TYPE),
/*   73*/ DEF_VALS1(MQIA_CHANNEL_EVENT),
/*   74*/ DEF_VALS1(MQIA_BRIDGE_EVENT),
/*   75*/ DEF_VALS1(MQIA_SSL_EVENT),
/*   76*/ DEF_VALS1(MQIA_SSL_RESET_COUNT),
/*   77*/ DEF_VALS1(MQIA_SHARED_Q_Q_MGR_NAME),
/*   78*/ DEF_VALS1(MQIA_NPM_CLASS),
/*   80*/ DEF_VALS1(MQIA_MAX_OPEN_Q),
/*   81*/ DEF_VALS1(MQIA_MONITOR_INTERVAL),
/*   82*/ DEF_VALS1(MQIA_Q_USERS),
/*   83*/ DEF_VALS1(MQIA_MAX_GLOBAL_LOCKS),
/*   84*/ DEF_VALS1(MQIA_MAX_LOCAL_LOCKS),
/*   85*/ DEF_VALS1(MQIA_LISTENER_PORT_NUMBER),
/*   86*/ DEF_VALS1(MQIA_BATCH_INTERFACE_AUTO),
/*   87*/ DEF_VALS1(MQIA_CMD_SERVER_AUTO),
/*   88*/ DEF_VALS1(MQIA_CMD_SERVER_CONVERT_MSG),
/*   89*/ DEF_VALS1(MQIA_CMD_SERVER_DLQ_MSG),
/*   90*/ DEF_VALS1(MQIA_MAX_Q_TRIGGERS),
/*   91*/ DEF_VALS1(MQIA_TRIGGER_RESTART),
/*   92*/ DEF_VALS1(MQIA_SSL_FIPS_REQUIRED),
/*   93*/ DEF_VALS1(MQIA_IP_ADDRESS_VERSION),
/*   94*/ DEF_VALS1(MQIA_LOGGER_EVENT),
/*   95*/ DEF_VALS1(MQIA_CLWL_Q_RANK),
/*   96*/ DEF_VALS1(MQIA_CLWL_Q_PRIORITY),
/*   97*/ DEF_VALS1(MQIA_CLWL_MRU_CHANNELS),
/*   98*/ DEF_VALS1(MQIA_CLWL_USEQ),
/*   99*/ DEF_VALS1(MQIA_COMMAND_EVENT),
/*  100*/ DEF_VALS1(MQIA_ACTIVE_CHANNELS),
/*  101*/ DEF_VALS1(MQIA_CHINIT_ADAPTERS),
/*  102*/ DEF_VALS1(MQIA_ADOPTNEWMCA_CHECK),
/*  103*/ DEF_VALS1(MQIA_ADOPTNEWMCA_TYPE),
/*  104*/ DEF_VALS1(MQIA_ADOPTNEWMCA_INTERVAL),
/*  105*/ DEF_VALS1(MQIA_CHINIT_DISPATCHERS),
/*  106*/ DEF_VALS1(MQIA_DNS_WLM),
/*  107*/ DEF_VALS1(MQIA_LISTENER_TIMER),
/*  108*/ DEF_VALS1(MQIA_LU62_CHANNELS),
/*  109*/ DEF_VALS1(MQIA_MAX_CHANNELS),
/*  110*/ DEF_VALS1(MQIA_OUTBOUND_PORT_MIN),
/*  111*/ DEF_VALS1(MQIA_RECEIVE_TIMEOUT),
/*  112*/ DEF_VALS1(MQIA_RECEIVE_TIMEOUT_TYPE),
/*  113*/ DEF_VALS1(MQIA_RECEIVE_TIMEOUT_MIN),
/*  114*/ DEF_VALS1(MQIA_TCP_CHANNELS),
/*  115*/ DEF_VALS1(MQIA_TCP_KEEP_ALIVE),
/*  116*/ DEF_VALS1(MQIA_TCP_STACK_TYPE),
/*  117*/ DEF_VALS1(MQIA_CHINIT_TRACE_AUTO_START),
/*  118*/ DEF_VALS1(MQIA_CHINIT_TRACE_TABLE_SIZE),
/*  119*/ DEF_VALS1(MQIA_CHINIT_CONTROL),
/*  120*/ DEF_VALS1(MQIA_CMD_SERVER_CONTROL),
/*  121*/ DEF_VALS1(MQIA_SERVICE_TYPE),
/*  122*/ DEF_VALS1(MQIA_MONITORING_CHANNEL),
/*  123*/ DEF_VALS1(MQIA_MONITORING_Q),
/*  124*/ DEF_VALS1(MQIA_MONITORING_AUTO_CLUSSDR),
/*  127*/ DEF_VALS1(MQIA_STATISTICS_MQI),
/*  128*/ DEF_VALS1(MQIA_STATISTICS_Q),
/*  129*/ DEF_VALS1(MQIA_STATISTICS_CHANNEL),
/*  130*/ DEF_VALS1(MQIA_STATISTICS_AUTO_CLUSSDR),
/*  131*/ DEF_VALS1(MQIA_STATISTICS_INTERVAL),
/*  133*/ DEF_VALS1(MQIA_ACCOUNTING_MQI),
/*  134*/ DEF_VALS1(MQIA_ACCOUNTING_Q),
/*  135*/ DEF_VALS1(MQIA_ACCOUNTING_INTERVAL),
/*  136*/ DEF_VALS1(MQIA_ACCOUNTING_CONN_OVERRIDE),
/*  137*/ DEF_VALS1(MQIA_TRACE_ROUTE_RECORDING),
/*  138*/ DEF_VALS1(MQIA_ACTIVITY_RECORDING),
/*  139*/ DEF_VALS1(MQIA_SERVICE_CONTROL),
/*  140*/ DEF_VALS1(MQIA_OUTBOUND_PORT_MAX),
/*  141*/ DEF_VALS1(MQIA_SECURITY_CASE),
/*  150*/ DEF_VALS1(MQIA_QMOPT_CSMT_ON_ERROR),
/*  151*/ DEF_VALS1(MQIA_QMOPT_CONS_INFO_MSGS),
/*  152*/ DEF_VALS1(MQIA_QMOPT_CONS_WARNING_MSGS),
/*  153*/ DEF_VALS1(MQIA_QMOPT_CONS_ERROR_MSGS),
/*  154*/ DEF_VALS1(MQIA_QMOPT_CONS_CRITICAL_MSGS),
/*  155*/ DEF_VALS1(MQIA_QMOPT_CONS_COMMS_MSGS),
/*  156*/ DEF_VALS1(MQIA_QMOPT_CONS_REORG_MSGS),
/*  157*/ DEF_VALS1(MQIA_QMOPT_CONS_SYSTEM_MSGS),
/*  158*/ DEF_VALS1(MQIA_QMOPT_LOG_INFO_MSGS),
/*  159*/ DEF_VALS1(MQIA_QMOPT_LOG_WARNING_MSGS),
/*  160*/ DEF_VALS1(MQIA_QMOPT_LOG_ERROR_MSGS),
/*  161*/ DEF_VALS1(MQIA_QMOPT_LOG_CRITICAL_MSGS),
/*  162*/ DEF_VALS1(MQIA_QMOPT_LOG_COMMS_MSGS),
/*  163*/ DEF_VALS1(MQIA_QMOPT_LOG_REORG_MSGS),
/*  164*/ DEF_VALS1(MQIA_QMOPT_LOG_SYSTEM_MSGS),
/*  165*/ DEF_VALS1(MQIA_QMOPT_TRACE_MQI_CALLS),
/*  166*/ DEF_VALS1(MQIA_QMOPT_TRACE_COMMS),
/*  167*/ DEF_VALS1(MQIA_QMOPT_TRACE_REORG),
/*  168*/ DEF_VALS1(MQIA_QMOPT_TRACE_CONVERSION),
/*  169*/ DEF_VALS1(MQIA_QMOPT_TRACE_SYSTEM),
/*  170*/ DEF_VALS1(MQIA_QMOPT_INTERNAL_DUMP),
/*  171*/ DEF_VALS1(MQIA_MAX_RECOVERY_TASKS),
/*  172*/ DEF_VALS1(MQIA_MAX_CLIENTS),
/*  173*/ DEF_VALS1(MQIA_AUTO_REORGANIZATION),
/*  174*/ DEF_VALS1(MQIA_AUTO_REORG_INTERVAL),
/*  175*/ DEF_VALS1(MQIA_DURABLE_SUB),
/*  176*/ DEF_VALS1(MQIA_MULTICAST),
/*  181*/ DEF_VALS1(MQIA_INHIBIT_PUB),
/*  182*/ DEF_VALS1(MQIA_INHIBIT_SUB),
/*  183*/ DEF_VALS1(MQIA_TREE_LIFE_TIME),
/*  184*/ DEF_VALS1(MQIA_DEF_PUT_RESPONSE_TYPE),
/*  185*/ DEF_VALS1(MQIA_TOPIC_DEF_PERSISTENCE),
/*  186*/ DEF_VALS1(MQIA_MASTER_ADMIN),
/*  187*/ DEF_VALS1(MQIA_PUBSUB_MODE),
/*  188*/ DEF_VALS1(MQIA_DEF_READ_AHEAD),
/*  189*/ DEF_VALS1(MQIA_READ_AHEAD),
/*  190*/ DEF_VALS1(MQIA_PROPERTY_CONTROL),
/*  192*/ DEF_VALS1(MQIA_MAX_PROPERTIES_LENGTH),
/*  193*/ DEF_VALS1(MQIA_BASE_TYPE),
/*  195*/ DEF_VALS1(MQIA_PM_DELIVERY),
/*  196*/ DEF_VALS1(MQIA_NPM_DELIVERY),
/*  199*/ DEF_VALS1(MQIA_PROXY_SUB),
/*  203*/ DEF_VALS1(MQIA_PUBSUB_NP_MSG),
/*  204*/ DEF_VALS1(MQIA_SUB_COUNT),
/*  205*/ DEF_VALS1(MQIA_PUBSUB_NP_RESP),
/*  206*/ DEF_VALS1(MQIA_PUBSUB_MAXMSG_RETRY_COUNT),
/*  207*/ DEF_VALS1(MQIA_PUBSUB_SYNC_PT),
/*  208*/ DEF_VALS1(MQIA_TOPIC_TYPE),
/*  215*/ DEF_VALS1(MQIA_PUB_COUNT),
/*  216*/ DEF_VALS1(MQIA_WILDCARD_OPERATION),
/*  218*/ DEF_VALS1(MQIA_SUB_SCOPE),
/*  219*/ DEF_VALS1(MQIA_PUB_SCOPE),
/*  221*/ DEF_VALS1(MQIA_GROUP_UR),
/*  222*/ DEF_VALS1(MQIA_UR_DISP),
/*  223*/ DEF_VALS1(MQIA_COMM_INFO_TYPE),
/*  224*/ DEF_VALS1(MQIA_CF_OFFLOAD),
/*  225*/ DEF_VALS1(MQIA_CF_OFFLOAD_THRESHOLD1),
/*  226*/ DEF_VALS1(MQIA_CF_OFFLOAD_THRESHOLD2),
/*  227*/ DEF_VALS1(MQIA_CF_OFFLOAD_THRESHOLD3),
/*  228*/ DEF_VALS1(MQIA_CF_SMDS_BUFFERS),
/*  229*/ DEF_VALS1(MQIA_CF_OFFLDUSE),
/*  230*/ DEF_VALS1(MQIA_MAX_RESPONSES),
/*  231*/ DEF_VALS1(MQIA_RESPONSE_RESTART_POINT),
/*  232*/ DEF_VALS1(MQIA_COMM_EVENT),
/*  233*/ DEF_VALS1(MQIA_MCAST_BRIDGE),
/*  234*/ DEF_VALS1(MQIA_USE_DEAD_LETTER_Q),
/*  235*/ DEF_VALS1(MQIA_TOLERATE_UNPROTECTED),
/*  236*/ DEF_VALS1(MQIA_SIGNATURE_ALGORITHM),
/*  237*/ DEF_VALS1(MQIA_ENCRYPTION_ALGORITHM),
/*  238*/ DEF_VALS1(MQIA_POLICY_VERSION),
/*  239*/ DEF_VALS1(MQIA_ACTIVITY_CONN_OVERRIDE),
/*  240*/ DEF_VALS1(MQIA_ACTIVITY_TRACE),
/*  242*/ DEF_VALS1(MQIA_SUB_CONFIGURATION_EVENT),
/*  243*/ DEF_VALS1(MQIA_XR_CAPABILITY),
/*  244*/ DEF_VALS1(MQIA_CF_RECAUTO),
/*  245*/ DEF_VALS1(MQIA_QMGR_CFCONLOS),
/*  246*/ DEF_VALS1(MQIA_CF_CFCONLOS),
/*  247*/ DEF_VALS1(MQIA_SUITE_B_STRENGTH),
/*  248*/ DEF_VALS1(MQIA_CHLAUTH_RECORDS),
/*  249*/ DEF_VALS1(MQIA_PUBSUB_CLUSTER),
/*  250*/ DEF_VALS1(MQIA_DEF_CLUSTER_XMIT_Q_TYPE),
/*  251*/ DEF_VALS1(MQIA_PROT_POLICY_CAPABILITY),
/*  252*/ DEF_VALS1(MQIA_CERT_VAL_POLICY),
/*  253*/ DEF_VALS1(MQIA_TOPIC_NODE_COUNT),
/*  254*/ DEF_VALS1(MQIA_REVERSE_DNS_LOOKUP),
/*  255*/ DEF_VALS1(MQIA_CLUSTER_PUB_ROUTE),
/*  256*/ DEF_VALS1(MQIA_CLUSTER_OBJECT_STATE),
/*  257*/ DEF_VALS1(MQIA_CHECK_LOCAL_BINDING),
/*  258*/ DEF_VALS1(MQIA_CHECK_CLIENT_BINDING),
/*  259*/ DEF_VALS1(MQIA_AUTHENTICATION_FAIL_DELAY),
/*  260*/ DEF_VALS1(MQIA_ADOPT_CONTEXT),
/*  261*/ DEF_VALS1(MQIA_LDAP_SECURE_COMM),
/*  262*/ DEF_VALS1(MQIA_DISPLAY_TYPE),
/*  263*/ DEF_VALS1(MQIA_LDAP_AUTHORMD),
/*  264*/ DEF_VALS1(MQIA_LDAP_NESTGRP),
/*  265*/ DEF_VALS1(MQIA_AMQP_CAPABILITY),
/*  266*/ DEF_VALS1(MQIA_AUTHENTICATION_METHOD),
/*  267*/ DEF_VALS1(MQIA_KEY_REUSE_COUNT),
/*  268*/ DEF_VALS1(MQIA_MEDIA_IMAGE_SCHEDULING),
/*  269*/ DEF_VALS1(MQIA_MEDIA_IMAGE_INTERVAL),
/*  270*/ DEF_VALS1(MQIA_MEDIA_IMAGE_LOG_LENGTH),
/*  271*/ DEF_VALS1(MQIA_MEDIA_IMAGE_RECOVER_OBJ),
/*  272*/ DEF_VALS1(MQIA_MEDIA_IMAGE_RECOVER_Q),
/*  273*/ DEF_VALS1(MQIA_ADVANCED_CAPABILITY),
/* 2001*/ DEF_VALS1(MQCA_APPL_ID),
/* 2001*/ DEF_VALS1(MQCA_FIRST),
/* 2002*/ DEF_VALS1(MQCA_BASE_OBJECT_NAME),
/* 2002 DEF_VALS1(MQCA_BASE_Q_NAME),*/
/* 2003*/ DEF_VALS1(MQCA_COMMAND_INPUT_Q_NAME),
/* 2004*/ DEF_VALS1(MQCA_CREATION_DATE),
/* 2005*/ DEF_VALS1(MQCA_CREATION_TIME),
/* 2006*/ DEF_VALS1(MQCA_DEAD_LETTER_Q_NAME),
/* 2007*/ DEF_VALS1(MQCA_ENV_DATA),
/* 2008*/ DEF_VALS1(MQCA_INITIATION_Q_NAME),
/* 2009*/ DEF_VALS1(MQCA_NAMELIST_DESC),
/* 2010*/ DEF_VALS1(MQCA_NAMELIST_NAME),
/* 2011*/ DEF_VALS1(MQCA_PROCESS_DESC),
/* 2012*/ DEF_VALS1(MQCA_PROCESS_NAME),
/* 2013*/ DEF_VALS1(MQCA_Q_DESC),
/* 2014*/ DEF_VALS1(MQCA_Q_MGR_DESC),
/* 2015*/ DEF_VALS1(MQCA_Q_MGR_NAME),
/* 2016*/ DEF_VALS1(MQCA_Q_NAME),
/* 2017*/ DEF_VALS1(MQCA_REMOTE_Q_MGR_NAME),
/* 2018*/ DEF_VALS1(MQCA_REMOTE_Q_NAME),
/* 2019*/ DEF_VALS1(MQCA_BACKOUT_REQ_Q_NAME),
/* 2020*/ DEF_VALS1(MQCA_NAMES),
/* 2021*/ DEF_VALS1(MQCA_USER_DATA),
/* 2022*/ DEF_VALS1(MQCA_STORAGE_CLASS),
/* 2023*/ DEF_VALS1(MQCA_TRIGGER_DATA),
/* 2024*/ DEF_VALS1(MQCA_XMIT_Q_NAME),
/* 2025*/ DEF_VALS1(MQCA_DEF_XMIT_Q_NAME),
/* 2026*/ DEF_VALS1(MQCA_CHANNEL_AUTO_DEF_EXIT),
/* 2027*/ DEF_VALS1(MQCA_ALTERATION_DATE),
/* 2028*/ DEF_VALS1(MQCA_ALTERATION_TIME),
/* 2029*/ DEF_VALS1(MQCA_CLUSTER_NAME),
/* 2030*/ DEF_VALS1(MQCA_CLUSTER_NAMELIST),
/* 2031*/ DEF_VALS1(MQCA_CLUSTER_Q_MGR_NAME),
/* 2032*/ DEF_VALS1(MQCA_Q_MGR_IDENTIFIER),
/* 2033*/ DEF_VALS1(MQCA_CLUSTER_WORKLOAD_EXIT),
/* 2034*/ DEF_VALS1(MQCA_CLUSTER_WORKLOAD_DATA),
/* 2035*/ DEF_VALS1(MQCA_REPOSITORY_NAME),
/* 2036*/ DEF_VALS1(MQCA_REPOSITORY_NAMELIST),
/* 2037*/ DEF_VALS1(MQCA_CLUSTER_DATE),
/* 2038*/ DEF_VALS1(MQCA_CLUSTER_TIME),
/* 2039*/ DEF_VALS1(MQCA_CF_STRUC_NAME),
/* 2040*/ DEF_VALS1(MQCA_QSG_NAME),
/* 2041*/ DEF_VALS1(MQCA_IGQ_USER_ID),
/* 2042*/ DEF_VALS1(MQCA_STORAGE_CLASS_DESC),
/* 2043*/ DEF_VALS1(MQCA_XCF_GROUP_NAME),
/* 2044*/ DEF_VALS1(MQCA_XCF_MEMBER_NAME),
/* 2045*/ DEF_VALS1(MQCA_AUTH_INFO_NAME),
/* 2046*/ DEF_VALS1(MQCA_AUTH_INFO_DESC),
/* 2047*/ DEF_VALS1(MQCA_LDAP_USER_NAME),
/* 2048*/ DEF_VALS1(MQCA_LDAP_PASSWORD),
/* 2049*/ DEF_VALS1(MQCA_SSL_KEY_REPOSITORY),
/* 2050*/ DEF_VALS1(MQCA_SSL_CRL_NAMELIST),
/* 2051*/ DEF_VALS1(MQCA_SSL_CRYPTO_HARDWARE),
/* 2052*/ DEF_VALS1(MQCA_CF_STRUC_DESC),
/* 2053*/ DEF_VALS1(MQCA_AUTH_INFO_CONN_NAME),
/* 2060*/ DEF_VALS1(MQCA_CICS_FILE_NAME),
/* 2061*/ DEF_VALS1(MQCA_TRIGGER_TRANS_ID),
/* 2062*/ DEF_VALS1(MQCA_TRIGGER_PROGRAM_NAME),
/* 2063*/ DEF_VALS1(MQCA_TRIGGER_TERM_ID),
/* 2064*/ DEF_VALS1(MQCA_TRIGGER_CHANNEL_NAME),
/* 2065*/ DEF_VALS1(MQCA_SYSTEM_LOG_Q_NAME),
/* 2066*/ DEF_VALS1(MQCA_MONITOR_Q_NAME),
/* 2067*/ DEF_VALS1(MQCA_COMMAND_REPLY_Q_NAME),
/* 2068*/ DEF_VALS1(MQCA_BATCH_INTERFACE_ID),
/* 2069*/ DEF_VALS1(MQCA_SSL_KEY_LIBRARY),
/* 2070*/ DEF_VALS1(MQCA_SSL_KEY_MEMBER),
/* 2071*/ DEF_VALS1(MQCA_DNS_GROUP),
/* 2072*/ DEF_VALS1(MQCA_LU_GROUP_NAME),
/* 2073*/ DEF_VALS1(MQCA_LU_NAME),
/* 2074*/ DEF_VALS1(MQCA_LU62_ARM_SUFFIX),
/* 2075*/ DEF_VALS1(MQCA_TCP_NAME),
/* 2076*/ DEF_VALS1(MQCA_CHINIT_SERVICE_PARM),
/* 2077*/ DEF_VALS1(MQCA_SERVICE_NAME),
/* 2078*/ DEF_VALS1(MQCA_SERVICE_DESC),
/* 2079*/ DEF_VALS1(MQCA_SERVICE_START_COMMAND),
/* 2080*/ DEF_VALS1(MQCA_SERVICE_START_ARGS),
/* 2081*/ DEF_VALS1(MQCA_SERVICE_STOP_COMMAND),
/* 2082*/ DEF_VALS1(MQCA_SERVICE_STOP_ARGS),
/* 2083*/ DEF_VALS1(MQCA_STDOUT_DESTINATION),
/* 2084*/ DEF_VALS1(MQCA_STDERR_DESTINATION),
/* 2085*/ DEF_VALS1(MQCA_TPIPE_NAME),
/* 2086*/ DEF_VALS1(MQCA_PASS_TICKET_APPL),
/* 2090*/ DEF_VALS1(MQCA_AUTO_REORG_START_TIME),
/* 2091*/ DEF_VALS1(MQCA_AUTO_REORG_CATALOG),
/* 2092*/ DEF_VALS1(MQCA_TOPIC_NAME),
/* 2093*/ DEF_VALS1(MQCA_TOPIC_DESC),
/* 2094*/ DEF_VALS1(MQCA_TOPIC_STRING),
/* 2096*/ DEF_VALS1(MQCA_MODEL_DURABLE_Q),
/* 2097*/ DEF_VALS1(MQCA_MODEL_NON_DURABLE_Q),
/* 2098*/ DEF_VALS1(MQCA_RESUME_DATE),
/* 2099*/ DEF_VALS1(MQCA_RESUME_TIME),
/* 2101*/ DEF_VALS1(MQCA_CHILD),
/* 2102*/ DEF_VALS1(MQCA_PARENT),
/* 2105*/ DEF_VALS1(MQCA_ADMIN_TOPIC_NAME),
/* 2108*/ DEF_VALS1(MQCA_TOPIC_STRING_FILTER),
/* 2109*/ DEF_VALS1(MQCA_AUTH_INFO_OCSP_URL),
/* 2110*/ DEF_VALS1(MQCA_COMM_INFO_NAME),
/* 2111*/ DEF_VALS1(MQCA_COMM_INFO_DESC),
/* 2112*/ DEF_VALS1(MQCA_POLICY_NAME),
/* 2113*/ DEF_VALS1(MQCA_SIGNER_DN),
/* 2114*/ DEF_VALS1(MQCA_RECIPIENT_DN),
/* 2115*/ DEF_VALS1(MQCA_INSTALLATION_DESC),
/* 2116*/ DEF_VALS1(MQCA_INSTALLATION_NAME),
/* 2117*/ DEF_VALS1(MQCA_INSTALLATION_PATH),
/* 2118*/ DEF_VALS1(MQCA_CHLAUTH_DESC),
/* 2119*/ DEF_VALS1(MQCA_CUSTOM),
/* 2120*/ DEF_VALS1(MQCA_VERSION),
/* 2121*/ DEF_VALS1(MQCA_CERT_LABEL),
/* 2122*/ DEF_VALS1(MQCA_XR_VERSION),
/* 2123*/ DEF_VALS1(MQCA_XR_SSL_CIPHER_SUITES),
/* 2124*/ DEF_VALS1(MQCA_CLUS_CHL_NAME),
/* 2125*/ DEF_VALS1(MQCA_CONN_AUTH),
/* 2126*/ DEF_VALS1(MQCA_LDAP_BASE_DN_USERS),
/* 2127*/ DEF_VALS1(MQCA_LDAP_SHORT_USER_FIELD),
/* 2128*/ DEF_VALS1(MQCA_LDAP_USER_OBJECT_CLASS),
/* 2129*/ DEF_VALS1(MQCA_LDAP_USER_ATTR_FIELD),
/* 2130*/ DEF_VALS1(MQCA_SSL_CERT_ISSUER_NAME),
/* 2131*/ DEF_VALS1(MQCA_QSG_CERT_LABEL),
/* 2132*/ DEF_VALS1(MQCA_LDAP_BASE_DN_GROUPS),
/* 2133*/ DEF_VALS1(MQCA_LDAP_GROUP_OBJECT_CLASS),
/* 2134*/ DEF_VALS1(MQCA_LDAP_GROUP_ATTR_FIELD),
/* 2135*/ DEF_VALS1(MQCA_LDAP_FIND_GROUP_FIELD),
/* 2136*/ DEF_VALS1(MQCA_AMQP_VERSION),
/* 2137*/ DEF_VALS1(MQCA_AMQP_SSL_CIPHER_SUITES),
DEF_VALSE;
DEF_VALS_EXTBX(selector);

DEF_VALSB(MQCFINT_Parse)
/*    1*/ DEF_VALS2(MQIA_APPL_TYPE, GET_VALSP(MQAT)),
/*    4*/ DEF_VALS2(MQIA_DEF_INPUT_OPEN_OPTION, GET_VALSP(MQOO)),
/*    5*/ DEF_VALS2(MQIA_DEF_PERSISTENCE, GET_VALSP(MQPER)),
/*    6*/ DEF_VALS2(MQIA_DEF_PRIORITY, GET_VALSP(MQPRI)),
/*    7*/ DEF_VALS2(MQIA_DEFINITION_TYPE, GET_VALSP(MQQDT)),
/*    8*/ DEF_VALS2(MQIA_HARDEN_GET_BACKOUT, GET_VALSP(MQQA_BACKOUT)),
/*    9*/ DEF_VALS2(MQIA_INHIBIT_GET, GET_VALSP(MQQA_GET)),
/*   10*/ DEF_VALS2(MQIA_INHIBIT_PUT, GET_VALSP(MQQA_PUT)),
/*   12*/ DEF_VALS2(MQIA_USAGE, GET_VALSP(MQUS)),
/*   16*/ DEF_VALS2(MQIA_MSG_DELIVERY_SEQUENCE, GET_VALSP(MQMDS)),
/*   20*/ DEF_VALS2(MQIA_Q_TYPE, GET_VALSP(MQQT)),
/*   23*/ DEF_VALS2(MQIA_SHAREABILITY, GET_VALSP(Shareability)),
/*   24*/ DEF_VALS2(MQIA_TRIGGER_CONTROL, GET_VALSP(TriggerControl)),
/*   28*/ DEF_VALS2(MQIA_TRIGGER_TYPE, GET_VALSP(TriggerType)),
/*   30*/ DEF_VALS2(MQIA_SYNCPOINT, GET_VALSP(SyncpointAvailability)),
/*   32*/ DEF_VALS2(MQIA_PLATFORM, GET_VALSP(Platform)),
/*   34*/ DEF_VALS2(MQIA_DIST_LISTS, GET_VALSP(DistributionLists)),
/*   42*/ DEF_VALS2(MQIA_Q_DEPTH_MAX_EVENT, GET_VALSP(MQEVR)),
/*   43*/ DEF_VALS2(MQIA_Q_DEPTH_HIGH_EVENT, GET_VALSP(MQEVR)),
/*   44*/ DEF_VALS2(MQIA_Q_DEPTH_LOW_EVENT, GET_VALSP(MQEVR)),
/*   45*/ DEF_VALS2(MQIA_SCOPE, GET_VALSP(QueueDefinitionScope)),
/*   46*/ DEF_VALS2(MQIA_Q_SERVICE_INTERVAL_EVENT, GET_VALSP(ServiceIntervalEvent)),
/*   47*/ DEF_VALS2(MQIA_AUTHORITY_EVENT, GET_VALSP(MQEVR)),
/*   48*/ DEF_VALS2(MQIA_INHIBIT_EVENT, GET_VALSP(MQEVR)),
/*   49*/ DEF_VALS2(MQIA_LOCAL_EVENT, GET_VALSP(MQEVR)),
/*   50*/ DEF_VALS2(MQIA_REMOTE_EVENT, GET_VALSP(MQEVR)),
/*   51*/ DEF_VALS2(MQIA_CONFIGURATION_EVENT, GET_VALSP(MQEVR)),
/*   52*/ DEF_VALS2(MQIA_START_STOP_EVENT, GET_VALSP(MQEVR)),
/*   53*/ DEF_VALS2(MQIA_PERFORMANCE_EVENT, GET_VALSP(MQEVR)),
/*   55*/ DEF_VALS2(MQIA_CHANNEL_AUTO_DEF, GET_VALSP(ChanAutoDef)),
/*   56*/ DEF_VALS2(MQIA_CHANNEL_AUTO_DEF_EVENT, GET_VALSP(MQEVR)),
/*   57*/ DEF_VALS2(MQIA_INDEX_TYPE, GET_VALSP(IndexTypes)),
/*   61*/ DEF_VALS2(MQIA_DEF_BIND, GET_VALSP(Bindings)),
/*   63*/ DEF_VALS2(MQIA_QSG_DISP, GET_VALSP(QShrGrpDisp)),
/*   64*/ DEF_VALS2(MQIA_INTRA_GROUP_QUEUING, GET_VALSP(IntraGroupQueuing)),
/*   65*/ DEF_VALS2(MQIA_IGQ_PUT_AUTHORITY, GET_VALSP(IGQPutAuthority)),
/*   66*/ DEF_VALS2(MQIA_AUTH_INFO_TYPE, GET_VALSP(AuthInfoType)),
/*   71*/ DEF_VALS2(MQIA_CF_RECOVER, GET_VALSP(CFRecoverability)),
/*   73*/ DEF_VALS2(MQIA_CHANNEL_EVENT, GET_VALSP(MQEVR)),
/*   74*/ DEF_VALS2(MQIA_BRIDGE_EVENT, GET_VALSP(MQEVR)),
/*   75*/ DEF_VALS2(MQIA_SSL_EVENT, GET_VALSP(MQEVR)),
/*   77*/ DEF_VALS2(MQIA_SHARED_Q_Q_MGR_NAME, GET_VALSP(SharedQueueQueueManagerName)),
/*   78*/ DEF_VALS2(MQIA_NPM_CLASS, GET_VALSP(NonpersistentMsgCls)),
/*   92*/ DEF_VALS2(MQIA_SSL_FIPS_REQUIRED, GET_VALSP(FipsRequired)),
/*   93*/ DEF_VALS2(MQIA_IP_ADDRESS_VERSION, GET_VALSP(IPAddressVersion)),
/*   94*/ DEF_VALS2(MQIA_LOGGER_EVENT, GET_VALSP(MQEVR)),
/*   98*/ DEF_VALS2(MQIA_CLWL_USEQ, GET_VALSP(CLWLUseQ)),
/*   99*/ DEF_VALS2(MQIA_COMMAND_EVENT, GET_VALSP(MQEVR)),
/*  102*/ DEF_VALS2(MQIA_ADOPTNEWMCA_CHECK, GET_VALSP(AdoptNewMCACheck)),
/*  103*/ DEF_VALS2(MQIA_ADOPTNEWMCA_TYPE, GET_VALSP(AdoptNewMCAType)),
/*  106*/ DEF_VALS2(MQIA_DNS_WLM, GET_VALSP(DNSWLM)),
/*  112*/ DEF_VALS2(MQIA_RECEIVE_TIMEOUT_TYPE, GET_VALSP(ReceiveTimeoutType)),
/*  115*/ DEF_VALS2(MQIA_TCP_KEEP_ALIVE, GET_VALSP(TCPKeepAlive)),
/*  116*/ DEF_VALS2(MQIA_TCP_STACK_TYPE, GET_VALSP(TCPStackType)),
/*  117*/ DEF_VALS2(MQIA_CHINIT_TRACE_AUTO_START, GET_VALSP(ChinitTraceAutoStart)),
/*  119*/ DEF_VALS2(MQIA_CHINIT_CONTROL, GET_VALSP(MQSVC_CONTROL)),
/*  120*/ DEF_VALS2(MQIA_CMD_SERVER_CONTROL, GET_VALSP(MQSVC_CONTROL)),
/*  122*/ DEF_VALS2(MQIA_MONITORING_CHANNEL, GET_VALSP(MQMON)),
/*  123*/ DEF_VALS2(MQIA_MONITORING_Q, GET_VALSP(MQMON)),
/*  124*/ DEF_VALS2(MQIA_MONITORING_AUTO_CLUSSDR, GET_VALSP(MQMON)),
/*  124*/ DEF_VALS2(MQIA_MONITORING_AUTO_CLUSSDR, GET_VALSP(MQMON)),
/*  127*/ DEF_VALS2(MQIA_STATISTICS_MQI, GET_VALSP(MQMON)),
/*  128*/ DEF_VALS2(MQIA_STATISTICS_Q, GET_VALSP(MQMON)),
/*  129*/ DEF_VALS2(MQIA_STATISTICS_CHANNEL, GET_VALSP(MQMON)),
/*  130*/ DEF_VALS2(MQIA_STATISTICS_AUTO_CLUSSDR, GET_VALSP(MQMON)),
/*  131*/ DEF_VALS2(MQIA_STATISTICS_INTERVAL, GET_VALSP(MQMON)),
/*  133*/ DEF_VALS2(MQIA_ACCOUNTING_MQI, GET_VALSP(MQMON)),
/*  134*/ DEF_VALS2(MQIA_ACCOUNTING_Q, GET_VALSP(MQMON)),
/*  136*/ DEF_VALS2(MQIA_ACCOUNTING_CONN_OVERRIDE, GET_VALSP(MQMON)),
/*  137*/ DEF_VALS2(MQIA_TRACE_ROUTE_RECORDING, GET_VALSP(TraceRouteRecording)),
/*  138*/ DEF_VALS2(MQIA_ACTIVITY_RECORDING, GET_VALSP(ActivityRecording)),
/*  141*/ DEF_VALS2(MQIA_SECURITY_CASE, GET_VALSP(SecurityCase)),
/*  175*/ DEF_VALS2(MQIA_DURABLE_SUB, GET_VALSP(MQSUB_DURABLE)),
/*  176*/ DEF_VALS2(MQIA_MULTICAST, GET_VALSP(MQMC)),
/*  181*/ DEF_VALS2(MQIA_INHIBIT_PUB, GET_VALSP(InhibitPublications)),
/*  182*/ DEF_VALS2(MQIA_INHIBIT_SUB, GET_VALSP(InhibitSubscriptions)),
/*  184*/ DEF_VALS2(MQIA_DEF_PUT_RESPONSE_TYPE, GET_VALSP(MQPRT)),
/*  185*/ DEF_VALS2(MQIA_TOPIC_DEF_PERSISTENCE, GET_VALSP(MQPER)),
/*  187*/ DEF_VALS2(MQIA_PUBSUB_MODE, GET_VALSP(PubSubMode)),
/*  188*/ DEF_VALS2(MQIA_DEF_READ_AHEAD, GET_VALSP(MQREADA)),
/*  189*/ DEF_VALS2(MQIA_READ_AHEAD, GET_VALSP(MQREADA)),
/*  190*/ DEF_VALS2(MQIA_PROPERTY_CONTROL, GET_VALSP(MQPROP)),
/*  193*/ DEF_VALS2(MQIA_BASE_TYPE, GET_VALSP(objtype)),
/*  195*/ DEF_VALS2(MQIA_PM_DELIVERY, GET_VALSP(MsgDelivery)),
/*  196*/ DEF_VALS2(MQIA_NPM_DELIVERY, GET_VALSP(MsgDelivery)),
/*  199*/ DEF_VALS2(MQIA_PROXY_SUB, GET_VALSP(ProxySubscriptions)),
/*  203*/ DEF_VALS2(MQIA_PUBSUB_NP_MSG, GET_VALSP(MQUNDELIVERED)),
/*  205*/ DEF_VALS2(MQIA_PUBSUB_NP_RESP, GET_VALSP(MQUNDELIVERED)),
/*  207*/ DEF_VALS2(MQIA_PUBSUB_SYNC_PT, GET_VALSP(PubSubSync)),
/*  208*/ DEF_VALS2(MQIA_TOPIC_TYPE, GET_VALSP(TopicType)),
/*  216*/ DEF_VALS2(MQIA_WILDCARD_OPERATION, GET_VALSP(WildcardOperation)),
/*  218*/ DEF_VALS2(MQIA_SUB_SCOPE, GET_VALSP(PubSubScope)),
/*  219*/ DEF_VALS2(MQIA_PUB_SCOPE, GET_VALSP(PubSubScope)),
/*  221*/ DEF_VALS2(MQIA_GROUP_UR, GET_VALSP(MQGUR)),
/*  222*/ DEF_VALS2(MQIA_UR_DISP, GET_VALSP(QShrGrpDisp)),
/*  223*/ DEF_VALS2(MQIA_COMM_INFO_TYPE, GET_VALSP(MQCIT)),
/*  224*/ DEF_VALS2(MQIA_CF_OFFLOAD, GET_VALSP(OffloadUse)),
/*  229*/ DEF_VALS2(MQIA_CF_OFFLDUSE, GET_VALSP(OffloadUse)),
/*  232*/ DEF_VALS2(MQIA_COMM_EVENT, GET_VALSP(MQEVR)),
/*  233*/ DEF_VALS2(MQIA_MCAST_BRIDGE, GET_VALSP(MQMCB)),
/*  234*/ DEF_VALS2(MQIA_USE_DEAD_LETTER_Q, GET_VALSP(MQUSEDLQ)),
/*  239*/ DEF_VALS2(MQIA_ACTIVITY_CONN_OVERRIDE, GET_VALSP(MQMON)),
/*  240*/ DEF_VALS2(MQIA_ACTIVITY_TRACE, GET_VALSP(MQMON)),
/*  243*/ DEF_VALS2(MQIA_XR_CAPABILITY, GET_VALSP(MQCAP)),
/*  244*/ DEF_VALS2(MQIA_CF_RECAUTO, GET_VALSP(CFAutomaticRecovery)),
/*  245*/ DEF_VALS2(MQIA_QMGR_CFCONLOS, GET_VALSP(CFConLoss)),
/*  246*/ DEF_VALS2(MQIA_CF_CFCONLOS, GET_VALSP(CFLossConnectivity)),
/*  247*/ DEF_VALS2(MQIA_SUITE_B_STRENGTH, GET_VALSP(MQ_SUITE_B)),
/*  248*/ DEF_VALS2(MQIA_CHLAUTH_RECORDS, GET_VALSP(ChlAuthRecords)),
/*  249*/ DEF_VALS2(MQIA_PUBSUB_CLUSTER, GET_VALSP(PubSubCluster)),
/*  250*/ DEF_VALS2(MQIA_DEF_CLUSTER_XMIT_Q_TYPE, GET_VALSP(DefClusXmitTyp)),
/*  251*/ DEF_VALS2(MQIA_PROT_POLICY_CAPABILITY, GET_VALSP(MQCAP)),
/*  252*/ DEF_VALS2(MQIA_CERT_VAL_POLICY, GET_VALSP(CertValPolicy)),
/*  254*/ DEF_VALS2(MQIA_REVERSE_DNS_LOOKUP, GET_VALSP(MQRDNS)),
/*  255*/ DEF_VALS2(MQIA_CLUSTER_PUB_ROUTE, GET_VALSP(MQCLROUTE)),
/*  256*/ DEF_VALS2(MQIA_CLUSTER_OBJECT_STATE, GET_VALSP(MQCLST)),
/*  257*/ DEF_VALS2(MQIA_CHECK_LOCAL_BINDING, GET_VALSP(MQCHK)),
/*  258*/ DEF_VALS2(MQIA_CHECK_CLIENT_BINDING, GET_VALSP(MQCHK)),
/*  260*/ DEF_VALS2(MQIA_ADOPT_CONTEXT, GET_VALSP(MQADPCTX)),
/*  261*/ DEF_VALS2(MQIA_LDAP_SECURE_COMM, GET_VALSP(MQSECCOMM)),
/*  263*/ DEF_VALS2(MQIA_LDAP_AUTHORMD, GET_VALSP(MQLDAP_AUTHORMD)),
/*  264*/ DEF_VALS2(MQIA_LDAP_NESTGRP, GET_VALSP(MQLDAP_NESTGRP)),
/*  265*/ DEF_VALS2(MQIA_AMQP_CAPABILITY, GET_VALSP(MQCAP)),
/*  266*/ DEF_VALS2(MQIA_AUTHENTICATION_METHOD, GET_VALSP(MQAUTHENTICATE)),
/*  267*/ DEF_VALS2(MQIA_KEY_REUSE_COUNT, GET_VALSP(Keyreusecount)),
/* 1001*/ DEF_VALS2(MQIACF_Q_MGR_ATTRS, GET_VALSP(PrmId)),
/* 1002*/ DEF_VALS2(MQIACF_Q_ATTRS, GET_VALSP(PrmId)),
/* 1006*/ DEF_VALS2(MQIACF_REPLACE, GET_VALSP(ReplaceOptions)),
/* 1010*/ DEF_VALS2(MQIACF_EVENT_APPL_TYPE, GET_VALSP(MQAT)),
/* 1011*/ DEF_VALS2(MQIACF_EVENT_ORIGIN, GET_VALSP(EvtOrig)),
/* 1012*/ DEF_VALS2(MQIACF_PARAMETER_ID, GET_VALSP(PrmId)),
/* 1016*/ DEF_VALS2(MQIACF_OBJECT_TYPE, GET_VALSP(objtype)),
/* 1020*/ DEF_VALS2(MQIACF_REASON_QUALIFIER, GET_VALSP(MQRQ)),
/* 1021*/ DEF_VALS2(MQIACF_COMMAND, GET_VALSP(MQCMD)),
/* 1023*/ DEF_VALS2(MQIACF_OPEN_TYPE, GET_VALSP(QueueStatusOpenTypes)),
/* 1026*/ DEF_VALS2(MQIACF_Q_STATUS_ATTRS, GET_VALSP(PrmId)),
/* 1028*/ DEF_VALS2(MQIACF_HANDLE_STATE, GET_VALSP(HandleStates)),
/* 1093*/ DEF_VALS2(MQIACF_CLUSTER_Q_MGR_ATTRS, GET_VALSP(PrmId)),
/* 1098*/ DEF_VALS2(MQIACF_OPEN_INPUT_TYPE, GET_VALSP(QueueStatusOpenOptions)),
/* 1099*/ DEF_VALS2(MQIACF_OPEN_OUTPUT, GET_VALSP(QueueStatusOptionsYesNo)),
/* 1100*/ DEF_VALS2(MQIACF_OPEN_SET, GET_VALSP(QueueStatusOptionsYesNo)),
/* 1101*/ DEF_VALS2(MQIACF_OPEN_INQUIRE, GET_VALSP(QueueStatusOptionsYesNo)),
/* 1102*/ DEF_VALS2(MQIACF_OPEN_BROWSE, GET_VALSP(QueueStatusOptionsYesNo)),
/* 1103*/ DEF_VALS2(MQIACF_Q_STATUS_TYPE, GET_VALSP(PrmId)),
/* 1106*/ DEF_VALS2(MQIACF_SECURITY_TYPE, GET_VALSP(MQSECTYPE)),
/* 1107*/ DEF_VALS2(MQIACF_CONNECTION_ATTRS, GET_VALSP(PrmId)),
/* 1110*/ DEF_VALS2(MQIACF_CONN_INFO_TYPE, GET_VALSP(ConnInfoType)),
/* 1115*/ DEF_VALS2(MQIACF_AUTHORIZATION_LIST, GET_VALSP(MQAUTH)),
/* 1118*/ DEF_VALS2(MQIACF_ENTITY_TYPE, GET_VALSP(MQZAET)),
/* 1120*/ DEF_VALS2(MQIACF_COMMAND_INFO, GET_VALSP(CommandInformationValues)),
/* 1126*/ DEF_VALS2(MQIACF_QSG_DISPS, GET_VALSP(QShrGrpDisp)),
/* 1128*/ DEF_VALS2(MQIACF_UOW_STATE, GET_VALSP(UOWStates)),
/* 1129*/ DEF_VALS2(MQIACF_SECURITY_ITEM, GET_VALSP(MQSECITEM)),
/* 1130*/ DEF_VALS2(MQIACF_CF_STRUC_STATUS, GET_VALSP(CFStatus)),
/* 1132*/ DEF_VALS2(MQIACF_UOW_TYPE, GET_VALSP(UOWTypes)),
/* 1133*/ DEF_VALS2(MQIACF_CF_STRUC_ATTRS, GET_VALSP(PrmId)),
/* 1135*/ DEF_VALS2(MQIACF_CF_STATUS_TYPE, GET_VALSP(CFStatusType)),
/* 1139*/ DEF_VALS2(MQIACF_CF_STRUC_TYPE, GET_VALSP(CFStructType)),
/* 1149*/ DEF_VALS2(MQIACF_Q_MGR_STATUS, GET_VALSP(QSGStatus)),
/* 1150*/ DEF_VALS2(MQIACF_DB2_CONN_STATUS, GET_VALSP(QSGStatus)),
/* 1154*/ DEF_VALS2(MQIACF_SECURITY_SWITCH, GET_VALSP(MQSECSW)),
/* 1155*/ DEF_VALS2(MQIACF_SECURITY_SETTING, GET_VALSP(MQSECSW)),
/* 1157*/ DEF_VALS2(MQIACF_USAGE_TYPE, GET_VALSP(PrmId)),
/* 1165*/ DEF_VALS2(MQIACF_PAGESET_STATUS, GET_VALSP(MQUSAGE_PS)),
/* 1167*/ DEF_VALS2(MQIACF_USAGE_DATA_SET_TYPE, GET_VALSP(MQUSAGE_DS)),
/* 1175*/ DEF_VALS2(MQIACF_SYSP_TYPE, GET_VALSP(MQSYSP)),
/* 1182*/ DEF_VALS2(MQIACF_SYSP_ARCHIVE, GET_VALSP(MQSYSP)),
/* 1183*/ DEF_VALS2(MQIACF_SYSP_DUAL_ACTIVE, GET_VALSP(MQSYSP)),
/* 1184*/ DEF_VALS2(MQIACF_SYSP_DUAL_ARCHIVE, GET_VALSP(MQSYSP)),
/* 1185*/ DEF_VALS2(MQIACF_SYSP_DUAL_BSDS, GET_VALSP(MQSYSP)),
/* 1197*/ DEF_VALS2(MQIACF_SYSP_SMF_ACCOUNTING, GET_VALSP(MQSYSP)),
/* 1198*/ DEF_VALS2(MQIACF_SYSP_SMF_STATS, GET_VALSP(MQSYSP)),
/* 1203*/ DEF_VALS2(MQIACF_SYSP_ALLOC_UNIT, GET_VALSP(MQSYSP)),
/* 1205*/ DEF_VALS2(MQIACF_SYSP_ARCHIVE_WTOR, GET_VALSP(MQSYSP)),
/* 1207*/ DEF_VALS2(MQIACF_SYSP_CATALOG, GET_VALSP(MQSYSP)),
/* 1208*/ DEF_VALS2(MQIACF_SYSP_COMPACT, GET_VALSP(MQSYSP)),
/* 1211*/ DEF_VALS2(MQIACF_SYSP_PROTECT, GET_VALSP(MQSYSP)),
/* 1218*/ DEF_VALS2(MQIACF_SYSP_LOG_SUSPEND, GET_VALSP(MQSYSP)),
/* 1219*/ DEF_VALS2(MQIACF_SYSP_OFFLOAD_STATUS, GET_VALSP(MQSYSP)),
/* 1229*/ DEF_VALS2(MQIACF_Q_MGR_STATUS_ATTRS, GET_VALSP(PrmId)),
/* 1232*/ DEF_VALS2(MQIACF_CHINIT_STATUS, GET_VALSP(MQSVC_STATUS)),
/* 1233*/ DEF_VALS2(MQIACF_CMD_SERVER_STATUS, GET_VALSP(MQSVC_STATUS)),
/* 1261*/ DEF_VALS2(MQIACF_Q_TYPES, GET_VALSP(MQQT)),
/* 1262*/ DEF_VALS2(MQIACF_USER_ID_SUPPORT, GET_VALSP(MQUIDSUPP)),
/* 1264*/ DEF_VALS2(MQIACF_AUTH_SERVICE_ATTRS, GET_VALSP(PrmId)),
/* 1265*/ DEF_VALS2(MQIACF_USAGE_EXPAND_TYPE, GET_VALSP(MQUSAGE_EXPAND)),
/* 1271*/ DEF_VALS2(MQIACF_PUBSUB_PROPERTIES, GET_VALSP(MQPSPROP)),
/* 1274*/ DEF_VALS2(MQIACF_DURABLE_SUBSCRIPTION, GET_VALSP(MQSUB_DURABLE)),
/* 1280*/ DEF_VALS2(MQIACF_REQUEST_ONLY, GET_VALSP(MQSUB_DURABLE)),
/* 1283*/ DEF_VALS2(MQIACF_PUB_PRIORITY, GET_VALSP(MQPRI)),
/* 1289*/ DEF_VALS2(MQIACF_SUB_TYPE, GET_VALSP(MQSUBTYPE)),
/* 1300*/ DEF_VALS2(MQIACF_RETAINED_PUBLICATION, GET_VALSP(MQQSO)),
/* 1302*/ DEF_VALS2(MQIACF_TOPIC_STATUS_TYPE, GET_VALSP(PrmId)),
/* 1308*/ DEF_VALS2(MQIACF_ASYNC_STATE, GET_VALSP(AsynchronousStateValues)),
/* 1308*/ DEF_VALS2(MQIACF_PS_STATUS_TYPE, GET_VALSP(MQPSST)),
/* 1322*/ DEF_VALS2(MQIACF_LOG_COMPRESSION, GET_VALSP(MQCOMPRESS)),
/* 1324*/ DEF_VALS2(MQIACF_MULC_CAPTURE, GET_VALSP(MQMULC)),
/* 1325*/ DEF_VALS2(MQIACF_PERMIT_STANDBY, GET_VALSP(MQSTDBY)),
/* 1328*/ DEF_VALS2(MQIACF_CF_SMDS_BLOCK_SIZE, GET_VALSP(DSBlock)),
/* 1329*/ DEF_VALS2(MQIACF_CF_SMDS_EXPAND, GET_VALSP(DSExpand)),
/* 1332*/ DEF_VALS2(MQIACF_CF_STRUC_ACCESS, GET_VALSP(AccessOptions)),
/* 1335*/ DEF_VALS2(MQIACF_USAGE_SMDS, GET_VALSP(SMDSUsage)),
/* 1341*/ DEF_VALS2(MQIACF_USAGE_OFFLOAD_MSGS, GET_VALSP(OffloadUse)),
/* 1348*/ DEF_VALS2(MQIACF_SMDS_OPENMODE, GET_VALSP(OpenMode)),
/* 1349*/ DEF_VALS2(MQIACF_SMDS_STATUS, GET_VALSP(SMDSStatus)),
/* 1350*/ DEF_VALS2(MQIACF_SMDS_AVAIL, GET_VALSP(SMDSAvail)),
/* 1352*/ DEF_VALS2(MQIACF_CHLAUTH_TYPE, GET_VALSP(ChlauthType)),
/* 1376*/ DEF_VALS2(MQIACF_SMDS_EXPANDST, GET_VALSP(SMDSExpandSt)),
/* 1409*/ DEF_VALS2(MQIACF_LDAP_CONNECTION_STATUS, GET_VALSP(MQLDAPC)),
/* 1414*/ DEF_VALS2(MQIACF_SYSP_ZHYPERWRITE, GET_VALSP(MQSYSP)),
/* 1501*/ DEF_VALS2(MQIACH_XMIT_PROTOCOL_TYPE, GET_VALSP(TransportType)),
/* 1508*/ DEF_VALS2(MQIACH_PUT_AUTHORITY, GET_VALSP(PutAuthority)),
/* 1511*/ DEF_VALS2(MQIACH_CHANNEL_TYPE, GET_VALSP(ChannelType)),
/* 1515*/ DEF_VALS2(MQIACH_DATA_CONVERSION, GET_VALSP(DataConversion)),
/* 1517*/ DEF_VALS2(MQIACH_MCA_TYPE, GET_VALSP(MCAType)),
/* 1523*/ DEF_VALS2(MQIACH_CHANNEL_INSTANCE_TYPE, GET_VALSP(objtype)),
/* 1527*/ DEF_VALS2(MQIACH_CHANNEL_STATUS, GET_VALSP(ChannelStatus)),
/* 1528*/ DEF_VALS2(MQIACH_INDOUBT_STATUS, GET_VALSP(IndoubtStatus)),
/* 1542*/ DEF_VALS2(MQIACH_MCA_STATUS, GET_VALSP(MessageChannelAgentStatus)),
/* 1543*/ DEF_VALS2(MQIACH_STOP_REQUESTED, GET_VALSP(ChannelStopOptions)),
/* 1562*/ DEF_VALS2(MQIACH_NPM_SPEED, GET_VALSP(NonPersistentMsgSpeed)),
/* 1568*/ DEF_VALS2(MQIACH_SSL_CLIENT_AUTH, GET_VALSP(SSLClientAuthentication)),
/* 1575*/ DEF_VALS2(MQIACH_HDR_COMPRESSION, GET_VALSP(MQCOMPRESS)),
/* 1576*/ DEF_VALS2(MQIACH_MSG_COMPRESSION, GET_VALSP(MQCOMPRESS)),
/* 1580*/ DEF_VALS2(MQIACH_CHANNEL_DISP, GET_VALSP(ChannelDisp)),
/* 1581*/ DEF_VALS2(MQIACH_INBOUND_DISP, GET_VALSP(MQINBD)),
/* 1582*/ DEF_VALS2(MQIACH_CHANNEL_TYPES, GET_VALSP(ChannelType)),
/* 1599*/ DEF_VALS2(MQIACH_LISTENER_STATUS, GET_VALSP(MQSVC_STATUS)),
/* 1601*/ DEF_VALS2(MQIACH_LISTENER_CONTROL, GET_VALSP(MQSVC_CONTROL)),
/* 1609*/ DEF_VALS2(MQIACH_CHANNEL_SUBSTATE, GET_VALSP(ChannelSubStates)),
/* 1614*/ DEF_VALS2(MQIACH_DEF_CHANNEL_DISP, GET_VALSP(ChannelDisp)),
/* 1622*/ DEF_VALS2(MQIACH_AUTH_INFO_TYPES, GET_VALSP(AuthInfoType)),
/* 1627*/ DEF_VALS2(MQIACH_NEW_SUBSCRIBER_HISTORY, GET_VALSP(MQNSH)),
/* 1629*/ DEF_VALS2(MQIACH_USE_CLIENT_ID, GET_VALSP(MQUCI)),
/* 1638*/ DEF_VALS2(MQIACH_USER_SOURCE, GET_VALSP(UserSource)),
/* 1639*/ DEF_VALS2(MQIACH_WARNING, GET_VALSP(Warning)),
DEF_VALSE;
DEF_VALS_EXTBX(MQCFINT_Parse);

/*
 * Editor modelines - https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 4
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=4 tabstop=8 expandtab:
 * :indentSize=4:tabSize=8:noTabs=true:
 */
