/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef _IMX27_REGS_H
#define _IMX27_REGS_H

#define MX27_AIPI_BASE_ADDR		0x10000000
#define MX27_AIPI_SIZE			SZ_1M
#define MX27_DMA_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x01000)
#define MX27_WDOG_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x02000)
#define MX27_GPT1_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x03000)
#define MX27_GPT2_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x04000)
#define MX27_GPT3_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x05000)
#define MX27_PWM_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x06000)
#define MX27_RTC_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x07000)
#define MX27_KPP_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x08000)
#define MX27_OWIRE_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x09000)
#define MX27_UART1_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x0a000)
#define MX27_UART2_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x0b000)
#define MX27_UART3_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x0c000)
#define MX27_UART4_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x0d000)
#define MX27_CSPI1_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x0e000)
#define MX27_CSPI2_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x0f000)
#define MX27_SSI1_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x10000)
#define MX27_SSI2_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x11000)
#define MX27_I2C1_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x12000)
#define MX27_SDHC1_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x13000)
#define MX27_SDHC2_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x14000)
#define MX27_GPIO_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x15000)
#define MX27_GPIO1_BASE_ADDR			(MX27_GPIO_BASE_ADDR + 0x000)
#define MX27_GPIO2_BASE_ADDR			(MX27_GPIO_BASE_ADDR + 0x100)
#define MX27_GPIO3_BASE_ADDR			(MX27_GPIO_BASE_ADDR + 0x200)
#define MX27_GPIO4_BASE_ADDR			(MX27_GPIO_BASE_ADDR + 0x300)
#define MX27_GPIO5_BASE_ADDR			(MX27_GPIO_BASE_ADDR + 0x400)
#define MX27_GPIO6_BASE_ADDR			(MX27_GPIO_BASE_ADDR + 0x500)
#define MX27_AUDMUX_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x16000)
#define MX27_CSPI3_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x17000)
#define MX27_MSHC_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x18000)
#define MX27_GPT4_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x19000)
#define MX27_GPT5_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x1a000)
#define MX27_UART5_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x1b000)
#define MX27_UART6_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x1c000)
#define MX27_I2C2_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x1d000)
#define MX27_SDHC3_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x1e000)
#define MX27_GPT6_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x1f000)
#define MX27_LCDC_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x21000)
#define MX27_SLCDC_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x22000)
#define MX27_VPU_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x23000)
#define MX27_USB_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x24000)
#define MX27_USB_OTG_BASE_ADDR			(MX27_USB_BASE_ADDR + 0x0000)
#define MX27_USB_HS1_BASE_ADDR			(MX27_USB_BASE_ADDR + 0x0200)
#define MX27_USB_HS2_BASE_ADDR			(MX27_USB_BASE_ADDR + 0x0400)
#define MX27_SAHARA_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x25000)
#define MX27_EMMAPP_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x26000)
#define MX27_EMMAPRP_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x26400)
#define MX27_CCM_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x27000)
#define MX27_SYSCTRL_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x27800)
#define MX27_IIM_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x28000)
#define MX27_RTIC_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x2a000)
#define MX27_FEC_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x2b000)
#define MX27_SCC_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x2c000)
#define MX27_ETB_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x3b000)
#define MX27_ETB_RAM_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x3c000)
#define MX27_JAM_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x3e000)
#define MX27_MAX_BASE_ADDR			(MX27_AIPI_BASE_ADDR + 0x3f000)

#define MX27_AVIC_BASE_ADDR		0x10040000

/* ROM patch */
#define MX27_ROMP_BASE_ADDR		0x10041000

#define MX27_SAHB1_BASE_ADDR		0x80000000
#define MX27_SAHB1_SIZE			SZ_1M
#define MX27_CSI_BASE_ADDR			(MX27_SAHB1_BASE_ADDR + 0x0000)
#define MX27_ATA_BASE_ADDR			(MX27_SAHB1_BASE_ADDR + 0x1000)

/* Memory regions and CS */
#define MX27_CSD0_BASE_ADDR		0xa0000000
#define MX27_CSD1_BASE_ADDR		0xb0000000

#define MX27_CS0_BASE_ADDR		0xc0000000
#define MX27_CS1_BASE_ADDR		0xc8000000
#define MX27_CS2_BASE_ADDR		0xd0000000
#define MX27_CS3_BASE_ADDR		0xd2000000
#define MX27_CS4_BASE_ADDR		0xd4000000
#define MX27_CS5_BASE_ADDR		0xd6000000

/* NAND, SDRAM, WEIM, M3IF, EMI controllers */
#define MX27_X_MEMC_BASE_ADDR		0xd8000000
#define MX27_X_MEMC_SIZE		SZ_1M
#define MX27_NFC_BASE_ADDR		(MX27_X_MEMC_BASE_ADDR)
#define MX27_ESDCTL_BASE_ADDR		(MX27_X_MEMC_BASE_ADDR + 0x1000)
#define MX27_WEIM_BASE_ADDR		(MX27_X_MEMC_BASE_ADDR + 0x2000)
#define MX27_M3IF_BASE_ADDR		(MX27_X_MEMC_BASE_ADDR + 0x3000)
#define MX27_PCMCIA_CTL_BASE_ADDR	(MX27_X_MEMC_BASE_ADDR + 0x4000)

#define MX27_WEIM_CSCRx_BASE_ADDR(cs)	(MX27_WEIM_BASE_ADDR + (cs) * 0x10)
#define MX27_WEIM_CSCRxU(cs)		(MX27_WEIM_CSCRx_BASE_ADDR(cs))
#define MX27_WEIM_CSCRxL(cs)		(MX27_WEIM_CSCRx_BASE_ADDR(cs) + 0x4)
#define MX27_WEIM_CSCRxA(cs)		(MX27_WEIM_CSCRx_BASE_ADDR(cs) + 0x8)

#define MX27_PCMCIA_MEM_BASE_ADDR	0xdc000000

/* IRAM */
#define MX27_IRAM_BASE_ADDR		0xffff4c00	/* internal ram */
#define MX27_IRAM_SIZE			0x0000b400

/* PCMCIA (base: MX27_PCMCIA_CTL_BASE_ADDR) */
#define MX27_PCMCIA_PIPR	0x00
#define MX27_PCMCIA_PSCR	0x04
#define MX27_PCMCIA_PER		0x08
#define MX27_PCMCIA_PBR(x)	(0x0c + ((x) << 2))
#define MX27_PCMCIA_POR(x)	(0x28 + ((x) << 2))
#define MX27_PCMCIA_POFR(x)	(0x44 + ((x) << 2))
#define MX27_PCMCIA_PGCR	0x60
#define MX27_PCMCIA_PGSR	0x64

/* AIPI (base: MX27_AIPI_BASE_ADDR) */
#define MX27_AIPI1_PSR0	0x00
#define MX27_AIPI1_PSR1	0x04
#define MX27_AIPI2_PSR0	(0x20000 + 0x00)
#define MX27_AIPI2_PSR1	(0x20000 + 0x04)

/* System Control (base: MX27_SYSCTRL_BASE_ADDR) */
#define MX27_CID	0x0	/* Chip ID Register */
#define MX27_FMCR	0x14	/* Function Multeplexing Control Register */
#define MX27_GPCR	0x18	/* Global Peripheral Control Register */
#define MX27_WBCR	0x1C	/* Well Bias Control Register */
#define MX27_DSCR(x)	(0x1C + ((x) << 2))	/* Driving Strength Control Register 1 - 13 */

/* PLL registers (base: MX27_CCM_BASE_ADDR) */
#define MX27_CSCR	0x00 /* Clock Source Control Register       */
#define MX27_MPCTL0	0x04 /* MCU PLL Control Register 0          */
#define MX27_MPCTL1	0x08 /* MCU PLL Control Register 1          */
#define MX27_SPCTL0	0x0c /* System PLL Control Register 0       */
#define MX27_SPCTL1	0x10 /* System PLL Control Register 1       */
#define MX27_OSC26MCTL	0x14 /* Oscillator 26M Register             */
#define MX27_PCDR0	0x18 /* Peripheral Clock Divider Register 0 */
#define MX27_PCDR1	0x1c /* Peripheral Clock Divider Register 1 */
#define MX27_PCCR0	0x20 /* Peripheral Clock Control Register 0 */
#define MX27_PCCR1	0x24 /* Peripheral Clock Control Register 1 */
#define MX27_CCSR	0x28 /* Clock Control Status Register       */

#define MX27_CSCR_MPEN		(1 << 0)
#define MX27_CSCR_SPEN		(1 << 1)
#define MX27_CSCR_FPM_EN	(1 << 2)
#define MX27_CSCR_OSC26M_DIS	(1 << 3)
#define MX27_CSCR_OSC26M_DIV1P5	(1 << 4)
#define MX27_CSCR_AHB_DIV(d)	(((d) & 0x3) << 8)
#define MX27_CSCR_ARM_DIV(d)	(((d) & 0x3) << 12)
#define MX27_CSCR_ARM_SRC_MPLL	(1 << 15)
#define MX27_CSCR_MCU_SEL	(1 << 16)
#define MX27_CSCR_SP_SEL	(1 << 17)
#define MX27_CSCR_MPLL_RESTART	(1 << 18)
#define MX27_CSCR_SPLL_RESTART	(1 << 19)
#define MX27_CSCR_MSHC_SEL	(1 << 20)
#define MX27_CSCR_H264_SEL	(1 << 21)
#define MX27_CSCR_SSI1_SEL	(1 << 22)
#define MX27_CSCR_SSI2_SEL	(1 << 23)
#define MX27_CSCR_SD_CNT(d)	(((d) & 0x3) << 24)
#define MX27_CSCR_USB_DIV(d)	(((d) & 0x7) << 28)
#define MX27_CSCR_UPDATE_DIS	(1 << 31)

#define MX27_MPCTL1_BRMO	(1 << 6)
#define MX27_MPCTL1_LF		(1 << 15)

#endif /* _IMX27_REGS_H */
