/* SPDX-License-Identifier: GPL-2.0-or-later */
/* SPDX-FileCopyrightText: 2010-2011 Freescale Semiconductor, Inc. */

#ifndef __ARCH_ARM_MACH_MX6_CRM_REGS_H__
#define __ARCH_ARM_MACH_MX6_CRM_REGS_H__

#define MXC_CCM_BASE   MX6_CCM_BASE_ADDR

/* Register addresses of CCM*/
#define MXC_CCM_CCR		(MXC_CCM_BASE + 0x00)
#define MXC_CCM_CCDR		(MXC_CCM_BASE + 0x04)
#define MXC_CCM_CSR		(MXC_CCM_BASE + 0x08)
#define MXC_CCM_CCSR		(MXC_CCM_BASE + 0x0C)
#define MXC_CCM_CACRR		(MXC_CCM_BASE + 0x10)
#define MXC_CCM_CBCDR		(MXC_CCM_BASE + 0x14)
#define MXC_CCM_CBCMR		(MXC_CCM_BASE + 0x18)
#define MXC_CCM_CSCMR1		(MXC_CCM_BASE + 0x1C)
#define MXC_CCM_CSCMR2		(MXC_CCM_BASE + 0x20)
#define MXC_CCM_CSCDR1		(MXC_CCM_BASE + 0x24)
#define MXC_CCM_CS1CDR		(MXC_CCM_BASE + 0x28)
#define MXC_CCM_CS2CDR		(MXC_CCM_BASE + 0x2C)
#define MXC_CCM_CDCDR		(MXC_CCM_BASE + 0x30)
#define MXC_CCM_CHSCDR		(MXC_CCM_BASE + 0x34)
#define MXC_CCM_CSCDR2		(MXC_CCM_BASE + 0x38)
#define MXC_CCM_CSCDR3		(MXC_CCM_BASE + 0x3C)
#define MXC_CCM_CSCDR4		(MXC_CCM_BASE + 0x40)
#define MXC_CCM_CWDR		(MXC_CCM_BASE + 0x44)
#define MXC_CCM_CDHIPR		(MXC_CCM_BASE + 0x48)
#define MXC_CCM_CDCR		(MXC_CCM_BASE + 0x4C)
#define MXC_CCM_CTOR		(MXC_CCM_BASE + 0x50)
#define MXC_CCM_CLPCR		(MXC_CCM_BASE + 0x54)
#define MXC_CCM_CISR		(MXC_CCM_BASE + 0x58)
#define MXC_CCM_CIMR		(MXC_CCM_BASE + 0x5C)
#define MXC_CCM_CCOSR		(MXC_CCM_BASE + 0x60)
#define MXC_CCM_CGPR		(MXC_CCM_BASE + 0x64)
#define MXC_CCM_CCGR0		(MXC_CCM_BASE + 0x68)
#define MXC_CCM_CCGR1		(MXC_CCM_BASE + 0x6C)
#define MXC_CCM_CCGR2		(MXC_CCM_BASE + 0x70)
#define MXC_CCM_CCGR3		(MXC_CCM_BASE + 0x74)
#define MXC_CCM_CCGR4		(MXC_CCM_BASE + 0x78)
#define MXC_CCM_CCGR5		(MXC_CCM_BASE + 0x7C)
#define MXC_CCM_CCGR6		(MXC_CCM_BASE + 0x80)
#define MXC_CCM_CCGR7		(MXC_CCM_BASE + 0x80)
#define MXC_CCM_CMEOR		(MXC_CCM_BASE + 0x88)

/* Define the bits in register CCR */
#define MXC_CCM_CCR_RBC_EN				(1 << 27)
#define MXC_CCM_CCR_REG_BYPASS_CNT_MASK 		(0x3F << 21)
#define MXC_CCM_CCR_REG_BYPASS_CNT_OFFSET 		(21)
#define MXC_CCM_CCR_WB_COUNT_MASK 			(0x7)
#define MXC_CCM_CCR_WB_COUNT_OFFSET			(1 << 16)
#define MXC_CCM_CCR_COSC_EN				(1 << 12)
#define MXC_CCM_CCR_OSCNT_MASK				(0xFF)
#define MXC_CCM_CCR_OSCNT_OFFSET			(0)

/* Define the bits in register CCDR */
#define MXC_CCM_CCDR_MMDC_CH1_HS_MASK			(1 << 16)
#define MXC_CCM_CCDR_MMDC_CH0_HS_MASK			(1 << 17)

/* Define the bits in register CSR */
#define MXC_CCM_CSR_COSC_READY				(1 << 5)
#define MXC_CCM_CSR_REF_EN_B				(1 << 0)

/* Define the bits in register CCSR */
#define MXC_CCM_CCSR_PDF_540M_AUTO_DIS			(1 << 15)
#define MXC_CCM_CCSR_PDF_720M_AUTO_DIS			(1 << 14)
#define MXC_CCM_CCSR_PDF_454M_AUTO_DIS			(1 << 13)
#define MXC_CCM_CCSR_PDF_508M_AUTO_DIS			(1 << 12)
#define MXC_CCM_CCSR_PDF_594M_AUTO_DIS			(1 << 11)
#define MXC_CCM_CCSR_PDF_352M_AUTO_DIS			(1 << 10)
#define MXC_CCM_CCSR_PDF_400M_AUTO_DIS			(1 << 9)
#define MXC_CCM_CCSR_STEP_SEL				(1 << 8)
#define MXC_CCM_CCSR_PLL1_SW_CLK_SEL			(1 << 2)
#define MXC_CCM_CCSR_PLL2_SW_CLK_SEL			(1 << 1)
#define MXC_CCM_CCSR_PLL3_SW_CLK_SEL			(1 << 0)

/* Define the bits in register CACRR */
#define MXC_CCM_CACRR_ARM_PODF_OFFSET			(0)
#define MXC_CCM_CACRR_ARM_PODF_MASK			(0x7)

/* Define the bits in register CBCDR */
#define MXC_CCM_CBCDR_PERIPH_CLK2_PODF_MASK		(0x7 << 27)
#define MXC_CCM_CBCDR_PERIPH_CLK2_PODF_OFFSET		(27)
#define MXC_CCM_CBCDR_PERIPH2_CLK2_SEL			(1 << 26)
#define MXC_CCM_CBCDR_PERIPH_CLK_SEL			(1 << 25)
#define MXC_CCM_CBCDR_MMDC_CH0_PODF_MASK		(0x7 << 19)
#define MXC_CCM_CBCDR_MMDC_CH0_PODF_OFFSET		(19)
#define MXC_CCM_CBCDR_AXI_PODF_MASK			(0x7 << 16)
#define MXC_CCM_CBCDR_AXI_PODF_OFFSET			(16)
#define MXC_CCM_CBCDR_AHB_PODF_MASK			(0x7 << 10)
#define MXC_CCM_CBCDR_AHB_PODF_OFFSET			(10)
#define MXC_CCM_CBCDR_IPG_PODF_MASK			(0x3 << 8)
#define MXC_CCM_CBCDR_IPG_PODF_OFFSET			(8)
#define MXC_CCM_CBCDR_AXI_ALT_SEL			(1 << 7)
#define MXC_CCM_CBCDR_AXI_SEL				(1 << 6)
#define MXC_CCM_CBCDR_MMDC_CH1_PODF_MASK		(0x7 << 3)
#define MXC_CCM_CBCDR_MMDC_CH1_PODF_OFFSET		(3)
#define MXC_CCM_CBCDR_PERIPH2_CLK2_PODF_MASK		(0x7 << 0)
#define MXC_CCM_CBCDR_PERIPH2_CLK2_PODF_OFFSET		(0)

/* Define the bits in register CBCMR */
#define MXC_CCM_CBCMR_GPU3D_SHADER_PODF_MASK		(0x7 << 29)
#define MXC_CCM_CBCMR_GPU3D_SHADER_PODF_OFFSET		(29)
#define MXC_CCM_CBCMR_GPU3D_CORE_PODF_MASK		(0x7 << 26)
#define MXC_CCM_CBCMR_GPU3D_CORE_PODF_OFFSET		(26)
#define MXC_CCM_CBCMR_GPU2D_CORE_PODF_MASK		(0x7 << 23)
#define MXC_CCM_CBCMR_GPU2D_CORE_PODF_OFFSET		(23)
#define MXC_CCM_CBCMR_PRE_PERIPH2_CLK_SEL_MASK		(0x3 << 21)
#define MXC_CCM_CBCMR_PRE_PERIPH2_CLK_SEL_OFFSET	(21)
#define MXC_CCM_CBCMR_PRE_PERIPH2_CLK2_SEL		(1 << 20)
#define MXC_CCM_CBCMR_PRE_PERIPH_CLK_SEL_MASK		(0x3 << 18)
#define MXC_CCM_CBCMR_PRE_PERIPH_CLK_SEL_OFFSET		(18)
#define MXC_CCM_CBCMR_GPU2D_CLK_SEL_MASK		(0x3 << 16)
#define MXC_CCM_CBCMR_GPU2D_CLK_SEL_OFFSET		(16)
#define MXC_CCM_CBCMR_VPU_AXI_CLK_SEL_MASK		(0x3 << 14)
#define MXC_CCM_CBCMR_VPU_AXI_CLK_SEL_OFFSET		(14)
#define MXC_CCM_CBCMR_PERIPH_CLK2_SEL_MASK		(0x3 << 12)
#define MXC_CCM_CBCMR_PERIPH_CLK2_SEL_OFFSET		(12)
#define MXC_CCM_CBCMR_VDOAXI_CLK_SEL			(1 << 11)
#define MXC_CCM_CBCMR_PCIE_AXI_CLK_SEL			(1 << 10)
#define MXC_CCM_CBCMR_GPU3D_SHADER_CLK_SEL_MASK		(0x3 << 8)
#define MXC_CCM_CBCMR_GPU3D_SHADER_CLK_SEL_OFFSET	(8)
#define MXC_CCM_CBCMR_GPU3D_CORE_CLK_SEL_MASK		(0x3 << 4)
#define MXC_CCM_CBCMR_GPU3D_CORE_CLK_SEL_OFFSET		(4)
#define MXC_CCM_CBCMR_GPU3D_AXI_CLK_SEL			(1 << 1)
#define MXC_CCM_CBCMR_GPU2D_AXI_CLK_SEL			(1 << 0)

/* Define the bits in register CSCMR1 */
#define MXC_CCM_CSCMR1_ACLK_EMI_SLOW_MASK		(0x3 << 29)
#define MXC_CCM_CSCMR1_ACLK_EMI_SLOW_OFFSET		(29)
#define MXC_CCM_CSCMR1_ACLK_EMI_MASK			(0x3 << 27)
#define MXC_CCM_CSCMR1_ACLK_EMI_OFFSET			(27)
#define MXC_CCM_CSCMR1_ACLK_EMI_SLOW_PODF_MASK		(0x7 << 23)
#define MXC_CCM_CSCMR1_ACLK_EMI_SLOW_PODF_OFFSET	(23)
#define MXC_CCM_CSCMR1_ACLK_EMI_PODF_MASK		(0x7 << 20)
#define MXC_CCM_CSCMR1_ACLK_EMI_PODF_OFFSET		(20)
#define MXC_CCM_CSCMR1_USDHC4_CLK_SEL			(1 << 19)
#define MXC_CCM_CSCMR1_USDHC3_CLK_SEL			(1 << 18)
#define MXC_CCM_CSCMR1_USDHC2_CLK_SEL			(1 << 17)
#define MXC_CCM_CSCMR1_USDHC1_CLK_SEL			(1 << 16)
#define MXC_CCM_CSCMR1_SSI3_CLK_SEL_MASK		(0x3 << 14)
#define MXC_CCM_CSCMR1_SSI3_CLK_SEL_OFFSET		(14)
#define MXC_CCM_CSCMR1_SSI2_CLK_SEL_MASK		(0x3 << 12)
#define MXC_CCM_CSCMR1_SSI2_CLK_SEL_OFFSET		(12)
#define MXC_CCM_CSCMR1_SSI1_CLK_SEL_MASK		(0x3 << 10)
#define MXC_CCM_CSCMR1_SSI1_CLK_SEL_OFFSET		(10)
#define MXC_CCM_CSCMR1_PERCLK_PODF_MASK			(0x3F)

/* Define the bits in register CSCMR2 */
#define MXC_CCM_CSCMR2_ESAI_PRE_SEL_MASK		(0x3 << 19)
#define MXC_CCM_CSCMR2_ESAI_PRE_SEL_OFFSET		(19)
#define MXC_CCM_CSCMR2_LDB_DI1_IPU_DIV			(1 << 11)
#define MXC_CCM_CSCMR2_LDB_DI0_IPU_DIV			(1 << 10)
#define MXC_CCM_CSCMR2_CAN_CLK_SEL_MASK			(0x3F << 2)
#define MXC_CCM_CSCMR2_CAN_CLK_SEL_OFFSET		(2)

/* Define the bits in register CSCDR1 */
#define MXC_CCM_CSCDR1_VPU_AXI_PODF_MASK		(0x7 << 25)
#define MXC_CCM_CSCDR1_VPU_AXI_PODF_OFFSET		(25)
#define MXC_CCM_CSCDR1_USDHC4_PODF_MASK			(0x7 << 22)
#define MXC_CCM_CSCDR1_USDHC4_PODF_OFFSET		(22)
#define MXC_CCM_CSCDR1_USDHC3_PODF_MASK			(0x7 << 19)
#define MXC_CCM_CSCDR1_USDHC3_PODF_OFFSET		(19)
#define MXC_CCM_CSCDR1_USDHC2_PODF_MASK			(0x7 << 16)
#define MXC_CCM_CSCDR1_USDHC2_PODF_OFFSET		(16)
#define MXC_CCM_CSCDR1_USDHC1_PODF_MASK			(0x7 << 11)
#define MXC_CCM_CSCDR1_USDHC1_PODF_OFFSET		(11)
#define MXC_CCM_CSCDR1_USBOH3_CLK_PRED_OFFSET		(8)
#define MXC_CCM_CSCDR1_USBOH3_CLK_PRED_MASK		(0x7 << 8)
#define MXC_CCM_CSCDR1_USBOH3_CLK_PODF_OFFSET		(6)
#define MXC_CCM_CSCDR1_USBOH3_CLK_PODF_MASK		(0x3 << 6)
#define MXC_CCM_CSCDR1_UART_CLK_PODF_MASK		(0x3F)
#define MXC_CCM_CSCDR1_UART_CLK_PODF_OFFSET		(0)

/* Define the bits in register CS1CDR */
#define MXC_CCM_CS1CDR_ESAI_CLK_PODF_MASK		(0x3F << 25)
#define MXC_CCM_CS1CDR_ESAI_CLK_PODF_OFFSET		(25)
#define MXC_CCM_CS1CDR_SSI3_CLK_PODF_MASK		(0x3F << 16)
#define MXC_CCM_CS1CDR_SSI3_CLK_PODF_OFFSET		(16)
#define MXC_CCM_CS1CDR_ESAI_CLK_PRED_MASK		(0x3 << 9)
#define MXC_CCM_CS1CDR_ESAI_CLK_PRED_OFFSET		(9)
#define MXC_CCM_CS1CDR_SSI1_CLK_PRED_MASK		(0x7 << 6)
#define MXC_CCM_CS1CDR_SSI1_CLK_PRED_OFFSET		(6)
#define MXC_CCM_CS1CDR_SSI1_CLK_PODF_MASK		(0x3F)
#define MXC_CCM_CS1CDR_SSI1_CLK_PODF_OFFSET		(0)

/* Define the bits in register CS2CDR */
#define MXC_CCM_CS2CDR_ENFC_CLK_PODF_MASK		(0x3F << 21)
#define MXC_CCM_CS2CDR_ENFC_CLK_PODF_OFFSET		(21)
#define MXC_CCM_CS2CDR_ENFC_CLK_PRED_MASK		(0x7 << 18)
#define MXC_CCM_CS2CDR_ENFC_CLK_PRED_OFFSET		(18)
#define MXC_CCM_CS2CDR_ENFC_CLK_SEL_MASK		(0x3 << 16)
#define MXC_CCM_CS2CDR_ENFC_CLK_SEL_OFFSET		(16)
#define MXC_CCM_CS2CDR_LDB_DI1_CLK_SEL_MASK		(0x7 << 12)
#define MXC_CCM_CS2CDR_LDB_DI1_CLK_SEL_OFFSET		(12)
#define MXC_CCM_CS2CDR_LDB_DI0_CLK_SEL_MASK		(0x7 << 9)
#define MXC_CCM_CS2CDR_LDB_DI0_CLK_SEL_OFFSET		(9)
#define MXC_CCM_CS2CDR_SSI2_CLK_PRED_MASK		(0x7 << 6)
#define MXC_CCM_CS2CDR_SSI2_CLK_PRED_OFFSET		(6)
#define MXC_CCM_CS2CDR_SSI2_CLK_PODF_MASK		(0x3F)
#define MXC_CCM_CS2CDR_SSI2_CLK_PODF_OFFSET		(0)

/* Define the bits in register CDCDR */
#define MXC_CCM_CDCDR_HSI_TX_PODF_MASK			(0x7 << 29)
#define MXC_CCM_CDCDR_HSI_TX_PODF_OFFSET		(29)
#define MXC_CCM_CDCDR_HSI_TX_CLK_SEL			(1 << 28)
#define MXC_CCM_CDCDR_SPDIF0_CLK_PRED_MASK		(0x7 << 25)
#define MXC_CCM_CDCDR_SPDIF0_CLK_PRED_OFFSET		(25)
#define MXC_CCM_CDCDR_SPDIF0_CLK_PODF_MASK		(0x7 << 19)
#define MXC_CCM_CDCDR_SPDIF0_CLK_PODF_OFFSET		(19)
#define MXC_CCM_CDCDR_SPDIF0_CLK_SEL_MASK		(0x3 << 20)
#define MXC_CCM_CDCDR_SPDIF0_CLK_SEL_OFFSET		(20)
#define MXC_CCM_CDCDR_SPDIF1_CLK_PRED_MASK		(0x7 << 12)
#define MXC_CCM_CDCDR_SPDIF1_CLK_PRED_OFFSET		(12)
#define MXC_CCM_CDCDR_SPDIF1_CLK_PODF_MASK		(0x7 << 9)
#define MXC_CCM_CDCDR_SPDIF1_CLK_PODF_OFFSET		(9)
#define MXC_CCM_CDCDR_SPDIF1_CLK_SEL_MASK		(0x3 << 7)
#define MXC_CCM_CDCDR_SPDIF1_CLK_SEL_OFFSET		(7)

/* Define the bits in register CHSCCDR */
#define MXC_CCM_CHSCCDR_IPU1_DI1_PRE_CLK_SEL_MASK	(0x7 << 15)
#define MXC_CCM_CHSCCDR_IPU1_DI1_PRE_CLK_SEL_OFFSET	(15)
#define MXC_CCM_CHSCCDR_IPU1_DI1_PODF_MASK		(0x7 << 12)
#define MXC_CCM_CHSCCDR_IPU1_DI1_PODF_OFFSET		(12)
#define MXC_CCM_CHSCCDR_IPU1_DI1_CLK_SEL_MASK		(0x7 << 9)
#define MXC_CCM_CHSCCDR_IPU1_DI1_CLK_SEL_OFFSET		(9)
#define MXC_CCM_CHSCCDR_IPU1_DI0_PRE_CLK_SEL_MASK	(0x7 << 6)
#define MXC_CCM_CHSCCDR_IPU1_DI0_PRE_CLK_SEL_OFFSET	(6)
#define MXC_CCM_CHSCCDR_IPU1_DI0_PODF_MASK		(0x7 << 3)
#define MXC_CCM_CHSCCDR_IPU1_DI0_PODF_OFFSET		(3)
#define MXC_CCM_CHSCCDR_IPU1_DI0_CLK_SEL_MASK		(0x7)
#define MXC_CCM_CHSCCDR_IPU1_DI0_CLK_SEL_OFFSET		(0)

/* Define the bits in register CSCDR2 */
#define MXC_CCM_CSCDR2_ECSPI_CLK_PODF_MASK		(0x3F << 19)
#define MXC_CCM_CSCDR2_ECSPI_CLK_PODF_OFFSET		(19)
#define MXC_CCM_CHSCCDR_IPU2_DI1_PRE_CLK_SEL_MASK	(0x7 << 15)
#define MXC_CCM_CHSCCDR_IPU2_DI1_PRE_CLK_SEL_OFFSET	(15)
#define MXC_CCM_CHSCCDR_IPU2_DI1_PODF_MASK		(0x7 << 12)
#define MXC_CCM_CHSCCDR_IPU2_DI1_PODF_OFFSET		(12)
#define MXC_CCM_CHSCCDR_IPU2_DI1_CLK_SEL_MASK		(0x7 << 9)
#define MXC_CCM_CHSCCDR_IPU2_DI1_CLK_SEL_OFFSET		(9)
#define MXC_CCM_CHSCCDR_IPU2_DI0_PRE_CLK_SEL_MASK	(0x7 << 6)
#define MXC_CCM_CHSCCDR_IPU2_DI0_PRE_CLK_SEL_OFFSET	(6)
#define MXC_CCM_CHSCCDR_IPU2_DI0_PODF_MASK		(0x7 << 3)
#define MXC_CCM_CHSCCDR_IPU2_DI0_PODF_OFFSET		(3)
#define MXC_CCM_CHSCCDR_IPU2_DI0_CLK_SEL_MASK		(0x7)
#define MXC_CCM_CHSCCDR_IPU2_DI0_CLK_SEL_OFFSET		(0)

/* Define the bits in register CSCDR3 */
#define MXC_CCM_CSCDR3_IPU2_HSP_PODF_MASK		(0x7 << 16)
#define MXC_CCM_CSCDR3_IPU2_HSP_PODF_OFFSET		(16)
#define MXC_CCM_CSCDR3_IPU2_HSP_CLK_SEL_MASK		(0x3 << 14)
#define MXC_CCM_CSCDR3_IPU2_HSP_CLK_SEL_OFFSET		(14)
#define MXC_CCM_CSCDR3_IPU1_HSP_PODF_MASK		(0x7 << 11)
#define MXC_CCM_CSCDR3_IPU1_HSP_PODF_OFFSET		(11)
#define MXC_CCM_CSCDR3_IPU1_HSP_CLK_SEL_MASK		(0x3 << 9)
#define MXC_CCM_CSCDR3_IPU1_HSP_CLK_SEL_OFFSET		(9)

/* Define the bits in register CDHIPR */
#define MXC_CCM_CDHIPR_ARM_PODF_BUSY			(1 << 16)
#define MXC_CCM_CDHIPR_PERIPH_CLK_SEL_BUSY		(1 << 5)
#define MXC_CCM_CDHIPR_MMDC_CH0_PODF_BUSY		(1 << 4)
#define MXC_CCM_CDHIPR_PERIPH2_CLK_SEL_BUSY		(1 << 3)
#define MXC_CCM_CDHIPR_MMDC_CH1_PODF_BUSY		(1 << 2)
#define MXC_CCM_CDHIPR_AHB_PODF_BUSY			(1 << 1)
#define MXC_CCM_CDHIPR_AXI_PODF_BUSY			(1)

/* Define the bits in register CLPCR */
#define MXC_CCM_CLPCR_MASK_L2CC_IDLE			(1 << 27)
#define MXC_CCM_CLPCR_MASK_SCU_IDLE			(1 << 26)
#define MXC_CCM_CLPCR_MASK_CORE3_WFI			(1 << 25)
#define MXC_CCM_CLPCR_MASK_CORE2_WFI			(1 << 24)
#define MXC_CCM_CLPCR_MASK_CORE1_WFI			(1 << 23)
#define MXC_CCM_CLPCR_MASK_CORE0_WFI			(1 << 22)
#define MXC_CCM_CLPCR_BYP_MMDC_CH1_LPM_HS		(1 << 21)
#define MXC_CCM_CLPCR_BYP_MMDC_CH0_LPM_HS		(1 << 19)
#define MXC_CCM_CLPCR_WB_CORE_AT_LPM			(1 << 17)
#define MXC_CCM_CLPCR_WB_PER_AT_LPM			(1 << 17)
#define MXC_CCM_CLPCR_COSC_PWRDOWN			(1 << 11)
#define MXC_CCM_CLPCR_STBY_COUNT_MASK			(0x3 << 9)
#define MXC_CCM_CLPCR_STBY_COUNT_OFFSET			(9)
#define MXC_CCM_CLPCR_VSTBY				(1 << 8)
#define MXC_CCM_CLPCR_DIS_REF_OSC			(1 << 7)
#define MXC_CCM_CLPCR_SBYOS				(1 << 6)
#define MXC_CCM_CLPCR_ARM_CLK_DIS_ON_LPM		(1 << 5)
#define MXC_CCM_CLPCR_LPSR_CLK_SEL_MASK			(0x3 << 3)
#define MXC_CCM_CLPCR_LPSR_CLK_SEL_OFFSET		(3)
#define MXC_CCM_CLPCR_BYPASS_PMIC_VFUNC_READY		(1 << 2)
#define MXC_CCM_CLPCR_LPM_MASK				(0x3)
#define MXC_CCM_CLPCR_LPM_OFFSET			(0)

/* Define the bits in register CISR */
#define MXC_CCM_CISR_ARM_PODF_LOADED			(1 << 26)
#define MXC_CCM_CISR_MMDC_CH0_PODF_LOADED		(1 << 23)
#define MXC_CCM_CISR_PERIPH_CLK_SEL_LOADED		(1 << 22)
#define MXC_CCM_CISR_MMDC_CH1_PODF_LOADED		(1 << 21)
#define MXC_CCM_CISR_AHB_PODF_LOADED			(1 << 20)
#define MXC_CCM_CISR_PERIPH2_CLK_SEL_LOADED		(1 << 19)
#define MXC_CCM_CISR_AXI_PODF_LOADED			(1 << 17)
#define MXC_CCM_CISR_COSC_READY				(1 << 6)
#define MXC_CCM_CISR_LRF_PLL				(1)

/* Define the bits in register CIMR */
#define MXC_CCM_CIMR_MASK_ARM_PODF_LOADED		(1 << 26)
#define MXC_CCM_CIMR_MASK_MMDC_CH0_PODF_LOADED		(1 << 23)
#define MXC_CCM_CIMR_MASK_PERIPH_CLK_SEL_LOADED		(1 << 22)
#define MXC_CCM_CIMR_MASK_MMDC_CH1_PODF_LOADED		(1 << 21)
#define MXC_CCM_CIMR_MASK_AHB_PODF_LOADED		(1 << 20)
#define MXC_CCM_CIMR_MASK_PERIPH2_CLK_SEL_LOADED	(1 << 22)
#define MXC_CCM_CIMR_MASK_AXI_PODF_LOADED		(1 << 17)
#define MXC_CCM_CIMR_MASK_COSC_READY			(1 << 6)
#define MXC_CCM_CIMR_MASK_LRF_PLL			(1)

/* Define the bits in register CCOSR */
#define MXC_CCM_CCOSR_CKO2_EN_OFFSET			(1 << 24)
#define MXC_CCM_CCOSR_CKO2_DIV_MASK			(0x7 << 21)
#define MXC_CCM_CCOSR_CKO2_DIV_OFFSET			(21)
#define MXC_CCM_CCOSR_CKO2_SEL_OFFSET			(16)
#define MXC_CCM_CCOSR_CKO2_SEL_MASK			(0x1F << 16)
#define MXC_CCM_CCOSR_CKOL_EN				(0x1 << 7)
#define MXC_CCM_CCOSR_CKOL_DIV_MASK			(0x7 << 4)
#define MXC_CCM_CCOSR_CKOL_DIV_OFFSET			(4)
#define MXC_CCM_CCOSR_CKOL_SEL_MASK			(0xF)
#define MXC_CCM_CCOSR_CKOL_SEL_OFFSET			(0)

/* Define the bits in registers CGPR */
#define MXC_CCM_CGPR_EFUSE_PROG_SUPPLY_GATE		(1 << 4)
#define MXC_CCM_CGPR_MMDC_EXT_CLK_DIS			(1 << 2)
#define MXC_CCM_CGPR_PMIC_DELAY_SCALER			(1)

#endif				/* __ARCH_ARM_MACH_MX6_CRM_REGS_H__ */
