/*
 * Copyright (c) 2014-2022, ARM Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef FIRMWARE_IMAGE_PACKAGE_H
#define FIRMWARE_IMAGE_PACKAGE_H

#include <linux/uuid.h>
#include <linux/types.h>

/* This is used as a signature to validate the blob header */
#define TOC_HEADER_NAME	0xAA640001


/* ToC Entry UUIDs */
#define UUID_TRUSTED_UPDATE_FIRMWARE_SCP_BL2U \
	UUID_INIT(0x65922703, 0x2f74, 0xe644, 0x8d, 0xff, 0x57, 0x9a, 0xc1, 0xff, 0x06, 0x10)
#define UUID_TRUSTED_UPDATE_FIRMWARE_BL2U \
	UUID_INIT(0x60b3eb37, 0xc1e5, 0xea41, 0x9d, 0xf3, 0x19, 0xed, 0xa1, 0x1f, 0x68, 0x01)
#define UUID_TRUSTED_UPDATE_FIRMWARE_NS_BL2U \
	UUID_INIT(0x4f511d11, 0x2be5, 0x4e49, 0xb4, 0xc5, 0x83, 0xc2, 0xf7, 0x15, 0x84, 0x0a)
#define UUID_TRUSTED_FWU_CERT \
	UUID_INIT(0x71408ab2, 0x18d6, 0x874c, 0x8b, 0x2e, 0xc6, 0xdc, 0xcd, 0x50, 0xf0, 0x96)
#define UUID_CCA_CONTENT_CERT \
	UUID_INIT(0x36d83d85, 0x761d, 0x4daf, 0x96, 0xf1, 0xcd, 0x99, 0xd6, 0x56, 0x9b, 0x00)
#define UUID_CORE_SWD_KEY_CERT \
	UUID_INIT(0x52222d31, 0x820f, 0x494d, 0x8b, 0xbc, 0xea, 0x68, 0x25, 0xd3, 0xc3, 0x5a)
#define UUID_PLAT_KEY_CERT \
	UUID_INIT(0xd43cd902, 0x5b9f, 0x412e, 0x8a, 0xc6, 0x92, 0xb6, 0xd1, 0x8b, 0xe6, 0x0d)
#define UUID_TRUSTED_BOOT_FIRMWARE_BL2 \
	UUID_INIT(0x5ff9ec0b, 0x4d22, 0x3e4d, 0xa5, 0x44, 0xc3, 0x9d, 0x81, 0xc7, 0x3f, 0x0a)
#define UUID_SCP_FIRMWARE_SCP_BL2 \
	UUID_INIT(0x9766fd3d, 0x89be, 0xe849, 0xae, 0x5d, 0x78, 0xa1, 0x40, 0x60, 0x82, 0x13)
#define UUID_EL3_RUNTIME_FIRMWARE_BL31 \
	UUID_INIT(0x47d4086d, 0x4cfe, 0x9846, 0x9b, 0x95, 0x29, 0x50, 0xcb, 0xbd, 0x5a, 0x00)
#define UUID_SECURE_PAYLOAD_BL32 \
	UUID_INIT(0x05d0e189, 0x53dc, 0x1347, 0x8d, 0x2b, 0x50, 0x0a, 0x4b, 0x7a, 0x3e, 0x38)
#define UUID_SECURE_PAYLOAD_BL32_EXTRA1 \
	UUID_INIT(0x0b70c29b, 0x2a5a, 0x7840, 0x9f, 0x65, 0x0a, 0x56, 0x82, 0x73, 0x82, 0x88)
#define UUID_SECURE_PAYLOAD_BL32_EXTRA2 \
	UUID_INIT(0x8ea87bb1, 0xcfa2, 0x3f4d, 0x85, 0xfd, 0xe7, 0xbb, 0xa5, 0x02, 0x20, 0xd9)
#define UUID_NON_TRUSTED_FIRMWARE_BL33 \
	UUID_INIT(0xd6d0eea7, 0xfcea, 0xd54b, 0x97, 0x82, 0x99, 0x34, 0xf2, 0x34, 0xb6, 0xe4)
#define UUID_REALM_MONITOR_MGMT_FIRMWARE \
	UUID_INIT(0x6c0762a6, 0x12f2, 0x4b56, 0x92, 0xcb, 0xba, 0x8f, 0x63, 0x36, 0x06, 0xd9)

/* Key certificates */
#define UUID_ROT_KEY_CERT \
	UUID_INIT(0x862d1d72, 0xf860, 0xe411, 0x92, 0x0b, 0x8b, 0xe7, 0x62, 0x16, 0x0f, 0x24)
#define UUID_TRUSTED_KEY_CERT \
	UUID_INIT(0x827ee890, 0xf860, 0xe411, 0xa1, 0xb4, 0x77, 0x7a, 0x21, 0xb4, 0xf9, 0x4c)
#define UUID_NON_TRUSTED_WORLD_KEY_CERT \
	UUID_INIT(0x1c67873d, 0x5f63, 0xe411, 0x97, 0x8d, 0x27, 0xc0, 0xc7, 0x14, 0x8a, 0xbd)
#define UUID_SCP_FW_KEY_CERT \
	UUID_INIT(0x024221a1, 0xf860, 0xe411, 0x8d, 0x9b, 0xf3, 0x3c, 0x0e, 0x15, 0xa0, 0x14)
#define UUID_SOC_FW_KEY_CERT \
	UUID_INIT(0x8ab8becc, 0xf960, 0xe411, 0x9a, 0xd0, 0xeb, 0x48, 0x22, 0xd8, 0xdc, 0xf8)
#define UUID_TRUSTED_OS_FW_KEY_CERT \
	UUID_INIT(0x9477d603, 0xfb60, 0xe411, 0x85, 0xdd, 0xb7, 0x10, 0x5b, 0x8c, 0xee, 0x04)
#define UUID_NON_TRUSTED_FW_KEY_CERT \
	UUID_INIT(0x8ad5832a, 0xfb60, 0xe411, 0x8a, 0xaf, 0xdf, 0x30, 0xbb, 0xc4, 0x98, 0x59)

/* Content certificates */
#define UUID_TRUSTED_BOOT_FW_CERT \
	UUID_INIT(0xd6e269ea, 0x5d63, 0xe411, 0x8d, 0x8c, 0x9f, 0xba, 0xbe, 0x99, 0x56, 0xa5)
#define UUID_SCP_FW_CONTENT_CERT \
	UUID_INIT(0x44be6f04, 0x5e63, 0xe411, 0xb2, 0x8b, 0x73, 0xd8, 0xea, 0xae, 0x96, 0x56)
#define UUID_SOC_FW_CONTENT_CERT \
	UUID_INIT(0xe2b20c20, 0x5e63, 0xe411, 0x9c, 0xe8, 0xab, 0xcc, 0xf9, 0x2b, 0xb6, 0x66)
#define UUID_TRUSTED_OS_FW_CONTENT_CERT \
	UUID_INIT(0xa49f4411, 0x5e63, 0xe411, 0x87, 0x28, 0x3f, 0x05, 0x72, 0x2a, 0xf3, 0x3d)
#define UUID_NON_TRUSTED_FW_CONTENT_CERT \
	UUID_INIT(0x8ec4c1f3, 0x5d63, 0xe411, 0xa7, 0xa9, 0x87, 0xee, 0x40, 0xb2, 0x3f, 0xa7)
#define UUID_SIP_SECURE_PARTITION_CONTENT_CERT \
	UUID_INIT(0x776dfd44, 0x8697, 0x4c3b, 0x91, 0xeb, 0xc1, 0x3e, 0x02, 0x5a, 0x2a, 0x6f)
#define UUID_PLAT_SECURE_PARTITION_CONTENT_CERT \
	UUID_INIT(0xddcbbf4a, 0xcad6, 0x11ea, 0x87, 0xd0, 0x02, 0x42, 0xac, 0x13, 0x00, 0x03)

/* Dynamic configs */
#define UUID_HW_CONFIG \
	UUID_INIT(0x08b8f1d9, 0xc9cf, 0x9349, 0xa9, 0x62, 0x6f, 0xbc, 0x6b, 0x72, 0x65, 0xcc)
#define UUID_TB_FW_CONFIG \
	UUID_INIT(0x6c0458ff, 0xaf6b, 0x7d4f, 0x82, 0xed, 0xaa, 0x27, 0xbc, 0x69, 0xbf, 0xd2)
#define UUID_SOC_FW_CONFIG \
	UUID_INIT(0x9979814b, 0x0376, 0xfb46, 0x8c, 0x8e, 0x8d, 0x26, 0x7f, 0x78, 0x59, 0xe0)
#define UUID_TOS_FW_CONFIG \
	UUID_INIT(0x26257c1a, 0xdbc6, 0x7f47, 0x8d, 0x96, 0xc4, 0xc4, 0xb0, 0x24, 0x80, 0x21)
#define UUID_NT_FW_CONFIG \
	UUID_INIT(0x28da9815, 0x93e8, 0x7e44, 0xac, 0x66, 0x1a, 0xaf, 0x80, 0x15, 0x50, 0xf9)
#define UUID_FW_CONFIG \
	UUID_INIT(0x5807e16a, 0x8459, 0x47be, 0x8e, 0xd5, 0x64, 0x8e, 0x8d, 0xdd, 0xab, 0x0e)

#define UUID_STM32MP_CONFIG_CERT \
	UUID_INIT(0x501d8dd2, 0x8bce, 0x49a5, 0x84, 0xeb, 0x55, 0x9a, 0x9f, 0x2e, 0xae, 0xaf)

typedef struct fip_toc_header {
	uint32_t	name;
	uint32_t	serial_number;
	uint64_t	flags;
} fip_toc_header_t;

typedef struct fip_toc_entry {
	uuid_t		uuid;
	uint64_t	offset_address;
	uint64_t	size;
	uint64_t	flags;
} fip_toc_entry_t;

#endif /* FIRMWARE_IMAGE_PACKAGE_H */
