// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright 2019 NXP
 *
 * Generated code from MX8M_DDR_tool
 * Align with uboot-imx_v2018.03_4.14.78_1.0.0_ga
 */

#include <common.h>
#include <soc/imx8m/ddr.h>

#define DDR_ONE_RANK
#include <soc/imx8m/lpddr4_define.h>

static struct dram_cfg_param ddr_ddrc_cfg[] = {
	{0x3d400020, 0x00000213},
	{0x3d400024, 0x0003e800},
	{0x3d400030, 0x00000120},
	{0x3d400000, 0xa3080020},
	{0x3d400064, 0x006100e0},
	{0x3d4000d0, 0xc003061c},
	{0x3d4000d4, 0x009e0000},
	{0x3d4000dc, 0x00d4002d},
	{0x3d4000e0, 0x00310000},
	{0x3d4000e8, 0x0066004d},
	{0x3d4000ec, 0x0016004a},
	{0x3d400100, 0x1a201b22},
	{0x3d400104, 0x00060633},
	{0x3d40010c, 0x00c0c000},
	{0x3d400110, 0x0f04080f},
	{0x3d400114, 0x02040c0c},
	{0x3d400118, 0x01010007},
	{0x3d40011c, 0x00000401},
	{0x3d400130, 0x00020600},
	{0x3d400134, 0x0c100002},
	{0x3d400138, 0x000000e6},
	{0x3d400144, 0x00a00050},
	{0x3d400180, 0x03200018},
	{0x3d400184, 0x028061a8},
	{0x3d400188, 0x00000000},
	{0x3d400190, 0x0497820a},
	{0x3d4001b4, 0x0000170a},
	{0x3d400108, 0x070e1617},
	{0x3d4001c0, 0x00000001},
	{0x3d400194, 0x00080303},
	{0x3d4001a0, 0xe0400018},
	{0x3d4001a4, 0x00df00e4},
	{0x3d4001a8, 0x80000000},
	{0x3d4001b0, 0x00000011},
	{0x3d4001c4, 0x00000001},
	{0x3d4000f4, 0x00000c99},
	{0x3d400200, 0x00000017},
	{0x3d400204, 0x00080808},
	{0x3d400208, 0x00000000},
	{0x3d40020c, 0x00000000},
	{0x3d400210, 0x00001f1f},
	{0x3d400214, 0x07070707},
	{0x3d400218, 0x07070707},
	{0x3d40021c, 0x00000f0f},
	{0x3d400250, 0x29001701},
	{0x3d400254, 0x0000002c},
	{0x3d40025c, 0x04000030},
	{0x3d400264, 0x900093e7},
	{0x3d40026c, 0x20005574},
	{0x3d400400, 0x00000111},
	{0x3d400408, 0x000072ff},
	{0x3d400494, 0x02100e07},
	{0x3d400498, 0x00620096},
	{0x3d40049c, 0x01100e07},
	{0x3d4004a0, 0x00c8012c},
	{0x3d402020, 0x00000011},
	{0x3d402024, 0x00007d00},
	{0x3d402050, 0x0020d040},
	{0x3d402064, 0x000c001d},
	{0x3d4020f4, 0x00000c99},
	{0x3d402100, 0x0a040305},
	{0x3d402104, 0x00030407},
	{0x3d402108, 0x0203060b},
	{0x3d40210c, 0x00505000},
	{0x3d402110, 0x02040202},
	{0x3d402114, 0x02030202},
	{0x3d402118, 0x01010004},
	{0x3d40211c, 0x00000301},
	{0x3d402130, 0x00020300},
	{0x3d402134, 0x0a100002},
	{0x3d402138, 0x0000001d},
	{0x3d402144, 0x0014000a},
	{0x3d402180, 0x00650004},
	{0x3d402190, 0x03818200},
	{0x3d402194, 0x00080303},
	{0x3d4021b4, 0x00000100},
	{0x3d4020dc, 0x00840000},
	{0x3d4020e0, 0x00310000},
	{0x3d4020e8, 0x0066004d},
	{0x3d4020ec, 0x0016004a},
	{0x3d403020, 0x00000011},
	{0x3d403024, 0x00001f40},
	{0x3d403050, 0x0020d040},
	{0x3d403064, 0x00030007},
	{0x3d4030f4, 0x00000c99},
	{0x3d403100, 0x0a010102},
	{0x3d403104, 0x00030404},
	{0x3d403108, 0x0203060b},
	{0x3d40310c, 0x00505000},
	{0x3d403110, 0x02040202},
	{0x3d403114, 0x02030202},
	{0x3d403118, 0x01010004},
	{0x3d40311c, 0x00000301},
	{0x3d403130, 0x00020300},
	{0x3d403134, 0x0a100002},
	{0x3d403138, 0x00000008},
	{0x3d403144, 0x00050003},
	{0x3d403180, 0x00190004},
	{0x3d403190, 0x03818200},
	{0x3d403194, 0x00080303},
	{0x3d4031b4, 0x00000100},
	{0x3d4030dc, 0x00840000},
	{0x3d4030e0, 0x00310000},
	{0x3d4030e8, 0x0066004d},
	{0x3d4030ec, 0x0016004a},

	/* default boot point */
	{ 0x3d400028, 0x0 },
};

/* PHY Initialize Configuration */
static struct dram_cfg_param ddr_ddrphy_cfg[] = {
	{0x000d0000, 0x00000000},
	{0x000100a0, 0x00000000},
	{0x000100a1, 0x00000001},
	{0x000100a2, 0x00000002},
	{0x000100a3, 0x00000003},
	{0x000100a4, 0x00000004},
	{0x000100a5, 0x00000005},
	{0x000100a6, 0x00000006},
	{0x000100a7, 0x00000007},
	{0x000110a0, 0x00000000},
	{0x000110a1, 0x00000001},
	{0x000110a2, 0x00000003},
	{0x000110a3, 0x00000004},
	{0x000110a4, 0x00000005},
	{0x000110a5, 0x00000002},
	{0x000110a6, 0x00000007},
	{0x000110a7, 0x00000006},
	{0x0001005f, 0x0000015f},
	{0x0001015f, 0x0000015f},
	{0x0001105f, 0x0000015f},
	{0x0001115f, 0x0000015f},
	{0x0011005f, 0x0000015f},
	{0x0011015f, 0x0000015f},
	{0x0011105f, 0x0000015f},
	{0x0011115f, 0x0000015f},
	{0x0021005f, 0x0000015f},
	{0x0021015f, 0x0000015f},
	{0x0021105f, 0x0000015f},
	{0x0021115f, 0x0000015f},
	{0x00000055, 0x0000016f},
	{0x00001055, 0x0000016f},
	{0x00002055, 0x0000016f},
	{0x00003055, 0x0000016f},
	{0x00004055, 0x0000016f},
	{0x00005055, 0x0000016f},
	{0x00006055, 0x0000016f},
	{0x00007055, 0x0000016f},
	{0x00008055, 0x0000016f},
	{0x00009055, 0x0000016f},
	{0x000200c5, 0x00000019},
	{0x001200c5, 0x00000007},
	{0x002200c5, 0x00000007},
	{0x0002002e, 0x00000002},
	{0x0012002e, 0x00000002},
	{0x0022002e, 0x00000002},
	{0x00090204, 0x00000000},
	{0x00190204, 0x00000000},
	{0x00290204, 0x00000000},
	{0x00020024, 0x000001a3},
	{0x0002003a, 0x00000002},
	{0x0002007d, 0x00000212},
	{0x0002007c, 0x00000061},
	{0x00120024, 0x000001a3},
	{0x0002003a, 0x00000002},
	{0x0012007d, 0x00000212},
	{0x0012007c, 0x00000061},
	{0x00220024, 0x000001a3},
	{0x0002003a, 0x00000002},
	{0x0022007d, 0x00000212},
	{0x0022007c, 0x00000061},
	{0x00020056, 0x00000003},
	{0x00120056, 0x00000003},
	{0x00220056, 0x00000003},
	{0x0001004d, 0x00000f80},
	{0x0001014d, 0x00000f80},
	{0x0001104d, 0x00000f80},
	{0x0001114d, 0x00000f80},
	{0x0011004d, 0x00000f80},
	{0x0011014d, 0x00000f80},
	{0x0011104d, 0x00000f80},
	{0x0011114d, 0x00000f80},
	{0x0021004d, 0x00000f80},
	{0x0021014d, 0x00000f80},
	{0x0021104d, 0x00000f80},
	{0x0021114d, 0x00000f80},
	{0x00010049, 0x00000fbe},
	{0x00010149, 0x00000fbe},
	{0x00011049, 0x00000fbe},
	{0x00011149, 0x00000fbe},
	{0x00110049, 0x00000fbe},
	{0x00110149, 0x00000fbe},
	{0x00111049, 0x00000fbe},
	{0x00111149, 0x00000fbe},
	{0x00210049, 0x00000fbe},
	{0x00210149, 0x00000fbe},
	{0x00211049, 0x00000fbe},
	{0x00211149, 0x00000fbe},
	{0x00000043, 0x00000063},
	{0x00001043, 0x00000063},
	{0x00002043, 0x00000063},
	{0x00003043, 0x00000063},
	{0x00004043, 0x00000063},
	{0x00005043, 0x00000063},
	{0x00006043, 0x00000063},
	{0x00007043, 0x00000063},
	{0x00008043, 0x00000063},
	{0x00009043, 0x00000063},
	{0x00020018, 0x00000001},
	{0x00020075, 0x00000004},
	{0x00020050, 0x00000000},
	{0x00020008, 0x00000320},
	{0x00120008, 0x00000064},
	{0x00220008, 0x00000019},
	{0x00020088, 0x00000009},
	{0x000200b2, 0x000000dc},
	{0x00010043, 0x000005a1},
	{0x00010143, 0x000005a1},
	{0x00011043, 0x000005a1},
	{0x00011143, 0x000005a1},
	{0x001200b2, 0x000000dc},
	{0x00110043, 0x000005a1},
	{0x00110143, 0x000005a1},
	{0x00111043, 0x000005a1},
	{0x00111143, 0x000005a1},
	{0x002200b2, 0x000000dc},
	{0x00210043, 0x000005a1},
	{0x00210143, 0x000005a1},
	{0x00211043, 0x000005a1},
	{0x00211143, 0x000005a1},
	{0x000200fa, 0x00000001},
	{0x001200fa, 0x00000001},
	{0x002200fa, 0x00000001},
	{0x00020019, 0x00000001},
	{0x00120019, 0x00000001},
	{0x00220019, 0x00000001},
	{0x000200f0, 0x00000660},
	{0x000200f1, 0x00000000},
	{0x000200f2, 0x00004444},
	{0x000200f3, 0x00008888},
	{0x000200f4, 0x00005665},
	{0x000200f5, 0x00000000},
	{0x000200f6, 0x00000000},
	{0x000200f7, 0x0000f000},
	{0x0001004a, 0x00000500},
	{0x0001104a, 0x00000500},
	{0x00020025, 0x00000000},
	{0x0002002d, 0x00000000},
	{0x0012002d, 0x00000000},
	{0x0022002d, 0x00000000},
	{0x0002002c, 0x00000000},
	{0x000200c7, 0x00000021},
	{0x000200ca, 0x00000024},
	{0x000200cc, 0x000001f7},
	{0x001200c7, 0x00000021},
	{0x001200ca, 0x00000024},
	{0x001200cc, 0x000001f7},
	{0x002200c7, 0x00000021},
	{0x002200ca, 0x00000024},
	{0x002200cc, 0x000001f7},
	{0x00020060, 0x00000002},
	{0x000d0000, 0x00000001},
};

/* P0 message block paremeter for training firmware */
static struct dram_cfg_param ddr_fsp0_cfg[] = {
	{0x000d0000, 0x00000000},
	{0x00054000, 0x00000000},
	{0x00054001, 0x00000000},
	{0x00054002, 0x00000000},
	{0x00054003, 0x00000c80},
	{0x00054004, 0x00000002},
	{0x00054005, 0x00000000},
	{0x00054006, 0x00000011},
	{0x00054007, 0x00000000},
	{0x00054008, 0x0000131f},
	{0x00054009, 0x000000c8},
	{0x0005400a, 0x00000000},
	{0x0005400b, 0x00000002},
	{0x0005400c, 0x00000000},
	{0x0005400d, 0x00000000},
	{0x0005400e, 0x00000000},
	{0x0005400f, 0x00000100},
	{0x00054010, 0x00000000},
	{0x00054011, 0x00000000},
	{0x00054012, 0x00000310},
	{0x00054013, 0x00000000},
	{0x00054014, 0x00000000},
	{0x00054015, 0x00000000},
	{0x00054016, 0x00000000},
	{0x00054017, 0x00000000},
	{0x00054018, 0x00000000},
	{0x00054019, 0x00002dd4},
	{0x0005401a, 0x00000031},
	{0x0005401b, 0x00004d66},
	{0x0005401c, 0x00004a00},
	{0x0005401d, 0x00000000},
	{0x0005401e, 0x00000016},
	{0x0005401f, 0x00002dd4},
	{0x00054020, 0x00000031},
	{0x00054021, 0x00004d66},
	{0x00054022, 0x00004a00},
	{0x00054023, 0x00000000},
	{0x00054024, 0x0000002e},
	{0x00054025, 0x00000000},
	{0x00054026, 0x00000000},
	{0x00054027, 0x00000000},
	{0x00054028, 0x00000000},
	{0x00054029, 0x00000000},
	{0x0005402a, 0x00000000},
	{0x0005402b, 0x00000000},
	{0x0005402c, 0x00000000},
	{0x0005402d, 0x00000000},
	{0x0005402e, 0x00000000},
	{0x0005402f, 0x00000000},
	{0x00054030, 0x00000000},
	{0x00054031, 0x00000000},
	{0x00054032, 0x0000d400},
	{0x00054033, 0x0000312d},
	{0x00054034, 0x00006600},
	{0x00054035, 0x0000004d},
	{0x00054036, 0x0000004a},
	{0x00054037, 0x00001600},
	{0x00054038, 0x0000d400},
	{0x00054039, 0x0000312d},
	{0x0005403a, 0x00006600},
	{0x0005403b, 0x0000004d},
	{0x0005403c, 0x0000004a},
	{0x0005403d, 0x00002e00},
	{0x0005403e, 0x00000000},
	{0x0005403f, 0x00000000},
	{0x00054040, 0x00000000},
	{0x00054041, 0x00000000},
	{0x00054042, 0x00000000},
	{0x00054043, 0x00000000},
	{0x00054044, 0x00000000},
	{0x000d0000, 0x00000001},
};

/* P1 message block paremeter for training firmware */
static struct dram_cfg_param ddr_fsp1_cfg[] = {
	{0x000d0000, 0x00000000},
	{0x00054000, 0x00000000},
	{0x00054001, 0x00000000},
	{0x00054002, 0x00000101},
	{0x00054003, 0x00000190},
	{0x00054004, 0x00000002},
	{0x00054005, 0x00000000},
	{0x00054006, 0x00000011},
	{0x00054007, 0x00000000},
	{0x00054008, 0x0000121f},
	{0x00054009, 0x000000c8},
	{0x0005400a, 0x00000000},
	{0x0005400b, 0x00000002},
	{0x0005400c, 0x00000000},
	{0x0005400d, 0x00000000},
	{0x0005400e, 0x00000000},
	{0x0005400f, 0x00000100},
	{0x00054010, 0x00000000},
	{0x00054011, 0x00000000},
	{0x00054012, 0x00000310},
	{0x00054013, 0x00000000},
	{0x00054014, 0x00000000},
	{0x00054015, 0x00000000},
	{0x00054016, 0x00000000},
	{0x00054017, 0x00000000},
	{0x00054018, 0x00000000},
	{0x00054019, 0x00000084},
	{0x0005401a, 0x00000031},
	{0x0005401b, 0x00004d66},
	{0x0005401c, 0x00004a00},
	{0x0005401d, 0x00000000},
	{0x0005401e, 0x00000016},
	{0x0005401f, 0x00000084},
	{0x00054020, 0x00000031},
	{0x00054021, 0x00004d66},
	{0x00054022, 0x00004a00},
	{0x00054023, 0x00000000},
	{0x00054024, 0x0000002e},
	{0x00054025, 0x00000000},
	{0x00054026, 0x00000000},
	{0x00054027, 0x00000000},
	{0x00054028, 0x00000000},
	{0x00054029, 0x00000000},
	{0x0005402a, 0x00000000},
	{0x0005402b, 0x00000000},
	{0x0005402c, 0x00000000},
	{0x0005402d, 0x00000000},
	{0x0005402e, 0x00000000},
	{0x0005402f, 0x00000000},
	{0x00054030, 0x00000000},
	{0x00054031, 0x00000000},
	{0x00054032, 0x00008400},
	{0x00054033, 0x00003100},
	{0x00054034, 0x00006600},
	{0x00054035, 0x0000004d},
	{0x00054036, 0x0000004a},
	{0x00054037, 0x00001600},
	{0x00054038, 0x00008400},
	{0x00054039, 0x00003100},
	{0x0005403a, 0x00006600},
	{0x0005403b, 0x0000004d},
	{0x0005403c, 0x0000004a},
	{0x0005403d, 0x00002e00},
	{0x0005403e, 0x00000000},
	{0x0005403f, 0x00000000},
	{0x00054040, 0x00000000},
	{0x00054041, 0x00000000},
	{0x00054042, 0x00000000},
	{0x00054043, 0x00000000},
	{0x00054044, 0x00000000},
	{0x000d0000, 0x00000001},
};

/* P2 message block paremeter for training firmware */
static struct dram_cfg_param ddr_fsp2_cfg[] = {
	{0x000d0000, 0x00000000},
	{0x00054000, 0x00000000},
	{0x00054001, 0x00000000},
	{0x00054002, 0x00000102},
	{0x00054003, 0x00000064},
	{0x00054004, 0x00000002},
	{0x00054005, 0x00000000},
	{0x00054006, 0x00000011},
	{0x00054007, 0x00000000},
	{0x00054008, 0x0000121f},
	{0x00054009, 0x000000c8},
	{0x0005400a, 0x00000000},
	{0x0005400b, 0x00000002},
	{0x0005400c, 0x00000000},
	{0x0005400d, 0x00000000},
	{0x0005400e, 0x00000000},
	{0x0005400f, 0x00000100},
	{0x00054010, 0x00000000},
	{0x00054011, 0x00000000},
	{0x00054012, 0x00000310},
	{0x00054013, 0x00000000},
	{0x00054014, 0x00000000},
	{0x00054015, 0x00000000},
	{0x00054016, 0x00000000},
	{0x00054017, 0x00000000},
	{0x00054018, 0x00000000},
	{0x00054019, 0x00000084},
	{0x0005401a, 0x00000031},
	{0x0005401b, 0x00004d66},
	{0x0005401c, 0x00004a00},
	{0x0005401d, 0x00000000},
	{0x0005401e, 0x00000016},
	{0x0005401f, 0x00000084},
	{0x00054020, 0x00000031},
	{0x00054021, 0x00004d66},
	{0x00054022, 0x00004a00},
	{0x00054023, 0x00000000},
	{0x00054024, 0x0000002e},
	{0x00054025, 0x00000000},
	{0x00054026, 0x00000000},
	{0x00054027, 0x00000000},
	{0x00054028, 0x00000000},
	{0x00054029, 0x00000000},
	{0x0005402a, 0x00000000},
	{0x0005402b, 0x00000000},
	{0x0005402c, 0x00000000},
	{0x0005402d, 0x00000000},
	{0x0005402e, 0x00000000},
	{0x0005402f, 0x00000000},
	{0x00054030, 0x00000000},
	{0x00054031, 0x00000000},
	{0x00054032, 0x00008400},
	{0x00054033, 0x00003100},
	{0x00054034, 0x00006600},
	{0x00054035, 0x0000004d},
	{0x00054036, 0x0000004a},
	{0x00054037, 0x00001600},
	{0x00054038, 0x00008400},
	{0x00054039, 0x00003100},
	{0x0005403a, 0x00006600},
	{0x0005403b, 0x0000004d},
	{0x0005403c, 0x0000004a},
	{0x0005403d, 0x00002e00},
	{0x0005403e, 0x00000000},
	{0x0005403f, 0x00000000},
	{0x00054040, 0x00000000},
	{0x00054041, 0x00000000},
	{0x00054042, 0x00000000},
	{0x00054043, 0x00000000},
	{0x00054044, 0x00000000},
	{0x000d0000, 0x00000001},
};

/* P0 2D message block paremeter for training firmware */
static struct dram_cfg_param ddr_fsp0_2d_cfg[] = {
	{0x000d0000, 0x00000000},
	{0x00054000, 0x00000000},
	{0x00054001, 0x00000000},
	{0x00054002, 0x00000000},
	{0x00054003, 0x00000c80},
	{0x00054004, 0x00000002},
	{0x00054005, 0x00000000},
	{0x00054006, 0x00000011},
	{0x00054007, 0x00000000},
	{0x00054008, 0x00000061},
	{0x00054009, 0x000000c8},
	{0x0005400a, 0x00000000},
	{0x0005400b, 0x00000002},
	{0x0005400c, 0x00000000},
	{0x0005400d, 0x00000000},
	{0x0005400e, 0x00000000},
	{0x0005400f, 0x00000100},
	{0x00054010, 0x00001f7f},
	{0x00054011, 0x00000000},
	{0x00054012, 0x00000310},
	{0x00054013, 0x00000000},
	{0x00054014, 0x00000000},
	{0x00054015, 0x00000000},
	{0x00054016, 0x00000000},
	{0x00054017, 0x00000000},
	{0x00054018, 0x00000000},
	{0x00054019, 0x00002dd4},
	{0x0005401a, 0x00000031},
	{0x0005401b, 0x00004d66},
	{0x0005401c, 0x00004a00},
	{0x0005401d, 0x00000000},
	{0x0005401e, 0x00000016},
	{0x0005401f, 0x00002dd4},
	{0x00054020, 0x00000031},
	{0x00054021, 0x00004d66},
	{0x00054022, 0x00004a00},
	{0x00054023, 0x00000000},
	{0x00054024, 0x0000002e},
	{0x00054025, 0x00000000},
	{0x00054026, 0x00000000},
	{0x00054027, 0x00000000},
	{0x00054028, 0x00000000},
	{0x00054029, 0x00000000},
	{0x0005402a, 0x00000000},
	{0x0005402b, 0x00000000},
	{0x0005402c, 0x00000000},
	{0x0005402d, 0x00000000},
	{0x0005402e, 0x00000000},
	{0x0005402f, 0x00000000},
	{0x00054030, 0x00000000},
	{0x00054031, 0x00000000},
	{0x00054032, 0x0000d400},
	{0x00054033, 0x0000312d},
	{0x00054034, 0x00006600},
	{0x00054035, 0x0000004d},
	{0x00054036, 0x0000004a},
	{0x00054037, 0x00001600},
	{0x00054038, 0x0000d400},
	{0x00054039, 0x0000312d},
	{0x0005403a, 0x00006600},
	{0x0005403b, 0x0000004d},
	{0x0005403c, 0x0000004a},
	{0x0005403d, 0x00002e00},
	{0x0005403e, 0x00000000},
	{0x0005403f, 0x00000000},
	{0x00054040, 0x00000000},
	{0x00054041, 0x00000000},
	{0x00054042, 0x00000000},
	{0x00054043, 0x00000000},
	{0x00054044, 0x00000000},
	{0x000d0000, 0x00000001},
};

/* DRAM PHY init engine image */
static struct dram_cfg_param ddr_phy_pie[] = {
	{0xd0000, 0x0},
	{0x90000, 0x10},
	{0x90001, 0x400},
	{0x90002, 0x10e},
	{0x90003, 0x0},
	{0x90004, 0x0},
	{0x90005, 0x8},
	{0x90029, 0xb},
	{0x9002a, 0x480},
	{0x9002b, 0x109},
	{0x9002c, 0x8},
	{0x9002d, 0x448},
	{0x9002e, 0x139},
	{0x9002f, 0x8},
	{0x90030, 0x478},
	{0x90031, 0x109},
	{0x90032, 0x0},
	{0x90033, 0xe8},
	{0x90034, 0x109},
	{0x90035, 0x2},
	{0x90036, 0x10},
	{0x90037, 0x139},
	{0x90038, 0xb},
	{0x90039, 0x7c0},
	{0x9003a, 0x139},
	{0x9003b, 0x44},
	{0x9003c, 0x633},
	{0x9003d, 0x159},
	{0x9003e, 0x14f},
	{0x9003f, 0x630},
	{0x90040, 0x159},
	{0x90041, 0x47},
	{0x90042, 0x633},
	{0x90043, 0x149},
	{0x90044, 0x4f},
	{0x90045, 0x633},
	{0x90046, 0x179},
	{0x90047, 0x8},
	{0x90048, 0xe0},
	{0x90049, 0x109},
	{0x9004a, 0x0},
	{0x9004b, 0x7c8},
	{0x9004c, 0x109},
	{0x9004d, 0x0},
	{0x9004e, 0x1},
	{0x9004f, 0x8},
	{0x90050, 0x0},
	{0x90051, 0x45a},
	{0x90052, 0x9},
	{0x90053, 0x0},
	{0x90054, 0x448},
	{0x90055, 0x109},
	{0x90056, 0x40},
	{0x90057, 0x633},
	{0x90058, 0x179},
	{0x90059, 0x1},
	{0x9005a, 0x618},
	{0x9005b, 0x109},
	{0x9005c, 0x40c0},
	{0x9005d, 0x633},
	{0x9005e, 0x149},
	{0x9005f, 0x8},
	{0x90060, 0x4},
	{0x90061, 0x48},
	{0x90062, 0x4040},
	{0x90063, 0x633},
	{0x90064, 0x149},
	{0x90065, 0x0},
	{0x90066, 0x4},
	{0x90067, 0x48},
	{0x90068, 0x40},
	{0x90069, 0x633},
	{0x9006a, 0x149},
	{0x9006b, 0x10},
	{0x9006c, 0x4},
	{0x9006d, 0x18},
	{0x9006e, 0x0},
	{0x9006f, 0x4},
	{0x90070, 0x78},
	{0x90071, 0x549},
	{0x90072, 0x633},
	{0x90073, 0x159},
	{0x90074, 0xd49},
	{0x90075, 0x633},
	{0x90076, 0x159},
	{0x90077, 0x94a},
	{0x90078, 0x633},
	{0x90079, 0x159},
	{0x9007a, 0x441},
	{0x9007b, 0x633},
	{0x9007c, 0x149},
	{0x9007d, 0x42},
	{0x9007e, 0x633},
	{0x9007f, 0x149},
	{0x90080, 0x1},
	{0x90081, 0x633},
	{0x90082, 0x149},
	{0x90083, 0x0},
	{0x90084, 0xe0},
	{0x90085, 0x109},
	{0x90086, 0xa},
	{0x90087, 0x10},
	{0x90088, 0x109},
	{0x90089, 0x9},
	{0x9008a, 0x3c0},
	{0x9008b, 0x149},
	{0x9008c, 0x9},
	{0x9008d, 0x3c0},
	{0x9008e, 0x159},
	{0x9008f, 0x18},
	{0x90090, 0x10},
	{0x90091, 0x109},
	{0x90092, 0x0},
	{0x90093, 0x3c0},
	{0x90094, 0x109},
	{0x90095, 0x18},
	{0x90096, 0x4},
	{0x90097, 0x48},
	{0x90098, 0x18},
	{0x90099, 0x4},
	{0x9009a, 0x58},
	{0x9009b, 0xb},
	{0x9009c, 0x10},
	{0x9009d, 0x109},
	{0x9009e, 0x1},
	{0x9009f, 0x10},
	{0x900a0, 0x109},
	{0x900a1, 0x5},
	{0x900a2, 0x7c0},
	{0x900a3, 0x109},
	{0x40000, 0x811},
	{0x40020, 0x880},
	{0x40040, 0x0},
	{0x40060, 0x0},
	{0x40001, 0x4008},
	{0x40021, 0x83},
	{0x40041, 0x4f},
	{0x40061, 0x0},
	{0x40002, 0x4040},
	{0x40022, 0x83},
	{0x40042, 0x51},
	{0x40062, 0x0},
	{0x40003, 0x811},
	{0x40023, 0x880},
	{0x40043, 0x0},
	{0x40063, 0x0},
	{0x40004, 0x720},
	{0x40024, 0xf},
	{0x40044, 0x1740},
	{0x40064, 0x0},
	{0x40005, 0x16},
	{0x40025, 0x83},
	{0x40045, 0x4b},
	{0x40065, 0x0},
	{0x40006, 0x716},
	{0x40026, 0xf},
	{0x40046, 0x2001},
	{0x40066, 0x0},
	{0x40007, 0x716},
	{0x40027, 0xf},
	{0x40047, 0x2800},
	{0x40067, 0x0},
	{0x40008, 0x716},
	{0x40028, 0xf},
	{0x40048, 0xf00},
	{0x40068, 0x0},
	{0x40009, 0x720},
	{0x40029, 0xf},
	{0x40049, 0x1400},
	{0x40069, 0x0},
	{0x4000a, 0xe08},
	{0x4002a, 0xc15},
	{0x4004a, 0x0},
	{0x4006a, 0x0},
	{0x4000b, 0x625},
	{0x4002b, 0x15},
	{0x4004b, 0x0},
	{0x4006b, 0x0},
	{0x4000c, 0x4028},
	{0x4002c, 0x80},
	{0x4004c, 0x0},
	{0x4006c, 0x0},
	{0x4000d, 0xe08},
	{0x4002d, 0xc1a},
	{0x4004d, 0x0},
	{0x4006d, 0x0},
	{0x4000e, 0x625},
	{0x4002e, 0x1a},
	{0x4004e, 0x0},
	{0x4006e, 0x0},
	{0x4000f, 0x4040},
	{0x4002f, 0x80},
	{0x4004f, 0x0},
	{0x4006f, 0x0},
	{0x40010, 0x2604},
	{0x40030, 0x15},
	{0x40050, 0x0},
	{0x40070, 0x0},
	{0x40011, 0x708},
	{0x40031, 0x5},
	{0x40051, 0x0},
	{0x40071, 0x2002},
	{0x40012, 0x8},
	{0x40032, 0x80},
	{0x40052, 0x0},
	{0x40072, 0x0},
	{0x40013, 0x2604},
	{0x40033, 0x1a},
	{0x40053, 0x0},
	{0x40073, 0x0},
	{0x40014, 0x708},
	{0x40034, 0xa},
	{0x40054, 0x0},
	{0x40074, 0x2002},
	{0x40015, 0x4040},
	{0x40035, 0x80},
	{0x40055, 0x0},
	{0x40075, 0x0},
	{0x40016, 0x60a},
	{0x40036, 0x15},
	{0x40056, 0x1200},
	{0x40076, 0x0},
	{0x40017, 0x61a},
	{0x40037, 0x15},
	{0x40057, 0x1300},
	{0x40077, 0x0},
	{0x40018, 0x60a},
	{0x40038, 0x1a},
	{0x40058, 0x1200},
	{0x40078, 0x0},
	{0x40019, 0x642},
	{0x40039, 0x1a},
	{0x40059, 0x1300},
	{0x40079, 0x0},
	{0x4001a, 0x4808},
	{0x4003a, 0x880},
	{0x4005a, 0x0},
	{0x4007a, 0x0},
	{0x900a4, 0x0},
	{0x900a5, 0x790},
	{0x900a6, 0x11a},
	{0x900a7, 0x8},
	{0x900a8, 0x7aa},
	{0x900a9, 0x2a},
	{0x900aa, 0x10},
	{0x900ab, 0x7b2},
	{0x900ac, 0x2a},
	{0x900ad, 0x0},
	{0x900ae, 0x7c8},
	{0x900af, 0x109},
	{0x900b0, 0x10},
	{0x900b1, 0x10},
	{0x900b2, 0x109},
	{0x900b3, 0x10},
	{0x900b4, 0x2a8},
	{0x900b5, 0x129},
	{0x900b6, 0x8},
	{0x900b7, 0x370},
	{0x900b8, 0x129},
	{0x900b9, 0xa},
	{0x900ba, 0x3c8},
	{0x900bb, 0x1a9},
	{0x900bc, 0xc},
	{0x900bd, 0x408},
	{0x900be, 0x199},
	{0x900bf, 0x14},
	{0x900c0, 0x790},
	{0x900c1, 0x11a},
	{0x900c2, 0x8},
	{0x900c3, 0x4},
	{0x900c4, 0x18},
	{0x900c5, 0xe},
	{0x900c6, 0x408},
	{0x900c7, 0x199},
	{0x900c8, 0x8},
	{0x900c9, 0x8568},
	{0x900ca, 0x108},
	{0x900cb, 0x18},
	{0x900cc, 0x790},
	{0x900cd, 0x16a},
	{0x900ce, 0x8},
	{0x900cf, 0x1d8},
	{0x900d0, 0x169},
	{0x900d1, 0x10},
	{0x900d2, 0x8558},
	{0x900d3, 0x168},
	{0x900d4, 0x70},
	{0x900d5, 0x788},
	{0x900d6, 0x16a},
	{0x900d7, 0x1ff8},
	{0x900d8, 0x85a8},
	{0x900d9, 0x1e8},
	{0x900da, 0x50},
	{0x900db, 0x798},
	{0x900dc, 0x16a},
	{0x900dd, 0x60},
	{0x900de, 0x7a0},
	{0x900df, 0x16a},
	{0x900e0, 0x8},
	{0x900e1, 0x8310},
	{0x900e2, 0x168},
	{0x900e3, 0x8},
	{0x900e4, 0xa310},
	{0x900e5, 0x168},
	{0x900e6, 0xa},
	{0x900e7, 0x408},
	{0x900e8, 0x169},
	{0x900e9, 0x6e},
	{0x900ea, 0x0},
	{0x900eb, 0x68},
	{0x900ec, 0x0},
	{0x900ed, 0x408},
	{0x900ee, 0x169},
	{0x900ef, 0x0},
	{0x900f0, 0x8310},
	{0x900f1, 0x168},
	{0x900f2, 0x0},
	{0x900f3, 0xa310},
	{0x900f4, 0x168},
	{0x900f5, 0x1ff8},
	{0x900f6, 0x85a8},
	{0x900f7, 0x1e8},
	{0x900f8, 0x68},
	{0x900f9, 0x798},
	{0x900fa, 0x16a},
	{0x900fb, 0x78},
	{0x900fc, 0x7a0},
	{0x900fd, 0x16a},
	{0x900fe, 0x68},
	{0x900ff, 0x790},
	{0x90100, 0x16a},
	{0x90101, 0x8},
	{0x90102, 0x8b10},
	{0x90103, 0x168},
	{0x90104, 0x8},
	{0x90105, 0xab10},
	{0x90106, 0x168},
	{0x90107, 0xa},
	{0x90108, 0x408},
	{0x90109, 0x169},
	{0x9010a, 0x58},
	{0x9010b, 0x0},
	{0x9010c, 0x68},
	{0x9010d, 0x0},
	{0x9010e, 0x408},
	{0x9010f, 0x169},
	{0x90110, 0x0},
	{0x90111, 0x8b10},
	{0x90112, 0x168},
	{0x90113, 0x1},
	{0x90114, 0xab10},
	{0x90115, 0x168},
	{0x90116, 0x0},
	{0x90117, 0x1d8},
	{0x90118, 0x169},
	{0x90119, 0x80},
	{0x9011a, 0x790},
	{0x9011b, 0x16a},
	{0x9011c, 0x18},
	{0x9011d, 0x7aa},
	{0x9011e, 0x6a},
	{0x9011f, 0xa},
	{0x90120, 0x0},
	{0x90121, 0x1e9},
	{0x90122, 0x8},
	{0x90123, 0x8080},
	{0x90124, 0x108},
	{0x90125, 0xf},
	{0x90126, 0x408},
	{0x90127, 0x169},
	{0x90128, 0xc},
	{0x90129, 0x0},
	{0x9012a, 0x68},
	{0x9012b, 0x9},
	{0x9012c, 0x0},
	{0x9012d, 0x1a9},
	{0x9012e, 0x0},
	{0x9012f, 0x408},
	{0x90130, 0x169},
	{0x90131, 0x0},
	{0x90132, 0x8080},
	{0x90133, 0x108},
	{0x90134, 0x8},
	{0x90135, 0x7aa},
	{0x90136, 0x6a},
	{0x90137, 0x0},
	{0x90138, 0x8568},
	{0x90139, 0x108},
	{0x9013a, 0xb7},
	{0x9013b, 0x790},
	{0x9013c, 0x16a},
	{0x9013d, 0x1f},
	{0x9013e, 0x0},
	{0x9013f, 0x68},
	{0x90140, 0x8},
	{0x90141, 0x8558},
	{0x90142, 0x168},
	{0x90143, 0xf},
	{0x90144, 0x408},
	{0x90145, 0x169},
	{0x90146, 0xd},
	{0x90147, 0x0},
	{0x90148, 0x68},
	{0x90149, 0x0},
	{0x9014a, 0x408},
	{0x9014b, 0x169},
	{0x9014c, 0x0},
	{0x9014d, 0x8558},
	{0x9014e, 0x168},
	{0x9014f, 0x8},
	{0x90150, 0x3c8},
	{0x90151, 0x1a9},
	{0x90152, 0x3},
	{0x90153, 0x370},
	{0x90154, 0x129},
	{0x90155, 0x20},
	{0x90156, 0x2aa},
	{0x90157, 0x9},
	{0x90158, 0x0},
	{0x90159, 0x400},
	{0x9015a, 0x10e},
	{0x9015b, 0x8},
	{0x9015c, 0xe8},
	{0x9015d, 0x109},
	{0x9015e, 0x0},
	{0x9015f, 0x8140},
	{0x90160, 0x10c},
	{0x90161, 0x10},
	{0x90162, 0x8138},
	{0x90163, 0x10c},
	{0x90164, 0x8},
	{0x90165, 0x7c8},
	{0x90166, 0x101},
	{0x90167, 0x8},
	{0x90168, 0x448},
	{0x90169, 0x109},
	{0x9016a, 0xf},
	{0x9016b, 0x7c0},
	{0x9016c, 0x109},
	{0x9016d, 0x0},
	{0x9016e, 0xe8},
	{0x9016f, 0x109},
	{0x90170, 0x47},
	{0x90171, 0x630},
	{0x90172, 0x109},
	{0x90173, 0x8},
	{0x90174, 0x618},
	{0x90175, 0x109},
	{0x90176, 0x8},
	{0x90177, 0xe0},
	{0x90178, 0x109},
	{0x90179, 0x0},
	{0x9017a, 0x7c8},
	{0x9017b, 0x109},
	{0x9017c, 0x8},
	{0x9017d, 0x8140},
	{0x9017e, 0x10c},
	{0x9017f, 0x0},
	{0x90180, 0x1},
	{0x90181, 0x8},
	{0x90182, 0x8},
	{0x90183, 0x4},
	{0x90184, 0x8},
	{0x90185, 0x8},
	{0x90186, 0x7c8},
	{0x90187, 0x101},
	{0x90006, 0x0},
	{0x90007, 0x0},
	{0x90008, 0x8},
	{0x90009, 0x0},
	{0x9000a, 0x0},
	{0x9000b, 0x0},
	{0xd00e7, 0x400},
	{0x90017, 0x0},
	{0x9001f, 0x29},
	{0x90026, 0x6a},
	{0x400d0, 0x0},
	{0x400d1, 0x101},
	{0x400d2, 0x105},
	{0x400d3, 0x107},
	{0x400d4, 0x10f},
	{0x400d5, 0x202},
	{0x400d6, 0x20a},
	{0x400d7, 0x20b},
	{0x2003a, 0x2},
	{0x2000b, 0x64},
	{0x2000c, 0xc8},
	{0x2000d, 0x7d0},
	{0x2000e, 0x2c},
	{0x12000b, 0xc},
	{0x12000c, 0x19},
	{0x12000d, 0xfa},
	{0x12000e, 0x10},
	{0x22000b, 0x3},
	{0x22000c, 0x6},
	{0x22000d, 0x3e},
	{0x22000e, 0x10},
	{0x9000c, 0x0},
	{0x9000d, 0x173},
	{0x9000e, 0x60},
	{0x9000f, 0x6110},
	{0x90010, 0x2152},
	{0x90011, 0xdfbd},
	{0x90012, 0x2060},
	{0x90013, 0x6152},
	{0x20010, 0x5a},
	{0x20011, 0x3},
	{0x40080, 0xe0},
	{0x40081, 0x12},
	{0x40082, 0xe0},
	{0x40083, 0x12},
	{0x40084, 0xe0},
	{0x40085, 0x12},
	{0x140080, 0xe0},
	{0x140081, 0x12},
	{0x140082, 0xe0},
	{0x140083, 0x12},
	{0x140084, 0xe0},
	{0x140085, 0x12},
	{0x240080, 0xe0},
	{0x240081, 0x12},
	{0x240082, 0xe0},
	{0x240083, 0x12},
	{0x240084, 0xe0},
	{0x240085, 0x12},
	{0x400fd, 0xf},
	{0x10011, 0x1},
	{0x10012, 0x1},
	{0x10013, 0x180},
	{0x10018, 0x1},
	{0x10002, 0x6209},
	{0x100b2, 0x1},
	{0x101b4, 0x1},
	{0x102b4, 0x1},
	{0x103b4, 0x1},
	{0x104b4, 0x1},
	{0x105b4, 0x1},
	{0x106b4, 0x1},
	{0x107b4, 0x1},
	{0x108b4, 0x1},
	{0x11011, 0x1},
	{0x11012, 0x1},
	{0x11013, 0x180},
	{0x11018, 0x1},
	{0x11002, 0x6209},
	{0x110b2, 0x1},
	{0x111b4, 0x1},
	{0x112b4, 0x1},
	{0x113b4, 0x1},
	{0x114b4, 0x1},
	{0x115b4, 0x1},
	{0x116b4, 0x1},
	{0x117b4, 0x1},
	{0x118b4, 0x1},
	{0x20089, 0x1},
	{0x20088, 0x19},
	{0xc0080, 0x2},
	{0xd0000, 0x1},
};

static struct dram_fsp_msg ddr_dram_fsp_msg[] = {
	{
		/* P0 3200mts 1D */
		.drate = 3200,
		.fw_type = FW_1D_IMAGE,
		.fsp_cfg = ddr_fsp0_cfg,
		.fsp_cfg_num = ARRAY_SIZE(ddr_fsp0_cfg),
	},
	{
		/* P1 400mts 1D */
		.drate = 400,
		.fw_type = FW_1D_IMAGE,
		.fsp_cfg = ddr_fsp1_cfg,
		.fsp_cfg_num = ARRAY_SIZE(ddr_fsp1_cfg),
	},
	{
		/* P2 100mts 1D */
		.drate = 100,
		.fw_type = FW_1D_IMAGE,
		.fsp_cfg = ddr_fsp2_cfg,
		.fsp_cfg_num = ARRAY_SIZE(ddr_fsp2_cfg),
	},
	{
		/* P0 3200mts 2D */
		.drate = 3200,
		.fw_type = FW_2D_IMAGE,
		.fsp_cfg = ddr_fsp0_2d_cfg,
		.fsp_cfg_num = ARRAY_SIZE(ddr_fsp0_2d_cfg),
	},
};

/* ddr timing config params */
struct dram_timing_info imx8mn_evk_lpddr4_timing = {
	.ddrc_cfg = ddr_ddrc_cfg,
	.ddrc_cfg_num = ARRAY_SIZE(ddr_ddrc_cfg),
	.ddrphy_cfg = ddr_ddrphy_cfg,
	.ddrphy_cfg_num = ARRAY_SIZE(ddr_ddrphy_cfg),
	.fsp_msg = ddr_dram_fsp_msg,
	.fsp_msg_num = ARRAY_SIZE(ddr_dram_fsp_msg),
	.ddrphy_pie = ddr_phy_pie,
	.ddrphy_pie_num = ARRAY_SIZE(ddr_phy_pie),
	.fsp_table = { 3200, 400, 100, },
};
