/* SPDX-License-Identifier: GPL-2.0-or-later */
/* SPDX-FileCopyrightText: 2013 Greg Ungerer <gerg@uclinux.org> */
/* SPDX-FileCopyrightText: 2016 Alexander Kurz <akurz@blala.de> */

/* based on linux imx50-pinfunc.h */

#ifndef __MACH_IOMUX_MX50_H__
#define __MACH_IOMUX_MX50_H__

#include <mach/imx/iomux-v3.h>

/* These 2 defines are for pins that may not have a mux register, but could
 * have a pad setting register, and vice-versa. */
#define __NA_   0x00

#define MX50_UART_PAD_CTRL (PAD_CTL_PKE | PAD_CTL_PUE | PAD_CTL_DSE_HIGH)
#define MX50_SDHC_PAD_CTRL (PAD_CTL_PKE | PAD_CTL_PUE | \
			    PAD_CTL_PUS_47K_UP | PAD_CTL_DSE_HIGH)
#define MX50_I2C_PAD_CTRL (PAD_CTL_PKE | PAD_CTL_PUE | PAD_CTL_ODE | \
			   PAD_CTL_PUS_47K_UP | PAD_CTL_DSE_HIGH)
#define MX50_SPI_PAD_CTRL (PAD_CTL_PKE | PAD_CTL_DSE_HIGH)

#define MX50_PAD_KEY_COL0__KPP_COL_0			IOMUX_PAD(0x2CC, 0x020, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL0__GPIO4_0			IOMUX_PAD(0x2CC, 0x020, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL0__EIM_NANDF_CLE		IOMUX_PAD(0x2CC, 0x020, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL0__CTI_TRIGIN7			IOMUX_PAD(0x2CC, 0x020, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL0__USBPHY1_TXREADY		IOMUX_PAD(0x2CC, 0x020, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW0__KPP_ROW_0			IOMUX_PAD(0x2D0, 0x024, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW0__GPIO4_1			IOMUX_PAD(0x2D0, 0x024, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW0__EIM_NANDF_ALE		IOMUX_PAD(0x2D0, 0x024, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW0__CTI_TRIGIN_ACK7		IOMUX_PAD(0x2D0, 0x024, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW0__USBPHY1_RXVALID		IOMUX_PAD(0x2D0, 0x024, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL1__KPP_COL_1			IOMUX_PAD(0x2D4, 0x028, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL1__GPIO4_2			IOMUX_PAD(0x2D4, 0x028, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL1__EIM_NANDF_CEN_0		IOMUX_PAD(0x2D4, 0x028, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL1__CTI_TRIGOUT_ACK6		IOMUX_PAD(0x2D4, 0x028, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL1__USBPHY1_RXACTIVE		IOMUX_PAD(0x2D4, 0x028, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW1__KPP_ROW_1			IOMUX_PAD(0x2D8, 0x02C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW1__GPIO4_3			IOMUX_PAD(0x2D8, 0x02C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW1__EIM_NANDF_CEN_1		IOMUX_PAD(0x2D8, 0x02C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW1__CTI_TRIGOUT_ACK7		IOMUX_PAD(0x2D8, 0x02C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW1__USBPHY1_RXERROR		IOMUX_PAD(0x2D8, 0x02C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL2__KPP_COL_1			IOMUX_PAD(0x2DC, 0x030, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL2__GPIO4_4			IOMUX_PAD(0x2DC, 0x030, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL2__EIM_NANDF_CEN_2		IOMUX_PAD(0x2DC, 0x030, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL2__CTI_TRIGOUT6			IOMUX_PAD(0x2DC, 0x030, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL2__USBPHY1_SIECLOCK		IOMUX_PAD(0x2DC, 0x030, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW2__KPP_ROW_2			IOMUX_PAD(0x2E0, 0x034, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW2__GPIO4_5			IOMUX_PAD(0x2E0, 0x034, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW2__EIM_NANDF_CEN_3		IOMUX_PAD(0x2E0, 0x034, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW2__CTI_TRIGOUT7			IOMUX_PAD(0x2E0, 0x034, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW2__USBPHY1_LINESTATE_0		IOMUX_PAD(0x2E0, 0x034, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL3__KPP_COL_2			IOMUX_PAD(0x2E4, 0x038, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL3__GPIO4_6			IOMUX_PAD(0x2E4, 0x038, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL3__EIM_NANDF_READY0		IOMUX_PAD(0x2E4, 0x038, 2, 0x7B4, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL3__SDMA_EXT_EVENT_0		IOMUX_PAD(0x2E4, 0x038, 6, 0x7B8, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_COL3__USBPHY1_LINESTATE_1		IOMUX_PAD(0x2E4, 0x038, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW3__KPP_ROW_3			IOMUX_PAD(0x2E8, 0x03C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW3__GPIO4_7			IOMUX_PAD(0x2E8, 0x03C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW3__EIM_NANDF_DQS		IOMUX_PAD(0x2E8, 0x03C, 2, 0x7B0, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW3__SDMA_EXT_EVENT_1		IOMUX_PAD(0x2E8, 0x03C, 6, 0x7BC, 0, NO_PAD_CTRL)
#define MX50_PAD_KEY_ROW3__USBPHY1_VBUSVALID		IOMUX_PAD(0x2E8, 0x03C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C1_SCL__I2C1_SCL			IOMUX_PAD(0x2EC, 0x040, 0 | IOMUX_CONFIG_SION, __NA_, 0, MX50_I2C_PAD_CTRL)
#define MX50_PAD_I2C1_SCL__GPIO6_18			IOMUX_PAD(0x2EC, 0x040, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C1_SCL__UART2_TXD_MUX		IOMUX_PAD(0x2EC, 0x040, 2, 0x7CC, 0, MX50_UART_PAD_CTRL)
#define MX50_PAD_I2C1_SDA__I2C1_SDA			IOMUX_PAD(0x2F0, 0x044, 0 | IOMUX_CONFIG_SION, __NA_, 0, MX50_I2C_PAD_CTRL)
#define MX50_PAD_I2C1_SDA__GPIO6_19			IOMUX_PAD(0x2F0, 0x044, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C1_SDA__UART2_RXD_MUX		IOMUX_PAD(0x2F0, 0x044, 2, 0x7CC, 1, MX50_UART_PAD_CTRL)
#define MX50_PAD_I2C2_SCL__I2C2_SCL			IOMUX_PAD(0x2F4, 0x048, 0 | IOMUX_CONFIG_SION, __NA_, 0, MX50_I2C_PAD_CTRL)
#define MX50_PAD_I2C2_SCL__GPIO6_20			IOMUX_PAD(0x2F4, 0x048, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C2_SCL__UART2_CTS			IOMUX_PAD(0x2F4, 0x048, 2, __NA_, 0, MX50_UART_PAD_CTRL)
#define MX50_PAD_I2C2_SDA__I2C2_SDA			IOMUX_PAD(0x2F8, 0x04C, 0 | IOMUX_CONFIG_SION, __NA_, 0, MX50_I2C_PAD_CTRL)
#define MX50_PAD_I2C2_SDA__GPIO6_21			IOMUX_PAD(0x2F8, 0x04C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C2_SDA__UART2_RTS			IOMUX_PAD(0x2F8, 0x04C, 2, 0x7C8, 1, MX50_UART_PAD_CTRL)
#define MX50_PAD_I2C3_SCL__I2C3_SCL			IOMUX_PAD(0x2FC, 0x050, 0 | IOMUX_CONFIG_SION, __NA_, 0, MX50_I2C_PAD_CTRL)
#define MX50_PAD_I2C3_SCL__GPIO6_22			IOMUX_PAD(0x2FC, 0x050, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C3_SCL__FEC_MDC			IOMUX_PAD(0x2FC, 0x050, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C3_SCL__GPC_PMIC_RDY			IOMUX_PAD(0x2FC, 0x050, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C3_SCL__GPT_CAPIN1			IOMUX_PAD(0x2FC, 0x050, 5, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C3_SCL__OBSERVE_MUX_OBSRV_INT_OUT0	IOMUX_PAD(0x2FC, 0x050, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C3_SCL__USBOH1_USBOTG_OC		IOMUX_PAD(0x2FC, 0x050, 7, 0x7E8, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C3_SDA__I2C3_SDA			IOMUX_PAD(0x300, 0x054, 0 | IOMUX_CONFIG_SION, __NA_, 0, MX50_I2C_PAD_CTRL)
#define MX50_PAD_I2C3_SDA__GPIO6_23			IOMUX_PAD(0x300, 0x054, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C3_SDA__FEC_MDIO			IOMUX_PAD(0x300, 0x054, 2, 0x774, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C3_SDA__TZIC_PWRFAIL_INT		IOMUX_PAD(0x300, 0x054, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C3_SDA__SRTC_ALARM_DEB		IOMUX_PAD(0x300, 0x054, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C3_SDA__GPT_CAPIN2			IOMUX_PAD(0x300, 0x054, 5, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C3_SDA__OBSERVE_MUX_OBSRV_INT_OUT1	IOMUX_PAD(0x300, 0x054, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_I2C3_SDA__USBOH1_USBOTG_PWR		IOMUX_PAD(0x300, 0x054, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_PWM1__PWM1_PWMO			IOMUX_PAD(0x304, 0x058, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_PWM1__GPIO6_24				IOMUX_PAD(0x304, 0x058, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_PWM1__USBOH1_USBOTG_OC			IOMUX_PAD(0x304, 0x058, 2, 0x7E8, 1, NO_PAD_CTRL)
#define MX50_PAD_PWM1__GPT_CMPOUT1			IOMUX_PAD(0x304, 0x058, 5, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_PWM1__OBSERVE_MUX_OBSRV_INT_OUT2	IOMUX_PAD(0x304, 0x058, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_PWM1__SJC_FAIL				IOMUX_PAD(0x304, 0x058, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_PWM2__PWM2_PWMO			IOMUX_PAD(0x308, 0x05C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_PWM2__GPIO6_25				IOMUX_PAD(0x308, 0x05C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_PWM2__USBOH1_USBOTG_PWR		IOMUX_PAD(0x308, 0x05C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_PWM2__GPT_CMPOUT2			IOMUX_PAD(0x308, 0x05C, 5, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_PWM2__OBSERVE_MUX_OBSRV_INT_OUT3	IOMUX_PAD(0x308, 0x05C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_PWM2__SRC_ANY_PU_RST			IOMUX_PAD(0x308, 0x05C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_OWIRE__OWIRE_LINE			IOMUX_PAD(0x30C, 0x060, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_OWIRE__GPIO6_26			IOMUX_PAD(0x30C, 0x060, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_OWIRE__USBOH1_USBH1_OC			IOMUX_PAD(0x30C, 0x060, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_OWIRE__CCM_SSI_EXT1_CLK		IOMUX_PAD(0x30C, 0x060, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_OWIRE__EPDC_PWRIRQ			IOMUX_PAD(0x30C, 0x060, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_OWIRE__GPT_CMPOUT3			IOMUX_PAD(0x30C, 0x060, 5, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_OWIRE__OBSERVE_MUX_OBSRV_INT_OUT4	IOMUX_PAD(0x30C, 0x060, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_OWIRE__SJC_JTAG_ACT			IOMUX_PAD(0x30C, 0x060, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPITO__EPIT1_EPITO			IOMUX_PAD(0x310, 0x064, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPITO__GPIO6_27			IOMUX_PAD(0x310, 0x064, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPITO__USBOH1_USBH1_PWR		IOMUX_PAD(0x310, 0x064, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPITO__CCM_SSI_EXT2_CLK		IOMUX_PAD(0x310, 0x064, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPITO__DPLLIP1_TOG_EN			IOMUX_PAD(0x310, 0x064, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPITO__GPT_CLK_IN			IOMUX_PAD(0x310, 0x064, 5, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPITO__PMU_IRQ_B			IOMUX_PAD(0x310, 0x064, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPITO__SJC_DE_B			IOMUX_PAD(0x310, 0x064, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_WDOG__WDOG1_WDOG_B			IOMUX_PAD(0x314, 0x068, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_WDOG__GPIO6_28				IOMUX_PAD(0x314, 0x068, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_WDOG__WDOG1_WDOG_RST_B_DEB		IOMUX_PAD(0x314, 0x068, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_WDOG__CCM_XTAL32K			IOMUX_PAD(0x314, 0x068, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_WDOG__SJC_DONE				IOMUX_PAD(0x314, 0x068, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_TXFS__AUDMUX_AUD3_TXFS		IOMUX_PAD(0x318, 0x06C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_TXFS__GPIO6_0			IOMUX_PAD(0x318, 0x06C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_TXFS__SRC_BT_FUSE_RSV_1		IOMUX_PAD(0x318, 0x06C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_TXFS__USBPHY1_DATAOUT_8		IOMUX_PAD(0x318, 0x06C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_TXC__AUDMUX_AUD3_TXC		IOMUX_PAD(0x31C, 0x070, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_TXC__GPIO6_1			IOMUX_PAD(0x31C, 0x070, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_TXC__SRC_BT_FUSE_RSV_0		IOMUX_PAD(0x31C, 0x070, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_TXC__USBPHY1_DATAOUT_9		IOMUX_PAD(0x31C, 0x070, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_TXD__AUDMUX_AUD3_TXD		IOMUX_PAD(0x320, 0x074, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_TXD__GPIO6_2			IOMUX_PAD(0x320, 0x074, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_TXD__CSPI_RDY			IOMUX_PAD(0x320, 0x074, 4, 0x6E8, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_TXD__USBPHY1_DATAOUT_10		IOMUX_PAD(0x320, 0x074, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXD__AUDMUX_AUD3_RXD		IOMUX_PAD(0x324, 0x078, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXD__GPIO6_3			IOMUX_PAD(0x324, 0x078, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXD__CSPI_SS3			IOMUX_PAD(0x324, 0x078, 4, 0x6F4, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXD__USBPHY1_DATAOUT_11		IOMUX_PAD(0x324, 0x078, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXFS__AUDMUX_AUD3_RXFS		IOMUX_PAD(0x328, 0x07C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXFS__GPIO6_4			IOMUX_PAD(0x328, 0x07C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXFS__UART5_TXD_MUX		IOMUX_PAD(0x328, 0x07C, 2, 0x7E4, 0, MX50_UART_PAD_CTRL)
#define MX50_PAD_SSI_RXFS__EIM_WEIM_D_6			IOMUX_PAD(0x328, 0x07C, 3, 0x804, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXFS__CSPI_SS2			IOMUX_PAD(0x328, 0x07C, 4, 0x6F0, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXFS__FEC_COL			IOMUX_PAD(0x328, 0x07C, 5, 0x770, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXFS__FEC_MDC			IOMUX_PAD(0x328, 0x07C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXFS__USBPHY1_DATAOUT_12		IOMUX_PAD(0x328, 0x07C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXC__AUDMUX_AUD3_RXC		IOMUX_PAD(0x32C, 0x080, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXC__GPIO6_5			IOMUX_PAD(0x32C, 0x080, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXC__UART5_RXD_MUX			IOMUX_PAD(0x32C, 0x080, 2, 0x7E4, 1, MX50_UART_PAD_CTRL)
#define MX50_PAD_SSI_RXC__EIM_WEIM_D_7			IOMUX_PAD(0x32C, 0x080, 3, 0x808, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXC__CSPI_SS1			IOMUX_PAD(0x32C, 0x080, 4, 0x6EC, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXC__FEC_RX_CLK			IOMUX_PAD(0x32C, 0x080, 5, 0x780, 0, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXC__FEC_MDIO			IOMUX_PAD(0x32C, 0x080, 6, 0x774, 1, NO_PAD_CTRL)
#define MX50_PAD_SSI_RXC__USBPHY1_DATAOUT_13		IOMUX_PAD(0x32C, 0x080, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART1_TXD__UART1_TXD_MUX		IOMUX_PAD(0x330, 0x084, 0, 0x7C4, 0, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART1_TXD__GPIO6_6			IOMUX_PAD(0x330, 0x084, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART1_TXD__USBPHY1_DATAOUT_14		IOMUX_PAD(0x330, 0x084, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART1_RXD__UART1_RXD_MUX		IOMUX_PAD(0x334, 0x088, 0, 0x7C4, 1, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART1_RXD__GPIO6_7			IOMUX_PAD(0x334, 0x088, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART1_RXD__USBPHY1_DATAOUT_15		IOMUX_PAD(0x334, 0x088, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART1_CTS__UART1_CTS			IOMUX_PAD(0x338, 0x08C, 0, __NA_, 0, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART1_CTS__GPIO6_8			IOMUX_PAD(0x338, 0x08C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART1_CTS__UART5_TXD_MUX		IOMUX_PAD(0x338, 0x08C, 2, 0x7E4, 2, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART1_CTS__ESDHC4_DAT4			IOMUX_PAD(0x338, 0x08C, 4, 0x760, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART1_CTS__ESDHC4_CMD			IOMUX_PAD(0x338, 0x08C, 5, 0x74C, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART1_CTS__USBPHY2_DATAOUT_8		IOMUX_PAD(0x338, 0x08C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART1_RTS__UART1_RTS			IOMUX_PAD(0x33C, 0x090, 0, 0x7C0, 3, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART1_RTS__GPIO6_9			IOMUX_PAD(0x33C, 0x090, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART1_RTS__UART5_RXD_MUX		IOMUX_PAD(0x33C, 0x090, 2, 0x7E4, 3, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART1_RTS__ESDHC4_DAT5			IOMUX_PAD(0x33C, 0x090, 4, 0x764, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART1_RTS__ESDHC4_CLK			IOMUX_PAD(0x33C, 0x090, 5, 0x748, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART1_RTS__USBPHY2_DATAOUT_9		IOMUX_PAD(0x33C, 0x090, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART2_TXD__UART2_TXD_MUX		IOMUX_PAD(0x340, 0x094, 0, 0x7CC, 2, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART2_TXD__GPIO6_10			IOMUX_PAD(0x340, 0x094, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART2_TXD__ESDHC4_DAT6			IOMUX_PAD(0x340, 0x094, 4, 0x768, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART2_TXD__ESDHC4_DAT4			IOMUX_PAD(0x340, 0x094, 5, 0x760, 1, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART2_TXD__USBPHY2_DATAOUT_10		IOMUX_PAD(0x340, 0x094, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART2_RXD__UART2_RXD_MUX		IOMUX_PAD(0x344, 0x098, 0, 0x7CC, 3, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART2_RXD__GPIO6_11			IOMUX_PAD(0x344, 0x098, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART2_RXD__ESDHC4_DAT7			IOMUX_PAD(0x344, 0x098, 4, 0x76C, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART2_RXD__ESDHC4_DAT5			IOMUX_PAD(0x344, 0x098, 5, 0x764, 1, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART2_RXD__USBPHY2_DATAOUT_11		IOMUX_PAD(0x344, 0x098, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART2_CTS__UART2_CTS			IOMUX_PAD(0x348, 0x09C, 0, __NA_, 0, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART2_CTS__GPIO6_12			IOMUX_PAD(0x348, 0x09C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART2_CTS__ESDHC4_CMD			IOMUX_PAD(0x348, 0x09C, 4, 0x74C, 1, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART2_CTS__ESDHC4_DAT6			IOMUX_PAD(0x348, 0x09C, 5, 0x768, 1, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART2_CTS__USBPHY2_DATAOUT_12		IOMUX_PAD(0x348, 0x09C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART2_RTS__UART2_RTS			IOMUX_PAD(0x34C, 0x0A0, 0, 0x7C8, 2, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART2_RTS__GPIO6_13			IOMUX_PAD(0x34C, 0x0A0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART2_RTS__ESDHC4_CLK			IOMUX_PAD(0x34C, 0x0A0, 4, 0x748, 1, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART2_RTS__ESDHC4_DAT7			IOMUX_PAD(0x34C, 0x0A0, 5, 0x76C, 1, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART2_RTS__USBPHY2_DATAOUT_13		IOMUX_PAD(0x34C, 0x0A0, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART3_TXD__UART3_TXD_MUX		IOMUX_PAD(0x350, 0x0A4, 0, 0x7D4, 0, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART3_TXD__GPIO6_14			IOMUX_PAD(0x350, 0x0A4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART3_TXD__ESDHC1_DAT4			IOMUX_PAD(0x350, 0x0A4, 3, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART3_TXD__ESDHC4_DAT0			IOMUX_PAD(0x350, 0x0A4, 4, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART3_TXD__ESDHC2_WP			IOMUX_PAD(0x350, 0x0A4, 5, 0x744, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART3_TXD__EIM_WEIM_D_12		IOMUX_PAD(0x350, 0x0A4, 6, 0x81C, 0, NO_PAD_CTRL)
#define MX50_PAD_UART3_TXD__USBPHY2_DATAOUT_14		IOMUX_PAD(0x350, 0x0A4, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART3_RXD__UART3_RXD_MUX		IOMUX_PAD(0x354, 0x0A8, 0, 0x7D4, 1, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART3_RXD__GPIO6_15			IOMUX_PAD(0x354, 0x0A8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART3_RXD__ESDHC1_DAT5			IOMUX_PAD(0x354, 0x0A8, 3, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART3_RXD__ESDHC4_DAT1			IOMUX_PAD(0x354, 0x0A8, 4, 0x754, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART3_RXD__ESDHC2_CD			IOMUX_PAD(0x354, 0x0A8, 5, 0x740, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART3_RXD__EIM_WEIM_D_13		IOMUX_PAD(0x354, 0x0A8, 6, 0x820, 0, NO_PAD_CTRL)
#define MX50_PAD_UART3_RXD__USBPHY2_DATAOUT_15		IOMUX_PAD(0x354, 0x0A8, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART4_TXD__UART4_TXD_MUX		IOMUX_PAD(0x358, 0x0AC, 0, 0x7DC, 0, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART4_TXD__GPIO6_16			IOMUX_PAD(0x358, 0x0AC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART4_TXD__UART3_CTS			IOMUX_PAD(0x358, 0x0AC, 2, 0x7D0, 0, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART4_TXD__ESDHC1_DAT6			IOMUX_PAD(0x358, 0x0AC, 3, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART4_TXD__ESDHC4_DAT2			IOMUX_PAD(0x358, 0x0AC, 4, 0x758, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART4_TXD__ESDHC2_LCTL			IOMUX_PAD(0x358, 0x0AC, 5, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART4_TXD__EIM_WEIM_D_14		IOMUX_PAD(0x358, 0x0AC, 6, 0x824, 0, NO_PAD_CTRL)
#define MX50_PAD_UART4_RXD__UART4_RXD_MUX		IOMUX_PAD(0x35C, 0x0B0, 0, 0x7DC, 1, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART4_RXD__GPIO6_17			IOMUX_PAD(0x35C, 0x0B0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_UART4_RXD__UART3_RTS			IOMUX_PAD(0x35C, 0x0B0, 2, 0x7D0, 1, MX50_UART_PAD_CTRL)
#define MX50_PAD_UART4_RXD__ESDHC1_DAT7			IOMUX_PAD(0x35C, 0x0B0, 3, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART4_RXD__ESDHC4_DAT3			IOMUX_PAD(0x35C, 0x0B0, 4, 0x75C, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART4_RXD__ESDHC1_LCTL			IOMUX_PAD(0x35C, 0x0B0, 5, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_UART4_RXD__EIM_WEIM_D_15		IOMUX_PAD(0x35C, 0x0B0, 6, 0x828, 0, NO_PAD_CTRL)
#define MX50_PAD_CSPI_SCLK__CSPI_SCLK			IOMUX_PAD(0x360, 0x0B4, 0, __NA_, 0, MX50_SPI_PAD_CTRL)
#define MX50_PAD_CSPI_SCLK__GPIO4_8			IOMUX_PAD(0x360, 0x0B4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_CSPI_MOSI__CSPI_MOSI			IOMUX_PAD(0x364, 0x0B8, 0, __NA_, 0, MX50_SPI_PAD_CTRL)
#define MX50_PAD_CSPI_MOSI__GPIO4_9			IOMUX_PAD(0x364, 0x0B8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_CSPI_MISO__CSPI_MISO			IOMUX_PAD(0x368, 0x0BC, 0, __NA_, 0, MX50_SPI_PAD_CTRL)
#define MX50_PAD_CSPI_MISO__GPIO4_10			IOMUX_PAD(0x368, 0x0BC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_CSPI_SS0__CSPI_SS0			IOMUX_PAD(0x36C, 0x0C0, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_CSPI_SS0__GPIO4_11			IOMUX_PAD(0x36C, 0x0C0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_SCLK__ECSPI1_SCLK		IOMUX_PAD(0x370, 0x0C4, 0, __NA_, 0, MX50_SPI_PAD_CTRL)
#define MX50_PAD_ECSPI1_SCLK__GPIO4_12			IOMUX_PAD(0x370, 0x0C4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_SCLK__CSPI_RDY			IOMUX_PAD(0x370, 0x0C4, 2, 0x6E8, 1, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_SCLK__ECSPI2_RDY		IOMUX_PAD(0x370, 0x0C4, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_SCLK__UART3_RTS			IOMUX_PAD(0x370, 0x0C4, 4, 0x7D0, 2, MX50_UART_PAD_CTRL)
#define MX50_PAD_ECSPI1_SCLK__EPDC_SDCE_6		IOMUX_PAD(0x370, 0x0C4, 5, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_SCLK__EIM_WEIM_D_8		IOMUX_PAD(0x370, 0x0C4, 7, 0x80C, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_MOSI__ECSPI1_MOSI		IOMUX_PAD(0x374, 0x0C8, 0, __NA_, 0, MX50_SPI_PAD_CTRL)
#define MX50_PAD_ECSPI1_MOSI__GPIO4_13			IOMUX_PAD(0x374, 0x0C8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_MOSI__CSPI_SS1			IOMUX_PAD(0x374, 0x0C8, 2, 0x6EC, 1, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_MOSI__ECSPI2_SS1		IOMUX_PAD(0x374, 0x0C8, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_MOSI__UART3_CTS			IOMUX_PAD(0x374, 0x0C8, 4, __NA_, 0, MX50_UART_PAD_CTRL)
#define MX50_PAD_ECSPI1_MOSI__EPDC_SDCE_7		IOMUX_PAD(0x374, 0x0C8, 5, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_MOSI__EIM_WEIM_D_9		IOMUX_PAD(0x374, 0x0C8, 7, 0x810, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_MISO__ECSPI1_MISO		IOMUX_PAD(0x378, 0x0CC, 0, __NA_, 0, MX50_SPI_PAD_CTRL)
#define MX50_PAD_ECSPI1_MISO__GPIO4_14			IOMUX_PAD(0x378, 0x0CC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_MISO__CSPI_SS2			IOMUX_PAD(0x378, 0x0CC, 2, 0x6F0, 1, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_MISO__ECSPI2_SS2		IOMUX_PAD(0x378, 0x0CC, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_MISO__UART4_RTS			IOMUX_PAD(0x378, 0x0CC, 4, 0x7D8, 0, MX50_UART_PAD_CTRL)
#define MX50_PAD_ECSPI1_MISO__EPDC_SDCE_8		IOMUX_PAD(0x378, 0x0CC, 5, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_MISO__EIM_WEIM_D_10		IOMUX_PAD(0x378, 0x0CC, 7, 0x814, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_SS0__ECSPI1_SS0			IOMUX_PAD(0x37C, 0x0D0, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_SS0__GPIO4_15			IOMUX_PAD(0x37C, 0x0D0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_SS0__CSPI_SS3			IOMUX_PAD(0x37C, 0x0D0, 2, 0x6F4, 1, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_SS0__ECSPI2_SS3			IOMUX_PAD(0x37C, 0x0D0, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_SS0__UART4_CTS			IOMUX_PAD(0x37C, 0x0D0, 4, __NA_, 0, MX50_UART_PAD_CTRL)
#define MX50_PAD_ECSPI1_SS0__EPDC_SDCE_9		IOMUX_PAD(0x37C, 0x0D0, 5, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI1_SS0__EIM_WEIM_D_11		IOMUX_PAD(0x37C, 0x0D0, 7, 0x818, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_SCLK__ECSPI2_SCLK		IOMUX_PAD(0x380, 0x0D4, 0, __NA_, 0, MX50_SPI_PAD_CTRL)
#define MX50_PAD_ECSPI2_SCLK__GPIO4_16			IOMUX_PAD(0x380, 0x0D4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_SCLK__ELCDIF_WR_RWN		IOMUX_PAD(0x380, 0x0D4, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_SCLK__ECSPI1_RDY		IOMUX_PAD(0x380, 0x0D4, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_SCLK__UART5_RTS			IOMUX_PAD(0x380, 0x0D4, 4, 0x7E0, 0, MX50_UART_PAD_CTRL)
#define MX50_PAD_ECSPI2_SCLK__ELCDIF_DOTCLK		IOMUX_PAD(0x380, 0x0D4, 5, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_SCLK__EIM_NANDF_CEN_4		IOMUX_PAD(0x380, 0x0D4, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_SCLK__EIM_WEIM_D_8		IOMUX_PAD(0x380, 0x0D4, 7, 0x80C, 1, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_MOSI__ECSPI2_MOSI		IOMUX_PAD(0x384, 0x0D8, 0, __NA_, 0, MX50_SPI_PAD_CTRL)
#define MX50_PAD_ECSPI2_MOSI__GPIO4_17			IOMUX_PAD(0x384, 0x0D8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_MOSI__ELCDIF_RE_E		IOMUX_PAD(0x384, 0x0D8, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_MOSI__ECSPI1_SS1		IOMUX_PAD(0x384, 0x0D8, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_MOSI__UART5_CTS			IOMUX_PAD(0x384, 0x0D8, 4, 0x7E0, 1, MX50_UART_PAD_CTRL)
#define MX50_PAD_ECSPI2_MOSI__ELCDIF_ENABLE		IOMUX_PAD(0x384, 0x0D8, 5, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_MOSI__EIM_NANDF_CEN_5		IOMUX_PAD(0x384, 0x0D8, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_MOSI__EIM_WEIM_D_9		IOMUX_PAD(0x384, 0x0D8, 7, 0x810, 1, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_MISO__ECSPI2_MISO		IOMUX_PAD(0x388, 0x0DC, 0, __NA_, 0, MX50_SPI_PAD_CTRL)
#define MX50_PAD_ECSPI2_MISO__GPIO4_18			IOMUX_PAD(0x388, 0x0DC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_MISO__ELCDIF_RS			IOMUX_PAD(0x388, 0x0DC, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_MISO__ECSPI1_SS2		IOMUX_PAD(0x388, 0x0DC, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_MISO__UART5_TXD_MUX		IOMUX_PAD(0x388, 0x0DC, 4, 0x7E4, 4, MX50_UART_PAD_CTRL)
#define MX50_PAD_ECSPI2_MISO__ELCDIF_VSYNC		IOMUX_PAD(0x388, 0x0DC, 5, 0x73C, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_MISO__EIM_NANDF_CEN_6		IOMUX_PAD(0x388, 0x0DC, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_MISO__EIM_WEIM_D_10		IOMUX_PAD(0x388, 0x0DC, 7, 0x814, 1, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_SS0__ECSPI2_SS0			IOMUX_PAD(0x38C, 0x0E0, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_SS0__GPIO4_19			IOMUX_PAD(0x38C, 0x0E0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_SS0__ELCDIF_CS			IOMUX_PAD(0x38C, 0x0E0, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_SS0__ECSPI2_SS3			IOMUX_PAD(0x38C, 0x0E0, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_SS0__UART5_RXD_MUX		IOMUX_PAD(0x38C, 0x0E0, 4, 0x7E4, 5, MX50_UART_PAD_CTRL)
#define MX50_PAD_ECSPI2_SS0__ELCDIF_HSYNC		IOMUX_PAD(0x38C, 0x0E0, 5, 0x6F8, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_SS0__EIM_NANDF_CEN_7		IOMUX_PAD(0x38C, 0x0E0, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_ECSPI2_SS0__EIM_WEIM_D_11		IOMUX_PAD(0x38C, 0x0E0, 7, 0x818, 1, NO_PAD_CTRL)
#define MX50_PAD_SD1_CLK__ESDHC1_CLK			IOMUX_PAD(0x390, 0x0E4, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD1_CLK__GPIO5_0			IOMUX_PAD(0x390, 0x0E4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD1_CLK__CCM_CLKO			IOMUX_PAD(0x390, 0x0E4, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD1_CMD__ESDHC1_CMD			IOMUX_PAD(0x394, 0x0E8, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD1_CMD__GPIO5_1			IOMUX_PAD(0x394, 0x0E8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD1_CMD__CCM_CLKO2			IOMUX_PAD(0x394, 0x0E8, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD1_D0__ESDHC1_DAT0			IOMUX_PAD(0x398, 0x0EC, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD1_D0__GPIO5_2			IOMUX_PAD(0x398, 0x0EC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD1_D0__CCM_PLL1_BYP			IOMUX_PAD(0x398, 0x0EC, 7, 0x6DC, 0, NO_PAD_CTRL)
#define MX50_PAD_SD1_D1__ESDHC1_DAT1			IOMUX_PAD(0x39C, 0x0F0, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD1_D1__GPIO5_3			IOMUX_PAD(0x39C, 0x0F0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD1_D1__CCM_PLL2_BYP			IOMUX_PAD(0x39C, 0x0F0, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD1_D2__ESDHC1_DAT2			IOMUX_PAD(0x3A0, 0x0F4, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD1_D2__GPIO5_4			IOMUX_PAD(0x3A0, 0x0F4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD1_D2__CCM_PLL3_BYP			IOMUX_PAD(0x3A0, 0x0F4, 7, 0x6E4, 0, NO_PAD_CTRL)
#define MX50_PAD_SD1_D3__ESDHC1_DAT3			IOMUX_PAD(0x3A4, 0x0F8, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD1_D3__GPIO5_5			IOMUX_PAD(0x3A4, 0x0F8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_CLK__ESDHC2_CLK			IOMUX_PAD(0x3A8, 0x0FC, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD2_CLK__GPIO5_6			IOMUX_PAD(0x3A8, 0x0FC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_CLK__MSHC_SCLK			IOMUX_PAD(0x3A8, 0x0FC, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_CMD__ESDHC2_CMD			IOMUX_PAD(0x3AC, 0x100, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD2_CMD__GPIO5_7			IOMUX_PAD(0x3AC, 0x100, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_CMD__MSHC_BS			IOMUX_PAD(0x3AC, 0x100, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D0__ESDHC2_DAT0			IOMUX_PAD(0x3B0, 0x104, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD2_D0__GPIO5_8			IOMUX_PAD(0x3B0, 0x104, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D0__MSHC_DATA_0			IOMUX_PAD(0x3B0, 0x104, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D0__KPP_COL_4			IOMUX_PAD(0x3B0, 0x104, 3, 0x790, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D1__ESDHC2_DAT1			IOMUX_PAD(0x3B4, 0x108, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD2_D1__GPIO5_9			IOMUX_PAD(0x3B4, 0x108, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D1__MSHC_DATA_1			IOMUX_PAD(0x3B4, 0x108, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D1__KPP_ROW_4			IOMUX_PAD(0x3B4, 0x108, 3, 0x7A0, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D2__ESDHC2_DAT2			IOMUX_PAD(0x3B8, 0x10C, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD2_D2__GPIO5_10			IOMUX_PAD(0x3B8, 0x10C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D2__MSHC_DATA_2			IOMUX_PAD(0x3B8, 0x10C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D2__KPP_COL_5			IOMUX_PAD(0x3B8, 0x10C, 3, 0x794, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D3__ESDHC2_DAT3			IOMUX_PAD(0x3BC, 0x110, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD2_D3__GPIO5_11			IOMUX_PAD(0x3BC, 0x110, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D3__MSHC_DATA_3			IOMUX_PAD(0x3BC, 0x110, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D3__KPP_ROW_5			IOMUX_PAD(0x3BC, 0x110, 3, 0x7A4, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D4__ESDHC2_DAT4			IOMUX_PAD(0x3C0, 0x114, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD2_D4__GPIO5_12			IOMUX_PAD(0x3C0, 0x114, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D4__AUDMUX_AUD4_RXFS		IOMUX_PAD(0x3C0, 0x114, 2, 0x6D0, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D4__KPP_COL_6			IOMUX_PAD(0x3C0, 0x114, 3, 0x798, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D4__EIM_WEIM_D_0			IOMUX_PAD(0x3C0, 0x114, 4, 0x7EC, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D4__CCM_CCM_OUT_0			IOMUX_PAD(0x3C0, 0x114, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D5__ESDHC2_DAT5			IOMUX_PAD(0x3C4, 0x118, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD2_D5__GPIO5_13			IOMUX_PAD(0x3C4, 0x118, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D5__AUDMUX_AUD4_RXC		IOMUX_PAD(0x3C4, 0x118, 2, 0x6CC, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D5__KPP_ROW_6			IOMUX_PAD(0x3C4, 0x118, 3, 0x7A8, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D5__EIM_WEIM_D_1			IOMUX_PAD(0x3C4, 0x118, 4, 0x7F0, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D5__CCM_CCM_OUT_1			IOMUX_PAD(0x3C4, 0x118, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D6__ESDHC2_DAT6			IOMUX_PAD(0x3C8, 0x11C, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD2_D6__GPIO5_14			IOMUX_PAD(0x3C8, 0x11C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D6__AUDMUX_AUD4_RXD		IOMUX_PAD(0x3C8, 0x11C, 2, 0x6C4, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D6__KPP_COL_7			IOMUX_PAD(0x3C8, 0x11C, 3, 0x79C, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D6__EIM_WEIM_D_2			IOMUX_PAD(0x3C8, 0x11C, 4, 0x7F4, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D6__CCM_CCM_OUT_2			IOMUX_PAD(0x3C8, 0x11C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D7__ESDHC2_DAT7			IOMUX_PAD(0x3CC, 0x120, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD2_D7__GPIO5_15			IOMUX_PAD(0x3CC, 0x120, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D7__AUDMUX_AUD4_TXFS		IOMUX_PAD(0x3CC, 0x120, 2, 0x6D8, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D7__KPP_ROW_7			IOMUX_PAD(0x3CC, 0x120, 3, 0x7AC, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D7__EIM_WEIM_D_3			IOMUX_PAD(0x3CC, 0x120, 4, 0x7F8, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_D7__CCM_STOP			IOMUX_PAD(0x3CC, 0x120, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_WP__ESDHC2_WP			IOMUX_PAD(0x3D0, 0x124, 0, 0x744, 1, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD2_WP__GPIO5_16			IOMUX_PAD(0x3D0, 0x124, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_WP__AUDMUX_AUD4_TXD		IOMUX_PAD(0x3D0, 0x124, 2, 0x6C8, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_WP__EIM_WEIM_D_4			IOMUX_PAD(0x3D0, 0x124, 4, 0x7FC, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_WP__CCM_WAIT			IOMUX_PAD(0x3D0, 0x124, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_CD__ESDHC2_CD			IOMUX_PAD(0x3D4, 0x128, 0, 0x740, 1, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD2_CD__GPIO5_17			IOMUX_PAD(0x3D4, 0x128, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_CD__AUDMUX_AUD4_TXC		IOMUX_PAD(0x3D4, 0x128, 2, 0x6D4, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_CD__EIM_WEIM_D_5			IOMUX_PAD(0x3D4, 0x128, 4, 0x800, 0, NO_PAD_CTRL)
#define MX50_PAD_SD2_CD__CCM_REF_EN_B			IOMUX_PAD(0x3D4, 0x128, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D0__ELCDIF_DAT_0			IOMUX_PAD(0x40C, 0x12C, 0, 0x6FC, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D0__GPIO2_0			IOMUX_PAD(0x40C, 0x12C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D0__FEC_TX_CLK			IOMUX_PAD(0x40C, 0x12C, 2, 0x78C, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D0__EIM_WEIM_A_16			IOMUX_PAD(0x40C, 0x12C, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D0__SDMA_DEBUG_PC_0		IOMUX_PAD(0x40C, 0x12C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D0__USBPHY1_VSTATUS_0		IOMUX_PAD(0x40C, 0x12C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D1__ELCDIF_DAT_1			IOMUX_PAD(0x410, 0x130, 0, 0x700, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D1__GPIO2_1			IOMUX_PAD(0x410, 0x130, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D1__FEC_RX_ERR			IOMUX_PAD(0x410, 0x130, 2, 0x788, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D1__EIM_WEIM_A_17			IOMUX_PAD(0x410, 0x130, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D1__SDMA_DEBUG_PC_1		IOMUX_PAD(0x410, 0x130, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D1__USBPHY1_VSTATUS_1		IOMUX_PAD(0x410, 0x130, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D2__ELCDIF_DAT_2			IOMUX_PAD(0x414, 0x134, 0, 0x704, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D2__GPIO2_2			IOMUX_PAD(0x414, 0x134, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D2__FEC_RX_DV			IOMUX_PAD(0x414, 0x134, 2, 0x784, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D2__EIM_WEIM_A_18			IOMUX_PAD(0x414, 0x134, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D2__SDMA_DEBUG_PC_2		IOMUX_PAD(0x414, 0x134, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D2__USBPHY1_VSTATUS_2		IOMUX_PAD(0x414, 0x134, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D3__ELCDIF_DAT_3			IOMUX_PAD(0x418, 0x138, 0, 0x708, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D3__GPIO2_3			IOMUX_PAD(0x418, 0x138, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D3__FEC_RDATA_1			IOMUX_PAD(0x418, 0x138, 2, 0x77C, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D3__EIM_WEIM_A_19			IOMUX_PAD(0x418, 0x138, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D3__FEC_COL			IOMUX_PAD(0x418, 0x138, 4, 0x770, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D3__SDMA_DEBUG_PC_3		IOMUX_PAD(0x418, 0x138, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D3__USBPHY1_VSTATUS_3		IOMUX_PAD(0x418, 0x138, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D4__ELCDIF_DAT_4			IOMUX_PAD(0x41C, 0x13C, 0, 0x70C, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D4__GPIO2_4			IOMUX_PAD(0x41C, 0x13C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D4__FEC_RDATA_0			IOMUX_PAD(0x41C, 0x13C, 2, 0x778, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D4__EIM_WEIM_A_20			IOMUX_PAD(0x41C, 0x13C, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D4__SDMA_DEBUG_PC_4		IOMUX_PAD(0x41C, 0x13C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D4__USBPHY1_VSTATUS_4		IOMUX_PAD(0x41C, 0x13C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D5__ELCDIF_DAT_5			IOMUX_PAD(0x420, 0x140, 0, 0x710, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D5__GPIO2_5			IOMUX_PAD(0x420, 0x140, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D5__FEC_TX_EN			IOMUX_PAD(0x420, 0x140, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D5__EIM_WEIM_A_21			IOMUX_PAD(0x420, 0x140, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D5__SDMA_DEBUG_PC_5		IOMUX_PAD(0x420, 0x140, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D5__USBPHY1_VSTATUS_5		IOMUX_PAD(0x420, 0x140, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D6__ELCDIF_DAT_6			IOMUX_PAD(0x424, 0x144, 0, 0x714, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D6__GPIO2_6			IOMUX_PAD(0x424, 0x144, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D6__FEC_TDATA_1			IOMUX_PAD(0x424, 0x144, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D6__EIM_WEIM_A_22			IOMUX_PAD(0x424, 0x144, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D6__FEC_RX_CLK			IOMUX_PAD(0x424, 0x144, 4, 0x780, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D6__SDMA_DEBUG_PC_6		IOMUX_PAD(0x424, 0x144, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D6__USBPHY1_VSTATUS_6		IOMUX_PAD(0x424, 0x144, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D7__ELCDIF_DAT_7			IOMUX_PAD(0x428, 0x148, 0, 0x718, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D7__GPIO2_7			IOMUX_PAD(0x428, 0x148, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D7__FEC_TDATA_0			IOMUX_PAD(0x428, 0x148, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D7__EIM_WEIM_A_23			IOMUX_PAD(0x428, 0x148, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D7__SDMA_DEBUG_PC_7		IOMUX_PAD(0x428, 0x148, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D7__USBPHY1_VSTATUS_7		IOMUX_PAD(0x428, 0x148, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_WR__ELCDIF_WR_RWN			IOMUX_PAD(0x42C, 0x14C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_WR__GPIO2_16			IOMUX_PAD(0x42C, 0x14C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_WR__ELCDIF_DOTCLK			IOMUX_PAD(0x42C, 0x14C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_WR__EIM_WEIM_A_24			IOMUX_PAD(0x42C, 0x14C, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_WR__SDMA_DEBUG_PC_8		IOMUX_PAD(0x42C, 0x14C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_WR__USBPHY1_AVALID		IOMUX_PAD(0x42C, 0x14C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RD__ELCDIF_RD_E			IOMUX_PAD(0x430, 0x150, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RD__GPIO2_19			IOMUX_PAD(0x430, 0x150, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RD__ELCDIF_ENABLE			IOMUX_PAD(0x430, 0x150, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RD__EIM_WEIM_A_25			IOMUX_PAD(0x430, 0x150, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RD__SDMA_DEBUG_PC_9		IOMUX_PAD(0x430, 0x150, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RD__USBPHY1_BVALID		IOMUX_PAD(0x430, 0x150, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RS__ELCDIF_RS			IOMUX_PAD(0x434, 0x154, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RS__GPIO2_17			IOMUX_PAD(0x434, 0x154, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RS__ELCDIF_VSYNC			IOMUX_PAD(0x434, 0x154, 2, 0x73C, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_RS__EIM_WEIM_A_26			IOMUX_PAD(0x434, 0x154, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RS__SDMA_DEBUG_PC_10		IOMUX_PAD(0x434, 0x154, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RS__USBPHY1_ENDSESSION		IOMUX_PAD(0x434, 0x154, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_CS__ELCDIF_CS			IOMUX_PAD(0x438, 0x158, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_CS__GPIO2_21			IOMUX_PAD(0x438, 0x158, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_CS__ELCDIF_HSYNC			IOMUX_PAD(0x438, 0x158, 2, 0x6F8, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_CS__EIM_WEIM_A_27			IOMUX_PAD(0x438, 0x158, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_CS__EIM_WEIM_CS_3			IOMUX_PAD(0x438, 0x158, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_CS__SDMA_DEBUG_PC_11		IOMUX_PAD(0x438, 0x158, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_CS__USBPHY1_IDDIG			IOMUX_PAD(0x438, 0x158, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_BUSY__ELCDIF_BUSY			IOMUX_PAD(0x43C, 0x15C, 0, 0x6F8, 2, NO_PAD_CTRL)
#define MX50_PAD_DISP_BUSY__GPIO2_18			IOMUX_PAD(0x43C, 0x15C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_BUSY__EIM_WEIM_CS_3		IOMUX_PAD(0x43C, 0x15C, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_BUSY__SDMA_DEBUG_PC_12		IOMUX_PAD(0x43C, 0x15C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_BUSY__USBPHY2_HOSTDISCONNECT	IOMUX_PAD(0x43C, 0x15C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RESET__ELCDIF_RESET		IOMUX_PAD(0x440, 0x160, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RESET__GPIO2_20			IOMUX_PAD(0x440, 0x160, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RESET__EIM_WEIM_CS_3		IOMUX_PAD(0x440, 0x160, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RESET__SDMA_DEBUG_PC_13		IOMUX_PAD(0x440, 0x160, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_RESET__USBPHY2_BISTOK		IOMUX_PAD(0x440, 0x160, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_CMD__ESDHC3_CMD			IOMUX_PAD(0x444, 0x164, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD3_CMD__GPIO5_18			IOMUX_PAD(0x444, 0x164, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_CMD__EIM_NANDF_WRN			IOMUX_PAD(0x444, 0x164, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_CMD__SSP_CMD			IOMUX_PAD(0x444, 0x164, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_CLK__ESDHC3_CLK			IOMUX_PAD(0x448, 0x168, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD3_CLK__GPIO5_19			IOMUX_PAD(0x448, 0x168, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_CLK__EIM_NANDF_RDN			IOMUX_PAD(0x448, 0x168, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_CLK__SSP_CLK			IOMUX_PAD(0x448, 0x168, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D0__ESDHC3_DAT0			IOMUX_PAD(0x44C, 0x16C, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD3_D0__GPIO5_20			IOMUX_PAD(0x44C, 0x16C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D0__EIM_NANDF_D_4			IOMUX_PAD(0x44C, 0x16C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D0__SSP_D0				IOMUX_PAD(0x44C, 0x16C, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D0__CCM_PLL1_BYP			IOMUX_PAD(0x44C, 0x16C, 7, 0x6DC, 1, NO_PAD_CTRL)
#define MX50_PAD_SD3_D1__ESDHC3_DAT1			IOMUX_PAD(0x450, 0x170, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD3_D1__GPIO5_21			IOMUX_PAD(0x450, 0x170, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D1__EIM_NANDF_D_5			IOMUX_PAD(0x450, 0x170, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D1__SSP_D1				IOMUX_PAD(0x450, 0x170, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D1__CCM_PLL2_BYP			IOMUX_PAD(0x450, 0x170, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D2__ESDHC3_DAT2			IOMUX_PAD(0x454, 0x174, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD3_D2__GPIO5_22			IOMUX_PAD(0x454, 0x174, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D2__EIM_NANDF_D_6			IOMUX_PAD(0x454, 0x174, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D2__SSP_D2				IOMUX_PAD(0x454, 0x174, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D2__CCM_PLL3_BYP			IOMUX_PAD(0x454, 0x174, 7, 0x6E4, 1, NO_PAD_CTRL)
#define MX50_PAD_SD3_D3__ESDHC3_DAT3			IOMUX_PAD(0x458, 0x178, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD3_D3__GPIO5_23			IOMUX_PAD(0x458, 0x178, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D3__EIM_NANDF_D_7			IOMUX_PAD(0x458, 0x178, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D3__SSP_D3				IOMUX_PAD(0x458, 0x178, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D4__ESDHC3_DAT4			IOMUX_PAD(0x45C, 0x17C, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD3_D4__GPIO5_24			IOMUX_PAD(0x45C, 0x17C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D4__EIM_NANDF_D_0			IOMUX_PAD(0x45C, 0x17C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D4__SSP_D4				IOMUX_PAD(0x45C, 0x17C, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D5__ESDHC3_DAT5			IOMUX_PAD(0x460, 0x180, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD3_D5__GPIO5_25			IOMUX_PAD(0x460, 0x180, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D5__EIM_NANDF_D_1			IOMUX_PAD(0x460, 0x180, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D5__SSP_D5				IOMUX_PAD(0x460, 0x180, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D6__ESDHC3_DAT6			IOMUX_PAD(0x464, 0x184, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD3_D6__GPIO5_26			IOMUX_PAD(0x464, 0x184, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D6__EIM_NANDF_D_2			IOMUX_PAD(0x464, 0x184, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D6__SSP_D6				IOMUX_PAD(0x464, 0x184, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D7__ESDHC3_DAT7			IOMUX_PAD(0x468, 0x188, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD3_D7__GPIO5_27			IOMUX_PAD(0x468, 0x188, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D7__EIM_NANDF_D_3			IOMUX_PAD(0x468, 0x188, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_D7__SSP_D7				IOMUX_PAD(0x468, 0x188, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_WP__ESDHC3_WP			IOMUX_PAD(0x46C, 0x18C, 0, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD3_WP__GPIO5_28			IOMUX_PAD(0x46C, 0x18C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_WP__EIM_NANDF_RESETN		IOMUX_PAD(0x46C, 0x18C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_WP__SSP_CD				IOMUX_PAD(0x46C, 0x18C, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_SD3_WP__ESDHC4_LCTL			IOMUX_PAD(0x46C, 0x18C, 4, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_SD3_WP__EIM_WEIM_CS_3			IOMUX_PAD(0x46C, 0x18C, 5, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D8__ELCDIF_DAT_8			IOMUX_PAD(0x470, 0x190, 0, 0x71C, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D8__GPIO2_8			IOMUX_PAD(0x470, 0x190, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D8__EIM_NANDF_CLE			IOMUX_PAD(0x470, 0x190, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D8__ESDHC1_LCTL			IOMUX_PAD(0x470, 0x190, 3, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D8__ESDHC4_CMD			IOMUX_PAD(0x470, 0x190, 4, 0x74C, 2, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D8__KPP_COL_4			IOMUX_PAD(0x470, 0x190, 5, 0x790, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D8__FEC_TX_CLK			IOMUX_PAD(0x470, 0x190, 6, 0x78C, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D8__USBPHY1_DATAOUT_0		IOMUX_PAD(0x470, 0x190, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D9__ELCDIF_DAT_9			IOMUX_PAD(0x474, 0x194, 0, 0x720, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D9__GPIO2_9			IOMUX_PAD(0x474, 0x194, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D9__EIM_NANDF_ALE			IOMUX_PAD(0x474, 0x194, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D9__ESDHC2_LCTL			IOMUX_PAD(0x474, 0x194, 3, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D9__ESDHC4_CLK			IOMUX_PAD(0x474, 0x194, 4, 0x748, 2, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D9__KPP_ROW_4			IOMUX_PAD(0x474, 0x194, 5, 0x7A0, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D9__FEC_RX_ER			IOMUX_PAD(0x474, 0x194, 6, 0x788, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D9__USBPHY1_DATAOUT_1		IOMUX_PAD(0x474, 0x194, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D10__ELCDIF_DAT_10		IOMUX_PAD(0x478, 0x198, 0, 0x724, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D10__GPIO2_10			IOMUX_PAD(0x478, 0x198, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D10__EIM_NANDF_CEN_0		IOMUX_PAD(0x478, 0x198, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D10__ESDHC3_LCTL			IOMUX_PAD(0x478, 0x198, 3, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D10__ESDHC4_DAT0			IOMUX_PAD(0x478, 0x198, 4, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D10__KPP_COL_5			IOMUX_PAD(0x478, 0x198, 5, 0x794, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D10__FEC_RX_DV			IOMUX_PAD(0x478, 0x198, 6, 0x784, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D10__USBPHY1_DATAOUT_2		IOMUX_PAD(0x478, 0x198, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D11__ELCDIF_DAT_11		IOMUX_PAD(0x47C, 0x19C, 0, 0x728, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D11__GPIO2_11			IOMUX_PAD(0x47C, 0x19C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D11__EIM_NANDF_CEN_1		IOMUX_PAD(0x47C, 0x19C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D11__ESDHC4_DAT1			IOMUX_PAD(0x47C, 0x19C, 4, 0x754, 1, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D11__KPP_ROW_5			IOMUX_PAD(0x47C, 0x19C, 5, 0x7A4, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D11__FEC_RDATA_1			IOMUX_PAD(0x47C, 0x19C, 6, 0x77C, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D11__USBPHY1_DATAOUT_3		IOMUX_PAD(0x47C, 0x19C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D12__ELCDIF_DAT_12		IOMUX_PAD(0x480, 0x1A0, 0, 0x72C, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D12__GPIO2_12			IOMUX_PAD(0x480, 0x1A0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D12__EIM_NANDF_CEN_2		IOMUX_PAD(0x480, 0x1A0, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D12__ESDHC1_CD			IOMUX_PAD(0x480, 0x1A0, 3, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D12__ESDHC4_DAT2			IOMUX_PAD(0x480, 0x1A0, 4, 0x758, 1, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D12__KPP_COL_6			IOMUX_PAD(0x480, 0x1A0, 5, 0x798, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D12__FEC_RDATA_0			IOMUX_PAD(0x480, 0x1A0, 6, 0x778, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D12__USBPHY1_DATAOUT_4		IOMUX_PAD(0x480, 0x1A0, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D13__ELCDIF_DAT_13		IOMUX_PAD(0x484, 0x1A4, 0, 0x730, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D13__GPIO2_13			IOMUX_PAD(0x484, 0x1A4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D13__EIM_NANDF_CEN_3		IOMUX_PAD(0x484, 0x1A4, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D13__ESDHC3_CD			IOMUX_PAD(0x484, 0x1A4, 3, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D13__ESDHC4_DAT3			IOMUX_PAD(0x484, 0x1A4, 4, 0x75C, 1, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D13__KPP_ROW_6			IOMUX_PAD(0x484, 0x1A4, 5, 0x7A8, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D13__FEC_TX_EN			IOMUX_PAD(0x484, 0x1A4, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D13__USBPHY1_DATAOUT_5		IOMUX_PAD(0x484, 0x1A4, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D14__ELCDIF_DAT_14		IOMUX_PAD(0x488, 0x1A8, 0, 0x734, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D14__GPIO2_14			IOMUX_PAD(0x488, 0x1A8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D14__EIM_NANDF_READY0		IOMUX_PAD(0x488, 0x1A8, 2, 0x7B4, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D14__ESDHC1_WP			IOMUX_PAD(0x488, 0x1A8, 3, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D14__ESDHC4_WP			IOMUX_PAD(0x488, 0x1A8, 4, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D14__KPP_COL_7			IOMUX_PAD(0x488, 0x1A8, 5, 0x79C, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D14__FEC_TDATA_1			IOMUX_PAD(0x488, 0x1A8, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D14__USBPHY1_DATAOUT_6		IOMUX_PAD(0x488, 0x1A8, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D15__ELCDIF_DAT_15		IOMUX_PAD(0x48C, 0x1AC, 0, 0x738, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D15__GPIO2_15			IOMUX_PAD(0x48C, 0x1AC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D15__EIM_NANDF_DQS		IOMUX_PAD(0x48C, 0x1AC, 2, 0x7B0, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D15__ESDHC3_RST			IOMUX_PAD(0x48C, 0x1AC, 3, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D15__ESDHC4_CD			IOMUX_PAD(0x48C, 0x1AC, 4, __NA_, 0, MX50_SDHC_PAD_CTRL)
#define MX50_PAD_DISP_D15__KPP_ROW_7			IOMUX_PAD(0x48C, 0x1AC, 5, 0x7AC, 1, NO_PAD_CTRL)
#define MX50_PAD_DISP_D15__FEC_TDATA_0			IOMUX_PAD(0x48C, 0x1AC, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_DISP_D15__USBPHY1_DATAOUT_7		IOMUX_PAD(0x48C, 0x1AC, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D0__EPDC_SDDO_0			IOMUX_PAD(0x54C, 0x1B0, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D0__GPIO3_0			IOMUX_PAD(0x54C, 0x1B0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D0__EIM_WEIM_D_0			IOMUX_PAD(0x54C, 0x1B0, 2, 0x7EC, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D0__ELCDIF_RS			IOMUX_PAD(0x54C, 0x1B0, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D0__ELCDIF_DOTCLK			IOMUX_PAD(0x54C, 0x1B0, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D0__SDMA_DEBUG_EVT_CHN_LINES_0	IOMUX_PAD(0x54C, 0x1B0, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D0__USBPHY2_DATAOUT_0		IOMUX_PAD(0x54C, 0x1B0, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D1__EPDC_SDDO_1			IOMUX_PAD(0x550, 0x1B4, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D1__GPIO3_1			IOMUX_PAD(0x550, 0x1B4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D1__EIM_WEIM_D_1			IOMUX_PAD(0x550, 0x1B4, 2, 0x7F0, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D1__ELCDIF_CS			IOMUX_PAD(0x550, 0x1B4, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D1__ELCDIF_ENABLE			IOMUX_PAD(0x550, 0x1B4, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D1__SDMA_DEBUG_EVT_CHN_LINES_1	IOMUX_PAD(0x550, 0x1B4, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D1__USBPHY2_DATAOUT_1		IOMUX_PAD(0x550, 0x1B4, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D2__EPDC_SDDO_2			IOMUX_PAD(0x554, 0x1B8, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D2__GPIO3_2			IOMUX_PAD(0x554, 0x1B8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D2__EIM_WEIM_D_2			IOMUX_PAD(0x554, 0x1B8, 2, 0x7F4, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D2__ELCDIF_WR_RWN			IOMUX_PAD(0x554, 0x1B8, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D2__ELCDIF_VSYNC			IOMUX_PAD(0x554, 0x1B8, 4, 0x73C, 2, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D2__SDMA_DEBUG_EVT_CHN_LINES_2	IOMUX_PAD(0x554, 0x1B8, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D2__USBPHY2_DATAOUT_2		IOMUX_PAD(0x554, 0x1B8, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D3__EPDC_SDDO_3			IOMUX_PAD(0x558, 0x1BC, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D3__GPIO3_3			IOMUX_PAD(0x558, 0x1BC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D3__EIM_WEIM_D_3			IOMUX_PAD(0x558, 0x1BC, 2, 0x7F8, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D3__ELCDIF_RD_E			IOMUX_PAD(0x558, 0x1BC, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D3__ELCDIF_HSYNC			IOMUX_PAD(0x558, 0x1BC, 4, 0x6F8, 3, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D3__SDMA_DEBUG_EVT_CHN_LINES_3	IOMUX_PAD(0x558, 0x1BC, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D3__USBPHY2_DATAOUT_3		IOMUX_PAD(0x558, 0x1BC, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D4__EPDC_SDDO_4			IOMUX_PAD(0x55C, 0x1C0, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D4__GPIO3_4			IOMUX_PAD(0x55C, 0x1C0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D4__EIM_WEIM_D_4			IOMUX_PAD(0x55C, 0x1C0, 2, 0x7FC, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D4__SDMA_DEBUG_EVT_CHN_LINES_4	IOMUX_PAD(0x55C, 0x1C0, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D4__USBPHY2_DATAOUT_4		IOMUX_PAD(0x55C, 0x1C0, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D5__EPDC_SDDO_5			IOMUX_PAD(0x560, 0x1C4, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D5__GPIO3_5			IOMUX_PAD(0x560, 0x1C4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D5__EIM_WEIM_D_5			IOMUX_PAD(0x560, 0x1C4, 2, 0x800, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D5__SDMA_DEBUG_EVT_CHN_LINES_5	IOMUX_PAD(0x560, 0x1C4, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D5__USBPHY2_DATAOUT_5		IOMUX_PAD(0x560, 0x1C4, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D6__EPDC_SDDO_6			IOMUX_PAD(0x564, 0x1C8, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D6__GPIO3_6			IOMUX_PAD(0x564, 0x1C8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D6__EIM_WEIM_D_6			IOMUX_PAD(0x564, 0x1C8, 2, 0x804, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D6__SDMA_DEBUG_EVT_CHN_LINES_6	IOMUX_PAD(0x564, 0x1C8, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D6__USBPHY2_DATAOUT_6		IOMUX_PAD(0x564, 0x1C8, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D7__EPDC_SDDO_7			IOMUX_PAD(0x568, 0x1CC, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D7__GPIO3_7			IOMUX_PAD(0x568, 0x1CC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D7__EIM_WEIM_D_7			IOMUX_PAD(0x568, 0x1CC, 2, 0x808, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D7__SDMA_DEBUG_EVT_CHN_LINES_7	IOMUX_PAD(0x568, 0x1CC, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D7__USBPHY2_DATAOUT_7		IOMUX_PAD(0x568, 0x1CC, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D8__EPDC_SDDO_8			IOMUX_PAD(0x56C, 0x1D0, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D8__GPIO3_8			IOMUX_PAD(0x56C, 0x1D0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D8__EIM_WEIM_D_8			IOMUX_PAD(0x56C, 0x1D0, 2, 0x80C, 2, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D8__ELCDIF_DAT_24			IOMUX_PAD(0x56C, 0x1D0, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D8__SDMA_DEBUG_MATCHED_DMBUS	IOMUX_PAD(0x56C, 0x1D0, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D8__USBPHY2_VSTATUS_0		IOMUX_PAD(0x56C, 0x1D0, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D9__EPDC_SDDO_9			IOMUX_PAD(0x570, 0x1D4, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D9__GPIO3_9			IOMUX_PAD(0x570, 0x1D4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D9__EIM_WEIM_D_9			IOMUX_PAD(0x570, 0x1D4, 2, 0x810, 2, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D9__ELCDIF_DAT_25			IOMUX_PAD(0x570, 0x1D4, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D9__SDMA_DEBUG_EVENT_CHANNEL_SEL	IOMUX_PAD(0x570, 0x1D4, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D9__USBPHY2_VSTATUS_1		IOMUX_PAD(0x570, 0x1D4, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D10__EPDC_SDDO_10			IOMUX_PAD(0x574, 0x1D8, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D10__GPIO3_10			IOMUX_PAD(0x574, 0x1D8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D10__EIM_WEIM_D_10		IOMUX_PAD(0x574, 0x1D8, 2, 0x814, 2, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D10__ELCDIF_DAT_26		IOMUX_PAD(0x574, 0x1D8, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D10__SDMA_DEBUG_EVENT_CHANNEL_0	IOMUX_PAD(0x574, 0x1D8, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D10__USBPHY2_VSTATUS_2		IOMUX_PAD(0x574, 0x1D8, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D11__EPDC_SDDO_11			IOMUX_PAD(0x578, 0x1DC, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D11__GPIO3_11			IOMUX_PAD(0x578, 0x1DC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D11__EIM_WEIM_D_11		IOMUX_PAD(0x578, 0x1DC, 2, 0x818, 2, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D11__ELCDIF_DAT_27		IOMUX_PAD(0x578, 0x1DC, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D11__SDMA_DEBUG_EVENT_CHANNEL_1	IOMUX_PAD(0x578, 0x1DC, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D11__USBPHY2_VSTATUS_3		IOMUX_PAD(0x578, 0x1DC, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D12__EPDC_SDDO_12			IOMUX_PAD(0x57C, 0x1E0, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D12__GPIO3_12			IOMUX_PAD(0x57C, 0x1E0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D12__EIM_WEIM_D_12		IOMUX_PAD(0x57C, 0x1E0, 2, 0x81C, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D12__ELCDIF_DAT_28		IOMUX_PAD(0x57C, 0x1E0, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D12__SDMA_DEBUG_EVENT_CHANNEL_2	IOMUX_PAD(0x57C, 0x1E0, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D12__USBPHY2_VSTATUS_4		IOMUX_PAD(0x57C, 0x1E0, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D13__EPDC_SDDO_13			IOMUX_PAD(0x580, 0x1E4, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D13__GPIO3_13			IOMUX_PAD(0x580, 0x1E4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D13__EIM_WEIM_D_13		IOMUX_PAD(0x580, 0x1E4, 2, 0x820, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D13__ELCDIF_DAT_29		IOMUX_PAD(0x580, 0x1E4, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D13__SDMA_DEBUG_EVENT_CHANNEL_3	IOMUX_PAD(0x580, 0x1E4, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D13__USBPHY2_VSTATUS_5		IOMUX_PAD(0x580, 0x1E4, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D14__EPDC_SDDO_14			IOMUX_PAD(0x584, 0x1E8, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D14__GPIO3_14			IOMUX_PAD(0x584, 0x1E8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D14__EIM_WEIM_D_14		IOMUX_PAD(0x584, 0x1E8, 2, 0x824, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D14__ELCDIF_DAT_30		IOMUX_PAD(0x584, 0x1E8, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D14__AUDMUX_AUD6_TXD		IOMUX_PAD(0x584, 0x1E8, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D14__SDMA_DEBUG_EVENT_CHANNEL_4	IOMUX_PAD(0x584, 0x1E8, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D14__USBPHY2_VSTATUS_6		IOMUX_PAD(0x584, 0x1E8, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D15__EPDC_SDDO_15			IOMUX_PAD(0x588, 0x1EC, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D15__GPIO3_15			IOMUX_PAD(0x588, 0x1EC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D15__EIM_WEIM_D_15		IOMUX_PAD(0x588, 0x1EC, 2, 0x828, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D15__ELCDIF_DAT_31		IOMUX_PAD(0x588, 0x1EC, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D15__AUDMUX_AUD6_TXC		IOMUX_PAD(0x588, 0x1EC, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D15__SDMA_DEBUG_EVENT_CHANNEL_5	IOMUX_PAD(0x588, 0x1EC, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_D15__USBPHY2_VSTATUS_7		IOMUX_PAD(0x588, 0x1EC, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDCLK__EPDC_GDCLK			IOMUX_PAD(0x58C, 0x1F0, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDCLK__GPIO3_16			IOMUX_PAD(0x58C, 0x1F0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDCLK__EIM_WEIM_D_16		IOMUX_PAD(0x58C, 0x1F0, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDCLK__ELCDIF_DAT_16		IOMUX_PAD(0x58C, 0x1F0, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDCLK__AUDMUX_AUD6_TXFS		IOMUX_PAD(0x58C, 0x1F0, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDCLK__SDMA_DEBUG_CORE_STATE_0	IOMUX_PAD(0x58C, 0x1F0, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDCLK__USBPHY2_BISTOK		IOMUX_PAD(0x58C, 0x1F0, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDSP__EPCD_GDSP			IOMUX_PAD(0x590, 0x1F4, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDSP__GPIO3_17			IOMUX_PAD(0x590, 0x1F4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDSP__EIM_WEIM_D_17		IOMUX_PAD(0x590, 0x1F4, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDSP__ELCDIF_DAT_17		IOMUX_PAD(0x590, 0x1F4, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDSP__AUDMUX_AUD6_RXD		IOMUX_PAD(0x590, 0x1F4, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDSP__SDMA_DEBUG_CORE_STATE_1	IOMUX_PAD(0x590, 0x1F4, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDSP__USBPHY2_BVALID		IOMUX_PAD(0x590, 0x1F4, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDOE__EPCD_GDOE			IOMUX_PAD(0x594, 0x1F8, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDOE__GPIO3_18			IOMUX_PAD(0x594, 0x1F8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDOE__EIM_WEIM_D_18		IOMUX_PAD(0x594, 0x1F8, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDOE__ELCDIF_DAT_18		IOMUX_PAD(0x594, 0x1F8, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDOE__AUDMUX_AUD6_RXC		IOMUX_PAD(0x594, 0x1F8, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDOE__SDMA_DEBUG_CORE_STATE_2	IOMUX_PAD(0x594, 0x1F8, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDOE__USBPHY2_ENDSESSION		IOMUX_PAD(0x594, 0x1F8, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDRL__EPCD_GDRL			IOMUX_PAD(0x598, 0x1FC, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDRL__GPIO3_19			IOMUX_PAD(0x598, 0x1FC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDRL__EIM_WEIM_D_19		IOMUX_PAD(0x598, 0x1F8, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDRL__ELCDIF_DAT_19		IOMUX_PAD(0x598, 0x1FC, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDRL__AUDMUX_AUD6_RXFS		IOMUX_PAD(0x598, 0x1FC, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDRL__SDMA_DEBUG_CORE_STATE_3	IOMUX_PAD(0x598, 0x1FC, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_GDRL__USBPHY2_IDDIG		IOMUX_PAD(0x598, 0x1FC, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLK__EPCD_SDCLK			IOMUX_PAD(0x59C, 0x200, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLK__GPIO3_20			IOMUX_PAD(0x59C, 0x200, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLK__EIM_WEIM_D_20		IOMUX_PAD(0x59C, 0x200, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLK__ELCDIF_DAT_20		IOMUX_PAD(0x59C, 0x200, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLK__AUDMUX_AUD5_TXD		IOMUX_PAD(0x59C, 0x200, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLK__SDMA_DEBUG_BUS_DEVICE_0	IOMUX_PAD(0x59C, 0x200, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLK__USBPHY2_HOSTDISCONNECT	IOMUX_PAD(0x59C, 0x200, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOEZ__EPCD_SDOEZ			IOMUX_PAD(0x5A0, 0x204, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOEZ__GPIO3_21			IOMUX_PAD(0x5A0, 0x204, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOEZ__EIM_WEIM_D_21		IOMUX_PAD(0x5A0, 0x204, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOEZ__ELCDIF_DAT_21		IOMUX_PAD(0x5A0, 0x204, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOEZ__AUDMUX_AUD5_TXC		IOMUX_PAD(0x5A0, 0x204, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOEZ__SDMA_DEBUG_BUS_DEVICE_1	IOMUX_PAD(0x5A0, 0x204, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOEZ__USBPHY2_TXREADY		IOMUX_PAD(0x5A0, 0x204, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOED__EPCD_SDOED			IOMUX_PAD(0x5A4, 0x208, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOED__GPIO3_22			IOMUX_PAD(0x5A4, 0x208, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOED__EIM_WEIM_D_22		IOMUX_PAD(0x5A4, 0x208, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOED__ELCDIF_DAT_22		IOMUX_PAD(0x5A4, 0x208, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOED__AUDMUX_AUD5_TXFS		IOMUX_PAD(0x5A4, 0x208, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOED__SDMA_DEBUG_BUS_DEVICE_2	IOMUX_PAD(0x5A4, 0x208, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOED__USBPHY2_RXVALID		IOMUX_PAD(0x5A4, 0x208, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOE__EPCD_SDOE			IOMUX_PAD(0x5A8, 0x20C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOE__GPIO3_23			IOMUX_PAD(0x5A8, 0x20C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOE__EIM_WEIM_D_23		IOMUX_PAD(0x5A8, 0x20C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOE__ELCDIF_DAT_23		IOMUX_PAD(0x5A8, 0x20C, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOE__AUDMUX_AUD5_RXD		IOMUX_PAD(0x5A8, 0x20C, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOE__SDMA_DEBUG_BUS_DEVICE_3	IOMUX_PAD(0x5A8, 0x20C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDOE__USBPHY2_RXACTIVE		IOMUX_PAD(0x5A8, 0x20C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDLE__EPCD_SDLE			IOMUX_PAD(0x5AC, 0x210, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDLE__GPIO3_24			IOMUX_PAD(0x5AC, 0x210, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDLE__EIM_WEIM_D_24		IOMUX_PAD(0x5AC, 0x210, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDLE__ELCDIF_DAT_8		IOMUX_PAD(0x5AC, 0x210, 3, 0x71C, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDLE__AUDMUX_AUD5_RXC		IOMUX_PAD(0x5AC, 0x210, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDLE__SDMA_DEBUG_BUS_DEVICE_4	IOMUX_PAD(0x5AC, 0x210, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDLE__USBPHY2_RXERROR		IOMUX_PAD(0x5AC, 0x210, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLKN__EPCD_SDCLKN		IOMUX_PAD(0x5B0, 0x214, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLKN__GPIO3_25			IOMUX_PAD(0x5B0, 0x214, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLKN__EIM_WEIM_D_25		IOMUX_PAD(0x5B0, 0x214, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLKN__ELCDIF_DAT_9		IOMUX_PAD(0x5B0, 0x214, 3, 0x720, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLKN__AUDMUX_AUD5_RXFS		IOMUX_PAD(0x5B0, 0x214, 4, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLKN__SDMA_DEBUG_BUS_ERROR	IOMUX_PAD(0x5B0, 0x214, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCLKN__USBPHY2_SIECLOCK		IOMUX_PAD(0x5B0, 0x214, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDSHR__EPCD_SDSHR			IOMUX_PAD(0x5B4, 0x218, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDSHR__GPIO3_26			IOMUX_PAD(0x5B4, 0x218, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDSHR__EIM_WEIM_D_26		IOMUX_PAD(0x5B4, 0x218, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDSHR__ELCDIF_DAT_10		IOMUX_PAD(0x5B4, 0x218, 3, 0x724, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDSHR__AUDMUX_AUD4_TXD		IOMUX_PAD(0x5B4, 0x218, 4, 0x6C8, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDSHR__SDMA_DEBUG_BUS_RWB		IOMUX_PAD(0x5B4, 0x218, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDSHR__USBPHY2_LINESTATE_0	IOMUX_PAD(0x5B4, 0x218, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCOM__EPCD_PWRCOM		IOMUX_PAD(0x5B8, 0x21C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCOM__GPIO3_27			IOMUX_PAD(0x5B8, 0x21C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCOM__EIM_WEIM_D_27		IOMUX_PAD(0x5B8, 0x21C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCOM__ELCDIF_DAT_11		IOMUX_PAD(0x5B8, 0x21C, 3, 0x728, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCOM__AUDMUX_AUD4_TXC		IOMUX_PAD(0x5B8, 0x21C, 4, 0x6D4, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCOM__SDMA_DEBUG_CORE_RUN	IOMUX_PAD(0x5B8, 0x21C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCOM__USBPHY2_LINESTATE_1	IOMUX_PAD(0x5B8, 0x21C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRSTAT__EPCD_PWRSTAT		IOMUX_PAD(0x5BC, 0x220, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRSTAT__GPIO3_28			IOMUX_PAD(0x5BC, 0x220, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRSTAT__EIM_WEIM_D_28		IOMUX_PAD(0x5BC, 0x220, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRSTAT__ELCDIF_DAT_12		IOMUX_PAD(0x5BC, 0x220, 3, 0x72C, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRSTAT__AUDMUX_AUD4_TXFS		IOMUX_PAD(0x5BC, 0x220, 4, 0x6D8, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRSTAT__SDMA_DEBUG_MODE		IOMUX_PAD(0x5BC, 0x220, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRSTAT__USBPHY2_VBUSVALID	IOMUX_PAD(0x5BC, 0x220, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL0__EPCD_PWRCTRL0		IOMUX_PAD(0x5C0, 0x224, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL0__GPIO3_29		IOMUX_PAD(0x5C0, 0x224, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL0__EIM_WEIM_D_29		IOMUX_PAD(0x5C0, 0x224, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL0__ELCDIF_DAT_13		IOMUX_PAD(0x5C0, 0x224, 3, 0x730, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL0__AUDMUX_AUD4_RXD		IOMUX_PAD(0x5C0, 0x224, 4, 0x6C4, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL0__SDMA_DEBUG_RTBUFFER_WRITE	IOMUX_PAD(0x5C0, 0x224, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL0__USBPHY2_AVALID		IOMUX_PAD(0x5C0, 0x224, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL1__EPCD_PWRCTRL1		IOMUX_PAD(0x5C4, 0x228, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL1__GPIO3_30		IOMUX_PAD(0x5C4, 0x228, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL1__EIM_WEIM_D_30		IOMUX_PAD(0x5C4, 0x228, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL1__ELCDIF_DAT_14		IOMUX_PAD(0x5C4, 0x228, 3, 0x734, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL1__AUDMUX_AUD4_RXC		IOMUX_PAD(0x5C4, 0x228, 4, 0x6CC, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL1__SDMA_DEBUG_YIELD	IOMUX_PAD(0x5C4, 0x228, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL1__USBPHY1_ONBIST		IOMUX_PAD(0x5C4, 0x228, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL2__EPCD_PWRCTRL2		IOMUX_PAD(0x5C8, 0x22C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL2__GPIO3_31		IOMUX_PAD(0x5C8, 0x22C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL2__EIM_WEIM_D_31		IOMUX_PAD(0x5C8, 0x22C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL2__ELCDIF_DAT_15		IOMUX_PAD(0x5C8, 0x22C, 3, 0x738, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL2__AUDMUX_AUD4_RXFS	IOMUX_PAD(0x5C8, 0x22C, 4, 0x6D0, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL2__SDMA_EXT_EVENT_0	IOMUX_PAD(0x5C8, 0x22C, 6, 0x7B8, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL2__USBPHY2_ONBIST		IOMUX_PAD(0x5C8, 0x22C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL3__EPCD_PWRCTRL3		IOMUX_PAD(0x5CC, 0x230, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL3__GPIO4_20		IOMUX_PAD(0x5CC, 0x230, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL3__EIM_WEIM_EB_2		IOMUX_PAD(0x5CC, 0x230, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL3__SDMA_EXT_EVENT_1	IOMUX_PAD(0x5CC, 0x230, 6, 0x7BC, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_PWRCTRL3__USBPHY1_BISTOK		IOMUX_PAD(0x5CC, 0x230, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_VCOM0__EPCD_VCOM_0		IOMUX_PAD(0x5D0, 0x234, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_VCOM0__GPIO4_21			IOMUX_PAD(0x5D0, 0x234, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_VCOM0__EIM_WEIM_EB_3		IOMUX_PAD(0x5D0, 0x234, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_VCOM0__USBPHY2_BISTOK		IOMUX_PAD(0x5D0, 0x234, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_VCOM1__EPCD_VCOM_1		IOMUX_PAD(0x5D4, 0x238, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_VCOM1__GPIO4_22			IOMUX_PAD(0x5D4, 0x238, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_VCOM1__EIM_WEIM_CS_3		IOMUX_PAD(0x5D4, 0x238, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_BDR0__EPCD_BDR_0			IOMUX_PAD(0x5D8, 0x23C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_BDR0__GPIO4_23			IOMUX_PAD(0x5D8, 0x23C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_BDR0__ELCDIF_DAT_7		IOMUX_PAD(0x5D8, 0x23C, 3, 0x718, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_BDR1__EPCD_BDR_1			IOMUX_PAD(0x5DC, 0x240, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_BDR1__GPIO4_24			IOMUX_PAD(0x5DC, 0x240, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_BDR1__ELCDIF_DAT_6		IOMUX_PAD(0x5DC, 0x240, 3, 0x714, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE0__EPCD_SDCE_0		IOMUX_PAD(0x5E0, 0x244, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE0__GPIO4_25			IOMUX_PAD(0x5E0, 0x244, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE0__ELCDIF_DAT_5		IOMUX_PAD(0x5E0, 0x244, 3, 0x710, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE1__EPCD_SDCE_1		IOMUX_PAD(0x5E4, 0x248, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE1__GPIO4_26			IOMUX_PAD(0x5E4, 0x248, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE1__ELCDIF_DAT_4		IOMUX_PAD(0x5E4, 0x248, 3, 0x70C, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE2__EPCD_SDCE_2		IOMUX_PAD(0x5E8, 0x24C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE2__GPIO4_27			IOMUX_PAD(0x5E8, 0x24C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE2__ELCDIF_DAT_3		IOMUX_PAD(0x5E8, 0x24C, 3, 0x708, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE3__EPCD_SDCE_3		IOMUX_PAD(0x5EC, 0x250, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE3__GPIO4_28			IOMUX_PAD(0x5EC, 0x250, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE3__ELCDIF_DAT_2		IOMUX_PAD(0x5EC, 0x250, 3, 0x704, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE4__EPCD_SDCE_4		IOMUX_PAD(0x5F0, 0x254, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE4__GPIO4_29			IOMUX_PAD(0x5F0, 0x254, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE4__ELCDIF_DAT_1		IOMUX_PAD(0x5F0, 0x254, 3, 0x700, 1, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE5__EPCD_SDCE_5		IOMUX_PAD(0x5F4, 0x258, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE5__GPIO4_30			IOMUX_PAD(0x5F4, 0x258, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EPDC_SDCE5__ELCDIF_DAT_0		IOMUX_PAD(0x5F4, 0x258, 3, 0x6FC, 1, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA0__EIM_WEIM_A_0			IOMUX_PAD(0x5F8, 0x25C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA0__GPIO1_0			IOMUX_PAD(0x5F8, 0x25C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA0__KPP_COL_4			IOMUX_PAD(0x5F8, 0x25C, 3, 0x790, 2, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA0__TPIU_TRACE_0			IOMUX_PAD(0x5F8, 0x25C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA0__SRC_BT_CFG1_0			IOMUX_PAD(0x5F8, 0x25C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA1__EIM_WEIM_A_1			IOMUX_PAD(0x5FC, 0x260, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA1__GPIO1_1			IOMUX_PAD(0x5FC, 0x260, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA1__KPP_ROW_4			IOMUX_PAD(0x5FC, 0x260, 3, 0x7A0, 2, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA1__TPIU_TRACE_1			IOMUX_PAD(0x5FC, 0x260, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA1__SRC_BT_CFG1_1			IOMUX_PAD(0x5FC, 0x260, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA2__EIM_WEIM_A_2			IOMUX_PAD(0x600, 0x264, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA2__GPIO1_2			IOMUX_PAD(0x600, 0x264, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA2__KPP_COL_5			IOMUX_PAD(0x600, 0x264, 3, 0x794, 2, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA2__TPIU_TRACE_2			IOMUX_PAD(0x600, 0x264, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA2__SRC_BT_CFG1_2			IOMUX_PAD(0x600, 0x264, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA3__EIM_WEIM_A_3			IOMUX_PAD(0x604, 0x268, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA3__GPIO1_3			IOMUX_PAD(0x604, 0x268, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA3__KPP_ROW_5			IOMUX_PAD(0x604, 0x268, 3, 0x7A4, 2, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA3__TPIU_TRACE_3			IOMUX_PAD(0x604, 0x268, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA3__SRC_BT_CFG1_3			IOMUX_PAD(0x604, 0x268, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA4__EIM_WEIM_A_4			IOMUX_PAD(0x608, 0x26C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA4__GPIO1_4			IOMUX_PAD(0x608, 0x26C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA4__KPP_COL_6			IOMUX_PAD(0x608, 0x26C, 3, 0x798, 2, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA4__TPIU_TRACE_4			IOMUX_PAD(0x608, 0x26C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA4__SRC_BT_CFG1_4			IOMUX_PAD(0x608, 0x26C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA5__EIM_WEIM_A_5			IOMUX_PAD(0x60C, 0x270, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA5__GPIO1_5			IOMUX_PAD(0x60C, 0x270, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA5__KPP_ROW_6			IOMUX_PAD(0x60C, 0x270, 3, 0x7A8, 2, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA5__TPIU_TRACE_5			IOMUX_PAD(0x60C, 0x270, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA5__SRC_BT_CFG1_5			IOMUX_PAD(0x60C, 0x270, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA6__EIM_WEIM_A_6			IOMUX_PAD(0x610, 0x274, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA6__GPIO1_6			IOMUX_PAD(0x610, 0x274, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA6__KPP_COL_7			IOMUX_PAD(0x610, 0x274, 3, 0x79C, 2, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA6__TPIU_TRACE_6			IOMUX_PAD(0x610, 0x274, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA6__SRC_BT_CFG1_6			IOMUX_PAD(0x610, 0x274, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA7__EIM_WEIM_A_7			IOMUX_PAD(0x614, 0x278, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA7__GPIO1_7			IOMUX_PAD(0x614, 0x278, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA7__KPP_ROW_7			IOMUX_PAD(0x614, 0x278, 3, 0x7AC, 2, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA7__TPIU_TRACE_7			IOMUX_PAD(0x614, 0x278, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA7__SRC_BT_CFG1_7			IOMUX_PAD(0x614, 0x278, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA8__EIM_WEIM_A_8			IOMUX_PAD(0x618, 0x27C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA8__GPIO1_8			IOMUX_PAD(0x618, 0x27C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA8__EIM_NANDF_CLE			IOMUX_PAD(0x618, 0x27C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA8__TPIU_TRACE_8			IOMUX_PAD(0x618, 0x27C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA8__SRC_BT_CFG2_0			IOMUX_PAD(0x618, 0x27C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA9__EIM_WEIM_A_9			IOMUX_PAD(0x61C, 0x280, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA9__GPIO1_9			IOMUX_PAD(0x61C, 0x280, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA9__EIM_NANDF_ALE			IOMUX_PAD(0x61C, 0x280, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA9__TPIU_TRACE_9			IOMUX_PAD(0x61C, 0x280, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA9__SRC_BT_CFG2_1			IOMUX_PAD(0x61C, 0x280, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA10__EIM_WEIM_A_10		IOMUX_PAD(0x620, 0x284, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA10__GPIO1_10			IOMUX_PAD(0x620, 0x284, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA10__EIM_NANDF_CEN_0		IOMUX_PAD(0x620, 0x284, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA10__TPIU_TRACE_10		IOMUX_PAD(0x620, 0x284, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA10__SRC_BT_CFG2_2		IOMUX_PAD(0x620, 0x284, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA11__EIM_WEIM_A_11		IOMUX_PAD(0x624, 0x288, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA11__GPIO1_11			IOMUX_PAD(0x624, 0x288, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA11__EIM_NANDF_CEN_1		IOMUX_PAD(0x624, 0x288, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA11__TPIU_TRACE_11		IOMUX_PAD(0x624, 0x288, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA11__SRC_BT_CFG2_3		IOMUX_PAD(0x624, 0x288, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA12__EIM_WEIM_A_12		IOMUX_PAD(0x628, 0x28C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA12__GPIO1_12			IOMUX_PAD(0x628, 0x28C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA12__EIM_NANDF_CEN_2		IOMUX_PAD(0x628, 0x28C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA12__EPDC_SDCE_6			IOMUX_PAD(0x628, 0x28C, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA12__TPIU_TRACE_12		IOMUX_PAD(0x628, 0x28C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA12__SRC_BT_CFG2_4		IOMUX_PAD(0x628, 0x28C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA13__EIM_WEIM_A_13		IOMUX_PAD(0x62C, 0x290, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA13__GPIO1_13			IOMUX_PAD(0x62C, 0x290, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA13__EIM_NANDF_CEN_3		IOMUX_PAD(0x62C, 0x290, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA13__EPDC_SDCE_7			IOMUX_PAD(0x62C, 0x290, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA13__TPIU_TRACE_13		IOMUX_PAD(0x62C, 0x290, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA13__SRC_BT_CFG2_5		IOMUX_PAD(0x62C, 0x290, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA14__EIM_WEIM_A_14		IOMUX_PAD(0x630, 0x294, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA14__GPIO1_14			IOMUX_PAD(0x630, 0x294, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA14__EIM_NANDF_READY0		IOMUX_PAD(0x630, 0x294, 2, 0x7B4, 2, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA14__EPDC_SDCE_8			IOMUX_PAD(0x630, 0x294, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA14__TPIU_TRACE_14		IOMUX_PAD(0x630, 0x294, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA14__SRC_BT_CFG2_6		IOMUX_PAD(0x630, 0x294, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA15__EIM_WEIM_A_15		IOMUX_PAD(0x634, 0x298, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA15__GPIO1_15			IOMUX_PAD(0x634, 0x298, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA15__EIM_NANDF_DQS		IOMUX_PAD(0x634, 0x298, 2, 0x7B0, 2, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA15__EPDC_SDCE_9			IOMUX_PAD(0x634, 0x298, 3, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA15__TPIU_TRACE_15		IOMUX_PAD(0x634, 0x298, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_DA15__SRC_BT_CFG2_7		IOMUX_PAD(0x634, 0x298, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CS2__EIM_WEIM_CS_2			IOMUX_PAD(0x638, 0x29C, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CS2__GPIO1_16			IOMUX_PAD(0x638, 0x29C, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CS2__EIM_WEIM_A_27			IOMUX_PAD(0x638, 0x29C, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CS2__TPIU_TRCLK			IOMUX_PAD(0x638, 0x29C, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CS2__SRC_BT_CFG3_0			IOMUX_PAD(0x638, 0x29C, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CS1__EIM_WEIM_CS_1			IOMUX_PAD(0x63C, 0x2A0, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CS1__GPIO1_17			IOMUX_PAD(0x63C, 0x2A0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CS1__TPIU_TRCTL			IOMUX_PAD(0x63C, 0x2A0, 6, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CS1__SRC_BT_CFG3_1			IOMUX_PAD(0x63C, 0x2A0, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CS0__EIM_WEIM_CS_0			IOMUX_PAD(0x640, 0x2A4, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CS0__GPIO1_18			IOMUX_PAD(0x640, 0x2A4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CS0__SRC_BT_CFG3_2			IOMUX_PAD(0x640, 0x2A4, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_EB0__EIM_WEIM_EB_0			IOMUX_PAD(0x644, 0x2A8, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_EB0__GPIO1_19			IOMUX_PAD(0x644, 0x2A8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_EB0__SRC_BT_CFG3_3			IOMUX_PAD(0x644, 0x2A8, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_EB1__EIM_WEIM_EB_1			IOMUX_PAD(0x648, 0x2AC, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_EB1__GPIO1_20			IOMUX_PAD(0x648, 0x2AC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_EB1__SRC_BT_CFG3_4			IOMUX_PAD(0x648, 0x2AC, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_WAIT__EIM_WEIM_WAIT		IOMUX_PAD(0x64C, 0x2B0, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_WAIT__GPIO1_21			IOMUX_PAD(0x64C, 0x2B0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_WAIT__EIM_WEIM_DTACK_B		IOMUX_PAD(0x64C, 0x2B0, 2, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_WAIT__SRC_BT_CFG3_5		IOMUX_PAD(0x64C, 0x2B0, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_BCLK__EIM_WEIM_BCLK		IOMUX_PAD(0x650, 0x2B4, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_BCLK__GPIO1_22			IOMUX_PAD(0x650, 0x2B4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_BCLK__SRC_BT_CFG3_6		IOMUX_PAD(0x650, 0x2B4, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_RDY__EIM_WEIM_RDY			IOMUX_PAD(0x654, 0x2B8, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_RDY__GPIO1_23			IOMUX_PAD(0x654, 0x2B8, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_RDY__SRC_BT_CFG3_7			IOMUX_PAD(0x654, 0x2B8, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_OE__EIM_WEIM_OE			IOMUX_PAD(0x658, 0x2BC, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_OE__GPIO1_24			IOMUX_PAD(0x658, 0x2BC, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_OE__INT_BOOT			IOMUX_PAD(0x658, 0x2BC, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_RW__EIM_WEIM_RW			IOMUX_PAD(0x65C, 0x2C0, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_RW__GPIO1_25			IOMUX_PAD(0x65C, 0x2C0, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_RW__SYSTEM_RST			IOMUX_PAD(0x65C, 0x2C0, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_LBA__EIM_WEIM_LBA			IOMUX_PAD(0x660, 0x2C4, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_LBA__GPIO1_26			IOMUX_PAD(0x660, 0x2C4, 1, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_LBA__TESTER_ACK			IOMUX_PAD(0x660, 0x2C4, 7, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CRE__EIM_WEIM_CRE			IOMUX_PAD(0x664, 0x2C8, 0, __NA_, 0, NO_PAD_CTRL)
#define MX50_PAD_EIM_CRE__GPIO1_27			IOMUX_PAD(0x664, 0x2C8, 1, __NA_, 0, NO_PAD_CTRL)

#endif /* __MACH_IOMUX_MX50_H__ */
