/*
 * Copyright 2013-2014 Freescale Semiconductor, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef __MACH_VF610_REGS_H__
#define __MACH_VF610_REGS_H__

#define VF610_IRAM_BASE_ADDR		0x3F000000	/* internal ram */
#define VF610_IRAM_SIZE			0x00080000	/* 512 KB */

#define VF610_AIPS0_BASE_ADDR		0x40000000
#define VF610_AIPS1_BASE_ADDR		0x40080000

#define VF610_RAM_BASE_ADDR		0x80000000

/* AIPS 0 */
#define VF610_MSCM_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00001000)
#define VF610_MSCM_IR_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00001800)
#define VF610_CA5SCU_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00002000)
#define VF610_CA5_INTD_BASE_ADDR	(VF610_AIPS0_BASE_ADDR + 0x00003000)
#define VF610_CA5_L2C_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00006000)
#define VF610_NIC0_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00008000)
#define VF610_NIC1_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00009000)
#define VF610_NIC2_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0000A000)
#define VF610_NIC3_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0000B000)
#define VF610_NIC4_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0000C000)
#define VF610_NIC5_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0000D000)
#define VF610_NIC6_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0000E000)
#define VF610_NIC7_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0000F000)
#define VF610_AHBTZASC_BASE_ADDR	(VF610_AIPS0_BASE_ADDR + 0x00010000)
#define VF610_TZASC_SYS0_BASE_ADDR	(VF610_AIPS0_BASE_ADDR + 0x00011000)
#define VF610_TZASC_SYS1_BASE_ADDR	(VF610_AIPS0_BASE_ADDR + 0x00012000)
#define VF610_TZASC_GFX_BASE_ADDR	(VF610_AIPS0_BASE_ADDR + 0x00013000)
#define VF610_TZASC_DDR0_BASE_ADDR	(VF610_AIPS0_BASE_ADDR + 0x00014000)
#define VF610_TZASC_DDR1_BASE_ADDR	(VF610_AIPS0_BASE_ADDR + 0x00015000)
#define VF610_CSU_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00017000)
#define VF610_DMA0_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00018000)
#define VF610_DMA0_TCD_BASE_ADDR	(VF610_AIPS0_BASE_ADDR + 0x00019000)
#define VF610_SEMA4_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0001D000)
#define VF610_FB_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0001E000)
#define VF610_DMA_MUX0_BASE_ADDR	(VF610_AIPS0_BASE_ADDR + 0x00024000)
#define VF610_UART1_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00027000)
#define VF610_UART2_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00028000)
#define VF610_UART3_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00029000)
#define VF610_UART4_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0002A000)
#define VF610_SPI0_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0002C000)
#define VF610_SPI1_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0002D000)
#define VF610_SAI0_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0002F000)
#define VF610_SAI1_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00030000)
#define VF610_SAI2_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00031000)
#define VF610_SAI3_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00032000)
#define VF610_CRC_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00033000)
#define VF610_USBC0_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00034000)
#define VF610_PDB_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00036000)
#define VF610_PIT_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00037000)
#define VF610_FTM0_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00038000)
#define VF610_FTM1_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00039000)
#define VF610_ADC_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0003B000)
#define VF610_TCON0_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0003D000)
#define VF610_WDOG1_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0003E000)
#define VF610_LPTMR_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00040000)
#define VF610_RLE_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00042000)
#define VF610_MLB_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00043000)
#define VF610_QSPI0_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00044000)
#define VF610_IOMUXC_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00048000)
#define VF610_ANADIG_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00050000)
#define VF610_USB_PHY0_BASE_ADDR	(VF610_AIPS0_BASE_ADDR + 0x00050800)
#define VF610_USB_PHY1_BASE_ADDR	(VF610_AIPS0_BASE_ADDR + 0x00050C00)
#define VF610_SCSC_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00052000)
#define VF610_ASRC_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00060000)
#define VF610_SPDIF_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00061000)
#define VF610_ESAI_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00062000)
#define VF610_ESAI_FIFO_BASE_ADDR	(VF610_AIPS0_BASE_ADDR + 0x00063000)
#define VF610_WDOG_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00065000)
#define VF610_I2C1_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00066000)
#define VF610_I2C2_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x00067000)
#define VF610_I2C3_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x000E6000)
#define VF610_I2C4_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x000E7000)
#define VF610_WKUP_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0006A000)
#define VF610_CCM_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0006B000)
#define VF610_GPC_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0006C000)
#define VF610_VREG_DIG_BASE_ADDR	(VF610_AIPS0_BASE_ADDR + 0x0006D000)
#define VF610_SRC_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0006E000)
#define VF610_CMU_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x0006F000)
#define VF610_GPIO0_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x000FF000)
#define VF610_GPIO1_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x000FF040)
#define VF610_GPIO2_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x000FF080)
#define VF610_GPIO3_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x000FF0C0)
#define VF610_GPIO4_BASE_ADDR		(VF610_AIPS0_BASE_ADDR + 0x000FF100)

/* AIPS 1 */
#define VF610_OCOTP_BASE_ADDR		(VF610_AIPS1_BASE_ADDR + 0x00025000)
#define VF610_DDR_BASE_ADDR		(VF610_AIPS1_BASE_ADDR + 0x0002E000)
#define VF610_ESDHC0_BASE_ADDR		(VF610_AIPS1_BASE_ADDR + 0x00031000)
#define VF610_ESDHC1_BASE_ADDR		(VF610_AIPS1_BASE_ADDR + 0x00032000)
#define VF610_USBC1_BASE_ADDR		(VF610_AIPS1_BASE_ADDR + 0x00034000)
#define VF610_ENET_BASE_ADDR		(VF610_AIPS1_BASE_ADDR + 0x00050000)
#define VF610_ENET1_BASE_ADDR		(VF610_AIPS1_BASE_ADDR + 0x00051000)
#define VF610_NFC_BASE_ADDR		(VF610_AIPS1_BASE_ADDR + 0x00060000)

#define VF610_QSPI0_AMBA_BASE		0x20000000


/* MSCM interrupt rounter */
#define VF610_MSCM_IRSPRC(n)		(0x880 + 2 * (n))
#define VF610_MSCM_CPxTYPE		0
#define VF610_MSCM_IRSPRC_CP0_EN	1
#define VF610_MSCM_IRSPRC_NUM		112

#define VF610_MSCM_CPxCOUNT		0x00c
#define VF610_MSCM_CPxCFG1		0x014

#endif
