/*
 * Copyright (C) 2011 Alexander Aring <a.aring@phytec.de>
 *
 * This file is released under the GPLv2
 *
 */

#ifndef __MFD_TWL6030_H__
#define __MFD_TWL6030_H__

#include <mfd/twl-core.h>

/* VMMC_CFG_VOLTAGE */
#define TWL6030_VMMC_VSEL_0			(1 << 0)
#define TWL6030_VMMC_VSEL_1			(1 << 1)
#define TWL6030_VMMC_VSEL_2			(1 << 2)
#define TWL6030_VMMC_VSEL_3			(1 << 3)
#define TWL6030_VMMC_VSEL_4			(1 << 4)
#define TWL6030_VMMC_WR_S			(1 << 7)

/* VMMC_CFG_STATE (W) */
#define TWL6030_VMMC_STATE0			(1 << 0)
#define TWL6030_VMMC_STATE1			(1 << 1)
#define TWL6030_VMMC_GRP_APP			(1 << 5)
#define TWL6030_VMMC_GRP_CON			(1 << 6)
#define TWL6030_VMMC_GRP_MOD			(1 << 7)

enum twl6030_reg {
	/* RTC */
	TWL6030_RTC_SECONDS			= 0x0000,
	TWL6030_RTC_MINUTES			= 0x0001,
	TWL6030_RTC_HOURS			= 0x0002,
	TWL6030_RTC_DAYS			= 0x0003,
	TWL6030_RTC_MONTHS			= 0x0004,
	TWL6030_RTC_YEARS			= 0x0005,
	TWL6030_RTC_WEEKS			= 0x0006,
	TWL6030_RTC_ALARM_SECONDS			= 0x0008,
	TWL6030_RTC_ALARM_MINUTES			= 0x0009,
	TWL6030_RTC_ALARM_HOURS			= 0x000A,
	TWL6030_RTC_ALARM_DAYS			= 0x000B,
	TWL6030_RTC_ALARM_MONTHS			= 0x000C,
	TWL6030_RTC_ALARM_YEARS			= 0x000D,
	TWL6030_RTC_CTRL			= 0x0010,
	TWL6030_RTC_STATUS			= 0x0011,
	TWL6030_RTC_INTERRUPTS			= 0x0012,
	TWL6030_RTC_COMP_LSB			= 0x0013,
	TWL6030_RTC_COMP_MSB			= 0x0014,
	TWL6030_RTC_RESET_STATUS			= 0x0016,
	/* MEM */
	TWL6030_MEM_VALIDITY0		= 0x0017,
	TWL6030_MEM_VALIDITY1		= 0x0018,
	TWL6030_MEM_VALIDITY2		= 0x0019,
	TWL6030_MEM_VALIDITY3		= 0x001A,
	TWL6030_MEM_VALIDITY4		= 0x001B,
	TWL6030_MEM_VALIDITY5		= 0x001C,
	TWL6030_MEM_VALIDITY6		= 0x001D,
	TWL6030_MEM_VALIDITY7		= 0x001E,
	/* PMC Master */
	TWL6030_PMCM_START			= 0x001F,
	TWL6030_PMCM_MSK			= 0x0020,
	TWL6030_PMCM_HW				= 0x0021,
	TWL6030_PMCM_TURNOFF			= 0x0022,
	TWL6030_PMCM_VBAT_THRESHOLD_LO	= 0x0023,
	TWL6030_PMCM_VBAT_THRESHOLD_HI	= 0x0024,
	TWL6030_PMCM_DEV_ON			= 0x0025,
	TWL6030_PMCM_PWR_GRP_STATE	= 0x0027,
	TWL6030_PMCM_CFG_VBATLOWV	= 0x0028,
	TWL6030_PMCM_STS_BOOT		= 0x0029,
	TWL6030_PMCM_SENS_TRANSITION	= 0x002A,
	TWL6030_PMCM_SEQ_CFG			= 0x002B,
	TWL6030_PMCM_PRIMARY_WATCHDOG_CFG	= 0x002C,
	TWL6030_PMCM_KEY_PRESS_DURATION_CFG	= 0x002D,
	/* PMC Slave MISC */
	TWL6030_PMCS_ADDRESS_ALL		= 0x0031,
	TWL6030_PMCS_ADDRESS_REF		= 0x0032,
	TWL6030_PMCS_ADDRESS_PROV		= 0x0033,
	TWL6030_PMCS_ADDRESS_CLK_RST	= 0x0034,
	/* PMC Slave SMPS */
	TWL6030_PMCS_V1V29_CFG_GRP	= 0x0040,
	TWL6030_PMCS_V1V29_CFG_TRANS	= 0x0041,
	TWL6030_PMCS_V1V29_CFG_STATE	= 0x0042,
	TWL6030_PMCS_V1V29_CFG_VOLTAGE	= 0x0044,
	TWL6030_PMCS_V1V8_CFG_GRP	= 0x0046,
	TWL6030_PMCS_V1V8_CFG_TRANS	= 0x0047,
	TWL6030_PMCS_V1V8_CFG_STATE		= 0x0048,
	TWL6030_PMCS_V1V8_CFG_VOLTAGE	= 0x004A,
	TWL6030_PMCS_V2V1_CFG_GRP	= 0x004C,
	TWL6030_PMCS_V2V1_CFG_TRANS	= 0x004D,
	TWL6030_PMCS_V2V1_CFG_STATE		= 0x004E,
	TWL6030_PMCS_V2V1_CFG_VOLTAGE	= 0x0050,
	TWL6030_PMCS_VCORE1_CFG_GRP	= 0x0052,
	TWL6030_PMCS_VCORE1_CFG_TRANS	= 0x0053,
	TWL6030_PMCS_VCORE1_CFG_STATE	= 0x0054,
	TWL6030_PMCS_VCORE1_CFG_STEP	= 0x0057,
	TWL6030_PMCS_VCORE2_CFG_GRP	= 0x0058,
	TWL6030_PMCS_VCORE2_CFG_TRANS	= 0x0059,
	TWL6030_PMCS_VCORE2_CFG_STATE	= 0x005A,
	TWL6030_PMCS_VCORE2_CFG_STEP	= 0x005D,
	TWL6030_PMCS_VCORE3_CFG_GRP	= 0x005E,
	TWL6030_PMCS_VCORE3_CFG_TRANS	= 0x005F,
	TWL6030_PMCS_VCORE3_CFG_STATE	= 0x0060,
	TWL6030_PMCS_VCORE3_CFG_STEP	= 0x0063,
	TWL6030_PMCS_VMEM_CFG_GRP	= 0x0064,
	TWL6030_PMCS_VMEM_CFG_TRANS	= 0x0065,
	TWL6030_PMCS_VMEM_CFG_STATE		= 0x0066,
	TWL6030_PMCS_VMEM_CFG_VOLTAGE	= 0x0068,
	/* PMC Slave LDO */
	TWL6030_PMCS_VANA_CFG_GRP	= 0x0080,
	TWL6030_PMCS_VANA_CFG_TRANS	= 0x0081,
	TWL6030_PMCS_VANA_CFG_STATE		= 0x0082,
	TWL6030_PMCS_VANA_CFG_VOLTAGE	= 0x0083,
	TWL6030_PMCS_VAUX1_CFG_GRP	= 0x0084,
	TWL6030_PMCS_VAUX1_CFG_TRANS	= 0x0085,
	TWL6030_PMCS_VAUX1_CFG_STATE	= 0x0086,
	TWL6030_PMCS_VAUX1_CFG_VOLTAGE	= 0x0087,
	TWL6030_PMCS_VAUX2_CFG_GRP	= 0x0088,
	TWL6030_PMCS_VAUX2_CFG_TRANS	= 0x0089,
	TWL6030_PMCS_VAUX2_CFG_STATE	= 0x008A,
	TWL6030_PMCS_VAUX2_CFG_VOLTAGE	= 0x008B,
	TWL6030_PMCS_VAUX3_CFG_GRP	= 0x008C,
	TWL6030_PMCS_VAUX3_CFG_TRANS	= 0x008D,
	TWL6030_PMCS_VAUX3_CFG_STATE	= 0x008E,
	TWL6030_PMCS_VAUX3_CFG_VOLTAGE	= 0x008F,
	TWL6030_PMCS_VCXIO_CFG_GRP	= 0x0090,
	TWL6030_PMCS_VCXIO_CFG_TRANS	= 0x0091,
	TWL6030_PMCS_VCXIO_CFG_STATE	= 0x0092,
	TWL6030_PMCS_VCXIO_CFG_VOLTAGE	= 0x0093,
	TWL6030_PMCS_VDAC_CFG_GRP	= 0x0094,
	TWL6030_PMCS_VDAC_CFG_TRANS	= 0x0095,
	TWL6030_PMCS_VDAC_CFG_STATE	= 0x0096,
	TWL6030_PMCS_VDAC_CFG_VOLTAGE	= 0x0097,
	TWL6030_PMCS_VMMC_CFG_GRP	= 0x0098,
	TWL6030_PMCS_VMMC_CFG_TRANS	= 0x0099,
	TWL6030_PMCS_VMMC_CFG_STATE	= 0x009A,
	TWL6030_PMCS_VMMC_CFG_VOLTAGE	= 0x009B,
	TWL6030_PMCS_VPP_CFG_GRP	= 0x009C,
	TWL6030_PMCS_VPP_CFG_TRANS	= 0x009D,
	TWL6030_PMCS_VPP_CFG_STATE	= 0x009E,
	TWL6030_PMCS_VPP_CFG_VOLTAGE	= 0x009F,
	TWL6030_PMCS_VUSB_CFG_GRP	= 0x00A0,
	TWL6030_PMCS_VUSB_CFG_TRANS	= 0x00A1,
	TWL6030_PMCS_VUSB_CFG_STATE	= 0x00A2,
	TWL6030_PMCS_VUSB_CFG_VOLTAGE	= 0x00A3,
	TWL6030_PMCS_VUSIM_CFG_GRP	= 0x00A4,
	TWL6030_PMCS_VUSIM_CFG_TRANS	= 0x00A5,
	TWL6030_PMCS_VUSIM_CFG_STATE	= 0x00A6,
	TWL6030_PMCS_VUSIM_CFG_VOLTAGE	= 0x00A7,
	/* Resource Register Map */
	TWL6030_PMCS_REGEN1_CFG_GRP	= 0x00AD,
	TWL6030_PMCS_REGEN1_CFG_TRANS	= 0x00AE,
	TWL6030_PMCS_REGEN1_CFG_STATE	= 0x00AF,
	TWL6030_PMCS_REGEN2_CFG_GRP	= 0x00B0,
	TWL6030_PMCS_REGEN2_CFG_TRANS	= 0x00B1,
	TWL6030_PMCS_REGEN2_CFG_STATE	= 0x00B2,
	TWL6030_PMCS_SYSEN_CFG_GRP	= 0x00B3,
	TWL6030_PMCS_SYSEN_CFG_TRANS	= 0x00B4,
	TWL6030_PMCS_SYSEN_CFG_STATE	= 0x00B5,
	TWL6030_PMCS_NRESPWRON_CFG_GRP	= 0x00B6,
	TWL6030_PMCS_NRESPWRON_CFG_TRANS	= 0x00B7,
	TWL6030_PMCS_NRESPWRON_CFG_STATE	= 0x00B8,
	TWL6030_PMCS_CLK32KAO_CFG_GRP	= 0x00B9,
	TWL6030_PMCS_CLK32KAO_CFG_TRANS	= 0x00BA,
	TWL6030_PMCS_CLK32KAO_CFG_STATE		= 0x00BB,
	TWL6030_PMCS_CLK32KG_CFG_GRP	= 0x00BC,
	TWL6030_PMCS_CLK32KG_CFG_TRANS	= 0x00BD,
	TWL6030_PMCS_CLK32KG_CFG_STATE		= 0x00BE,
	TWL6030_PMCS_CLK32KAUDIO_CFG_GRP	= 0x00BF,
	TWL6030_PMCS_CLK32KAUDIO_CFG_TRANS	= 0x00C0,
	TWL6030_PMCS_CLK32KAUDIO_CFG_STATE	= 0x00C1,
	TWL6030_PMCS_VRTC_CFG_GRP	= 0x00C2,
	TWL6030_PMCS_VRTC_CFG_TRANS	= 0x00C3,
	TWL6030_PMCS_VRTC_CFG_STATE	= 0x00C4,
	TWL6030_PMCS_BIAS_CFG_GRP	= 0x00C5,
	TWL6030_PMCS_BIAS_CFG_TRANS	= 0x00C6,
	TWL6030_PMCS_BIAS_CFG_STATE	= 0x00C7,
	TWL6030_PMCS_VBATMIN_CFG_GRP	= 0x00C8,
	TWL6030_PMCS_VBATMIN_CFG_TRANS	= 0x00C9,
	TWL6030_PMCS_VBATMIN_CFG_STATE	= 0x00CA,
	TWL6030_PMCS_RC6MHZ_CFG_GRP	= 0x00CB,
	TWL6030_PMCS_RC6MHZ_CFG_TRANS	= 0x00CC,
	TWL6030_PMCS_RC6MHZ_CFG_STATE	= 0x00CD,
	TWL6030_PMCS_TMP_CFG_GRP	= 0x00CE,
	TWL6030_PMCS_TMP_CFG_TRANS	= 0x00CF,
	TWL6030_PMCS_TMP_CFG_STATE	= 0x00D0,
	/* Misc Register */
	TWL6030_PMC_SMPS_OFFSET	= 0x00E0,
	TWL6030_PMC_SMPS_MULT	= 0x00E3,
	TWL6030_PMC_SMPS_MISC1	= 0x00E4,
	TWL6030_PMC_SMPS_MISC2	= 0x00E5,
	TWL6030_PMC_SMPS_BBSPOR_CFG	= 0x00E6,
	TWL6030_PMC_SMPS_TMP_CFG	= 0x00E7,
	TWL6030_PMC_SMPS_FORCE_SMPS_CLK	= 0x00E8,
	TWL6030_PMC_SMPS_SIMDEBOUNCING	= 0x00EB,
	TWL6030_PMC_SMPS_SIMCTRL	= 0x00EC,
	TWL6030_PMC_SMPS_MMCDEBOUNCING	= 0x00ED,
	TWL6030_PMC_SMPS_MMCCTRL	= 0x00EE,
	TWL6030_PMC_SMPS_BATDEBOUNCING	= 0x00EF,
	/* Pull-up | Pull-down | High-Z */
	TWL6030_PMC_CFG_INPUT_PUPD1	= 0x00F0,
	TWL6030_PMC_CFG_INPUT_PUPD2	= 0x00F1,
	TWL6030_PMC_CFG_INPUT_PUPD3	= 0x00F2,
	TWL6030_PMC_CFG_INPUT_PUPD4	= 0x00F3,
	TWL6030_PMC_CFG_LDO_PD1	= 0x00F4,
	TWL6030_PMC_CFG_LDO_PD2	= 0x00F5,
	TWL6030_PMC_CFG_SMPS_PD	= 0x00F6,
	/* OTG Backup */
	TWL6030_OTG_BACKUP_REG	= 0x00FA,
	/* USB OTG */
	TWL6030_OTG_USB_VENDORID_LO	= 0x0100,
	TWL6030_OTG_USB_VENDORID_HI	= 0x0101,
	TWL6030_OTG_USB_PRODUCTID_LO	= 0x0102,
	TWL6030_OTG_USB_PRODUCTID_HI	= 0x0103,
	TWL6030_OTG_USB_VBUS_CTRL_SET	= 0x0104,
	TWL6030_OTG_USB_VBUS_CTRL_CLR	= 0x0105,
	TWL6030_OTG_USB_ID_CTRL_SET	= 0x0106,
	TWL6030_OTG_USB_ID_CTRL_CLR	= 0x0107,
	TWL6030_OTG_USB_VBUS_INT_SRC	= 0x0108,
	TWL6030_OTG_USB_VBUS_INT_LATCH_SET	= 0x0109,
	TWL6030_OTG_USB_VBUS_INT_LATCH_CLR	= 0x010A,
	TWL6030_OTG_USB_VBUS_INT_EN_LO_SET	= 0x010B,
	TWL6030_OTG_USB_VBUS_INT_EN_LO_CLR	= 0x010C,
	TWL6030_OTG_USB_VBUS_INT_EN_HI_SET	= 0x010D,
	TWL6030_OTG_USB_VBUS_INT_EN_HI_CLR	= 0x010E,
	TWL6030_OTG_USB_ID_INT_SRC	= 0x010F,
	TWL6030_OTG_USB_ID_INT_LATCH_SET	= 0x0110,
	TWL6030_OTG_USB_ID_INT_LATCH_CLR	= 0x0111,
	TWL6030_OTG_USB_ID_INT_EN_LO_SET	= 0x0112,
	TWL6030_OTG_USB_ID_INT_EN_LO_CLR	= 0x0113,
	TWL6030_OTG_USB_ID_INT_EN_HI_SET	= 0x0114,
	TWL6030_OTG_USB_ID_INT_EN_HI_CLR	= 0x0115,
	TWL6030_OTG_USB_ADP_CTRL	= 0x0116,
	TWL6030_OTG_USB_ADP_HIGH	= 0x0117,
	TWL6030_OTG_USB_ADP_LOW	= 0x0118,
	TWL6030_OTG_USB_ADP_RISE	= 0x0119,
	/* GPADC Control */
	TWL6030_GPADC_CTRL	= 0x012E,
	TWL6030_GPADC_RTSELECT_LSB	= 0x0130,
	TWL6030_GPADC_RTSELECT_ISB	= 0x0131,
	TWL6030_GPADC_RTSELECT_MSB	= 0x0132,
	TWL6030_GPADC_CTRL_P1	= 0x0133,
	TWL6030_GPADC_CTRL_P2	= 0x0134,
	/* GPADC Real Time */
	TWL6030_GPADC_RTCH0_LO	= 0x0135,
	TWL6030_GPADC_RTCH0_HI	= 0x0136,
	TWL6030_GPADC_RTCH1_LO	= 0x0137,
	TWL6030_GPADC_RTCH1_HI	= 0x0138,
	TWL6030_GPADC_RTCH2_LO	= 0x0139,
	TWL6030_GPADC_RTCH2_HI	= 0x013A,
	TWL6030_GPADC_RTCH3_LO	= 0x013B,
	TWL6030_GPADC_RTCH3_HI	= 0x013C,
	TWL6030_GPADC_RTCH4_LO	= 0x013D,
	TWL6030_GPADC_RTCH4_HI	= 0x013E,
	TWL6030_GPADC_RTCH5_LO	= 0x013F,
	TWL6030_GPADC_RTCH5_HI	= 0x0140,
	TWL6030_GPADC_RTCH6_LO	= 0x0141,
	TWL6030_GPADC_RTCH6_HI	= 0x0142,
	TWL6030_GPADC_RTCH7_LO	= 0x0143,
	TWL6030_GPADC_RTCH7_HI	= 0x0144,
	TWL6030_GPADC_RTCH8_LO	= 0x0145,
	TWL6030_GPADC_RTCH8_HI	= 0x0146,
	TWL6030_GPADC_RTCH9_LO	= 0x0147,
	TWL6030_GPADC_RTCH9_HI	= 0x0148,
	TWL6030_GPADC_RTCH10_LO	= 0x0149,
	TWL6030_GPADC_RTCH10_HI	= 0x014A,
	TWL6030_GPADC_RTCH11_LO	= 0x014B,
	TWL6030_GPADC_RTCH11_HI	= 0x014C,
	TWL6030_GPADC_RTCH12_LO	= 0x014D,
	TWL6030_GPADC_RTCH12_HI	= 0x014E,
	TWL6030_GPADC_RTCH13_LO	= 0x014F,
	TWL6030_GPADC_RTCH13_HI	= 0x0150,
	TWL6030_GPADC_RTCH14_LO	= 0x0151,
	TWL6030_GPADC_RTCH14_HI	= 0x0152,
	TWL6030_GPADC_RTCH15_LO	= 0x0153,
	TWL6030_GPADC_RTCH15_HI	= 0x0154,
	TWL6030_GPADC_RTCH16_LO	= 0x0155,
	TWL6030_GPADC_RTCH16_HI	= 0x0156,
	/* GPADC General Purpose */
	TWL6030_GPADC_GPCH0_LO	= 0x0157,
	TWL6030_GPADC_GPCH0_HI	= 0x0158,
	TWL6030_GPADC_GPCH1_LO	= 0x0159,
	TWL6030_GPADC_GPCH1_HI	= 0x015A,
	TWL6030_GPADC_GPCH2_LO	= 0x015B,
	TWL6030_GPADC_GPCH2_HI	= 0x015C,
	TWL6030_GPADC_GPCH3_LO	= 0x015D,
	TWL6030_GPADC_GPCH3_HI	= 0x015E,
	TWL6030_GPADC_GPCH4_LO	= 0x015F,
	TWL6030_GPADC_GPCH4_HI	= 0x0160,
	TWL6030_GPADC_GPCH5_LO	= 0x0161,
	TWL6030_GPADC_GPCH5_HI	= 0x0162,
	TWL6030_GPADC_GPCH6_LO	= 0x0163,
	TWL6030_GPADC_GPCH6_HI	= 0x0164,
	TWL6030_GPADC_GPCH7_LO	= 0x0165,
	TWL6030_GPADC_GPCH7_HI	= 0x0166,
	TWL6030_GPADC_GPCH8_LO	= 0x0167,
	TWL6030_GPADC_GPCH8_HI	= 0x0168,
	TWL6030_GPADC_GPCH9_LO	= 0x0169,
	TWL6030_GPADC_GPCH9_HI	= 0x016A,
	TWL6030_GPADC_GPCH10_LO	= 0x016B,
	TWL6030_GPADC_GPCH10_HI	= 0x016C,
	TWL6030_GPADC_GPCH11_LO	= 0x016D,
	TWL6030_GPADC_GPCH11_HI	= 0x016E,
	TWL6030_GPADC_GPCH12_LO	= 0x016F,
	TWL6030_GPADC_GPCH12_HI	= 0x0170,
	TWL6030_GPADC_GPCH13_LO	= 0x0171,
	TWL6030_GPADC_GPCH13_HI	= 0x0172,
	TWL6030_GPADC_GPCH14_LO	= 0x0173,
	TWL6030_GPADC_GPCH14_HI	= 0x0174,
	TWL6030_GPADC_GPCH15_LO	= 0x0175,
	TWL6030_GPADC_GPCH15_HI	= 0x0176,
	TWL6030_GPADC_GPCH16_LO	= 0x0177,
	TWL6030_GPADC_GPCH16_HI	= 0x0178,
	/* Auxiliaries Register */
	TWL6030_AUX_TOGGLE1 = 0x0190,
	TWL6030_AUX_TOGGLE2 = 0x0191,
	TWL6030_AUX_TOGGLE3 = 0x0192,
	TWL6030_AUX_PWDNSTATUS1 = 0x0193,
	TWL6030_AUX_PWDNSTATUS2 = 0x0194,
	TWL6030_AUX_VIBCTRL = 0x019B,
	TWL6030_AUX_VIBMODE = 0x019C,
	/* PWM Register */
	TWL6030_PWM_PWM1ON = 0x019C,
	TWL6030_PWM_PWM1OFF = 0x019C,
	TWL6030_PWM_PWM2ON = 0x019C,
	TWL6030_PWM_PWM2OFF = 0x019C,
	/* Gas Gauge Register */
	TWL6030_FG_REG_00 = 0x01C0,
	TWL6030_FG_REG_01 = 0x01C1,
	TWL6030_FG_REG_02 = 0x01C2,
	TWL6030_FG_REG_03 = 0x01C3,
	TWL6030_FG_REG_04 = 0x01C4,
	TWL6030_FG_REG_05 = 0x01C5,
	TWL6030_FG_REG_06 = 0x01C6,
	TWL6030_FG_REG_07 = 0x01C7,
	TWL6030_FG_REG_08 = 0x01C8,
	TWL6030_FG_REG_09 = 0x01C9,
	TWL6030_FG_REG_10 = 0x01CA,
	TWL6030_FG_REG_11 = 0x01CB,
	/* Interfaces Interrupts */
	TWL6030_INT_STS_A = 0x01D0,
	TWL6030_INT_STS_B = 0x01D1,
	TWL6030_INT_STS_C = 0x01D2,
	TWL6030_INT_MSK_LINE_A = 0x01D3,
	TWL6030_INT_MSK_LINE_B = 0x01D4,
	TWL6030_INT_MSK_LINE_C = 0x01D5,
	TWL6030_INT_MSK_STS_A = 0x01D6,
	TWL6030_INT_MSK_STS_B = 0x01D7,
	TWL6030_INT_MSK_STS_C = 0x01D8,
	/* Charger Regisers */
	TWL6030_CHR_CONTROLLER_INT_MASK = 0x01E0,
	TWL6030_CHR_CONTROLLER_CTRL1 = 0x01E1,
	TWL6030_CHR_CONTROLLER_WDG = 0x01E2,
	TWL6030_CHR_CONTROLLER_STAT1 = 0x01E3,
	TWL6030_CHR_CHARGERUSB_INT_STATUS = 0x01E4,
	TWL6030_CHR_CHARGERUSB_INT_MASK = 0x01E5,
	TWL6030_CHR_CHARGERUSB_STATUS_INT1 = 0x01E6,
	TWL6030_CHR_CHARGERUSB_STATUS_INT2 = 0x01E7,
	TWL6030_CHR_CHARGERUSB_CTRL1 = 0x01E8,
	TWL6030_CHR_CHARGERUSB_CTRL2 = 0x01E9,
	TWL6030_CHR_CHARGERUSB_CTRL3 = 0x01EA,
	TWL6030_CHR_CHARGERUSB_STAT1 = 0x01EB,
	TWL6030_CHR_CHARGERUSB_VOREG = 0x01EC,
	TWL6030_CHR_CHARGERUSB_VICHRG = 0x01ED,
	TWL6030_CHR_CHARGERUSB_CINLIMIT = 0x01EE,
	TWL6030_CHR_CHARGERUSB_CTRLLIMIT1 = 0x01EF,
	TWL6030_CHR_CHARGERUSB_CTRLLIMIT2 = 0x01F0,
	TWL6030_CHR_ANTICOLLAPSE_CTRL1 = 0x01F1,
	TWL6030_CHR_ANTICOLLAPSE_CTRL2 = 0x01F2,
	TWL6030_CHR_ANTICOLLAPSE_STAT1 = 0x01F3,
	TWL6030_CHR_LED_PWM_CTRL1 = 0x01F4,
	TWL6030_CHR_LED_PWM_CTRL2 = 0x01F5,
	/* JTAG */
	TWL6030_JTAG_JTAGVERNUM = 0x0287,
	TWL6030_JTAG_EPROM_REV = 0x02DF,
	TWL6030_DIEID_0 = 0x02C0,
	TWL6030_DIEID_1 = 0x02C1,
	TWL6030_DIEID_2 = 0x02C2,
	TWL6030_DIEID_3 = 0x02C3,
	TWL6030_DIEID_4 = 0x02C4,
	TWL6030_DIEID_5 = 0x02C5,
	TWL6030_DIEID_6 = 0x02C6,
	TWL6030_DIEID_7 = 0x02C7,
	/* GPADC Trimming */
	TWL6030_GPADC_TRIM1 = 0x02CD,
	TWL6030_GPADC_TRIM2 = 0x02CE,
	TWL6030_GPADC_TRIM3 = 0x02CF,
	TWL6030_GPADC_TRIM4 = 0x02D0,
	TWL6030_GPADC_TRIM5 = 0x02D1,
	TWL6030_GPADC_TRIM6 = 0x02D2,
	TWL6030_GPADC_TRIM7 = 0x02D3,
	TWL6030_GPADC_TRIM8 = 0x02D4,
	TWL6030_GPADC_TRIM9 = 0x02D5,
	TWL6030_GPADC_TRIM10 = 0x02D6,
	TWL6030_GPADC_TRIM11 = 0x02D7,
	TWL6030_GPADC_TRIM12 = 0x02D8,
	TWL6030_GPADC_TRIM13 = 0x02D9,
	TWL6030_GPADC_TRIM14 = 0x02DA,
	TWL6030_GPADC_TRIM15 = 0x02DB,
	TWL6030_GPADC_TRIM16 = 0x02DC,
	TWL6030_GPADC_TRIM17 = 0x02DD,
	TWL6030_GPADC_TRIM18 = 0x02DE,
};

struct twl6030 {
	struct twlcore core;
};

extern struct twl6030 *twl6030_get(void);

static inline int twl6030_reg_read(struct twl6030 *twl6030,
		enum twl6030_reg reg, u8 *val)
{
	return twlcore_reg_read(&twl6030->core, reg, val);
}

static inline int twl6030_reg_write(struct twl6030 *twl6030,
		enum twl6030_reg reg, u8 val)
{
	return twlcore_reg_write(&twl6030->core, reg, val);
}

static inline int twl6030_set_bits(struct twl6030 *twl6030,
		enum twl6030_reg reg, u8 mask, u8 val)
{
	return twlcore_set_bits(&twl6030->core, reg, mask, val);
}

#endif /* __MFD_TWL6030_H__ */
