/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __MACH_IMX_OCOTP_FUSEMAP_H
#define __MACH_IMX_OCOTP_FUSEMAP_H

#include <mach/imx/ocotp.h>

#define OCOTP_TESTER_LOCK		(OCOTP_WORD(0x400) | OCOTP_BIT(0) | OCOTP_WIDTH(2))
#define OCOTP_BOOT_CFG_LOCK		(OCOTP_WORD(0x400) | OCOTP_BIT(2) | OCOTP_WIDTH(2))
#define OCOTP_MEM_TRIM_LOCK		(OCOTP_WORD(0x400) | OCOTP_BIT(4) | OCOTP_WIDTH(2))
#define OCOTP_SJC_RESP_LOCK		(OCOTP_WORD(0x400) | OCOTP_BIT(6) | OCOTP_WIDTH(1))
#define OCOTP_MAC_ADDR_LOCK		(OCOTP_WORD(0x400) | OCOTP_BIT(8) | OCOTP_WIDTH(2))
#define OCOTP_GP1_LOCK			(OCOTP_WORD(0x400) | OCOTP_BIT(10) | OCOTP_WIDTH(2))
#define OCOTP_GP2_LOCK			(OCOTP_WORD(0x400) | OCOTP_BIT(12) | OCOTP_WIDTH(2))

/* available on i.MX8 */
#define MX8M_OCOTP_GP1_LOCK		(OCOTP_WORD(0x400) | OCOTP_BIT(20) | OCOTP_WIDTH(2))
#define MX8M_OCOTP_GP2_LOCK		(OCOTP_WORD(0x400) | OCOTP_BIT(22) | OCOTP_WIDTH(2))
#define MX8M_OCOTP_GP5_LOCK		(OCOTP_WORD(0x400) | OCOTP_BIT(24) | OCOTP_WIDTH(2))
#define MX8M_OCOTP_GP1_0		(OCOTP_WORD(0x780) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8M_OCOTP_GP1_1		(OCOTP_WORD(0x790) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8M_OCOTP_GP2_0		(OCOTP_WORD(0x7A0) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8M_OCOTP_GP2_1		(OCOTP_WORD(0x7B0) | OCOTP_BIT(0) | OCOTP_WIDTH(32))

/* available on i.MX8MP */
#define MX8MP_OCOTP_GP1_LOCK	MX8M_OCOTP_GP1_LOCK
#define MX8MP_OCOTP_GP2_LOCK	MX8M_OCOTP_GP2_LOCK
#define MX8MP_OCOTP_GP4_LOCK	(OCOTP_WORD(0x410) | OCOTP_BIT(4)  | OCOTP_WIDTH(2))
#define MX8MP_OCOTP_GP5_LOCK	(OCOTP_WORD(0x410) | OCOTP_BIT(8)  | OCOTP_WIDTH(2))
#define MX8MP_OCOTP_GP6_LOCK	(OCOTP_WORD(0x410) | OCOTP_BIT(10) | OCOTP_WIDTH(2))
#define MX8MP_OCOTP_GP7_LOCK	(OCOTP_WORD(0x410) | OCOTP_BIT(12) | OCOTP_WIDTH(2))
#define MX8MP_OCOTP_GP8_LOCK	(OCOTP_WORD(0x410) | OCOTP_BIT(14) | OCOTP_WIDTH(2))
#define MX8MP_OCOTP_GP9_LOCK	(OCOTP_WORD(0x410) | OCOTP_BIT(16) | OCOTP_WIDTH(2))
#define MX8MP_OCOTP_GP6_0		(OCOTP_WORD(0xE40) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP6_1		(OCOTP_WORD(0xE50) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP6_2		(OCOTP_WORD(0xE60) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP6_3		(OCOTP_WORD(0xE70) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP7_0		(OCOTP_WORD(0xE80) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP7_1		(OCOTP_WORD(0xE90) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP7_2		(OCOTP_WORD(0xEA0) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP7_3		(OCOTP_WORD(0xEB0) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP8_0		(OCOTP_WORD(0xEC0) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP8_1		(OCOTP_WORD(0xED0) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP8_2		(OCOTP_WORD(0xEE0) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP8_3		(OCOTP_WORD(0xEF0) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP9_0		(OCOTP_WORD(0xF00) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP9_1		(OCOTP_WORD(0xF30) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP9_2		(OCOTP_WORD(0xF40) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8MP_OCOTP_GP9_3		(OCOTP_WORD(0xF50) | OCOTP_BIT(0) | OCOTP_WIDTH(32))

#define OCOTP_SRK_LOCK			(OCOTP_WORD(0x400) | OCOTP_BIT(14) | OCOTP_WIDTH(1))
#define OCOTP_ANALOG_LOCK		(OCOTP_WORD(0x400) | OCOTP_BIT(18) | OCOTP_WIDTH(2))
#define OCOTP_MISC_CONF_LOCK		(OCOTP_WORD(0x400) | OCOTP_BIT(22) | OCOTP_WIDTH(1))

/* 0 <= n <= 1 */
#define OCOTP_UNIQUE_ID(n)		(OCOTP_WORD(0x410 + 0x10 * (n)) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define OCOTP_NUM_CORES			(OCOTP_WORD(0x430) | OCOTP_BIT(20) | OCOTP_WIDTH(2))
#define OCOTP_MLB_DISABLE		(OCOTP_WORD(0x430) | OCOTP_BIT(26) | OCOTP_WIDTH(1))

#define OCOTP_BOOT_CFG1			(OCOTP_WORD(0x450) | OCOTP_BIT(0) | OCOTP_WIDTH(8))
#define OCOTP_BOOT_CFG2			(OCOTP_WORD(0x450) | OCOTP_BIT(8) | OCOTP_WIDTH(8))
#define OCOTP_BOOT_CFG3			(OCOTP_WORD(0x450) | OCOTP_BIT(16) | OCOTP_WIDTH(8))
#define OCOTP_BOOT_CFG4			(OCOTP_WORD(0x450) | OCOTP_BIT(24) | OCOTP_WIDTH(8))
/* available on i.MX6SDL silicon revision >=1.4, "reserved" elsewhere */
#define OCOTP_SDP_DISABLE		(OCOTP_WORD(0x460) | OCOTP_BIT(0) | OCOTP_WIDTH(1))
#define OCOTP_SEC_CONFIG_1		(OCOTP_WORD(0x460) | OCOTP_BIT(1) | OCOTP_WIDTH(1))
/* available on i.MX6SDL silicon revision >=1.4, "reserved" elsewhere */
#define OCOTP_SDP_READ_DISABLE		(OCOTP_WORD(0x460) | OCOTP_BIT(2) | OCOTP_WIDTH(1))
#define OCOTP_DIR_BT_DIS		(OCOTP_WORD(0x460) | OCOTP_BIT(3) | OCOTP_WIDTH(1))
#define OCOTP_BT_FUSE_SEL		(OCOTP_WORD(0x460) | OCOTP_BIT(4) | OCOTP_WIDTH(1))
#define OCOTP_SJC_DISABLE		(OCOTP_WORD(0x460) | OCOTP_BIT(20) | OCOTP_WIDTH(1))
#define OCOTP_WDOG_ENABLE		(OCOTP_WORD(0x460) | OCOTP_BIT(21) | OCOTP_WIDTH(1))
#define OCOTP_JTAG_SMODE		(OCOTP_WORD(0x460) | OCOTP_BIT(22) | OCOTP_WIDTH(2))
#define OCOTP_KTE			(OCOTP_WORD(0x460) | OCOTP_BIT(26) | OCOTP_WIDTH(1))
#define OCOTP_JTAG_HEO			(OCOTP_WORD(0x460) | OCOTP_BIT(27) | OCOTP_WIDTH(1))
/* available on i.MX6SDL silicon revision >=1.4, "reserved" elsewhere */
#define OCOTP_FORCE_INTERNAL_BOOT	(OCOTP_WORD(0x460) | OCOTP_BIT(31) | OCOTP_WIDTH(1))
#define OCOTP_NAND_READ_CMD_CODE1	(OCOTP_WORD(0x470) | OCOTP_BIT(0) | OCOTP_WIDTH(8))
#define OCOTP_NAND_READ_CMD_CODE2	(OCOTP_WORD(0x470) | OCOTP_BIT(8) | OCOTP_WIDTH(8))
#define OCOTP_TEMP_SENSE		(OCOTP_WORD(0x4e0) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define OCOTP_USB_VID			(OCOTP_WORD(0x4f0) | OCOTP_BIT(0) | OCOTP_WIDTH(16))
#define OCOTP_USB_PID			(OCOTP_WORD(0x4f0) | OCOTP_BIT(16) | OCOTP_WIDTH(16))
/* 0 <= n <= 7 */
#define OCOTP_SRK_HASH(n)		(OCOTP_WORD(0x580 + 0x10 * (n)) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define OCOTP_SJC_RESP_31_0		(OCOTP_WORD(0x600) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define OCOTP_SJC_RESP_55_32		(OCOTP_WORD(0x610) | OCOTP_BIT(0) | OCOTP_WIDTH(24))
#define OCOTP_MAC_ADDR_31_0		(OCOTP_WORD(0x620) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define OCOTP_MAC_ADDR_47_32		(OCOTP_WORD(0x630) | OCOTP_BIT(0) | OCOTP_WIDTH(16))
#define OCOTP_GP1			(OCOTP_WORD(0x660) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define OCOTP_GP2			(OCOTP_WORD(0x670) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define OCOTP_PAD_SETTINGS		(OCOTP_WORD(0x6d0) | OCOTP_BIT(0) | OCOTP_WIDTH(6))
/* i.MX8M moved the security related fuses */
#define MX8M_OCOTP_SRK_LOCK		(OCOTP_WORD(0x400) | OCOTP_BIT(9) | OCOTP_WIDTH(1))
#define MX8M_OCOTP_SJC_RESP_LOCK	(OCOTP_WORD(0x400) | OCOTP_BIT(10) | OCOTP_WIDTH(1))
#define MX8M_OCOTP_USB_ID_LOCK		(OCOTP_WORD(0x400) | OCOTP_BIT(12) | OCOTP_WIDTH(2))
#define MX8M_OCOTP_KTE			(OCOTP_WORD(0x470) | OCOTP_BIT(20) | OCOTP_WIDTH(1))
#define MX8M_OCOTP_SJC_DISABLE		(OCOTP_WORD(0x470) | OCOTP_BIT(21) | OCOTP_WIDTH(1))
#define MX8M_OCOTP_JTAG_SMODE		(OCOTP_WORD(0x470) | OCOTP_BIT(22) | OCOTP_WIDTH(2))
#define MX8M_OCOTP_SEC_CONFIG_1		(OCOTP_WORD(0x470) | OCOTP_BIT(25) | OCOTP_WIDTH(1))
#define MX8M_OCOTP_JTAG_HEO		(OCOTP_WORD(0x470) | OCOTP_BIT(26) | OCOTP_WIDTH(1))
#define MX8MQ_OCOTP_DIR_BT_DIS		(OCOTP_WORD(0x470) | OCOTP_BIT(27) | OCOTP_WIDTH(1))
#define MX8M_OCOTP_FORCE_COLD_BOOT	(OCOTP_WORD(0x470) | OCOTP_BIT(29) | OCOTP_WIDTH(1))
#define MX8M_OCOTP_TZASC_EN		(OCOTP_WORD(0x480) | OCOTP_BIT(11) | OCOTP_WIDTH(1))
#define MX8MP_OCOTP_ROM_NO_LOG		(OCOTP_WORD(0x480) | OCOTP_BIT(22) | OCOTP_WIDTH(1))
#define MX8M_OCOTP_RECOVERY_SDMMC_BOOT_DIS	(OCOTP_WORD(0x490) | OCOTP_BIT(23) | OCOTP_WIDTH(1))
#define MX8M_OCOTP_FIELD_RETURN		(OCOTP_WORD(0x630) | OCOTP_BIT(0) | OCOTP_WIDTH(1))
#define MX8MP_OCOTP_FIELD_RETURN	(OCOTP_WORD(0x630) | OCOTP_BIT(0) | OCOTP_WIDTH(32))
#define MX8M_OCOTP_SRK_REVOKE		(OCOTP_WORD(0x670) | OCOTP_BIT(0) | OCOTP_WIDTH(4))

#endif /* __MACH_IMX_OCOTP_FUSEMAP_H */
