/* SPDX-License-Identifier: GPL-2.0-only */

/* linux/arch/arm/mach-at91/clock.h */

#include <linux/clkdev.h>

#define CLK_TYPE_PRIMARY	0x1
#define CLK_TYPE_PLL		0x2
#define CLK_TYPE_PROGRAMMABLE	0x4
#define CLK_TYPE_PERIPHERAL	0x8
#define CLK_TYPE_SYSTEM		0x10
#define CLK_TYPE_PERIPH_H64MX   0x80

struct clk {
	struct list_head node;
	const char	*name;		/* unique clock name */
	struct clk_lookup cl;
	unsigned long	rate_hz;
	unsigned	div;		/* parent clock divider */
	struct clk	*parent;
	unsigned	pid;		/* peripheral ID */
	u32		pmc_mask;
	void		(*mode)(struct clk *, int);
	unsigned	id:3;		/* PCK0..4, or 32k/main/a/b */
	unsigned	type;		/* clock type */
	u16		users;
};


extern int __init clk_register(struct clk *clk);
extern struct clk mck;
extern struct clk utmi_clk;
