#include <soc/k3/ddr.h>

#include "ddr.h"

#define DDRSS_CTL_REG_INIT_COUNT (423U)
#define DDRSS_PHY_INDEP_REG_INIT_COUNT (345U)
#define DDRSS_PHY_REG_INIT_COUNT (1406U)

static uint32_t DDRSS_ctlReg[] = {
	0x00000a00, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x000890b8,
	0x00000000, 0x00000000, 0x00000000, 0x000890b8,
	0x00000000, 0x00000000, 0x00000000, 0x000890b8,
	0x00000000, 0x00000000, 0x00000000, 0x01010100,
	0x01000100, 0x01000110, 0x02010002, 0x00027100,
	0x00061a80, 0x04000400, 0x00000400, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x0400091c, 0x1c1c1c1c,
	0x0400091c, 0x1c1c1c1c, 0x0400091c, 0x1c1c1c1c,
	0x05050404, 0x00002706, 0x0602001d, 0x05001d0b,
	0x00270605, 0x0602001d, 0x05001d0b, 0x00270605,
	0x0602001d, 0x07001d0b, 0x00180807, 0x0400db60,
	0x07070009, 0x00001808, 0x0400db60, 0x07070009,
	0x00001808, 0x0400db60, 0x03000009, 0x0d0c0002,
	0x0d0c0d0c, 0x01010000, 0x03191919, 0x0b0b0b0b,
	0x00000b0b, 0x00000101, 0x00000000, 0x01000000,
	0x01180803, 0x00001860, 0x00000118, 0x00001860,
	0x00000118, 0x00001860, 0x00000005, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00090009,
	0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00010001, 0x00040001,
	0x04000120, 0x04000120, 0x01200120, 0x01200120,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x03010000, 0x00010000,
	0x00000000, 0x01000000, 0x80104002, 0x00040003,
	0x00040005, 0x00030000, 0x00050004, 0x00000004,
	0x00040003, 0x00040005, 0x00000000, 0x00061800,
	0x00061800, 0x00061800, 0x00061800, 0x00061800,
	0x00000000, 0x0000aaa0, 0x00061800, 0x00061800,
	0x00061800, 0x00061800, 0x00061800, 0x00000000,
	0x0000aaa0, 0x00061800, 0x00061800, 0x00061800,
	0x00061800, 0x00061800, 0x00000000, 0x0000aaa0,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x080c0000, 0x080c080c, 0x08000000, 0x00000808,
	0x000e0000, 0x00080808, 0x0e000000, 0x08080800,
	0x00000000, 0x0000080e, 0x00040003, 0x00000007,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x01000000, 0x00000000,
	0x00001500, 0x0000100e, 0x00000000, 0x00000000,
	0x00000001, 0x00000002, 0x00000c00, 0x00001000,
	0x00000c00, 0x00001000, 0x00000c00, 0x00001000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00042400, 0x00000301, 0x00000000, 0x00000424,
	0x00000301, 0x00000000, 0x00000424, 0x00000301,
	0x00000000, 0x00000424, 0x00000301, 0x00000000,
	0x00000424, 0x00000301, 0x00000000, 0x00000424,
	0x00000301, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00001401, 0x00001401, 0x00001401, 0x00001401,
	0x00001401, 0x00001401, 0x00000493, 0x00000493,
	0x00000493, 0x00000493, 0x00000493, 0x00000493,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00010000, 0x00000000, 0x00000000,
	0x00000000, 0x00000101, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x0c181511, 0x00000304,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00040000, 0x00800200, 0x00000000,
	0x02000400, 0x00000080, 0x00040000, 0x00800200,
	0x00000000, 0x00000000, 0x00000000, 0x00000100,
	0x01010000, 0x00000000, 0x3fff0000, 0x000fff00,
	0xffffffff, 0x00ffff00, 0x0a000000, 0x0001ffff,
	0x01010101, 0x01010101, 0x00000118, 0x00000c01,
	0x00000000, 0x00000000, 0x00000000, 0x01000000,
	0x00000100, 0x00010000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x0c000000, 0x060c0606,
	0x06060c06, 0x00010101, 0x02000000, 0x05020101,
	0x00000505, 0x02020200, 0x02020202, 0x02020202,
	0x02020202, 0x00000000, 0x00000000, 0x04000100,
	0x1e000004, 0x000030c0, 0x00000200, 0x00000200,
	0x00000200, 0x00000200, 0x0000db60, 0x0001e780,
	0x0c0d0302, 0x001e090a, 0x000030c0, 0x00000200,
	0x00000200, 0x00000200, 0x00000200, 0x0000db60,
	0x0001e780, 0x0c0d0302, 0x001e090a, 0x000030c0,
	0x00000200, 0x00000200, 0x00000200, 0x00000200,
	0x0000db60, 0x0001e780, 0x0c0d0302, 0x0000090a,
	0x00000000, 0x0302000a, 0x01000500, 0x01010001,
	0x00010001, 0x01010001, 0x02010000, 0x00000200,
	0x02000201, 0x00000000, 0x00202020
};

static uint32_t DDRSS_phyIndepReg[] = {
	0x00000a00, 0x00000000, 0x00000000, 0x01000000,
	0x00000001, 0x00010064, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00010001, 0x00000000, 0x00010001,
	0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x280d0001, 0x00000000, 0x00010000, 0x00003200,
	0x00000000, 0x00000000, 0x00060602, 0x00000000,
	0x00000000, 0x00000000, 0x00000001, 0x00000055,
	0x000000aa, 0x000000ad, 0x00000052, 0x0000006a,
	0x00000095, 0x00000095, 0x000000ad, 0x00000000,
	0x00000000, 0x00010100, 0x00000014, 0x000007d0,
	0x00000300, 0x00000000, 0x00000000, 0x01000000,
	0x00010101, 0x01000000, 0x00000000, 0x00010000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00001400, 0x00000000, 0x01000000, 0x00000404,
	0x00000001, 0x0001010e, 0x02040100, 0x00010000,
	0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000005,
	0x01000000, 0x04000100, 0x00020000, 0x00010002,
	0x00000001, 0x00020001, 0x00020002, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000300,
	0x0a090b0c, 0x04060708, 0x01000005, 0x00000800,
	0x00000000, 0x00010008, 0x00000000, 0x0000aa00,
	0x00000000, 0x00010000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00010100, 0x00000000, 0x00000000,
	0x00027100, 0x00061a80, 0x00000100, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x01000000, 0x00010003, 0x02000101, 0x01030001,
	0x00010400, 0x06000105, 0x01070001, 0x00000000,
	0x00000000, 0x00000000, 0x00010000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00010000,
	0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x00007800, 0x00780078, 0x00141414, 0x0000003a,
	0x0000003a, 0x0004003a, 0x04000400, 0xc8040009,
	0x0400091c, 0x00091cc8, 0x001cc804, 0x00000118,
	0x00001860, 0x00000118, 0x00001860, 0x00000118,
	0x04001860, 0x01010404, 0x00001901, 0x00190019,
	0x010c010c, 0x0000010c, 0x00000000, 0x05000000,
	0x01010505, 0x01010101, 0x00181818, 0x00000000,
	0x00000000, 0x0d000000, 0x0a0a0d0d, 0x0303030a,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x0d090000, 0x0d09000d, 0x0d09000d,
	0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x16000000, 0x001600c8, 0x001600c8,
	0x010100c8, 0x00001b01, 0x1f0f0053, 0x05000001,
	0x001b0a0d, 0x1f0f0053, 0x05000001, 0x001b0a0d,
	0x1f0f0053, 0x05000001, 0x00010a0d, 0x0c0b0700,
	0x000d0605, 0x0000c570, 0x0000001d, 0x180a0800,
	0x0b071c1c, 0x0d06050c, 0x0000c570, 0x0000001d,
	0x180a0800, 0x0b071c1c, 0x0d06050c, 0x0000c570,
	0x0000001d, 0x180a0800, 0x00001c1c, 0x000030c0,
	0x0001e780, 0x000030c0, 0x0001e780, 0x000030c0,
	0x0001e780, 0x04000400, 0x03030400, 0x00040003,
	0x04000400, 0x0c080c08, 0x00000c08, 0x000890b8,
	0x00000000, 0x00000000, 0x00000000, 0x00000120,
	0x000890b8, 0x00000000, 0x00000000, 0x00000000,
	0x00000120, 0x000890b8, 0x00000000, 0x00000000,
	0x00000000, 0x02000120, 0x00000080, 0x00020000,
	0x00000080, 0x00020000, 0x00000080, 0x00000000,
	0x00000000, 0x00040404, 0x00000000, 0x02010102,
	0x67676767, 0x00000202, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x0d100f00,
	0x0003020e, 0x00000001, 0x01000000, 0x00020201,
	0x00000000, 0x00000424, 0x00000301, 0x00000000,
	0x00000000, 0x00000000, 0x00001401, 0x00000493,
	0x00000000, 0x00000424, 0x00000301, 0x00000000,
	0x00000000, 0x00000000, 0x00001401, 0x00000493,
	0x00000000, 0x00000424, 0x00000301, 0x00000000,
	0x00000000, 0x00000000, 0x00001401, 0x00000493,
	0x00000000, 0x00000424, 0x00000301, 0x00000000,
	0x00000000, 0x00000000, 0x00001401, 0x00000493,
	0x00000000, 0x00000424, 0x00000301, 0x00000000,
	0x00000000, 0x00000000, 0x00001401, 0x00000493,
	0x00000000, 0x00000424, 0x00000301, 0x00000000,
	0x00000000, 0x00000000, 0x00001401, 0x00000493,
	0x00000000
};

static uint32_t DDRSS_phyReg[] = {
	0x04c00000, 0x00000000, 0x00000200, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000001, 0x00000000, 0x00000000, 0x010101ff,
	0x00010000, 0x00c00004, 0x00cc0008, 0x00660201,
	0x00000000, 0x00000000, 0x00000000, 0x0000aaaa,
	0x00005555, 0x0000b5b5, 0x00004a4a, 0x00005656,
	0x0000a9a9, 0x0000b7b7, 0x00004848, 0x00000000,
	0x00000000, 0x08000000, 0x0f000008, 0x00000f0f,
	0x00e4e400, 0x00070820, 0x000c0020, 0x00062000,
	0x00000000, 0x55555555, 0xaaaaaaaa, 0x55555555,
	0xaaaaaaaa, 0x00005555, 0x01000100, 0x00800180,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000004, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x041f07ff, 0x00000000, 0x01ccb001, 0x2000ccb0,
	0x20000140, 0x07ff0200, 0x0000dd01, 0x10100303,
	0x10101010, 0x10101010, 0x00021010, 0x00100010,
	0x00100010, 0x00100010, 0x00100010, 0x02020010,
	0x51515041, 0x31804000, 0x04bf0340, 0x01008080,
	0x04050001, 0x00000504, 0x42100010, 0x010c053e,
	0x000f0c14, 0x01000140, 0x007a0120, 0x00000c00,
	0x000001cc, 0x20100200, 0x00000005, 0x76543210,
	0x00000008, 0x02800280, 0x02800280, 0x02800280,
	0x02800280, 0x00000280, 0x00008000, 0x00800080,
	0x00800080, 0x00800080, 0x00800080, 0x00800080,
	0x00800080, 0x00800080, 0x00800080, 0x01000080,
	0x01000000, 0x00000000, 0x00000000, 0x00080200,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x04c00000, 0x00000000, 0x00000200, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000001, 0x00000000, 0x00000000, 0x010101ff,
	0x00010000, 0x00c00004, 0x00cc0008, 0x00660201,
	0x00000000, 0x00000000, 0x00000000, 0x0000aaaa,
	0x00005555, 0x0000b5b5, 0x00004a4a, 0x00005656,
	0x0000a9a9, 0x0000b7b7, 0x00004848, 0x00000000,
	0x00000000, 0x08000000, 0x0f000008, 0x00000f0f,
	0x00e4e400, 0x00070820, 0x000c0020, 0x00062000,
	0x00000000, 0x55555555, 0xaaaaaaaa, 0x55555555,
	0xaaaaaaaa, 0x00005555, 0x01000100, 0x00800180,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000004, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x041f07ff, 0x00000000, 0x01ccb001, 0x2000ccb0,
	0x20000140, 0x07ff0200, 0x0000dd01, 0x10100303,
	0x10101010, 0x10101010, 0x00021010, 0x00100010,
	0x00100010, 0x00100010, 0x00100010, 0x02020010,
	0x51515041, 0x31804000, 0x04bf0340, 0x01008080,
	0x04050001, 0x00000504, 0x42100010, 0x010c053e,
	0x000f0c14, 0x01000140, 0x007a0120, 0x00000c00,
	0x000001cc, 0x20100200, 0x00000005, 0x76543210,
	0x00000008, 0x02800280, 0x02800280, 0x02800280,
	0x02800280, 0x00000280, 0x00008000, 0x00800080,
	0x00800080, 0x00800080, 0x00800080, 0x00800080,
	0x00800080, 0x00800080, 0x00800080, 0x01000080,
	0x01000000, 0x00000000, 0x00000000, 0x00080200,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000100, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000100, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00dcba98, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a418820, 0x103f0000, 0x000f0100, 0x0000000f,
	0x020002cc, 0x00030000, 0x00000300, 0x00000300,
	0x00000300, 0x00000300, 0x00000300, 0x42080010,
	0x0000003e, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000100, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000100, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00dcba98, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x16a4a0e6, 0x103f0000, 0x000f0000, 0x0000000f,
	0x020002cc, 0x00030000, 0x00000300, 0x00000300,
	0x00000300, 0x00000300, 0x00000300, 0x42080010,
	0x0000003e, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000100, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000100, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00dcba98, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2307b9ac, 0x10030000, 0x000f0000, 0x0000000f,
	0x020002cc, 0x00030000, 0x00000300, 0x00000300,
	0x00000300, 0x00000300, 0x00000300, 0x42080010,
	0x0000003e, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000100, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00050000, 0x04000100,
	0x00000055, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x01002000, 0x00004001, 0x00020028,
	0x00010100, 0x00000001, 0x00000000, 0x0f0f0e06,
	0x00010101, 0x010f0004, 0x00000000, 0x00000000,
	0x00000064, 0x00000000, 0x00000000, 0x01020103,
	0x0f020102, 0x03030303, 0x03030303, 0x00040000,
	0x00004201, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x07070001,
	0x00005400, 0x000040a2, 0x00024410, 0x00004410,
	0x00004410, 0x00004410, 0x00004410, 0x00004410,
	0x00004410, 0x00004410, 0x00004410, 0x00004410,
	0x00000000, 0x00000046, 0x00000400, 0x00000008,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x03000000, 0x00000000, 0x00000000,
	0x00000000, 0x04102006, 0x00041020, 0x01c98c98,
	0x3f400000, 0x3f3f1f3f, 0x0000001f, 0x00000000,
	0x00000000, 0x00000000, 0x00000001, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x76543210,
	0x00000098, 0x00000000, 0x00000000, 0x00000000,
	0x00040700, 0x00000000, 0x00000000, 0x00000000,
	0x00000002, 0x00000100, 0x00000000, 0x00000fc3,
	0x00020002, 0x00000000, 0x00001142, 0x03020400,
	0x00000080, 0x03900390, 0x03900390, 0x03900390,
	0x03900390, 0x03900390, 0x03900390, 0x00000300,
	0x00000300, 0x00000300, 0x00000300, 0x31823fc7,
	0x00000000, 0x0c000d3f, 0x30000d3f, 0x300d3f11,
	0x01990000, 0x000d3fcc, 0x00000c11, 0x300d3f11,
	0x01990000, 0x300c3f11, 0x01990000, 0x300c3f11,
	0x01990000, 0x300d3f11, 0x01990000, 0x300d3f11
};

static struct reginitdata ctl_regs = {
	.regs = DDRSS_ctlReg,
	.num = DDRSS_CTL_REG_INIT_COUNT,
};

static struct reginitdata pi_regs = {
	.regs = DDRSS_phyIndepReg,
	.num = DDRSS_PHY_INDEP_REG_INIT_COUNT,
};

static struct reginitdata phy_regs = {
	.regs = DDRSS_phyReg,
	.num = DDRSS_PHY_REG_INIT_COUNT,
};

static struct k3_ddr_initdata initdata = {
	.ctl_regs = &ctl_regs,
	.pi_regs = &pi_regs,
	.phy_regs = &phy_regs,
	.freq0 = 25000000,
	.freq1 = 400000000,
	.freq2 = 400000000,
};

void beagleplay_ddr_init(void)
{
	k3_ddrss_init(&initdata);
}
