#include <linux/kernel.h>
#include <soc/k3/ddr.h>

#include "ddr.h"

/*
 * The data in this file was taken from
 * https://git.ti.com/cgit/ti-u-boot/ti-u-boot/tree/arch/arm/dts/k3-am62x-sip-ddr-lp4-50-800.dtsi?h=ti-u-boot-2024.04
 * 
 */

#define DDRSS_PLL_FHS_CNT 3
#define DDRSS_PLL_FREQUENCY_1 400000000
#define DDRSS_PLL_FREQUENCY_2 400000000
#define DDRSS_SDRAM_IDX 13
#define DDRSS_REGION_IDX 16

static uint32_t DDRSS_ctlReg[] = {
	0x00000B00,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00002710,
	0x000186A0,
	0x00000005,
	0x00000064,
	0x00027100,
	0x00186A00,
	0x00000005,
	0x00000640,
	0x00027100,
	0x00186A00,
	0x00000005,
	0x00000640,
	0x01010100,
	0x01010100,
	0x01000110,
	0x02010002,
	0x0000000A,
	0x000186A0,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00020200,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x08000010,
	0x00002020,
	0x00000000,
	0x00000000,
	0x0000040C,
	0x00000000,
	0x0000081C,
	0x00000000,
	0x0000081C,
	0x00000000,
	0x05000804,
	0x00000700,
	0x09090004,
	0x00000303,
	0x00320007,
	0x09090023,
	0x0000210F,
	0x00320007,
	0x09090023,
	0x0900210F,
	0x000A0A09,
	0x040006DB,
	0x09092004,
	0x00000C0A,
	0x06006DB0,
	0x09092006,
	0x00000C0A,
	0x06006DB0,
	0x03042006,
	0x04050002,
	0x100F100F,
	0x01010008,
	0x041F1F07,
	0x03111103,
	0x00001111,
	0x00000101,
	0x00000000,
	0x01000000,
	0x00090803,
	0x000000BB,
	0x00000090,
	0x00000C2B,
	0x00000090,
	0x00000C2B,
	0x00000005,
	0x00000005,
	0x00000010,
	0x00000048,
	0x0000017E,
	0x00000048,
	0x0000017E,
	0x03004000,
	0x00001201,
	0x00060005,
	0x00000006,
	0x00000000,
	0x05121208,
	0x05030A05,
	0x05030C06,
	0x01030C06,
	0x02010201,
	0x00000A01,
	0x0096000A,
	0x00960096,
	0x00000096,
	0x00000000,
	0x05010303,
	0x0C040505,
	0x06050203,
	0x030C0605,
	0x05060502,
	0x03030306,
	0x03010000,
	0x00010000,
	0x00000000,
	0x01000000,
	0x80104002,
	0x00040003,
	0x00040005,
	0x00030000,
	0x00050004,
	0x00000004,
	0x00040003,
	0x00040005,
	0x00000000,
	0x00002EC0,
	0x00002EC0,
	0x00002EC0,
	0x00002EC0,
	0x00002EC0,
	0x00000000,
	0x0000051D,
	0x00030AC0,
	0x00030AC0,
	0x00030AC0,
	0x00030AC0,
	0x00030AC0,
	0x00000000,
	0x0000552D,
	0x00030AC0,
	0x00030AC0,
	0x00030AC0,
	0x00030AC0,
	0x00030AC0,
	0x00000000,
	0x0000552D,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x03050000,
	0x03050305,
	0x00000000,
	0x08010000,
	0x000E0808,
	0x01000000,
	0x0E080808,
	0x00000000,
	0x08080801,
	0x0000080E,
	0x00040003,
	0x00000007,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x01000000,
	0x00000000,
	0x00001500,
	0x0000100E,
	0x00000002,
	0x00000000,
	0x00000001,
	0x00000002,
	0x00000C00,
	0x00001000,
	0x00000C00,
	0x00001000,
	0x00000C00,
	0x00001000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x0005000A,
	0x0404000D,
	0x0000000D,
	0x005000A0,
	0x060600C8,
	0x000000C8,
	0x005000A0,
	0x060600C8,
	0x000000C8,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000004,
	0x00000000,
	0x00000000,
	0x00000024,
	0x00000012,
	0x00000000,
	0x00000024,
	0x00000012,
	0x00000000,
	0x00000004,
	0x00000000,
	0x00000000,
	0x00000024,
	0x00000012,
	0x00000000,
	0x00000024,
	0x00000012,
	0x00000000,
	0x00000000,
	0x00000031,
	0x000000B1,
	0x000000B1,
	0x00000031,
	0x000000B1,
	0x000000B1,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x65006565,
	0x00002765,
	0x00000027,
	0x00000027,
	0x00000027,
	0x00000027,
	0x00000027,
	0x00000000,
	0x00000000,
	0x0000000F,
	0x0000000F,
	0x0000000F,
	0x0000000F,
	0x0000000F,
	0x0000000F,
	0x00000000,
	0x00001000,
	0x00000015,
	0x00000015,
	0x00000010,
	0x00000015,
	0x00000015,
	0x00000020,
	0x00010000,
	0x00000100,
	0x00000000,
	0x00000000,
	0x00000101,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x0C181511,
	0x00000304,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00020000,
	0x00400100,
	0x00080032,
	0x01000200,
	0x03200040,
	0x00020018,
	0x00400100,
	0x00180320,
	0x00030000,
	0x00280028,
	0x00000100,
	0x01010000,
	0x00000202,
	0x0FFF0000,
	0x000FFF00,
	0xFFFFFFFF,
	0x00FFFF00,
	0x0B000000,
	0x0001FFFF,
	0x01010101,
	0x01010101,
	0x00000118,
	0x00000C01,
	0x01000100,
	0x00000000,
	0x00000000,
	0x01030303,
	0x00000001,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x01000101,
	0x01010001,
	0x00010101,
	0x01050503,
	0x05020201,
	0x08080C0C,
	0x00080308,
	0x000B030E,
	0x000B0310,
	0x0B0B0810,
	0x01000000,
	0x03020301,
	0x04000102,
	0x1B000004,
	0x00000176,
	0x00000200,
	0x00000200,
	0x00000200,
	0x00000200,
	0x00000693,
	0x00000E9C,
	0x03050202,
	0x00250201,
	0x00001856,
	0x00000200,
	0x00000200,
	0x00000200,
	0x00000200,
	0x00006D83,
	0x0000F35C,
	0x070D0402,
	0x00250405,
	0x00001856,
	0x00000200,
	0x00000200,
	0x00000200,
	0x00000200,
	0x00006D83,
	0x0000F35C,
	0x070D0402,
	0x00000405,
	0x00000000,
	0x0302000A,
	0x01000500,
	0x01010001,
	0x00010001,
	0x01010001,
	0x02010000,
	0x00000200,
	0x02000201,
	0x10100600,
	0x00202020,
};

static uint32_t DDRSS_phyIndepReg[] = {
	0x00000B00,
	0x00000000,
	0x00000000,
	0x01000000,
	0x00000001,
	0x00010064,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000002,
	0x00000005,
	0x00010001,
	0x08000000,
	0x00010300,
	0x00000005,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00010000,
	0x280A0001,
	0x00000000,
	0x00010000,
	0x00003200,
	0x00000000,
	0x00000000,
	0x01010102,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000001,
	0x000000AA,
	0x00000055,
	0x000000B5,
	0x0000004A,
	0x00000056,
	0x000000A9,
	0x000000A9,
	0x000000B5,
	0x00000000,
	0x00000000,
	0x00010100,
	0x00000015,
	0x000007D0,
	0x00000300,
	0x00000000,
	0x00000000,
	0x01000000,
	0x00010101,
	0x01000000,
	0x03000000,
	0x00000000,
	0x00001701,
	0x00000000,
	0x00000000,
	0x00000000,
	0x0A0A140A,
	0x10020101,
	0x01000210,
	0x05000404,
	0x00010001,
	0x0001000E,
	0x01010100,
	0x00010000,
	0x00000034,
	0x00000000,
	0x00000000,
	0x0000FFFF,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x01000000,
	0x08020100,
	0x00020000,
	0x00010002,
	0x00000001,
	0x00020001,
	0x00020002,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000400,
	0x0A090B0C,
	0x04060708,
	0x01000005,
	0x00000800,
	0x00000000,
	0x00010008,
	0x00000000,
	0x0000AA00,
	0x00000000,
	0x00010000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000008,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00010000,
	0x00000000,
	0x00000000,
	0x0000000A,
	0x000186A0,
	0x00000100,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x01000000,
	0x00010003,
	0x02000101,
	0x01030001,
	0x00010400,
	0x06000105,
	0x01070001,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00010001,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00010000,
	0x00000004,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000800,
	0x00780078,
	0x00101001,
	0x00000034,
	0x00000042,
	0x00020042,
	0x02000200,
	0x00000004,
	0x0000080C,
	0x00081C00,
	0x001C0000,
	0x00000009,
	0x000000BB,
	0x00000090,
	0x00000C2B,
	0x00000090,
	0x04000C2B,
	0x01010404,
	0x00001501,
	0x001D001D,
	0x01000100,
	0x00000100,
	0x00000000,
	0x05050503,
	0x01010C0C,
	0x01010101,
	0x000C0C0A,
	0x00000000,
	0x00000000,
	0x04000000,
	0x04020808,
	0x04040204,
	0x00090031,
	0x00110039,
	0x00110039,
	0x01010101,
	0x0002000D,
	0x000200C8,
	0x010000C8,
	0x000E000E,
	0x00C90100,
	0x010000C9,
	0x00C900C9,
	0x32103200,
	0x01013210,
	0x0A070601,
	0x0D09070D,
	0x0D09070D,
	0x000C000D,
	0x00001000,
	0x00000C00,
	0x00001000,
	0x00000C00,
	0x02001000,
	0x0016000D,
	0x001600C8,
	0x000000C8,
	0x00001900,
	0x32000056,
	0x06000101,
	0x001D0204,
	0x32120058,
	0x05000101,
	0x001D0408,
	0x32120058,
	0x05000101,
	0x00000408,
	0x05030900,
	0x00040900,
	0x0000062B,
	0x20010004,
	0x0A0A0A03,
	0x11090000,
	0x1009000F,
	0x000062B8,
	0x20030023,
	0x0C0A0C0C,
	0x11090000,
	0x1009000F,
	0x000062B8,
	0x20030023,
	0x0C0A0C0C,
	0x00000000,
	0x00000176,
	0x00000E9C,
	0x00001856,
	0x0000F35C,
	0x00001856,
	0x0000F35C,
	0x0096000A,
	0x03030096,
	0x00000003,
	0x00000000,
	0x05030503,
	0x00000503,
	0x00002710,
	0x000186A0,
	0x00000005,
	0x00000064,
	0x0000000A,
	0x00027100,
	0x000186A0,
	0x00000005,
	0x00000640,
	0x00000096,
	0x00027100,
	0x000186A0,
	0x00000005,
	0x00000640,
	0x01000096,
	0x00320040,
	0x00010008,
	0x03200040,
	0x00010018,
	0x03200040,
	0x00000318,
	0x00280028,
	0x03040404,
	0x00000303,
	0x02020101,
	0x67676767,
	0x00000000,
	0x55000000,
	0x00000000,
	0x3C00005A,
	0x00005500,
	0x00005A00,
	0x0D100F3C,
	0x0003020E,
	0x00000001,
	0x01000000,
	0x00020201,
	0x00000000,
	0x00000000,
	0x00000004,
	0x00000000,
	0x00000031,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00100F27,
	0x00000000,
	0x00000024,
	0x00000012,
	0x000000B1,
	0x00000000,
	0x00000000,
	0x65000000,
	0x00150F27,
	0x00000000,
	0x00000024,
	0x00000012,
	0x000000B1,
	0x00000000,
	0x00000000,
	0x65000000,
	0x00150F27,
	0x00000000,
	0x00000004,
	0x00000000,
	0x00000031,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00100F27,
	0x00000000,
	0x00000024,
	0x00000012,
	0x000000B1,
	0x00000000,
	0x00000000,
	0x65000000,
	0x00150F27,
	0x00000000,
	0x00000024,
	0x00000012,
	0x000000B1,
	0x00000000,
	0x00000000,
	0x65000000,
	0x00150F27,
};

static uint32_t DDRSS_phyReg[] = {
	0x04F00000,
	0x00000000,
	0x00030200,
	0x00000000,
	0x00000000,
	0x01000000,
	0x03000400,
	0x00000001,
	0x00000001,
	0x00000000,
	0x00000000,
	0x01010000,
	0x00010000,
	0x00C00001,
	0x00CC0008,
	0x00660601,
	0x00000003,
	0x00000000,
	0x00000000,
	0x0000AAAA,
	0x00005555,
	0x0000B5B5,
	0x00004A4A,
	0x00005656,
	0x0000A9A9,
	0x0000B7B7,
	0x00004848,
	0x00000000,
	0x00000000,
	0x08000000,
	0x0F000008,
	0x00000F0F,
	0x00E4E400,
	0x00071020,
	0x000C0020,
	0x00062000,
	0x00000000,
	0x55555555,
	0xAAAAAAAA,
	0x55555555,
	0xAAAAAAAA,
	0x00005555,
	0x01000100,
	0x00800180,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000004,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x041F07FF,
	0x00000000,
	0x01CC0B01,
	0x1003CC0B,
	0x20000140,
	0x07FF0200,
	0x0000DD01,
	0x00100303,
	0x00000000,
	0x00000000,
	0x00021000,
	0x00100010,
	0x00100010,
	0x00100010,
	0x00100010,
	0x02020010,
	0x51516041,
	0x31C06000,
	0x07AB0340,
	0x0000C0C0,
	0x04050000,
	0x00000504,
	0x42100010,
	0x010C053E,
	0x000F0C1D,
	0x01000140,
	0x007A0120,
	0x00000C00,
	0x000001CC,
	0x20100200,
	0x00000005,
	0x56743210,
	0x00000008,
	0x034C034C,
	0x034C034C,
	0x034C034C,
	0x034C034C,
	0x0000034C,
	0x00008000,
	0x00800080,
	0x00800080,
	0x00800080,
	0x00800080,
	0x00800080,
	0x00800080,
	0x00800080,
	0x00800080,
	0x01800080,
	0x01000000,
	0x00000000,
	0x00000000,
	0x00080200,
	0x00000000,
	0x0000F0F0,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x04F00000,
	0x00000000,
	0x00030200,
	0x00000000,
	0x00000000,
	0x01000000,
	0x03000400,
	0x00000001,
	0x00000001,
	0x00000000,
	0x00000000,
	0x01010000,
	0x00010000,
	0x00C00001,
	0x00CC0008,
	0x00660601,
	0x00000003,
	0x00000000,
	0x00000000,
	0x0000AAAA,
	0x00005555,
	0x0000B5B5,
	0x00004A4A,
	0x00005656,
	0x0000A9A9,
	0x0000B7B7,
	0x00004848,
	0x00000000,
	0x00000000,
	0x08000000,
	0x0F000008,
	0x00000F0F,
	0x00E4E400,
	0x00071020,
	0x000C0020,
	0x00062000,
	0x00000000,
	0x55555555,
	0xAAAAAAAA,
	0x55555555,
	0xAAAAAAAA,
	0x00005555,
	0x01000100,
	0x00800180,
	0x00000001,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000004,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x041F07FF,
	0x00000000,
	0x01CC0B01,
	0x1003CC0B,
	0x20000140,
	0x07FF0200,
	0x0000DD01,
	0x00100303,
	0x00000000,
	0x00000000,
	0x00021000,
	0x00100010,
	0x00100010,
	0x00100010,
	0x00100010,
	0x02020010,
	0x51516041,
	0x31C06000,
	0x07AB0340,
	0x0000C0C0,
	0x04050000,
	0x00000504,
	0x42100010,
	0x010C053E,
	0x000F0C1D,
	0x01000140,
	0x007A0120,
	0x00000C00,
	0x000001CC,
	0x20100200,
	0x00000005,
	0x01324567,
	0x00000008,
	0x034C034C,
	0x034C034C,
	0x034C034C,
	0x034C034C,
	0x0000034C,
	0x00008000,
	0x00800080,
	0x00800080,
	0x00800080,
	0x00800080,
	0x00800080,
	0x00800080,
	0x00800080,
	0x00800080,
	0x01800080,
	0x01000000,
	0x00000000,
	0x00000000,
	0x00080200,
	0x00000000,
	0x0000F0F0,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000100,
	0x00000200,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00400000,
	0x00000080,
	0x00DCBA98,
	0x03000000,
	0x00200000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x0000002A,
	0x00000015,
	0x00000015,
	0x0000002A,
	0x00000033,
	0x0000000C,
	0x0000000C,
	0x00000033,
	0x0A418820,
	0x003F0000,
	0x000F013F,
	0x0000000F,
	0x020002CC,
	0x00030000,
	0x00000300,
	0x00000300,
	0x00000300,
	0x00000300,
	0x00000300,
	0x42080010,
	0x0000803E,
	0x00000003,
	0x00000002,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000100,
	0x00000200,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00400000,
	0x00000080,
	0x00DCBA98,
	0x03000000,
	0x00200000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x0000002A,
	0x00000015,
	0x00000015,
	0x0000002A,
	0x00000033,
	0x0000000C,
	0x0000000C,
	0x00000033,
	0x00000000,
	0x00000000,
	0x000F0000,
	0x0000000F,
	0x020002CC,
	0x00030000,
	0x00000300,
	0x00000300,
	0x00000300,
	0x00000300,
	0x00000300,
	0x42080010,
	0x0000803E,
	0x00000003,
	0x00000002,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000100,
	0x00000200,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00400000,
	0x00000080,
	0x00DCBA98,
	0x03000000,
	0x00200000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x0000002A,
	0x00000015,
	0x00000015,
	0x0000002A,
	0x00000033,
	0x0000000C,
	0x0000000C,
	0x00000033,
	0x2307B9AC,
	0x10000000,
	0x000F0000,
	0x0000000F,
	0x020002CC,
	0x00030000,
	0x00000300,
	0x00000300,
	0x00000300,
	0x00000300,
	0x00000300,
	0x42080010,
	0x0000803E,
	0x00000003,
	0x00000002,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00010100,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00050000,
	0x04000000,
	0x00000055,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00002001,
	0x00004001,
	0x00020028,
	0x01010100,
	0x00000000,
	0x00000000,
	0x0F0F0E06,
	0x00010101,
	0x010F0004,
	0x00000000,
	0x00000000,
	0x00000064,
	0x00000000,
	0x00000000,
	0x01020103,
	0x0F020102,
	0x03030303,
	0x03030303,
	0x00041B42,
	0x00005201,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x07030101,
	0x00005400,
	0x000040A2,
	0x00024410,
	0x00004410,
	0x00004410,
	0x00004410,
	0x00004410,
	0x00004410,
	0x00004410,
	0x00004410,
	0x00004410,
	0x00004410,
	0x00000000,
	0x00000076,
	0x00000400,
	0x00000008,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x03000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x04102006,
	0x00041020,
	0x01C98C98,
	0x3F400000,
	0x3F3F1F3F,
	0x0000001F,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000001,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x76543201,
	0x00040198,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00040700,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000002,
	0x00000000,
	0x00000000,
	0x0001F7C2,
	0x00020002,
	0x00000000,
	0x00001142,
	0x03020000,
	0x00000080,
	0x03900390,
	0x03900390,
	0x03900390,
	0x03900390,
	0x03000300,
	0x03000300,
	0x00000300,
	0x00000300,
	0x00000300,
	0x00000300,
	0x3183BF77,
	0x00000000,
	0x0C000DFF,
	0x30000DFF,
	0x3F0DFF11,
	0x01990000,
	0x780DFFCC,
	0x00000C11,
	0x00018011,
	0x0089FF00,
	0x000C3F11,
	0x01990000,
	0x000C3F91,
	0x01990000,
	0x3F0DFF11,
	0x01990000,
	0x00018011,
	0x0089FF00,
	0x20040004,
};

static struct reginitdata ctl_regs = {
	.regs = DDRSS_ctlReg,
	.num = ARRAY_SIZE(DDRSS_ctlReg),
};

static struct reginitdata pi_regs = {
	.regs = DDRSS_phyIndepReg,
	.num = ARRAY_SIZE(DDRSS_phyIndepReg),
};

static struct reginitdata phy_regs = {
	.regs = DDRSS_phyReg,
	.num = ARRAY_SIZE(DDRSS_phyReg),
};

static struct k3_ddr_initdata initdata = {
	.ctl_regs = &ctl_regs,
	.pi_regs = &pi_regs,
	.phy_regs = &phy_regs,
	.freq0 = 25000000,
	.freq1 = DDRSS_PLL_FREQUENCY_1,
	.freq2 = DDRSS_PLL_FREQUENCY_2,
	.fhs_cnt = DDRSS_PLL_FHS_CNT,
};

void am625sip_sk_ddr_init(void)
{
	k3_ddrss_init(&initdata);
}
